/******************************************************************************
 *
 * Copyright(c) 2007 - 2017  Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/

/*Image2HeaderVersion: R2 1.2.1*/
#include "mp_precomp.h"
#include "../phydm_precomp.h"

#if (RTL8822B_SUPPORT == 1)
static boolean check_positive(struct PHY_DM_STRUCT *p_dm_odm,
			      const u32 condition1, const u32 condition2,
			      const u32 condition3, const u32 condition4)
{
	u32 cond1 = condition1, cond2 = condition2, cond3 = condition3,
	    cond4 = condition4;

	u8 cut_version_for_para = (p_dm_odm->cut_version == ODM_CUT_A) ?
					  15 :
					  p_dm_odm->cut_version;
	u8 pkg_type_for_para =
		(p_dm_odm->package_type == 0) ? 15 : p_dm_odm->package_type;

	u32 driver1 =
		cut_version_for_para << 24 |
		(p_dm_odm->support_interface & 0xF0) << 16 |
		p_dm_odm->support_platform << 16 | pkg_type_for_para << 12 |
		(p_dm_odm->support_interface & 0x0F) << 8 | p_dm_odm->rfe_type;

	u32 driver2 = (p_dm_odm->type_glna & 0xFF) << 0 |
		      (p_dm_odm->type_gpa & 0xFF) << 8 |
		      (p_dm_odm->type_alna & 0xFF) << 16 |
		      (p_dm_odm->type_apa & 0xFF) << 24;

	u32 driver3 = 0;

	u32 driver4 = (p_dm_odm->type_glna & 0xFF00) >> 8 |
		      (p_dm_odm->type_gpa & 0xFF00) |
		      (p_dm_odm->type_alna & 0xFF00) << 8 |
		      (p_dm_odm->type_apa & 0xFF00) << 16;

	ODM_RT_TRACE(
		p_dm_odm, ODM_COMP_INIT, ODM_DBG_TRACE,
		("===> check_positive (cond1, cond2, cond3, cond4) = (0x%X 0x%X 0x%X 0x%X)\n",
		 cond1, cond2, cond3, cond4));
	ODM_RT_TRACE(
		p_dm_odm, ODM_COMP_INIT, ODM_DBG_TRACE,
		("===> check_positive (driver1, driver2, driver3, driver4) = (0x%X 0x%X 0x%X 0x%X)\n",
		 driver1, driver2, driver3, driver4));

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_TRACE,
		     ("	(Platform, Interface) = (0x%X, 0x%X)\n",
		      p_dm_odm->support_platform, p_dm_odm->support_interface));
	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_TRACE,
		     ("	(RFE, Package) = (0x%X, 0x%X)\n",
		      p_dm_odm->rfe_type, p_dm_odm->package_type));

	/*============== value Defined Check ===============*/
	/*cut version [27:24] need to do value check*/

	if (((cond1 & 0x0F000000) != 0) &&
	    ((cond1 & 0x0F000000) != (driver1 & 0x0F000000)))
		return false;

	/*pkg type [15:12] need to do value check*/

	if (((cond1 & 0x0000F000) != 0) &&
	    ((cond1 & 0x0000F000) != (driver1 & 0x0000F000)))
		return false;

	/*=============== Bit Defined Check ================*/
	/* We don't care [31:28] */

	cond1 &= 0x000000FF;
	driver1 &= 0x000000FF;

	if (cond1 == driver1)
		return true;
	else
		return false;
}

/******************************************************************************
*                           agc_tab.TXT
******************************************************************************/

u32 array_mp_8822b_agc_tab[] = {
	0x80000000,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c,
	0xFF000003,  BBREG_0x81c, 0xFE000003,  BBREG_0x81c, 0xFD020003,
	BBREG_0x81c, 0xFC040003,  BBREG_0x81c, 0xFB060003,  BBREG_0x81c,
	0xFA080003,  BBREG_0x81c, 0xF90A0003,  BBREG_0x81c, 0xF80C0003,
	BBREG_0x81c, 0xF70E0003,  BBREG_0x81c, 0xF6100003,  BBREG_0x81c,
	0xF5120003,  BBREG_0x81c, 0xF4140003,  BBREG_0x81c, 0xF3160003,
	BBREG_0x81c, 0xF2180003,  BBREG_0x81c, 0xF11A0003,  BBREG_0x81c,
	0xF01C0003,  BBREG_0x81c, 0xEF1E0003,  BBREG_0x81c, 0xEE200003,
	BBREG_0x81c, 0xED220003,  BBREG_0x81c, 0xEC240003,  BBREG_0x81c,
	0xEB260003,  BBREG_0x81c, 0xEA280003,  BBREG_0x81c, 0xE92A0003,
	BBREG_0x81c, 0xE82C0003,  BBREG_0x81c, 0xE72E0003,  BBREG_0x81c,
	0xE6300003,  BBREG_0x81c, 0xE5320003,  BBREG_0x81c, 0xC8340003,
	BBREG_0x81c, 0xC7360003,  BBREG_0x81c, 0xC6380003,  BBREG_0x81c,
	0xC53A0003,  BBREG_0x81c, 0xC43C0003,  BBREG_0x81c, 0xC33E0003,
	BBREG_0x81c, 0xC2400003,  BBREG_0x81c, 0xC1420003,  BBREG_0x81c,
	0xC0440003,  BBREG_0x81c, 0xA3460003,  BBREG_0x81c, 0xA2480003,
	BBREG_0x81c, 0xA14A0003,  BBREG_0x81c, 0xA04C0003,  BBREG_0x81c,
	0x824E0003,  BBREG_0x81c, 0x81500003,  BBREG_0x81c, 0x80520003,
	BBREG_0x81c, 0x64540003,  BBREG_0x81c, 0x63560003,  BBREG_0x81c,
	0x62580003,  BBREG_0x81c, 0x445A0003,  BBREG_0x81c, 0x435C0003,
	BBREG_0x81c, 0x425E0003,  BBREG_0x81c, 0x41600003,  BBREG_0x81c,
	0x40620003,  BBREG_0x81c, 0x05640003,  BBREG_0x81c, 0x04660003,
	BBREG_0x81c, 0x03680003,  BBREG_0x81c, 0x026A0003,  BBREG_0x81c,
	0x016C0003,  BBREG_0x81c, 0x006E0003,  BBREG_0x81c, 0x00700003,
	BBREG_0x81c, 0x00720003,  BBREG_0x81c, 0x00740003,  BBREG_0x81c,
	0x00760003,  BBREG_0x81c, 0x00780003,  BBREG_0x81c, 0x007A0003,
	BBREG_0x81c, 0x007C0003,  BBREG_0x81c, 0x007E0003,  0x90000001,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c, 0xFF000003,
	BBREG_0x81c, 0xF5000003,  BBREG_0x81c, 0xF4020003,  BBREG_0x81c,
	0xF3040003,  BBREG_0x81c, 0xF2060003,  BBREG_0x81c, 0xF1080003,
	BBREG_0x81c, 0xF00A0003,  BBREG_0x81c, 0xEF0C0003,  BBREG_0x81c,
	0xEE0E0003,  BBREG_0x81c, 0xED100003,  BBREG_0x81c, 0xEC120003,
	BBREG_0x81c, 0xEB140003,  BBREG_0x81c, 0xEA160003,  BBREG_0x81c,
	0xE9180003,  BBREG_0x81c, 0xE81A0003,  BBREG_0x81c, 0xE71C0003,
	BBREG_0x81c, 0xE61E0003,  BBREG_0x81c, 0xE5200003,  BBREG_0x81c,
	0xE4220003,  BBREG_0x81c, 0xE3240003,  BBREG_0x81c, 0xE2260003,
	BBREG_0x81c, 0xE1280003,  BBREG_0x81c, 0xE02A0003,  BBREG_0x81c,
	0xC32C0003,  BBREG_0x81c, 0xC22E0003,  BBREG_0x81c, 0xC1300003,
	BBREG_0x81c, 0xC0320003,  BBREG_0x81c, 0xA4340003,  BBREG_0x81c,
	0xA3360003,  BBREG_0x81c, 0xA2380003,  BBREG_0x81c, 0xA13A0003,
	BBREG_0x81c, 0xA03C0003,  BBREG_0x81c, 0x823E0003,  BBREG_0x81c,
	0x81400003,  BBREG_0x81c, 0x80420003,  BBREG_0x81c, 0x64440003,
	BBREG_0x81c, 0x63460003,  BBREG_0x81c, 0x62480003,  BBREG_0x81c,
	0x614A0003,  BBREG_0x81c, 0x604C0003,  BBREG_0x81c, 0x454E0003,
	BBREG_0x81c, 0x44500003,  BBREG_0x81c, 0x43520003,  BBREG_0x81c,
	0x42540003,  BBREG_0x81c, 0x41560003,  BBREG_0x81c, 0x40580003,
	BBREG_0x81c, 0x055A0003,  BBREG_0x81c, 0x045C0003,  BBREG_0x81c,
	0x035E0003,  BBREG_0x81c, 0x02600003,  BBREG_0x81c, 0x01620003,
	BBREG_0x81c, 0x00640003,  BBREG_0x81c, 0x00660003,  BBREG_0x81c,
	0x00680003,  BBREG_0x81c, 0x006A0003,  BBREG_0x81c, 0x006C0003,
	BBREG_0x81c, 0x006E0003,  BBREG_0x81c, 0x00700003,  BBREG_0x81c,
	0x00720003,  BBREG_0x81c, 0x00740003,  BBREG_0x81c, 0x00760003,
	BBREG_0x81c, 0x00780003,  BBREG_0x81c, 0x007A0003,  BBREG_0x81c,
	0x007C0003,  BBREG_0x81c, 0x007E0003,  0x90000002,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x81c, 0xFF000003,  BBREG_0x81c,
	0xFD000003,  BBREG_0x81c, 0xFC020003,  BBREG_0x81c, 0xFB040003,
	BBREG_0x81c, 0xFA060003,  BBREG_0x81c, 0xF9080003,  BBREG_0x81c,
	0xF80A0003,  BBREG_0x81c, 0xF70C0003,  BBREG_0x81c, 0xF60E0003,
	BBREG_0x81c, 0xF5100003,  BBREG_0x81c, 0xF4120003,  BBREG_0x81c,
	0xF3140003,  BBREG_0x81c, 0xF2160003,  BBREG_0x81c, 0xF1180003,
	BBREG_0x81c, 0xF01A0003,  BBREG_0x81c, 0xEF1C0003,  BBREG_0x81c,
	0xEE1E0003,  BBREG_0x81c, 0xED200003,  BBREG_0x81c, 0xEC220003,
	BBREG_0x81c, 0xEB240003,  BBREG_0x81c, 0xEA260003,  BBREG_0x81c,
	0xE9280003,  BBREG_0x81c, 0xE82A0003,  BBREG_0x81c, 0xE72C0003,
	BBREG_0x81c, 0xE62E0003,  BBREG_0x81c, 0xE5300003,  BBREG_0x81c,
	0xC8320003,  BBREG_0x81c, 0xC7340003,  BBREG_0x81c, 0xC6360003,
	BBREG_0x81c, 0xC5380003,  BBREG_0x81c, 0xC43A0003,  BBREG_0x81c,
	0xC33C0003,  BBREG_0x81c, 0xC23E0003,  BBREG_0x81c, 0xC1400003,
	BBREG_0x81c, 0xC0420003,  BBREG_0x81c, 0xA5440003,  BBREG_0x81c,
	0xA4460003,  BBREG_0x81c, 0xA3480003,  BBREG_0x81c, 0xA24A0003,
	BBREG_0x81c, 0xA14C0003,  BBREG_0x81c, 0x834E0003,  BBREG_0x81c,
	0x82500003,  BBREG_0x81c, 0x81520003,  BBREG_0x81c, 0x80540003,
	BBREG_0x81c, 0x65560003,  BBREG_0x81c, 0x64580003,  BBREG_0x81c,
	0x635A0003,  BBREG_0x81c, 0x625C0003,  BBREG_0x81c, 0x435E0003,
	BBREG_0x81c, 0x42600003,  BBREG_0x81c, 0x41620003,  BBREG_0x81c,
	0x40640003,  BBREG_0x81c, 0x06660003,  BBREG_0x81c, 0x05680003,
	BBREG_0x81c, 0x046A0003,  BBREG_0x81c, 0x036C0003,  BBREG_0x81c,
	0x026E0003,  BBREG_0x81c, 0x01700003,  BBREG_0x81c, 0x00720003,
	BBREG_0x81c, 0x00740003,  BBREG_0x81c, 0x00760003,  BBREG_0x81c,
	0x00780003,  BBREG_0x81c, 0x007A0003,  BBREG_0x81c, 0x007C0003,
	BBREG_0x81c, 0x007E0003,  0x90000003,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x81c, 0xFF000003,  BBREG_0x81c, 0xFD000003,
	BBREG_0x81c, 0xFC020003,  BBREG_0x81c, 0xFB040003,  BBREG_0x81c,
	0xFA060003,  BBREG_0x81c, 0xF9080003,  BBREG_0x81c, 0xF80A0003,
	BBREG_0x81c, 0xF70C0003,  BBREG_0x81c, 0xF60E0003,  BBREG_0x81c,
	0xF5100003,  BBREG_0x81c, 0xF4120003,  BBREG_0x81c, 0xF3140003,
	BBREG_0x81c, 0xF2160003,  BBREG_0x81c, 0xF1180003,  BBREG_0x81c,
	0xF01A0003,  BBREG_0x81c, 0xEF1C0003,  BBREG_0x81c, 0xEE1E0003,
	BBREG_0x81c, 0xED200003,  BBREG_0x81c, 0xEC220003,  BBREG_0x81c,
	0xEB240003,  BBREG_0x81c, 0xEA260003,  BBREG_0x81c, 0xE9280003,
	BBREG_0x81c, 0xE82A0003,  BBREG_0x81c, 0xE72C0003,  BBREG_0x81c,
	0xE62E0003,  BBREG_0x81c, 0xE5300003,  BBREG_0x81c, 0xC8320003,
	BBREG_0x81c, 0xC7340003,  BBREG_0x81c, 0xC6360003,  BBREG_0x81c,
	0xC5380003,  BBREG_0x81c, 0xC43A0003,  BBREG_0x81c, 0xC33C0003,
	BBREG_0x81c, 0xC23E0003,  BBREG_0x81c, 0xC1400003,  BBREG_0x81c,
	0xC0420003,  BBREG_0x81c, 0xA5440003,  BBREG_0x81c, 0xA4460003,
	BBREG_0x81c, 0xA3480003,  BBREG_0x81c, 0xA24A0003,  BBREG_0x81c,
	0xA14C0003,  BBREG_0x81c, 0x834E0003,  BBREG_0x81c, 0x82500003,
	BBREG_0x81c, 0x81520003,  BBREG_0x81c, 0x80540003,  BBREG_0x81c,
	0x65560003,  BBREG_0x81c, 0x64580003,  BBREG_0x81c, 0x635A0003,
	BBREG_0x81c, 0x625C0003,  BBREG_0x81c, 0x435E0003,  BBREG_0x81c,
	0x42600003,  BBREG_0x81c, 0x41620003,  BBREG_0x81c, 0x40640003,
	BBREG_0x81c, 0x06660003,  BBREG_0x81c, 0x05680003,  BBREG_0x81c,
	0x046A0003,  BBREG_0x81c, 0x036C0003,  BBREG_0x81c, 0x026E0003,
	BBREG_0x81c, 0x01700003,  BBREG_0x81c, 0x00720003,  BBREG_0x81c,
	0x00740003,  BBREG_0x81c, 0x00760003,  BBREG_0x81c, 0x00780003,
	BBREG_0x81c, 0x007A0003,  BBREG_0x81c, 0x007C0003,  BBREG_0x81c,
	0x007E0003,  0x90000004,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x81c, 0xFF000003,  BBREG_0x81c, 0xDC000003,  BBREG_0x81c,
	0xDB020003,  BBREG_0x81c, 0xDA040003,  BBREG_0x81c, 0xD9060003,
	BBREG_0x81c, 0xD8080003,  BBREG_0x81c, 0xD70A0003,  BBREG_0x81c,
	0xD60C0003,  BBREG_0x81c, 0xD50E0003,  BBREG_0x81c, 0xD4100003,
	BBREG_0x81c, 0xD3120003,  BBREG_0x81c, 0xD2140003,  BBREG_0x81c,
	0xD1160003,  BBREG_0x81c, 0xD0180003,  BBREG_0x81c, 0xB41A0003,
	BBREG_0x81c, 0xB31C0003,  BBREG_0x81c, 0xB21E0003,  BBREG_0x81c,
	0xB1200003,  BBREG_0x81c, 0xB0220003,  BBREG_0x81c, 0xAF240003,
	BBREG_0x81c, 0xAE260003,  BBREG_0x81c, 0xAD280003,  BBREG_0x81c,
	0xAC2A0003,  BBREG_0x81c, 0xAB2C0003,  BBREG_0x81c, 0x8C2E0003,
	BBREG_0x81c, 0x8B300003,  BBREG_0x81c, 0x8A320003,  BBREG_0x81c,
	0x89340003,  BBREG_0x81c, 0x88360003,  BBREG_0x81c, 0x87380003,
	BBREG_0x81c, 0x863A0003,  BBREG_0x81c, 0x853C0003,  BBREG_0x81c,
	0x693E0003,  BBREG_0x81c, 0x68400003,  BBREG_0x81c, 0x67420003,
	BBREG_0x81c, 0x66440003,  BBREG_0x81c, 0x65460003,  BBREG_0x81c,
	0x48480003,  BBREG_0x81c, 0x474A0003,  BBREG_0x81c, 0x464C0003,
	BBREG_0x81c, 0x454E0003,  BBREG_0x81c, 0x44500003,  BBREG_0x81c,
	0x43520003,  BBREG_0x81c, 0x27540003,  BBREG_0x81c, 0x26560003,
	BBREG_0x81c, 0x25580003,  BBREG_0x81c, 0x245A0003,  BBREG_0x81c,
	0x235C0003,  BBREG_0x81c, 0x045E0003,  BBREG_0x81c, 0x03600003,
	BBREG_0x81c, 0x02620003,  BBREG_0x81c, 0x01640003,  BBREG_0x81c,
	0x00660003,  BBREG_0x81c, 0x00680003,  BBREG_0x81c, 0x006A0003,
	BBREG_0x81c, 0x006C0003,  BBREG_0x81c, 0x006E0003,  BBREG_0x81c,
	0x00700003,  BBREG_0x81c, 0x00720003,  BBREG_0x81c, 0x00740003,
	BBREG_0x81c, 0x00760003,  BBREG_0x81c, 0x00780003,  BBREG_0x81c,
	0x007A0003,  BBREG_0x81c, 0x007C0003,  BBREG_0x81c, 0x007E0003,
	0x90000005,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c,
	0xFF000003,  BBREG_0x81c, 0xFD000003,  BBREG_0x81c, 0xFC020003,
	BBREG_0x81c, 0xFB040003,  BBREG_0x81c, 0xFA060003,  BBREG_0x81c,
	0xF9080003,  BBREG_0x81c, 0xF80A0003,  BBREG_0x81c, 0xF70C0003,
	BBREG_0x81c, 0xF60E0003,  BBREG_0x81c, 0xF5100003,  BBREG_0x81c,
	0xF4120003,  BBREG_0x81c, 0xF3140003,  BBREG_0x81c, 0xF2160003,
	BBREG_0x81c, 0xF1180003,  BBREG_0x81c, 0xF01A0003,  BBREG_0x81c,
	0xEF1C0003,  BBREG_0x81c, 0xEE1E0003,  BBREG_0x81c, 0xED200003,
	BBREG_0x81c, 0xEC220003,  BBREG_0x81c, 0xEB240003,  BBREG_0x81c,
	0xEA260003,  BBREG_0x81c, 0xE9280003,  BBREG_0x81c, 0xE82A0003,
	BBREG_0x81c, 0xE72C0003,  BBREG_0x81c, 0xE62E0003,  BBREG_0x81c,
	0xE5300003,  BBREG_0x81c, 0xC8320003,  BBREG_0x81c, 0xC7340003,
	BBREG_0x81c, 0xC6360003,  BBREG_0x81c, 0xC5380003,  BBREG_0x81c,
	0xC43A0003,  BBREG_0x81c, 0xC33C0003,  BBREG_0x81c, 0xC23E0003,
	BBREG_0x81c, 0xC1400003,  BBREG_0x81c, 0xC0420003,  BBREG_0x81c,
	0xA5440003,  BBREG_0x81c, 0xA4460003,  BBREG_0x81c, 0xA3480003,
	BBREG_0x81c, 0xA24A0003,  BBREG_0x81c, 0xA14C0003,  BBREG_0x81c,
	0x834E0003,  BBREG_0x81c, 0x82500003,  BBREG_0x81c, 0x81520003,
	BBREG_0x81c, 0x80540003,  BBREG_0x81c, 0x65560003,  BBREG_0x81c,
	0x64580003,  BBREG_0x81c, 0x635A0003,  BBREG_0x81c, 0x625C0003,
	BBREG_0x81c, 0x435E0003,  BBREG_0x81c, 0x42600003,  BBREG_0x81c,
	0x41620003,  BBREG_0x81c, 0x40640003,  BBREG_0x81c, 0x06660003,
	BBREG_0x81c, 0x05680003,  BBREG_0x81c, 0x046A0003,  BBREG_0x81c,
	0x036C0003,  BBREG_0x81c, 0x026E0003,  BBREG_0x81c, 0x01700003,
	BBREG_0x81c, 0x00720003,  BBREG_0x81c, 0x00740003,  BBREG_0x81c,
	0x00760003,  BBREG_0x81c, 0x00780003,  BBREG_0x81c, 0x007A0003,
	BBREG_0x81c, 0x007C0003,  BBREG_0x81c, 0x007E0003,  0x90000006,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c, 0xFF000003,
	BBREG_0x81c, 0xF5000003,  BBREG_0x81c, 0xF4020003,  BBREG_0x81c,
	0xF3040003,  BBREG_0x81c, 0xF2060003,  BBREG_0x81c, 0xF1080003,
	BBREG_0x81c, 0xF00A0003,  BBREG_0x81c, 0xEF0C0003,  BBREG_0x81c,
	0xEE0E0003,  BBREG_0x81c, 0xED100003,  BBREG_0x81c, 0xEC120003,
	BBREG_0x81c, 0xEB140003,  BBREG_0x81c, 0xEA160003,  BBREG_0x81c,
	0xE9180003,  BBREG_0x81c, 0xE81A0003,  BBREG_0x81c, 0xE71C0003,
	BBREG_0x81c, 0xE61E0003,  BBREG_0x81c, 0xE5200003,  BBREG_0x81c,
	0xE4220003,  BBREG_0x81c, 0xE3240003,  BBREG_0x81c, 0xE2260003,
	BBREG_0x81c, 0xE1280003,  BBREG_0x81c, 0xE02A0003,  BBREG_0x81c,
	0xC32C0003,  BBREG_0x81c, 0xC22E0003,  BBREG_0x81c, 0xC1300003,
	BBREG_0x81c, 0xC0320003,  BBREG_0x81c, 0xA4340003,  BBREG_0x81c,
	0xA3360003,  BBREG_0x81c, 0xA2380003,  BBREG_0x81c, 0xA13A0003,
	BBREG_0x81c, 0xA03C0003,  BBREG_0x81c, 0x823E0003,  BBREG_0x81c,
	0x81400003,  BBREG_0x81c, 0x80420003,  BBREG_0x81c, 0x64440003,
	BBREG_0x81c, 0x63460003,  BBREG_0x81c, 0x62480003,  BBREG_0x81c,
	0x614A0003,  BBREG_0x81c, 0x604C0003,  BBREG_0x81c, 0x454E0003,
	BBREG_0x81c, 0x44500003,  BBREG_0x81c, 0x43520003,  BBREG_0x81c,
	0x42540003,  BBREG_0x81c, 0x41560003,  BBREG_0x81c, 0x40580003,
	BBREG_0x81c, 0x055A0003,  BBREG_0x81c, 0x045C0003,  BBREG_0x81c,
	0x035E0003,  BBREG_0x81c, 0x02600003,  BBREG_0x81c, 0x01620003,
	BBREG_0x81c, 0x00640003,  BBREG_0x81c, 0x00660003,  BBREG_0x81c,
	0x00680003,  BBREG_0x81c, 0x006A0003,  BBREG_0x81c, 0x006C0003,
	BBREG_0x81c, 0x006E0003,  BBREG_0x81c, 0x00700003,  BBREG_0x81c,
	0x00720003,  BBREG_0x81c, 0x00740003,  BBREG_0x81c, 0x00760003,
	BBREG_0x81c, 0x00780003,  BBREG_0x81c, 0x007A0003,  BBREG_0x81c,
	0x007C0003,  BBREG_0x81c, 0x007E0003,  0x90000007,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x81c, 0xFF000003,  BBREG_0x81c,
	0xF5000003,  BBREG_0x81c, 0xF4020003,  BBREG_0x81c, 0xF3040003,
	BBREG_0x81c, 0xF2060003,  BBREG_0x81c, 0xF1080003,  BBREG_0x81c,
	0xF00A0003,  BBREG_0x81c, 0xEF0C0003,  BBREG_0x81c, 0xEE0E0003,
	BBREG_0x81c, 0xED100003,  BBREG_0x81c, 0xEC120003,  BBREG_0x81c,
	0xEB140003,  BBREG_0x81c, 0xEA160003,  BBREG_0x81c, 0xE9180003,
	BBREG_0x81c, 0xE81A0003,  BBREG_0x81c, 0xE71C0003,  BBREG_0x81c,
	0xE61E0003,  BBREG_0x81c, 0xE5200003,  BBREG_0x81c, 0xE4220003,
	BBREG_0x81c, 0xE3240003,  BBREG_0x81c, 0xE2260003,  BBREG_0x81c,
	0xE1280003,  BBREG_0x81c, 0xE02A0003,  BBREG_0x81c, 0xC32C0003,
	BBREG_0x81c, 0xC22E0003,  BBREG_0x81c, 0xC1300003,  BBREG_0x81c,
	0xC0320003,  BBREG_0x81c, 0xA4340003,  BBREG_0x81c, 0xA3360003,
	BBREG_0x81c, 0xA2380003,  BBREG_0x81c, 0xA13A0003,  BBREG_0x81c,
	0xA03C0003,  BBREG_0x81c, 0x823E0003,  BBREG_0x81c, 0x81400003,
	BBREG_0x81c, 0x80420003,  BBREG_0x81c, 0x64440003,  BBREG_0x81c,
	0x63460003,  BBREG_0x81c, 0x62480003,  BBREG_0x81c, 0x614A0003,
	BBREG_0x81c, 0x604C0003,  BBREG_0x81c, 0x454E0003,  BBREG_0x81c,
	0x44500003,  BBREG_0x81c, 0x43520003,  BBREG_0x81c, 0x42540003,
	BBREG_0x81c, 0x41560003,  BBREG_0x81c, 0x40580003,  BBREG_0x81c,
	0x055A0003,  BBREG_0x81c, 0x045C0003,  BBREG_0x81c, 0x035E0003,
	BBREG_0x81c, 0x02600003,  BBREG_0x81c, 0x01620003,  BBREG_0x81c,
	0x00640003,  BBREG_0x81c, 0x00660003,  BBREG_0x81c, 0x00680003,
	BBREG_0x81c, 0x006A0003,  BBREG_0x81c, 0x006C0003,  BBREG_0x81c,
	0x006E0003,  BBREG_0x81c, 0x00700003,  BBREG_0x81c, 0x00720003,
	BBREG_0x81c, 0x00740003,  BBREG_0x81c, 0x00760003,  BBREG_0x81c,
	0x00780003,  BBREG_0x81c, 0x007A0003,  BBREG_0x81c, 0x007C0003,
	BBREG_0x81c, 0x007E0003,  0x90000008,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x81c, 0xFF000003,  BBREG_0x81c, 0xFE000003,
	BBREG_0x81c, 0xFD020003,  BBREG_0x81c, 0xFC040003,  BBREG_0x81c,
	0xFB060003,  BBREG_0x81c, 0xFA080003,  BBREG_0x81c, 0xF90A0003,
	BBREG_0x81c, 0xF80C0003,  BBREG_0x81c, 0xF70E0003,  BBREG_0x81c,
	0xF6100003,  BBREG_0x81c, 0xF5120003,  BBREG_0x81c, 0xF4140003,
	BBREG_0x81c, 0xF3160003,  BBREG_0x81c, 0xF2180003,  BBREG_0x81c,
	0xF11A0003,  BBREG_0x81c, 0xF01C0003,  BBREG_0x81c, 0xEF1E0003,
	BBREG_0x81c, 0xEE200003,  BBREG_0x81c, 0xED220003,  BBREG_0x81c,
	0xEC240003,  BBREG_0x81c, 0xEB260003,  BBREG_0x81c, 0xEA280003,
	BBREG_0x81c, 0xE92A0003,  BBREG_0x81c, 0xE82C0003,  BBREG_0x81c,
	0xE72E0003,  BBREG_0x81c, 0xE6300003,  BBREG_0x81c, 0xE5320003,
	BBREG_0x81c, 0xC8340003,  BBREG_0x81c, 0xC7360003,  BBREG_0x81c,
	0xC6380003,  BBREG_0x81c, 0xC53A0003,  BBREG_0x81c, 0xC43C0003,
	BBREG_0x81c, 0xC33E0003,  BBREG_0x81c, 0xC2400003,  BBREG_0x81c,
	0xC1420003,  BBREG_0x81c, 0xC0440003,  BBREG_0x81c, 0xA3460003,
	BBREG_0x81c, 0xA2480003,  BBREG_0x81c, 0xA14A0003,  BBREG_0x81c,
	0xA04C0003,  BBREG_0x81c, 0x824E0003,  BBREG_0x81c, 0x81500003,
	BBREG_0x81c, 0x80520003,  BBREG_0x81c, 0x64540003,  BBREG_0x81c,
	0x63560003,  BBREG_0x81c, 0x62580003,  BBREG_0x81c, 0x445A0003,
	BBREG_0x81c, 0x435C0003,  BBREG_0x81c, 0x425E0003,  BBREG_0x81c,
	0x41600003,  BBREG_0x81c, 0x40620003,  BBREG_0x81c, 0x05640003,
	BBREG_0x81c, 0x04660003,  BBREG_0x81c, 0x03680003,  BBREG_0x81c,
	0x026A0003,  BBREG_0x81c, 0x016C0003,  BBREG_0x81c, 0x006E0003,
	BBREG_0x81c, 0x00700003,  BBREG_0x81c, 0x00720003,  BBREG_0x81c,
	0x00740003,  BBREG_0x81c, 0x00760003,  BBREG_0x81c, 0x00780003,
	BBREG_0x81c, 0x007A0003,  BBREG_0x81c, 0x007C0003,  BBREG_0x81c,
	0x007E0003,  0x90000009,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x81c, 0xFF000003,  BBREG_0x81c, 0xF5000003,  BBREG_0x81c,
	0xF4020003,  BBREG_0x81c, 0xF3040003,  BBREG_0x81c, 0xF2060003,
	BBREG_0x81c, 0xF1080003,  BBREG_0x81c, 0xF00A0003,  BBREG_0x81c,
	0xEF0C0003,  BBREG_0x81c, 0xEE0E0003,  BBREG_0x81c, 0xED100003,
	BBREG_0x81c, 0xEC120003,  BBREG_0x81c, 0xEB140003,  BBREG_0x81c,
	0xEA160003,  BBREG_0x81c, 0xE9180003,  BBREG_0x81c, 0xE81A0003,
	BBREG_0x81c, 0xE71C0003,  BBREG_0x81c, 0xE61E0003,  BBREG_0x81c,
	0xE5200003,  BBREG_0x81c, 0xE4220003,  BBREG_0x81c, 0xE3240003,
	BBREG_0x81c, 0xE2260003,  BBREG_0x81c, 0xE1280003,  BBREG_0x81c,
	0xE02A0003,  BBREG_0x81c, 0xC32C0003,  BBREG_0x81c, 0xC22E0003,
	BBREG_0x81c, 0xC1300003,  BBREG_0x81c, 0xC0320003,  BBREG_0x81c,
	0xA4340003,  BBREG_0x81c, 0xA3360003,  BBREG_0x81c, 0xA2380003,
	BBREG_0x81c, 0xA13A0003,  BBREG_0x81c, 0xA03C0003,  BBREG_0x81c,
	0x823E0003,  BBREG_0x81c, 0x81400003,  BBREG_0x81c, 0x80420003,
	BBREG_0x81c, 0x64440003,  BBREG_0x81c, 0x63460003,  BBREG_0x81c,
	0x62480003,  BBREG_0x81c, 0x614A0003,  BBREG_0x81c, 0x604C0003,
	BBREG_0x81c, 0x454E0003,  BBREG_0x81c, 0x44500003,  BBREG_0x81c,
	0x43520003,  BBREG_0x81c, 0x42540003,  BBREG_0x81c, 0x41560003,
	BBREG_0x81c, 0x40580003,  BBREG_0x81c, 0x055A0003,  BBREG_0x81c,
	0x045C0003,  BBREG_0x81c, 0x035E0003,  BBREG_0x81c, 0x02600003,
	BBREG_0x81c, 0x01620003,  BBREG_0x81c, 0x00640003,  BBREG_0x81c,
	0x00660003,  BBREG_0x81c, 0x00680003,  BBREG_0x81c, 0x006A0003,
	BBREG_0x81c, 0x006C0003,  BBREG_0x81c, 0x006E0003,  BBREG_0x81c,
	0x00700003,  BBREG_0x81c, 0x00720003,  BBREG_0x81c, 0x00740003,
	BBREG_0x81c, 0x00760003,  BBREG_0x81c, 0x00780003,  BBREG_0x81c,
	0x007A0003,  BBREG_0x81c, 0x007C0003,  BBREG_0x81c, 0x007E0003,
	0x9000000a,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c,
	0xFF000003,  BBREG_0x81c, 0xFE000003,  BBREG_0x81c, 0xFD020003,
	BBREG_0x81c, 0xFC040003,  BBREG_0x81c, 0xFB060003,  BBREG_0x81c,
	0xFA080003,  BBREG_0x81c, 0xF90A0003,  BBREG_0x81c, 0xF80C0003,
	BBREG_0x81c, 0xF70E0003,  BBREG_0x81c, 0xF6100003,  BBREG_0x81c,
	0xF5120003,  BBREG_0x81c, 0xF4140003,  BBREG_0x81c, 0xF3160003,
	BBREG_0x81c, 0xF2180003,  BBREG_0x81c, 0xF11A0003,  BBREG_0x81c,
	0xF01C0003,  BBREG_0x81c, 0xEF1E0003,  BBREG_0x81c, 0xEE200003,
	BBREG_0x81c, 0xED220003,  BBREG_0x81c, 0xEC240003,  BBREG_0x81c,
	0xEB260003,  BBREG_0x81c, 0xEA280003,  BBREG_0x81c, 0xE92A0003,
	BBREG_0x81c, 0xE82C0003,  BBREG_0x81c, 0xE72E0003,  BBREG_0x81c,
	0xE6300003,  BBREG_0x81c, 0xE5320003,  BBREG_0x81c, 0xC8340003,
	BBREG_0x81c, 0xC7360003,  BBREG_0x81c, 0xC6380003,  BBREG_0x81c,
	0xC53A0003,  BBREG_0x81c, 0xC43C0003,  BBREG_0x81c, 0xC33E0003,
	BBREG_0x81c, 0xC2400003,  BBREG_0x81c, 0xC1420003,  BBREG_0x81c,
	0xC0440003,  BBREG_0x81c, 0xA3460003,  BBREG_0x81c, 0xA2480003,
	BBREG_0x81c, 0xA14A0003,  BBREG_0x81c, 0xA04C0003,  BBREG_0x81c,
	0x824E0003,  BBREG_0x81c, 0x81500003,  BBREG_0x81c, 0x80520003,
	BBREG_0x81c, 0x64540003,  BBREG_0x81c, 0x63560003,  BBREG_0x81c,
	0x62580003,  BBREG_0x81c, 0x445A0003,  BBREG_0x81c, 0x435C0003,
	BBREG_0x81c, 0x425E0003,  BBREG_0x81c, 0x41600003,  BBREG_0x81c,
	0x40620003,  BBREG_0x81c, 0x05640003,  BBREG_0x81c, 0x04660003,
	BBREG_0x81c, 0x03680003,  BBREG_0x81c, 0x026A0003,  BBREG_0x81c,
	0x016C0003,  BBREG_0x81c, 0x006E0003,  BBREG_0x81c, 0x00700003,
	BBREG_0x81c, 0x00720003,  BBREG_0x81c, 0x00740003,  BBREG_0x81c,
	0x00760003,  BBREG_0x81c, 0x00780003,  BBREG_0x81c, 0x007A0003,
	BBREG_0x81c, 0x007C0003,  BBREG_0x81c, 0x007E0003,  0x9000000b,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c, 0xFF000003,
	BBREG_0x81c, 0xF5000003,  BBREG_0x81c, 0xF4020003,  BBREG_0x81c,
	0xF3040003,  BBREG_0x81c, 0xF2060003,  BBREG_0x81c, 0xF1080003,
	BBREG_0x81c, 0xF00A0003,  BBREG_0x81c, 0xEF0C0003,  BBREG_0x81c,
	0xEE0E0003,  BBREG_0x81c, 0xED100003,  BBREG_0x81c, 0xEC120003,
	BBREG_0x81c, 0xEB140003,  BBREG_0x81c, 0xEA160003,  BBREG_0x81c,
	0xE9180003,  BBREG_0x81c, 0xE81A0003,  BBREG_0x81c, 0xE71C0003,
	BBREG_0x81c, 0xE61E0003,  BBREG_0x81c, 0xE5200003,  BBREG_0x81c,
	0xE4220003,  BBREG_0x81c, 0xE3240003,  BBREG_0x81c, 0xE2260003,
	BBREG_0x81c, 0xE1280003,  BBREG_0x81c, 0xE02A0003,  BBREG_0x81c,
	0xC32C0003,  BBREG_0x81c, 0xC22E0003,  BBREG_0x81c, 0xC1300003,
	BBREG_0x81c, 0xC0320003,  BBREG_0x81c, 0xA4340003,  BBREG_0x81c,
	0xA3360003,  BBREG_0x81c, 0xA2380003,  BBREG_0x81c, 0xA13A0003,
	BBREG_0x81c, 0xA03C0003,  BBREG_0x81c, 0x823E0003,  BBREG_0x81c,
	0x81400003,  BBREG_0x81c, 0x80420003,  BBREG_0x81c, 0x64440003,
	BBREG_0x81c, 0x63460003,  BBREG_0x81c, 0x62480003,  BBREG_0x81c,
	0x614A0003,  BBREG_0x81c, 0x604C0003,  BBREG_0x81c, 0x454E0003,
	BBREG_0x81c, 0x44500003,  BBREG_0x81c, 0x43520003,  BBREG_0x81c,
	0x42540003,  BBREG_0x81c, 0x41560003,  BBREG_0x81c, 0x40580003,
	BBREG_0x81c, 0x055A0003,  BBREG_0x81c, 0x045C0003,  BBREG_0x81c,
	0x035E0003,  BBREG_0x81c, 0x02600003,  BBREG_0x81c, 0x01620003,
	BBREG_0x81c, 0x00640003,  BBREG_0x81c, 0x00660003,  BBREG_0x81c,
	0x00680003,  BBREG_0x81c, 0x006A0003,  BBREG_0x81c, 0x006C0003,
	BBREG_0x81c, 0x006E0003,  BBREG_0x81c, 0x00700003,  BBREG_0x81c,
	0x00720003,  BBREG_0x81c, 0x00740003,  BBREG_0x81c, 0x00760003,
	BBREG_0x81c, 0x00780003,  BBREG_0x81c, 0x007A0003,  BBREG_0x81c,
	0x007C0003,  BBREG_0x81c, 0x007E0003,  0x9000000c,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x81c, 0xFF000003,  BBREG_0x81c,
	0xFD000003,  BBREG_0x81c, 0xFC020003,  BBREG_0x81c, 0xFB040003,
	BBREG_0x81c, 0xFA060003,  BBREG_0x81c, 0xF9080003,  BBREG_0x81c,
	0xF80A0003,  BBREG_0x81c, 0xF70C0003,  BBREG_0x81c, 0xF60E0003,
	BBREG_0x81c, 0xF5100003,  BBREG_0x81c, 0xF4120003,  BBREG_0x81c,
	0xF3140003,  BBREG_0x81c, 0xF2160003,  BBREG_0x81c, 0xF1180003,
	BBREG_0x81c, 0xF01A0003,  BBREG_0x81c, 0xEF1C0003,  BBREG_0x81c,
	0xEE1E0003,  BBREG_0x81c, 0xED200003,  BBREG_0x81c, 0xEC220003,
	BBREG_0x81c, 0xEB240003,  BBREG_0x81c, 0xEA260003,  BBREG_0x81c,
	0xE9280003,  BBREG_0x81c, 0xE82A0003,  BBREG_0x81c, 0xE72C0003,
	BBREG_0x81c, 0xE62E0003,  BBREG_0x81c, 0xE5300003,  BBREG_0x81c,
	0xC8320003,  BBREG_0x81c, 0xC7340003,  BBREG_0x81c, 0xC6360003,
	BBREG_0x81c, 0xC5380003,  BBREG_0x81c, 0xC43A0003,  BBREG_0x81c,
	0xC33C0003,  BBREG_0x81c, 0xC23E0003,  BBREG_0x81c, 0xC1400003,
	BBREG_0x81c, 0xC0420003,  BBREG_0x81c, 0xA5440003,  BBREG_0x81c,
	0xA4460003,  BBREG_0x81c, 0xA3480003,  BBREG_0x81c, 0xA24A0003,
	BBREG_0x81c, 0xA14C0003,  BBREG_0x81c, 0x834E0003,  BBREG_0x81c,
	0x82500003,  BBREG_0x81c, 0x81520003,  BBREG_0x81c, 0x80540003,
	BBREG_0x81c, 0x65560003,  BBREG_0x81c, 0x64580003,  BBREG_0x81c,
	0x635A0003,  BBREG_0x81c, 0x625C0003,  BBREG_0x81c, 0x435E0003,
	BBREG_0x81c, 0x42600003,  BBREG_0x81c, 0x41620003,  BBREG_0x81c,
	0x40640003,  BBREG_0x81c, 0x06660003,  BBREG_0x81c, 0x05680003,
	BBREG_0x81c, 0x046A0003,  BBREG_0x81c, 0x036C0003,  BBREG_0x81c,
	0x026E0003,  BBREG_0x81c, 0x01700003,  BBREG_0x81c, 0x00720003,
	BBREG_0x81c, 0x00740003,  BBREG_0x81c, 0x00760003,  BBREG_0x81c,
	0x00780003,  BBREG_0x81c, 0x007A0003,  BBREG_0x81c, 0x007C0003,
	BBREG_0x81c, 0x007E0003,  0x9000000d,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x81c, 0xFF000003,  BBREG_0x81c, 0xFE000003,
	BBREG_0x81c, 0xFD020003,  BBREG_0x81c, 0xFC040003,  BBREG_0x81c,
	0xFB060003,  BBREG_0x81c, 0xFA080003,  BBREG_0x81c, 0xF90A0003,
	BBREG_0x81c, 0xF80C0003,  BBREG_0x81c, 0xF70E0003,  BBREG_0x81c,
	0xF6100003,  BBREG_0x81c, 0xF5120003,  BBREG_0x81c, 0xF4140003,
	BBREG_0x81c, 0xF3160003,  BBREG_0x81c, 0xF2180003,  BBREG_0x81c,
	0xF11A0003,  BBREG_0x81c, 0xF01C0003,  BBREG_0x81c, 0xEF1E0003,
	BBREG_0x81c, 0xEE200003,  BBREG_0x81c, 0xED220003,  BBREG_0x81c,
	0xEC240003,  BBREG_0x81c, 0xEB260003,  BBREG_0x81c, 0xEA280003,
	BBREG_0x81c, 0xE92A0003,  BBREG_0x81c, 0xE82C0003,  BBREG_0x81c,
	0xE72E0003,  BBREG_0x81c, 0xE6300003,  BBREG_0x81c, 0xE5320003,
	BBREG_0x81c, 0xC8340003,  BBREG_0x81c, 0xC7360003,  BBREG_0x81c,
	0xC6380003,  BBREG_0x81c, 0xC53A0003,  BBREG_0x81c, 0xC43C0003,
	BBREG_0x81c, 0xC33E0003,  BBREG_0x81c, 0xC2400003,  BBREG_0x81c,
	0xC1420003,  BBREG_0x81c, 0xC0440003,  BBREG_0x81c, 0xA3460003,
	BBREG_0x81c, 0xA2480003,  BBREG_0x81c, 0xA14A0003,  BBREG_0x81c,
	0xA04C0003,  BBREG_0x81c, 0x824E0003,  BBREG_0x81c, 0x81500003,
	BBREG_0x81c, 0x80520003,  BBREG_0x81c, 0x64540003,  BBREG_0x81c,
	0x63560003,  BBREG_0x81c, 0x62580003,  BBREG_0x81c, 0x445A0003,
	BBREG_0x81c, 0x435C0003,  BBREG_0x81c, 0x425E0003,  BBREG_0x81c,
	0x41600003,  BBREG_0x81c, 0x40620003,  BBREG_0x81c, 0x05640003,
	BBREG_0x81c, 0x04660003,  BBREG_0x81c, 0x03680003,  BBREG_0x81c,
	0x026A0003,  BBREG_0x81c, 0x016C0003,  BBREG_0x81c, 0x006E0003,
	BBREG_0x81c, 0x00700003,  BBREG_0x81c, 0x00720003,  BBREG_0x81c,
	0x00740003,  BBREG_0x81c, 0x00760003,  BBREG_0x81c, 0x00780003,
	BBREG_0x81c, 0x007A0003,  BBREG_0x81c, 0x007C0003,  BBREG_0x81c,
	0x007E0003,  0x9000000e,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x81c, 0xFF000003,  BBREG_0x81c, 0xFE000003,  BBREG_0x81c,
	0xFD020003,  BBREG_0x81c, 0xFC040003,  BBREG_0x81c, 0xFB060003,
	BBREG_0x81c, 0xFA080003,  BBREG_0x81c, 0xF90A0003,  BBREG_0x81c,
	0xF80C0003,  BBREG_0x81c, 0xF70E0003,  BBREG_0x81c, 0xF6100003,
	BBREG_0x81c, 0xF5120003,  BBREG_0x81c, 0xF4140003,  BBREG_0x81c,
	0xF3160003,  BBREG_0x81c, 0xF2180003,  BBREG_0x81c, 0xF11A0003,
	BBREG_0x81c, 0xF01C0003,  BBREG_0x81c, 0xEF1E0003,  BBREG_0x81c,
	0xEE200003,  BBREG_0x81c, 0xED220003,  BBREG_0x81c, 0xEC240003,
	BBREG_0x81c, 0xEB260003,  BBREG_0x81c, 0xEA280003,  BBREG_0x81c,
	0xE92A0003,  BBREG_0x81c, 0xE82C0003,  BBREG_0x81c, 0xE72E0003,
	BBREG_0x81c, 0xE6300003,  BBREG_0x81c, 0xE5320003,  BBREG_0x81c,
	0xC8340003,  BBREG_0x81c, 0xC7360003,  BBREG_0x81c, 0xC6380003,
	BBREG_0x81c, 0xC53A0003,  BBREG_0x81c, 0xC43C0003,  BBREG_0x81c,
	0xC33E0003,  BBREG_0x81c, 0xC2400003,  BBREG_0x81c, 0xC1420003,
	BBREG_0x81c, 0xC0440003,  BBREG_0x81c, 0xA3460003,  BBREG_0x81c,
	0xA2480003,  BBREG_0x81c, 0xA14A0003,  BBREG_0x81c, 0xA04C0003,
	BBREG_0x81c, 0x824E0003,  BBREG_0x81c, 0x81500003,  BBREG_0x81c,
	0x80520003,  BBREG_0x81c, 0x64540003,  BBREG_0x81c, 0x63560003,
	BBREG_0x81c, 0x62580003,  BBREG_0x81c, 0x445A0003,  BBREG_0x81c,
	0x435C0003,  BBREG_0x81c, 0x425E0003,  BBREG_0x81c, 0x41600003,
	BBREG_0x81c, 0x40620003,  BBREG_0x81c, 0x05640003,  BBREG_0x81c,
	0x04660003,  BBREG_0x81c, 0x03680003,  BBREG_0x81c, 0x026A0003,
	BBREG_0x81c, 0x016C0003,  BBREG_0x81c, 0x006E0003,  BBREG_0x81c,
	0x00700003,  BBREG_0x81c, 0x00720003,  BBREG_0x81c, 0x00740003,
	BBREG_0x81c, 0x00760003,  BBREG_0x81c, 0x00780003,  BBREG_0x81c,
	0x007A0003,  BBREG_0x81c, 0x007C0003,  BBREG_0x81c, 0x007E0003,
	0x9000000f,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c,
	0xFF000003,  BBREG_0x81c, 0xFC000003,  BBREG_0x81c, 0xFB020003,
	BBREG_0x81c, 0xFA040003,  BBREG_0x81c, 0xF9060003,  BBREG_0x81c,
	0xF8080003,  BBREG_0x81c, 0xF70A0003,  BBREG_0x81c, 0xF60C0003,
	BBREG_0x81c, 0xF50E0003,  BBREG_0x81c, 0xF4100003,  BBREG_0x81c,
	0xF3120003,  BBREG_0x81c, 0xF2140003,  BBREG_0x81c, 0xF1160003,
	BBREG_0x81c, 0xF0180003,  BBREG_0x81c, 0xEF1A0003,  BBREG_0x81c,
	0xEE1C0003,  BBREG_0x81c, 0xED1E0003,  BBREG_0x81c, 0xEC200003,
	BBREG_0x81c, 0xEB220003,  BBREG_0x81c, 0xEA240003,  BBREG_0x81c,
	0xE9260003,  BBREG_0x81c, 0xE8280003,  BBREG_0x81c, 0xE72A0003,
	BBREG_0x81c, 0xE62C0003,  BBREG_0x81c, 0xE52E0003,  BBREG_0x81c,
	0xC8300003,  BBREG_0x81c, 0xC7320003,  BBREG_0x81c, 0xC6340003,
	BBREG_0x81c, 0xC5360003,  BBREG_0x81c, 0xC4380003,  BBREG_0x81c,
	0xC33A0003,  BBREG_0x81c, 0xC23C0003,  BBREG_0x81c, 0xC13E0003,
	BBREG_0x81c, 0xA4400003,  BBREG_0x81c, 0xA3420003,  BBREG_0x81c,
	0xA2440003,  BBREG_0x81c, 0xA1460003,  BBREG_0x81c, 0xA0480003,
	BBREG_0x81c, 0x684A0003,  BBREG_0x81c, 0x674C0003,  BBREG_0x81c,
	0x664E0003,  BBREG_0x81c, 0x65500003,  BBREG_0x81c, 0x64520003,
	BBREG_0x81c, 0x63540003,  BBREG_0x81c, 0x44560003,  BBREG_0x81c,
	0x43580003,  BBREG_0x81c, 0x425A0003,  BBREG_0x81c, 0x415C0003,
	BBREG_0x81c, 0x405E0003,  BBREG_0x81c, 0x23600003,  BBREG_0x81c,
	0x22620003,  BBREG_0x81c, 0x21640003,  BBREG_0x81c, 0x03660003,
	BBREG_0x81c, 0x02680003,  BBREG_0x81c, 0x016A0003,  BBREG_0x81c,
	0x006C0003,  BBREG_0x81c, 0x006E0003,  BBREG_0x81c, 0x00700003,
	BBREG_0x81c, 0x00720003,  BBREG_0x81c, 0x00740003,  BBREG_0x81c,
	0x00760003,  BBREG_0x81c, 0x00780003,  BBREG_0x81c, 0x007A0003,
	BBREG_0x81c, 0x007C0003,  BBREG_0x81c, 0x007E0003,  0x90000010,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c, 0xFF000003,
	BBREG_0x81c, 0xFD000003,  BBREG_0x81c, 0xFC020003,  BBREG_0x81c,
	0xFB040003,  BBREG_0x81c, 0xFA060003,  BBREG_0x81c, 0xF9080003,
	BBREG_0x81c, 0xF80A0003,  BBREG_0x81c, 0xF70C0003,  BBREG_0x81c,
	0xF60E0003,  BBREG_0x81c, 0xF5100003,  BBREG_0x81c, 0xF4120003,
	BBREG_0x81c, 0xF3140003,  BBREG_0x81c, 0xF2160003,  BBREG_0x81c,
	0xF1180003,  BBREG_0x81c, 0xF01A0003,  BBREG_0x81c, 0xEF1C0003,
	BBREG_0x81c, 0xEE1E0003,  BBREG_0x81c, 0xED200003,  BBREG_0x81c,
	0xEC220003,  BBREG_0x81c, 0xEB240003,  BBREG_0x81c, 0xEA260003,
	BBREG_0x81c, 0xE9280003,  BBREG_0x81c, 0xE82A0003,  BBREG_0x81c,
	0xE72C0003,  BBREG_0x81c, 0xE62E0003,  BBREG_0x81c, 0xE5300003,
	BBREG_0x81c, 0xC8320003,  BBREG_0x81c, 0xC7340003,  BBREG_0x81c,
	0xC6360003,  BBREG_0x81c, 0xC5380003,  BBREG_0x81c, 0xC43A0003,
	BBREG_0x81c, 0xC33C0003,  BBREG_0x81c, 0xC23E0003,  BBREG_0x81c,
	0xC1400003,  BBREG_0x81c, 0xC0420003,  BBREG_0x81c, 0xA5440003,
	BBREG_0x81c, 0xA4460003,  BBREG_0x81c, 0xA3480003,  BBREG_0x81c,
	0xA24A0003,  BBREG_0x81c, 0xA14C0003,  BBREG_0x81c, 0x834E0003,
	BBREG_0x81c, 0x82500003,  BBREG_0x81c, 0x81520003,  BBREG_0x81c,
	0x80540003,  BBREG_0x81c, 0x65560003,  BBREG_0x81c, 0x64580003,
	BBREG_0x81c, 0x635A0003,  BBREG_0x81c, 0x625C0003,  BBREG_0x81c,
	0x435E0003,  BBREG_0x81c, 0x42600003,  BBREG_0x81c, 0x41620003,
	BBREG_0x81c, 0x40640003,  BBREG_0x81c, 0x06660003,  BBREG_0x81c,
	0x05680003,  BBREG_0x81c, 0x046A0003,  BBREG_0x81c, 0x036C0003,
	BBREG_0x81c, 0x026E0003,  BBREG_0x81c, 0x01700003,  BBREG_0x81c,
	0x00720003,  BBREG_0x81c, 0x00740003,  BBREG_0x81c, 0x00760003,
	BBREG_0x81c, 0x00780003,  BBREG_0x81c, 0x007A0003,  BBREG_0x81c,
	0x007C0003,  BBREG_0x81c, 0x007E0003,  0xA0000000,  0x00000000,
	BBREG_0x81c, 0xFF000003,  BBREG_0x81c, 0xFE000003,  BBREG_0x81c,
	0xFD020003,  BBREG_0x81c, 0xFC040003,  BBREG_0x81c, 0xFB060003,
	BBREG_0x81c, 0xFA080003,  BBREG_0x81c, 0xF90A0003,  BBREG_0x81c,
	0xF80C0003,  BBREG_0x81c, 0xF70E0003,  BBREG_0x81c, 0xF6100003,
	BBREG_0x81c, 0xF5120003,  BBREG_0x81c, 0xF4140003,  BBREG_0x81c,
	0xF3160003,  BBREG_0x81c, 0xF2180003,  BBREG_0x81c, 0xF11A0003,
	BBREG_0x81c, 0xF01C0003,  BBREG_0x81c, 0xEF1E0003,  BBREG_0x81c,
	0xEE200003,  BBREG_0x81c, 0xED220003,  BBREG_0x81c, 0xEC240003,
	BBREG_0x81c, 0xEB260003,  BBREG_0x81c, 0xEA280003,  BBREG_0x81c,
	0xE92A0003,  BBREG_0x81c, 0xE82C0003,  BBREG_0x81c, 0xE72E0003,
	BBREG_0x81c, 0xE6300003,  BBREG_0x81c, 0xE5320003,  BBREG_0x81c,
	0xC8340003,  BBREG_0x81c, 0xC7360003,  BBREG_0x81c, 0xC6380003,
	BBREG_0x81c, 0xC53A0003,  BBREG_0x81c, 0xC43C0003,  BBREG_0x81c,
	0xC33E0003,  BBREG_0x81c, 0xC2400003,  BBREG_0x81c, 0xC1420003,
	BBREG_0x81c, 0xC0440003,  BBREG_0x81c, 0xA3460003,  BBREG_0x81c,
	0xA2480003,  BBREG_0x81c, 0xA14A0003,  BBREG_0x81c, 0xA04C0003,
	BBREG_0x81c, 0x824E0003,  BBREG_0x81c, 0x81500003,  BBREG_0x81c,
	0x80520003,  BBREG_0x81c, 0x64540003,  BBREG_0x81c, 0x63560003,
	BBREG_0x81c, 0x62580003,  BBREG_0x81c, 0x445A0003,  BBREG_0x81c,
	0x435C0003,  BBREG_0x81c, 0x425E0003,  BBREG_0x81c, 0x41600003,
	BBREG_0x81c, 0x40620003,  BBREG_0x81c, 0x05640003,  BBREG_0x81c,
	0x04660003,  BBREG_0x81c, 0x03680003,  BBREG_0x81c, 0x026A0003,
	BBREG_0x81c, 0x016C0003,  BBREG_0x81c, 0x006E0003,  BBREG_0x81c,
	0x00700003,  BBREG_0x81c, 0x00720003,  BBREG_0x81c, 0x00740003,
	BBREG_0x81c, 0x00760003,  BBREG_0x81c, 0x00780003,  BBREG_0x81c,
	0x007A0003,  BBREG_0x81c, 0x007C0003,  BBREG_0x81c, 0x007E0003,
	0xB0000000,  0x00000000,  0x80000000,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x81c, 0xFD000103,  BBREG_0x81c, 0xFC020103,
	BBREG_0x81c, 0xFB040103,  BBREG_0x81c, 0xFA060103,  BBREG_0x81c,
	0xF9080103,  BBREG_0x81c, 0xF80A0103,  BBREG_0x81c, 0xF70C0103,
	BBREG_0x81c, 0xF60E0103,  BBREG_0x81c, 0xF5100103,  BBREG_0x81c,
	0xF4120103,  BBREG_0x81c, 0xF3140103,  BBREG_0x81c, 0xF2160103,
	BBREG_0x81c, 0xF1180103,  BBREG_0x81c, 0xF01A0103,  BBREG_0x81c,
	0xEE1C0103,  BBREG_0x81c, 0xED1E0103,  BBREG_0x81c, 0xEC200103,
	BBREG_0x81c, 0xEB220103,  BBREG_0x81c, 0xEA240103,  BBREG_0x81c,
	0xE9260103,  BBREG_0x81c, 0xE8280103,  BBREG_0x81c, 0xE72A0103,
	BBREG_0x81c, 0xE62C0103,  BBREG_0x81c, 0xE52E0103,  BBREG_0x81c,
	0xE4300103,  BBREG_0x81c, 0xE3320103,  BBREG_0x81c, 0xE2340103,
	BBREG_0x81c, 0xC5360103,  BBREG_0x81c, 0xC4380103,  BBREG_0x81c,
	0xC33A0103,  BBREG_0x81c, 0xC23C0103,  BBREG_0x81c, 0xA53E0103,
	BBREG_0x81c, 0xA4400103,  BBREG_0x81c, 0xA3420103,  BBREG_0x81c,
	0xA2440103,  BBREG_0x81c, 0xA1460103,  BBREG_0x81c, 0x83480103,
	BBREG_0x81c, 0x824A0103,  BBREG_0x81c, 0x814C0103,  BBREG_0x81c,
	0x804E0103,  BBREG_0x81c, 0x63500103,  BBREG_0x81c, 0x62520103,
	BBREG_0x81c, 0x61540103,  BBREG_0x81c, 0x43560103,  BBREG_0x81c,
	0x42580103,  BBREG_0x81c, 0x415A0103,  BBREG_0x81c, 0x405C0103,
	BBREG_0x81c, 0x225E0103,  BBREG_0x81c, 0x21600103,  BBREG_0x81c,
	0x20620103,  BBREG_0x81c, 0x03640103,  BBREG_0x81c, 0x02660103,
	BBREG_0x81c, 0x01680103,  BBREG_0x81c, 0x006A0103,  BBREG_0x81c,
	0x006C0103,  BBREG_0x81c, 0x006E0103,  BBREG_0x81c, 0x00700103,
	BBREG_0x81c, 0x00720103,  BBREG_0x81c, 0x00740103,  BBREG_0x81c,
	0x00760103,  BBREG_0x81c, 0x00780103,  BBREG_0x81c, 0x007A0103,
	BBREG_0x81c, 0x007C0103,  BBREG_0x81c, 0x007E0103,  0x90000001,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c, 0xF8000103,
	BBREG_0x81c, 0xF7020103,  BBREG_0x81c, 0xF6040103,  BBREG_0x81c,
	0xF5060103,  BBREG_0x81c, 0xF4080103,  BBREG_0x81c, 0xF30A0103,
	BBREG_0x81c, 0xF20C0103,  BBREG_0x81c, 0xF10E0103,  BBREG_0x81c,
	0xF0100103,  BBREG_0x81c, 0xEF120103,  BBREG_0x81c, 0xEE140103,
	BBREG_0x81c, 0xED160103,  BBREG_0x81c, 0xEC180103,  BBREG_0x81c,
	0xEB1A0103,  BBREG_0x81c, 0xEA1C0103,  BBREG_0x81c, 0xE91E0103,
	BBREG_0x81c, 0xE8200103,  BBREG_0x81c, 0xE7220103,  BBREG_0x81c,
	0xE6240103,  BBREG_0x81c, 0xE5260103,  BBREG_0x81c, 0xE4280103,
	BBREG_0x81c, 0xE32A0103,  BBREG_0x81c, 0xC32C0103,  BBREG_0x81c,
	0xC22E0103,  BBREG_0x81c, 0xC1300103,  BBREG_0x81c, 0xC0320103,
	BBREG_0x81c, 0xA3340103,  BBREG_0x81c, 0xA2360103,  BBREG_0x81c,
	0xA1380103,  BBREG_0x81c, 0xA03A0103,  BBREG_0x81c, 0x823C0103,
	BBREG_0x81c, 0x813E0103,  BBREG_0x81c, 0x80400103,  BBREG_0x81c,
	0x63420103,  BBREG_0x81c, 0x62440103,  BBREG_0x81c, 0x61460103,
	BBREG_0x81c, 0x60480103,  BBREG_0x81c, 0x424A0103,  BBREG_0x81c,
	0x414C0103,  BBREG_0x81c, 0x404E0103,  BBREG_0x81c, 0x06500103,
	BBREG_0x81c, 0x05520103,  BBREG_0x81c, 0x04540103,  BBREG_0x81c,
	0x03560103,  BBREG_0x81c, 0x02580103,  BBREG_0x81c, 0x015A0103,
	BBREG_0x81c, 0x005C0103,  BBREG_0x81c, 0x005E0103,  BBREG_0x81c,
	0x00600103,  BBREG_0x81c, 0x00620103,  BBREG_0x81c, 0x00640103,
	BBREG_0x81c, 0x00660103,  BBREG_0x81c, 0x00680103,  BBREG_0x81c,
	0x006A0103,  BBREG_0x81c, 0x006C0103,  BBREG_0x81c, 0x006E0103,
	BBREG_0x81c, 0x00700103,  BBREG_0x81c, 0x00720103,  BBREG_0x81c,
	0x00740103,  BBREG_0x81c, 0x00760103,  BBREG_0x81c, 0x00780103,
	BBREG_0x81c, 0x007A0103,  BBREG_0x81c, 0x007C0103,  BBREG_0x81c,
	0x007E0103,  0x90000002,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x81c, 0xF8000103,  BBREG_0x81c, 0xF7020103,  BBREG_0x81c,
	0xF6040103,  BBREG_0x81c, 0xF5060103,  BBREG_0x81c, 0xF4080103,
	BBREG_0x81c, 0xF30A0103,  BBREG_0x81c, 0xF20C0103,  BBREG_0x81c,
	0xF10E0103,  BBREG_0x81c, 0xF0100103,  BBREG_0x81c, 0xEF120103,
	BBREG_0x81c, 0xEE140103,  BBREG_0x81c, 0xED160103,  BBREG_0x81c,
	0xEC180103,  BBREG_0x81c, 0xEB1A0103,  BBREG_0x81c, 0xEA1C0103,
	BBREG_0x81c, 0xE91E0103,  BBREG_0x81c, 0xE8200103,  BBREG_0x81c,
	0xE7220103,  BBREG_0x81c, 0xE6240103,  BBREG_0x81c, 0xE5260103,
	BBREG_0x81c, 0xE4280103,  BBREG_0x81c, 0xE32A0103,  BBREG_0x81c,
	0xC32C0103,  BBREG_0x81c, 0xC22E0103,  BBREG_0x81c, 0xC1300103,
	BBREG_0x81c, 0xC0320103,  BBREG_0x81c, 0xA3340103,  BBREG_0x81c,
	0xA2360103,  BBREG_0x81c, 0xA1380103,  BBREG_0x81c, 0xA03A0103,
	BBREG_0x81c, 0x823C0103,  BBREG_0x81c, 0x813E0103,  BBREG_0x81c,
	0x80400103,  BBREG_0x81c, 0x63420103,  BBREG_0x81c, 0x62440103,
	BBREG_0x81c, 0x61460103,  BBREG_0x81c, 0x60480103,  BBREG_0x81c,
	0x424A0103,  BBREG_0x81c, 0x414C0103,  BBREG_0x81c, 0x404E0103,
	BBREG_0x81c, 0x22500103,  BBREG_0x81c, 0x21520103,  BBREG_0x81c,
	0x20540103,  BBREG_0x81c, 0x03560103,  BBREG_0x81c, 0x02580103,
	BBREG_0x81c, 0x015A0103,  BBREG_0x81c, 0x005C0103,  BBREG_0x81c,
	0x005E0103,  BBREG_0x81c, 0x00600103,  BBREG_0x81c, 0x00620103,
	BBREG_0x81c, 0x00640103,  BBREG_0x81c, 0x00660103,  BBREG_0x81c,
	0x00680103,  BBREG_0x81c, 0x006A0103,  BBREG_0x81c, 0x006C0103,
	BBREG_0x81c, 0x006E0103,  BBREG_0x81c, 0x00700103,  BBREG_0x81c,
	0x00720103,  BBREG_0x81c, 0x00740103,  BBREG_0x81c, 0x00760103,
	BBREG_0x81c, 0x00780103,  BBREG_0x81c, 0x007A0103,  BBREG_0x81c,
	0x007C0103,  BBREG_0x81c, 0x007E0103,  0x90000003,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x81c, 0xFE000103,  BBREG_0x81c,
	0xFD020103,  BBREG_0x81c, 0xFC040103,  BBREG_0x81c, 0xFB060103,
	BBREG_0x81c, 0xFA080103,  BBREG_0x81c, 0xF90A0103,  BBREG_0x81c,
	0xF80C0103,  BBREG_0x81c, 0xF70E0103,  BBREG_0x81c, 0xF6100103,
	BBREG_0x81c, 0xF5120103,  BBREG_0x81c, 0xF4140103,  BBREG_0x81c,
	0xF3160103,  BBREG_0x81c, 0xF2180103,  BBREG_0x81c, 0xF11A0103,
	BBREG_0x81c, 0xF01C0103,  BBREG_0x81c, 0xEF1E0103,  BBREG_0x81c,
	0xEE200103,  BBREG_0x81c, 0xED220103,  BBREG_0x81c, 0xEC240103,
	BBREG_0x81c, 0xEB260103,  BBREG_0x81c, 0xEA280103,  BBREG_0x81c,
	0xE92A0103,  BBREG_0x81c, 0xE82C0103,  BBREG_0x81c, 0xE72E0103,
	BBREG_0x81c, 0xE6300103,  BBREG_0x81c, 0xE5320103,  BBREG_0x81c,
	0xE4340103,  BBREG_0x81c, 0xE3360103,  BBREG_0x81c, 0xC6380103,
	BBREG_0x81c, 0xC53A0103,  BBREG_0x81c, 0xC43C0103,  BBREG_0x81c,
	0xC33E0103,  BBREG_0x81c, 0xA5400103,  BBREG_0x81c, 0xA4420103,
	BBREG_0x81c, 0xA3440103,  BBREG_0x81c, 0xA2460103,  BBREG_0x81c,
	0xA1480103,  BBREG_0x81c, 0xA04A0103,  BBREG_0x81c, 0x824C0103,
	BBREG_0x81c, 0x814E0103,  BBREG_0x81c, 0x80500103,  BBREG_0x81c,
	0x64520103,  BBREG_0x81c, 0x63540103,  BBREG_0x81c, 0x62560103,
	BBREG_0x81c, 0x61580103,  BBREG_0x81c, 0x605A0103,  BBREG_0x81c,
	0x235C0103,  BBREG_0x81c, 0x225E0103,  BBREG_0x81c, 0x21600103,
	BBREG_0x81c, 0x20620103,  BBREG_0x81c, 0x03640103,  BBREG_0x81c,
	0x02660103,  BBREG_0x81c, 0x01680103,  BBREG_0x81c, 0x006A0103,
	BBREG_0x81c, 0x006C0103,  BBREG_0x81c, 0x006E0103,  BBREG_0x81c,
	0x00700103,  BBREG_0x81c, 0x00720103,  BBREG_0x81c, 0x00740103,
	BBREG_0x81c, 0x00760103,  BBREG_0x81c, 0x00780103,  BBREG_0x81c,
	0x007A0103,  BBREG_0x81c, 0x007C0103,  BBREG_0x81c, 0x007E0103,
	0x90000004,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c,
	0xF8000103,  BBREG_0x81c, 0xF7020103,  BBREG_0x81c, 0xF6040103,
	BBREG_0x81c, 0xF5060103,  BBREG_0x81c, 0xF4080103,  BBREG_0x81c,
	0xF30A0103,  BBREG_0x81c, 0xF20C0103,  BBREG_0x81c, 0xF10E0103,
	BBREG_0x81c, 0xF0100103,  BBREG_0x81c, 0xEF120103,  BBREG_0x81c,
	0xEE140103,  BBREG_0x81c, 0xED160103,  BBREG_0x81c, 0xEC180103,
	BBREG_0x81c, 0xEB1A0103,  BBREG_0x81c, 0xEA1C0103,  BBREG_0x81c,
	0xE91E0103,  BBREG_0x81c, 0xE8200103,  BBREG_0x81c, 0xE7220103,
	BBREG_0x81c, 0xE6240103,  BBREG_0x81c, 0xE5260103,  BBREG_0x81c,
	0xE4280103,  BBREG_0x81c, 0xE32A0103,  BBREG_0x81c, 0xC32C0103,
	BBREG_0x81c, 0xC22E0103,  BBREG_0x81c, 0xC1300103,  BBREG_0x81c,
	0xC0320103,  BBREG_0x81c, 0xA3340103,  BBREG_0x81c, 0xA2360103,
	BBREG_0x81c, 0xA1380103,  BBREG_0x81c, 0xA03A0103,  BBREG_0x81c,
	0x823C0103,  BBREG_0x81c, 0x813E0103,  BBREG_0x81c, 0x80400103,
	BBREG_0x81c, 0x63420103,  BBREG_0x81c, 0x62440103,  BBREG_0x81c,
	0x61460103,  BBREG_0x81c, 0x60480103,  BBREG_0x81c, 0x424A0103,
	BBREG_0x81c, 0x414C0103,  BBREG_0x81c, 0x404E0103,  BBREG_0x81c,
	0x22500103,  BBREG_0x81c, 0x21520103,  BBREG_0x81c, 0x20540103,
	BBREG_0x81c, 0x03560103,  BBREG_0x81c, 0x02580103,  BBREG_0x81c,
	0x015A0103,  BBREG_0x81c, 0x005C0103,  BBREG_0x81c, 0x005E0103,
	BBREG_0x81c, 0x00600103,  BBREG_0x81c, 0x00620103,  BBREG_0x81c,
	0x00640103,  BBREG_0x81c, 0x00660103,  BBREG_0x81c, 0x00680103,
	BBREG_0x81c, 0x006A0103,  BBREG_0x81c, 0x006C0103,  BBREG_0x81c,
	0x006E0103,  BBREG_0x81c, 0x00700103,  BBREG_0x81c, 0x00720103,
	BBREG_0x81c, 0x00740103,  BBREG_0x81c, 0x00760103,  BBREG_0x81c,
	0x00780103,  BBREG_0x81c, 0x007A0103,  BBREG_0x81c, 0x007C0103,
	BBREG_0x81c, 0x007E0103,  0x90000005,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x81c, 0xFD000103,  BBREG_0x81c, 0xFC020103,
	BBREG_0x81c, 0xFB040103,  BBREG_0x81c, 0xFA060103,  BBREG_0x81c,
	0xF9080103,  BBREG_0x81c, 0xF80A0103,  BBREG_0x81c, 0xF70C0103,
	BBREG_0x81c, 0xF60E0103,  BBREG_0x81c, 0xF5100103,  BBREG_0x81c,
	0xF4120103,  BBREG_0x81c, 0xF3140103,  BBREG_0x81c, 0xF2160103,
	BBREG_0x81c, 0xF1180103,  BBREG_0x81c, 0xF01A0103,  BBREG_0x81c,
	0xEF1C0103,  BBREG_0x81c, 0xEE1E0103,  BBREG_0x81c, 0xED200103,
	BBREG_0x81c, 0xEC220103,  BBREG_0x81c, 0xEB240103,  BBREG_0x81c,
	0xEA260103,  BBREG_0x81c, 0xE9280103,  BBREG_0x81c, 0xE82A0103,
	BBREG_0x81c, 0xE72C0103,  BBREG_0x81c, 0xE62E0103,  BBREG_0x81c,
	0xE5300103,  BBREG_0x81c, 0xE4320103,  BBREG_0x81c, 0xE3340103,
	BBREG_0x81c, 0xE2360103,  BBREG_0x81c, 0xC5380103,  BBREG_0x81c,
	0xC43A0103,  BBREG_0x81c, 0xC33C0103,  BBREG_0x81c, 0xC23E0103,
	BBREG_0x81c, 0xA5400103,  BBREG_0x81c, 0xA4420103,  BBREG_0x81c,
	0xA3440103,  BBREG_0x81c, 0xA2460103,  BBREG_0x81c, 0xA1480103,
	BBREG_0x81c, 0x834A0103,  BBREG_0x81c, 0x824C0103,  BBREG_0x81c,
	0x814E0103,  BBREG_0x81c, 0x64500103,  BBREG_0x81c, 0x63520103,
	BBREG_0x81c, 0x62540103,  BBREG_0x81c, 0x61560103,  BBREG_0x81c,
	0x42580103,  BBREG_0x81c, 0x415A0103,  BBREG_0x81c, 0x405C0103,
	BBREG_0x81c, 0x065E0103,  BBREG_0x81c, 0x05600103,  BBREG_0x81c,
	0x04620103,  BBREG_0x81c, 0x03640103,  BBREG_0x81c, 0x02660103,
	BBREG_0x81c, 0x01680103,  BBREG_0x81c, 0x006A0103,  BBREG_0x81c,
	0x006C0103,  BBREG_0x81c, 0x006E0103,  BBREG_0x81c, 0x00700103,
	BBREG_0x81c, 0x00720103,  BBREG_0x81c, 0x00740103,  BBREG_0x81c,
	0x00760103,  BBREG_0x81c, 0x00780103,  BBREG_0x81c, 0x007A0103,
	BBREG_0x81c, 0x007C0103,  BBREG_0x81c, 0x007E0103,  0x90000006,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c, 0xFA000103,
	BBREG_0x81c, 0xF9020103,  BBREG_0x81c, 0xF8040103,  BBREG_0x81c,
	0xF7060103,  BBREG_0x81c, 0xF6080103,  BBREG_0x81c, 0xF50A0103,
	BBREG_0x81c, 0xF40C0103,  BBREG_0x81c, 0xF30E0103,  BBREG_0x81c,
	0xF2100103,  BBREG_0x81c, 0xF1120103,  BBREG_0x81c, 0xF0140103,
	BBREG_0x81c, 0xEF160103,  BBREG_0x81c, 0xEE180103,  BBREG_0x81c,
	0xED1A0103,  BBREG_0x81c, 0xEC1C0103,  BBREG_0x81c, 0xEB1E0103,
	BBREG_0x81c, 0xEA200103,  BBREG_0x81c, 0xE9220103,  BBREG_0x81c,
	0xE8240103,  BBREG_0x81c, 0xE7260103,  BBREG_0x81c, 0xE6280103,
	BBREG_0x81c, 0xE52A0103,  BBREG_0x81c, 0xC42C0103,  BBREG_0x81c,
	0xC32E0103,  BBREG_0x81c, 0xC2300103,  BBREG_0x81c, 0xC1320103,
	BBREG_0x81c, 0xA4340103,  BBREG_0x81c, 0xA3360103,  BBREG_0x81c,
	0xA2380103,  BBREG_0x81c, 0xA13A0103,  BBREG_0x81c, 0x833C0103,
	BBREG_0x81c, 0x823E0103,  BBREG_0x81c, 0x81400103,  BBREG_0x81c,
	0x63420103,  BBREG_0x81c, 0x62440103,  BBREG_0x81c, 0x61460103,
	BBREG_0x81c, 0x60480103,  BBREG_0x81c, 0x424A0103,  BBREG_0x81c,
	0x414C0103,  BBREG_0x81c, 0x404E0103,  BBREG_0x81c, 0x22500103,
	BBREG_0x81c, 0x21520103,  BBREG_0x81c, 0x20540103,  BBREG_0x81c,
	0x03560103,  BBREG_0x81c, 0x02580103,  BBREG_0x81c, 0x015A0103,
	BBREG_0x81c, 0x005C0103,  BBREG_0x81c, 0x005E0103,  BBREG_0x81c,
	0x00600103,  BBREG_0x81c, 0x00620103,  BBREG_0x81c, 0x00640103,
	BBREG_0x81c, 0x00660103,  BBREG_0x81c, 0x00680103,  BBREG_0x81c,
	0x006A0103,  BBREG_0x81c, 0x006C0103,  BBREG_0x81c, 0x006E0103,
	BBREG_0x81c, 0x00700103,  BBREG_0x81c, 0x00720103,  BBREG_0x81c,
	0x00740103,  BBREG_0x81c, 0x00760103,  BBREG_0x81c, 0x00780103,
	BBREG_0x81c, 0x007A0103,  BBREG_0x81c, 0x007C0103,  BBREG_0x81c,
	0x007E0103,  0x90000007,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x81c, 0xF8000103,  BBREG_0x81c, 0xF7020103,  BBREG_0x81c,
	0xF6040103,  BBREG_0x81c, 0xF5060103,  BBREG_0x81c, 0xF4080103,
	BBREG_0x81c, 0xF30A0103,  BBREG_0x81c, 0xF20C0103,  BBREG_0x81c,
	0xF10E0103,  BBREG_0x81c, 0xF0100103,  BBREG_0x81c, 0xEF120103,
	BBREG_0x81c, 0xEE140103,  BBREG_0x81c, 0xED160103,  BBREG_0x81c,
	0xEC180103,  BBREG_0x81c, 0xEB1A0103,  BBREG_0x81c, 0xEA1C0103,
	BBREG_0x81c, 0xE91E0103,  BBREG_0x81c, 0xE8200103,  BBREG_0x81c,
	0xE7220103,  BBREG_0x81c, 0xE6240103,  BBREG_0x81c, 0xE5260103,
	BBREG_0x81c, 0xE4280103,  BBREG_0x81c, 0xE32A0103,  BBREG_0x81c,
	0xE22C0103,  BBREG_0x81c, 0xC32E0103,  BBREG_0x81c, 0xC2300103,
	BBREG_0x81c, 0xC1320103,  BBREG_0x81c, 0xA3340103,  BBREG_0x81c,
	0xA2360103,  BBREG_0x81c, 0xA1380103,  BBREG_0x81c, 0xA03A0103,
	BBREG_0x81c, 0x823C0103,  BBREG_0x81c, 0x813E0103,  BBREG_0x81c,
	0x80400103,  BBREG_0x81c, 0x64420103,  BBREG_0x81c, 0x63440103,
	BBREG_0x81c, 0x62460103,  BBREG_0x81c, 0x61480103,  BBREG_0x81c,
	0x434A0103,  BBREG_0x81c, 0x424C0103,  BBREG_0x81c, 0x414E0103,
	BBREG_0x81c, 0x40500103,  BBREG_0x81c, 0x22520103,  BBREG_0x81c,
	0x21540103,  BBREG_0x81c, 0x20560103,  BBREG_0x81c, 0x04580103,
	BBREG_0x81c, 0x035A0103,  BBREG_0x81c, 0x025C0103,  BBREG_0x81c,
	0x015E0103,  BBREG_0x81c, 0x00600103,  BBREG_0x81c, 0x00620103,
	BBREG_0x81c, 0x00640103,  BBREG_0x81c, 0x00660103,  BBREG_0x81c,
	0x00680103,  BBREG_0x81c, 0x006A0103,  BBREG_0x81c, 0x006C0103,
	BBREG_0x81c, 0x006E0103,  BBREG_0x81c, 0x00700103,  BBREG_0x81c,
	0x00720103,  BBREG_0x81c, 0x00740103,  BBREG_0x81c, 0x00760103,
	BBREG_0x81c, 0x00780103,  BBREG_0x81c, 0x007A0103,  BBREG_0x81c,
	0x007C0103,  BBREG_0x81c, 0x007E0103,  0x90000008,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x81c, 0xFD000103,  BBREG_0x81c,
	0xFC020103,  BBREG_0x81c, 0xFB040103,  BBREG_0x81c, 0xFA060103,
	BBREG_0x81c, 0xF9080103,  BBREG_0x81c, 0xF80A0103,  BBREG_0x81c,
	0xF70C0103,  BBREG_0x81c, 0xF60E0103,  BBREG_0x81c, 0xF5100103,
	BBREG_0x81c, 0xF4120103,  BBREG_0x81c, 0xF3140103,  BBREG_0x81c,
	0xF2160103,  BBREG_0x81c, 0xF1180103,  BBREG_0x81c, 0xF01A0103,
	BBREG_0x81c, 0xEF1C0103,  BBREG_0x81c, 0xEE1E0103,  BBREG_0x81c,
	0xED200103,  BBREG_0x81c, 0xEC220103,  BBREG_0x81c, 0xEB240103,
	BBREG_0x81c, 0xEA260103,  BBREG_0x81c, 0xE9280103,  BBREG_0x81c,
	0xE82A0103,  BBREG_0x81c, 0xE72C0103,  BBREG_0x81c, 0xE62E0103,
	BBREG_0x81c, 0xE5300103,  BBREG_0x81c, 0xE4320103,  BBREG_0x81c,
	0xE3340103,  BBREG_0x81c, 0xC6360103,  BBREG_0x81c, 0xC5380103,
	BBREG_0x81c, 0xC43A0103,  BBREG_0x81c, 0xC33C0103,  BBREG_0x81c,
	0xC23E0103,  BBREG_0x81c, 0xA5400103,  BBREG_0x81c, 0xA4420103,
	BBREG_0x81c, 0xA3440103,  BBREG_0x81c, 0xA2460103,  BBREG_0x81c,
	0xA1480103,  BBREG_0x81c, 0x834A0103,  BBREG_0x81c, 0x824C0103,
	BBREG_0x81c, 0x814E0103,  BBREG_0x81c, 0x63500103,  BBREG_0x81c,
	0x62520103,  BBREG_0x81c, 0x61540103,  BBREG_0x81c, 0x43560103,
	BBREG_0x81c, 0x42580103,  BBREG_0x81c, 0x245A0103,  BBREG_0x81c,
	0x235C0103,  BBREG_0x81c, 0x225E0103,  BBREG_0x81c, 0x21600103,
	BBREG_0x81c, 0x04620103,  BBREG_0x81c, 0x03640103,  BBREG_0x81c,
	0x02660103,  BBREG_0x81c, 0x01680103,  BBREG_0x81c, 0x006A0103,
	BBREG_0x81c, 0x006C0103,  BBREG_0x81c, 0x006E0103,  BBREG_0x81c,
	0x00700103,  BBREG_0x81c, 0x00720103,  BBREG_0x81c, 0x00740103,
	BBREG_0x81c, 0x00760103,  BBREG_0x81c, 0x00780103,  BBREG_0x81c,
	0x007A0103,  BBREG_0x81c, 0x007C0103,  BBREG_0x81c, 0x007E0103,
	0x90000009,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c,
	0xF8000103,  BBREG_0x81c, 0xF7020103,  BBREG_0x81c, 0xF6040103,
	BBREG_0x81c, 0xF5060103,  BBREG_0x81c, 0xF4080103,  BBREG_0x81c,
	0xF30A0103,  BBREG_0x81c, 0xF20C0103,  BBREG_0x81c, 0xF10E0103,
	BBREG_0x81c, 0xF0100103,  BBREG_0x81c, 0xEF120103,  BBREG_0x81c,
	0xEE140103,  BBREG_0x81c, 0xED160103,  BBREG_0x81c, 0xEC180103,
	BBREG_0x81c, 0xEB1A0103,  BBREG_0x81c, 0xEA1C0103,  BBREG_0x81c,
	0xE91E0103,  BBREG_0x81c, 0xE8200103,  BBREG_0x81c, 0xE7220103,
	BBREG_0x81c, 0xE6240103,  BBREG_0x81c, 0xE5260103,  BBREG_0x81c,
	0xE4280103,  BBREG_0x81c, 0xE32A0103,  BBREG_0x81c, 0xE22C0103,
	BBREG_0x81c, 0xC32E0103,  BBREG_0x81c, 0xC2300103,  BBREG_0x81c,
	0xC1320103,  BBREG_0x81c, 0xA3340103,  BBREG_0x81c, 0xA2360103,
	BBREG_0x81c, 0xA1380103,  BBREG_0x81c, 0xA03A0103,  BBREG_0x81c,
	0x823C0103,  BBREG_0x81c, 0x813E0103,  BBREG_0x81c, 0x80400103,
	BBREG_0x81c, 0x64420103,  BBREG_0x81c, 0x63440103,  BBREG_0x81c,
	0x62460103,  BBREG_0x81c, 0x61480103,  BBREG_0x81c, 0x434A0103,
	BBREG_0x81c, 0x424C0103,  BBREG_0x81c, 0x414E0103,  BBREG_0x81c,
	0x40500103,  BBREG_0x81c, 0x22520103,  BBREG_0x81c, 0x21540103,
	BBREG_0x81c, 0x20560103,  BBREG_0x81c, 0x04580103,  BBREG_0x81c,
	0x035A0103,  BBREG_0x81c, 0x025C0103,  BBREG_0x81c, 0x015E0103,
	BBREG_0x81c, 0x00600103,  BBREG_0x81c, 0x00620103,  BBREG_0x81c,
	0x00640103,  BBREG_0x81c, 0x00660103,  BBREG_0x81c, 0x00680103,
	BBREG_0x81c, 0x006A0103,  BBREG_0x81c, 0x006C0103,  BBREG_0x81c,
	0x006E0103,  BBREG_0x81c, 0x00700103,  BBREG_0x81c, 0x00720103,
	BBREG_0x81c, 0x00740103,  BBREG_0x81c, 0x00760103,  BBREG_0x81c,
	0x00780103,  BBREG_0x81c, 0x007A0103,  BBREG_0x81c, 0x007C0103,
	BBREG_0x81c, 0x007E0103,  0x9000000a,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x81c, 0xFD000103,  BBREG_0x81c, 0xFC020103,
	BBREG_0x81c, 0xFB040103,  BBREG_0x81c, 0xFA060103,  BBREG_0x81c,
	0xF9080103,  BBREG_0x81c, 0xF80A0103,  BBREG_0x81c, 0xF70C0103,
	BBREG_0x81c, 0xF60E0103,  BBREG_0x81c, 0xF5100103,  BBREG_0x81c,
	0xF4120103,  BBREG_0x81c, 0xF3140103,  BBREG_0x81c, 0xF2160103,
	BBREG_0x81c, 0xF1180103,  BBREG_0x81c, 0xF01A0103,  BBREG_0x81c,
	0xEE1C0103,  BBREG_0x81c, 0xED1E0103,  BBREG_0x81c, 0xEC200103,
	BBREG_0x81c, 0xEB220103,  BBREG_0x81c, 0xEA240103,  BBREG_0x81c,
	0xE9260103,  BBREG_0x81c, 0xE8280103,  BBREG_0x81c, 0xE72A0103,
	BBREG_0x81c, 0xE62C0103,  BBREG_0x81c, 0xE52E0103,  BBREG_0x81c,
	0xE4300103,  BBREG_0x81c, 0xE3320103,  BBREG_0x81c, 0xE2340103,
	BBREG_0x81c, 0xC5360103,  BBREG_0x81c, 0xC4380103,  BBREG_0x81c,
	0xC33A0103,  BBREG_0x81c, 0xC23C0103,  BBREG_0x81c, 0xA53E0103,
	BBREG_0x81c, 0xA4400103,  BBREG_0x81c, 0xA3420103,  BBREG_0x81c,
	0xA2440103,  BBREG_0x81c, 0xA1460103,  BBREG_0x81c, 0x83480103,
	BBREG_0x81c, 0x824A0103,  BBREG_0x81c, 0x814C0103,  BBREG_0x81c,
	0x804E0103,  BBREG_0x81c, 0x63500103,  BBREG_0x81c, 0x62520103,
	BBREG_0x81c, 0x61540103,  BBREG_0x81c, 0x43560103,  BBREG_0x81c,
	0x42580103,  BBREG_0x81c, 0x415A0103,  BBREG_0x81c, 0x405C0103,
	BBREG_0x81c, 0x225E0103,  BBREG_0x81c, 0x21600103,  BBREG_0x81c,
	0x20620103,  BBREG_0x81c, 0x03640103,  BBREG_0x81c, 0x02660103,
	BBREG_0x81c, 0x01680103,  BBREG_0x81c, 0x006A0103,  BBREG_0x81c,
	0x006C0103,  BBREG_0x81c, 0x006E0103,  BBREG_0x81c, 0x00700103,
	BBREG_0x81c, 0x00720103,  BBREG_0x81c, 0x00740103,  BBREG_0x81c,
	0x00760103,  BBREG_0x81c, 0x00780103,  BBREG_0x81c, 0x007A0103,
	BBREG_0x81c, 0x007C0103,  BBREG_0x81c, 0x007E0103,  0x9000000b,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c, 0xF9000103,
	BBREG_0x81c, 0xF8020103,  BBREG_0x81c, 0xF7040103,  BBREG_0x81c,
	0xF6060103,  BBREG_0x81c, 0xF5080103,  BBREG_0x81c, 0xF40A0103,
	BBREG_0x81c, 0xF30C0103,  BBREG_0x81c, 0xF20E0103,  BBREG_0x81c,
	0xF1100103,  BBREG_0x81c, 0xF0120103,  BBREG_0x81c, 0xEF140103,
	BBREG_0x81c, 0xEE160103,  BBREG_0x81c, 0xED180103,  BBREG_0x81c,
	0xEC1A0103,  BBREG_0x81c, 0xEB1C0103,  BBREG_0x81c, 0xEA1E0103,
	BBREG_0x81c, 0xE9200103,  BBREG_0x81c, 0xE8220103,  BBREG_0x81c,
	0xE7240103,  BBREG_0x81c, 0xE6260103,  BBREG_0x81c, 0xE5280103,
	BBREG_0x81c, 0xE42A0103,  BBREG_0x81c, 0xE32C0103,  BBREG_0x81c,
	0xC32E0103,  BBREG_0x81c, 0xC2300103,  BBREG_0x81c, 0xC1320103,
	BBREG_0x81c, 0xA4340103,  BBREG_0x81c, 0xA3360103,  BBREG_0x81c,
	0xA2380103,  BBREG_0x81c, 0xA13A0103,  BBREG_0x81c, 0xA03C0103,
	BBREG_0x81c, 0x823E0103,  BBREG_0x81c, 0x81400103,  BBREG_0x81c,
	0x80420103,  BBREG_0x81c, 0x63440103,  BBREG_0x81c, 0x62460103,
	BBREG_0x81c, 0x61480103,  BBREG_0x81c, 0x604A0103,  BBREG_0x81c,
	0x244C0103,  BBREG_0x81c, 0x234E0103,  BBREG_0x81c, 0x22500103,
	BBREG_0x81c, 0x21520103,  BBREG_0x81c, 0x20540103,  BBREG_0x81c,
	0x05560103,  BBREG_0x81c, 0x04580103,  BBREG_0x81c, 0x035A0103,
	BBREG_0x81c, 0x025C0103,  BBREG_0x81c, 0x015E0103,  BBREG_0x81c,
	0x00600103,  BBREG_0x81c, 0x00620103,  BBREG_0x81c, 0x00640103,
	BBREG_0x81c, 0x00660103,  BBREG_0x81c, 0x00680103,  BBREG_0x81c,
	0x006A0103,  BBREG_0x81c, 0x006C0103,  BBREG_0x81c, 0x006E0103,
	BBREG_0x81c, 0x00700103,  BBREG_0x81c, 0x00720103,  BBREG_0x81c,
	0x00740103,  BBREG_0x81c, 0x00760103,  BBREG_0x81c, 0x00780103,
	BBREG_0x81c, 0x007A0103,  BBREG_0x81c, 0x007C0103,  BBREG_0x81c,
	0x007E0103,  0x9000000c,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x81c, 0xFE000103,  BBREG_0x81c, 0xFD020103,  BBREG_0x81c,
	0xFC040103,  BBREG_0x81c, 0xFB060103,  BBREG_0x81c, 0xFA080103,
	BBREG_0x81c, 0xF90A0103,  BBREG_0x81c, 0xF80C0103,  BBREG_0x81c,
	0xF70E0103,  BBREG_0x81c, 0xF6100103,  BBREG_0x81c, 0xF5120103,
	BBREG_0x81c, 0xF4140103,  BBREG_0x81c, 0xF3160103,  BBREG_0x81c,
	0xF2180103,  BBREG_0x81c, 0xF11A0103,  BBREG_0x81c, 0xF01C0103,
	BBREG_0x81c, 0xEF1E0103,  BBREG_0x81c, 0xEE200103,  BBREG_0x81c,
	0xED220103,  BBREG_0x81c, 0xEC240103,  BBREG_0x81c, 0xEB260103,
	BBREG_0x81c, 0xEA280103,  BBREG_0x81c, 0xE92A0103,  BBREG_0x81c,
	0xE82C0103,  BBREG_0x81c, 0xE72E0103,  BBREG_0x81c, 0xE6300103,
	BBREG_0x81c, 0xE5320103,  BBREG_0x81c, 0xE4340103,  BBREG_0x81c,
	0xE3360103,  BBREG_0x81c, 0xC6380103,  BBREG_0x81c, 0xC53A0103,
	BBREG_0x81c, 0xC43C0103,  BBREG_0x81c, 0xC33E0103,  BBREG_0x81c,
	0xA5400103,  BBREG_0x81c, 0xA4420103,  BBREG_0x81c, 0xA3440103,
	BBREG_0x81c, 0xA2460103,  BBREG_0x81c, 0xA1480103,  BBREG_0x81c,
	0xA04A0103,  BBREG_0x81c, 0x824C0103,  BBREG_0x81c, 0x814E0103,
	BBREG_0x81c, 0x80500103,  BBREG_0x81c, 0x64520103,  BBREG_0x81c,
	0x63540103,  BBREG_0x81c, 0x62560103,  BBREG_0x81c, 0x61580103,
	BBREG_0x81c, 0x605A0103,  BBREG_0x81c, 0x235C0103,  BBREG_0x81c,
	0x225E0103,  BBREG_0x81c, 0x21600103,  BBREG_0x81c, 0x20620103,
	BBREG_0x81c, 0x03640103,  BBREG_0x81c, 0x02660103,  BBREG_0x81c,
	0x01680103,  BBREG_0x81c, 0x006A0103,  BBREG_0x81c, 0x006C0103,
	BBREG_0x81c, 0x006E0103,  BBREG_0x81c, 0x00700103,  BBREG_0x81c,
	0x00720103,  BBREG_0x81c, 0x00740103,  BBREG_0x81c, 0x00760103,
	BBREG_0x81c, 0x00780103,  BBREG_0x81c, 0x007A0103,  BBREG_0x81c,
	0x007C0103,  BBREG_0x81c, 0x007E0103,  0x9000000d,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x81c, 0xFD000103,  BBREG_0x81c,
	0xFC020103,  BBREG_0x81c, 0xFB040103,  BBREG_0x81c, 0xFA060103,
	BBREG_0x81c, 0xF9080103,  BBREG_0x81c, 0xF80A0103,  BBREG_0x81c,
	0xF70C0103,  BBREG_0x81c, 0xF60E0103,  BBREG_0x81c, 0xF5100103,
	BBREG_0x81c, 0xF4120103,  BBREG_0x81c, 0xF3140103,  BBREG_0x81c,
	0xF2160103,  BBREG_0x81c, 0xF1180103,  BBREG_0x81c, 0xF01A0103,
	BBREG_0x81c, 0xEE1C0103,  BBREG_0x81c, 0xED1E0103,  BBREG_0x81c,
	0xEC200103,  BBREG_0x81c, 0xEB220103,  BBREG_0x81c, 0xEA240103,
	BBREG_0x81c, 0xE9260103,  BBREG_0x81c, 0xE8280103,  BBREG_0x81c,
	0xE72A0103,  BBREG_0x81c, 0xE62C0103,  BBREG_0x81c, 0xE52E0103,
	BBREG_0x81c, 0xE4300103,  BBREG_0x81c, 0xE3320103,  BBREG_0x81c,
	0xE2340103,  BBREG_0x81c, 0xC5360103,  BBREG_0x81c, 0xC4380103,
	BBREG_0x81c, 0xC33A0103,  BBREG_0x81c, 0xC23C0103,  BBREG_0x81c,
	0xA53E0103,  BBREG_0x81c, 0xA4400103,  BBREG_0x81c, 0xA3420103,
	BBREG_0x81c, 0xA2440103,  BBREG_0x81c, 0xA1460103,  BBREG_0x81c,
	0x83480103,  BBREG_0x81c, 0x824A0103,  BBREG_0x81c, 0x814C0103,
	BBREG_0x81c, 0x804E0103,  BBREG_0x81c, 0x63500103,  BBREG_0x81c,
	0x62520103,  BBREG_0x81c, 0x61540103,  BBREG_0x81c, 0x43560103,
	BBREG_0x81c, 0x42580103,  BBREG_0x81c, 0x415A0103,  BBREG_0x81c,
	0x405C0103,  BBREG_0x81c, 0x225E0103,  BBREG_0x81c, 0x21600103,
	BBREG_0x81c, 0x20620103,  BBREG_0x81c, 0x03640103,  BBREG_0x81c,
	0x02660103,  BBREG_0x81c, 0x01680103,  BBREG_0x81c, 0x006A0103,
	BBREG_0x81c, 0x006C0103,  BBREG_0x81c, 0x006E0103,  BBREG_0x81c,
	0x00700103,  BBREG_0x81c, 0x00720103,  BBREG_0x81c, 0x00740103,
	BBREG_0x81c, 0x00760103,  BBREG_0x81c, 0x00780103,  BBREG_0x81c,
	0x007A0103,  BBREG_0x81c, 0x007C0103,  BBREG_0x81c, 0x007E0103,
	0x9000000e,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c,
	0xFD000103,  BBREG_0x81c, 0xFC020103,  BBREG_0x81c, 0xFB040103,
	BBREG_0x81c, 0xFA060103,  BBREG_0x81c, 0xF9080103,  BBREG_0x81c,
	0xF80A0103,  BBREG_0x81c, 0xF70C0103,  BBREG_0x81c, 0xF60E0103,
	BBREG_0x81c, 0xF5100103,  BBREG_0x81c, 0xF4120103,  BBREG_0x81c,
	0xF3140103,  BBREG_0x81c, 0xF2160103,  BBREG_0x81c, 0xF1180103,
	BBREG_0x81c, 0xF01A0103,  BBREG_0x81c, 0xEE1C0103,  BBREG_0x81c,
	0xED1E0103,  BBREG_0x81c, 0xEC200103,  BBREG_0x81c, 0xEB220103,
	BBREG_0x81c, 0xEA240103,  BBREG_0x81c, 0xE9260103,  BBREG_0x81c,
	0xE8280103,  BBREG_0x81c, 0xE72A0103,  BBREG_0x81c, 0xE62C0103,
	BBREG_0x81c, 0xE52E0103,  BBREG_0x81c, 0xE4300103,  BBREG_0x81c,
	0xE3320103,  BBREG_0x81c, 0xE2340103,  BBREG_0x81c, 0xC5360103,
	BBREG_0x81c, 0xC4380103,  BBREG_0x81c, 0xC33A0103,  BBREG_0x81c,
	0xC23C0103,  BBREG_0x81c, 0xA53E0103,  BBREG_0x81c, 0xA4400103,
	BBREG_0x81c, 0xA3420103,  BBREG_0x81c, 0xA2440103,  BBREG_0x81c,
	0xA1460103,  BBREG_0x81c, 0x83480103,  BBREG_0x81c, 0x824A0103,
	BBREG_0x81c, 0x814C0103,  BBREG_0x81c, 0x804E0103,  BBREG_0x81c,
	0x63500103,  BBREG_0x81c, 0x62520103,  BBREG_0x81c, 0x61540103,
	BBREG_0x81c, 0x43560103,  BBREG_0x81c, 0x42580103,  BBREG_0x81c,
	0x415A0103,  BBREG_0x81c, 0x405C0103,  BBREG_0x81c, 0x225E0103,
	BBREG_0x81c, 0x21600103,  BBREG_0x81c, 0x20620103,  BBREG_0x81c,
	0x03640103,  BBREG_0x81c, 0x02660103,  BBREG_0x81c, 0x01680103,
	BBREG_0x81c, 0x006A0103,  BBREG_0x81c, 0x006C0103,  BBREG_0x81c,
	0x006E0103,  BBREG_0x81c, 0x00700103,  BBREG_0x81c, 0x00720103,
	BBREG_0x81c, 0x00740103,  BBREG_0x81c, 0x00760103,  BBREG_0x81c,
	0x00780103,  BBREG_0x81c, 0x007A0103,  BBREG_0x81c, 0x007C0103,
	BBREG_0x81c, 0x007E0103,  0x9000000f,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x81c, 0xFC000103,  BBREG_0x81c, 0xFB020103,
	BBREG_0x81c, 0xFA040103,  BBREG_0x81c, 0xF9060103,  BBREG_0x81c,
	0xF8080103,  BBREG_0x81c, 0xF70A0103,  BBREG_0x81c, 0xF60C0103,
	BBREG_0x81c, 0xF50E0103,  BBREG_0x81c, 0xF4100103,  BBREG_0x81c,
	0xF3120103,  BBREG_0x81c, 0xF2140103,  BBREG_0x81c, 0xF1160103,
	BBREG_0x81c, 0xF0180103,  BBREG_0x81c, 0xEF1A0103,  BBREG_0x81c,
	0xEE1C0103,  BBREG_0x81c, 0xED1E0103,  BBREG_0x81c, 0xEC200103,
	BBREG_0x81c, 0xEB220103,  BBREG_0x81c, 0xEA240103,  BBREG_0x81c,
	0xE9260103,  BBREG_0x81c, 0xE8280103,  BBREG_0x81c, 0xE72A0103,
	BBREG_0x81c, 0xE62C0103,  BBREG_0x81c, 0xE52E0103,  BBREG_0x81c,
	0xE4300103,  BBREG_0x81c, 0xE3320103,  BBREG_0x81c, 0xE2340103,
	BBREG_0x81c, 0xE1360103,  BBREG_0x81c, 0xC3380103,  BBREG_0x81c,
	0xC23A0103,  BBREG_0x81c, 0xC13C0103,  BBREG_0x81c, 0xC03E0103,
	BBREG_0x81c, 0xA4400103,  BBREG_0x81c, 0xA3420103,  BBREG_0x81c,
	0xA2440103,  BBREG_0x81c, 0xA1460103,  BBREG_0x81c, 0x82480103,
	BBREG_0x81c, 0x814A0103,  BBREG_0x81c, 0x804C0103,  BBREG_0x81c,
	0x634E0103,  BBREG_0x81c, 0x62500103,  BBREG_0x81c, 0x61520103,
	BBREG_0x81c, 0x42540103,  BBREG_0x81c, 0x41560103,  BBREG_0x81c,
	0x24580103,  BBREG_0x81c, 0x235A0103,  BBREG_0x81c, 0x225C0103,
	BBREG_0x81c, 0x215E0103,  BBREG_0x81c, 0x20600103,  BBREG_0x81c,
	0x03620103,  BBREG_0x81c, 0x02640103,  BBREG_0x81c, 0x01660103,
	BBREG_0x81c, 0x00680103,  BBREG_0x81c, 0x006A0103,  BBREG_0x81c,
	0x006C0103,  BBREG_0x81c, 0x006E0103,  BBREG_0x81c, 0x00700103,
	BBREG_0x81c, 0x00720103,  BBREG_0x81c, 0x00740103,  BBREG_0x81c,
	0x00760103,  BBREG_0x81c, 0x00780103,  BBREG_0x81c, 0x007A0103,
	BBREG_0x81c, 0x007C0103,  BBREG_0x81c, 0x007E0103,  0x90000010,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c, 0xFE000103,
	BBREG_0x81c, 0xFD020103,  BBREG_0x81c, 0xFC040103,  BBREG_0x81c,
	0xFB060103,  BBREG_0x81c, 0xFA080103,  BBREG_0x81c, 0xF90A0103,
	BBREG_0x81c, 0xF80C0103,  BBREG_0x81c, 0xF70E0103,  BBREG_0x81c,
	0xF6100103,  BBREG_0x81c, 0xF5120103,  BBREG_0x81c, 0xF4140103,
	BBREG_0x81c, 0xF3160103,  BBREG_0x81c, 0xF2180103,  BBREG_0x81c,
	0xF11A0103,  BBREG_0x81c, 0xF01C0103,  BBREG_0x81c, 0xEF1E0103,
	BBREG_0x81c, 0xEE200103,  BBREG_0x81c, 0xED220103,  BBREG_0x81c,
	0xEC240103,  BBREG_0x81c, 0xEB260103,  BBREG_0x81c, 0xEA280103,
	BBREG_0x81c, 0xE92A0103,  BBREG_0x81c, 0xE82C0103,  BBREG_0x81c,
	0xE72E0103,  BBREG_0x81c, 0xE6300103,  BBREG_0x81c, 0xE5320103,
	BBREG_0x81c, 0xE4340103,  BBREG_0x81c, 0xE3360103,  BBREG_0x81c,
	0xC6380103,  BBREG_0x81c, 0xC53A0103,  BBREG_0x81c, 0xC43C0103,
	BBREG_0x81c, 0xC33E0103,  BBREG_0x81c, 0xA5400103,  BBREG_0x81c,
	0xA4420103,  BBREG_0x81c, 0xA3440103,  BBREG_0x81c, 0xA2460103,
	BBREG_0x81c, 0xA1480103,  BBREG_0x81c, 0xA04A0103,  BBREG_0x81c,
	0x824C0103,  BBREG_0x81c, 0x814E0103,  BBREG_0x81c, 0x80500103,
	BBREG_0x81c, 0x64520103,  BBREG_0x81c, 0x63540103,  BBREG_0x81c,
	0x62560103,  BBREG_0x81c, 0x61580103,  BBREG_0x81c, 0x605A0103,
	BBREG_0x81c, 0x235C0103,  BBREG_0x81c, 0x225E0103,  BBREG_0x81c,
	0x21600103,  BBREG_0x81c, 0x20620103,  BBREG_0x81c, 0x03640103,
	BBREG_0x81c, 0x02660103,  BBREG_0x81c, 0x01680103,  BBREG_0x81c,
	0x006A0103,  BBREG_0x81c, 0x006C0103,  BBREG_0x81c, 0x006E0103,
	BBREG_0x81c, 0x00700103,  BBREG_0x81c, 0x00720103,  BBREG_0x81c,
	0x00740103,  BBREG_0x81c, 0x00760103,  BBREG_0x81c, 0x00780103,
	BBREG_0x81c, 0x007A0103,  BBREG_0x81c, 0x007C0103,  BBREG_0x81c,
	0x007E0103,  0xA0000000,  0x00000000,  BBREG_0x81c, 0xFE000103,
	BBREG_0x81c, 0xFD020103,  BBREG_0x81c, 0xFC040103,  BBREG_0x81c,
	0xFB060103,  BBREG_0x81c, 0xFA080103,  BBREG_0x81c, 0xF90A0103,
	BBREG_0x81c, 0xF80C0103,  BBREG_0x81c, 0xF70E0103,  BBREG_0x81c,
	0xF6100103,  BBREG_0x81c, 0xF5120103,  BBREG_0x81c, 0xF4140103,
	BBREG_0x81c, 0xF3160103,  BBREG_0x81c, 0xF2180103,  BBREG_0x81c,
	0xF11A0103,  BBREG_0x81c, 0xF01C0103,  BBREG_0x81c, 0xEF1E0103,
	BBREG_0x81c, 0xEE200103,  BBREG_0x81c, 0xED220103,  BBREG_0x81c,
	0xEC240103,  BBREG_0x81c, 0xEB260103,  BBREG_0x81c, 0xEA280103,
	BBREG_0x81c, 0xE92A0103,  BBREG_0x81c, 0xE82C0103,  BBREG_0x81c,
	0xE72E0103,  BBREG_0x81c, 0xE6300103,  BBREG_0x81c, 0xE5320103,
	BBREG_0x81c, 0xE4340103,  BBREG_0x81c, 0xE3360103,  BBREG_0x81c,
	0xC6380103,  BBREG_0x81c, 0xC53A0103,  BBREG_0x81c, 0xC43C0103,
	BBREG_0x81c, 0xC33E0103,  BBREG_0x81c, 0xA5400103,  BBREG_0x81c,
	0xA4420103,  BBREG_0x81c, 0xA3440103,  BBREG_0x81c, 0xA2460103,
	BBREG_0x81c, 0xA1480103,  BBREG_0x81c, 0xA04A0103,  BBREG_0x81c,
	0x824C0103,  BBREG_0x81c, 0x814E0103,  BBREG_0x81c, 0x80500103,
	BBREG_0x81c, 0x64520103,  BBREG_0x81c, 0x63540103,  BBREG_0x81c,
	0x62560103,  BBREG_0x81c, 0x61580103,  BBREG_0x81c, 0x605A0103,
	BBREG_0x81c, 0x235C0103,  BBREG_0x81c, 0x225E0103,  BBREG_0x81c,
	0x21600103,  BBREG_0x81c, 0x20620103,  BBREG_0x81c, 0x03640103,
	BBREG_0x81c, 0x02660103,  BBREG_0x81c, 0x01680103,  BBREG_0x81c,
	0x006A0103,  BBREG_0x81c, 0x006C0103,  BBREG_0x81c, 0x006E0103,
	BBREG_0x81c, 0x00700103,  BBREG_0x81c, 0x00720103,  BBREG_0x81c,
	0x00740103,  BBREG_0x81c, 0x00760103,  BBREG_0x81c, 0x00780103,
	BBREG_0x81c, 0x007A0103,  BBREG_0x81c, 0x007C0103,  BBREG_0x81c,
	0x007E0103,  0xB0000000,  0x00000000,  0x80000000,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x81c, 0xFC000203,  BBREG_0x81c,
	0xFB020203,  BBREG_0x81c, 0xFA040203,  BBREG_0x81c, 0xF9060203,
	BBREG_0x81c, 0xF8080203,  BBREG_0x81c, 0xF70A0203,  BBREG_0x81c,
	0xF60C0203,  BBREG_0x81c, 0xF50E0203,  BBREG_0x81c, 0xF4100203,
	BBREG_0x81c, 0xF3120203,  BBREG_0x81c, 0xF2140203,  BBREG_0x81c,
	0xF1160203,  BBREG_0x81c, 0xF0180203,  BBREG_0x81c, 0xEE1A0203,
	BBREG_0x81c, 0xED1C0203,  BBREG_0x81c, 0xEC1E0203,  BBREG_0x81c,
	0xEB200203,  BBREG_0x81c, 0xEA220203,  BBREG_0x81c, 0xE9240203,
	BBREG_0x81c, 0xE8260203,  BBREG_0x81c, 0xE7280203,  BBREG_0x81c,
	0xE62A0203,  BBREG_0x81c, 0xE52C0203,  BBREG_0x81c, 0xE42E0203,
	BBREG_0x81c, 0xE3300203,  BBREG_0x81c, 0xE2320203,  BBREG_0x81c,
	0xC6340203,  BBREG_0x81c, 0xC5360203,  BBREG_0x81c, 0xC4380203,
	BBREG_0x81c, 0xC33A0203,  BBREG_0x81c, 0xA63C0203,  BBREG_0x81c,
	0xA53E0203,  BBREG_0x81c, 0xA4400203,  BBREG_0x81c, 0xA3420203,
	BBREG_0x81c, 0xA2440203,  BBREG_0x81c, 0xA1460203,  BBREG_0x81c,
	0x83480203,  BBREG_0x81c, 0x824A0203,  BBREG_0x81c, 0x814C0203,
	BBREG_0x81c, 0x804E0203,  BBREG_0x81c, 0x63500203,  BBREG_0x81c,
	0x62520203,  BBREG_0x81c, 0x61540203,  BBREG_0x81c, 0x42560203,
	BBREG_0x81c, 0x41580203,  BBREG_0x81c, 0x405A0203,  BBREG_0x81c,
	0x225C0203,  BBREG_0x81c, 0x215E0203,  BBREG_0x81c, 0x20600203,
	BBREG_0x81c, 0x04620203,  BBREG_0x81c, 0x03640203,  BBREG_0x81c,
	0x02660203,  BBREG_0x81c, 0x01680203,  BBREG_0x81c, 0x006A0203,
	BBREG_0x81c, 0x006C0203,  BBREG_0x81c, 0x006E0203,  BBREG_0x81c,
	0x00700203,  BBREG_0x81c, 0x00720203,  BBREG_0x81c, 0x00740203,
	BBREG_0x81c, 0x00760203,  BBREG_0x81c, 0x00780203,  BBREG_0x81c,
	0x007A0203,  BBREG_0x81c, 0x007C0203,  BBREG_0x81c, 0x007E0203,
	0x90000001,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c,
	0xF7000203,  BBREG_0x81c, 0xF6020203,  BBREG_0x81c, 0xF5040203,
	BBREG_0x81c, 0xF4060203,  BBREG_0x81c, 0xF3080203,  BBREG_0x81c,
	0xF20A0203,  BBREG_0x81c, 0xF10C0203,  BBREG_0x81c, 0xF00E0203,
	BBREG_0x81c, 0xEF100203,  BBREG_0x81c, 0xEE120203,  BBREG_0x81c,
	0xED140203,  BBREG_0x81c, 0xEC160203,  BBREG_0x81c, 0xEB180203,
	BBREG_0x81c, 0xEA1A0203,  BBREG_0x81c, 0xE91C0203,  BBREG_0x81c,
	0xE81E0203,  BBREG_0x81c, 0xE7200203,  BBREG_0x81c, 0xE6220203,
	BBREG_0x81c, 0xE5240203,  BBREG_0x81c, 0xE4260203,  BBREG_0x81c,
	0xE3280203,  BBREG_0x81c, 0xC42A0203,  BBREG_0x81c, 0xC32C0203,
	BBREG_0x81c, 0xC22E0203,  BBREG_0x81c, 0xC1300203,  BBREG_0x81c,
	0xC0320203,  BBREG_0x81c, 0xA3340203,  BBREG_0x81c, 0xA2360203,
	BBREG_0x81c, 0xA1380203,  BBREG_0x81c, 0xA03A0203,  BBREG_0x81c,
	0x823C0203,  BBREG_0x81c, 0x813E0203,  BBREG_0x81c, 0x80400203,
	BBREG_0x81c, 0x63420203,  BBREG_0x81c, 0x62440203,  BBREG_0x81c,
	0x61460203,  BBREG_0x81c, 0x60480203,  BBREG_0x81c, 0x424A0203,
	BBREG_0x81c, 0x414C0203,  BBREG_0x81c, 0x404E0203,  BBREG_0x81c,
	0x06500203,  BBREG_0x81c, 0x05520203,  BBREG_0x81c, 0x04540203,
	BBREG_0x81c, 0x03560203,  BBREG_0x81c, 0x02580203,  BBREG_0x81c,
	0x015A0203,  BBREG_0x81c, 0x005C0203,  BBREG_0x81c, 0x005E0203,
	BBREG_0x81c, 0x00600203,  BBREG_0x81c, 0x00620203,  BBREG_0x81c,
	0x00640203,  BBREG_0x81c, 0x00660203,  BBREG_0x81c, 0x00680203,
	BBREG_0x81c, 0x006A0203,  BBREG_0x81c, 0x006C0203,  BBREG_0x81c,
	0x006E0203,  BBREG_0x81c, 0x00700203,  BBREG_0x81c, 0x00720203,
	BBREG_0x81c, 0x00740203,  BBREG_0x81c, 0x00760203,  BBREG_0x81c,
	0x00780203,  BBREG_0x81c, 0x007A0203,  BBREG_0x81c, 0x007C0203,
	BBREG_0x81c, 0x007E0203,  0x90000002,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x81c, 0xF7000203,  BBREG_0x81c, 0xF6020203,
	BBREG_0x81c, 0xF5040203,  BBREG_0x81c, 0xF4060203,  BBREG_0x81c,
	0xF3080203,  BBREG_0x81c, 0xF20A0203,  BBREG_0x81c, 0xF10C0203,
	BBREG_0x81c, 0xF00E0203,  BBREG_0x81c, 0xEF100203,  BBREG_0x81c,
	0xEE120203,  BBREG_0x81c, 0xED140203,  BBREG_0x81c, 0xEC160203,
	BBREG_0x81c, 0xEB180203,  BBREG_0x81c, 0xEA1A0203,  BBREG_0x81c,
	0xE91C0203,  BBREG_0x81c, 0xE81E0203,  BBREG_0x81c, 0xE7200203,
	BBREG_0x81c, 0xE6220203,  BBREG_0x81c, 0xE5240203,  BBREG_0x81c,
	0xE4260203,  BBREG_0x81c, 0xE3280203,  BBREG_0x81c, 0xC42A0203,
	BBREG_0x81c, 0xC32C0203,  BBREG_0x81c, 0xC22E0203,  BBREG_0x81c,
	0xC1300203,  BBREG_0x81c, 0xC0320203,  BBREG_0x81c, 0xA3340203,
	BBREG_0x81c, 0xA2360203,  BBREG_0x81c, 0xA1380203,  BBREG_0x81c,
	0xA03A0203,  BBREG_0x81c, 0x823C0203,  BBREG_0x81c, 0x813E0203,
	BBREG_0x81c, 0x80400203,  BBREG_0x81c, 0x64420203,  BBREG_0x81c,
	0x63440203,  BBREG_0x81c, 0x62460203,  BBREG_0x81c, 0x61480203,
	BBREG_0x81c, 0x604A0203,  BBREG_0x81c, 0x414C0203,  BBREG_0x81c,
	0x404E0203,  BBREG_0x81c, 0x22500203,  BBREG_0x81c, 0x21520203,
	BBREG_0x81c, 0x20540203,  BBREG_0x81c, 0x03560203,  BBREG_0x81c,
	0x02580203,  BBREG_0x81c, 0x015A0203,  BBREG_0x81c, 0x005C0203,
	BBREG_0x81c, 0x005E0203,  BBREG_0x81c, 0x00600203,  BBREG_0x81c,
	0x00620203,  BBREG_0x81c, 0x00640203,  BBREG_0x81c, 0x00660203,
	BBREG_0x81c, 0x00680203,  BBREG_0x81c, 0x006A0203,  BBREG_0x81c,
	0x006C0203,  BBREG_0x81c, 0x006E0203,  BBREG_0x81c, 0x00700203,
	BBREG_0x81c, 0x00720203,  BBREG_0x81c, 0x00740203,  BBREG_0x81c,
	0x00760203,  BBREG_0x81c, 0x00780203,  BBREG_0x81c, 0x007A0203,
	BBREG_0x81c, 0x007C0203,  BBREG_0x81c, 0x007E0203,  0x90000003,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c, 0xFC000203,
	BBREG_0x81c, 0xFB020203,  BBREG_0x81c, 0xFA040203,  BBREG_0x81c,
	0xF9060203,  BBREG_0x81c, 0xF8080203,  BBREG_0x81c, 0xF70A0203,
	BBREG_0x81c, 0xF60C0203,  BBREG_0x81c, 0xF50E0203,  BBREG_0x81c,
	0xF4100203,  BBREG_0x81c, 0xF3120203,  BBREG_0x81c, 0xF2140203,
	BBREG_0x81c, 0xF1160203,  BBREG_0x81c, 0xF0180203,  BBREG_0x81c,
	0xEF1A0203,  BBREG_0x81c, 0xEE1C0203,  BBREG_0x81c, 0xED1E0203,
	BBREG_0x81c, 0xEC200203,  BBREG_0x81c, 0xEB220203,  BBREG_0x81c,
	0xEA240203,  BBREG_0x81c, 0xE9260203,  BBREG_0x81c, 0xE8280203,
	BBREG_0x81c, 0xE72A0203,  BBREG_0x81c, 0xE62C0203,  BBREG_0x81c,
	0xE52E0203,  BBREG_0x81c, 0xE4300203,  BBREG_0x81c, 0xE3320203,
	BBREG_0x81c, 0xE2340203,  BBREG_0x81c, 0xC6360203,  BBREG_0x81c,
	0xC5380203,  BBREG_0x81c, 0xC43A0203,  BBREG_0x81c, 0xC33C0203,
	BBREG_0x81c, 0xA63E0203,  BBREG_0x81c, 0xA5400203,  BBREG_0x81c,
	0xA4420203,  BBREG_0x81c, 0xA3440203,  BBREG_0x81c, 0xA2460203,
	BBREG_0x81c, 0xA1480203,  BBREG_0x81c, 0x834A0203,  BBREG_0x81c,
	0x824C0203,  BBREG_0x81c, 0x814E0203,  BBREG_0x81c, 0x64500203,
	BBREG_0x81c, 0x63520203,  BBREG_0x81c, 0x62540203,  BBREG_0x81c,
	0x61560203,  BBREG_0x81c, 0x60580203,  BBREG_0x81c, 0x405A0203,
	BBREG_0x81c, 0x215C0203,  BBREG_0x81c, 0x205E0203,  BBREG_0x81c,
	0x03600203,  BBREG_0x81c, 0x02620203,  BBREG_0x81c, 0x01640203,
	BBREG_0x81c, 0x00660203,  BBREG_0x81c, 0x00680203,  BBREG_0x81c,
	0x006A0203,  BBREG_0x81c, 0x006C0203,  BBREG_0x81c, 0x006E0203,
	BBREG_0x81c, 0x00700203,  BBREG_0x81c, 0x00720203,  BBREG_0x81c,
	0x00740203,  BBREG_0x81c, 0x00760203,  BBREG_0x81c, 0x00780203,
	BBREG_0x81c, 0x007A0203,  BBREG_0x81c, 0x007C0203,  BBREG_0x81c,
	0x007E0203,  0x90000004,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x81c, 0xF7000203,  BBREG_0x81c, 0xF6020203,  BBREG_0x81c,
	0xF5040203,  BBREG_0x81c, 0xF4060203,  BBREG_0x81c, 0xF3080203,
	BBREG_0x81c, 0xF20A0203,  BBREG_0x81c, 0xF10C0203,  BBREG_0x81c,
	0xF00E0203,  BBREG_0x81c, 0xEF100203,  BBREG_0x81c, 0xEE120203,
	BBREG_0x81c, 0xED140203,  BBREG_0x81c, 0xEC160203,  BBREG_0x81c,
	0xEB180203,  BBREG_0x81c, 0xEA1A0203,  BBREG_0x81c, 0xE91C0203,
	BBREG_0x81c, 0xE81E0203,  BBREG_0x81c, 0xE7200203,  BBREG_0x81c,
	0xE6220203,  BBREG_0x81c, 0xE5240203,  BBREG_0x81c, 0xE4260203,
	BBREG_0x81c, 0xE3280203,  BBREG_0x81c, 0xC42A0203,  BBREG_0x81c,
	0xC32C0203,  BBREG_0x81c, 0xC22E0203,  BBREG_0x81c, 0xC1300203,
	BBREG_0x81c, 0xC0320203,  BBREG_0x81c, 0xA3340203,  BBREG_0x81c,
	0xA2360203,  BBREG_0x81c, 0xA1380203,  BBREG_0x81c, 0xA03A0203,
	BBREG_0x81c, 0x823C0203,  BBREG_0x81c, 0x813E0203,  BBREG_0x81c,
	0x80400203,  BBREG_0x81c, 0x64420203,  BBREG_0x81c, 0x63440203,
	BBREG_0x81c, 0x62460203,  BBREG_0x81c, 0x61480203,  BBREG_0x81c,
	0x604A0203,  BBREG_0x81c, 0x414C0203,  BBREG_0x81c, 0x404E0203,
	BBREG_0x81c, 0x22500203,  BBREG_0x81c, 0x21520203,  BBREG_0x81c,
	0x20540203,  BBREG_0x81c, 0x03560203,  BBREG_0x81c, 0x02580203,
	BBREG_0x81c, 0x015A0203,  BBREG_0x81c, 0x005C0203,  BBREG_0x81c,
	0x005E0203,  BBREG_0x81c, 0x00600203,  BBREG_0x81c, 0x00620203,
	BBREG_0x81c, 0x00640203,  BBREG_0x81c, 0x00660203,  BBREG_0x81c,
	0x00680203,  BBREG_0x81c, 0x006A0203,  BBREG_0x81c, 0x006C0203,
	BBREG_0x81c, 0x006E0203,  BBREG_0x81c, 0x00700203,  BBREG_0x81c,
	0x00720203,  BBREG_0x81c, 0x00740203,  BBREG_0x81c, 0x00760203,
	BBREG_0x81c, 0x00780203,  BBREG_0x81c, 0x007A0203,  BBREG_0x81c,
	0x007C0203,  BBREG_0x81c, 0x007E0203,  0x90000005,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x81c, 0xFC000203,  BBREG_0x81c,
	0xFB020203,  BBREG_0x81c, 0xFA040203,  BBREG_0x81c, 0xF9060203,
	BBREG_0x81c, 0xF8080203,  BBREG_0x81c, 0xF70A0203,  BBREG_0x81c,
	0xF60C0203,  BBREG_0x81c, 0xF50E0203,  BBREG_0x81c, 0xF4100203,
	BBREG_0x81c, 0xF3120203,  BBREG_0x81c, 0xF2140203,  BBREG_0x81c,
	0xF1160203,  BBREG_0x81c, 0xF0180203,  BBREG_0x81c, 0xEF1A0203,
	BBREG_0x81c, 0xEE1C0203,  BBREG_0x81c, 0xED1E0203,  BBREG_0x81c,
	0xEC200203,  BBREG_0x81c, 0xEB220203,  BBREG_0x81c, 0xEA240203,
	BBREG_0x81c, 0xE9260203,  BBREG_0x81c, 0xE8280203,  BBREG_0x81c,
	0xE72A0203,  BBREG_0x81c, 0xE62C0203,  BBREG_0x81c, 0xE52E0203,
	BBREG_0x81c, 0xE4300203,  BBREG_0x81c, 0xE3320203,  BBREG_0x81c,
	0xE2340203,  BBREG_0x81c, 0xE1360203,  BBREG_0x81c, 0xC5380203,
	BBREG_0x81c, 0xC43A0203,  BBREG_0x81c, 0xC33C0203,  BBREG_0x81c,
	0xC23E0203,  BBREG_0x81c, 0xC1400203,  BBREG_0x81c, 0xA3420203,
	BBREG_0x81c, 0xA2440203,  BBREG_0x81c, 0xA1460203,  BBREG_0x81c,
	0xA0480203,  BBREG_0x81c, 0x834A0203,  BBREG_0x81c, 0x824C0203,
	BBREG_0x81c, 0x814E0203,  BBREG_0x81c, 0x64500203,  BBREG_0x81c,
	0x63520203,  BBREG_0x81c, 0x62540203,  BBREG_0x81c, 0x61560203,
	BBREG_0x81c, 0x25580203,  BBREG_0x81c, 0x245A0203,  BBREG_0x81c,
	0x235C0203,  BBREG_0x81c, 0x225E0203,  BBREG_0x81c, 0x21600203,
	BBREG_0x81c, 0x04620203,  BBREG_0x81c, 0x03640203,  BBREG_0x81c,
	0x02660203,  BBREG_0x81c, 0x01680203,  BBREG_0x81c, 0x006A0203,
	BBREG_0x81c, 0x006C0203,  BBREG_0x81c, 0x006E0203,  BBREG_0x81c,
	0x00700203,  BBREG_0x81c, 0x00720203,  BBREG_0x81c, 0x00740203,
	BBREG_0x81c, 0x00760203,  BBREG_0x81c, 0x00780203,  BBREG_0x81c,
	0x007A0203,  BBREG_0x81c, 0x007C0203,  BBREG_0x81c, 0x007E0203,
	0x90000006,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c,
	0xF9000203,  BBREG_0x81c, 0xF8020203,  BBREG_0x81c, 0xF7040203,
	BBREG_0x81c, 0xF6060203,  BBREG_0x81c, 0xF5080203,  BBREG_0x81c,
	0xF40A0203,  BBREG_0x81c, 0xF30C0203,  BBREG_0x81c, 0xF20E0203,
	BBREG_0x81c, 0xF1100203,  BBREG_0x81c, 0xF0120203,  BBREG_0x81c,
	0xEF140203,  BBREG_0x81c, 0xEE160203,  BBREG_0x81c, 0xED180203,
	BBREG_0x81c, 0xEC1A0203,  BBREG_0x81c, 0xEB1C0203,  BBREG_0x81c,
	0xEA1E0203,  BBREG_0x81c, 0xE9200203,  BBREG_0x81c, 0xE8220203,
	BBREG_0x81c, 0xE7240203,  BBREG_0x81c, 0xE6260203,  BBREG_0x81c,
	0xE5280203,  BBREG_0x81c, 0xC42A0203,  BBREG_0x81c, 0xC32C0203,
	BBREG_0x81c, 0xC22E0203,  BBREG_0x81c, 0xC1300203,  BBREG_0x81c,
	0xC0320203,  BBREG_0x81c, 0xA3340203,  BBREG_0x81c, 0xA2360203,
	BBREG_0x81c, 0xA1380203,  BBREG_0x81c, 0xA03A0203,  BBREG_0x81c,
	0x823C0203,  BBREG_0x81c, 0x813E0203,  BBREG_0x81c, 0x80400203,
	BBREG_0x81c, 0x64420203,  BBREG_0x81c, 0x63440203,  BBREG_0x81c,
	0x62460203,  BBREG_0x81c, 0x61480203,  BBREG_0x81c, 0x604A0203,
	BBREG_0x81c, 0x414C0203,  BBREG_0x81c, 0x404E0203,  BBREG_0x81c,
	0x22500203,  BBREG_0x81c, 0x21520203,  BBREG_0x81c, 0x20540203,
	BBREG_0x81c, 0x03560203,  BBREG_0x81c, 0x02580203,  BBREG_0x81c,
	0x015A0203,  BBREG_0x81c, 0x005C0203,  BBREG_0x81c, 0x005E0203,
	BBREG_0x81c, 0x00600203,  BBREG_0x81c, 0x00620203,  BBREG_0x81c,
	0x00640203,  BBREG_0x81c, 0x00660203,  BBREG_0x81c, 0x00680203,
	BBREG_0x81c, 0x006A0203,  BBREG_0x81c, 0x006C0203,  BBREG_0x81c,
	0x006E0203,  BBREG_0x81c, 0x00700203,  BBREG_0x81c, 0x00720203,
	BBREG_0x81c, 0x00740203,  BBREG_0x81c, 0x00760203,  BBREG_0x81c,
	0x00780203,  BBREG_0x81c, 0x007A0203,  BBREG_0x81c, 0x007C0203,
	BBREG_0x81c, 0x007E0203,  0x90000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x81c, 0xF8000203,  BBREG_0x81c, 0xF7020203,
	BBREG_0x81c, 0xF6040203,  BBREG_0x81c, 0xF5060203,  BBREG_0x81c,
	0xF4080203,  BBREG_0x81c, 0xF30A0203,  BBREG_0x81c, 0xF20C0203,
	BBREG_0x81c, 0xF10E0203,  BBREG_0x81c, 0xF0100203,  BBREG_0x81c,
	0xEF120203,  BBREG_0x81c, 0xEE140203,  BBREG_0x81c, 0xED160203,
	BBREG_0x81c, 0xEC180203,  BBREG_0x81c, 0xEB1A0203,  BBREG_0x81c,
	0xEA1C0203,  BBREG_0x81c, 0xE91E0203,  BBREG_0x81c, 0xE8200203,
	BBREG_0x81c, 0xE7220203,  BBREG_0x81c, 0xE6240203,  BBREG_0x81c,
	0xE5260203,  BBREG_0x81c, 0xE4280203,  BBREG_0x81c, 0xE32A0203,
	BBREG_0x81c, 0xC42C0203,  BBREG_0x81c, 0xC32E0203,  BBREG_0x81c,
	0xC2300203,  BBREG_0x81c, 0xC1320203,  BBREG_0x81c, 0xA3340203,
	BBREG_0x81c, 0xA2360203,  BBREG_0x81c, 0xA1380203,  BBREG_0x81c,
	0xA03A0203,  BBREG_0x81c, 0x823C0203,  BBREG_0x81c, 0x813E0203,
	BBREG_0x81c, 0x80400203,  BBREG_0x81c, 0x65420203,  BBREG_0x81c,
	0x64440203,  BBREG_0x81c, 0x63460203,  BBREG_0x81c, 0x62480203,
	BBREG_0x81c, 0x614A0203,  BBREG_0x81c, 0x424C0203,  BBREG_0x81c,
	0x414E0203,  BBREG_0x81c, 0x40500203,  BBREG_0x81c, 0x22520203,
	BBREG_0x81c, 0x21540203,  BBREG_0x81c, 0x20560203,  BBREG_0x81c,
	0x04580203,  BBREG_0x81c, 0x035A0203,  BBREG_0x81c, 0x025C0203,
	BBREG_0x81c, 0x015E0203,  BBREG_0x81c, 0x00600203,  BBREG_0x81c,
	0x00620203,  BBREG_0x81c, 0x00640203,  BBREG_0x81c, 0x00660203,
	BBREG_0x81c, 0x00680203,  BBREG_0x81c, 0x006A0203,  BBREG_0x81c,
	0x006C0203,  BBREG_0x81c, 0x006E0203,  BBREG_0x81c, 0x00700203,
	BBREG_0x81c, 0x00720203,  BBREG_0x81c, 0x00740203,  BBREG_0x81c,
	0x00760203,  BBREG_0x81c, 0x00780203,  BBREG_0x81c, 0x007A0203,
	BBREG_0x81c, 0x007C0203,  BBREG_0x81c, 0x007E0203,  0x90000008,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c, 0xFB000203,
	BBREG_0x81c, 0xFA020203,  BBREG_0x81c, 0xF9040203,  BBREG_0x81c,
	0xF8060203,  BBREG_0x81c, 0xF7080203,  BBREG_0x81c, 0xF60A0203,
	BBREG_0x81c, 0xF50C0203,  BBREG_0x81c, 0xF40E0203,  BBREG_0x81c,
	0xF3100203,  BBREG_0x81c, 0xF2120203,  BBREG_0x81c, 0xF1140203,
	BBREG_0x81c, 0xF0160203,  BBREG_0x81c, 0xEF180203,  BBREG_0x81c,
	0xEE1A0203,  BBREG_0x81c, 0xED1C0203,  BBREG_0x81c, 0xEC1E0203,
	BBREG_0x81c, 0xEB200203,  BBREG_0x81c, 0xEA220203,  BBREG_0x81c,
	0xE9240203,  BBREG_0x81c, 0xE8260203,  BBREG_0x81c, 0xE7280203,
	BBREG_0x81c, 0xE62A0203,  BBREG_0x81c, 0xE52C0203,  BBREG_0x81c,
	0xE42E0203,  BBREG_0x81c, 0xE3300203,  BBREG_0x81c, 0xE2320203,
	BBREG_0x81c, 0xC6340203,  BBREG_0x81c, 0xC5360203,  BBREG_0x81c,
	0xC4380203,  BBREG_0x81c, 0xC33A0203,  BBREG_0x81c, 0xC23C0203,
	BBREG_0x81c, 0xC13E0203,  BBREG_0x81c, 0xC0400203,  BBREG_0x81c,
	0xA3420203,  BBREG_0x81c, 0xA2440203,  BBREG_0x81c, 0xA1460203,
	BBREG_0x81c, 0xA0480203,  BBREG_0x81c, 0x824A0203,  BBREG_0x81c,
	0x814C0203,  BBREG_0x81c, 0x804E0203,  BBREG_0x81c, 0x63500203,
	BBREG_0x81c, 0x62520203,  BBREG_0x81c, 0x61540203,  BBREG_0x81c,
	0x60560203,  BBREG_0x81c, 0x24580203,  BBREG_0x81c, 0x235A0203,
	BBREG_0x81c, 0x225C0203,  BBREG_0x81c, 0x215E0203,  BBREG_0x81c,
	0x20600203,  BBREG_0x81c, 0x03620203,  BBREG_0x81c, 0x02640203,
	BBREG_0x81c, 0x01660203,  BBREG_0x81c, 0x00680203,  BBREG_0x81c,
	0x006A0203,  BBREG_0x81c, 0x006C0203,  BBREG_0x81c, 0x006E0203,
	BBREG_0x81c, 0x00700203,  BBREG_0x81c, 0x00720203,  BBREG_0x81c,
	0x00740203,  BBREG_0x81c, 0x00760203,  BBREG_0x81c, 0x00780203,
	BBREG_0x81c, 0x007A0203,  BBREG_0x81c, 0x007C0203,  BBREG_0x81c,
	0x007E0203,  0x90000009,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x81c, 0xF8000203,  BBREG_0x81c, 0xF7020203,  BBREG_0x81c,
	0xF6040203,  BBREG_0x81c, 0xF5060203,  BBREG_0x81c, 0xF4080203,
	BBREG_0x81c, 0xF30A0203,  BBREG_0x81c, 0xF20C0203,  BBREG_0x81c,
	0xF10E0203,  BBREG_0x81c, 0xF0100203,  BBREG_0x81c, 0xEF120203,
	BBREG_0x81c, 0xEE140203,  BBREG_0x81c, 0xED160203,  BBREG_0x81c,
	0xEC180203,  BBREG_0x81c, 0xEB1A0203,  BBREG_0x81c, 0xEA1C0203,
	BBREG_0x81c, 0xE91E0203,  BBREG_0x81c, 0xE8200203,  BBREG_0x81c,
	0xE7220203,  BBREG_0x81c, 0xE6240203,  BBREG_0x81c, 0xE5260203,
	BBREG_0x81c, 0xE4280203,  BBREG_0x81c, 0xE32A0203,  BBREG_0x81c,
	0xC42C0203,  BBREG_0x81c, 0xC32E0203,  BBREG_0x81c, 0xC2300203,
	BBREG_0x81c, 0xC1320203,  BBREG_0x81c, 0xA3340203,  BBREG_0x81c,
	0xA2360203,  BBREG_0x81c, 0xA1380203,  BBREG_0x81c, 0xA03A0203,
	BBREG_0x81c, 0x823C0203,  BBREG_0x81c, 0x813E0203,  BBREG_0x81c,
	0x80400203,  BBREG_0x81c, 0x65420203,  BBREG_0x81c, 0x64440203,
	BBREG_0x81c, 0x63460203,  BBREG_0x81c, 0x62480203,  BBREG_0x81c,
	0x614A0203,  BBREG_0x81c, 0x424C0203,  BBREG_0x81c, 0x414E0203,
	BBREG_0x81c, 0x40500203,  BBREG_0x81c, 0x22520203,  BBREG_0x81c,
	0x21540203,  BBREG_0x81c, 0x20560203,  BBREG_0x81c, 0x04580203,
	BBREG_0x81c, 0x035A0203,  BBREG_0x81c, 0x025C0203,  BBREG_0x81c,
	0x015E0203,  BBREG_0x81c, 0x00600203,  BBREG_0x81c, 0x00620203,
	BBREG_0x81c, 0x00640203,  BBREG_0x81c, 0x00660203,  BBREG_0x81c,
	0x00680203,  BBREG_0x81c, 0x006A0203,  BBREG_0x81c, 0x006C0203,
	BBREG_0x81c, 0x006E0203,  BBREG_0x81c, 0x00700203,  BBREG_0x81c,
	0x00720203,  BBREG_0x81c, 0x00740203,  BBREG_0x81c, 0x00760203,
	BBREG_0x81c, 0x00780203,  BBREG_0x81c, 0x007A0203,  BBREG_0x81c,
	0x007C0203,  BBREG_0x81c, 0x007E0203,  0x9000000a,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x81c, 0xFC000203,  BBREG_0x81c,
	0xFB020203,  BBREG_0x81c, 0xFA040203,  BBREG_0x81c, 0xF9060203,
	BBREG_0x81c, 0xF8080203,  BBREG_0x81c, 0xF70A0203,  BBREG_0x81c,
	0xF60C0203,  BBREG_0x81c, 0xF50E0203,  BBREG_0x81c, 0xF4100203,
	BBREG_0x81c, 0xF3120203,  BBREG_0x81c, 0xF2140203,  BBREG_0x81c,
	0xF1160203,  BBREG_0x81c, 0xF0180203,  BBREG_0x81c, 0xEE1A0203,
	BBREG_0x81c, 0xED1C0203,  BBREG_0x81c, 0xEC1E0203,  BBREG_0x81c,
	0xEB200203,  BBREG_0x81c, 0xEA220203,  BBREG_0x81c, 0xE9240203,
	BBREG_0x81c, 0xE8260203,  BBREG_0x81c, 0xE7280203,  BBREG_0x81c,
	0xE62A0203,  BBREG_0x81c, 0xE52C0203,  BBREG_0x81c, 0xE42E0203,
	BBREG_0x81c, 0xE3300203,  BBREG_0x81c, 0xE2320203,  BBREG_0x81c,
	0xC6340203,  BBREG_0x81c, 0xC5360203,  BBREG_0x81c, 0xC4380203,
	BBREG_0x81c, 0xC33A0203,  BBREG_0x81c, 0xA63C0203,  BBREG_0x81c,
	0xA53E0203,  BBREG_0x81c, 0xA4400203,  BBREG_0x81c, 0xA3420203,
	BBREG_0x81c, 0xA2440203,  BBREG_0x81c, 0xA1460203,  BBREG_0x81c,
	0x83480203,  BBREG_0x81c, 0x824A0203,  BBREG_0x81c, 0x814C0203,
	BBREG_0x81c, 0x804E0203,  BBREG_0x81c, 0x63500203,  BBREG_0x81c,
	0x62520203,  BBREG_0x81c, 0x61540203,  BBREG_0x81c, 0x42560203,
	BBREG_0x81c, 0x41580203,  BBREG_0x81c, 0x405A0203,  BBREG_0x81c,
	0x225C0203,  BBREG_0x81c, 0x215E0203,  BBREG_0x81c, 0x20600203,
	BBREG_0x81c, 0x04620203,  BBREG_0x81c, 0x03640203,  BBREG_0x81c,
	0x02660203,  BBREG_0x81c, 0x01680203,  BBREG_0x81c, 0x006A0203,
	BBREG_0x81c, 0x006C0203,  BBREG_0x81c, 0x006E0203,  BBREG_0x81c,
	0x00700203,  BBREG_0x81c, 0x00720203,  BBREG_0x81c, 0x00740203,
	BBREG_0x81c, 0x00760203,  BBREG_0x81c, 0x00780203,  BBREG_0x81c,
	0x007A0203,  BBREG_0x81c, 0x007C0203,  BBREG_0x81c, 0x007E0203,
	0x9000000b,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c,
	0xF9000203,  BBREG_0x81c, 0xF8020203,  BBREG_0x81c, 0xF7040203,
	BBREG_0x81c, 0xF6060203,  BBREG_0x81c, 0xF5080203,  BBREG_0x81c,
	0xF40A0203,  BBREG_0x81c, 0xF30C0203,  BBREG_0x81c, 0xF20E0203,
	BBREG_0x81c, 0xF1100203,  BBREG_0x81c, 0xF0120203,  BBREG_0x81c,
	0xEF140203,  BBREG_0x81c, 0xEE160203,  BBREG_0x81c, 0xED180203,
	BBREG_0x81c, 0xEC1A0203,  BBREG_0x81c, 0xEB1C0203,  BBREG_0x81c,
	0xEA1E0203,  BBREG_0x81c, 0xE9200203,  BBREG_0x81c, 0xE8220203,
	BBREG_0x81c, 0xE7240203,  BBREG_0x81c, 0xE6260203,  BBREG_0x81c,
	0xE5280203,  BBREG_0x81c, 0xE42A0203,  BBREG_0x81c, 0xC42C0203,
	BBREG_0x81c, 0xC32E0203,  BBREG_0x81c, 0xC2300203,  BBREG_0x81c,
	0xC1320203,  BBREG_0x81c, 0xA3340203,  BBREG_0x81c, 0xA2360203,
	BBREG_0x81c, 0xA1380203,  BBREG_0x81c, 0xA03A0203,  BBREG_0x81c,
	0x823C0203,  BBREG_0x81c, 0x813E0203,  BBREG_0x81c, 0x80400203,
	BBREG_0x81c, 0x64420203,  BBREG_0x81c, 0x63440203,  BBREG_0x81c,
	0x62460203,  BBREG_0x81c, 0x61480203,  BBREG_0x81c, 0x604A0203,
	BBREG_0x81c, 0x244C0203,  BBREG_0x81c, 0x234E0203,  BBREG_0x81c,
	0x22500203,  BBREG_0x81c, 0x21520203,  BBREG_0x81c, 0x20540203,
	BBREG_0x81c, 0x05560203,  BBREG_0x81c, 0x04580203,  BBREG_0x81c,
	0x035A0203,  BBREG_0x81c, 0x025C0203,  BBREG_0x81c, 0x015E0203,
	BBREG_0x81c, 0x00600203,  BBREG_0x81c, 0x00620203,  BBREG_0x81c,
	0x00640203,  BBREG_0x81c, 0x00660203,  BBREG_0x81c, 0x00680203,
	BBREG_0x81c, 0x006A0203,  BBREG_0x81c, 0x006C0203,  BBREG_0x81c,
	0x006E0203,  BBREG_0x81c, 0x00700203,  BBREG_0x81c, 0x00720203,
	BBREG_0x81c, 0x00740203,  BBREG_0x81c, 0x00760203,  BBREG_0x81c,
	0x00780203,  BBREG_0x81c, 0x007A0203,  BBREG_0x81c, 0x007C0203,
	BBREG_0x81c, 0x007E0203,  0x9000000c,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x81c, 0xFC000203,  BBREG_0x81c, 0xFB020203,
	BBREG_0x81c, 0xFA040203,  BBREG_0x81c, 0xF9060203,  BBREG_0x81c,
	0xF8080203,  BBREG_0x81c, 0xF70A0203,  BBREG_0x81c, 0xF60C0203,
	BBREG_0x81c, 0xF50E0203,  BBREG_0x81c, 0xF4100203,  BBREG_0x81c,
	0xF3120203,  BBREG_0x81c, 0xF2140203,  BBREG_0x81c, 0xF1160203,
	BBREG_0x81c, 0xF0180203,  BBREG_0x81c, 0xEF1A0203,  BBREG_0x81c,
	0xEE1C0203,  BBREG_0x81c, 0xED1E0203,  BBREG_0x81c, 0xEC200203,
	BBREG_0x81c, 0xEB220203,  BBREG_0x81c, 0xEA240203,  BBREG_0x81c,
	0xE9260203,  BBREG_0x81c, 0xE8280203,  BBREG_0x81c, 0xE72A0203,
	BBREG_0x81c, 0xE62C0203,  BBREG_0x81c, 0xE52E0203,  BBREG_0x81c,
	0xE4300203,  BBREG_0x81c, 0xE3320203,  BBREG_0x81c, 0xE2340203,
	BBREG_0x81c, 0xC6360203,  BBREG_0x81c, 0xC5380203,  BBREG_0x81c,
	0xC43A0203,  BBREG_0x81c, 0xC33C0203,  BBREG_0x81c, 0xA63E0203,
	BBREG_0x81c, 0xA5400203,  BBREG_0x81c, 0xA4420203,  BBREG_0x81c,
	0xA3440203,  BBREG_0x81c, 0xA2460203,  BBREG_0x81c, 0xA1480203,
	BBREG_0x81c, 0x834A0203,  BBREG_0x81c, 0x824C0203,  BBREG_0x81c,
	0x814E0203,  BBREG_0x81c, 0x64500203,  BBREG_0x81c, 0x63520203,
	BBREG_0x81c, 0x62540203,  BBREG_0x81c, 0x61560203,  BBREG_0x81c,
	0x60580203,  BBREG_0x81c, 0x405A0203,  BBREG_0x81c, 0x215C0203,
	BBREG_0x81c, 0x205E0203,  BBREG_0x81c, 0x03600203,  BBREG_0x81c,
	0x02620203,  BBREG_0x81c, 0x01640203,  BBREG_0x81c, 0x00660203,
	BBREG_0x81c, 0x00680203,  BBREG_0x81c, 0x006A0203,  BBREG_0x81c,
	0x006C0203,  BBREG_0x81c, 0x006E0203,  BBREG_0x81c, 0x00700203,
	BBREG_0x81c, 0x00720203,  BBREG_0x81c, 0x00740203,  BBREG_0x81c,
	0x00760203,  BBREG_0x81c, 0x00780203,  BBREG_0x81c, 0x007A0203,
	BBREG_0x81c, 0x007C0203,  BBREG_0x81c, 0x007E0203,  0x9000000d,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c, 0xFC000203,
	BBREG_0x81c, 0xFB020203,  BBREG_0x81c, 0xFA040203,  BBREG_0x81c,
	0xF9060203,  BBREG_0x81c, 0xF8080203,  BBREG_0x81c, 0xF70A0203,
	BBREG_0x81c, 0xF60C0203,  BBREG_0x81c, 0xF50E0203,  BBREG_0x81c,
	0xF4100203,  BBREG_0x81c, 0xF3120203,  BBREG_0x81c, 0xF2140203,
	BBREG_0x81c, 0xF1160203,  BBREG_0x81c, 0xF0180203,  BBREG_0x81c,
	0xEE1A0203,  BBREG_0x81c, 0xED1C0203,  BBREG_0x81c, 0xEC1E0203,
	BBREG_0x81c, 0xEB200203,  BBREG_0x81c, 0xEA220203,  BBREG_0x81c,
	0xE9240203,  BBREG_0x81c, 0xE8260203,  BBREG_0x81c, 0xE7280203,
	BBREG_0x81c, 0xE62A0203,  BBREG_0x81c, 0xE52C0203,  BBREG_0x81c,
	0xE42E0203,  BBREG_0x81c, 0xE3300203,  BBREG_0x81c, 0xE2320203,
	BBREG_0x81c, 0xC6340203,  BBREG_0x81c, 0xC5360203,  BBREG_0x81c,
	0xC4380203,  BBREG_0x81c, 0xC33A0203,  BBREG_0x81c, 0xA63C0203,
	BBREG_0x81c, 0xA53E0203,  BBREG_0x81c, 0xA4400203,  BBREG_0x81c,
	0xA3420203,  BBREG_0x81c, 0xA2440203,  BBREG_0x81c, 0xA1460203,
	BBREG_0x81c, 0x83480203,  BBREG_0x81c, 0x824A0203,  BBREG_0x81c,
	0x814C0203,  BBREG_0x81c, 0x804E0203,  BBREG_0x81c, 0x63500203,
	BBREG_0x81c, 0x62520203,  BBREG_0x81c, 0x61540203,  BBREG_0x81c,
	0x42560203,  BBREG_0x81c, 0x41580203,  BBREG_0x81c, 0x405A0203,
	BBREG_0x81c, 0x225C0203,  BBREG_0x81c, 0x215E0203,  BBREG_0x81c,
	0x20600203,  BBREG_0x81c, 0x04620203,  BBREG_0x81c, 0x03640203,
	BBREG_0x81c, 0x02660203,  BBREG_0x81c, 0x01680203,  BBREG_0x81c,
	0x006A0203,  BBREG_0x81c, 0x006C0203,  BBREG_0x81c, 0x006E0203,
	BBREG_0x81c, 0x00700203,  BBREG_0x81c, 0x00720203,  BBREG_0x81c,
	0x00740203,  BBREG_0x81c, 0x00760203,  BBREG_0x81c, 0x00780203,
	BBREG_0x81c, 0x007A0203,  BBREG_0x81c, 0x007C0203,  BBREG_0x81c,
	0x007E0203,  0x9000000e,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x81c, 0xFC000203,  BBREG_0x81c, 0xFB020203,  BBREG_0x81c,
	0xFA040203,  BBREG_0x81c, 0xF9060203,  BBREG_0x81c, 0xF8080203,
	BBREG_0x81c, 0xF70A0203,  BBREG_0x81c, 0xF60C0203,  BBREG_0x81c,
	0xF50E0203,  BBREG_0x81c, 0xF4100203,  BBREG_0x81c, 0xF3120203,
	BBREG_0x81c, 0xF2140203,  BBREG_0x81c, 0xF1160203,  BBREG_0x81c,
	0xF0180203,  BBREG_0x81c, 0xEE1A0203,  BBREG_0x81c, 0xED1C0203,
	BBREG_0x81c, 0xEC1E0203,  BBREG_0x81c, 0xEB200203,  BBREG_0x81c,
	0xEA220203,  BBREG_0x81c, 0xE9240203,  BBREG_0x81c, 0xE8260203,
	BBREG_0x81c, 0xE7280203,  BBREG_0x81c, 0xE62A0203,  BBREG_0x81c,
	0xE52C0203,  BBREG_0x81c, 0xE42E0203,  BBREG_0x81c, 0xE3300203,
	BBREG_0x81c, 0xE2320203,  BBREG_0x81c, 0xC6340203,  BBREG_0x81c,
	0xC5360203,  BBREG_0x81c, 0xC4380203,  BBREG_0x81c, 0xC33A0203,
	BBREG_0x81c, 0xA63C0203,  BBREG_0x81c, 0xA53E0203,  BBREG_0x81c,
	0xA4400203,  BBREG_0x81c, 0xA3420203,  BBREG_0x81c, 0xA2440203,
	BBREG_0x81c, 0xA1460203,  BBREG_0x81c, 0x83480203,  BBREG_0x81c,
	0x824A0203,  BBREG_0x81c, 0x814C0203,  BBREG_0x81c, 0x804E0203,
	BBREG_0x81c, 0x63500203,  BBREG_0x81c, 0x62520203,  BBREG_0x81c,
	0x61540203,  BBREG_0x81c, 0x42560203,  BBREG_0x81c, 0x41580203,
	BBREG_0x81c, 0x405A0203,  BBREG_0x81c, 0x225C0203,  BBREG_0x81c,
	0x215E0203,  BBREG_0x81c, 0x20600203,  BBREG_0x81c, 0x04620203,
	BBREG_0x81c, 0x03640203,  BBREG_0x81c, 0x02660203,  BBREG_0x81c,
	0x01680203,  BBREG_0x81c, 0x006A0203,  BBREG_0x81c, 0x006C0203,
	BBREG_0x81c, 0x006E0203,  BBREG_0x81c, 0x00700203,  BBREG_0x81c,
	0x00720203,  BBREG_0x81c, 0x00740203,  BBREG_0x81c, 0x00760203,
	BBREG_0x81c, 0x00780203,  BBREG_0x81c, 0x007A0203,  BBREG_0x81c,
	0x007C0203,  BBREG_0x81c, 0x007E0203,  0x9000000f,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x81c, 0xFC000203,  BBREG_0x81c,
	0xFB020203,  BBREG_0x81c, 0xFA040203,  BBREG_0x81c, 0xF9060203,
	BBREG_0x81c, 0xF8080203,  BBREG_0x81c, 0xF70A0203,  BBREG_0x81c,
	0xF60C0203,  BBREG_0x81c, 0xF50E0203,  BBREG_0x81c, 0xF4100203,
	BBREG_0x81c, 0xF3120203,  BBREG_0x81c, 0xF2140203,  BBREG_0x81c,
	0xF1160203,  BBREG_0x81c, 0xF0180203,  BBREG_0x81c, 0xEF1A0203,
	BBREG_0x81c, 0xEE1C0203,  BBREG_0x81c, 0xED1E0203,  BBREG_0x81c,
	0xEC200203,  BBREG_0x81c, 0xEB220203,  BBREG_0x81c, 0xEA240203,
	BBREG_0x81c, 0xE9260203,  BBREG_0x81c, 0xE8280203,  BBREG_0x81c,
	0xE72A0203,  BBREG_0x81c, 0xE62C0203,  BBREG_0x81c, 0xE52E0203,
	BBREG_0x81c, 0xE4300203,  BBREG_0x81c, 0xE3320203,  BBREG_0x81c,
	0xE2340203,  BBREG_0x81c, 0xE1360203,  BBREG_0x81c, 0xE0380203,
	BBREG_0x81c, 0xC33A0203,  BBREG_0x81c, 0xC23C0203,  BBREG_0x81c,
	0xC13E0203,  BBREG_0x81c, 0xA3400203,  BBREG_0x81c, 0xA2420203,
	BBREG_0x81c, 0xA1440203,  BBREG_0x81c, 0xA0460203,  BBREG_0x81c,
	0x83480203,  BBREG_0x81c, 0x824A0203,  BBREG_0x81c, 0x814C0203,
	BBREG_0x81c, 0x644E0203,  BBREG_0x81c, 0x63500203,  BBREG_0x81c,
	0x62520203,  BBREG_0x81c, 0x61540203,  BBREG_0x81c, 0x42560203,
	BBREG_0x81c, 0x41580203,  BBREG_0x81c, 0x235A0203,  BBREG_0x81c,
	0x225C0203,  BBREG_0x81c, 0x215E0203,  BBREG_0x81c, 0x04600203,
	BBREG_0x81c, 0x03620203,  BBREG_0x81c, 0x02640203,  BBREG_0x81c,
	0x01660203,  BBREG_0x81c, 0x00680203,  BBREG_0x81c, 0x006A0203,
	BBREG_0x81c, 0x006C0203,  BBREG_0x81c, 0x006E0203,  BBREG_0x81c,
	0x00700203,  BBREG_0x81c, 0x00720203,  BBREG_0x81c, 0x00740203,
	BBREG_0x81c, 0x00760203,  BBREG_0x81c, 0x00780203,  BBREG_0x81c,
	0x007A0203,  BBREG_0x81c, 0x007C0203,  BBREG_0x81c, 0x007E0203,
	0x90000010,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c,
	0xFC000203,  BBREG_0x81c, 0xFB020203,  BBREG_0x81c, 0xFA040203,
	BBREG_0x81c, 0xF9060203,  BBREG_0x81c, 0xF8080203,  BBREG_0x81c,
	0xF70A0203,  BBREG_0x81c, 0xF60C0203,  BBREG_0x81c, 0xF50E0203,
	BBREG_0x81c, 0xF4100203,  BBREG_0x81c, 0xF3120203,  BBREG_0x81c,
	0xF2140203,  BBREG_0x81c, 0xF1160203,  BBREG_0x81c, 0xF0180203,
	BBREG_0x81c, 0xEF1A0203,  BBREG_0x81c, 0xEE1C0203,  BBREG_0x81c,
	0xED1E0203,  BBREG_0x81c, 0xEC200203,  BBREG_0x81c, 0xEB220203,
	BBREG_0x81c, 0xEA240203,  BBREG_0x81c, 0xE9260203,  BBREG_0x81c,
	0xE8280203,  BBREG_0x81c, 0xE72A0203,  BBREG_0x81c, 0xE62C0203,
	BBREG_0x81c, 0xE52E0203,  BBREG_0x81c, 0xE4300203,  BBREG_0x81c,
	0xE3320203,  BBREG_0x81c, 0xE2340203,  BBREG_0x81c, 0xC6360203,
	BBREG_0x81c, 0xC5380203,  BBREG_0x81c, 0xC43A0203,  BBREG_0x81c,
	0xC33C0203,  BBREG_0x81c, 0xA63E0203,  BBREG_0x81c, 0xA5400203,
	BBREG_0x81c, 0xA4420203,  BBREG_0x81c, 0xA3440203,  BBREG_0x81c,
	0xA2460203,  BBREG_0x81c, 0xA1480203,  BBREG_0x81c, 0x834A0203,
	BBREG_0x81c, 0x824C0203,  BBREG_0x81c, 0x814E0203,  BBREG_0x81c,
	0x64500203,  BBREG_0x81c, 0x63520203,  BBREG_0x81c, 0x62540203,
	BBREG_0x81c, 0x61560203,  BBREG_0x81c, 0x60580203,  BBREG_0x81c,
	0x405A0203,  BBREG_0x81c, 0x215C0203,  BBREG_0x81c, 0x205E0203,
	BBREG_0x81c, 0x03600203,  BBREG_0x81c, 0x02620203,  BBREG_0x81c,
	0x01640203,  BBREG_0x81c, 0x00660203,  BBREG_0x81c, 0x00680203,
	BBREG_0x81c, 0x006A0203,  BBREG_0x81c, 0x006C0203,  BBREG_0x81c,
	0x006E0203,  BBREG_0x81c, 0x00700203,  BBREG_0x81c, 0x00720203,
	BBREG_0x81c, 0x00740203,  BBREG_0x81c, 0x00760203,  BBREG_0x81c,
	0x00780203,  BBREG_0x81c, 0x007A0203,  BBREG_0x81c, 0x007C0203,
	BBREG_0x81c, 0x007E0203,  0xA0000000,  0x00000000,  BBREG_0x81c,
	0xFD000203,  BBREG_0x81c, 0xFC020203,  BBREG_0x81c, 0xFB040203,
	BBREG_0x81c, 0xFA060203,  BBREG_0x81c, 0xF9080203,  BBREG_0x81c,
	0xF80A0203,  BBREG_0x81c, 0xF70C0203,  BBREG_0x81c, 0xF60E0203,
	BBREG_0x81c, 0xF5100203,  BBREG_0x81c, 0xF4120203,  BBREG_0x81c,
	0xF3140203,  BBREG_0x81c, 0xF2160203,  BBREG_0x81c, 0xF1180203,
	BBREG_0x81c, 0xF01A0203,  BBREG_0x81c, 0xEF1C0203,  BBREG_0x81c,
	0xEE1E0203,  BBREG_0x81c, 0xED200203,  BBREG_0x81c, 0xEC220203,
	BBREG_0x81c, 0xEB240203,  BBREG_0x81c, 0xEA260203,  BBREG_0x81c,
	0xE9280203,  BBREG_0x81c, 0xE82A0203,  BBREG_0x81c, 0xE72C0203,
	BBREG_0x81c, 0xE62E0203,  BBREG_0x81c, 0xE5300203,  BBREG_0x81c,
	0xE4320203,  BBREG_0x81c, 0xE3340203,  BBREG_0x81c, 0xC6360203,
	BBREG_0x81c, 0xC5380203,  BBREG_0x81c, 0xC43A0203,  BBREG_0x81c,
	0xC33C0203,  BBREG_0x81c, 0xA63E0203,  BBREG_0x81c, 0xA5400203,
	BBREG_0x81c, 0xA4420203,  BBREG_0x81c, 0xA3440203,  BBREG_0x81c,
	0xA2460203,  BBREG_0x81c, 0xA1480203,  BBREG_0x81c, 0x834A0203,
	BBREG_0x81c, 0x824C0203,  BBREG_0x81c, 0x814E0203,  BBREG_0x81c,
	0x64500203,  BBREG_0x81c, 0x63520203,  BBREG_0x81c, 0x62540203,
	BBREG_0x81c, 0x61560203,  BBREG_0x81c, 0x60580203,  BBREG_0x81c,
	0x235A0203,  BBREG_0x81c, 0x225C0203,  BBREG_0x81c, 0x215E0203,
	BBREG_0x81c, 0x20600203,  BBREG_0x81c, 0x03620203,  BBREG_0x81c,
	0x02640203,  BBREG_0x81c, 0x01660203,  BBREG_0x81c, 0x00680203,
	BBREG_0x81c, 0x006A0203,  BBREG_0x81c, 0x006C0203,  BBREG_0x81c,
	0x006E0203,  BBREG_0x81c, 0x00700203,  BBREG_0x81c, 0x00720203,
	BBREG_0x81c, 0x00740203,  BBREG_0x81c, 0x00760203,  BBREG_0x81c,
	0x00780203,  BBREG_0x81c, 0x007A0203,  BBREG_0x81c, 0x007C0203,
	BBREG_0x81c, 0x007E0203,  0xB0000000,  0x00000000,  0x80000000,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c, 0xFC000303,
	BBREG_0x81c, 0xFB020303,  BBREG_0x81c, 0xFA040303,  BBREG_0x81c,
	0xF9060303,  BBREG_0x81c, 0xF8080303,  BBREG_0x81c, 0xF70A0303,
	BBREG_0x81c, 0xF60C0303,  BBREG_0x81c, 0xF50E0303,  BBREG_0x81c,
	0xF4100303,  BBREG_0x81c, 0xF3120303,  BBREG_0x81c, 0xF2140303,
	BBREG_0x81c, 0xF1160303,  BBREG_0x81c, 0xEF180303,  BBREG_0x81c,
	0xEE1A0303,  BBREG_0x81c, 0xED1C0303,  BBREG_0x81c, 0xEC1E0303,
	BBREG_0x81c, 0xEB200303,  BBREG_0x81c, 0xEA220303,  BBREG_0x81c,
	0xE9240303,  BBREG_0x81c, 0xE8260303,  BBREG_0x81c, 0xE7280303,
	BBREG_0x81c, 0xE62A0303,  BBREG_0x81c, 0xE52C0303,  BBREG_0x81c,
	0xE42E0303,  BBREG_0x81c, 0xE3300303,  BBREG_0x81c, 0xE2320303,
	BBREG_0x81c, 0xC6340303,  BBREG_0x81c, 0xC5360303,  BBREG_0x81c,
	0xC4380303,  BBREG_0x81c, 0xC33A0303,  BBREG_0x81c, 0xA63C0303,
	BBREG_0x81c, 0xA53E0303,  BBREG_0x81c, 0xA4400303,  BBREG_0x81c,
	0xA3420303,  BBREG_0x81c, 0xA2440303,  BBREG_0x81c, 0xA1460303,
	BBREG_0x81c, 0x83480303,  BBREG_0x81c, 0x824A0303,  BBREG_0x81c,
	0x814C0303,  BBREG_0x81c, 0x804E0303,  BBREG_0x81c, 0x63500303,
	BBREG_0x81c, 0x62520303,  BBREG_0x81c, 0x61540303,  BBREG_0x81c,
	0x42560303,  BBREG_0x81c, 0x41580303,  BBREG_0x81c, 0x405A0303,
	BBREG_0x81c, 0x225C0303,  BBREG_0x81c, 0x215E0303,  BBREG_0x81c,
	0x20600303,  BBREG_0x81c, 0x04620303,  BBREG_0x81c, 0x03640303,
	BBREG_0x81c, 0x02660303,  BBREG_0x81c, 0x01680303,  BBREG_0x81c,
	0x006A0303,  BBREG_0x81c, 0x006C0303,  BBREG_0x81c, 0x006E0303,
	BBREG_0x81c, 0x00700303,  BBREG_0x81c, 0x00720303,  BBREG_0x81c,
	0x00740303,  BBREG_0x81c, 0x00760303,  BBREG_0x81c, 0x00780303,
	BBREG_0x81c, 0x007A0303,  BBREG_0x81c, 0x007C0303,  BBREG_0x81c,
	0x007E0303,  0x90000001,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x81c, 0xF7000303,  BBREG_0x81c, 0xF6020303,  BBREG_0x81c,
	0xF5040303,  BBREG_0x81c, 0xF4060303,  BBREG_0x81c, 0xF3080303,
	BBREG_0x81c, 0xF20A0303,  BBREG_0x81c, 0xF10C0303,  BBREG_0x81c,
	0xF00E0303,  BBREG_0x81c, 0xEF100303,  BBREG_0x81c, 0xEE120303,
	BBREG_0x81c, 0xED140303,  BBREG_0x81c, 0xEC160303,  BBREG_0x81c,
	0xEB180303,  BBREG_0x81c, 0xEA1A0303,  BBREG_0x81c, 0xE91C0303,
	BBREG_0x81c, 0xCA1E0303,  BBREG_0x81c, 0xC9200303,  BBREG_0x81c,
	0xC8220303,  BBREG_0x81c, 0xC7240303,  BBREG_0x81c, 0xC6260303,
	BBREG_0x81c, 0xC5280303,  BBREG_0x81c, 0xC42A0303,  BBREG_0x81c,
	0xC32C0303,  BBREG_0x81c, 0xC22E0303,  BBREG_0x81c, 0xC1300303,
	BBREG_0x81c, 0xA4320303,  BBREG_0x81c, 0xA3340303,  BBREG_0x81c,
	0xA2360303,  BBREG_0x81c, 0xA1380303,  BBREG_0x81c, 0xA03A0303,
	BBREG_0x81c, 0x823C0303,  BBREG_0x81c, 0x813E0303,  BBREG_0x81c,
	0x80400303,  BBREG_0x81c, 0x64420303,  BBREG_0x81c, 0x63440303,
	BBREG_0x81c, 0x62460303,  BBREG_0x81c, 0x61480303,  BBREG_0x81c,
	0x604A0303,  BBREG_0x81c, 0x414C0303,  BBREG_0x81c, 0x404E0303,
	BBREG_0x81c, 0x06500303,  BBREG_0x81c, 0x05520303,  BBREG_0x81c,
	0x04540303,  BBREG_0x81c, 0x03560303,  BBREG_0x81c, 0x02580303,
	BBREG_0x81c, 0x015A0303,  BBREG_0x81c, 0x005C0303,  BBREG_0x81c,
	0x005E0303,  BBREG_0x81c, 0x00600303,  BBREG_0x81c, 0x00620303,
	BBREG_0x81c, 0x00640303,  BBREG_0x81c, 0x00660303,  BBREG_0x81c,
	0x00680303,  BBREG_0x81c, 0x006A0303,  BBREG_0x81c, 0x006C0303,
	BBREG_0x81c, 0x006E0303,  BBREG_0x81c, 0x00700303,  BBREG_0x81c,
	0x00720303,  BBREG_0x81c, 0x00740303,  BBREG_0x81c, 0x00760303,
	BBREG_0x81c, 0x00780303,  BBREG_0x81c, 0x007A0303,  BBREG_0x81c,
	0x007C0303,  BBREG_0x81c, 0x007E0303,  0x90000002,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x81c, 0xF7000303,  BBREG_0x81c,
	0xF6020303,  BBREG_0x81c, 0xF5040303,  BBREG_0x81c, 0xF4060303,
	BBREG_0x81c, 0xF3080303,  BBREG_0x81c, 0xF20A0303,  BBREG_0x81c,
	0xF10C0303,  BBREG_0x81c, 0xF00E0303,  BBREG_0x81c, 0xEF100303,
	BBREG_0x81c, 0xEE120303,  BBREG_0x81c, 0xED140303,  BBREG_0x81c,
	0xEC160303,  BBREG_0x81c, 0xEB180303,  BBREG_0x81c, 0xEA1A0303,
	BBREG_0x81c, 0xE91C0303,  BBREG_0x81c, 0xCA1E0303,  BBREG_0x81c,
	0xC9200303,  BBREG_0x81c, 0xC8220303,  BBREG_0x81c, 0xC7240303,
	BBREG_0x81c, 0xC6260303,  BBREG_0x81c, 0xC5280303,  BBREG_0x81c,
	0xC42A0303,  BBREG_0x81c, 0xC32C0303,  BBREG_0x81c, 0xC22E0303,
	BBREG_0x81c, 0xC1300303,  BBREG_0x81c, 0xA4320303,  BBREG_0x81c,
	0xA3340303,  BBREG_0x81c, 0xA2360303,  BBREG_0x81c, 0xA1380303,
	BBREG_0x81c, 0xA03A0303,  BBREG_0x81c, 0x823C0303,  BBREG_0x81c,
	0x813E0303,  BBREG_0x81c, 0x80400303,  BBREG_0x81c, 0x64420303,
	BBREG_0x81c, 0x63440303,  BBREG_0x81c, 0x62460303,  BBREG_0x81c,
	0x61480303,  BBREG_0x81c, 0x604A0303,  BBREG_0x81c, 0x414C0303,
	BBREG_0x81c, 0x404E0303,  BBREG_0x81c, 0x22500303,  BBREG_0x81c,
	0x21520303,  BBREG_0x81c, 0x20540303,  BBREG_0x81c, 0x03560303,
	BBREG_0x81c, 0x02580303,  BBREG_0x81c, 0x015A0303,  BBREG_0x81c,
	0x005C0303,  BBREG_0x81c, 0x005E0303,  BBREG_0x81c, 0x00600303,
	BBREG_0x81c, 0x00620303,  BBREG_0x81c, 0x00640303,  BBREG_0x81c,
	0x00660303,  BBREG_0x81c, 0x00680303,  BBREG_0x81c, 0x006A0303,
	BBREG_0x81c, 0x006C0303,  BBREG_0x81c, 0x006E0303,  BBREG_0x81c,
	0x00700303,  BBREG_0x81c, 0x00720303,  BBREG_0x81c, 0x00740303,
	BBREG_0x81c, 0x00760303,  BBREG_0x81c, 0x00780303,  BBREG_0x81c,
	0x007A0303,  BBREG_0x81c, 0x007C0303,  BBREG_0x81c, 0x007E0303,
	0x90000003,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c,
	0xFC000303,  BBREG_0x81c, 0xFB020303,  BBREG_0x81c, 0xFA040303,
	BBREG_0x81c, 0xF9060303,  BBREG_0x81c, 0xF8080303,  BBREG_0x81c,
	0xF70A0303,  BBREG_0x81c, 0xF60C0303,  BBREG_0x81c, 0xF50E0303,
	BBREG_0x81c, 0xF4100303,  BBREG_0x81c, 0xF3120303,  BBREG_0x81c,
	0xF2140303,  BBREG_0x81c, 0xF1160303,  BBREG_0x81c, 0xF0180303,
	BBREG_0x81c, 0xEF1A0303,  BBREG_0x81c, 0xEE1C0303,  BBREG_0x81c,
	0xED1E0303,  BBREG_0x81c, 0xEC200303,  BBREG_0x81c, 0xEB220303,
	BBREG_0x81c, 0xEA240303,  BBREG_0x81c, 0xE9260303,  BBREG_0x81c,
	0xE8280303,  BBREG_0x81c, 0xE72A0303,  BBREG_0x81c, 0xE62C0303,
	BBREG_0x81c, 0xE52E0303,  BBREG_0x81c, 0xE4300303,  BBREG_0x81c,
	0xE3320303,  BBREG_0x81c, 0xE2340303,  BBREG_0x81c, 0xC6360303,
	BBREG_0x81c, 0xC5380303,  BBREG_0x81c, 0xC43A0303,  BBREG_0x81c,
	0xC33C0303,  BBREG_0x81c, 0xA63E0303,  BBREG_0x81c, 0xA5400303,
	BBREG_0x81c, 0xA4420303,  BBREG_0x81c, 0xA3440303,  BBREG_0x81c,
	0xA2460303,  BBREG_0x81c, 0x84480303,  BBREG_0x81c, 0x834A0303,
	BBREG_0x81c, 0x824C0303,  BBREG_0x81c, 0x814E0303,  BBREG_0x81c,
	0x80500303,  BBREG_0x81c, 0x63520303,  BBREG_0x81c, 0x62540303,
	BBREG_0x81c, 0x61560303,  BBREG_0x81c, 0x60580303,  BBREG_0x81c,
	0x225A0303,  BBREG_0x81c, 0x055C0303,  BBREG_0x81c, 0x045E0303,
	BBREG_0x81c, 0x03600303,  BBREG_0x81c, 0x02620303,  BBREG_0x81c,
	0x01640303,  BBREG_0x81c, 0x00660303,  BBREG_0x81c, 0x00680303,
	BBREG_0x81c, 0x006A0303,  BBREG_0x81c, 0x006C0303,  BBREG_0x81c,
	0x006E0303,  BBREG_0x81c, 0x00700303,  BBREG_0x81c, 0x00720303,
	BBREG_0x81c, 0x00740303,  BBREG_0x81c, 0x00760303,  BBREG_0x81c,
	0x00780303,  BBREG_0x81c, 0x007A0303,  BBREG_0x81c, 0x007C0303,
	BBREG_0x81c, 0x007E0303,  0x90000004,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x81c, 0xF7000303,  BBREG_0x81c, 0xF6020303,
	BBREG_0x81c, 0xF5040303,  BBREG_0x81c, 0xF4060303,  BBREG_0x81c,
	0xF3080303,  BBREG_0x81c, 0xF20A0303,  BBREG_0x81c, 0xF10C0303,
	BBREG_0x81c, 0xF00E0303,  BBREG_0x81c, 0xEF100303,  BBREG_0x81c,
	0xEE120303,  BBREG_0x81c, 0xED140303,  BBREG_0x81c, 0xEC160303,
	BBREG_0x81c, 0xEB180303,  BBREG_0x81c, 0xEA1A0303,  BBREG_0x81c,
	0xE91C0303,  BBREG_0x81c, 0xCA1E0303,  BBREG_0x81c, 0xC9200303,
	BBREG_0x81c, 0xC8220303,  BBREG_0x81c, 0xC7240303,  BBREG_0x81c,
	0xC6260303,  BBREG_0x81c, 0xC5280303,  BBREG_0x81c, 0xC42A0303,
	BBREG_0x81c, 0xC32C0303,  BBREG_0x81c, 0xC22E0303,  BBREG_0x81c,
	0xC1300303,  BBREG_0x81c, 0xA4320303,  BBREG_0x81c, 0xA3340303,
	BBREG_0x81c, 0xA2360303,  BBREG_0x81c, 0xA1380303,  BBREG_0x81c,
	0xA03A0303,  BBREG_0x81c, 0x823C0303,  BBREG_0x81c, 0x813E0303,
	BBREG_0x81c, 0x80400303,  BBREG_0x81c, 0x64420303,  BBREG_0x81c,
	0x63440303,  BBREG_0x81c, 0x62460303,  BBREG_0x81c, 0x61480303,
	BBREG_0x81c, 0x604A0303,  BBREG_0x81c, 0x414C0303,  BBREG_0x81c,
	0x404E0303,  BBREG_0x81c, 0x22500303,  BBREG_0x81c, 0x21520303,
	BBREG_0x81c, 0x20540303,  BBREG_0x81c, 0x03560303,  BBREG_0x81c,
	0x02580303,  BBREG_0x81c, 0x015A0303,  BBREG_0x81c, 0x005C0303,
	BBREG_0x81c, 0x005E0303,  BBREG_0x81c, 0x00600303,  BBREG_0x81c,
	0x00620303,  BBREG_0x81c, 0x00640303,  BBREG_0x81c, 0x00660303,
	BBREG_0x81c, 0x00680303,  BBREG_0x81c, 0x006A0303,  BBREG_0x81c,
	0x006C0303,  BBREG_0x81c, 0x006E0303,  BBREG_0x81c, 0x00700303,
	BBREG_0x81c, 0x00720303,  BBREG_0x81c, 0x00740303,  BBREG_0x81c,
	0x00760303,  BBREG_0x81c, 0x00780303,  BBREG_0x81c, 0x007A0303,
	BBREG_0x81c, 0x007C0303,  BBREG_0x81c, 0x007E0303,  0x90000005,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c, 0xFB000303,
	BBREG_0x81c, 0xFA020303,  BBREG_0x81c, 0xF9040303,  BBREG_0x81c,
	0xF8060303,  BBREG_0x81c, 0xF7080303,  BBREG_0x81c, 0xF60A0303,
	BBREG_0x81c, 0xF50C0303,  BBREG_0x81c, 0xF40E0303,  BBREG_0x81c,
	0xF3100303,  BBREG_0x81c, 0xF2120303,  BBREG_0x81c, 0xF1140303,
	BBREG_0x81c, 0xF0160303,  BBREG_0x81c, 0xEF180303,  BBREG_0x81c,
	0xEE1A0303,  BBREG_0x81c, 0xED1C0303,  BBREG_0x81c, 0xEC1E0303,
	BBREG_0x81c, 0xEB200303,  BBREG_0x81c, 0xEA220303,  BBREG_0x81c,
	0xE9240303,  BBREG_0x81c, 0xE8260303,  BBREG_0x81c, 0xE7280303,
	BBREG_0x81c, 0xE62A0303,  BBREG_0x81c, 0xE52C0303,  BBREG_0x81c,
	0xE42E0303,  BBREG_0x81c, 0xE3300303,  BBREG_0x81c, 0xE2320303,
	BBREG_0x81c, 0xE1340303,  BBREG_0x81c, 0xC5360303,  BBREG_0x81c,
	0xC4380303,  BBREG_0x81c, 0xC33A0303,  BBREG_0x81c, 0xC23C0303,
	BBREG_0x81c, 0xC13E0303,  BBREG_0x81c, 0xA4400303,  BBREG_0x81c,
	0xA3420303,  BBREG_0x81c, 0xA2440303,  BBREG_0x81c, 0xA1460303,
	BBREG_0x81c, 0x83480303,  BBREG_0x81c, 0x824A0303,  BBREG_0x81c,
	0x814C0303,  BBREG_0x81c, 0x804E0303,  BBREG_0x81c, 0x64500303,
	BBREG_0x81c, 0x63520303,  BBREG_0x81c, 0x62540303,  BBREG_0x81c,
	0x61560303,  BBREG_0x81c, 0x60580303,  BBREG_0x81c, 0x235A0303,
	BBREG_0x81c, 0x225C0303,  BBREG_0x81c, 0x215E0303,  BBREG_0x81c,
	0x20600303,  BBREG_0x81c, 0x04620303,  BBREG_0x81c, 0x03640303,
	BBREG_0x81c, 0x02660303,  BBREG_0x81c, 0x01680303,  BBREG_0x81c,
	0x006A0303,  BBREG_0x81c, 0x006C0303,  BBREG_0x81c, 0x006E0303,
	BBREG_0x81c, 0x00700303,  BBREG_0x81c, 0x00720303,  BBREG_0x81c,
	0x00740303,  BBREG_0x81c, 0x00760303,  BBREG_0x81c, 0x00780303,
	BBREG_0x81c, 0x007A0303,  BBREG_0x81c, 0x007C0303,  BBREG_0x81c,
	0x007E0303,  0x90000006,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x81c, 0xF9000303,  BBREG_0x81c, 0xF8020303,  BBREG_0x81c,
	0xF7040303,  BBREG_0x81c, 0xF6060303,  BBREG_0x81c, 0xF5080303,
	BBREG_0x81c, 0xF40A0303,  BBREG_0x81c, 0xF30C0303,  BBREG_0x81c,
	0xF20E0303,  BBREG_0x81c, 0xF1100303,  BBREG_0x81c, 0xF0120303,
	BBREG_0x81c, 0xEF140303,  BBREG_0x81c, 0xEE160303,  BBREG_0x81c,
	0xED180303,  BBREG_0x81c, 0xEC1A0303,  BBREG_0x81c, 0xEB1C0303,
	BBREG_0x81c, 0xEA1E0303,  BBREG_0x81c, 0xC9200303,  BBREG_0x81c,
	0xC8220303,  BBREG_0x81c, 0xC7240303,  BBREG_0x81c, 0xC6260303,
	BBREG_0x81c, 0xC5280303,  BBREG_0x81c, 0xC42A0303,  BBREG_0x81c,
	0xC32C0303,  BBREG_0x81c, 0xC22E0303,  BBREG_0x81c, 0xC1300303,
	BBREG_0x81c, 0xC0320303,  BBREG_0x81c, 0xA3340303,  BBREG_0x81c,
	0xA2360303,  BBREG_0x81c, 0xA1380303,  BBREG_0x81c, 0xA03A0303,
	BBREG_0x81c, 0x823C0303,  BBREG_0x81c, 0x813E0303,  BBREG_0x81c,
	0x80400303,  BBREG_0x81c, 0x64420303,  BBREG_0x81c, 0x63440303,
	BBREG_0x81c, 0x62460303,  BBREG_0x81c, 0x61480303,  BBREG_0x81c,
	0x604A0303,  BBREG_0x81c, 0x414C0303,  BBREG_0x81c, 0x404E0303,
	BBREG_0x81c, 0x22500303,  BBREG_0x81c, 0x21520303,  BBREG_0x81c,
	0x20540303,  BBREG_0x81c, 0x03560303,  BBREG_0x81c, 0x02580303,
	BBREG_0x81c, 0x015A0303,  BBREG_0x81c, 0x005C0303,  BBREG_0x81c,
	0x005E0303,  BBREG_0x81c, 0x00600303,  BBREG_0x81c, 0x00620303,
	BBREG_0x81c, 0x00640303,  BBREG_0x81c, 0x00660303,  BBREG_0x81c,
	0x00680303,  BBREG_0x81c, 0x006A0303,  BBREG_0x81c, 0x006C0303,
	BBREG_0x81c, 0x006E0303,  BBREG_0x81c, 0x00700303,  BBREG_0x81c,
	0x00720303,  BBREG_0x81c, 0x00740303,  BBREG_0x81c, 0x00760303,
	BBREG_0x81c, 0x00780303,  BBREG_0x81c, 0x007A0303,  BBREG_0x81c,
	0x007C0303,  BBREG_0x81c, 0x007E0303,  0x90000007,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x81c, 0xF8000303,  BBREG_0x81c,
	0xF7020303,  BBREG_0x81c, 0xF6040303,  BBREG_0x81c, 0xF5060303,
	BBREG_0x81c, 0xF4080303,  BBREG_0x81c, 0xF30A0303,  BBREG_0x81c,
	0xF20C0303,  BBREG_0x81c, 0xF10E0303,  BBREG_0x81c, 0xF0100303,
	BBREG_0x81c, 0xEF120303,  BBREG_0x81c, 0xEE140303,  BBREG_0x81c,
	0xED160303,  BBREG_0x81c, 0xEC180303,  BBREG_0x81c, 0xEB1A0303,
	BBREG_0x81c, 0xEA1C0303,  BBREG_0x81c, 0xE91E0303,  BBREG_0x81c,
	0xCA200303,  BBREG_0x81c, 0xC9220303,  BBREG_0x81c, 0xC8240303,
	BBREG_0x81c, 0xC7260303,  BBREG_0x81c, 0xC6280303,  BBREG_0x81c,
	0xC52A0303,  BBREG_0x81c, 0xC42C0303,  BBREG_0x81c, 0xC32E0303,
	BBREG_0x81c, 0xC2300303,  BBREG_0x81c, 0xC1320303,  BBREG_0x81c,
	0xA3340303,  BBREG_0x81c, 0xA2360303,  BBREG_0x81c, 0xA1380303,
	BBREG_0x81c, 0xA03A0303,  BBREG_0x81c, 0x823C0303,  BBREG_0x81c,
	0x813E0303,  BBREG_0x81c, 0x80400303,  BBREG_0x81c, 0x65420303,
	BBREG_0x81c, 0x64440303,  BBREG_0x81c, 0x63460303,  BBREG_0x81c,
	0x62480303,  BBREG_0x81c, 0x614A0303,  BBREG_0x81c, 0x424C0303,
	BBREG_0x81c, 0x414E0303,  BBREG_0x81c, 0x40500303,  BBREG_0x81c,
	0x22520303,  BBREG_0x81c, 0x21540303,  BBREG_0x81c, 0x20560303,
	BBREG_0x81c, 0x04580303,  BBREG_0x81c, 0x035A0303,  BBREG_0x81c,
	0x025C0303,  BBREG_0x81c, 0x015E0303,  BBREG_0x81c, 0x00600303,
	BBREG_0x81c, 0x00620303,  BBREG_0x81c, 0x00640303,  BBREG_0x81c,
	0x00660303,  BBREG_0x81c, 0x00680303,  BBREG_0x81c, 0x006A0303,
	BBREG_0x81c, 0x006C0303,  BBREG_0x81c, 0x006E0303,  BBREG_0x81c,
	0x00700303,  BBREG_0x81c, 0x00720303,  BBREG_0x81c, 0x00740303,
	BBREG_0x81c, 0x00760303,  BBREG_0x81c, 0x00780303,  BBREG_0x81c,
	0x007A0303,  BBREG_0x81c, 0x007C0303,  BBREG_0x81c, 0x007E0303,
	0x90000008,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c,
	0xFB000303,  BBREG_0x81c, 0xFA020303,  BBREG_0x81c, 0xF9040303,
	BBREG_0x81c, 0xF8060303,  BBREG_0x81c, 0xF7080303,  BBREG_0x81c,
	0xF60A0303,  BBREG_0x81c, 0xF50C0303,  BBREG_0x81c, 0xF40E0303,
	BBREG_0x81c, 0xF3100303,  BBREG_0x81c, 0xF2120303,  BBREG_0x81c,
	0xF1140303,  BBREG_0x81c, 0xF0160303,  BBREG_0x81c, 0xEF180303,
	BBREG_0x81c, 0xEE1A0303,  BBREG_0x81c, 0xED1C0303,  BBREG_0x81c,
	0xEC1E0303,  BBREG_0x81c, 0xEB200303,  BBREG_0x81c, 0xEA220303,
	BBREG_0x81c, 0xE9240303,  BBREG_0x81c, 0xE8260303,  BBREG_0x81c,
	0xE7280303,  BBREG_0x81c, 0xE62A0303,  BBREG_0x81c, 0xE52C0303,
	BBREG_0x81c, 0xE42E0303,  BBREG_0x81c, 0xE3300303,  BBREG_0x81c,
	0xE2320303,  BBREG_0x81c, 0xC6340303,  BBREG_0x81c, 0xC5360303,
	BBREG_0x81c, 0xC4380303,  BBREG_0x81c, 0xC33A0303,  BBREG_0x81c,
	0xC23C0303,  BBREG_0x81c, 0xC13E0303,  BBREG_0x81c, 0xA4400303,
	BBREG_0x81c, 0xA3420303,  BBREG_0x81c, 0xA2440303,  BBREG_0x81c,
	0xA1460303,  BBREG_0x81c, 0x83480303,  BBREG_0x81c, 0x824A0303,
	BBREG_0x81c, 0x814C0303,  BBREG_0x81c, 0x804E0303,  BBREG_0x81c,
	0x63500303,  BBREG_0x81c, 0x62520303,  BBREG_0x81c, 0x43540303,
	BBREG_0x81c, 0x42560303,  BBREG_0x81c, 0x41580303,  BBREG_0x81c,
	0x235A0303,  BBREG_0x81c, 0x225C0303,  BBREG_0x81c, 0x215E0303,
	BBREG_0x81c, 0x20600303,  BBREG_0x81c, 0x04620303,  BBREG_0x81c,
	0x03640303,  BBREG_0x81c, 0x02660303,  BBREG_0x81c, 0x01680303,
	BBREG_0x81c, 0x006A0303,  BBREG_0x81c, 0x006C0303,  BBREG_0x81c,
	0x006E0303,  BBREG_0x81c, 0x00700303,  BBREG_0x81c, 0x00720303,
	BBREG_0x81c, 0x00740303,  BBREG_0x81c, 0x00760303,  BBREG_0x81c,
	0x00780303,  BBREG_0x81c, 0x007A0303,  BBREG_0x81c, 0x007C0303,
	BBREG_0x81c, 0x007E0303,  0x90000009,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x81c, 0xF8000303,  BBREG_0x81c, 0xF7020303,
	BBREG_0x81c, 0xF6040303,  BBREG_0x81c, 0xF5060303,  BBREG_0x81c,
	0xF4080303,  BBREG_0x81c, 0xF30A0303,  BBREG_0x81c, 0xF20C0303,
	BBREG_0x81c, 0xF10E0303,  BBREG_0x81c, 0xF0100303,  BBREG_0x81c,
	0xEF120303,  BBREG_0x81c, 0xEE140303,  BBREG_0x81c, 0xED160303,
	BBREG_0x81c, 0xEC180303,  BBREG_0x81c, 0xEB1A0303,  BBREG_0x81c,
	0xEA1C0303,  BBREG_0x81c, 0xE91E0303,  BBREG_0x81c, 0xCA200303,
	BBREG_0x81c, 0xC9220303,  BBREG_0x81c, 0xC8240303,  BBREG_0x81c,
	0xC7260303,  BBREG_0x81c, 0xC6280303,  BBREG_0x81c, 0xC52A0303,
	BBREG_0x81c, 0xC42C0303,  BBREG_0x81c, 0xC32E0303,  BBREG_0x81c,
	0xC2300303,  BBREG_0x81c, 0xC1320303,  BBREG_0x81c, 0xA3340303,
	BBREG_0x81c, 0xA2360303,  BBREG_0x81c, 0xA1380303,  BBREG_0x81c,
	0xA03A0303,  BBREG_0x81c, 0x823C0303,  BBREG_0x81c, 0x813E0303,
	BBREG_0x81c, 0x80400303,  BBREG_0x81c, 0x65420303,  BBREG_0x81c,
	0x64440303,  BBREG_0x81c, 0x63460303,  BBREG_0x81c, 0x62480303,
	BBREG_0x81c, 0x614A0303,  BBREG_0x81c, 0x424C0303,  BBREG_0x81c,
	0x414E0303,  BBREG_0x81c, 0x40500303,  BBREG_0x81c, 0x22520303,
	BBREG_0x81c, 0x21540303,  BBREG_0x81c, 0x20560303,  BBREG_0x81c,
	0x04580303,  BBREG_0x81c, 0x035A0303,  BBREG_0x81c, 0x025C0303,
	BBREG_0x81c, 0x015E0303,  BBREG_0x81c, 0x00600303,  BBREG_0x81c,
	0x00620303,  BBREG_0x81c, 0x00640303,  BBREG_0x81c, 0x00660303,
	BBREG_0x81c, 0x00680303,  BBREG_0x81c, 0x006A0303,  BBREG_0x81c,
	0x006C0303,  BBREG_0x81c, 0x006E0303,  BBREG_0x81c, 0x00700303,
	BBREG_0x81c, 0x00720303,  BBREG_0x81c, 0x00740303,  BBREG_0x81c,
	0x00760303,  BBREG_0x81c, 0x00780303,  BBREG_0x81c, 0x007A0303,
	BBREG_0x81c, 0x007C0303,  BBREG_0x81c, 0x007E0303,  0x9000000a,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c, 0xFC000303,
	BBREG_0x81c, 0xFB020303,  BBREG_0x81c, 0xFA040303,  BBREG_0x81c,
	0xF9060303,  BBREG_0x81c, 0xF8080303,  BBREG_0x81c, 0xF70A0303,
	BBREG_0x81c, 0xF60C0303,  BBREG_0x81c, 0xF50E0303,  BBREG_0x81c,
	0xF4100303,  BBREG_0x81c, 0xF3120303,  BBREG_0x81c, 0xF2140303,
	BBREG_0x81c, 0xF1160303,  BBREG_0x81c, 0xEF180303,  BBREG_0x81c,
	0xEE1A0303,  BBREG_0x81c, 0xED1C0303,  BBREG_0x81c, 0xEC1E0303,
	BBREG_0x81c, 0xEB200303,  BBREG_0x81c, 0xEA220303,  BBREG_0x81c,
	0xE9240303,  BBREG_0x81c, 0xE8260303,  BBREG_0x81c, 0xE7280303,
	BBREG_0x81c, 0xE62A0303,  BBREG_0x81c, 0xE52C0303,  BBREG_0x81c,
	0xE42E0303,  BBREG_0x81c, 0xE3300303,  BBREG_0x81c, 0xE2320303,
	BBREG_0x81c, 0xC6340303,  BBREG_0x81c, 0xC5360303,  BBREG_0x81c,
	0xC4380303,  BBREG_0x81c, 0xC33A0303,  BBREG_0x81c, 0xA63C0303,
	BBREG_0x81c, 0xA53E0303,  BBREG_0x81c, 0xA4400303,  BBREG_0x81c,
	0xA3420303,  BBREG_0x81c, 0xA2440303,  BBREG_0x81c, 0xA1460303,
	BBREG_0x81c, 0x83480303,  BBREG_0x81c, 0x824A0303,  BBREG_0x81c,
	0x814C0303,  BBREG_0x81c, 0x804E0303,  BBREG_0x81c, 0x63500303,
	BBREG_0x81c, 0x62520303,  BBREG_0x81c, 0x61540303,  BBREG_0x81c,
	0x42560303,  BBREG_0x81c, 0x41580303,  BBREG_0x81c, 0x405A0303,
	BBREG_0x81c, 0x225C0303,  BBREG_0x81c, 0x215E0303,  BBREG_0x81c,
	0x20600303,  BBREG_0x81c, 0x04620303,  BBREG_0x81c, 0x03640303,
	BBREG_0x81c, 0x02660303,  BBREG_0x81c, 0x01680303,  BBREG_0x81c,
	0x006A0303,  BBREG_0x81c, 0x006C0303,  BBREG_0x81c, 0x006E0303,
	BBREG_0x81c, 0x00700303,  BBREG_0x81c, 0x00720303,  BBREG_0x81c,
	0x00740303,  BBREG_0x81c, 0x00760303,  BBREG_0x81c, 0x00780303,
	BBREG_0x81c, 0x007A0303,  BBREG_0x81c, 0x007C0303,  BBREG_0x81c,
	0x007E0303,  0x9000000b,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x81c, 0xF8000303,  BBREG_0x81c, 0xF7020303,  BBREG_0x81c,
	0xF6040303,  BBREG_0x81c, 0xF5060303,  BBREG_0x81c, 0xF4080303,
	BBREG_0x81c, 0xF30A0303,  BBREG_0x81c, 0xF20C0303,  BBREG_0x81c,
	0xF10E0303,  BBREG_0x81c, 0xF0100303,  BBREG_0x81c, 0xEF120303,
	BBREG_0x81c, 0xEE140303,  BBREG_0x81c, 0xED160303,  BBREG_0x81c,
	0xEC180303,  BBREG_0x81c, 0xEB1A0303,  BBREG_0x81c, 0xEA1C0303,
	BBREG_0x81c, 0xE91E0303,  BBREG_0x81c, 0xCA200303,  BBREG_0x81c,
	0xC9220303,  BBREG_0x81c, 0xC8240303,  BBREG_0x81c, 0xC7260303,
	BBREG_0x81c, 0xC6280303,  BBREG_0x81c, 0xC52A0303,  BBREG_0x81c,
	0xC42C0303,  BBREG_0x81c, 0xC32E0303,  BBREG_0x81c, 0xC2300303,
	BBREG_0x81c, 0xC1320303,  BBREG_0x81c, 0xA3340303,  BBREG_0x81c,
	0xA2360303,  BBREG_0x81c, 0xA1380303,  BBREG_0x81c, 0xA03A0303,
	BBREG_0x81c, 0x823C0303,  BBREG_0x81c, 0x813E0303,  BBREG_0x81c,
	0x80400303,  BBREG_0x81c, 0x64420303,  BBREG_0x81c, 0x63440303,
	BBREG_0x81c, 0x62460303,  BBREG_0x81c, 0x61480303,  BBREG_0x81c,
	0x604A0303,  BBREG_0x81c, 0x234C0303,  BBREG_0x81c, 0x224E0303,
	BBREG_0x81c, 0x21500303,  BBREG_0x81c, 0x20520303,  BBREG_0x81c,
	0x06540303,  BBREG_0x81c, 0x05560303,  BBREG_0x81c, 0x04580303,
	BBREG_0x81c, 0x035A0303,  BBREG_0x81c, 0x025C0303,  BBREG_0x81c,
	0x015E0303,  BBREG_0x81c, 0x00600303,  BBREG_0x81c, 0x00620303,
	BBREG_0x81c, 0x00640303,  BBREG_0x81c, 0x00660303,  BBREG_0x81c,
	0x00680303,  BBREG_0x81c, 0x006A0303,  BBREG_0x81c, 0x006C0303,
	BBREG_0x81c, 0x006E0303,  BBREG_0x81c, 0x00700303,  BBREG_0x81c,
	0x00720303,  BBREG_0x81c, 0x00740303,  BBREG_0x81c, 0x00760303,
	BBREG_0x81c, 0x00780303,  BBREG_0x81c, 0x007A0303,  BBREG_0x81c,
	0x007C0303,  BBREG_0x81c, 0x007E0303,  0x9000000c,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x81c, 0xFC000303,  BBREG_0x81c,
	0xFB020303,  BBREG_0x81c, 0xFA040303,  BBREG_0x81c, 0xF9060303,
	BBREG_0x81c, 0xF8080303,  BBREG_0x81c, 0xF70A0303,  BBREG_0x81c,
	0xF60C0303,  BBREG_0x81c, 0xF50E0303,  BBREG_0x81c, 0xF4100303,
	BBREG_0x81c, 0xF3120303,  BBREG_0x81c, 0xF2140303,  BBREG_0x81c,
	0xF1160303,  BBREG_0x81c, 0xF0180303,  BBREG_0x81c, 0xEF1A0303,
	BBREG_0x81c, 0xEE1C0303,  BBREG_0x81c, 0xED1E0303,  BBREG_0x81c,
	0xEC200303,  BBREG_0x81c, 0xEB220303,  BBREG_0x81c, 0xEA240303,
	BBREG_0x81c, 0xE9260303,  BBREG_0x81c, 0xE8280303,  BBREG_0x81c,
	0xE72A0303,  BBREG_0x81c, 0xE62C0303,  BBREG_0x81c, 0xE52E0303,
	BBREG_0x81c, 0xE4300303,  BBREG_0x81c, 0xE3320303,  BBREG_0x81c,
	0xE2340303,  BBREG_0x81c, 0xC6360303,  BBREG_0x81c, 0xC5380303,
	BBREG_0x81c, 0xC43A0303,  BBREG_0x81c, 0xC33C0303,  BBREG_0x81c,
	0xA63E0303,  BBREG_0x81c, 0xA5400303,  BBREG_0x81c, 0xA4420303,
	BBREG_0x81c, 0xA3440303,  BBREG_0x81c, 0xA2460303,  BBREG_0x81c,
	0x84480303,  BBREG_0x81c, 0x834A0303,  BBREG_0x81c, 0x824C0303,
	BBREG_0x81c, 0x814E0303,  BBREG_0x81c, 0x80500303,  BBREG_0x81c,
	0x63520303,  BBREG_0x81c, 0x62540303,  BBREG_0x81c, 0x61560303,
	BBREG_0x81c, 0x60580303,  BBREG_0x81c, 0x225A0303,  BBREG_0x81c,
	0x055C0303,  BBREG_0x81c, 0x045E0303,  BBREG_0x81c, 0x03600303,
	BBREG_0x81c, 0x02620303,  BBREG_0x81c, 0x01640303,  BBREG_0x81c,
	0x00660303,  BBREG_0x81c, 0x00680303,  BBREG_0x81c, 0x006A0303,
	BBREG_0x81c, 0x006C0303,  BBREG_0x81c, 0x006E0303,  BBREG_0x81c,
	0x00700303,  BBREG_0x81c, 0x00720303,  BBREG_0x81c, 0x00740303,
	BBREG_0x81c, 0x00760303,  BBREG_0x81c, 0x00780303,  BBREG_0x81c,
	0x007A0303,  BBREG_0x81c, 0x007C0303,  BBREG_0x81c, 0x007E0303,
	0x9000000d,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c,
	0xFB000303,  BBREG_0x81c, 0xFA020303,  BBREG_0x81c, 0xF9040303,
	BBREG_0x81c, 0xF8060303,  BBREG_0x81c, 0xF7080303,  BBREG_0x81c,
	0xF60A0303,  BBREG_0x81c, 0xF50C0303,  BBREG_0x81c, 0xF40E0303,
	BBREG_0x81c, 0xF3100303,  BBREG_0x81c, 0xF2120303,  BBREG_0x81c,
	0xF1140303,  BBREG_0x81c, 0xEF160303,  BBREG_0x81c, 0xEE180303,
	BBREG_0x81c, 0xED1A0303,  BBREG_0x81c, 0xEC1C0303,  BBREG_0x81c,
	0xEB1E0303,  BBREG_0x81c, 0xEA200303,  BBREG_0x81c, 0xE9220303,
	BBREG_0x81c, 0xE8240303,  BBREG_0x81c, 0xE7260303,  BBREG_0x81c,
	0xE6280303,  BBREG_0x81c, 0xE52A0303,  BBREG_0x81c, 0xE42C0303,
	BBREG_0x81c, 0xE32E0303,  BBREG_0x81c, 0xE2300303,  BBREG_0x81c,
	0xE1320303,  BBREG_0x81c, 0xC6340303,  BBREG_0x81c, 0xC5360303,
	BBREG_0x81c, 0xC4380303,  BBREG_0x81c, 0xC33A0303,  BBREG_0x81c,
	0xA63C0303,  BBREG_0x81c, 0xA53E0303,  BBREG_0x81c, 0xA4400303,
	BBREG_0x81c, 0xA3420303,  BBREG_0x81c, 0xA2440303,  BBREG_0x81c,
	0xA1460303,  BBREG_0x81c, 0x83480303,  BBREG_0x81c, 0x824A0303,
	BBREG_0x81c, 0x814C0303,  BBREG_0x81c, 0x804E0303,  BBREG_0x81c,
	0x63500303,  BBREG_0x81c, 0x62520303,  BBREG_0x81c, 0x61540303,
	BBREG_0x81c, 0x42560303,  BBREG_0x81c, 0x41580303,  BBREG_0x81c,
	0x405A0303,  BBREG_0x81c, 0x225C0303,  BBREG_0x81c, 0x215E0303,
	BBREG_0x81c, 0x20600303,  BBREG_0x81c, 0x04620303,  BBREG_0x81c,
	0x03640303,  BBREG_0x81c, 0x02660303,  BBREG_0x81c, 0x01680303,
	BBREG_0x81c, 0x006A0303,  BBREG_0x81c, 0x006C0303,  BBREG_0x81c,
	0x006E0303,  BBREG_0x81c, 0x00700303,  BBREG_0x81c, 0x00720303,
	BBREG_0x81c, 0x00740303,  BBREG_0x81c, 0x00760303,  BBREG_0x81c,
	0x00780303,  BBREG_0x81c, 0x007A0303,  BBREG_0x81c, 0x007C0303,
	BBREG_0x81c, 0x007E0303,  0x9000000e,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x81c, 0xFB000303,  BBREG_0x81c, 0xFA020303,
	BBREG_0x81c, 0xF9040303,  BBREG_0x81c, 0xF8060303,  BBREG_0x81c,
	0xF7080303,  BBREG_0x81c, 0xF60A0303,  BBREG_0x81c, 0xF50C0303,
	BBREG_0x81c, 0xF40E0303,  BBREG_0x81c, 0xF3100303,  BBREG_0x81c,
	0xF2120303,  BBREG_0x81c, 0xF1140303,  BBREG_0x81c, 0xEF160303,
	BBREG_0x81c, 0xEE180303,  BBREG_0x81c, 0xED1A0303,  BBREG_0x81c,
	0xEC1C0303,  BBREG_0x81c, 0xEB1E0303,  BBREG_0x81c, 0xEA200303,
	BBREG_0x81c, 0xE9220303,  BBREG_0x81c, 0xE8240303,  BBREG_0x81c,
	0xE7260303,  BBREG_0x81c, 0xE6280303,  BBREG_0x81c, 0xE52A0303,
	BBREG_0x81c, 0xE42C0303,  BBREG_0x81c, 0xE32E0303,  BBREG_0x81c,
	0xE2300303,  BBREG_0x81c, 0xE1320303,  BBREG_0x81c, 0xC6340303,
	BBREG_0x81c, 0xC5360303,  BBREG_0x81c, 0xC4380303,  BBREG_0x81c,
	0xC33A0303,  BBREG_0x81c, 0xA63C0303,  BBREG_0x81c, 0xA53E0303,
	BBREG_0x81c, 0xA4400303,  BBREG_0x81c, 0xA3420303,  BBREG_0x81c,
	0xA2440303,  BBREG_0x81c, 0xA1460303,  BBREG_0x81c, 0x83480303,
	BBREG_0x81c, 0x824A0303,  BBREG_0x81c, 0x814C0303,  BBREG_0x81c,
	0x804E0303,  BBREG_0x81c, 0x63500303,  BBREG_0x81c, 0x62520303,
	BBREG_0x81c, 0x61540303,  BBREG_0x81c, 0x42560303,  BBREG_0x81c,
	0x41580303,  BBREG_0x81c, 0x405A0303,  BBREG_0x81c, 0x225C0303,
	BBREG_0x81c, 0x215E0303,  BBREG_0x81c, 0x20600303,  BBREG_0x81c,
	0x04620303,  BBREG_0x81c, 0x03640303,  BBREG_0x81c, 0x02660303,
	BBREG_0x81c, 0x01680303,  BBREG_0x81c, 0x006A0303,  BBREG_0x81c,
	0x006C0303,  BBREG_0x81c, 0x006E0303,  BBREG_0x81c, 0x00700303,
	BBREG_0x81c, 0x00720303,  BBREG_0x81c, 0x00740303,  BBREG_0x81c,
	0x00760303,  BBREG_0x81c, 0x00780303,  BBREG_0x81c, 0x007A0303,
	BBREG_0x81c, 0x007C0303,  BBREG_0x81c, 0x007E0303,  0x9000000f,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c, 0xFB000303,
	BBREG_0x81c, 0xFA020303,  BBREG_0x81c, 0xF9040303,  BBREG_0x81c,
	0xF8060303,  BBREG_0x81c, 0xF7080303,  BBREG_0x81c, 0xF60A0303,
	BBREG_0x81c, 0xF50C0303,  BBREG_0x81c, 0xF40E0303,  BBREG_0x81c,
	0xF3100303,  BBREG_0x81c, 0xF2120303,  BBREG_0x81c, 0xF1140303,
	BBREG_0x81c, 0xF0160303,  BBREG_0x81c, 0xEF180303,  BBREG_0x81c,
	0xEE1A0303,  BBREG_0x81c, 0xED1C0303,  BBREG_0x81c, 0xEC1E0303,
	BBREG_0x81c, 0xEB200303,  BBREG_0x81c, 0xEA220303,  BBREG_0x81c,
	0xE9240303,  BBREG_0x81c, 0xE8260303,  BBREG_0x81c, 0xE7280303,
	BBREG_0x81c, 0xE62A0303,  BBREG_0x81c, 0xE52C0303,  BBREG_0x81c,
	0xE42E0303,  BBREG_0x81c, 0xE3300303,  BBREG_0x81c, 0xE2320303,
	BBREG_0x81c, 0xE1340303,  BBREG_0x81c, 0xE0360303,  BBREG_0x81c,
	0xC3380303,  BBREG_0x81c, 0xC23A0303,  BBREG_0x81c, 0xC13C0303,
	BBREG_0x81c, 0xC03E0303,  BBREG_0x81c, 0xA3400303,  BBREG_0x81c,
	0xA2420303,  BBREG_0x81c, 0xA1440303,  BBREG_0x81c, 0xA0460303,
	BBREG_0x81c, 0x83480303,  BBREG_0x81c, 0x824A0303,  BBREG_0x81c,
	0x814C0303,  BBREG_0x81c, 0x644E0303,  BBREG_0x81c, 0x63500303,
	BBREG_0x81c, 0x62520303,  BBREG_0x81c, 0x61540303,  BBREG_0x81c,
	0x24560303,  BBREG_0x81c, 0x23580303,  BBREG_0x81c, 0x225A0303,
	BBREG_0x81c, 0x215C0303,  BBREG_0x81c, 0x055E0303,  BBREG_0x81c,
	0x04600303,  BBREG_0x81c, 0x03620303,  BBREG_0x81c, 0x02640303,
	BBREG_0x81c, 0x01660303,  BBREG_0x81c, 0x00680303,  BBREG_0x81c,
	0x006A0303,  BBREG_0x81c, 0x006C0303,  BBREG_0x81c, 0x006E0303,
	BBREG_0x81c, 0x00700303,  BBREG_0x81c, 0x00720303,  BBREG_0x81c,
	0x00740303,  BBREG_0x81c, 0x00760303,  BBREG_0x81c, 0x00780303,
	BBREG_0x81c, 0x007A0303,  BBREG_0x81c, 0x007C0303,  BBREG_0x81c,
	0x007E0303,  0x90000010,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x81c, 0xFC000303,  BBREG_0x81c, 0xFB020303,  BBREG_0x81c,
	0xFA040303,  BBREG_0x81c, 0xF9060303,  BBREG_0x81c, 0xF8080303,
	BBREG_0x81c, 0xF70A0303,  BBREG_0x81c, 0xF60C0303,  BBREG_0x81c,
	0xF50E0303,  BBREG_0x81c, 0xF4100303,  BBREG_0x81c, 0xF3120303,
	BBREG_0x81c, 0xF2140303,  BBREG_0x81c, 0xF1160303,  BBREG_0x81c,
	0xF0180303,  BBREG_0x81c, 0xEF1A0303,  BBREG_0x81c, 0xEE1C0303,
	BBREG_0x81c, 0xED1E0303,  BBREG_0x81c, 0xEC200303,  BBREG_0x81c,
	0xEB220303,  BBREG_0x81c, 0xEA240303,  BBREG_0x81c, 0xE9260303,
	BBREG_0x81c, 0xE8280303,  BBREG_0x81c, 0xE72A0303,  BBREG_0x81c,
	0xE62C0303,  BBREG_0x81c, 0xE52E0303,  BBREG_0x81c, 0xE4300303,
	BBREG_0x81c, 0xE3320303,  BBREG_0x81c, 0xE2340303,  BBREG_0x81c,
	0xC6360303,  BBREG_0x81c, 0xC5380303,  BBREG_0x81c, 0xC43A0303,
	BBREG_0x81c, 0xC33C0303,  BBREG_0x81c, 0xA63E0303,  BBREG_0x81c,
	0xA5400303,  BBREG_0x81c, 0xA4420303,  BBREG_0x81c, 0xA3440303,
	BBREG_0x81c, 0xA2460303,  BBREG_0x81c, 0x84480303,  BBREG_0x81c,
	0x834A0303,  BBREG_0x81c, 0x824C0303,  BBREG_0x81c, 0x814E0303,
	BBREG_0x81c, 0x80500303,  BBREG_0x81c, 0x63520303,  BBREG_0x81c,
	0x62540303,  BBREG_0x81c, 0x61560303,  BBREG_0x81c, 0x60580303,
	BBREG_0x81c, 0x225A0303,  BBREG_0x81c, 0x055C0303,  BBREG_0x81c,
	0x045E0303,  BBREG_0x81c, 0x03600303,  BBREG_0x81c, 0x02620303,
	BBREG_0x81c, 0x01640303,  BBREG_0x81c, 0x00660303,  BBREG_0x81c,
	0x00680303,  BBREG_0x81c, 0x006A0303,  BBREG_0x81c, 0x006C0303,
	BBREG_0x81c, 0x006E0303,  BBREG_0x81c, 0x00700303,  BBREG_0x81c,
	0x00720303,  BBREG_0x81c, 0x00740303,  BBREG_0x81c, 0x00760303,
	BBREG_0x81c, 0x00780303,  BBREG_0x81c, 0x007A0303,  BBREG_0x81c,
	0x007C0303,  BBREG_0x81c, 0x007E0303,  0xA0000000,  0x00000000,
	BBREG_0x81c, 0xFC000303,  BBREG_0x81c, 0xFB020303,  BBREG_0x81c,
	0xFA040303,  BBREG_0x81c, 0xF9060303,  BBREG_0x81c, 0xF8080303,
	BBREG_0x81c, 0xF70A0303,  BBREG_0x81c, 0xF60C0303,  BBREG_0x81c,
	0xF50E0303,  BBREG_0x81c, 0xF4100303,  BBREG_0x81c, 0xF3120303,
	BBREG_0x81c, 0xF2140303,  BBREG_0x81c, 0xF1160303,  BBREG_0x81c,
	0xF0180303,  BBREG_0x81c, 0xEF1A0303,  BBREG_0x81c, 0xEE1C0303,
	BBREG_0x81c, 0xED1E0303,  BBREG_0x81c, 0xEC200303,  BBREG_0x81c,
	0xEB220303,  BBREG_0x81c, 0xEA240303,  BBREG_0x81c, 0xE9260303,
	BBREG_0x81c, 0xE8280303,  BBREG_0x81c, 0xE72A0303,  BBREG_0x81c,
	0xE62C0303,  BBREG_0x81c, 0xE52E0303,  BBREG_0x81c, 0xE4300303,
	BBREG_0x81c, 0xE3320303,  BBREG_0x81c, 0xE2340303,  BBREG_0x81c,
	0xC6360303,  BBREG_0x81c, 0xC5380303,  BBREG_0x81c, 0xC43A0303,
	BBREG_0x81c, 0xC33C0303,  BBREG_0x81c, 0xA63E0303,  BBREG_0x81c,
	0xA5400303,  BBREG_0x81c, 0xA4420303,  BBREG_0x81c, 0xA3440303,
	BBREG_0x81c, 0xA2460303,  BBREG_0x81c, 0x84480303,  BBREG_0x81c,
	0x834A0303,  BBREG_0x81c, 0x824C0303,  BBREG_0x81c, 0x814E0303,
	BBREG_0x81c, 0x80500303,  BBREG_0x81c, 0x63520303,  BBREG_0x81c,
	0x62540303,  BBREG_0x81c, 0x61560303,  BBREG_0x81c, 0x60580303,
	BBREG_0x81c, 0x235A0303,  BBREG_0x81c, 0x225C0303,  BBREG_0x81c,
	0x215E0303,  BBREG_0x81c, 0x20600303,  BBREG_0x81c, 0x03620303,
	BBREG_0x81c, 0x02640303,  BBREG_0x81c, 0x01660303,  BBREG_0x81c,
	0x00680303,  BBREG_0x81c, 0x006A0303,  BBREG_0x81c, 0x006C0303,
	BBREG_0x81c, 0x006E0303,  BBREG_0x81c, 0x00700303,  BBREG_0x81c,
	0x00720303,  BBREG_0x81c, 0x00740303,  BBREG_0x81c, 0x00760303,
	BBREG_0x81c, 0x00780303,  BBREG_0x81c, 0x007A0303,  BBREG_0x81c,
	0x007C0303,  BBREG_0x81c, 0x007E0303,  0xB0000000,  0x00000000,
	0x80000000,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c,
	0xFF000403,  BBREG_0x81c, 0xFF000403,  BBREG_0x81c, 0xFF020403,
	BBREG_0x81c, 0xFE040403,  BBREG_0x81c, 0xFD060403,  BBREG_0x81c,
	0xFC080403,  BBREG_0x81c, 0xFB0A0403,  BBREG_0x81c, 0xFA0C0403,
	BBREG_0x81c, 0xF90E0403,  BBREG_0x81c, 0xF8100403,  BBREG_0x81c,
	0xF7120403,  BBREG_0x81c, 0xF6140403,  BBREG_0x81c, 0xF5160403,
	BBREG_0x81c, 0xF4180403,  BBREG_0x81c, 0xF31A0403,  BBREG_0x81c,
	0xF21C0403,  BBREG_0x81c, 0xD51E0403,  BBREG_0x81c, 0xD4200403,
	BBREG_0x81c, 0xD3220403,  BBREG_0x81c, 0xD2240403,  BBREG_0x81c,
	0xB6260403,  BBREG_0x81c, 0xB5280403,  BBREG_0x81c, 0xB42A0403,
	BBREG_0x81c, 0xB32C0403,  BBREG_0x81c, 0xB22E0403,  BBREG_0x81c,
	0xB1300403,  BBREG_0x81c, 0xB0320403,  BBREG_0x81c, 0xAF340403,
	BBREG_0x81c, 0xAE360403,  BBREG_0x81c, 0xAD380403,  BBREG_0x81c,
	0xAC3A0403,  BBREG_0x81c, 0xAB3C0403,  BBREG_0x81c, 0xAA3E0403,
	BBREG_0x81c, 0xA9400403,  BBREG_0x81c, 0xA8420403,  BBREG_0x81c,
	0xA7440403,  BBREG_0x81c, 0xA6460403,  BBREG_0x81c, 0xA5480403,
	BBREG_0x81c, 0xA44A0403,  BBREG_0x81c, 0xA34C0403,  BBREG_0x81c,
	0x854E0403,  BBREG_0x81c, 0x84500403,  BBREG_0x81c, 0x83520403,
	BBREG_0x81c, 0x82540403,  BBREG_0x81c, 0x81560403,  BBREG_0x81c,
	0x80580403,  BBREG_0x81c, 0x485A0403,  BBREG_0x81c, 0x475C0403,
	BBREG_0x81c, 0x465E0403,  BBREG_0x81c, 0x45600403,  BBREG_0x81c,
	0x44620403,  BBREG_0x81c, 0x0A640403,  BBREG_0x81c, 0x09660403,
	BBREG_0x81c, 0x08680403,  BBREG_0x81c, 0x076A0403,  BBREG_0x81c,
	0x066C0403,  BBREG_0x81c, 0x056E0403,  BBREG_0x81c, 0x04700403,
	BBREG_0x81c, 0x03720403,  BBREG_0x81c, 0x02740403,  BBREG_0x81c,
	0x01760403,  BBREG_0x81c, 0x00780403,  BBREG_0x81c, 0x007A0403,
	BBREG_0x81c, 0x007C0403,  BBREG_0x81c, 0x007E0403,  0x90000001,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c, 0xFF000403,
	BBREG_0x81c, 0xF5000403,  BBREG_0x81c, 0xF4020403,  BBREG_0x81c,
	0xF3040403,  BBREG_0x81c, 0xF2060403,  BBREG_0x81c, 0xF1080403,
	BBREG_0x81c, 0xF00A0403,  BBREG_0x81c, 0xEF0C0403,  BBREG_0x81c,
	0xEE0E0403,  BBREG_0x81c, 0xED100403,  BBREG_0x81c, 0xEC120403,
	BBREG_0x81c, 0xEB140403,  BBREG_0x81c, 0xEA160403,  BBREG_0x81c,
	0xE9180403,  BBREG_0x81c, 0xE81A0403,  BBREG_0x81c, 0xE71C0403,
	BBREG_0x81c, 0xE61E0403,  BBREG_0x81c, 0xE5200403,  BBREG_0x81c,
	0xE4220403,  BBREG_0x81c, 0xE3240403,  BBREG_0x81c, 0xE2260403,
	BBREG_0x81c, 0xE1280403,  BBREG_0x81c, 0xE02A0403,  BBREG_0x81c,
	0xC32C0403,  BBREG_0x81c, 0xC22E0403,  BBREG_0x81c, 0xC1300403,
	BBREG_0x81c, 0xC0320403,  BBREG_0x81c, 0xA4340403,  BBREG_0x81c,
	0xA3360403,  BBREG_0x81c, 0xA2380403,  BBREG_0x81c, 0xA13A0403,
	BBREG_0x81c, 0xA03C0403,  BBREG_0x81c, 0x823E0403,  BBREG_0x81c,
	0x81400403,  BBREG_0x81c, 0x80420403,  BBREG_0x81c, 0x64440403,
	BBREG_0x81c, 0x63460403,  BBREG_0x81c, 0x62480403,  BBREG_0x81c,
	0x614A0403,  BBREG_0x81c, 0x604C0403,  BBREG_0x81c, 0x454E0403,
	BBREG_0x81c, 0x44500403,  BBREG_0x81c, 0x43520403,  BBREG_0x81c,
	0x42540403,  BBREG_0x81c, 0x41560403,  BBREG_0x81c, 0x40580403,
	BBREG_0x81c, 0x055A0403,  BBREG_0x81c, 0x045C0403,  BBREG_0x81c,
	0x035E0403,  BBREG_0x81c, 0x02600403,  BBREG_0x81c, 0x01620403,
	BBREG_0x81c, 0x00640403,  BBREG_0x81c, 0x00660403,  BBREG_0x81c,
	0x00680403,  BBREG_0x81c, 0x006A0403,  BBREG_0x81c, 0x006C0403,
	BBREG_0x81c, 0x006E0403,  BBREG_0x81c, 0x00700403,  BBREG_0x81c,
	0x00720403,  BBREG_0x81c, 0x00740403,  BBREG_0x81c, 0x00760403,
	BBREG_0x81c, 0x00780403,  BBREG_0x81c, 0x007A0403,  BBREG_0x81c,
	0x007C0403,  BBREG_0x81c, 0x007E0403,  0x90000002,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x81c, 0xFF000403,  BBREG_0x81c,
	0xFF000403,  BBREG_0x81c, 0xFF020403,  BBREG_0x81c, 0xFE040403,
	BBREG_0x81c, 0xFD060403,  BBREG_0x81c, 0xFC080403,  BBREG_0x81c,
	0xFB0A0403,  BBREG_0x81c, 0xFA0C0403,  BBREG_0x81c, 0xF90E0403,
	BBREG_0x81c, 0xF8100403,  BBREG_0x81c, 0xF7120403,  BBREG_0x81c,
	0xF6140403,  BBREG_0x81c, 0xF5160403,  BBREG_0x81c, 0xF4180403,
	BBREG_0x81c, 0xF31A0403,  BBREG_0x81c, 0xF21C0403,  BBREG_0x81c,
	0xD51E0403,  BBREG_0x81c, 0xD4200403,  BBREG_0x81c, 0xD3220403,
	BBREG_0x81c, 0xD2240403,  BBREG_0x81c, 0xB6260403,  BBREG_0x81c,
	0xB5280403,  BBREG_0x81c, 0xB42A0403,  BBREG_0x81c, 0xB32C0403,
	BBREG_0x81c, 0xB22E0403,  BBREG_0x81c, 0xB1300403,  BBREG_0x81c,
	0xB0320403,  BBREG_0x81c, 0xAF340403,  BBREG_0x81c, 0xAE360403,
	BBREG_0x81c, 0xAD380403,  BBREG_0x81c, 0xAC3A0403,  BBREG_0x81c,
	0xAB3C0403,  BBREG_0x81c, 0xAA3E0403,  BBREG_0x81c, 0xA9400403,
	BBREG_0x81c, 0xA8420403,  BBREG_0x81c, 0xA7440403,  BBREG_0x81c,
	0xA6460403,  BBREG_0x81c, 0xA5480403,  BBREG_0x81c, 0xA44A0403,
	BBREG_0x81c, 0xA34C0403,  BBREG_0x81c, 0x854E0403,  BBREG_0x81c,
	0x84500403,  BBREG_0x81c, 0x83520403,  BBREG_0x81c, 0x82540403,
	BBREG_0x81c, 0x81560403,  BBREG_0x81c, 0x80580403,  BBREG_0x81c,
	0x485A0403,  BBREG_0x81c, 0x475C0403,  BBREG_0x81c, 0x465E0403,
	BBREG_0x81c, 0x45600403,  BBREG_0x81c, 0x44620403,  BBREG_0x81c,
	0x0A640403,  BBREG_0x81c, 0x09660403,  BBREG_0x81c, 0x08680403,
	BBREG_0x81c, 0x076A0403,  BBREG_0x81c, 0x066C0403,  BBREG_0x81c,
	0x056E0403,  BBREG_0x81c, 0x04700403,  BBREG_0x81c, 0x03720403,
	BBREG_0x81c, 0x02740403,  BBREG_0x81c, 0x01760403,  BBREG_0x81c,
	0x00780403,  BBREG_0x81c, 0x007A0403,  BBREG_0x81c, 0x007C0403,
	BBREG_0x81c, 0x007E0403,  0x90000003,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x81c, 0xFF000403,  BBREG_0x81c, 0xFF000403,
	BBREG_0x81c, 0xFF020403,  BBREG_0x81c, 0xFE040403,  BBREG_0x81c,
	0xFD060403,  BBREG_0x81c, 0xFC080403,  BBREG_0x81c, 0xFB0A0403,
	BBREG_0x81c, 0xFA0C0403,  BBREG_0x81c, 0xF90E0403,  BBREG_0x81c,
	0xF8100403,  BBREG_0x81c, 0xF7120403,  BBREG_0x81c, 0xF6140403,
	BBREG_0x81c, 0xF5160403,  BBREG_0x81c, 0xF4180403,  BBREG_0x81c,
	0xF31A0403,  BBREG_0x81c, 0xF21C0403,  BBREG_0x81c, 0xD51E0403,
	BBREG_0x81c, 0xD4200403,  BBREG_0x81c, 0xD3220403,  BBREG_0x81c,
	0xD2240403,  BBREG_0x81c, 0xB6260403,  BBREG_0x81c, 0xB5280403,
	BBREG_0x81c, 0xB42A0403,  BBREG_0x81c, 0xB32C0403,  BBREG_0x81c,
	0xB22E0403,  BBREG_0x81c, 0xB1300403,  BBREG_0x81c, 0xB0320403,
	BBREG_0x81c, 0xAF340403,  BBREG_0x81c, 0xAE360403,  BBREG_0x81c,
	0xAD380403,  BBREG_0x81c, 0xAC3A0403,  BBREG_0x81c, 0xAB3C0403,
	BBREG_0x81c, 0xAA3E0403,  BBREG_0x81c, 0xA9400403,  BBREG_0x81c,
	0xA8420403,  BBREG_0x81c, 0xA7440403,  BBREG_0x81c, 0xA6460403,
	BBREG_0x81c, 0xA5480403,  BBREG_0x81c, 0xA44A0403,  BBREG_0x81c,
	0xA34C0403,  BBREG_0x81c, 0x854E0403,  BBREG_0x81c, 0x84500403,
	BBREG_0x81c, 0x83520403,  BBREG_0x81c, 0x82540403,  BBREG_0x81c,
	0x81560403,  BBREG_0x81c, 0x80580403,  BBREG_0x81c, 0x485A0403,
	BBREG_0x81c, 0x475C0403,  BBREG_0x81c, 0x465E0403,  BBREG_0x81c,
	0x45600403,  BBREG_0x81c, 0x44620403,  BBREG_0x81c, 0x0A640403,
	BBREG_0x81c, 0x09660403,  BBREG_0x81c, 0x08680403,  BBREG_0x81c,
	0x076A0403,  BBREG_0x81c, 0x066C0403,  BBREG_0x81c, 0x056E0403,
	BBREG_0x81c, 0x04700403,  BBREG_0x81c, 0x03720403,  BBREG_0x81c,
	0x02740403,  BBREG_0x81c, 0x01760403,  BBREG_0x81c, 0x00780403,
	BBREG_0x81c, 0x007A0403,  BBREG_0x81c, 0x007C0403,  BBREG_0x81c,
	0x007E0403,  0x90000004,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x81c, 0xFF000403,  BBREG_0x81c, 0xF6000403,  BBREG_0x81c,
	0xF5020403,  BBREG_0x81c, 0xF4040403,  BBREG_0x81c, 0xF3060403,
	BBREG_0x81c, 0xF2080403,  BBREG_0x81c, 0xF10A0403,  BBREG_0x81c,
	0xF00C0403,  BBREG_0x81c, 0xEF0E0403,  BBREG_0x81c, 0xD6100403,
	BBREG_0x81c, 0xD5120403,  BBREG_0x81c, 0xD4140403,  BBREG_0x81c,
	0xD3160403,  BBREG_0x81c, 0xD2180403,  BBREG_0x81c, 0xD11A0403,
	BBREG_0x81c, 0xD01C0403,  BBREG_0x81c, 0xCF1E0403,  BBREG_0x81c,
	0x95200403,  BBREG_0x81c, 0x94220403,  BBREG_0x81c, 0x93240403,
	BBREG_0x81c, 0x92260403,  BBREG_0x81c, 0x91280403,  BBREG_0x81c,
	0x902A0403,  BBREG_0x81c, 0x8F2C0403,  BBREG_0x81c, 0x8E2E0403,
	BBREG_0x81c, 0x8D300403,  BBREG_0x81c, 0x8C320403,  BBREG_0x81c,
	0x8B340403,  BBREG_0x81c, 0x8A360403,  BBREG_0x81c, 0x89380403,
	BBREG_0x81c, 0x883A0403,  BBREG_0x81c, 0x873C0403,  BBREG_0x81c,
	0x863E0403,  BBREG_0x81c, 0x68400403,  BBREG_0x81c, 0x67420403,
	BBREG_0x81c, 0x66440403,  BBREG_0x81c, 0x65460403,  BBREG_0x81c,
	0x64480403,  BBREG_0x81c, 0x634A0403,  BBREG_0x81c, 0x484C0403,
	BBREG_0x81c, 0x474E0403,  BBREG_0x81c, 0x46500403,  BBREG_0x81c,
	0x45520403,  BBREG_0x81c, 0x44540403,  BBREG_0x81c, 0x27560403,
	BBREG_0x81c, 0x26580403,  BBREG_0x81c, 0x255A0403,  BBREG_0x81c,
	0x245C0403,  BBREG_0x81c, 0x235E0403,  BBREG_0x81c, 0x04600403,
	BBREG_0x81c, 0x03620403,  BBREG_0x81c, 0x02640403,  BBREG_0x81c,
	0x01660403,  BBREG_0x81c, 0x00680403,  BBREG_0x81c, 0x006A0403,
	BBREG_0x81c, 0x006C0403,  BBREG_0x81c, 0x006E0403,  BBREG_0x81c,
	0x00700403,  BBREG_0x81c, 0x00720403,  BBREG_0x81c, 0x00740403,
	BBREG_0x81c, 0x00760403,  BBREG_0x81c, 0x00780403,  BBREG_0x81c,
	0x007A0403,  BBREG_0x81c, 0x007C0403,  BBREG_0x81c, 0x007E0403,
	0x90000005,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c,
	0xFF000403,  BBREG_0x81c, 0xFF000403,  BBREG_0x81c, 0xFF020403,
	BBREG_0x81c, 0xFE040403,  BBREG_0x81c, 0xFD060403,  BBREG_0x81c,
	0xFC080403,  BBREG_0x81c, 0xFB0A0403,  BBREG_0x81c, 0xFA0C0403,
	BBREG_0x81c, 0xF90E0403,  BBREG_0x81c, 0xF8100403,  BBREG_0x81c,
	0xF7120403,  BBREG_0x81c, 0xF6140403,  BBREG_0x81c, 0xF5160403,
	BBREG_0x81c, 0xF4180403,  BBREG_0x81c, 0xF31A0403,  BBREG_0x81c,
	0xF21C0403,  BBREG_0x81c, 0xD51E0403,  BBREG_0x81c, 0xD4200403,
	BBREG_0x81c, 0xD3220403,  BBREG_0x81c, 0xD2240403,  BBREG_0x81c,
	0xB6260403,  BBREG_0x81c, 0xB5280403,  BBREG_0x81c, 0xB42A0403,
	BBREG_0x81c, 0xB32C0403,  BBREG_0x81c, 0xB22E0403,  BBREG_0x81c,
	0xB1300403,  BBREG_0x81c, 0xB0320403,  BBREG_0x81c, 0xAF340403,
	BBREG_0x81c, 0xAE360403,  BBREG_0x81c, 0xAD380403,  BBREG_0x81c,
	0xAC3A0403,  BBREG_0x81c, 0xAB3C0403,  BBREG_0x81c, 0xAA3E0403,
	BBREG_0x81c, 0xA9400403,  BBREG_0x81c, 0xA8420403,  BBREG_0x81c,
	0xA7440403,  BBREG_0x81c, 0xA6460403,  BBREG_0x81c, 0xA5480403,
	BBREG_0x81c, 0xA44A0403,  BBREG_0x81c, 0xA34C0403,  BBREG_0x81c,
	0x854E0403,  BBREG_0x81c, 0x84500403,  BBREG_0x81c, 0x83520403,
	BBREG_0x81c, 0x82540403,  BBREG_0x81c, 0x81560403,  BBREG_0x81c,
	0x80580403,  BBREG_0x81c, 0x485A0403,  BBREG_0x81c, 0x475C0403,
	BBREG_0x81c, 0x465E0403,  BBREG_0x81c, 0x45600403,  BBREG_0x81c,
	0x44620403,  BBREG_0x81c, 0x0A640403,  BBREG_0x81c, 0x09660403,
	BBREG_0x81c, 0x08680403,  BBREG_0x81c, 0x076A0403,  BBREG_0x81c,
	0x066C0403,  BBREG_0x81c, 0x056E0403,  BBREG_0x81c, 0x04700403,
	BBREG_0x81c, 0x03720403,  BBREG_0x81c, 0x02740403,  BBREG_0x81c,
	0x01760403,  BBREG_0x81c, 0x00780403,  BBREG_0x81c, 0x007A0403,
	BBREG_0x81c, 0x007C0403,  BBREG_0x81c, 0x007E0403,  0x90000006,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c, 0xFF000403,
	BBREG_0x81c, 0xF5000403,  BBREG_0x81c, 0xF4020403,  BBREG_0x81c,
	0xF3040403,  BBREG_0x81c, 0xF2060403,  BBREG_0x81c, 0xF1080403,
	BBREG_0x81c, 0xF00A0403,  BBREG_0x81c, 0xEF0C0403,  BBREG_0x81c,
	0xEE0E0403,  BBREG_0x81c, 0xED100403,  BBREG_0x81c, 0xEC120403,
	BBREG_0x81c, 0xEB140403,  BBREG_0x81c, 0xEA160403,  BBREG_0x81c,
	0xE9180403,  BBREG_0x81c, 0xE81A0403,  BBREG_0x81c, 0xE71C0403,
	BBREG_0x81c, 0xE61E0403,  BBREG_0x81c, 0xE5200403,  BBREG_0x81c,
	0xE4220403,  BBREG_0x81c, 0xE3240403,  BBREG_0x81c, 0xE2260403,
	BBREG_0x81c, 0xE1280403,  BBREG_0x81c, 0xE02A0403,  BBREG_0x81c,
	0xC32C0403,  BBREG_0x81c, 0xC22E0403,  BBREG_0x81c, 0xC1300403,
	BBREG_0x81c, 0xC0320403,  BBREG_0x81c, 0xA4340403,  BBREG_0x81c,
	0xA3360403,  BBREG_0x81c, 0xA2380403,  BBREG_0x81c, 0xA13A0403,
	BBREG_0x81c, 0xA03C0403,  BBREG_0x81c, 0x823E0403,  BBREG_0x81c,
	0x81400403,  BBREG_0x81c, 0x80420403,  BBREG_0x81c, 0x64440403,
	BBREG_0x81c, 0x63460403,  BBREG_0x81c, 0x62480403,  BBREG_0x81c,
	0x614A0403,  BBREG_0x81c, 0x604C0403,  BBREG_0x81c, 0x454E0403,
	BBREG_0x81c, 0x44500403,  BBREG_0x81c, 0x43520403,  BBREG_0x81c,
	0x42540403,  BBREG_0x81c, 0x41560403,  BBREG_0x81c, 0x40580403,
	BBREG_0x81c, 0x055A0403,  BBREG_0x81c, 0x045C0403,  BBREG_0x81c,
	0x035E0403,  BBREG_0x81c, 0x02600403,  BBREG_0x81c, 0x01620403,
	BBREG_0x81c, 0x00640403,  BBREG_0x81c, 0x00660403,  BBREG_0x81c,
	0x00680403,  BBREG_0x81c, 0x006A0403,  BBREG_0x81c, 0x006C0403,
	BBREG_0x81c, 0x006E0403,  BBREG_0x81c, 0x00700403,  BBREG_0x81c,
	0x00720403,  BBREG_0x81c, 0x00740403,  BBREG_0x81c, 0x00760403,
	BBREG_0x81c, 0x00780403,  BBREG_0x81c, 0x007A0403,  BBREG_0x81c,
	0x007C0403,  BBREG_0x81c, 0x007E0403,  0x90000007,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x81c, 0xFF000403,  BBREG_0x81c,
	0xF5000403,  BBREG_0x81c, 0xF4020403,  BBREG_0x81c, 0xF3040403,
	BBREG_0x81c, 0xF2060403,  BBREG_0x81c, 0xF1080403,  BBREG_0x81c,
	0xF00A0403,  BBREG_0x81c, 0xEF0C0403,  BBREG_0x81c, 0xEE0E0403,
	BBREG_0x81c, 0xED100403,  BBREG_0x81c, 0xEC120403,  BBREG_0x81c,
	0xEB140403,  BBREG_0x81c, 0xEA160403,  BBREG_0x81c, 0xE9180403,
	BBREG_0x81c, 0xE81A0403,  BBREG_0x81c, 0xE71C0403,  BBREG_0x81c,
	0xE61E0403,  BBREG_0x81c, 0xE5200403,  BBREG_0x81c, 0xE4220403,
	BBREG_0x81c, 0xE3240403,  BBREG_0x81c, 0xE2260403,  BBREG_0x81c,
	0xE1280403,  BBREG_0x81c, 0xE02A0403,  BBREG_0x81c, 0xC32C0403,
	BBREG_0x81c, 0xC22E0403,  BBREG_0x81c, 0xC1300403,  BBREG_0x81c,
	0xC0320403,  BBREG_0x81c, 0xA4340403,  BBREG_0x81c, 0xA3360403,
	BBREG_0x81c, 0xA2380403,  BBREG_0x81c, 0xA13A0403,  BBREG_0x81c,
	0xA03C0403,  BBREG_0x81c, 0x823E0403,  BBREG_0x81c, 0x81400403,
	BBREG_0x81c, 0x80420403,  BBREG_0x81c, 0x64440403,  BBREG_0x81c,
	0x63460403,  BBREG_0x81c, 0x62480403,  BBREG_0x81c, 0x614A0403,
	BBREG_0x81c, 0x604C0403,  BBREG_0x81c, 0x454E0403,  BBREG_0x81c,
	0x44500403,  BBREG_0x81c, 0x43520403,  BBREG_0x81c, 0x42540403,
	BBREG_0x81c, 0x41560403,  BBREG_0x81c, 0x40580403,  BBREG_0x81c,
	0x055A0403,  BBREG_0x81c, 0x045C0403,  BBREG_0x81c, 0x035E0403,
	BBREG_0x81c, 0x02600403,  BBREG_0x81c, 0x01620403,  BBREG_0x81c,
	0x00640403,  BBREG_0x81c, 0x00660403,  BBREG_0x81c, 0x00680403,
	BBREG_0x81c, 0x006A0403,  BBREG_0x81c, 0x006C0403,  BBREG_0x81c,
	0x006E0403,  BBREG_0x81c, 0x00700403,  BBREG_0x81c, 0x00720403,
	BBREG_0x81c, 0x00740403,  BBREG_0x81c, 0x00760403,  BBREG_0x81c,
	0x00780403,  BBREG_0x81c, 0x007A0403,  BBREG_0x81c, 0x007C0403,
	BBREG_0x81c, 0x007E0403,  0x90000008,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x81c, 0xFF000403,  BBREG_0x81c, 0xFF000403,
	BBREG_0x81c, 0xFF020403,  BBREG_0x81c, 0xFE040403,  BBREG_0x81c,
	0xFD060403,  BBREG_0x81c, 0xFC080403,  BBREG_0x81c, 0xFB0A0403,
	BBREG_0x81c, 0xFA0C0403,  BBREG_0x81c, 0xF90E0403,  BBREG_0x81c,
	0xF8100403,  BBREG_0x81c, 0xF7120403,  BBREG_0x81c, 0xF6140403,
	BBREG_0x81c, 0xF5160403,  BBREG_0x81c, 0xF4180403,  BBREG_0x81c,
	0xF31A0403,  BBREG_0x81c, 0xF21C0403,  BBREG_0x81c, 0xD51E0403,
	BBREG_0x81c, 0xD4200403,  BBREG_0x81c, 0xD3220403,  BBREG_0x81c,
	0xD2240403,  BBREG_0x81c, 0xB6260403,  BBREG_0x81c, 0xB5280403,
	BBREG_0x81c, 0xB42A0403,  BBREG_0x81c, 0xB32C0403,  BBREG_0x81c,
	0xB22E0403,  BBREG_0x81c, 0xB1300403,  BBREG_0x81c, 0xB0320403,
	BBREG_0x81c, 0xAF340403,  BBREG_0x81c, 0xAE360403,  BBREG_0x81c,
	0xAD380403,  BBREG_0x81c, 0xAC3A0403,  BBREG_0x81c, 0xAB3C0403,
	BBREG_0x81c, 0xAA3E0403,  BBREG_0x81c, 0xA9400403,  BBREG_0x81c,
	0xA8420403,  BBREG_0x81c, 0xA7440403,  BBREG_0x81c, 0xA6460403,
	BBREG_0x81c, 0xA5480403,  BBREG_0x81c, 0xA44A0403,  BBREG_0x81c,
	0xA34C0403,  BBREG_0x81c, 0x854E0403,  BBREG_0x81c, 0x84500403,
	BBREG_0x81c, 0x83520403,  BBREG_0x81c, 0x82540403,  BBREG_0x81c,
	0x81560403,  BBREG_0x81c, 0x80580403,  BBREG_0x81c, 0x485A0403,
	BBREG_0x81c, 0x475C0403,  BBREG_0x81c, 0x465E0403,  BBREG_0x81c,
	0x45600403,  BBREG_0x81c, 0x44620403,  BBREG_0x81c, 0x0A640403,
	BBREG_0x81c, 0x09660403,  BBREG_0x81c, 0x08680403,  BBREG_0x81c,
	0x076A0403,  BBREG_0x81c, 0x066C0403,  BBREG_0x81c, 0x056E0403,
	BBREG_0x81c, 0x04700403,  BBREG_0x81c, 0x03720403,  BBREG_0x81c,
	0x02740403,  BBREG_0x81c, 0x01760403,  BBREG_0x81c, 0x00780403,
	BBREG_0x81c, 0x007A0403,  BBREG_0x81c, 0x007C0403,  BBREG_0x81c,
	0x007E0403,  0x90000009,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x81c, 0xFF000403,  BBREG_0x81c, 0xF5000403,  BBREG_0x81c,
	0xF4020403,  BBREG_0x81c, 0xF3040403,  BBREG_0x81c, 0xF2060403,
	BBREG_0x81c, 0xF1080403,  BBREG_0x81c, 0xF00A0403,  BBREG_0x81c,
	0xEF0C0403,  BBREG_0x81c, 0xEE0E0403,  BBREG_0x81c, 0xED100403,
	BBREG_0x81c, 0xEC120403,  BBREG_0x81c, 0xEB140403,  BBREG_0x81c,
	0xEA160403,  BBREG_0x81c, 0xE9180403,  BBREG_0x81c, 0xE81A0403,
	BBREG_0x81c, 0xE71C0403,  BBREG_0x81c, 0xE61E0403,  BBREG_0x81c,
	0xE5200403,  BBREG_0x81c, 0xE4220403,  BBREG_0x81c, 0xE3240403,
	BBREG_0x81c, 0xE2260403,  BBREG_0x81c, 0xE1280403,  BBREG_0x81c,
	0xE02A0403,  BBREG_0x81c, 0xC32C0403,  BBREG_0x81c, 0xC22E0403,
	BBREG_0x81c, 0xC1300403,  BBREG_0x81c, 0xC0320403,  BBREG_0x81c,
	0xA4340403,  BBREG_0x81c, 0xA3360403,  BBREG_0x81c, 0xA2380403,
	BBREG_0x81c, 0xA13A0403,  BBREG_0x81c, 0xA03C0403,  BBREG_0x81c,
	0x823E0403,  BBREG_0x81c, 0x81400403,  BBREG_0x81c, 0x80420403,
	BBREG_0x81c, 0x64440403,  BBREG_0x81c, 0x63460403,  BBREG_0x81c,
	0x62480403,  BBREG_0x81c, 0x614A0403,  BBREG_0x81c, 0x604C0403,
	BBREG_0x81c, 0x454E0403,  BBREG_0x81c, 0x44500403,  BBREG_0x81c,
	0x43520403,  BBREG_0x81c, 0x42540403,  BBREG_0x81c, 0x41560403,
	BBREG_0x81c, 0x40580403,  BBREG_0x81c, 0x055A0403,  BBREG_0x81c,
	0x045C0403,  BBREG_0x81c, 0x035E0403,  BBREG_0x81c, 0x02600403,
	BBREG_0x81c, 0x01620403,  BBREG_0x81c, 0x00640403,  BBREG_0x81c,
	0x00660403,  BBREG_0x81c, 0x00680403,  BBREG_0x81c, 0x006A0403,
	BBREG_0x81c, 0x006C0403,  BBREG_0x81c, 0x006E0403,  BBREG_0x81c,
	0x00700403,  BBREG_0x81c, 0x00720403,  BBREG_0x81c, 0x00740403,
	BBREG_0x81c, 0x00760403,  BBREG_0x81c, 0x00780403,  BBREG_0x81c,
	0x007A0403,  BBREG_0x81c, 0x007C0403,  BBREG_0x81c, 0x007E0403,
	0x9000000a,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c,
	0xFF000403,  BBREG_0x81c, 0xFF000403,  BBREG_0x81c, 0xFF020403,
	BBREG_0x81c, 0xFE040403,  BBREG_0x81c, 0xFD060403,  BBREG_0x81c,
	0xFC080403,  BBREG_0x81c, 0xFB0A0403,  BBREG_0x81c, 0xFA0C0403,
	BBREG_0x81c, 0xF90E0403,  BBREG_0x81c, 0xF8100403,  BBREG_0x81c,
	0xF7120403,  BBREG_0x81c, 0xF6140403,  BBREG_0x81c, 0xF5160403,
	BBREG_0x81c, 0xF4180403,  BBREG_0x81c, 0xF31A0403,  BBREG_0x81c,
	0xF21C0403,  BBREG_0x81c, 0xD51E0403,  BBREG_0x81c, 0xD4200403,
	BBREG_0x81c, 0xD3220403,  BBREG_0x81c, 0xD2240403,  BBREG_0x81c,
	0xB6260403,  BBREG_0x81c, 0xB5280403,  BBREG_0x81c, 0xB42A0403,
	BBREG_0x81c, 0xB32C0403,  BBREG_0x81c, 0xB22E0403,  BBREG_0x81c,
	0xB1300403,  BBREG_0x81c, 0xB0320403,  BBREG_0x81c, 0xAF340403,
	BBREG_0x81c, 0xAE360403,  BBREG_0x81c, 0xAD380403,  BBREG_0x81c,
	0xAC3A0403,  BBREG_0x81c, 0xAB3C0403,  BBREG_0x81c, 0xAA3E0403,
	BBREG_0x81c, 0xA9400403,  BBREG_0x81c, 0xA8420403,  BBREG_0x81c,
	0xA7440403,  BBREG_0x81c, 0xA6460403,  BBREG_0x81c, 0xA5480403,
	BBREG_0x81c, 0xA44A0403,  BBREG_0x81c, 0xA34C0403,  BBREG_0x81c,
	0x854E0403,  BBREG_0x81c, 0x84500403,  BBREG_0x81c, 0x83520403,
	BBREG_0x81c, 0x82540403,  BBREG_0x81c, 0x81560403,  BBREG_0x81c,
	0x80580403,  BBREG_0x81c, 0x485A0403,  BBREG_0x81c, 0x475C0403,
	BBREG_0x81c, 0x465E0403,  BBREG_0x81c, 0x45600403,  BBREG_0x81c,
	0x44620403,  BBREG_0x81c, 0x0A640403,  BBREG_0x81c, 0x09660403,
	BBREG_0x81c, 0x08680403,  BBREG_0x81c, 0x076A0403,  BBREG_0x81c,
	0x066C0403,  BBREG_0x81c, 0x056E0403,  BBREG_0x81c, 0x04700403,
	BBREG_0x81c, 0x03720403,  BBREG_0x81c, 0x02740403,  BBREG_0x81c,
	0x01760403,  BBREG_0x81c, 0x00780403,  BBREG_0x81c, 0x007A0403,
	BBREG_0x81c, 0x007C0403,  BBREG_0x81c, 0x007E0403,  0x9000000b,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c, 0xFF000403,
	BBREG_0x81c, 0xF5000403,  BBREG_0x81c, 0xF4020403,  BBREG_0x81c,
	0xF3040403,  BBREG_0x81c, 0xF2060403,  BBREG_0x81c, 0xF1080403,
	BBREG_0x81c, 0xF00A0403,  BBREG_0x81c, 0xEF0C0403,  BBREG_0x81c,
	0xEE0E0403,  BBREG_0x81c, 0xED100403,  BBREG_0x81c, 0xEC120403,
	BBREG_0x81c, 0xEB140403,  BBREG_0x81c, 0xEA160403,  BBREG_0x81c,
	0xE9180403,  BBREG_0x81c, 0xE81A0403,  BBREG_0x81c, 0xE71C0403,
	BBREG_0x81c, 0xE61E0403,  BBREG_0x81c, 0xE5200403,  BBREG_0x81c,
	0xE4220403,  BBREG_0x81c, 0xE3240403,  BBREG_0x81c, 0xE2260403,
	BBREG_0x81c, 0xE1280403,  BBREG_0x81c, 0xE02A0403,  BBREG_0x81c,
	0xC32C0403,  BBREG_0x81c, 0xC22E0403,  BBREG_0x81c, 0xC1300403,
	BBREG_0x81c, 0xC0320403,  BBREG_0x81c, 0xA4340403,  BBREG_0x81c,
	0xA3360403,  BBREG_0x81c, 0xA2380403,  BBREG_0x81c, 0xA13A0403,
	BBREG_0x81c, 0xA03C0403,  BBREG_0x81c, 0x823E0403,  BBREG_0x81c,
	0x81400403,  BBREG_0x81c, 0x80420403,  BBREG_0x81c, 0x64440403,
	BBREG_0x81c, 0x63460403,  BBREG_0x81c, 0x62480403,  BBREG_0x81c,
	0x614A0403,  BBREG_0x81c, 0x604C0403,  BBREG_0x81c, 0x454E0403,
	BBREG_0x81c, 0x44500403,  BBREG_0x81c, 0x43520403,  BBREG_0x81c,
	0x42540403,  BBREG_0x81c, 0x41560403,  BBREG_0x81c, 0x40580403,
	BBREG_0x81c, 0x055A0403,  BBREG_0x81c, 0x045C0403,  BBREG_0x81c,
	0x035E0403,  BBREG_0x81c, 0x02600403,  BBREG_0x81c, 0x01620403,
	BBREG_0x81c, 0x00640403,  BBREG_0x81c, 0x00660403,  BBREG_0x81c,
	0x00680403,  BBREG_0x81c, 0x006A0403,  BBREG_0x81c, 0x006C0403,
	BBREG_0x81c, 0x006E0403,  BBREG_0x81c, 0x00700403,  BBREG_0x81c,
	0x00720403,  BBREG_0x81c, 0x00740403,  BBREG_0x81c, 0x00760403,
	BBREG_0x81c, 0x00780403,  BBREG_0x81c, 0x007A0403,  BBREG_0x81c,
	0x007C0403,  BBREG_0x81c, 0x007E0403,  0x9000000c,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x81c, 0xFF000403,  BBREG_0x81c,
	0xFF000403,  BBREG_0x81c, 0xFF020403,  BBREG_0x81c, 0xFE040403,
	BBREG_0x81c, 0xFD060403,  BBREG_0x81c, 0xFC080403,  BBREG_0x81c,
	0xFB0A0403,  BBREG_0x81c, 0xFA0C0403,  BBREG_0x81c, 0xF90E0403,
	BBREG_0x81c, 0xF8100403,  BBREG_0x81c, 0xF7120403,  BBREG_0x81c,
	0xF6140403,  BBREG_0x81c, 0xF5160403,  BBREG_0x81c, 0xF4180403,
	BBREG_0x81c, 0xF31A0403,  BBREG_0x81c, 0xF21C0403,  BBREG_0x81c,
	0xD51E0403,  BBREG_0x81c, 0xD4200403,  BBREG_0x81c, 0xD3220403,
	BBREG_0x81c, 0xD2240403,  BBREG_0x81c, 0xB6260403,  BBREG_0x81c,
	0xB5280403,  BBREG_0x81c, 0xB42A0403,  BBREG_0x81c, 0xB32C0403,
	BBREG_0x81c, 0xB22E0403,  BBREG_0x81c, 0xB1300403,  BBREG_0x81c,
	0xB0320403,  BBREG_0x81c, 0xAF340403,  BBREG_0x81c, 0xAE360403,
	BBREG_0x81c, 0xAD380403,  BBREG_0x81c, 0xAC3A0403,  BBREG_0x81c,
	0xAB3C0403,  BBREG_0x81c, 0xAA3E0403,  BBREG_0x81c, 0xA9400403,
	BBREG_0x81c, 0xA8420403,  BBREG_0x81c, 0xA7440403,  BBREG_0x81c,
	0xA6460403,  BBREG_0x81c, 0xA5480403,  BBREG_0x81c, 0xA44A0403,
	BBREG_0x81c, 0xA34C0403,  BBREG_0x81c, 0x854E0403,  BBREG_0x81c,
	0x84500403,  BBREG_0x81c, 0x83520403,  BBREG_0x81c, 0x82540403,
	BBREG_0x81c, 0x81560403,  BBREG_0x81c, 0x80580403,  BBREG_0x81c,
	0x485A0403,  BBREG_0x81c, 0x475C0403,  BBREG_0x81c, 0x465E0403,
	BBREG_0x81c, 0x45600403,  BBREG_0x81c, 0x44620403,  BBREG_0x81c,
	0x0A640403,  BBREG_0x81c, 0x09660403,  BBREG_0x81c, 0x08680403,
	BBREG_0x81c, 0x076A0403,  BBREG_0x81c, 0x066C0403,  BBREG_0x81c,
	0x056E0403,  BBREG_0x81c, 0x04700403,  BBREG_0x81c, 0x03720403,
	BBREG_0x81c, 0x02740403,  BBREG_0x81c, 0x01760403,  BBREG_0x81c,
	0x00780403,  BBREG_0x81c, 0x007A0403,  BBREG_0x81c, 0x007C0403,
	BBREG_0x81c, 0x007E0403,  0x9000000d,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x81c, 0xFF000403,  BBREG_0x81c, 0xFF000403,
	BBREG_0x81c, 0xFF020403,  BBREG_0x81c, 0xFE040403,  BBREG_0x81c,
	0xFD060403,  BBREG_0x81c, 0xFC080403,  BBREG_0x81c, 0xFB0A0403,
	BBREG_0x81c, 0xFA0C0403,  BBREG_0x81c, 0xF90E0403,  BBREG_0x81c,
	0xF8100403,  BBREG_0x81c, 0xF7120403,  BBREG_0x81c, 0xF6140403,
	BBREG_0x81c, 0xF5160403,  BBREG_0x81c, 0xF4180403,  BBREG_0x81c,
	0xF31A0403,  BBREG_0x81c, 0xF21C0403,  BBREG_0x81c, 0xD51E0403,
	BBREG_0x81c, 0xD4200403,  BBREG_0x81c, 0xD3220403,  BBREG_0x81c,
	0xD2240403,  BBREG_0x81c, 0xB6260403,  BBREG_0x81c, 0xB5280403,
	BBREG_0x81c, 0xB42A0403,  BBREG_0x81c, 0xB32C0403,  BBREG_0x81c,
	0xB22E0403,  BBREG_0x81c, 0xB1300403,  BBREG_0x81c, 0xB0320403,
	BBREG_0x81c, 0xAF340403,  BBREG_0x81c, 0xAE360403,  BBREG_0x81c,
	0xAD380403,  BBREG_0x81c, 0xAC3A0403,  BBREG_0x81c, 0xAB3C0403,
	BBREG_0x81c, 0xAA3E0403,  BBREG_0x81c, 0xA9400403,  BBREG_0x81c,
	0xA8420403,  BBREG_0x81c, 0xA7440403,  BBREG_0x81c, 0xA6460403,
	BBREG_0x81c, 0xA5480403,  BBREG_0x81c, 0xA44A0403,  BBREG_0x81c,
	0xA34C0403,  BBREG_0x81c, 0x854E0403,  BBREG_0x81c, 0x84500403,
	BBREG_0x81c, 0x83520403,  BBREG_0x81c, 0x82540403,  BBREG_0x81c,
	0x81560403,  BBREG_0x81c, 0x80580403,  BBREG_0x81c, 0x485A0403,
	BBREG_0x81c, 0x475C0403,  BBREG_0x81c, 0x465E0403,  BBREG_0x81c,
	0x45600403,  BBREG_0x81c, 0x44620403,  BBREG_0x81c, 0x0A640403,
	BBREG_0x81c, 0x09660403,  BBREG_0x81c, 0x08680403,  BBREG_0x81c,
	0x076A0403,  BBREG_0x81c, 0x066C0403,  BBREG_0x81c, 0x056E0403,
	BBREG_0x81c, 0x04700403,  BBREG_0x81c, 0x03720403,  BBREG_0x81c,
	0x02740403,  BBREG_0x81c, 0x01760403,  BBREG_0x81c, 0x00780403,
	BBREG_0x81c, 0x007A0403,  BBREG_0x81c, 0x007C0403,  BBREG_0x81c,
	0x007E0403,  0x9000000e,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x81c, 0xFF000403,  BBREG_0x81c, 0xFF000403,  BBREG_0x81c,
	0xFF020403,  BBREG_0x81c, 0xFE040403,  BBREG_0x81c, 0xFD060403,
	BBREG_0x81c, 0xFC080403,  BBREG_0x81c, 0xFB0A0403,  BBREG_0x81c,
	0xFA0C0403,  BBREG_0x81c, 0xF90E0403,  BBREG_0x81c, 0xF8100403,
	BBREG_0x81c, 0xF7120403,  BBREG_0x81c, 0xF6140403,  BBREG_0x81c,
	0xF5160403,  BBREG_0x81c, 0xF4180403,  BBREG_0x81c, 0xF31A0403,
	BBREG_0x81c, 0xF21C0403,  BBREG_0x81c, 0xD51E0403,  BBREG_0x81c,
	0xD4200403,  BBREG_0x81c, 0xD3220403,  BBREG_0x81c, 0xD2240403,
	BBREG_0x81c, 0xB6260403,  BBREG_0x81c, 0xB5280403,  BBREG_0x81c,
	0xB42A0403,  BBREG_0x81c, 0xB32C0403,  BBREG_0x81c, 0xB22E0403,
	BBREG_0x81c, 0xB1300403,  BBREG_0x81c, 0xB0320403,  BBREG_0x81c,
	0xAF340403,  BBREG_0x81c, 0xAE360403,  BBREG_0x81c, 0xAD380403,
	BBREG_0x81c, 0xAC3A0403,  BBREG_0x81c, 0xAB3C0403,  BBREG_0x81c,
	0xAA3E0403,  BBREG_0x81c, 0xA9400403,  BBREG_0x81c, 0xA8420403,
	BBREG_0x81c, 0xA7440403,  BBREG_0x81c, 0xA6460403,  BBREG_0x81c,
	0xA5480403,  BBREG_0x81c, 0xA44A0403,  BBREG_0x81c, 0xA34C0403,
	BBREG_0x81c, 0x854E0403,  BBREG_0x81c, 0x84500403,  BBREG_0x81c,
	0x83520403,  BBREG_0x81c, 0x82540403,  BBREG_0x81c, 0x81560403,
	BBREG_0x81c, 0x80580403,  BBREG_0x81c, 0x485A0403,  BBREG_0x81c,
	0x475C0403,  BBREG_0x81c, 0x465E0403,  BBREG_0x81c, 0x45600403,
	BBREG_0x81c, 0x44620403,  BBREG_0x81c, 0x0A640403,  BBREG_0x81c,
	0x09660403,  BBREG_0x81c, 0x08680403,  BBREG_0x81c, 0x076A0403,
	BBREG_0x81c, 0x066C0403,  BBREG_0x81c, 0x056E0403,  BBREG_0x81c,
	0x04700403,  BBREG_0x81c, 0x03720403,  BBREG_0x81c, 0x02740403,
	BBREG_0x81c, 0x01760403,  BBREG_0x81c, 0x00780403,  BBREG_0x81c,
	0x007A0403,  BBREG_0x81c, 0x007C0403,  BBREG_0x81c, 0x007E0403,
	0x9000000f,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c,
	0xFF000403,  BBREG_0x81c, 0xFF000403,  BBREG_0x81c, 0xFF020403,
	BBREG_0x81c, 0xFE040403,  BBREG_0x81c, 0xFD060403,  BBREG_0x81c,
	0xFC080403,  BBREG_0x81c, 0xFB0A0403,  BBREG_0x81c, 0xFA0C0403,
	BBREG_0x81c, 0xF90E0403,  BBREG_0x81c, 0xF8100403,  BBREG_0x81c,
	0xF7120403,  BBREG_0x81c, 0xF6140403,  BBREG_0x81c, 0xF5160403,
	BBREG_0x81c, 0xF4180403,  BBREG_0x81c, 0xF31A0403,  BBREG_0x81c,
	0xF21C0403,  BBREG_0x81c, 0xD51E0403,  BBREG_0x81c, 0xD4200403,
	BBREG_0x81c, 0xD3220403,  BBREG_0x81c, 0xD2240403,  BBREG_0x81c,
	0xB6260403,  BBREG_0x81c, 0xB5280403,  BBREG_0x81c, 0xB42A0403,
	BBREG_0x81c, 0xB32C0403,  BBREG_0x81c, 0xB22E0403,  BBREG_0x81c,
	0xB1300403,  BBREG_0x81c, 0xB0320403,  BBREG_0x81c, 0xAF340403,
	BBREG_0x81c, 0xAE360403,  BBREG_0x81c, 0xAD380403,  BBREG_0x81c,
	0xAC3A0403,  BBREG_0x81c, 0xAB3C0403,  BBREG_0x81c, 0xAA3E0403,
	BBREG_0x81c, 0xA9400403,  BBREG_0x81c, 0xA8420403,  BBREG_0x81c,
	0xA7440403,  BBREG_0x81c, 0xA6460403,  BBREG_0x81c, 0xA5480403,
	BBREG_0x81c, 0xA44A0403,  BBREG_0x81c, 0xA34C0403,  BBREG_0x81c,
	0x854E0403,  BBREG_0x81c, 0x84500403,  BBREG_0x81c, 0x83520403,
	BBREG_0x81c, 0x82540403,  BBREG_0x81c, 0x81560403,  BBREG_0x81c,
	0x80580403,  BBREG_0x81c, 0x485A0403,  BBREG_0x81c, 0x475C0403,
	BBREG_0x81c, 0x465E0403,  BBREG_0x81c, 0x45600403,  BBREG_0x81c,
	0x44620403,  BBREG_0x81c, 0x0A640403,  BBREG_0x81c, 0x09660403,
	BBREG_0x81c, 0x08680403,  BBREG_0x81c, 0x076A0403,  BBREG_0x81c,
	0x066C0403,  BBREG_0x81c, 0x056E0403,  BBREG_0x81c, 0x04700403,
	BBREG_0x81c, 0x03720403,  BBREG_0x81c, 0x02740403,  BBREG_0x81c,
	0x01760403,  BBREG_0x81c, 0x00780403,  BBREG_0x81c, 0x007A0403,
	BBREG_0x81c, 0x007C0403,  BBREG_0x81c, 0x007E0403,  0x90000010,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c, 0xFF000403,
	BBREG_0x81c, 0xFF000403,  BBREG_0x81c, 0xFF020403,  BBREG_0x81c,
	0xFE040403,  BBREG_0x81c, 0xFD060403,  BBREG_0x81c, 0xFC080403,
	BBREG_0x81c, 0xFB0A0403,  BBREG_0x81c, 0xFA0C0403,  BBREG_0x81c,
	0xF90E0403,  BBREG_0x81c, 0xF8100403,  BBREG_0x81c, 0xF7120403,
	BBREG_0x81c, 0xF6140403,  BBREG_0x81c, 0xF5160403,  BBREG_0x81c,
	0xF4180403,  BBREG_0x81c, 0xF31A0403,  BBREG_0x81c, 0xF21C0403,
	BBREG_0x81c, 0xD51E0403,  BBREG_0x81c, 0xD4200403,  BBREG_0x81c,
	0xD3220403,  BBREG_0x81c, 0xD2240403,  BBREG_0x81c, 0xB6260403,
	BBREG_0x81c, 0xB5280403,  BBREG_0x81c, 0xB42A0403,  BBREG_0x81c,
	0xB32C0403,  BBREG_0x81c, 0xB22E0403,  BBREG_0x81c, 0xB1300403,
	BBREG_0x81c, 0xB0320403,  BBREG_0x81c, 0xAF340403,  BBREG_0x81c,
	0xAE360403,  BBREG_0x81c, 0xAD380403,  BBREG_0x81c, 0xAC3A0403,
	BBREG_0x81c, 0xAB3C0403,  BBREG_0x81c, 0xAA3E0403,  BBREG_0x81c,
	0xA9400403,  BBREG_0x81c, 0xA8420403,  BBREG_0x81c, 0xA7440403,
	BBREG_0x81c, 0xA6460403,  BBREG_0x81c, 0xA5480403,  BBREG_0x81c,
	0xA44A0403,  BBREG_0x81c, 0xA34C0403,  BBREG_0x81c, 0x854E0403,
	BBREG_0x81c, 0x84500403,  BBREG_0x81c, 0x83520403,  BBREG_0x81c,
	0x82540403,  BBREG_0x81c, 0x81560403,  BBREG_0x81c, 0x80580403,
	BBREG_0x81c, 0x485A0403,  BBREG_0x81c, 0x475C0403,  BBREG_0x81c,
	0x465E0403,  BBREG_0x81c, 0x45600403,  BBREG_0x81c, 0x44620403,
	BBREG_0x81c, 0x0A640403,  BBREG_0x81c, 0x09660403,  BBREG_0x81c,
	0x08680403,  BBREG_0x81c, 0x076A0403,  BBREG_0x81c, 0x066C0403,
	BBREG_0x81c, 0x056E0403,  BBREG_0x81c, 0x04700403,  BBREG_0x81c,
	0x03720403,  BBREG_0x81c, 0x02740403,  BBREG_0x81c, 0x01760403,
	BBREG_0x81c, 0x00780403,  BBREG_0x81c, 0x007A0403,  BBREG_0x81c,
	0x007C0403,  BBREG_0x81c, 0x007E0403,  0xA0000000,  0x00000000,
	BBREG_0x81c, 0xFF000403,  BBREG_0x81c, 0xFF000403,  BBREG_0x81c,
	0xFF020403,  BBREG_0x81c, 0xFE040403,  BBREG_0x81c, 0xFD060403,
	BBREG_0x81c, 0xFC080403,  BBREG_0x81c, 0xFB0A0403,  BBREG_0x81c,
	0xFA0C0403,  BBREG_0x81c, 0xF90E0403,  BBREG_0x81c, 0xF8100403,
	BBREG_0x81c, 0xF7120403,  BBREG_0x81c, 0xF6140403,  BBREG_0x81c,
	0xF5160403,  BBREG_0x81c, 0xF4180403,  BBREG_0x81c, 0xF31A0403,
	BBREG_0x81c, 0xF21C0403,  BBREG_0x81c, 0xD51E0403,  BBREG_0x81c,
	0xD4200403,  BBREG_0x81c, 0xD3220403,  BBREG_0x81c, 0xD2240403,
	BBREG_0x81c, 0xB6260403,  BBREG_0x81c, 0xB5280403,  BBREG_0x81c,
	0xB42A0403,  BBREG_0x81c, 0xB32C0403,  BBREG_0x81c, 0xB22E0403,
	BBREG_0x81c, 0xB1300403,  BBREG_0x81c, 0xB0320403,  BBREG_0x81c,
	0xAF340403,  BBREG_0x81c, 0xAE360403,  BBREG_0x81c, 0xAD380403,
	BBREG_0x81c, 0xAC3A0403,  BBREG_0x81c, 0xAB3C0403,  BBREG_0x81c,
	0xAA3E0403,  BBREG_0x81c, 0xA9400403,  BBREG_0x81c, 0xA8420403,
	BBREG_0x81c, 0xA7440403,  BBREG_0x81c, 0xA6460403,  BBREG_0x81c,
	0xA5480403,  BBREG_0x81c, 0xA44A0403,  BBREG_0x81c, 0xA34C0403,
	BBREG_0x81c, 0x854E0403,  BBREG_0x81c, 0x84500403,  BBREG_0x81c,
	0x83520403,  BBREG_0x81c, 0x82540403,  BBREG_0x81c, 0x81560403,
	BBREG_0x81c, 0x80580403,  BBREG_0x81c, 0x485A0403,  BBREG_0x81c,
	0x475C0403,  BBREG_0x81c, 0x465E0403,  BBREG_0x81c, 0x45600403,
	BBREG_0x81c, 0x44620403,  BBREG_0x81c, 0x0A640403,  BBREG_0x81c,
	0x09660403,  BBREG_0x81c, 0x08680403,  BBREG_0x81c, 0x076A0403,
	BBREG_0x81c, 0x066C0403,  BBREG_0x81c, 0x056E0403,  BBREG_0x81c,
	0x04700403,  BBREG_0x81c, 0x03720403,  BBREG_0x81c, 0x02740403,
	BBREG_0x81c, 0x01760403,  BBREG_0x81c, 0x00780403,  BBREG_0x81c,
	0x007A0403,  BBREG_0x81c, 0x007C0403,  BBREG_0x81c, 0x007E0403,
	0xB0000000,  0x00000000,  0x80000000,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x81c, 0xFD000503,  BBREG_0x81c, 0xFC020503,
	BBREG_0x81c, 0xFB040503,  BBREG_0x81c, 0xFA060503,  BBREG_0x81c,
	0xF9080503,  BBREG_0x81c, 0xF80A0503,  BBREG_0x81c, 0xF70C0503,
	BBREG_0x81c, 0xF60E0503,  BBREG_0x81c, 0xF5100503,  BBREG_0x81c,
	0xF4120503,  BBREG_0x81c, 0xF3140503,  BBREG_0x81c, 0xF2160503,
	BBREG_0x81c, 0xF1180503,  BBREG_0x81c, 0xF01A0503,  BBREG_0x81c,
	0xEE1C0503,  BBREG_0x81c, 0xED1E0503,  BBREG_0x81c, 0xEC200503,
	BBREG_0x81c, 0xEB220503,  BBREG_0x81c, 0xEA240503,  BBREG_0x81c,
	0xE9260503,  BBREG_0x81c, 0xE8280503,  BBREG_0x81c, 0xE72A0503,
	BBREG_0x81c, 0xE62C0503,  BBREG_0x81c, 0xE52E0503,  BBREG_0x81c,
	0xE4300503,  BBREG_0x81c, 0xE3320503,  BBREG_0x81c, 0xE2340503,
	BBREG_0x81c, 0xC5360503,  BBREG_0x81c, 0xC4380503,  BBREG_0x81c,
	0xC33A0503,  BBREG_0x81c, 0xC23C0503,  BBREG_0x81c, 0xA53E0503,
	BBREG_0x81c, 0xA4400503,  BBREG_0x81c, 0xA3420503,  BBREG_0x81c,
	0xA2440503,  BBREG_0x81c, 0xA1460503,  BBREG_0x81c, 0x83480503,
	BBREG_0x81c, 0x824A0503,  BBREG_0x81c, 0x814C0503,  BBREG_0x81c,
	0x804E0503,  BBREG_0x81c, 0x63500503,  BBREG_0x81c, 0x62520503,
	BBREG_0x81c, 0x61540503,  BBREG_0x81c, 0x43560503,  BBREG_0x81c,
	0x42580503,  BBREG_0x81c, 0x415A0503,  BBREG_0x81c, 0x405C0503,
	BBREG_0x81c, 0x225E0503,  BBREG_0x81c, 0x21600503,  BBREG_0x81c,
	0x20620503,  BBREG_0x81c, 0x03640503,  BBREG_0x81c, 0x02660503,
	BBREG_0x81c, 0x01680503,  BBREG_0x81c, 0x006A0503,  BBREG_0x81c,
	0x006C0503,  BBREG_0x81c, 0x006E0503,  BBREG_0x81c, 0x00700503,
	BBREG_0x81c, 0x00720503,  BBREG_0x81c, 0x00740503,  BBREG_0x81c,
	0x00760503,  BBREG_0x81c, 0x00780503,  BBREG_0x81c, 0x007A0503,
	BBREG_0x81c, 0x007C0503,  BBREG_0x81c, 0x007E0503,  BBREG_0x81c,
	0x007E0503,  0x90000001,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x81c, 0xBE000503,  BBREG_0x81c, 0xBD020503,  BBREG_0x81c,
	0xBC040503,  BBREG_0x81c, 0xBB060503,  BBREG_0x81c, 0xBA080503,
	BBREG_0x81c, 0xB90A0503,  BBREG_0x81c, 0xB80C0503,  BBREG_0x81c,
	0xB70E0503,  BBREG_0x81c, 0xB6100503,  BBREG_0x81c, 0xB5120503,
	BBREG_0x81c, 0xB4140503,  BBREG_0x81c, 0xB3160503,  BBREG_0x81c,
	0xB2180503,  BBREG_0x81c, 0xB11A0503,  BBREG_0x81c, 0xB01C0503,
	BBREG_0x81c, 0xAF1E0503,  BBREG_0x81c, 0xAE200503,  BBREG_0x81c,
	0xAD220503,  BBREG_0x81c, 0xAC240503,  BBREG_0x81c, 0xAB260503,
	BBREG_0x81c, 0x8D280503,  BBREG_0x81c, 0x8C2A0503,  BBREG_0x81c,
	0x8B2C0503,  BBREG_0x81c, 0x8A2E0503,  BBREG_0x81c, 0x89300503,
	BBREG_0x81c, 0x88320503,  BBREG_0x81c, 0x6A340503,  BBREG_0x81c,
	0x69360503,  BBREG_0x81c, 0x68380503,  BBREG_0x81c, 0x673A0503,
	BBREG_0x81c, 0x663C0503,  BBREG_0x81c, 0x653E0503,  BBREG_0x81c,
	0x64400503,  BBREG_0x81c, 0x63420503,  BBREG_0x81c, 0x62440503,
	BBREG_0x81c, 0x61460503,  BBREG_0x81c, 0x60480503,  BBREG_0x81c,
	0x424A0503,  BBREG_0x81c, 0x414C0503,  BBREG_0x81c, 0x404E0503,
	BBREG_0x81c, 0x06500503,  BBREG_0x81c, 0x05520503,  BBREG_0x81c,
	0x04540503,  BBREG_0x81c, 0x03560503,  BBREG_0x81c, 0x02580503,
	BBREG_0x81c, 0x015A0503,  BBREG_0x81c, 0x005C0503,  BBREG_0x81c,
	0x005E0503,  BBREG_0x81c, 0x00600503,  BBREG_0x81c, 0x00620503,
	BBREG_0x81c, 0x00640503,  BBREG_0x81c, 0x00660503,  BBREG_0x81c,
	0x00680503,  BBREG_0x81c, 0x006A0503,  BBREG_0x81c, 0x006C0503,
	BBREG_0x81c, 0x006E0503,  BBREG_0x81c, 0x00700503,  BBREG_0x81c,
	0x00720503,  BBREG_0x81c, 0x00740503,  BBREG_0x81c, 0x00760503,
	BBREG_0x81c, 0x00780503,  BBREG_0x81c, 0x007A0503,  BBREG_0x81c,
	0x007C0503,  BBREG_0x81c, 0x007E0503,  BBREG_0x81c, 0x007C0503,
	0x90000002,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c,
	0xF8000503,  BBREG_0x81c, 0xF7020503,  BBREG_0x81c, 0xF6040503,
	BBREG_0x81c, 0xF5060503,  BBREG_0x81c, 0xF4080503,  BBREG_0x81c,
	0xF30A0503,  BBREG_0x81c, 0xF20C0503,  BBREG_0x81c, 0xF10E0503,
	BBREG_0x81c, 0xF0100503,  BBREG_0x81c, 0xEF120503,  BBREG_0x81c,
	0xEE140503,  BBREG_0x81c, 0xED160503,  BBREG_0x81c, 0xEC180503,
	BBREG_0x81c, 0xEB1A0503,  BBREG_0x81c, 0xEA1C0503,  BBREG_0x81c,
	0xE91E0503,  BBREG_0x81c, 0xE8200503,  BBREG_0x81c, 0xE7220503,
	BBREG_0x81c, 0xE6240503,  BBREG_0x81c, 0xE5260503,  BBREG_0x81c,
	0xE4280503,  BBREG_0x81c, 0xE32A0503,  BBREG_0x81c, 0xC32C0503,
	BBREG_0x81c, 0xC22E0503,  BBREG_0x81c, 0xC1300503,  BBREG_0x81c,
	0xC0320503,  BBREG_0x81c, 0xA3340503,  BBREG_0x81c, 0xA2360503,
	BBREG_0x81c, 0xA1380503,  BBREG_0x81c, 0xA03A0503,  BBREG_0x81c,
	0x823C0503,  BBREG_0x81c, 0x813E0503,  BBREG_0x81c, 0x80400503,
	BBREG_0x81c, 0x63420503,  BBREG_0x81c, 0x62440503,  BBREG_0x81c,
	0x61460503,  BBREG_0x81c, 0x60480503,  BBREG_0x81c, 0x424A0503,
	BBREG_0x81c, 0x414C0503,  BBREG_0x81c, 0x404E0503,  BBREG_0x81c,
	0x22500503,  BBREG_0x81c, 0x21520503,  BBREG_0x81c, 0x20540503,
	BBREG_0x81c, 0x03560503,  BBREG_0x81c, 0x02580503,  BBREG_0x81c,
	0x015A0503,  BBREG_0x81c, 0x005C0503,  BBREG_0x81c, 0x005E0503,
	BBREG_0x81c, 0x00600503,  BBREG_0x81c, 0x00620503,  BBREG_0x81c,
	0x00640503,  BBREG_0x81c, 0x00660503,  BBREG_0x81c, 0x00680503,
	BBREG_0x81c, 0x006A0503,  BBREG_0x81c, 0x006C0503,  BBREG_0x81c,
	0x006E0503,  BBREG_0x81c, 0x00700503,  BBREG_0x81c, 0x00720503,
	BBREG_0x81c, 0x00740503,  BBREG_0x81c, 0x00760503,  BBREG_0x81c,
	0x00780503,  BBREG_0x81c, 0x007A0503,  BBREG_0x81c, 0x007C0503,
	BBREG_0x81c, 0x007E0503,  BBREG_0x81c, 0x007E0503,  0x90000003,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c, 0xFE000503,
	BBREG_0x81c, 0xFD020503,  BBREG_0x81c, 0xFC040503,  BBREG_0x81c,
	0xFB060503,  BBREG_0x81c, 0xFA080503,  BBREG_0x81c, 0xF90A0503,
	BBREG_0x81c, 0xF80C0503,  BBREG_0x81c, 0xF70E0503,  BBREG_0x81c,
	0xF6100503,  BBREG_0x81c, 0xF5120503,  BBREG_0x81c, 0xF4140503,
	BBREG_0x81c, 0xF3160503,  BBREG_0x81c, 0xF2180503,  BBREG_0x81c,
	0xF11A0503,  BBREG_0x81c, 0xF01C0503,  BBREG_0x81c, 0xEF1E0503,
	BBREG_0x81c, 0xEE200503,  BBREG_0x81c, 0xED220503,  BBREG_0x81c,
	0xEC240503,  BBREG_0x81c, 0xEB260503,  BBREG_0x81c, 0xEA280503,
	BBREG_0x81c, 0xE92A0503,  BBREG_0x81c, 0xE82C0503,  BBREG_0x81c,
	0xE72E0503,  BBREG_0x81c, 0xE6300503,  BBREG_0x81c, 0xE5320503,
	BBREG_0x81c, 0xE4340503,  BBREG_0x81c, 0xE3360503,  BBREG_0x81c,
	0xC6380503,  BBREG_0x81c, 0xC53A0503,  BBREG_0x81c, 0xC43C0503,
	BBREG_0x81c, 0xC33E0503,  BBREG_0x81c, 0xA5400503,  BBREG_0x81c,
	0xA4420503,  BBREG_0x81c, 0xA3440503,  BBREG_0x81c, 0xA2460503,
	BBREG_0x81c, 0xA1480503,  BBREG_0x81c, 0xA04A0503,  BBREG_0x81c,
	0x824C0503,  BBREG_0x81c, 0x814E0503,  BBREG_0x81c, 0x80500503,
	BBREG_0x81c, 0x64520503,  BBREG_0x81c, 0x63540503,  BBREG_0x81c,
	0x62560503,  BBREG_0x81c, 0x61580503,  BBREG_0x81c, 0x605A0503,
	BBREG_0x81c, 0x235C0503,  BBREG_0x81c, 0x225E0503,  BBREG_0x81c,
	0x21600503,  BBREG_0x81c, 0x20620503,  BBREG_0x81c, 0x03640503,
	BBREG_0x81c, 0x02660503,  BBREG_0x81c, 0x01680503,  BBREG_0x81c,
	0x006A0503,  BBREG_0x81c, 0x006C0503,  BBREG_0x81c, 0x006E0503,
	BBREG_0x81c, 0x00700503,  BBREG_0x81c, 0x00720503,  BBREG_0x81c,
	0x00740503,  BBREG_0x81c, 0x00760503,  BBREG_0x81c, 0x00780503,
	BBREG_0x81c, 0x007A0503,  BBREG_0x81c, 0x007C0503,  BBREG_0x81c,
	0x007E0503,  BBREG_0x81c, 0x007E0503,  0x90000004,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x81c, 0xF8000503,  BBREG_0x81c,
	0xF7020503,  BBREG_0x81c, 0xF6040503,  BBREG_0x81c, 0xF5060503,
	BBREG_0x81c, 0xF4080503,  BBREG_0x81c, 0xF30A0503,  BBREG_0x81c,
	0xF20C0503,  BBREG_0x81c, 0xF10E0503,  BBREG_0x81c, 0xF0100503,
	BBREG_0x81c, 0xEF120503,  BBREG_0x81c, 0xEE140503,  BBREG_0x81c,
	0xED160503,  BBREG_0x81c, 0xEC180503,  BBREG_0x81c, 0xEB1A0503,
	BBREG_0x81c, 0xEA1C0503,  BBREG_0x81c, 0xE91E0503,  BBREG_0x81c,
	0xE8200503,  BBREG_0x81c, 0xE7220503,  BBREG_0x81c, 0xE6240503,
	BBREG_0x81c, 0xE5260503,  BBREG_0x81c, 0xE4280503,  BBREG_0x81c,
	0xE32A0503,  BBREG_0x81c, 0xC32C0503,  BBREG_0x81c, 0xC22E0503,
	BBREG_0x81c, 0xC1300503,  BBREG_0x81c, 0xC0320503,  BBREG_0x81c,
	0xA3340503,  BBREG_0x81c, 0xA2360503,  BBREG_0x81c, 0xA1380503,
	BBREG_0x81c, 0xA03A0503,  BBREG_0x81c, 0x823C0503,  BBREG_0x81c,
	0x813E0503,  BBREG_0x81c, 0x80400503,  BBREG_0x81c, 0x63420503,
	BBREG_0x81c, 0x62440503,  BBREG_0x81c, 0x61460503,  BBREG_0x81c,
	0x60480503,  BBREG_0x81c, 0x424A0503,  BBREG_0x81c, 0x414C0503,
	BBREG_0x81c, 0x404E0503,  BBREG_0x81c, 0x22500503,  BBREG_0x81c,
	0x21520503,  BBREG_0x81c, 0x20540503,  BBREG_0x81c, 0x03560503,
	BBREG_0x81c, 0x02580503,  BBREG_0x81c, 0x015A0503,  BBREG_0x81c,
	0x005C0503,  BBREG_0x81c, 0x005E0503,  BBREG_0x81c, 0x00600503,
	BBREG_0x81c, 0x00620503,  BBREG_0x81c, 0x00640503,  BBREG_0x81c,
	0x00660503,  BBREG_0x81c, 0x00680503,  BBREG_0x81c, 0x006A0503,
	BBREG_0x81c, 0x006C0503,  BBREG_0x81c, 0x006E0503,  BBREG_0x81c,
	0x00700503,  BBREG_0x81c, 0x00720503,  BBREG_0x81c, 0x00740503,
	BBREG_0x81c, 0x00760503,  BBREG_0x81c, 0x00780503,  BBREG_0x81c,
	0x007A0503,  BBREG_0x81c, 0x007C0503,  BBREG_0x81c, 0x007E0503,
	BBREG_0x81c, 0x007E0503,  0x90000005,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x81c, 0xFD000503,  BBREG_0x81c, 0xFC020503,
	BBREG_0x81c, 0xFB040503,  BBREG_0x81c, 0xFA060503,  BBREG_0x81c,
	0xF9080503,  BBREG_0x81c, 0xF80A0503,  BBREG_0x81c, 0xF70C0503,
	BBREG_0x81c, 0xF60E0503,  BBREG_0x81c, 0xF5100503,  BBREG_0x81c,
	0xF4120503,  BBREG_0x81c, 0xF3140503,  BBREG_0x81c, 0xF2160503,
	BBREG_0x81c, 0xF1180503,  BBREG_0x81c, 0xF01A0503,  BBREG_0x81c,
	0xEF1C0503,  BBREG_0x81c, 0xEE1E0503,  BBREG_0x81c, 0xED200503,
	BBREG_0x81c, 0xEC220503,  BBREG_0x81c, 0xEB240503,  BBREG_0x81c,
	0xEA260503,  BBREG_0x81c, 0xE9280503,  BBREG_0x81c, 0xE82A0503,
	BBREG_0x81c, 0xE72C0503,  BBREG_0x81c, 0xE62E0503,  BBREG_0x81c,
	0xE5300503,  BBREG_0x81c, 0xE4320503,  BBREG_0x81c, 0xE3340503,
	BBREG_0x81c, 0xE2360503,  BBREG_0x81c, 0xC5380503,  BBREG_0x81c,
	0xC43A0503,  BBREG_0x81c, 0xC33C0503,  BBREG_0x81c, 0xC23E0503,
	BBREG_0x81c, 0xA5400503,  BBREG_0x81c, 0xA4420503,  BBREG_0x81c,
	0xA3440503,  BBREG_0x81c, 0xA2460503,  BBREG_0x81c, 0xA1480503,
	BBREG_0x81c, 0x834A0503,  BBREG_0x81c, 0x824C0503,  BBREG_0x81c,
	0x814E0503,  BBREG_0x81c, 0x64500503,  BBREG_0x81c, 0x63520503,
	BBREG_0x81c, 0x62540503,  BBREG_0x81c, 0x61560503,  BBREG_0x81c,
	0x42580503,  BBREG_0x81c, 0x415A0503,  BBREG_0x81c, 0x405C0503,
	BBREG_0x81c, 0x065E0503,  BBREG_0x81c, 0x05600503,  BBREG_0x81c,
	0x04620503,  BBREG_0x81c, 0x03640503,  BBREG_0x81c, 0x02660503,
	BBREG_0x81c, 0x01680503,  BBREG_0x81c, 0x006A0503,  BBREG_0x81c,
	0x006C0503,  BBREG_0x81c, 0x006E0503,  BBREG_0x81c, 0x00700503,
	BBREG_0x81c, 0x00720503,  BBREG_0x81c, 0x00740503,  BBREG_0x81c,
	0x00760503,  BBREG_0x81c, 0x00780503,  BBREG_0x81c, 0x007A0503,
	BBREG_0x81c, 0x007C0503,  BBREG_0x81c, 0x007E0503,  BBREG_0x81c,
	0x007E0503,  0x90000006,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x81c, 0xFA000503,  BBREG_0x81c, 0xF9020503,  BBREG_0x81c,
	0xF8040503,  BBREG_0x81c, 0xF7060503,  BBREG_0x81c, 0xF6080503,
	BBREG_0x81c, 0xF50A0503,  BBREG_0x81c, 0xF40C0503,  BBREG_0x81c,
	0xF30E0503,  BBREG_0x81c, 0xF2100503,  BBREG_0x81c, 0xF1120503,
	BBREG_0x81c, 0xF0140503,  BBREG_0x81c, 0xEF160503,  BBREG_0x81c,
	0xEE180503,  BBREG_0x81c, 0xED1A0503,  BBREG_0x81c, 0xEC1C0503,
	BBREG_0x81c, 0xEB1E0503,  BBREG_0x81c, 0xEA200503,  BBREG_0x81c,
	0xE9220503,  BBREG_0x81c, 0xE8240503,  BBREG_0x81c, 0xE7260503,
	BBREG_0x81c, 0xE6280503,  BBREG_0x81c, 0xE52A0503,  BBREG_0x81c,
	0xC42C0503,  BBREG_0x81c, 0xC32E0503,  BBREG_0x81c, 0xC2300503,
	BBREG_0x81c, 0xC1320503,  BBREG_0x81c, 0xA4340503,  BBREG_0x81c,
	0xA3360503,  BBREG_0x81c, 0xA2380503,  BBREG_0x81c, 0xA13A0503,
	BBREG_0x81c, 0x833C0503,  BBREG_0x81c, 0x823E0503,  BBREG_0x81c,
	0x81400503,  BBREG_0x81c, 0x63420503,  BBREG_0x81c, 0x62440503,
	BBREG_0x81c, 0x61460503,  BBREG_0x81c, 0x60480503,  BBREG_0x81c,
	0x424A0503,  BBREG_0x81c, 0x414C0503,  BBREG_0x81c, 0x404E0503,
	BBREG_0x81c, 0x22500503,  BBREG_0x81c, 0x21520503,  BBREG_0x81c,
	0x20540503,  BBREG_0x81c, 0x03560503,  BBREG_0x81c, 0x02580503,
	BBREG_0x81c, 0x015A0503,  BBREG_0x81c, 0x005C0503,  BBREG_0x81c,
	0x005E0503,  BBREG_0x81c, 0x00600503,  BBREG_0x81c, 0x00620503,
	BBREG_0x81c, 0x00640503,  BBREG_0x81c, 0x00660503,  BBREG_0x81c,
	0x00680503,  BBREG_0x81c, 0x006A0503,  BBREG_0x81c, 0x006C0503,
	BBREG_0x81c, 0x006E0503,  BBREG_0x81c, 0x00700503,  BBREG_0x81c,
	0x00720503,  BBREG_0x81c, 0x00740503,  BBREG_0x81c, 0x00760503,
	BBREG_0x81c, 0x00780503,  BBREG_0x81c, 0x007A0503,  BBREG_0x81c,
	0x007C0503,  BBREG_0x81c, 0x007E0503,  BBREG_0x81c, 0x007E0503,
	0x90000007,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c,
	0xBF000503,  BBREG_0x81c, 0xBE020503,  BBREG_0x81c, 0xBD040503,
	BBREG_0x81c, 0xBC060503,  BBREG_0x81c, 0xBB080503,  BBREG_0x81c,
	0xBA0A0503,  BBREG_0x81c, 0xB90C0503,  BBREG_0x81c, 0xB80E0503,
	BBREG_0x81c, 0xB7100503,  BBREG_0x81c, 0xB6120503,  BBREG_0x81c,
	0xB5140503,  BBREG_0x81c, 0xB4160503,  BBREG_0x81c, 0xB3180503,
	BBREG_0x81c, 0xB21A0503,  BBREG_0x81c, 0xB11C0503,  BBREG_0x81c,
	0xB01E0503,  BBREG_0x81c, 0xAF200503,  BBREG_0x81c, 0xAE220503,
	BBREG_0x81c, 0xAD240503,  BBREG_0x81c, 0xAC260503,  BBREG_0x81c,
	0xAB280503,  BBREG_0x81c, 0x8D2A0503,  BBREG_0x81c, 0x8C2C0503,
	BBREG_0x81c, 0x8B2E0503,  BBREG_0x81c, 0x8A300503,  BBREG_0x81c,
	0x89320503,  BBREG_0x81c, 0x88340503,  BBREG_0x81c, 0x6A360503,
	BBREG_0x81c, 0x69380503,  BBREG_0x81c, 0x683A0503,  BBREG_0x81c,
	0x673C0503,  BBREG_0x81c, 0x663E0503,  BBREG_0x81c, 0x65400503,
	BBREG_0x81c, 0x64420503,  BBREG_0x81c, 0x63440503,  BBREG_0x81c,
	0x62460503,  BBREG_0x81c, 0x61480503,  BBREG_0x81c, 0x604A0503,
	BBREG_0x81c, 0x424C0503,  BBREG_0x81c, 0x414E0503,  BBREG_0x81c,
	0x40500503,  BBREG_0x81c, 0x06520503,  BBREG_0x81c, 0x05540503,
	BBREG_0x81c, 0x04560503,  BBREG_0x81c, 0x03580503,  BBREG_0x81c,
	0x025A0503,  BBREG_0x81c, 0x015C0503,  BBREG_0x81c, 0x005E0503,
	BBREG_0x81c, 0x00600503,  BBREG_0x81c, 0x00620503,  BBREG_0x81c,
	0x00640503,  BBREG_0x81c, 0x00660503,  BBREG_0x81c, 0x00680503,
	BBREG_0x81c, 0x006A0503,  BBREG_0x81c, 0x006C0503,  BBREG_0x81c,
	0x006E0503,  BBREG_0x81c, 0x00700503,  BBREG_0x81c, 0x00720503,
	BBREG_0x81c, 0x00740503,  BBREG_0x81c, 0x00760503,  BBREG_0x81c,
	0x00780503,  BBREG_0x81c, 0x007A0503,  BBREG_0x81c, 0x007C0503,
	BBREG_0x81c, 0x007E0503,  BBREG_0x81c, 0x007E0503,  0x90000008,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c, 0xFD000503,
	BBREG_0x81c, 0xFC020503,  BBREG_0x81c, 0xFB040503,  BBREG_0x81c,
	0xFA060503,  BBREG_0x81c, 0xF9080503,  BBREG_0x81c, 0xF80A0503,
	BBREG_0x81c, 0xF70C0503,  BBREG_0x81c, 0xF60E0503,  BBREG_0x81c,
	0xF5100503,  BBREG_0x81c, 0xF4120503,  BBREG_0x81c, 0xF3140503,
	BBREG_0x81c, 0xF2160503,  BBREG_0x81c, 0xF1180503,  BBREG_0x81c,
	0xF01A0503,  BBREG_0x81c, 0xEF1C0503,  BBREG_0x81c, 0xEE1E0503,
	BBREG_0x81c, 0xED200503,  BBREG_0x81c, 0xEC220503,  BBREG_0x81c,
	0xEB240503,  BBREG_0x81c, 0xEA260503,  BBREG_0x81c, 0xE9280503,
	BBREG_0x81c, 0xE82A0503,  BBREG_0x81c, 0xE72C0503,  BBREG_0x81c,
	0xE62E0503,  BBREG_0x81c, 0xE5300503,  BBREG_0x81c, 0xE4320503,
	BBREG_0x81c, 0xE3340503,  BBREG_0x81c, 0xC6360503,  BBREG_0x81c,
	0xC5380503,  BBREG_0x81c, 0xC43A0503,  BBREG_0x81c, 0xC33C0503,
	BBREG_0x81c, 0xC23E0503,  BBREG_0x81c, 0xA5400503,  BBREG_0x81c,
	0xA4420503,  BBREG_0x81c, 0xA3440503,  BBREG_0x81c, 0xA2460503,
	BBREG_0x81c, 0xA1480503,  BBREG_0x81c, 0x834A0503,  BBREG_0x81c,
	0x824C0503,  BBREG_0x81c, 0x814E0503,  BBREG_0x81c, 0x63500503,
	BBREG_0x81c, 0x62520503,  BBREG_0x81c, 0x61540503,  BBREG_0x81c,
	0x43560503,  BBREG_0x81c, 0x42580503,  BBREG_0x81c, 0x245A0503,
	BBREG_0x81c, 0x235C0503,  BBREG_0x81c, 0x225E0503,  BBREG_0x81c,
	0x21600503,  BBREG_0x81c, 0x04620503,  BBREG_0x81c, 0x03640503,
	BBREG_0x81c, 0x02660503,  BBREG_0x81c, 0x01680503,  BBREG_0x81c,
	0x006A0503,  BBREG_0x81c, 0x006C0503,  BBREG_0x81c, 0x006E0503,
	BBREG_0x81c, 0x00700503,  BBREG_0x81c, 0x00720503,  BBREG_0x81c,
	0x00740503,  BBREG_0x81c, 0x00760503,  BBREG_0x81c, 0x00780503,
	BBREG_0x81c, 0x007A0503,  BBREG_0x81c, 0x007C0503,  BBREG_0x81c,
	0x007E0503,  BBREG_0x81c, 0x007E0503,  0x90000009,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x81c, 0xF8000503,  BBREG_0x81c,
	0xF7020503,  BBREG_0x81c, 0xF6040503,  BBREG_0x81c, 0xF5060503,
	BBREG_0x81c, 0xF4080503,  BBREG_0x81c, 0xF30A0503,  BBREG_0x81c,
	0xF20C0503,  BBREG_0x81c, 0xF10E0503,  BBREG_0x81c, 0xF0100503,
	BBREG_0x81c, 0xEF120503,  BBREG_0x81c, 0xEE140503,  BBREG_0x81c,
	0xED160503,  BBREG_0x81c, 0xEC180503,  BBREG_0x81c, 0xEB1A0503,
	BBREG_0x81c, 0xEA1C0503,  BBREG_0x81c, 0xE91E0503,  BBREG_0x81c,
	0xE8200503,  BBREG_0x81c, 0xE7220503,  BBREG_0x81c, 0xE6240503,
	BBREG_0x81c, 0xE5260503,  BBREG_0x81c, 0xE4280503,  BBREG_0x81c,
	0xE32A0503,  BBREG_0x81c, 0xE22C0503,  BBREG_0x81c, 0xC32E0503,
	BBREG_0x81c, 0xC2300503,  BBREG_0x81c, 0xC1320503,  BBREG_0x81c,
	0xA3340503,  BBREG_0x81c, 0xA2360503,  BBREG_0x81c, 0xA1380503,
	BBREG_0x81c, 0xA03A0503,  BBREG_0x81c, 0x823C0503,  BBREG_0x81c,
	0x813E0503,  BBREG_0x81c, 0x80400503,  BBREG_0x81c, 0x64420503,
	BBREG_0x81c, 0x63440503,  BBREG_0x81c, 0x62460503,  BBREG_0x81c,
	0x61480503,  BBREG_0x81c, 0x434A0503,  BBREG_0x81c, 0x424C0503,
	BBREG_0x81c, 0x414E0503,  BBREG_0x81c, 0x40500503,  BBREG_0x81c,
	0x22520503,  BBREG_0x81c, 0x21540503,  BBREG_0x81c, 0x20560503,
	BBREG_0x81c, 0x04580503,  BBREG_0x81c, 0x035A0503,  BBREG_0x81c,
	0x025C0503,  BBREG_0x81c, 0x015E0503,  BBREG_0x81c, 0x00600503,
	BBREG_0x81c, 0x00620503,  BBREG_0x81c, 0x00640503,  BBREG_0x81c,
	0x00660503,  BBREG_0x81c, 0x00680503,  BBREG_0x81c, 0x006A0503,
	BBREG_0x81c, 0x006C0503,  BBREG_0x81c, 0x006E0503,  BBREG_0x81c,
	0x00700503,  BBREG_0x81c, 0x00720503,  BBREG_0x81c, 0x00740503,
	BBREG_0x81c, 0x00760503,  BBREG_0x81c, 0x00780503,  BBREG_0x81c,
	0x007A0503,  BBREG_0x81c, 0x007C0503,  BBREG_0x81c, 0x007E0503,
	BBREG_0x81c, 0x007E0503,  0x9000000a,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x81c, 0xFD000503,  BBREG_0x81c, 0xFC020503,
	BBREG_0x81c, 0xFB040503,  BBREG_0x81c, 0xFA060503,  BBREG_0x81c,
	0xF9080503,  BBREG_0x81c, 0xF80A0503,  BBREG_0x81c, 0xF70C0503,
	BBREG_0x81c, 0xF60E0503,  BBREG_0x81c, 0xF5100503,  BBREG_0x81c,
	0xF4120503,  BBREG_0x81c, 0xF3140503,  BBREG_0x81c, 0xF2160503,
	BBREG_0x81c, 0xF1180503,  BBREG_0x81c, 0xF01A0503,  BBREG_0x81c,
	0xEE1C0503,  BBREG_0x81c, 0xED1E0503,  BBREG_0x81c, 0xEC200503,
	BBREG_0x81c, 0xEB220503,  BBREG_0x81c, 0xEA240503,  BBREG_0x81c,
	0xE9260503,  BBREG_0x81c, 0xE8280503,  BBREG_0x81c, 0xE72A0503,
	BBREG_0x81c, 0xE62C0503,  BBREG_0x81c, 0xE52E0503,  BBREG_0x81c,
	0xE4300503,  BBREG_0x81c, 0xE3320503,  BBREG_0x81c, 0xE2340503,
	BBREG_0x81c, 0xC5360503,  BBREG_0x81c, 0xC4380503,  BBREG_0x81c,
	0xC33A0503,  BBREG_0x81c, 0xC23C0503,  BBREG_0x81c, 0xA53E0503,
	BBREG_0x81c, 0xA4400503,  BBREG_0x81c, 0xA3420503,  BBREG_0x81c,
	0xA2440503,  BBREG_0x81c, 0xA1460503,  BBREG_0x81c, 0x83480503,
	BBREG_0x81c, 0x824A0503,  BBREG_0x81c, 0x814C0503,  BBREG_0x81c,
	0x804E0503,  BBREG_0x81c, 0x63500503,  BBREG_0x81c, 0x62520503,
	BBREG_0x81c, 0x61540503,  BBREG_0x81c, 0x43560503,  BBREG_0x81c,
	0x42580503,  BBREG_0x81c, 0x415A0503,  BBREG_0x81c, 0x405C0503,
	BBREG_0x81c, 0x225E0503,  BBREG_0x81c, 0x21600503,  BBREG_0x81c,
	0x20620503,  BBREG_0x81c, 0x03640503,  BBREG_0x81c, 0x02660503,
	BBREG_0x81c, 0x01680503,  BBREG_0x81c, 0x006A0503,  BBREG_0x81c,
	0x006C0503,  BBREG_0x81c, 0x006E0503,  BBREG_0x81c, 0x00700503,
	BBREG_0x81c, 0x00720503,  BBREG_0x81c, 0x00740503,  BBREG_0x81c,
	0x00760503,  BBREG_0x81c, 0x00780503,  BBREG_0x81c, 0x007A0503,
	BBREG_0x81c, 0x007C0503,  BBREG_0x81c, 0x007E0503,  BBREG_0x81c,
	0x007E0503,  0x9000000b,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x81c, 0xF9000503,  BBREG_0x81c, 0xF8020503,  BBREG_0x81c,
	0xF7040503,  BBREG_0x81c, 0xF6060503,  BBREG_0x81c, 0xF5080503,
	BBREG_0x81c, 0xF40A0503,  BBREG_0x81c, 0xF30C0503,  BBREG_0x81c,
	0xF20E0503,  BBREG_0x81c, 0xF1100503,  BBREG_0x81c, 0xF0120503,
	BBREG_0x81c, 0xEF140503,  BBREG_0x81c, 0xEE160503,  BBREG_0x81c,
	0xED180503,  BBREG_0x81c, 0xEC1A0503,  BBREG_0x81c, 0xEB1C0503,
	BBREG_0x81c, 0xEA1E0503,  BBREG_0x81c, 0xE9200503,  BBREG_0x81c,
	0xE8220503,  BBREG_0x81c, 0xE7240503,  BBREG_0x81c, 0xE6260503,
	BBREG_0x81c, 0xE5280503,  BBREG_0x81c, 0xE42A0503,  BBREG_0x81c,
	0xE32C0503,  BBREG_0x81c, 0xC32E0503,  BBREG_0x81c, 0xC2300503,
	BBREG_0x81c, 0xC1320503,  BBREG_0x81c, 0xA4340503,  BBREG_0x81c,
	0xA3360503,  BBREG_0x81c, 0xA2380503,  BBREG_0x81c, 0xA13A0503,
	BBREG_0x81c, 0xA03C0503,  BBREG_0x81c, 0x823E0503,  BBREG_0x81c,
	0x81400503,  BBREG_0x81c, 0x80420503,  BBREG_0x81c, 0x63440503,
	BBREG_0x81c, 0x62460503,  BBREG_0x81c, 0x61480503,  BBREG_0x81c,
	0x604A0503,  BBREG_0x81c, 0x244C0503,  BBREG_0x81c, 0x234E0503,
	BBREG_0x81c, 0x22500503,  BBREG_0x81c, 0x21520503,  BBREG_0x81c,
	0x20540503,  BBREG_0x81c, 0x05560503,  BBREG_0x81c, 0x04580503,
	BBREG_0x81c, 0x035A0503,  BBREG_0x81c, 0x025C0503,  BBREG_0x81c,
	0x015E0503,  BBREG_0x81c, 0x00600503,  BBREG_0x81c, 0x00620503,
	BBREG_0x81c, 0x00640503,  BBREG_0x81c, 0x00660503,  BBREG_0x81c,
	0x00680503,  BBREG_0x81c, 0x006A0503,  BBREG_0x81c, 0x006C0503,
	BBREG_0x81c, 0x006E0503,  BBREG_0x81c, 0x00700503,  BBREG_0x81c,
	0x00720503,  BBREG_0x81c, 0x00740503,  BBREG_0x81c, 0x00760503,
	BBREG_0x81c, 0x00780503,  BBREG_0x81c, 0x007A0503,  BBREG_0x81c,
	0x007C0503,  BBREG_0x81c, 0x007E0503,  BBREG_0x81c, 0x007E0503,
	0x9000000c,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c,
	0xFE000503,  BBREG_0x81c, 0xFD020503,  BBREG_0x81c, 0xFC040503,
	BBREG_0x81c, 0xFB060503,  BBREG_0x81c, 0xFA080503,  BBREG_0x81c,
	0xF90A0503,  BBREG_0x81c, 0xF80C0503,  BBREG_0x81c, 0xF70E0503,
	BBREG_0x81c, 0xF6100503,  BBREG_0x81c, 0xF5120503,  BBREG_0x81c,
	0xF4140503,  BBREG_0x81c, 0xF3160503,  BBREG_0x81c, 0xF2180503,
	BBREG_0x81c, 0xF11A0503,  BBREG_0x81c, 0xF01C0503,  BBREG_0x81c,
	0xEF1E0503,  BBREG_0x81c, 0xEE200503,  BBREG_0x81c, 0xED220503,
	BBREG_0x81c, 0xEC240503,  BBREG_0x81c, 0xEB260503,  BBREG_0x81c,
	0xEA280503,  BBREG_0x81c, 0xE92A0503,  BBREG_0x81c, 0xE82C0503,
	BBREG_0x81c, 0xE72E0503,  BBREG_0x81c, 0xE6300503,  BBREG_0x81c,
	0xE5320503,  BBREG_0x81c, 0xE4340503,  BBREG_0x81c, 0xE3360503,
	BBREG_0x81c, 0xC6380503,  BBREG_0x81c, 0xC53A0503,  BBREG_0x81c,
	0xC43C0503,  BBREG_0x81c, 0xC33E0503,  BBREG_0x81c, 0xA5400503,
	BBREG_0x81c, 0xA4420503,  BBREG_0x81c, 0xA3440503,  BBREG_0x81c,
	0xA2460503,  BBREG_0x81c, 0xA1480503,  BBREG_0x81c, 0xA04A0503,
	BBREG_0x81c, 0x824C0503,  BBREG_0x81c, 0x814E0503,  BBREG_0x81c,
	0x80500503,  BBREG_0x81c, 0x64520503,  BBREG_0x81c, 0x63540503,
	BBREG_0x81c, 0x62560503,  BBREG_0x81c, 0x61580503,  BBREG_0x81c,
	0x605A0503,  BBREG_0x81c, 0x235C0503,  BBREG_0x81c, 0x225E0503,
	BBREG_0x81c, 0x21600503,  BBREG_0x81c, 0x20620503,  BBREG_0x81c,
	0x03640503,  BBREG_0x81c, 0x02660503,  BBREG_0x81c, 0x01680503,
	BBREG_0x81c, 0x006A0503,  BBREG_0x81c, 0x006C0503,  BBREG_0x81c,
	0x006E0503,  BBREG_0x81c, 0x00700503,  BBREG_0x81c, 0x00720503,
	BBREG_0x81c, 0x00740503,  BBREG_0x81c, 0x00760503,  BBREG_0x81c,
	0x00780503,  BBREG_0x81c, 0x007A0503,  BBREG_0x81c, 0x007C0503,
	BBREG_0x81c, 0x007E0503,  BBREG_0x81c, 0x007E0503,  0x9000000d,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c, 0xFD000503,
	BBREG_0x81c, 0xFC020503,  BBREG_0x81c, 0xFB040503,  BBREG_0x81c,
	0xFA060503,  BBREG_0x81c, 0xF9080503,  BBREG_0x81c, 0xF80A0503,
	BBREG_0x81c, 0xF70C0503,  BBREG_0x81c, 0xF60E0503,  BBREG_0x81c,
	0xF5100503,  BBREG_0x81c, 0xF4120503,  BBREG_0x81c, 0xF3140503,
	BBREG_0x81c, 0xF2160503,  BBREG_0x81c, 0xF1180503,  BBREG_0x81c,
	0xF01A0503,  BBREG_0x81c, 0xEE1C0503,  BBREG_0x81c, 0xED1E0503,
	BBREG_0x81c, 0xEC200503,  BBREG_0x81c, 0xEB220503,  BBREG_0x81c,
	0xEA240503,  BBREG_0x81c, 0xE9260503,  BBREG_0x81c, 0xE8280503,
	BBREG_0x81c, 0xE72A0503,  BBREG_0x81c, 0xE62C0503,  BBREG_0x81c,
	0xE52E0503,  BBREG_0x81c, 0xE4300503,  BBREG_0x81c, 0xE3320503,
	BBREG_0x81c, 0xE2340503,  BBREG_0x81c, 0xC5360503,  BBREG_0x81c,
	0xC4380503,  BBREG_0x81c, 0xC33A0503,  BBREG_0x81c, 0xC23C0503,
	BBREG_0x81c, 0xA53E0503,  BBREG_0x81c, 0xA4400503,  BBREG_0x81c,
	0xA3420503,  BBREG_0x81c, 0xA2440503,  BBREG_0x81c, 0xA1460503,
	BBREG_0x81c, 0x83480503,  BBREG_0x81c, 0x824A0503,  BBREG_0x81c,
	0x814C0503,  BBREG_0x81c, 0x804E0503,  BBREG_0x81c, 0x63500503,
	BBREG_0x81c, 0x62520503,  BBREG_0x81c, 0x61540503,  BBREG_0x81c,
	0x43560503,  BBREG_0x81c, 0x42580503,  BBREG_0x81c, 0x415A0503,
	BBREG_0x81c, 0x405C0503,  BBREG_0x81c, 0x225E0503,  BBREG_0x81c,
	0x21600503,  BBREG_0x81c, 0x20620503,  BBREG_0x81c, 0x03640503,
	BBREG_0x81c, 0x02660503,  BBREG_0x81c, 0x01680503,  BBREG_0x81c,
	0x006A0503,  BBREG_0x81c, 0x006C0503,  BBREG_0x81c, 0x006E0503,
	BBREG_0x81c, 0x00700503,  BBREG_0x81c, 0x00720503,  BBREG_0x81c,
	0x00740503,  BBREG_0x81c, 0x00760503,  BBREG_0x81c, 0x00780503,
	BBREG_0x81c, 0x007A0503,  BBREG_0x81c, 0x007C0503,  BBREG_0x81c,
	0x007E0503,  BBREG_0x81c, 0x007E0503,  0x9000000e,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x81c, 0xFD000503,  BBREG_0x81c,
	0xFC020503,  BBREG_0x81c, 0xFB040503,  BBREG_0x81c, 0xFA060503,
	BBREG_0x81c, 0xF9080503,  BBREG_0x81c, 0xF80A0503,  BBREG_0x81c,
	0xF70C0503,  BBREG_0x81c, 0xF60E0503,  BBREG_0x81c, 0xF5100503,
	BBREG_0x81c, 0xF4120503,  BBREG_0x81c, 0xF3140503,  BBREG_0x81c,
	0xF2160503,  BBREG_0x81c, 0xF1180503,  BBREG_0x81c, 0xF01A0503,
	BBREG_0x81c, 0xEE1C0503,  BBREG_0x81c, 0xED1E0503,  BBREG_0x81c,
	0xEC200503,  BBREG_0x81c, 0xEB220503,  BBREG_0x81c, 0xEA240503,
	BBREG_0x81c, 0xE9260503,  BBREG_0x81c, 0xE8280503,  BBREG_0x81c,
	0xE72A0503,  BBREG_0x81c, 0xE62C0503,  BBREG_0x81c, 0xE52E0503,
	BBREG_0x81c, 0xE4300503,  BBREG_0x81c, 0xE3320503,  BBREG_0x81c,
	0xE2340503,  BBREG_0x81c, 0xC5360503,  BBREG_0x81c, 0xC4380503,
	BBREG_0x81c, 0xC33A0503,  BBREG_0x81c, 0xC23C0503,  BBREG_0x81c,
	0xA53E0503,  BBREG_0x81c, 0xA4400503,  BBREG_0x81c, 0xA3420503,
	BBREG_0x81c, 0xA2440503,  BBREG_0x81c, 0xA1460503,  BBREG_0x81c,
	0x83480503,  BBREG_0x81c, 0x824A0503,  BBREG_0x81c, 0x814C0503,
	BBREG_0x81c, 0x804E0503,  BBREG_0x81c, 0x63500503,  BBREG_0x81c,
	0x62520503,  BBREG_0x81c, 0x61540503,  BBREG_0x81c, 0x43560503,
	BBREG_0x81c, 0x42580503,  BBREG_0x81c, 0x415A0503,  BBREG_0x81c,
	0x405C0503,  BBREG_0x81c, 0x225E0503,  BBREG_0x81c, 0x21600503,
	BBREG_0x81c, 0x20620503,  BBREG_0x81c, 0x03640503,  BBREG_0x81c,
	0x02660503,  BBREG_0x81c, 0x01680503,  BBREG_0x81c, 0x006A0503,
	BBREG_0x81c, 0x006C0503,  BBREG_0x81c, 0x006E0503,  BBREG_0x81c,
	0x00700503,  BBREG_0x81c, 0x00720503,  BBREG_0x81c, 0x00740503,
	BBREG_0x81c, 0x00760503,  BBREG_0x81c, 0x00780503,  BBREG_0x81c,
	0x007A0503,  BBREG_0x81c, 0x007C0503,  BBREG_0x81c, 0x007E0503,
	BBREG_0x81c, 0x007E0503,  0x9000000f,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x81c, 0xBF000503,  BBREG_0x81c, 0xBF020503,
	BBREG_0x81c, 0xBF040503,  BBREG_0x81c, 0xBF060503,  BBREG_0x81c,
	0xBF080503,  BBREG_0x81c, 0xBF0A0503,  BBREG_0x81c, 0xBE0C0503,
	BBREG_0x81c, 0xBD0E0503,  BBREG_0x81c, 0xBC100503,  BBREG_0x81c,
	0xBB120503,  BBREG_0x81c, 0xBA140503,  BBREG_0x81c, 0xB9160503,
	BBREG_0x81c, 0xB8180503,  BBREG_0x81c, 0xB71A0503,  BBREG_0x81c,
	0xB61C0503,  BBREG_0x81c, 0xB51E0503,  BBREG_0x81c, 0xB2200503,
	BBREG_0x81c, 0xB3220503,  BBREG_0x81c, 0xB2240503,  BBREG_0x81c,
	0xB1260503,  BBREG_0x81c, 0xB0280503,  BBREG_0x81c, 0xAF2A0503,
	BBREG_0x81c, 0xAE2C0503,  BBREG_0x81c, 0xAD2E0503,  BBREG_0x81c,
	0xAC300503,  BBREG_0x81c, 0xAB320503,  BBREG_0x81c, 0xAA340503,
	BBREG_0x81c, 0xC6360503,  BBREG_0x81c, 0xC5380503,  BBREG_0x81c,
	0xC43A0503,  BBREG_0x81c, 0xC33C0503,  BBREG_0x81c, 0x883E0503,
	BBREG_0x81c, 0x87400503,  BBREG_0x81c, 0x86420503,  BBREG_0x81c,
	0x85440503,  BBREG_0x81c, 0x84460503,  BBREG_0x81c, 0x83480503,
	BBREG_0x81c, 0x674A0503,  BBREG_0x81c, 0x664C0503,  BBREG_0x81c,
	0x654E0503,  BBREG_0x81c, 0x64500503,  BBREG_0x81c, 0x27520503,
	BBREG_0x81c, 0x26540503,  BBREG_0x81c, 0x25560503,  BBREG_0x81c,
	0x24580503,  BBREG_0x81c, 0x235A0503,  BBREG_0x81c, 0x225C0503,
	BBREG_0x81c, 0x215E0503,  BBREG_0x81c, 0x20600503,  BBREG_0x81c,
	0x03620503,  BBREG_0x81c, 0x02640503,  BBREG_0x81c, 0x01660503,
	BBREG_0x81c, 0x00680503,  BBREG_0x81c, 0x006A0503,  BBREG_0x81c,
	0x006C0503,  BBREG_0x81c, 0x006E0503,  BBREG_0x81c, 0x00700503,
	BBREG_0x81c, 0x00720503,  BBREG_0x81c, 0x00740503,  BBREG_0x81c,
	0x00760503,  BBREG_0x81c, 0x00780503,  BBREG_0x81c, 0x007A0503,
	BBREG_0x81c, 0x007C0503,  BBREG_0x81c, 0x007E0503,  BBREG_0x81c,
	0x007E0503,  0x90000010,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x81c, 0xFE000403,  BBREG_0x81c, 0xFD000503,  BBREG_0x81c,
	0xFC020503,  BBREG_0x81c, 0xFB040503,  BBREG_0x81c, 0xFA060503,
	BBREG_0x81c, 0xF9080503,  BBREG_0x81c, 0xF80A0503,  BBREG_0x81c,
	0xF70C0503,  BBREG_0x81c, 0xF60E0503,  BBREG_0x81c, 0xF5100503,
	BBREG_0x81c, 0xF4120503,  BBREG_0x81c, 0xF3140503,  BBREG_0x81c,
	0xF2160503,  BBREG_0x81c, 0xF1180503,  BBREG_0x81c, 0xF01A0503,
	BBREG_0x81c, 0xEF1C0503,  BBREG_0x81c, 0xEE1E0503,  BBREG_0x81c,
	0xED200503,  BBREG_0x81c, 0xEC220503,  BBREG_0x81c, 0xEB240503,
	BBREG_0x81c, 0xEA260503,  BBREG_0x81c, 0xE9280503,  BBREG_0x81c,
	0xE82A0503,  BBREG_0x81c, 0xE72C0503,  BBREG_0x81c, 0xE62E0503,
	BBREG_0x81c, 0xE5300503,  BBREG_0x81c, 0xE4320503,  BBREG_0x81c,
	0xE3340503,  BBREG_0x81c, 0xC6360503,  BBREG_0x81c, 0xC5380503,
	BBREG_0x81c, 0xC43A0503,  BBREG_0x81c, 0xC33C0503,  BBREG_0x81c,
	0xA53E0503,  BBREG_0x81c, 0xA4400503,  BBREG_0x81c, 0xA3420503,
	BBREG_0x81c, 0xA2440503,  BBREG_0x81c, 0xA1460503,  BBREG_0x81c,
	0xA0480503,  BBREG_0x81c, 0x824A0503,  BBREG_0x81c, 0x814C0503,
	BBREG_0x81c, 0x804E0503,  BBREG_0x81c, 0x64500503,  BBREG_0x81c,
	0x63520503,  BBREG_0x81c, 0x62540503,  BBREG_0x81c, 0x61560503,
	BBREG_0x81c, 0x60580503,  BBREG_0x81c, 0x235A0503,  BBREG_0x81c,
	0x225C0503,  BBREG_0x81c, 0x215E0503,  BBREG_0x81c, 0x20600503,
	BBREG_0x81c, 0x03620503,  BBREG_0x81c, 0x02640503,  BBREG_0x81c,
	0x01660503,  BBREG_0x81c, 0x00680503,  BBREG_0x81c, 0x006A0503,
	BBREG_0x81c, 0x006C0503,  BBREG_0x81c, 0x006E0503,  BBREG_0x81c,
	0x00700503,  BBREG_0x81c, 0x00720503,  BBREG_0x81c, 0x00740503,
	BBREG_0x81c, 0x00760503,  BBREG_0x81c, 0x00780503,  BBREG_0x81c,
	0x007A0503,  BBREG_0x81c, 0x007C0503,  BBREG_0x81c, 0x007E0503,
	0xA0000000,  0x00000000,  BBREG_0x81c, 0xFE000503,  BBREG_0x81c,
	0xFD020503,  BBREG_0x81c, 0xFC040503,  BBREG_0x81c, 0xFB060503,
	BBREG_0x81c, 0xFA080503,  BBREG_0x81c, 0xF90A0503,  BBREG_0x81c,
	0xF80C0503,  BBREG_0x81c, 0xF70E0503,  BBREG_0x81c, 0xF6100503,
	BBREG_0x81c, 0xF5120503,  BBREG_0x81c, 0xF4140503,  BBREG_0x81c,
	0xF3160503,  BBREG_0x81c, 0xF2180503,  BBREG_0x81c, 0xF11A0503,
	BBREG_0x81c, 0xF01C0503,  BBREG_0x81c, 0xEF1E0503,  BBREG_0x81c,
	0xEE200503,  BBREG_0x81c, 0xED220503,  BBREG_0x81c, 0xEC240503,
	BBREG_0x81c, 0xEB260503,  BBREG_0x81c, 0xEA280503,  BBREG_0x81c,
	0xE92A0503,  BBREG_0x81c, 0xE82C0503,  BBREG_0x81c, 0xE72E0503,
	BBREG_0x81c, 0xE6300503,  BBREG_0x81c, 0xE5320503,  BBREG_0x81c,
	0xE4340503,  BBREG_0x81c, 0xE3360503,  BBREG_0x81c, 0xC6380503,
	BBREG_0x81c, 0xC53A0503,  BBREG_0x81c, 0xC43C0503,  BBREG_0x81c,
	0xC33E0503,  BBREG_0x81c, 0xA5400503,  BBREG_0x81c, 0xA4420503,
	BBREG_0x81c, 0xA3440503,  BBREG_0x81c, 0xA2460503,  BBREG_0x81c,
	0xA1480503,  BBREG_0x81c, 0xA04A0503,  BBREG_0x81c, 0x824C0503,
	BBREG_0x81c, 0x814E0503,  BBREG_0x81c, 0x80500503,  BBREG_0x81c,
	0x64520503,  BBREG_0x81c, 0x63540503,  BBREG_0x81c, 0x62560503,
	BBREG_0x81c, 0x61580503,  BBREG_0x81c, 0x605A0503,  BBREG_0x81c,
	0x235C0503,  BBREG_0x81c, 0x225E0503,  BBREG_0x81c, 0x21600503,
	BBREG_0x81c, 0x20620503,  BBREG_0x81c, 0x03640503,  BBREG_0x81c,
	0x02660503,  BBREG_0x81c, 0x01680503,  BBREG_0x81c, 0x006A0503,
	BBREG_0x81c, 0x006C0503,  BBREG_0x81c, 0x006E0503,  BBREG_0x81c,
	0x00700503,  BBREG_0x81c, 0x00720503,  BBREG_0x81c, 0x00740503,
	BBREG_0x81c, 0x00760503,  BBREG_0x81c, 0x00780503,  BBREG_0x81c,
	0x007A0503,  BBREG_0x81c, 0x007C0503,  BBREG_0x81c, 0x007E0503,
	BBREG_0x81c, 0x007E0503,  0xB0000000,  0x00000000,  0x80000000,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c, 0xFC000603,
	BBREG_0x81c, 0xFB020603,  BBREG_0x81c, 0xFA040603,  BBREG_0x81c,
	0xF9060603,  BBREG_0x81c, 0xF8080603,  BBREG_0x81c, 0xF70A0603,
	BBREG_0x81c, 0xF60C0603,  BBREG_0x81c, 0xF50E0603,  BBREG_0x81c,
	0xF4100603,  BBREG_0x81c, 0xF3120603,  BBREG_0x81c, 0xF2140603,
	BBREG_0x81c, 0xF1160603,  BBREG_0x81c, 0xF0180603,  BBREG_0x81c,
	0xEE1A0603,  BBREG_0x81c, 0xED1C0603,  BBREG_0x81c, 0xEC1E0603,
	BBREG_0x81c, 0xEB200603,  BBREG_0x81c, 0xEA220603,  BBREG_0x81c,
	0xE9240603,  BBREG_0x81c, 0xE8260603,  BBREG_0x81c, 0xE7280603,
	BBREG_0x81c, 0xE62A0603,  BBREG_0x81c, 0xE52C0603,  BBREG_0x81c,
	0xE42E0603,  BBREG_0x81c, 0xE3300603,  BBREG_0x81c, 0xE2320603,
	BBREG_0x81c, 0xC6340603,  BBREG_0x81c, 0xC5360603,  BBREG_0x81c,
	0xC4380603,  BBREG_0x81c, 0xC33A0603,  BBREG_0x81c, 0xA63C0603,
	BBREG_0x81c, 0xA53E0603,  BBREG_0x81c, 0xA4400603,  BBREG_0x81c,
	0xA3420603,  BBREG_0x81c, 0xA2440603,  BBREG_0x81c, 0xA1460603,
	BBREG_0x81c, 0x83480603,  BBREG_0x81c, 0x824A0603,  BBREG_0x81c,
	0x814C0603,  BBREG_0x81c, 0x804E0603,  BBREG_0x81c, 0x63500603,
	BBREG_0x81c, 0x62520603,  BBREG_0x81c, 0x61540603,  BBREG_0x81c,
	0x42560603,  BBREG_0x81c, 0x41580603,  BBREG_0x81c, 0x405A0603,
	BBREG_0x81c, 0x225C0603,  BBREG_0x81c, 0x215E0603,  BBREG_0x81c,
	0x20600603,  BBREG_0x81c, 0x04620603,  BBREG_0x81c, 0x03640603,
	BBREG_0x81c, 0x02660603,  BBREG_0x81c, 0x01680603,  BBREG_0x81c,
	0x006A0603,  BBREG_0x81c, 0x006C0603,  BBREG_0x81c, 0x006E0603,
	BBREG_0x81c, 0x00700603,  BBREG_0x81c, 0x00720603,  BBREG_0x81c,
	0x00740603,  BBREG_0x81c, 0x00760603,  BBREG_0x81c, 0x00780603,
	BBREG_0x81c, 0x007A0603,  BBREG_0x81c, 0x007C0603,  BBREG_0x81c,
	0x007E0603,  BBREG_0x81c, 0x007E0603,  0x90000001,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x81c, 0xBD000603,  BBREG_0x81c,
	0xBC020603,  BBREG_0x81c, 0xBB040603,  BBREG_0x81c, 0xBA060603,
	BBREG_0x81c, 0xB9080603,  BBREG_0x81c, 0xB80A0603,  BBREG_0x81c,
	0xB70C0603,  BBREG_0x81c, 0xB60E0603,  BBREG_0x81c, 0xB5100603,
	BBREG_0x81c, 0xB4120603,  BBREG_0x81c, 0xB3140603,  BBREG_0x81c,
	0xB2160603,  BBREG_0x81c, 0xB1180603,  BBREG_0x81c, 0xB01A0603,
	BBREG_0x81c, 0xAF1C0603,  BBREG_0x81c, 0xAE1E0603,  BBREG_0x81c,
	0xAD200603,  BBREG_0x81c, 0x8F220603,  BBREG_0x81c, 0x8E240603,
	BBREG_0x81c, 0x8D260603,  BBREG_0x81c, 0x8C280603,  BBREG_0x81c,
	0x8B2A0603,  BBREG_0x81c, 0x8A2C0603,  BBREG_0x81c, 0x892E0603,
	BBREG_0x81c, 0x88300603,  BBREG_0x81c, 0x6B320603,  BBREG_0x81c,
	0x6A340603,  BBREG_0x81c, 0x69360603,  BBREG_0x81c, 0x68380603,
	BBREG_0x81c, 0x673A0603,  BBREG_0x81c, 0x663C0603,  BBREG_0x81c,
	0x653E0603,  BBREG_0x81c, 0x64400603,  BBREG_0x81c, 0x63420603,
	BBREG_0x81c, 0x62440603,  BBREG_0x81c, 0x61460603,  BBREG_0x81c,
	0x60480603,  BBREG_0x81c, 0x424A0603,  BBREG_0x81c, 0x414C0603,
	BBREG_0x81c, 0x404E0603,  BBREG_0x81c, 0x06500603,  BBREG_0x81c,
	0x05520603,  BBREG_0x81c, 0x04540603,  BBREG_0x81c, 0x03560603,
	BBREG_0x81c, 0x02580603,  BBREG_0x81c, 0x015A0603,  BBREG_0x81c,
	0x005C0603,  BBREG_0x81c, 0x005E0603,  BBREG_0x81c, 0x00600603,
	BBREG_0x81c, 0x00620603,  BBREG_0x81c, 0x00640603,  BBREG_0x81c,
	0x00660603,  BBREG_0x81c, 0x00680603,  BBREG_0x81c, 0x006A0603,
	BBREG_0x81c, 0x006C0603,  BBREG_0x81c, 0x006E0603,  BBREG_0x81c,
	0x00700603,  BBREG_0x81c, 0x00720603,  BBREG_0x81c, 0x00740603,
	BBREG_0x81c, 0x00760603,  BBREG_0x81c, 0x00780603,  BBREG_0x81c,
	0x007A0603,  BBREG_0x81c, 0x007C0603,  BBREG_0x81c, 0x007E0603,
	BBREG_0x81c, 0x007C0603,  0x90000002,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x81c, 0xF7000603,  BBREG_0x81c, 0xF6020603,
	BBREG_0x81c, 0xF5040603,  BBREG_0x81c, 0xF4060603,  BBREG_0x81c,
	0xF3080603,  BBREG_0x81c, 0xF20A0603,  BBREG_0x81c, 0xF10C0603,
	BBREG_0x81c, 0xF00E0603,  BBREG_0x81c, 0xEF100603,  BBREG_0x81c,
	0xEE120603,  BBREG_0x81c, 0xED140603,  BBREG_0x81c, 0xEC160603,
	BBREG_0x81c, 0xEB180603,  BBREG_0x81c, 0xEA1A0603,  BBREG_0x81c,
	0xE91C0603,  BBREG_0x81c, 0xE81E0603,  BBREG_0x81c, 0xE7200603,
	BBREG_0x81c, 0xE6220603,  BBREG_0x81c, 0xE5240603,  BBREG_0x81c,
	0xE4260603,  BBREG_0x81c, 0xE3280603,  BBREG_0x81c, 0xC42A0603,
	BBREG_0x81c, 0xC32C0603,  BBREG_0x81c, 0xC22E0603,  BBREG_0x81c,
	0xC1300603,  BBREG_0x81c, 0xC0320603,  BBREG_0x81c, 0xA3340603,
	BBREG_0x81c, 0xA2360603,  BBREG_0x81c, 0xA1380603,  BBREG_0x81c,
	0xA03A0603,  BBREG_0x81c, 0x823C0603,  BBREG_0x81c, 0x813E0603,
	BBREG_0x81c, 0x80400603,  BBREG_0x81c, 0x64420603,  BBREG_0x81c,
	0x63440603,  BBREG_0x81c, 0x62460603,  BBREG_0x81c, 0x61480603,
	BBREG_0x81c, 0x604A0603,  BBREG_0x81c, 0x414C0603,  BBREG_0x81c,
	0x404E0603,  BBREG_0x81c, 0x22500603,  BBREG_0x81c, 0x21520603,
	BBREG_0x81c, 0x20540603,  BBREG_0x81c, 0x03560603,  BBREG_0x81c,
	0x02580603,  BBREG_0x81c, 0x015A0603,  BBREG_0x81c, 0x005C0603,
	BBREG_0x81c, 0x005E0603,  BBREG_0x81c, 0x00600603,  BBREG_0x81c,
	0x00620603,  BBREG_0x81c, 0x00640603,  BBREG_0x81c, 0x00660603,
	BBREG_0x81c, 0x00680603,  BBREG_0x81c, 0x006A0603,  BBREG_0x81c,
	0x006C0603,  BBREG_0x81c, 0x006E0603,  BBREG_0x81c, 0x00700603,
	BBREG_0x81c, 0x00720603,  BBREG_0x81c, 0x00740603,  BBREG_0x81c,
	0x00760603,  BBREG_0x81c, 0x00780603,  BBREG_0x81c, 0x007A0603,
	BBREG_0x81c, 0x007C0603,  BBREG_0x81c, 0x007E0603,  BBREG_0x81c,
	0x007E0603,  0x90000003,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x81c, 0xFC000603,  BBREG_0x81c, 0xFB020603,  BBREG_0x81c,
	0xFA040603,  BBREG_0x81c, 0xF9060603,  BBREG_0x81c, 0xF8080603,
	BBREG_0x81c, 0xF70A0603,  BBREG_0x81c, 0xF60C0603,  BBREG_0x81c,
	0xF50E0603,  BBREG_0x81c, 0xF4100603,  BBREG_0x81c, 0xF3120603,
	BBREG_0x81c, 0xF2140603,  BBREG_0x81c, 0xF1160603,  BBREG_0x81c,
	0xF0180603,  BBREG_0x81c, 0xEF1A0603,  BBREG_0x81c, 0xEE1C0603,
	BBREG_0x81c, 0xED1E0603,  BBREG_0x81c, 0xEC200603,  BBREG_0x81c,
	0xEB220603,  BBREG_0x81c, 0xEA240603,  BBREG_0x81c, 0xE9260603,
	BBREG_0x81c, 0xE8280603,  BBREG_0x81c, 0xE72A0603,  BBREG_0x81c,
	0xE62C0603,  BBREG_0x81c, 0xE52E0603,  BBREG_0x81c, 0xE4300603,
	BBREG_0x81c, 0xE3320603,  BBREG_0x81c, 0xE2340603,  BBREG_0x81c,
	0xC6360603,  BBREG_0x81c, 0xC5380603,  BBREG_0x81c, 0xC43A0603,
	BBREG_0x81c, 0xC33C0603,  BBREG_0x81c, 0xA63E0603,  BBREG_0x81c,
	0xA5400603,  BBREG_0x81c, 0xA4420603,  BBREG_0x81c, 0xA3440603,
	BBREG_0x81c, 0xA2460603,  BBREG_0x81c, 0xA1480603,  BBREG_0x81c,
	0x834A0603,  BBREG_0x81c, 0x824C0603,  BBREG_0x81c, 0x814E0603,
	BBREG_0x81c, 0x64500603,  BBREG_0x81c, 0x63520603,  BBREG_0x81c,
	0x62540603,  BBREG_0x81c, 0x61560603,  BBREG_0x81c, 0x60580603,
	BBREG_0x81c, 0x405A0603,  BBREG_0x81c, 0x215C0603,  BBREG_0x81c,
	0x205E0603,  BBREG_0x81c, 0x03600603,  BBREG_0x81c, 0x02620603,
	BBREG_0x81c, 0x01640603,  BBREG_0x81c, 0x00660603,  BBREG_0x81c,
	0x00680603,  BBREG_0x81c, 0x006A0603,  BBREG_0x81c, 0x006C0603,
	BBREG_0x81c, 0x006E0603,  BBREG_0x81c, 0x00700603,  BBREG_0x81c,
	0x00720603,  BBREG_0x81c, 0x00740603,  BBREG_0x81c, 0x00760603,
	BBREG_0x81c, 0x00780603,  BBREG_0x81c, 0x007A0603,  BBREG_0x81c,
	0x007C0603,  BBREG_0x81c, 0x007E0603,  BBREG_0x81c, 0x007E0603,
	0x90000004,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c,
	0xF7000603,  BBREG_0x81c, 0xF6020603,  BBREG_0x81c, 0xF5040603,
	BBREG_0x81c, 0xF4060603,  BBREG_0x81c, 0xF3080603,  BBREG_0x81c,
	0xF20A0603,  BBREG_0x81c, 0xF10C0603,  BBREG_0x81c, 0xF00E0603,
	BBREG_0x81c, 0xEF100603,  BBREG_0x81c, 0xEE120603,  BBREG_0x81c,
	0xED140603,  BBREG_0x81c, 0xEC160603,  BBREG_0x81c, 0xEB180603,
	BBREG_0x81c, 0xEA1A0603,  BBREG_0x81c, 0xE91C0603,  BBREG_0x81c,
	0xE81E0603,  BBREG_0x81c, 0xE7200603,  BBREG_0x81c, 0xE6220603,
	BBREG_0x81c, 0xE5240603,  BBREG_0x81c, 0xE4260603,  BBREG_0x81c,
	0xE3280603,  BBREG_0x81c, 0xC42A0603,  BBREG_0x81c, 0xC32C0603,
	BBREG_0x81c, 0xC22E0603,  BBREG_0x81c, 0xC1300603,  BBREG_0x81c,
	0xC0320603,  BBREG_0x81c, 0xA3340603,  BBREG_0x81c, 0xA2360603,
	BBREG_0x81c, 0xA1380603,  BBREG_0x81c, 0xA03A0603,  BBREG_0x81c,
	0x823C0603,  BBREG_0x81c, 0x813E0603,  BBREG_0x81c, 0x80400603,
	BBREG_0x81c, 0x64420603,  BBREG_0x81c, 0x63440603,  BBREG_0x81c,
	0x62460603,  BBREG_0x81c, 0x61480603,  BBREG_0x81c, 0x604A0603,
	BBREG_0x81c, 0x414C0603,  BBREG_0x81c, 0x404E0603,  BBREG_0x81c,
	0x22500603,  BBREG_0x81c, 0x21520603,  BBREG_0x81c, 0x20540603,
	BBREG_0x81c, 0x03560603,  BBREG_0x81c, 0x02580603,  BBREG_0x81c,
	0x015A0603,  BBREG_0x81c, 0x005C0603,  BBREG_0x81c, 0x005E0603,
	BBREG_0x81c, 0x00600603,  BBREG_0x81c, 0x00620603,  BBREG_0x81c,
	0x00640603,  BBREG_0x81c, 0x00660603,  BBREG_0x81c, 0x00680603,
	BBREG_0x81c, 0x006A0603,  BBREG_0x81c, 0x006C0603,  BBREG_0x81c,
	0x006E0603,  BBREG_0x81c, 0x00700603,  BBREG_0x81c, 0x00720603,
	BBREG_0x81c, 0x00740603,  BBREG_0x81c, 0x00760603,  BBREG_0x81c,
	0x00780603,  BBREG_0x81c, 0x007A0603,  BBREG_0x81c, 0x007C0603,
	BBREG_0x81c, 0x007E0603,  BBREG_0x81c, 0x007E0603,  0x90000005,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c, 0xFC000603,
	BBREG_0x81c, 0xFB020603,  BBREG_0x81c, 0xFA040603,  BBREG_0x81c,
	0xF9060603,  BBREG_0x81c, 0xF8080603,  BBREG_0x81c, 0xF70A0603,
	BBREG_0x81c, 0xF60C0603,  BBREG_0x81c, 0xF50E0603,  BBREG_0x81c,
	0xF4100603,  BBREG_0x81c, 0xF3120603,  BBREG_0x81c, 0xF2140603,
	BBREG_0x81c, 0xF1160603,  BBREG_0x81c, 0xF0180603,  BBREG_0x81c,
	0xEF1A0603,  BBREG_0x81c, 0xEE1C0603,  BBREG_0x81c, 0xED1E0603,
	BBREG_0x81c, 0xEC200603,  BBREG_0x81c, 0xEB220603,  BBREG_0x81c,
	0xEA240603,  BBREG_0x81c, 0xE9260603,  BBREG_0x81c, 0xE8280603,
	BBREG_0x81c, 0xE72A0603,  BBREG_0x81c, 0xE62C0603,  BBREG_0x81c,
	0xE52E0603,  BBREG_0x81c, 0xE4300603,  BBREG_0x81c, 0xE3320603,
	BBREG_0x81c, 0xE2340603,  BBREG_0x81c, 0xE1360603,  BBREG_0x81c,
	0xC5380603,  BBREG_0x81c, 0xC43A0603,  BBREG_0x81c, 0xC33C0603,
	BBREG_0x81c, 0xC23E0603,  BBREG_0x81c, 0xC1400603,  BBREG_0x81c,
	0xA3420603,  BBREG_0x81c, 0xA2440603,  BBREG_0x81c, 0xA1460603,
	BBREG_0x81c, 0xA0480603,  BBREG_0x81c, 0x834A0603,  BBREG_0x81c,
	0x824C0603,  BBREG_0x81c, 0x814E0603,  BBREG_0x81c, 0x64500603,
	BBREG_0x81c, 0x63520603,  BBREG_0x81c, 0x62540603,  BBREG_0x81c,
	0x61560603,  BBREG_0x81c, 0x25580603,  BBREG_0x81c, 0x245A0603,
	BBREG_0x81c, 0x235C0603,  BBREG_0x81c, 0x225E0603,  BBREG_0x81c,
	0x21600603,  BBREG_0x81c, 0x04620603,  BBREG_0x81c, 0x03640603,
	BBREG_0x81c, 0x02660603,  BBREG_0x81c, 0x01680603,  BBREG_0x81c,
	0x006A0603,  BBREG_0x81c, 0x006C0603,  BBREG_0x81c, 0x006E0603,
	BBREG_0x81c, 0x00700603,  BBREG_0x81c, 0x00720603,  BBREG_0x81c,
	0x00740603,  BBREG_0x81c, 0x00760603,  BBREG_0x81c, 0x00780603,
	BBREG_0x81c, 0x007A0603,  BBREG_0x81c, 0x007C0603,  BBREG_0x81c,
	0x007E0603,  BBREG_0x81c, 0x007E0603,  0x90000006,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x81c, 0xF9000603,  BBREG_0x81c,
	0xF8020603,  BBREG_0x81c, 0xF7040603,  BBREG_0x81c, 0xF6060603,
	BBREG_0x81c, 0xF5080603,  BBREG_0x81c, 0xF40A0603,  BBREG_0x81c,
	0xF30C0603,  BBREG_0x81c, 0xF20E0603,  BBREG_0x81c, 0xF1100603,
	BBREG_0x81c, 0xF0120603,  BBREG_0x81c, 0xEF140603,  BBREG_0x81c,
	0xEE160603,  BBREG_0x81c, 0xED180603,  BBREG_0x81c, 0xEC1A0603,
	BBREG_0x81c, 0xEB1C0603,  BBREG_0x81c, 0xEA1E0603,  BBREG_0x81c,
	0xE9200603,  BBREG_0x81c, 0xE8220603,  BBREG_0x81c, 0xE7240603,
	BBREG_0x81c, 0xE6260603,  BBREG_0x81c, 0xE5280603,  BBREG_0x81c,
	0xC42A0603,  BBREG_0x81c, 0xC32C0603,  BBREG_0x81c, 0xC22E0603,
	BBREG_0x81c, 0xC1300603,  BBREG_0x81c, 0xC0320603,  BBREG_0x81c,
	0xA3340603,  BBREG_0x81c, 0xA2360603,  BBREG_0x81c, 0xA1380603,
	BBREG_0x81c, 0xA03A0603,  BBREG_0x81c, 0x823C0603,  BBREG_0x81c,
	0x813E0603,  BBREG_0x81c, 0x80400603,  BBREG_0x81c, 0x64420603,
	BBREG_0x81c, 0x63440603,  BBREG_0x81c, 0x62460603,  BBREG_0x81c,
	0x61480603,  BBREG_0x81c, 0x604A0603,  BBREG_0x81c, 0x414C0603,
	BBREG_0x81c, 0x404E0603,  BBREG_0x81c, 0x22500603,  BBREG_0x81c,
	0x21520603,  BBREG_0x81c, 0x20540603,  BBREG_0x81c, 0x03560603,
	BBREG_0x81c, 0x02580603,  BBREG_0x81c, 0x015A0603,  BBREG_0x81c,
	0x005C0603,  BBREG_0x81c, 0x005E0603,  BBREG_0x81c, 0x00600603,
	BBREG_0x81c, 0x00620603,  BBREG_0x81c, 0x00640603,  BBREG_0x81c,
	0x00660603,  BBREG_0x81c, 0x00680603,  BBREG_0x81c, 0x006A0603,
	BBREG_0x81c, 0x006C0603,  BBREG_0x81c, 0x006E0603,  BBREG_0x81c,
	0x00700603,  BBREG_0x81c, 0x00720603,  BBREG_0x81c, 0x00740603,
	BBREG_0x81c, 0x00760603,  BBREG_0x81c, 0x00780603,  BBREG_0x81c,
	0x007A0603,  BBREG_0x81c, 0x007C0603,  BBREG_0x81c, 0x007E0603,
	BBREG_0x81c, 0x007E0603,  0x90000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x81c, 0xBE000603,  BBREG_0x81c, 0xBD020603,
	BBREG_0x81c, 0xBC040603,  BBREG_0x81c, 0xBB060603,  BBREG_0x81c,
	0xBA080603,  BBREG_0x81c, 0xB90A0603,  BBREG_0x81c, 0xB80C0603,
	BBREG_0x81c, 0xB70E0603,  BBREG_0x81c, 0xB6100603,  BBREG_0x81c,
	0xB5120603,  BBREG_0x81c, 0xB4140603,  BBREG_0x81c, 0xB3160603,
	BBREG_0x81c, 0xB2180603,  BBREG_0x81c, 0xB11A0603,  BBREG_0x81c,
	0xB01C0603,  BBREG_0x81c, 0xAF1E0603,  BBREG_0x81c, 0xAE200603,
	BBREG_0x81c, 0xAD220603,  BBREG_0x81c, 0x8F240603,  BBREG_0x81c,
	0x8E260603,  BBREG_0x81c, 0x8D280603,  BBREG_0x81c, 0x8C2A0603,
	BBREG_0x81c, 0x8B2C0603,  BBREG_0x81c, 0x8A2E0603,  BBREG_0x81c,
	0x89300603,  BBREG_0x81c, 0x88320603,  BBREG_0x81c, 0x6B340603,
	BBREG_0x81c, 0x6A360603,  BBREG_0x81c, 0x69380603,  BBREG_0x81c,
	0x683A0603,  BBREG_0x81c, 0x673C0603,  BBREG_0x81c, 0x663E0603,
	BBREG_0x81c, 0x65400603,  BBREG_0x81c, 0x64420603,  BBREG_0x81c,
	0x63440603,  BBREG_0x81c, 0x62460603,  BBREG_0x81c, 0x61480603,
	BBREG_0x81c, 0x604A0603,  BBREG_0x81c, 0x424C0603,  BBREG_0x81c,
	0x414E0603,  BBREG_0x81c, 0x40500603,  BBREG_0x81c, 0x06520603,
	BBREG_0x81c, 0x05540603,  BBREG_0x81c, 0x04560603,  BBREG_0x81c,
	0x03580603,  BBREG_0x81c, 0x025A0603,  BBREG_0x81c, 0x015C0603,
	BBREG_0x81c, 0x005E0603,  BBREG_0x81c, 0x00600603,  BBREG_0x81c,
	0x00620603,  BBREG_0x81c, 0x00640603,  BBREG_0x81c, 0x00660603,
	BBREG_0x81c, 0x00680603,  BBREG_0x81c, 0x006A0603,  BBREG_0x81c,
	0x006C0603,  BBREG_0x81c, 0x006E0603,  BBREG_0x81c, 0x00700603,
	BBREG_0x81c, 0x00720603,  BBREG_0x81c, 0x00740603,  BBREG_0x81c,
	0x00760603,  BBREG_0x81c, 0x00780603,  BBREG_0x81c, 0x007A0603,
	BBREG_0x81c, 0x007C0603,  BBREG_0x81c, 0x007E0603,  BBREG_0x81c,
	0x007E0603,  0x90000008,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x81c, 0xFB000603,  BBREG_0x81c, 0xFA020603,  BBREG_0x81c,
	0xF9040603,  BBREG_0x81c, 0xF8060603,  BBREG_0x81c, 0xF7080603,
	BBREG_0x81c, 0xF60A0603,  BBREG_0x81c, 0xF50C0603,  BBREG_0x81c,
	0xF40E0603,  BBREG_0x81c, 0xF3100603,  BBREG_0x81c, 0xF2120603,
	BBREG_0x81c, 0xF1140603,  BBREG_0x81c, 0xF0160603,  BBREG_0x81c,
	0xEF180603,  BBREG_0x81c, 0xEE1A0603,  BBREG_0x81c, 0xED1C0603,
	BBREG_0x81c, 0xEC1E0603,  BBREG_0x81c, 0xEB200603,  BBREG_0x81c,
	0xEA220603,  BBREG_0x81c, 0xE9240603,  BBREG_0x81c, 0xE8260603,
	BBREG_0x81c, 0xE7280603,  BBREG_0x81c, 0xE62A0603,  BBREG_0x81c,
	0xE52C0603,  BBREG_0x81c, 0xE42E0603,  BBREG_0x81c, 0xE3300603,
	BBREG_0x81c, 0xE2320603,  BBREG_0x81c, 0xC6340603,  BBREG_0x81c,
	0xC5360603,  BBREG_0x81c, 0xC4380603,  BBREG_0x81c, 0xC33A0603,
	BBREG_0x81c, 0xC23C0603,  BBREG_0x81c, 0xC13E0603,  BBREG_0x81c,
	0xC0400603,  BBREG_0x81c, 0xA3420603,  BBREG_0x81c, 0xA2440603,
	BBREG_0x81c, 0xA1460603,  BBREG_0x81c, 0xA0480603,  BBREG_0x81c,
	0x824A0603,  BBREG_0x81c, 0x814C0603,  BBREG_0x81c, 0x804E0603,
	BBREG_0x81c, 0x63500603,  BBREG_0x81c, 0x62520603,  BBREG_0x81c,
	0x61540603,  BBREG_0x81c, 0x60560603,  BBREG_0x81c, 0x24580603,
	BBREG_0x81c, 0x235A0603,  BBREG_0x81c, 0x225C0603,  BBREG_0x81c,
	0x215E0603,  BBREG_0x81c, 0x20600603,  BBREG_0x81c, 0x03620603,
	BBREG_0x81c, 0x02640603,  BBREG_0x81c, 0x01660603,  BBREG_0x81c,
	0x00680603,  BBREG_0x81c, 0x006A0603,  BBREG_0x81c, 0x006C0603,
	BBREG_0x81c, 0x006E0603,  BBREG_0x81c, 0x00700603,  BBREG_0x81c,
	0x00720603,  BBREG_0x81c, 0x00740603,  BBREG_0x81c, 0x00760603,
	BBREG_0x81c, 0x00780603,  BBREG_0x81c, 0x007A0603,  BBREG_0x81c,
	0x007C0603,  BBREG_0x81c, 0x007E0603,  BBREG_0x81c, 0x007E0603,
	0x90000009,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c,
	0xF8000603,  BBREG_0x81c, 0xF7020603,  BBREG_0x81c, 0xF6040603,
	BBREG_0x81c, 0xF5060603,  BBREG_0x81c, 0xF4080603,  BBREG_0x81c,
	0xF30A0603,  BBREG_0x81c, 0xF20C0603,  BBREG_0x81c, 0xF10E0603,
	BBREG_0x81c, 0xF0100603,  BBREG_0x81c, 0xEF120603,  BBREG_0x81c,
	0xEE140603,  BBREG_0x81c, 0xED160603,  BBREG_0x81c, 0xEC180603,
	BBREG_0x81c, 0xEB1A0603,  BBREG_0x81c, 0xEA1C0603,  BBREG_0x81c,
	0xE91E0603,  BBREG_0x81c, 0xE8200603,  BBREG_0x81c, 0xE7220603,
	BBREG_0x81c, 0xE6240603,  BBREG_0x81c, 0xE5260603,  BBREG_0x81c,
	0xE4280603,  BBREG_0x81c, 0xE32A0603,  BBREG_0x81c, 0xC42C0603,
	BBREG_0x81c, 0xC32E0603,  BBREG_0x81c, 0xC2300603,  BBREG_0x81c,
	0xC1320603,  BBREG_0x81c, 0xA3340603,  BBREG_0x81c, 0xA2360603,
	BBREG_0x81c, 0xA1380603,  BBREG_0x81c, 0xA03A0603,  BBREG_0x81c,
	0x823C0603,  BBREG_0x81c, 0x813E0603,  BBREG_0x81c, 0x80400603,
	BBREG_0x81c, 0x65420603,  BBREG_0x81c, 0x64440603,  BBREG_0x81c,
	0x63460603,  BBREG_0x81c, 0x62480603,  BBREG_0x81c, 0x614A0603,
	BBREG_0x81c, 0x424C0603,  BBREG_0x81c, 0x414E0603,  BBREG_0x81c,
	0x40500603,  BBREG_0x81c, 0x22520603,  BBREG_0x81c, 0x21540603,
	BBREG_0x81c, 0x20560603,  BBREG_0x81c, 0x04580603,  BBREG_0x81c,
	0x035A0603,  BBREG_0x81c, 0x025C0603,  BBREG_0x81c, 0x015E0603,
	BBREG_0x81c, 0x00600603,  BBREG_0x81c, 0x00620603,  BBREG_0x81c,
	0x00640603,  BBREG_0x81c, 0x00660603,  BBREG_0x81c, 0x00680603,
	BBREG_0x81c, 0x006A0603,  BBREG_0x81c, 0x006C0603,  BBREG_0x81c,
	0x006E0603,  BBREG_0x81c, 0x00700603,  BBREG_0x81c, 0x00720603,
	BBREG_0x81c, 0x00740603,  BBREG_0x81c, 0x00760603,  BBREG_0x81c,
	0x00780603,  BBREG_0x81c, 0x007A0603,  BBREG_0x81c, 0x007C0603,
	BBREG_0x81c, 0x007E0603,  BBREG_0x81c, 0x007E0603,  0x9000000a,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c, 0xFC000603,
	BBREG_0x81c, 0xFB020603,  BBREG_0x81c, 0xFA040603,  BBREG_0x81c,
	0xF9060603,  BBREG_0x81c, 0xF8080603,  BBREG_0x81c, 0xF70A0603,
	BBREG_0x81c, 0xF60C0603,  BBREG_0x81c, 0xF50E0603,  BBREG_0x81c,
	0xF4100603,  BBREG_0x81c, 0xF3120603,  BBREG_0x81c, 0xF2140603,
	BBREG_0x81c, 0xF1160603,  BBREG_0x81c, 0xF0180603,  BBREG_0x81c,
	0xEE1A0603,  BBREG_0x81c, 0xED1C0603,  BBREG_0x81c, 0xEC1E0603,
	BBREG_0x81c, 0xEB200603,  BBREG_0x81c, 0xEA220603,  BBREG_0x81c,
	0xE9240603,  BBREG_0x81c, 0xE8260603,  BBREG_0x81c, 0xE7280603,
	BBREG_0x81c, 0xE62A0603,  BBREG_0x81c, 0xE52C0603,  BBREG_0x81c,
	0xE42E0603,  BBREG_0x81c, 0xE3300603,  BBREG_0x81c, 0xE2320603,
	BBREG_0x81c, 0xC6340603,  BBREG_0x81c, 0xC5360603,  BBREG_0x81c,
	0xC4380603,  BBREG_0x81c, 0xC33A0603,  BBREG_0x81c, 0xA63C0603,
	BBREG_0x81c, 0xA53E0603,  BBREG_0x81c, 0xA4400603,  BBREG_0x81c,
	0xA3420603,  BBREG_0x81c, 0xA2440603,  BBREG_0x81c, 0xA1460603,
	BBREG_0x81c, 0x83480603,  BBREG_0x81c, 0x824A0603,  BBREG_0x81c,
	0x814C0603,  BBREG_0x81c, 0x804E0603,  BBREG_0x81c, 0x63500603,
	BBREG_0x81c, 0x62520603,  BBREG_0x81c, 0x61540603,  BBREG_0x81c,
	0x42560603,  BBREG_0x81c, 0x41580603,  BBREG_0x81c, 0x405A0603,
	BBREG_0x81c, 0x225C0603,  BBREG_0x81c, 0x215E0603,  BBREG_0x81c,
	0x20600603,  BBREG_0x81c, 0x04620603,  BBREG_0x81c, 0x03640603,
	BBREG_0x81c, 0x02660603,  BBREG_0x81c, 0x01680603,  BBREG_0x81c,
	0x006A0603,  BBREG_0x81c, 0x006C0603,  BBREG_0x81c, 0x006E0603,
	BBREG_0x81c, 0x00700603,  BBREG_0x81c, 0x00720603,  BBREG_0x81c,
	0x00740603,  BBREG_0x81c, 0x00760603,  BBREG_0x81c, 0x00780603,
	BBREG_0x81c, 0x007A0603,  BBREG_0x81c, 0x007C0603,  BBREG_0x81c,
	0x007E0603,  BBREG_0x81c, 0x007E0603,  0x9000000b,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x81c, 0xF9000603,  BBREG_0x81c,
	0xF8020603,  BBREG_0x81c, 0xF7040603,  BBREG_0x81c, 0xF6060603,
	BBREG_0x81c, 0xF5080603,  BBREG_0x81c, 0xF40A0603,  BBREG_0x81c,
	0xF30C0603,  BBREG_0x81c, 0xF20E0603,  BBREG_0x81c, 0xF1100603,
	BBREG_0x81c, 0xF0120603,  BBREG_0x81c, 0xEF140603,  BBREG_0x81c,
	0xEE160603,  BBREG_0x81c, 0xED180603,  BBREG_0x81c, 0xEC1A0603,
	BBREG_0x81c, 0xEB1C0603,  BBREG_0x81c, 0xEA1E0603,  BBREG_0x81c,
	0xE9200603,  BBREG_0x81c, 0xE8220603,  BBREG_0x81c, 0xE7240603,
	BBREG_0x81c, 0xE6260603,  BBREG_0x81c, 0xE5280603,  BBREG_0x81c,
	0xE42A0603,  BBREG_0x81c, 0xC42C0603,  BBREG_0x81c, 0xC32E0603,
	BBREG_0x81c, 0xC2300603,  BBREG_0x81c, 0xC1320603,  BBREG_0x81c,
	0xA3340603,  BBREG_0x81c, 0xA2360603,  BBREG_0x81c, 0xA1380603,
	BBREG_0x81c, 0xA03A0603,  BBREG_0x81c, 0x823C0603,  BBREG_0x81c,
	0x813E0603,  BBREG_0x81c, 0x80400603,  BBREG_0x81c, 0x64420603,
	BBREG_0x81c, 0x63440603,  BBREG_0x81c, 0x62460603,  BBREG_0x81c,
	0x61480603,  BBREG_0x81c, 0x604A0603,  BBREG_0x81c, 0x244C0603,
	BBREG_0x81c, 0x234E0603,  BBREG_0x81c, 0x22500603,  BBREG_0x81c,
	0x21520603,  BBREG_0x81c, 0x20540603,  BBREG_0x81c, 0x05560603,
	BBREG_0x81c, 0x04580603,  BBREG_0x81c, 0x035A0603,  BBREG_0x81c,
	0x025C0603,  BBREG_0x81c, 0x015E0603,  BBREG_0x81c, 0x00600603,
	BBREG_0x81c, 0x00620603,  BBREG_0x81c, 0x00640603,  BBREG_0x81c,
	0x00660603,  BBREG_0x81c, 0x00680603,  BBREG_0x81c, 0x006A0603,
	BBREG_0x81c, 0x006C0603,  BBREG_0x81c, 0x006E0603,  BBREG_0x81c,
	0x00700603,  BBREG_0x81c, 0x00720603,  BBREG_0x81c, 0x00740603,
	BBREG_0x81c, 0x00760603,  BBREG_0x81c, 0x00780603,  BBREG_0x81c,
	0x007A0603,  BBREG_0x81c, 0x007C0603,  BBREG_0x81c, 0x007E0603,
	BBREG_0x81c, 0x007E0603,  0x9000000c,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x81c, 0xFC000603,  BBREG_0x81c, 0xFB020603,
	BBREG_0x81c, 0xFA040603,  BBREG_0x81c, 0xF9060603,  BBREG_0x81c,
	0xF8080603,  BBREG_0x81c, 0xF70A0603,  BBREG_0x81c, 0xF60C0603,
	BBREG_0x81c, 0xF50E0603,  BBREG_0x81c, 0xF4100603,  BBREG_0x81c,
	0xF3120603,  BBREG_0x81c, 0xF2140603,  BBREG_0x81c, 0xF1160603,
	BBREG_0x81c, 0xF0180603,  BBREG_0x81c, 0xEF1A0603,  BBREG_0x81c,
	0xEE1C0603,  BBREG_0x81c, 0xED1E0603,  BBREG_0x81c, 0xEC200603,
	BBREG_0x81c, 0xEB220603,  BBREG_0x81c, 0xEA240603,  BBREG_0x81c,
	0xE9260603,  BBREG_0x81c, 0xE8280603,  BBREG_0x81c, 0xE72A0603,
	BBREG_0x81c, 0xE62C0603,  BBREG_0x81c, 0xE52E0603,  BBREG_0x81c,
	0xE4300603,  BBREG_0x81c, 0xE3320603,  BBREG_0x81c, 0xE2340603,
	BBREG_0x81c, 0xC6360603,  BBREG_0x81c, 0xC5380603,  BBREG_0x81c,
	0xC43A0603,  BBREG_0x81c, 0xC33C0603,  BBREG_0x81c, 0xA63E0603,
	BBREG_0x81c, 0xA5400603,  BBREG_0x81c, 0xA4420603,  BBREG_0x81c,
	0xA3440603,  BBREG_0x81c, 0xA2460603,  BBREG_0x81c, 0xA1480603,
	BBREG_0x81c, 0x834A0603,  BBREG_0x81c, 0x824C0603,  BBREG_0x81c,
	0x814E0603,  BBREG_0x81c, 0x64500603,  BBREG_0x81c, 0x63520603,
	BBREG_0x81c, 0x62540603,  BBREG_0x81c, 0x61560603,  BBREG_0x81c,
	0x60580603,  BBREG_0x81c, 0x405A0603,  BBREG_0x81c, 0x215C0603,
	BBREG_0x81c, 0x205E0603,  BBREG_0x81c, 0x03600603,  BBREG_0x81c,
	0x02620603,  BBREG_0x81c, 0x01640603,  BBREG_0x81c, 0x00660603,
	BBREG_0x81c, 0x00680603,  BBREG_0x81c, 0x006A0603,  BBREG_0x81c,
	0x006C0603,  BBREG_0x81c, 0x006E0603,  BBREG_0x81c, 0x00700603,
	BBREG_0x81c, 0x00720603,  BBREG_0x81c, 0x00740603,  BBREG_0x81c,
	0x00760603,  BBREG_0x81c, 0x00780603,  BBREG_0x81c, 0x007A0603,
	BBREG_0x81c, 0x007C0603,  BBREG_0x81c, 0x007E0603,  BBREG_0x81c,
	0x007E0603,  0x9000000d,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x81c, 0xFC000603,  BBREG_0x81c, 0xFB020603,  BBREG_0x81c,
	0xFA040603,  BBREG_0x81c, 0xF9060603,  BBREG_0x81c, 0xF8080603,
	BBREG_0x81c, 0xF70A0603,  BBREG_0x81c, 0xF60C0603,  BBREG_0x81c,
	0xF50E0603,  BBREG_0x81c, 0xF4100603,  BBREG_0x81c, 0xF3120603,
	BBREG_0x81c, 0xF2140603,  BBREG_0x81c, 0xF1160603,  BBREG_0x81c,
	0xF0180603,  BBREG_0x81c, 0xEE1A0603,  BBREG_0x81c, 0xED1C0603,
	BBREG_0x81c, 0xEC1E0603,  BBREG_0x81c, 0xEB200603,  BBREG_0x81c,
	0xEA220603,  BBREG_0x81c, 0xE9240603,  BBREG_0x81c, 0xE8260603,
	BBREG_0x81c, 0xE7280603,  BBREG_0x81c, 0xE62A0603,  BBREG_0x81c,
	0xE52C0603,  BBREG_0x81c, 0xE42E0603,  BBREG_0x81c, 0xE3300603,
	BBREG_0x81c, 0xE2320603,  BBREG_0x81c, 0xC6340603,  BBREG_0x81c,
	0xC5360603,  BBREG_0x81c, 0xC4380603,  BBREG_0x81c, 0xC33A0603,
	BBREG_0x81c, 0xA63C0603,  BBREG_0x81c, 0xA53E0603,  BBREG_0x81c,
	0xA4400603,  BBREG_0x81c, 0xA3420603,  BBREG_0x81c, 0xA2440603,
	BBREG_0x81c, 0xA1460603,  BBREG_0x81c, 0x83480603,  BBREG_0x81c,
	0x824A0603,  BBREG_0x81c, 0x814C0603,  BBREG_0x81c, 0x804E0603,
	BBREG_0x81c, 0x63500603,  BBREG_0x81c, 0x62520603,  BBREG_0x81c,
	0x61540603,  BBREG_0x81c, 0x42560603,  BBREG_0x81c, 0x41580603,
	BBREG_0x81c, 0x405A0603,  BBREG_0x81c, 0x225C0603,  BBREG_0x81c,
	0x215E0603,  BBREG_0x81c, 0x20600603,  BBREG_0x81c, 0x04620603,
	BBREG_0x81c, 0x03640603,  BBREG_0x81c, 0x02660603,  BBREG_0x81c,
	0x01680603,  BBREG_0x81c, 0x006A0603,  BBREG_0x81c, 0x006C0603,
	BBREG_0x81c, 0x006E0603,  BBREG_0x81c, 0x00700603,  BBREG_0x81c,
	0x00720603,  BBREG_0x81c, 0x00740603,  BBREG_0x81c, 0x00760603,
	BBREG_0x81c, 0x00780603,  BBREG_0x81c, 0x007A0603,  BBREG_0x81c,
	0x007C0603,  BBREG_0x81c, 0x007E0603,  BBREG_0x81c, 0x007E0603,
	0x9000000e,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c,
	0xFC000603,  BBREG_0x81c, 0xFB020603,  BBREG_0x81c, 0xFA040603,
	BBREG_0x81c, 0xF9060603,  BBREG_0x81c, 0xF8080603,  BBREG_0x81c,
	0xF70A0603,  BBREG_0x81c, 0xF60C0603,  BBREG_0x81c, 0xF50E0603,
	BBREG_0x81c, 0xF4100603,  BBREG_0x81c, 0xF3120603,  BBREG_0x81c,
	0xF2140603,  BBREG_0x81c, 0xF1160603,  BBREG_0x81c, 0xF0180603,
	BBREG_0x81c, 0xEE1A0603,  BBREG_0x81c, 0xED1C0603,  BBREG_0x81c,
	0xEC1E0603,  BBREG_0x81c, 0xEB200603,  BBREG_0x81c, 0xEA220603,
	BBREG_0x81c, 0xE9240603,  BBREG_0x81c, 0xE8260603,  BBREG_0x81c,
	0xE7280603,  BBREG_0x81c, 0xE62A0603,  BBREG_0x81c, 0xE52C0603,
	BBREG_0x81c, 0xE42E0603,  BBREG_0x81c, 0xE3300603,  BBREG_0x81c,
	0xE2320603,  BBREG_0x81c, 0xC6340603,  BBREG_0x81c, 0xC5360603,
	BBREG_0x81c, 0xC4380603,  BBREG_0x81c, 0xC33A0603,  BBREG_0x81c,
	0xA63C0603,  BBREG_0x81c, 0xA53E0603,  BBREG_0x81c, 0xA4400603,
	BBREG_0x81c, 0xA3420603,  BBREG_0x81c, 0xA2440603,  BBREG_0x81c,
	0xA1460603,  BBREG_0x81c, 0x83480603,  BBREG_0x81c, 0x824A0603,
	BBREG_0x81c, 0x814C0603,  BBREG_0x81c, 0x804E0603,  BBREG_0x81c,
	0x63500603,  BBREG_0x81c, 0x62520603,  BBREG_0x81c, 0x61540603,
	BBREG_0x81c, 0x42560603,  BBREG_0x81c, 0x41580603,  BBREG_0x81c,
	0x405A0603,  BBREG_0x81c, 0x225C0603,  BBREG_0x81c, 0x215E0603,
	BBREG_0x81c, 0x20600603,  BBREG_0x81c, 0x04620603,  BBREG_0x81c,
	0x03640603,  BBREG_0x81c, 0x02660603,  BBREG_0x81c, 0x01680603,
	BBREG_0x81c, 0x006A0603,  BBREG_0x81c, 0x006C0603,  BBREG_0x81c,
	0x006E0603,  BBREG_0x81c, 0x00700603,  BBREG_0x81c, 0x00720603,
	BBREG_0x81c, 0x00740603,  BBREG_0x81c, 0x00760603,  BBREG_0x81c,
	0x00780603,  BBREG_0x81c, 0x007A0603,  BBREG_0x81c, 0x007C0603,
	BBREG_0x81c, 0x007E0603,  BBREG_0x81c, 0x007E0603,  0x9000000f,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c, 0xBF000603,
	BBREG_0x81c, 0xBF020603,  BBREG_0x81c, 0xBF040603,  BBREG_0x81c,
	0xBF060603,  BBREG_0x81c, 0xBF080603,  BBREG_0x81c, 0xBE0A0603,
	BBREG_0x81c, 0xBD0C0603,  BBREG_0x81c, 0xBC0E0603,  BBREG_0x81c,
	0xBB100603,  BBREG_0x81c, 0xBA120603,  BBREG_0x81c, 0xB9140603,
	BBREG_0x81c, 0xB8160603,  BBREG_0x81c, 0xB7180603,  BBREG_0x81c,
	0xB61A0603,  BBREG_0x81c, 0xB51C0603,  BBREG_0x81c, 0xB41E0603,
	BBREG_0x81c, 0xB1200603,  BBREG_0x81c, 0xB2220603,  BBREG_0x81c,
	0xB1240603,  BBREG_0x81c, 0xB0260603,  BBREG_0x81c, 0xAF280603,
	BBREG_0x81c, 0xAE2A0603,  BBREG_0x81c, 0xAD2C0603,  BBREG_0x81c,
	0xAC2E0603,  BBREG_0x81c, 0xAB300603,  BBREG_0x81c, 0xAA320603,
	BBREG_0x81c, 0xC6340603,  BBREG_0x81c, 0xC5360603,  BBREG_0x81c,
	0xC4380603,  BBREG_0x81c, 0xC33A0603,  BBREG_0x81c, 0x883C0603,
	BBREG_0x81c, 0x873E0603,  BBREG_0x81c, 0x86400603,  BBREG_0x81c,
	0x85420603,  BBREG_0x81c, 0x84440603,  BBREG_0x81c, 0x83460603,
	BBREG_0x81c, 0x67480603,  BBREG_0x81c, 0x664A0603,  BBREG_0x81c,
	0x654C0603,  BBREG_0x81c, 0x644E0603,  BBREG_0x81c, 0x27500603,
	BBREG_0x81c, 0x26520603,  BBREG_0x81c, 0x25540603,  BBREG_0x81c,
	0x24560603,  BBREG_0x81c, 0x23580603,  BBREG_0x81c, 0x225A0603,
	BBREG_0x81c, 0x215C0603,  BBREG_0x81c, 0x205E0603,  BBREG_0x81c,
	0x03600603,  BBREG_0x81c, 0x02620603,  BBREG_0x81c, 0x01640603,
	BBREG_0x81c, 0x00660603,  BBREG_0x81c, 0x00680603,  BBREG_0x81c,
	0x006A0603,  BBREG_0x81c, 0x006C0603,  BBREG_0x81c, 0x006E0603,
	BBREG_0x81c, 0x00700603,  BBREG_0x81c, 0x00720603,  BBREG_0x81c,
	0x00740603,  BBREG_0x81c, 0x00760603,  BBREG_0x81c, 0x00780603,
	BBREG_0x81c, 0x007A0603,  BBREG_0x81c, 0x007C0603,  BBREG_0x81c,
	0x007E0603,  BBREG_0x81c, 0x007E0603,  0x90000010,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x81c, 0xFC000403,  BBREG_0x81c,
	0xFB000603,  BBREG_0x81c, 0xFA020603,  BBREG_0x81c, 0xF9040603,
	BBREG_0x81c, 0xF8060603,  BBREG_0x81c, 0xF7080603,  BBREG_0x81c,
	0xF60A0603,  BBREG_0x81c, 0xF50C0603,  BBREG_0x81c, 0xF40E0603,
	BBREG_0x81c, 0xF3100603,  BBREG_0x81c, 0xF2120603,  BBREG_0x81c,
	0xF1140603,  BBREG_0x81c, 0xF0160603,  BBREG_0x81c, 0xEF180603,
	BBREG_0x81c, 0xEE1A0603,  BBREG_0x81c, 0xED1C0603,  BBREG_0x81c,
	0xEC1E0603,  BBREG_0x81c, 0xEB200603,  BBREG_0x81c, 0xEA220603,
	BBREG_0x81c, 0xE9240603,  BBREG_0x81c, 0xE8260603,  BBREG_0x81c,
	0xE7280603,  BBREG_0x81c, 0xE62A0603,  BBREG_0x81c, 0xE52C0603,
	BBREG_0x81c, 0xE42E0603,  BBREG_0x81c, 0xE3300603,  BBREG_0x81c,
	0xE2320603,  BBREG_0x81c, 0xC6340603,  BBREG_0x81c, 0xC5360603,
	BBREG_0x81c, 0xC4380603,  BBREG_0x81c, 0xC33A0603,  BBREG_0x81c,
	0xA63C0603,  BBREG_0x81c, 0xA53E0603,  BBREG_0x81c, 0xA4400603,
	BBREG_0x81c, 0xA3420603,  BBREG_0x81c, 0xA2440603,  BBREG_0x81c,
	0xA1460603,  BBREG_0x81c, 0x83480603,  BBREG_0x81c, 0x824A0603,
	BBREG_0x81c, 0x814C0603,  BBREG_0x81c, 0x644E0603,  BBREG_0x81c,
	0x63500603,  BBREG_0x81c, 0x62520603,  BBREG_0x81c, 0x61540603,
	BBREG_0x81c, 0x60560603,  BBREG_0x81c, 0x40580603,  BBREG_0x81c,
	0x215A0603,  BBREG_0x81c, 0x205C0603,  BBREG_0x81c, 0x035E0603,
	BBREG_0x81c, 0x02600603,  BBREG_0x81c, 0x01620603,  BBREG_0x81c,
	0x00640603,  BBREG_0x81c, 0x00660603,  BBREG_0x81c, 0x00680603,
	BBREG_0x81c, 0x006A0603,  BBREG_0x81c, 0x006C0603,  BBREG_0x81c,
	0x006E0603,  BBREG_0x81c, 0x00700603,  BBREG_0x81c, 0x00720603,
	BBREG_0x81c, 0x00740603,  BBREG_0x81c, 0x00760603,  BBREG_0x81c,
	0x00780603,  BBREG_0x81c, 0x007A0603,  BBREG_0x81c, 0x007C0603,
	BBREG_0x81c, 0x007E0603,  0xA0000000,  0x00000000,  BBREG_0x81c,
	0xFD000603,  BBREG_0x81c, 0xFC020603,  BBREG_0x81c, 0xFB040603,
	BBREG_0x81c, 0xFA060603,  BBREG_0x81c, 0xF9080603,  BBREG_0x81c,
	0xF80A0603,  BBREG_0x81c, 0xF70C0603,  BBREG_0x81c, 0xF60E0603,
	BBREG_0x81c, 0xF5100603,  BBREG_0x81c, 0xF4120603,  BBREG_0x81c,
	0xF3140603,  BBREG_0x81c, 0xF2160603,  BBREG_0x81c, 0xF1180603,
	BBREG_0x81c, 0xF01A0603,  BBREG_0x81c, 0xEF1C0603,  BBREG_0x81c,
	0xEE1E0603,  BBREG_0x81c, 0xED200603,  BBREG_0x81c, 0xEC220603,
	BBREG_0x81c, 0xEB240603,  BBREG_0x81c, 0xEA260603,  BBREG_0x81c,
	0xE9280603,  BBREG_0x81c, 0xE82A0603,  BBREG_0x81c, 0xE72C0603,
	BBREG_0x81c, 0xE62E0603,  BBREG_0x81c, 0xE5300603,  BBREG_0x81c,
	0xE4320603,  BBREG_0x81c, 0xE3340603,  BBREG_0x81c, 0xC6360603,
	BBREG_0x81c, 0xC5380603,  BBREG_0x81c, 0xC43A0603,  BBREG_0x81c,
	0xC33C0603,  BBREG_0x81c, 0xA63E0603,  BBREG_0x81c, 0xA5400603,
	BBREG_0x81c, 0xA4420603,  BBREG_0x81c, 0xA3440603,  BBREG_0x81c,
	0xA2460603,  BBREG_0x81c, 0xA1480603,  BBREG_0x81c, 0x834A0603,
	BBREG_0x81c, 0x824C0603,  BBREG_0x81c, 0x814E0603,  BBREG_0x81c,
	0x64500603,  BBREG_0x81c, 0x63520603,  BBREG_0x81c, 0x62540603,
	BBREG_0x81c, 0x61560603,  BBREG_0x81c, 0x60580603,  BBREG_0x81c,
	0x235A0603,  BBREG_0x81c, 0x225C0603,  BBREG_0x81c, 0x215E0603,
	BBREG_0x81c, 0x20600603,  BBREG_0x81c, 0x03620603,  BBREG_0x81c,
	0x02640603,  BBREG_0x81c, 0x01660603,  BBREG_0x81c, 0x00680603,
	BBREG_0x81c, 0x006A0603,  BBREG_0x81c, 0x006C0603,  BBREG_0x81c,
	0x006E0603,  BBREG_0x81c, 0x00700603,  BBREG_0x81c, 0x00720603,
	BBREG_0x81c, 0x00740603,  BBREG_0x81c, 0x00760603,  BBREG_0x81c,
	0x00780603,  BBREG_0x81c, 0x007A0603,  BBREG_0x81c, 0x007C0603,
	BBREG_0x81c, 0x007E0603,  BBREG_0x81c, 0x007E0603,  0xB0000000,
	0x00000000,  0x80000000,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x81c, 0xFC000703,  BBREG_0x81c, 0xFB020703,  BBREG_0x81c,
	0xFA040703,  BBREG_0x81c, 0xF9060703,  BBREG_0x81c, 0xF8080703,
	BBREG_0x81c, 0xF70A0703,  BBREG_0x81c, 0xF60C0703,  BBREG_0x81c,
	0xF50E0703,  BBREG_0x81c, 0xF4100703,  BBREG_0x81c, 0xF3120703,
	BBREG_0x81c, 0xF2140703,  BBREG_0x81c, 0xF1160703,  BBREG_0x81c,
	0xEF180703,  BBREG_0x81c, 0xEE1A0703,  BBREG_0x81c, 0xED1C0703,
	BBREG_0x81c, 0xEC1E0703,  BBREG_0x81c, 0xEB200703,  BBREG_0x81c,
	0xEA220703,  BBREG_0x81c, 0xE9240703,  BBREG_0x81c, 0xE8260703,
	BBREG_0x81c, 0xE7280703,  BBREG_0x81c, 0xE62A0703,  BBREG_0x81c,
	0xE52C0703,  BBREG_0x81c, 0xE42E0703,  BBREG_0x81c, 0xE3300703,
	BBREG_0x81c, 0xE2320703,  BBREG_0x81c, 0xC6340703,  BBREG_0x81c,
	0xC5360703,  BBREG_0x81c, 0xC4380703,  BBREG_0x81c, 0xC33A0703,
	BBREG_0x81c, 0xA63C0703,  BBREG_0x81c, 0xA53E0703,  BBREG_0x81c,
	0xA4400703,  BBREG_0x81c, 0xA3420703,  BBREG_0x81c, 0xA2440703,
	BBREG_0x81c, 0xA1460703,  BBREG_0x81c, 0x83480703,  BBREG_0x81c,
	0x824A0703,  BBREG_0x81c, 0x814C0703,  BBREG_0x81c, 0x804E0703,
	BBREG_0x81c, 0x63500703,  BBREG_0x81c, 0x62520703,  BBREG_0x81c,
	0x61540703,  BBREG_0x81c, 0x42560703,  BBREG_0x81c, 0x41580703,
	BBREG_0x81c, 0x405A0703,  BBREG_0x81c, 0x225C0703,  BBREG_0x81c,
	0x215E0703,  BBREG_0x81c, 0x20600703,  BBREG_0x81c, 0x04620703,
	BBREG_0x81c, 0x03640703,  BBREG_0x81c, 0x02660703,  BBREG_0x81c,
	0x01680703,  BBREG_0x81c, 0x006A0703,  BBREG_0x81c, 0x006C0703,
	BBREG_0x81c, 0x006E0703,  BBREG_0x81c, 0x00700703,  BBREG_0x81c,
	0x00720703,  BBREG_0x81c, 0x00740703,  BBREG_0x81c, 0x00760703,
	BBREG_0x81c, 0x00780703,  BBREG_0x81c, 0x007A0703,  BBREG_0x81c,
	0x007C0703,  BBREG_0x81c, 0x007E0703,  BBREG_0x81c, 0x007E0703,
	0x90000001,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c,
	0xBD000703,  BBREG_0x81c, 0xBC020703,  BBREG_0x81c, 0xBB040703,
	BBREG_0x81c, 0xBA060703,  BBREG_0x81c, 0xB9080703,  BBREG_0x81c,
	0xB80A0703,  BBREG_0x81c, 0xB70C0703,  BBREG_0x81c, 0xB60E0703,
	BBREG_0x81c, 0xB5100703,  BBREG_0x81c, 0xB4120703,  BBREG_0x81c,
	0xB3140703,  BBREG_0x81c, 0xB2160703,  BBREG_0x81c, 0xB1180703,
	BBREG_0x81c, 0xB01A0703,  BBREG_0x81c, 0xAF1C0703,  BBREG_0x81c,
	0xAE1E0703,  BBREG_0x81c, 0xAD200703,  BBREG_0x81c, 0xAC220703,
	BBREG_0x81c, 0x8E240703,  BBREG_0x81c, 0x8D260703,  BBREG_0x81c,
	0x8C280703,  BBREG_0x81c, 0x6F2A0703,  BBREG_0x81c, 0x6E2C0703,
	BBREG_0x81c, 0x6D2E0703,  BBREG_0x81c, 0x6C300703,  BBREG_0x81c,
	0x6B320703,  BBREG_0x81c, 0x6A340703,  BBREG_0x81c, 0x69360703,
	BBREG_0x81c, 0x68380703,  BBREG_0x81c, 0x673A0703,  BBREG_0x81c,
	0x663C0703,  BBREG_0x81c, 0x653E0703,  BBREG_0x81c, 0x64400703,
	BBREG_0x81c, 0x63420703,  BBREG_0x81c, 0x62440703,  BBREG_0x81c,
	0x61460703,  BBREG_0x81c, 0x60480703,  BBREG_0x81c, 0x424A0703,
	BBREG_0x81c, 0x414C0703,  BBREG_0x81c, 0x404E0703,  BBREG_0x81c,
	0x06500703,  BBREG_0x81c, 0x05520703,  BBREG_0x81c, 0x04540703,
	BBREG_0x81c, 0x03560703,  BBREG_0x81c, 0x02580703,  BBREG_0x81c,
	0x015A0703,  BBREG_0x81c, 0x005C0703,  BBREG_0x81c, 0x005E0703,
	BBREG_0x81c, 0x00600703,  BBREG_0x81c, 0x00620703,  BBREG_0x81c,
	0x00640703,  BBREG_0x81c, 0x00660703,  BBREG_0x81c, 0x00680703,
	BBREG_0x81c, 0x006A0703,  BBREG_0x81c, 0x006C0703,  BBREG_0x81c,
	0x006E0703,  BBREG_0x81c, 0x00700703,  BBREG_0x81c, 0x00720703,
	BBREG_0x81c, 0x00740703,  BBREG_0x81c, 0x00760703,  BBREG_0x81c,
	0x00780703,  BBREG_0x81c, 0x007A0703,  BBREG_0x81c, 0x007C0703,
	BBREG_0x81c, 0x007E0703,  BBREG_0x81c, 0x007C0703,  0x90000002,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c, 0xF7000703,
	BBREG_0x81c, 0xF6020703,  BBREG_0x81c, 0xF5040703,  BBREG_0x81c,
	0xF4060703,  BBREG_0x81c, 0xF3080703,  BBREG_0x81c, 0xF20A0703,
	BBREG_0x81c, 0xF10C0703,  BBREG_0x81c, 0xF00E0703,  BBREG_0x81c,
	0xEF100703,  BBREG_0x81c, 0xEE120703,  BBREG_0x81c, 0xED140703,
	BBREG_0x81c, 0xEC160703,  BBREG_0x81c, 0xEB180703,  BBREG_0x81c,
	0xEA1A0703,  BBREG_0x81c, 0xE91C0703,  BBREG_0x81c, 0xCA1E0703,
	BBREG_0x81c, 0xC9200703,  BBREG_0x81c, 0xC8220703,  BBREG_0x81c,
	0xC7240703,  BBREG_0x81c, 0xC6260703,  BBREG_0x81c, 0xC5280703,
	BBREG_0x81c, 0xC42A0703,  BBREG_0x81c, 0xC32C0703,  BBREG_0x81c,
	0xC22E0703,  BBREG_0x81c, 0xC1300703,  BBREG_0x81c, 0xA4320703,
	BBREG_0x81c, 0xA3340703,  BBREG_0x81c, 0xA2360703,  BBREG_0x81c,
	0xA1380703,  BBREG_0x81c, 0xA03A0703,  BBREG_0x81c, 0x823C0703,
	BBREG_0x81c, 0x813E0703,  BBREG_0x81c, 0x80400703,  BBREG_0x81c,
	0x64420703,  BBREG_0x81c, 0x63440703,  BBREG_0x81c, 0x62460703,
	BBREG_0x81c, 0x61480703,  BBREG_0x81c, 0x604A0703,  BBREG_0x81c,
	0x414C0703,  BBREG_0x81c, 0x404E0703,  BBREG_0x81c, 0x22500703,
	BBREG_0x81c, 0x21520703,  BBREG_0x81c, 0x20540703,  BBREG_0x81c,
	0x03560703,  BBREG_0x81c, 0x02580703,  BBREG_0x81c, 0x015A0703,
	BBREG_0x81c, 0x005C0703,  BBREG_0x81c, 0x005E0703,  BBREG_0x81c,
	0x00600703,  BBREG_0x81c, 0x00620703,  BBREG_0x81c, 0x00640703,
	BBREG_0x81c, 0x00660703,  BBREG_0x81c, 0x00680703,  BBREG_0x81c,
	0x006A0703,  BBREG_0x81c, 0x006C0703,  BBREG_0x81c, 0x006E0703,
	BBREG_0x81c, 0x00700703,  BBREG_0x81c, 0x00720703,  BBREG_0x81c,
	0x00740703,  BBREG_0x81c, 0x00760703,  BBREG_0x81c, 0x00780703,
	BBREG_0x81c, 0x007A0703,  BBREG_0x81c, 0x007C0703,  BBREG_0x81c,
	0x007E0703,  BBREG_0x81c, 0x007E0703,  0x90000003,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x81c, 0xFC000703,  BBREG_0x81c,
	0xFB020703,  BBREG_0x81c, 0xFA040703,  BBREG_0x81c, 0xF9060703,
	BBREG_0x81c, 0xF8080703,  BBREG_0x81c, 0xF70A0703,  BBREG_0x81c,
	0xF60C0703,  BBREG_0x81c, 0xF50E0703,  BBREG_0x81c, 0xF4100703,
	BBREG_0x81c, 0xF3120703,  BBREG_0x81c, 0xF2140703,  BBREG_0x81c,
	0xF1160703,  BBREG_0x81c, 0xF0180703,  BBREG_0x81c, 0xEF1A0703,
	BBREG_0x81c, 0xEE1C0703,  BBREG_0x81c, 0xED1E0703,  BBREG_0x81c,
	0xEC200703,  BBREG_0x81c, 0xEB220703,  BBREG_0x81c, 0xEA240703,
	BBREG_0x81c, 0xE9260703,  BBREG_0x81c, 0xE8280703,  BBREG_0x81c,
	0xE72A0703,  BBREG_0x81c, 0xE62C0703,  BBREG_0x81c, 0xE52E0703,
	BBREG_0x81c, 0xE4300703,  BBREG_0x81c, 0xE3320703,  BBREG_0x81c,
	0xE2340703,  BBREG_0x81c, 0xC6360703,  BBREG_0x81c, 0xC5380703,
	BBREG_0x81c, 0xC43A0703,  BBREG_0x81c, 0xC33C0703,  BBREG_0x81c,
	0xA63E0703,  BBREG_0x81c, 0xA5400703,  BBREG_0x81c, 0xA4420703,
	BBREG_0x81c, 0xA3440703,  BBREG_0x81c, 0xA2460703,  BBREG_0x81c,
	0x84480703,  BBREG_0x81c, 0x834A0703,  BBREG_0x81c, 0x824C0703,
	BBREG_0x81c, 0x814E0703,  BBREG_0x81c, 0x80500703,  BBREG_0x81c,
	0x63520703,  BBREG_0x81c, 0x62540703,  BBREG_0x81c, 0x61560703,
	BBREG_0x81c, 0x60580703,  BBREG_0x81c, 0x225A0703,  BBREG_0x81c,
	0x055C0703,  BBREG_0x81c, 0x045E0703,  BBREG_0x81c, 0x03600703,
	BBREG_0x81c, 0x02620703,  BBREG_0x81c, 0x01640703,  BBREG_0x81c,
	0x00660703,  BBREG_0x81c, 0x00680703,  BBREG_0x81c, 0x006A0703,
	BBREG_0x81c, 0x006C0703,  BBREG_0x81c, 0x006E0703,  BBREG_0x81c,
	0x00700703,  BBREG_0x81c, 0x00720703,  BBREG_0x81c, 0x00740703,
	BBREG_0x81c, 0x00760703,  BBREG_0x81c, 0x00780703,  BBREG_0x81c,
	0x007A0703,  BBREG_0x81c, 0x007C0703,  BBREG_0x81c, 0x007E0703,
	BBREG_0x81c, 0x007E0703,  0x90000004,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x81c, 0xF7000703,  BBREG_0x81c, 0xF6020703,
	BBREG_0x81c, 0xF5040703,  BBREG_0x81c, 0xF4060703,  BBREG_0x81c,
	0xF3080703,  BBREG_0x81c, 0xF20A0703,  BBREG_0x81c, 0xF10C0703,
	BBREG_0x81c, 0xF00E0703,  BBREG_0x81c, 0xEF100703,  BBREG_0x81c,
	0xEE120703,  BBREG_0x81c, 0xED140703,  BBREG_0x81c, 0xEC160703,
	BBREG_0x81c, 0xEB180703,  BBREG_0x81c, 0xEA1A0703,  BBREG_0x81c,
	0xE91C0703,  BBREG_0x81c, 0xCA1E0703,  BBREG_0x81c, 0xC9200703,
	BBREG_0x81c, 0xC8220703,  BBREG_0x81c, 0xC7240703,  BBREG_0x81c,
	0xC6260703,  BBREG_0x81c, 0xC5280703,  BBREG_0x81c, 0xC42A0703,
	BBREG_0x81c, 0xC32C0703,  BBREG_0x81c, 0xC22E0703,  BBREG_0x81c,
	0xC1300703,  BBREG_0x81c, 0xA4320703,  BBREG_0x81c, 0xA3340703,
	BBREG_0x81c, 0xA2360703,  BBREG_0x81c, 0xA1380703,  BBREG_0x81c,
	0xA03A0703,  BBREG_0x81c, 0x823C0703,  BBREG_0x81c, 0x813E0703,
	BBREG_0x81c, 0x80400703,  BBREG_0x81c, 0x64420703,  BBREG_0x81c,
	0x63440703,  BBREG_0x81c, 0x62460703,  BBREG_0x81c, 0x61480703,
	BBREG_0x81c, 0x604A0703,  BBREG_0x81c, 0x414C0703,  BBREG_0x81c,
	0x404E0703,  BBREG_0x81c, 0x22500703,  BBREG_0x81c, 0x21520703,
	BBREG_0x81c, 0x20540703,  BBREG_0x81c, 0x03560703,  BBREG_0x81c,
	0x02580703,  BBREG_0x81c, 0x015A0703,  BBREG_0x81c, 0x005C0703,
	BBREG_0x81c, 0x005E0703,  BBREG_0x81c, 0x00600703,  BBREG_0x81c,
	0x00620703,  BBREG_0x81c, 0x00640703,  BBREG_0x81c, 0x00660703,
	BBREG_0x81c, 0x00680703,  BBREG_0x81c, 0x006A0703,  BBREG_0x81c,
	0x006C0703,  BBREG_0x81c, 0x006E0703,  BBREG_0x81c, 0x00700703,
	BBREG_0x81c, 0x00720703,  BBREG_0x81c, 0x00740703,  BBREG_0x81c,
	0x00760703,  BBREG_0x81c, 0x00780703,  BBREG_0x81c, 0x007A0703,
	BBREG_0x81c, 0x007C0703,  BBREG_0x81c, 0x007E0703,  BBREG_0x81c,
	0x007E0703,  0x90000005,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x81c, 0xFB000703,  BBREG_0x81c, 0xFA020703,  BBREG_0x81c,
	0xF9040703,  BBREG_0x81c, 0xF8060703,  BBREG_0x81c, 0xF7080703,
	BBREG_0x81c, 0xF60A0703,  BBREG_0x81c, 0xF50C0703,  BBREG_0x81c,
	0xF40E0703,  BBREG_0x81c, 0xF3100703,  BBREG_0x81c, 0xF2120703,
	BBREG_0x81c, 0xF1140703,  BBREG_0x81c, 0xF0160703,  BBREG_0x81c,
	0xEF180703,  BBREG_0x81c, 0xEE1A0703,  BBREG_0x81c, 0xED1C0703,
	BBREG_0x81c, 0xEC1E0703,  BBREG_0x81c, 0xEB200703,  BBREG_0x81c,
	0xEA220703,  BBREG_0x81c, 0xE9240703,  BBREG_0x81c, 0xE8260703,
	BBREG_0x81c, 0xE7280703,  BBREG_0x81c, 0xE62A0703,  BBREG_0x81c,
	0xE52C0703,  BBREG_0x81c, 0xE42E0703,  BBREG_0x81c, 0xE3300703,
	BBREG_0x81c, 0xE2320703,  BBREG_0x81c, 0xE1340703,  BBREG_0x81c,
	0xC5360703,  BBREG_0x81c, 0xC4380703,  BBREG_0x81c, 0xC33A0703,
	BBREG_0x81c, 0xC23C0703,  BBREG_0x81c, 0xC13E0703,  BBREG_0x81c,
	0xA4400703,  BBREG_0x81c, 0xA3420703,  BBREG_0x81c, 0xA2440703,
	BBREG_0x81c, 0xA1460703,  BBREG_0x81c, 0x83480703,  BBREG_0x81c,
	0x824A0703,  BBREG_0x81c, 0x814C0703,  BBREG_0x81c, 0x804E0703,
	BBREG_0x81c, 0x64500703,  BBREG_0x81c, 0x63520703,  BBREG_0x81c,
	0x62540703,  BBREG_0x81c, 0x61560703,  BBREG_0x81c, 0x60580703,
	BBREG_0x81c, 0x235A0703,  BBREG_0x81c, 0x225C0703,  BBREG_0x81c,
	0x215E0703,  BBREG_0x81c, 0x20600703,  BBREG_0x81c, 0x04620703,
	BBREG_0x81c, 0x03640703,  BBREG_0x81c, 0x02660703,  BBREG_0x81c,
	0x01680703,  BBREG_0x81c, 0x006A0703,  BBREG_0x81c, 0x006C0703,
	BBREG_0x81c, 0x006E0703,  BBREG_0x81c, 0x00700703,  BBREG_0x81c,
	0x00720703,  BBREG_0x81c, 0x00740703,  BBREG_0x81c, 0x00760703,
	BBREG_0x81c, 0x00780703,  BBREG_0x81c, 0x007A0703,  BBREG_0x81c,
	0x007C0703,  BBREG_0x81c, 0x007E0703,  BBREG_0x81c, 0x007E0703,
	0x90000006,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c,
	0xF9000703,  BBREG_0x81c, 0xF8020703,  BBREG_0x81c, 0xF7040703,
	BBREG_0x81c, 0xF6060703,  BBREG_0x81c, 0xF5080703,  BBREG_0x81c,
	0xF40A0703,  BBREG_0x81c, 0xF30C0703,  BBREG_0x81c, 0xF20E0703,
	BBREG_0x81c, 0xF1100703,  BBREG_0x81c, 0xF0120703,  BBREG_0x81c,
	0xEF140703,  BBREG_0x81c, 0xEE160703,  BBREG_0x81c, 0xED180703,
	BBREG_0x81c, 0xEC1A0703,  BBREG_0x81c, 0xEB1C0703,  BBREG_0x81c,
	0xEA1E0703,  BBREG_0x81c, 0xC9200703,  BBREG_0x81c, 0xC8220703,
	BBREG_0x81c, 0xC7240703,  BBREG_0x81c, 0xC6260703,  BBREG_0x81c,
	0xC5280703,  BBREG_0x81c, 0xC42A0703,  BBREG_0x81c, 0xC32C0703,
	BBREG_0x81c, 0xC22E0703,  BBREG_0x81c, 0xC1300703,  BBREG_0x81c,
	0xC0320703,  BBREG_0x81c, 0xA3340703,  BBREG_0x81c, 0xA2360703,
	BBREG_0x81c, 0xA1380703,  BBREG_0x81c, 0xA03A0703,  BBREG_0x81c,
	0x823C0703,  BBREG_0x81c, 0x813E0703,  BBREG_0x81c, 0x80400703,
	BBREG_0x81c, 0x64420703,  BBREG_0x81c, 0x63440703,  BBREG_0x81c,
	0x62460703,  BBREG_0x81c, 0x61480703,  BBREG_0x81c, 0x604A0703,
	BBREG_0x81c, 0x414C0703,  BBREG_0x81c, 0x404E0703,  BBREG_0x81c,
	0x22500703,  BBREG_0x81c, 0x21520703,  BBREG_0x81c, 0x20540703,
	BBREG_0x81c, 0x03560703,  BBREG_0x81c, 0x02580703,  BBREG_0x81c,
	0x015A0703,  BBREG_0x81c, 0x005C0703,  BBREG_0x81c, 0x005E0703,
	BBREG_0x81c, 0x00600703,  BBREG_0x81c, 0x00620703,  BBREG_0x81c,
	0x00640703,  BBREG_0x81c, 0x00660703,  BBREG_0x81c, 0x00680703,
	BBREG_0x81c, 0x006A0703,  BBREG_0x81c, 0x006C0703,  BBREG_0x81c,
	0x006E0703,  BBREG_0x81c, 0x00700703,  BBREG_0x81c, 0x00720703,
	BBREG_0x81c, 0x00740703,  BBREG_0x81c, 0x00760703,  BBREG_0x81c,
	0x00780703,  BBREG_0x81c, 0x007A0703,  BBREG_0x81c, 0x007C0703,
	BBREG_0x81c, 0x007E0703,  BBREG_0x81c, 0x007E0703,  0x90000007,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c, 0xBE000703,
	BBREG_0x81c, 0xBD020703,  BBREG_0x81c, 0xBC040703,  BBREG_0x81c,
	0xBB060703,  BBREG_0x81c, 0xBA080703,  BBREG_0x81c, 0xB90A0703,
	BBREG_0x81c, 0xB80C0703,  BBREG_0x81c, 0xB70E0703,  BBREG_0x81c,
	0xB6100703,  BBREG_0x81c, 0xB5120703,  BBREG_0x81c, 0xB4140703,
	BBREG_0x81c, 0xB3160703,  BBREG_0x81c, 0xB2180703,  BBREG_0x81c,
	0xB11A0703,  BBREG_0x81c, 0xB01C0703,  BBREG_0x81c, 0xAF1E0703,
	BBREG_0x81c, 0xAE200703,  BBREG_0x81c, 0xAD220703,  BBREG_0x81c,
	0xAC240703,  BBREG_0x81c, 0x8E260703,  BBREG_0x81c, 0x8D280703,
	BBREG_0x81c, 0x8C2A0703,  BBREG_0x81c, 0x6F2C0703,  BBREG_0x81c,
	0x6E2E0703,  BBREG_0x81c, 0x6D300703,  BBREG_0x81c, 0x6C320703,
	BBREG_0x81c, 0x6B340703,  BBREG_0x81c, 0x6A360703,  BBREG_0x81c,
	0x69380703,  BBREG_0x81c, 0x683A0703,  BBREG_0x81c, 0x673C0703,
	BBREG_0x81c, 0x663E0703,  BBREG_0x81c, 0x65400703,  BBREG_0x81c,
	0x64420703,  BBREG_0x81c, 0x63440703,  BBREG_0x81c, 0x62460703,
	BBREG_0x81c, 0x61480703,  BBREG_0x81c, 0x604A0703,  BBREG_0x81c,
	0x424C0703,  BBREG_0x81c, 0x414E0703,  BBREG_0x81c, 0x40500703,
	BBREG_0x81c, 0x06520703,  BBREG_0x81c, 0x05540703,  BBREG_0x81c,
	0x04560703,  BBREG_0x81c, 0x03580703,  BBREG_0x81c, 0x025A0703,
	BBREG_0x81c, 0x015C0703,  BBREG_0x81c, 0x005E0703,  BBREG_0x81c,
	0x00600703,  BBREG_0x81c, 0x00620703,  BBREG_0x81c, 0x00640703,
	BBREG_0x81c, 0x00660703,  BBREG_0x81c, 0x00680703,  BBREG_0x81c,
	0x006A0703,  BBREG_0x81c, 0x006C0703,  BBREG_0x81c, 0x006E0703,
	BBREG_0x81c, 0x00700703,  BBREG_0x81c, 0x00720703,  BBREG_0x81c,
	0x00740703,  BBREG_0x81c, 0x00760703,  BBREG_0x81c, 0x00780703,
	BBREG_0x81c, 0x007A0703,  BBREG_0x81c, 0x007C0703,  BBREG_0x81c,
	0x007E0703,  BBREG_0x81c, 0x007E0703,  0x90000008,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x81c, 0xFB000703,  BBREG_0x81c,
	0xFA020703,  BBREG_0x81c, 0xF9040703,  BBREG_0x81c, 0xF8060703,
	BBREG_0x81c, 0xF7080703,  BBREG_0x81c, 0xF60A0703,  BBREG_0x81c,
	0xF50C0703,  BBREG_0x81c, 0xF40E0703,  BBREG_0x81c, 0xF3100703,
	BBREG_0x81c, 0xF2120703,  BBREG_0x81c, 0xF1140703,  BBREG_0x81c,
	0xF0160703,  BBREG_0x81c, 0xEF180703,  BBREG_0x81c, 0xEE1A0703,
	BBREG_0x81c, 0xED1C0703,  BBREG_0x81c, 0xEC1E0703,  BBREG_0x81c,
	0xEB200703,  BBREG_0x81c, 0xEA220703,  BBREG_0x81c, 0xE9240703,
	BBREG_0x81c, 0xE8260703,  BBREG_0x81c, 0xE7280703,  BBREG_0x81c,
	0xE62A0703,  BBREG_0x81c, 0xE52C0703,  BBREG_0x81c, 0xE42E0703,
	BBREG_0x81c, 0xE3300703,  BBREG_0x81c, 0xE2320703,  BBREG_0x81c,
	0xC6340703,  BBREG_0x81c, 0xC5360703,  BBREG_0x81c, 0xC4380703,
	BBREG_0x81c, 0xC33A0703,  BBREG_0x81c, 0xC23C0703,  BBREG_0x81c,
	0xC13E0703,  BBREG_0x81c, 0xA4400703,  BBREG_0x81c, 0xA3420703,
	BBREG_0x81c, 0xA2440703,  BBREG_0x81c, 0xA1460703,  BBREG_0x81c,
	0x83480703,  BBREG_0x81c, 0x824A0703,  BBREG_0x81c, 0x814C0703,
	BBREG_0x81c, 0x804E0703,  BBREG_0x81c, 0x63500703,  BBREG_0x81c,
	0x62520703,  BBREG_0x81c, 0x43540703,  BBREG_0x81c, 0x42560703,
	BBREG_0x81c, 0x41580703,  BBREG_0x81c, 0x235A0703,  BBREG_0x81c,
	0x225C0703,  BBREG_0x81c, 0x215E0703,  BBREG_0x81c, 0x20600703,
	BBREG_0x81c, 0x04620703,  BBREG_0x81c, 0x03640703,  BBREG_0x81c,
	0x02660703,  BBREG_0x81c, 0x01680703,  BBREG_0x81c, 0x006A0703,
	BBREG_0x81c, 0x006C0703,  BBREG_0x81c, 0x006E0703,  BBREG_0x81c,
	0x00700703,  BBREG_0x81c, 0x00720703,  BBREG_0x81c, 0x00740703,
	BBREG_0x81c, 0x00760703,  BBREG_0x81c, 0x00780703,  BBREG_0x81c,
	0x007A0703,  BBREG_0x81c, 0x007C0703,  BBREG_0x81c, 0x007E0703,
	BBREG_0x81c, 0x007E0703,  0x90000009,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x81c, 0xF8000703,  BBREG_0x81c, 0xF7020703,
	BBREG_0x81c, 0xF6040703,  BBREG_0x81c, 0xF5060703,  BBREG_0x81c,
	0xF4080703,  BBREG_0x81c, 0xF30A0703,  BBREG_0x81c, 0xF20C0703,
	BBREG_0x81c, 0xF10E0703,  BBREG_0x81c, 0xF0100703,  BBREG_0x81c,
	0xEF120703,  BBREG_0x81c, 0xEE140703,  BBREG_0x81c, 0xED160703,
	BBREG_0x81c, 0xEC180703,  BBREG_0x81c, 0xEB1A0703,  BBREG_0x81c,
	0xEA1C0703,  BBREG_0x81c, 0xE91E0703,  BBREG_0x81c, 0xCA200703,
	BBREG_0x81c, 0xC9220703,  BBREG_0x81c, 0xC8240703,  BBREG_0x81c,
	0xC7260703,  BBREG_0x81c, 0xC6280703,  BBREG_0x81c, 0xC52A0703,
	BBREG_0x81c, 0xC42C0703,  BBREG_0x81c, 0xC32E0703,  BBREG_0x81c,
	0xC2300703,  BBREG_0x81c, 0xC1320703,  BBREG_0x81c, 0xA3340703,
	BBREG_0x81c, 0xA2360703,  BBREG_0x81c, 0xA1380703,  BBREG_0x81c,
	0xA03A0703,  BBREG_0x81c, 0x823C0703,  BBREG_0x81c, 0x813E0703,
	BBREG_0x81c, 0x80400703,  BBREG_0x81c, 0x65420703,  BBREG_0x81c,
	0x64440703,  BBREG_0x81c, 0x63460703,  BBREG_0x81c, 0x62480703,
	BBREG_0x81c, 0x614A0703,  BBREG_0x81c, 0x424C0703,  BBREG_0x81c,
	0x414E0703,  BBREG_0x81c, 0x40500703,  BBREG_0x81c, 0x22520703,
	BBREG_0x81c, 0x21540703,  BBREG_0x81c, 0x20560703,  BBREG_0x81c,
	0x04580703,  BBREG_0x81c, 0x035A0703,  BBREG_0x81c, 0x025C0703,
	BBREG_0x81c, 0x015E0703,  BBREG_0x81c, 0x00600703,  BBREG_0x81c,
	0x00620703,  BBREG_0x81c, 0x00640703,  BBREG_0x81c, 0x00660703,
	BBREG_0x81c, 0x00680703,  BBREG_0x81c, 0x006A0703,  BBREG_0x81c,
	0x006C0703,  BBREG_0x81c, 0x006E0703,  BBREG_0x81c, 0x00700703,
	BBREG_0x81c, 0x00720703,  BBREG_0x81c, 0x00740703,  BBREG_0x81c,
	0x00760703,  BBREG_0x81c, 0x00780703,  BBREG_0x81c, 0x007A0703,
	BBREG_0x81c, 0x007C0703,  BBREG_0x81c, 0x007E0703,  BBREG_0x81c,
	0x007E0703,  0x9000000a,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x81c, 0xFC000703,  BBREG_0x81c, 0xFB020703,  BBREG_0x81c,
	0xFA040703,  BBREG_0x81c, 0xF9060703,  BBREG_0x81c, 0xF8080703,
	BBREG_0x81c, 0xF70A0703,  BBREG_0x81c, 0xF60C0703,  BBREG_0x81c,
	0xF50E0703,  BBREG_0x81c, 0xF4100703,  BBREG_0x81c, 0xF3120703,
	BBREG_0x81c, 0xF2140703,  BBREG_0x81c, 0xF1160703,  BBREG_0x81c,
	0xEF180703,  BBREG_0x81c, 0xEE1A0703,  BBREG_0x81c, 0xED1C0703,
	BBREG_0x81c, 0xEC1E0703,  BBREG_0x81c, 0xEB200703,  BBREG_0x81c,
	0xEA220703,  BBREG_0x81c, 0xE9240703,  BBREG_0x81c, 0xE8260703,
	BBREG_0x81c, 0xE7280703,  BBREG_0x81c, 0xE62A0703,  BBREG_0x81c,
	0xE52C0703,  BBREG_0x81c, 0xE42E0703,  BBREG_0x81c, 0xE3300703,
	BBREG_0x81c, 0xE2320703,  BBREG_0x81c, 0xC6340703,  BBREG_0x81c,
	0xC5360703,  BBREG_0x81c, 0xC4380703,  BBREG_0x81c, 0xC33A0703,
	BBREG_0x81c, 0xA63C0703,  BBREG_0x81c, 0xA53E0703,  BBREG_0x81c,
	0xA4400703,  BBREG_0x81c, 0xA3420703,  BBREG_0x81c, 0xA2440703,
	BBREG_0x81c, 0xA1460703,  BBREG_0x81c, 0x83480703,  BBREG_0x81c,
	0x824A0703,  BBREG_0x81c, 0x814C0703,  BBREG_0x81c, 0x804E0703,
	BBREG_0x81c, 0x63500703,  BBREG_0x81c, 0x62520703,  BBREG_0x81c,
	0x61540703,  BBREG_0x81c, 0x42560703,  BBREG_0x81c, 0x41580703,
	BBREG_0x81c, 0x405A0703,  BBREG_0x81c, 0x225C0703,  BBREG_0x81c,
	0x215E0703,  BBREG_0x81c, 0x20600703,  BBREG_0x81c, 0x04620703,
	BBREG_0x81c, 0x03640703,  BBREG_0x81c, 0x02660703,  BBREG_0x81c,
	0x01680703,  BBREG_0x81c, 0x006A0703,  BBREG_0x81c, 0x006C0703,
	BBREG_0x81c, 0x006E0703,  BBREG_0x81c, 0x00700703,  BBREG_0x81c,
	0x00720703,  BBREG_0x81c, 0x00740703,  BBREG_0x81c, 0x00760703,
	BBREG_0x81c, 0x00780703,  BBREG_0x81c, 0x007A0703,  BBREG_0x81c,
	0x007C0703,  BBREG_0x81c, 0x007E0703,  BBREG_0x81c, 0x007E0703,
	0x9000000b,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c,
	0xF8000703,  BBREG_0x81c, 0xF7020703,  BBREG_0x81c, 0xF6040703,
	BBREG_0x81c, 0xF5060703,  BBREG_0x81c, 0xF4080703,  BBREG_0x81c,
	0xF30A0703,  BBREG_0x81c, 0xF20C0703,  BBREG_0x81c, 0xF10E0703,
	BBREG_0x81c, 0xF0100703,  BBREG_0x81c, 0xEF120703,  BBREG_0x81c,
	0xEE140703,  BBREG_0x81c, 0xED160703,  BBREG_0x81c, 0xEC180703,
	BBREG_0x81c, 0xEB1A0703,  BBREG_0x81c, 0xEA1C0703,  BBREG_0x81c,
	0xE91E0703,  BBREG_0x81c, 0xCA200703,  BBREG_0x81c, 0xC9220703,
	BBREG_0x81c, 0xC8240703,  BBREG_0x81c, 0xC7260703,  BBREG_0x81c,
	0xC6280703,  BBREG_0x81c, 0xC52A0703,  BBREG_0x81c, 0xC42C0703,
	BBREG_0x81c, 0xC32E0703,  BBREG_0x81c, 0xC2300703,  BBREG_0x81c,
	0xC1320703,  BBREG_0x81c, 0xA3340703,  BBREG_0x81c, 0xA2360703,
	BBREG_0x81c, 0xA1380703,  BBREG_0x81c, 0xA03A0703,  BBREG_0x81c,
	0x823C0703,  BBREG_0x81c, 0x813E0703,  BBREG_0x81c, 0x80400703,
	BBREG_0x81c, 0x64420703,  BBREG_0x81c, 0x63440703,  BBREG_0x81c,
	0x62460703,  BBREG_0x81c, 0x61480703,  BBREG_0x81c, 0x604A0703,
	BBREG_0x81c, 0x234C0703,  BBREG_0x81c, 0x224E0703,  BBREG_0x81c,
	0x21500703,  BBREG_0x81c, 0x20520703,  BBREG_0x81c, 0x06540703,
	BBREG_0x81c, 0x05560703,  BBREG_0x81c, 0x04580703,  BBREG_0x81c,
	0x035A0703,  BBREG_0x81c, 0x025C0703,  BBREG_0x81c, 0x015E0703,
	BBREG_0x81c, 0x00600703,  BBREG_0x81c, 0x00620703,  BBREG_0x81c,
	0x00640703,  BBREG_0x81c, 0x00660703,  BBREG_0x81c, 0x00680703,
	BBREG_0x81c, 0x006A0703,  BBREG_0x81c, 0x006C0703,  BBREG_0x81c,
	0x006E0703,  BBREG_0x81c, 0x00700703,  BBREG_0x81c, 0x00720703,
	BBREG_0x81c, 0x00740703,  BBREG_0x81c, 0x00760703,  BBREG_0x81c,
	0x00780703,  BBREG_0x81c, 0x007A0703,  BBREG_0x81c, 0x007C0703,
	BBREG_0x81c, 0x007E0703,  BBREG_0x81c, 0x007E0703,  0x9000000c,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c, 0xFC000703,
	BBREG_0x81c, 0xFB020703,  BBREG_0x81c, 0xFA040703,  BBREG_0x81c,
	0xF9060703,  BBREG_0x81c, 0xF8080703,  BBREG_0x81c, 0xF70A0703,
	BBREG_0x81c, 0xF60C0703,  BBREG_0x81c, 0xF50E0703,  BBREG_0x81c,
	0xF4100703,  BBREG_0x81c, 0xF3120703,  BBREG_0x81c, 0xF2140703,
	BBREG_0x81c, 0xF1160703,  BBREG_0x81c, 0xF0180703,  BBREG_0x81c,
	0xEF1A0703,  BBREG_0x81c, 0xEE1C0703,  BBREG_0x81c, 0xED1E0703,
	BBREG_0x81c, 0xEC200703,  BBREG_0x81c, 0xEB220703,  BBREG_0x81c,
	0xEA240703,  BBREG_0x81c, 0xE9260703,  BBREG_0x81c, 0xE8280703,
	BBREG_0x81c, 0xE72A0703,  BBREG_0x81c, 0xE62C0703,  BBREG_0x81c,
	0xE52E0703,  BBREG_0x81c, 0xE4300703,  BBREG_0x81c, 0xE3320703,
	BBREG_0x81c, 0xE2340703,  BBREG_0x81c, 0xC6360703,  BBREG_0x81c,
	0xC5380703,  BBREG_0x81c, 0xC43A0703,  BBREG_0x81c, 0xC33C0703,
	BBREG_0x81c, 0xA63E0703,  BBREG_0x81c, 0xA5400703,  BBREG_0x81c,
	0xA4420703,  BBREG_0x81c, 0xA3440703,  BBREG_0x81c, 0xA2460703,
	BBREG_0x81c, 0x84480703,  BBREG_0x81c, 0x834A0703,  BBREG_0x81c,
	0x824C0703,  BBREG_0x81c, 0x814E0703,  BBREG_0x81c, 0x80500703,
	BBREG_0x81c, 0x63520703,  BBREG_0x81c, 0x62540703,  BBREG_0x81c,
	0x61560703,  BBREG_0x81c, 0x60580703,  BBREG_0x81c, 0x225A0703,
	BBREG_0x81c, 0x055C0703,  BBREG_0x81c, 0x045E0703,  BBREG_0x81c,
	0x03600703,  BBREG_0x81c, 0x02620703,  BBREG_0x81c, 0x01640703,
	BBREG_0x81c, 0x00660703,  BBREG_0x81c, 0x00680703,  BBREG_0x81c,
	0x006A0703,  BBREG_0x81c, 0x006C0703,  BBREG_0x81c, 0x006E0703,
	BBREG_0x81c, 0x00700703,  BBREG_0x81c, 0x00720703,  BBREG_0x81c,
	0x00740703,  BBREG_0x81c, 0x00760703,  BBREG_0x81c, 0x00780703,
	BBREG_0x81c, 0x007A0703,  BBREG_0x81c, 0x007C0703,  BBREG_0x81c,
	0x007E0703,  BBREG_0x81c, 0x007E0703,  0x9000000d,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x81c, 0xFB000703,  BBREG_0x81c,
	0xFA020703,  BBREG_0x81c, 0xF9040703,  BBREG_0x81c, 0xF8060703,
	BBREG_0x81c, 0xF7080703,  BBREG_0x81c, 0xF60A0703,  BBREG_0x81c,
	0xF50C0703,  BBREG_0x81c, 0xF40E0703,  BBREG_0x81c, 0xF3100703,
	BBREG_0x81c, 0xF2120703,  BBREG_0x81c, 0xF1140703,  BBREG_0x81c,
	0xEF160703,  BBREG_0x81c, 0xEE180703,  BBREG_0x81c, 0xED1A0703,
	BBREG_0x81c, 0xEC1C0703,  BBREG_0x81c, 0xEB1E0703,  BBREG_0x81c,
	0xEA200703,  BBREG_0x81c, 0xE9220703,  BBREG_0x81c, 0xE8240703,
	BBREG_0x81c, 0xE7260703,  BBREG_0x81c, 0xE6280703,  BBREG_0x81c,
	0xE52A0703,  BBREG_0x81c, 0xE42C0703,  BBREG_0x81c, 0xE32E0703,
	BBREG_0x81c, 0xE2300703,  BBREG_0x81c, 0xE1320703,  BBREG_0x81c,
	0xC6340703,  BBREG_0x81c, 0xC5360703,  BBREG_0x81c, 0xC4380703,
	BBREG_0x81c, 0xC33A0703,  BBREG_0x81c, 0xA63C0703,  BBREG_0x81c,
	0xA53E0703,  BBREG_0x81c, 0xA4400703,  BBREG_0x81c, 0xA3420703,
	BBREG_0x81c, 0xA2440703,  BBREG_0x81c, 0xA1460703,  BBREG_0x81c,
	0x83480703,  BBREG_0x81c, 0x824A0703,  BBREG_0x81c, 0x814C0703,
	BBREG_0x81c, 0x804E0703,  BBREG_0x81c, 0x63500703,  BBREG_0x81c,
	0x62520703,  BBREG_0x81c, 0x61540703,  BBREG_0x81c, 0x42560703,
	BBREG_0x81c, 0x41580703,  BBREG_0x81c, 0x405A0703,  BBREG_0x81c,
	0x225C0703,  BBREG_0x81c, 0x215E0703,  BBREG_0x81c, 0x20600703,
	BBREG_0x81c, 0x04620703,  BBREG_0x81c, 0x03640703,  BBREG_0x81c,
	0x02660703,  BBREG_0x81c, 0x01680703,  BBREG_0x81c, 0x006A0703,
	BBREG_0x81c, 0x006C0703,  BBREG_0x81c, 0x006E0703,  BBREG_0x81c,
	0x00700703,  BBREG_0x81c, 0x00720703,  BBREG_0x81c, 0x00740703,
	BBREG_0x81c, 0x00760703,  BBREG_0x81c, 0x00780703,  BBREG_0x81c,
	0x007A0703,  BBREG_0x81c, 0x007C0703,  BBREG_0x81c, 0x007E0703,
	BBREG_0x81c, 0x007E0703,  0x9000000e,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x81c, 0xFB000703,  BBREG_0x81c, 0xFA020703,
	BBREG_0x81c, 0xF9040703,  BBREG_0x81c, 0xF8060703,  BBREG_0x81c,
	0xF7080703,  BBREG_0x81c, 0xF60A0703,  BBREG_0x81c, 0xF50C0703,
	BBREG_0x81c, 0xF40E0703,  BBREG_0x81c, 0xF3100703,  BBREG_0x81c,
	0xF2120703,  BBREG_0x81c, 0xF1140703,  BBREG_0x81c, 0xEF160703,
	BBREG_0x81c, 0xEE180703,  BBREG_0x81c, 0xED1A0703,  BBREG_0x81c,
	0xEC1C0703,  BBREG_0x81c, 0xEB1E0703,  BBREG_0x81c, 0xEA200703,
	BBREG_0x81c, 0xE9220703,  BBREG_0x81c, 0xE8240703,  BBREG_0x81c,
	0xE7260703,  BBREG_0x81c, 0xE6280703,  BBREG_0x81c, 0xE52A0703,
	BBREG_0x81c, 0xE42C0703,  BBREG_0x81c, 0xE32E0703,  BBREG_0x81c,
	0xE2300703,  BBREG_0x81c, 0xE1320703,  BBREG_0x81c, 0xC6340703,
	BBREG_0x81c, 0xC5360703,  BBREG_0x81c, 0xC4380703,  BBREG_0x81c,
	0xC33A0703,  BBREG_0x81c, 0xA63C0703,  BBREG_0x81c, 0xA53E0703,
	BBREG_0x81c, 0xA4400703,  BBREG_0x81c, 0xA3420703,  BBREG_0x81c,
	0xA2440703,  BBREG_0x81c, 0xA1460703,  BBREG_0x81c, 0x83480703,
	BBREG_0x81c, 0x824A0703,  BBREG_0x81c, 0x814C0703,  BBREG_0x81c,
	0x804E0703,  BBREG_0x81c, 0x63500703,  BBREG_0x81c, 0x62520703,
	BBREG_0x81c, 0x61540703,  BBREG_0x81c, 0x42560703,  BBREG_0x81c,
	0x41580703,  BBREG_0x81c, 0x405A0703,  BBREG_0x81c, 0x225C0703,
	BBREG_0x81c, 0x215E0703,  BBREG_0x81c, 0x20600703,  BBREG_0x81c,
	0x04620703,  BBREG_0x81c, 0x03640703,  BBREG_0x81c, 0x02660703,
	BBREG_0x81c, 0x01680703,  BBREG_0x81c, 0x006A0703,  BBREG_0x81c,
	0x006C0703,  BBREG_0x81c, 0x006E0703,  BBREG_0x81c, 0x00700703,
	BBREG_0x81c, 0x00720703,  BBREG_0x81c, 0x00740703,  BBREG_0x81c,
	0x00760703,  BBREG_0x81c, 0x00780703,  BBREG_0x81c, 0x007A0703,
	BBREG_0x81c, 0x007C0703,  BBREG_0x81c, 0x007E0703,  BBREG_0x81c,
	0x007E0703,  0x9000000f,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x81c, 0xBF000703,  BBREG_0x81c, 0xBF020703,  BBREG_0x81c,
	0xBF040703,  BBREG_0x81c, 0xBF060703,  BBREG_0x81c, 0xBF080703,
	BBREG_0x81c, 0xBE0A0703,  BBREG_0x81c, 0xBD0C0703,  BBREG_0x81c,
	0xBC0E0703,  BBREG_0x81c, 0xBB100703,  BBREG_0x81c, 0xBA120703,
	BBREG_0x81c, 0xB9140703,  BBREG_0x81c, 0xB8160703,  BBREG_0x81c,
	0xB7180703,  BBREG_0x81c, 0xB61A0703,  BBREG_0x81c, 0xB51C0703,
	BBREG_0x81c, 0xB41E0703,  BBREG_0x81c, 0xB1200703,  BBREG_0x81c,
	0xB2220703,  BBREG_0x81c, 0xB1240703,  BBREG_0x81c, 0xB0260703,
	BBREG_0x81c, 0xAF280703,  BBREG_0x81c, 0xAE2A0703,  BBREG_0x81c,
	0xAD2C0703,  BBREG_0x81c, 0xAC2E0703,  BBREG_0x81c, 0xAB300703,
	BBREG_0x81c, 0xAA320703,  BBREG_0x81c, 0xC6340703,  BBREG_0x81c,
	0xC5360703,  BBREG_0x81c, 0xC4380703,  BBREG_0x81c, 0xC33A0703,
	BBREG_0x81c, 0x883C0703,  BBREG_0x81c, 0x873E0703,  BBREG_0x81c,
	0x86400703,  BBREG_0x81c, 0x85420703,  BBREG_0x81c, 0x84440703,
	BBREG_0x81c, 0x83460703,  BBREG_0x81c, 0x67480703,  BBREG_0x81c,
	0x664A0703,  BBREG_0x81c, 0x654C0703,  BBREG_0x81c, 0x644E0703,
	BBREG_0x81c, 0x27500703,  BBREG_0x81c, 0x26520703,  BBREG_0x81c,
	0x25540703,  BBREG_0x81c, 0x24560703,  BBREG_0x81c, 0x23580703,
	BBREG_0x81c, 0x225A0703,  BBREG_0x81c, 0x215C0703,  BBREG_0x81c,
	0x205E0703,  BBREG_0x81c, 0x03600703,  BBREG_0x81c, 0x02620703,
	BBREG_0x81c, 0x01640703,  BBREG_0x81c, 0x00660703,  BBREG_0x81c,
	0x00680703,  BBREG_0x81c, 0x006A0703,  BBREG_0x81c, 0x006C0703,
	BBREG_0x81c, 0x006E0703,  BBREG_0x81c, 0x00700703,  BBREG_0x81c,
	0x00720703,  BBREG_0x81c, 0x00740703,  BBREG_0x81c, 0x00760703,
	BBREG_0x81c, 0x00780703,  BBREG_0x81c, 0x007A0703,  BBREG_0x81c,
	0x007C0703,  BBREG_0x81c, 0x007E0703,  BBREG_0x81c, 0x007E0703,
	0x90000010,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x81c,
	0xFC000403,  BBREG_0x81c, 0xFB000703,  BBREG_0x81c, 0xFA020703,
	BBREG_0x81c, 0xF9040703,  BBREG_0x81c, 0xF8060703,  BBREG_0x81c,
	0xF7080703,  BBREG_0x81c, 0xF60A0703,  BBREG_0x81c, 0xF50C0703,
	BBREG_0x81c, 0xF40E0703,  BBREG_0x81c, 0xF3100703,  BBREG_0x81c,
	0xF2120703,  BBREG_0x81c, 0xF1140703,  BBREG_0x81c, 0xF0160703,
	BBREG_0x81c, 0xEF180703,  BBREG_0x81c, 0xEE1A0703,  BBREG_0x81c,
	0xED1C0703,  BBREG_0x81c, 0xEC1E0703,  BBREG_0x81c, 0xEB200703,
	BBREG_0x81c, 0xEA220703,  BBREG_0x81c, 0xE9240703,  BBREG_0x81c,
	0xE8260703,  BBREG_0x81c, 0xE7280703,  BBREG_0x81c, 0xE62A0703,
	BBREG_0x81c, 0xE52C0703,  BBREG_0x81c, 0xE42E0703,  BBREG_0x81c,
	0xE3300703,  BBREG_0x81c, 0xE2320703,  BBREG_0x81c, 0xC6340703,
	BBREG_0x81c, 0xC5360703,  BBREG_0x81c, 0xC4380703,  BBREG_0x81c,
	0xC33A0703,  BBREG_0x81c, 0xA63C0703,  BBREG_0x81c, 0xA53E0703,
	BBREG_0x81c, 0xA4400703,  BBREG_0x81c, 0xA3420703,  BBREG_0x81c,
	0xA2440703,  BBREG_0x81c, 0x84460703,  BBREG_0x81c, 0x83480703,
	BBREG_0x81c, 0x824A0703,  BBREG_0x81c, 0x814C0703,  BBREG_0x81c,
	0x804E0703,  BBREG_0x81c, 0x63500703,  BBREG_0x81c, 0x62520703,
	BBREG_0x81c, 0x61540703,  BBREG_0x81c, 0x60560703,  BBREG_0x81c,
	0x22580703,  BBREG_0x81c, 0x055A0703,  BBREG_0x81c, 0x045C0703,
	BBREG_0x81c, 0x035E0703,  BBREG_0x81c, 0x02600703,  BBREG_0x81c,
	0x01620703,  BBREG_0x81c, 0x00640703,  BBREG_0x81c, 0x00660703,
	BBREG_0x81c, 0x00680703,  BBREG_0x81c, 0x006A0703,  BBREG_0x81c,
	0x006C0703,  BBREG_0x81c, 0x006E0703,  BBREG_0x81c, 0x00700703,
	BBREG_0x81c, 0x00720703,  BBREG_0x81c, 0x00740703,  BBREG_0x81c,
	0x00760703,  BBREG_0x81c, 0x00780703,  BBREG_0x81c, 0x007A0703,
	BBREG_0x81c, 0x007C0703,  BBREG_0x81c, 0x007E0703,  0xA0000000,
	0x00000000,  BBREG_0x81c, 0xFC000703,  BBREG_0x81c, 0xFB020703,
	BBREG_0x81c, 0xFA040703,  BBREG_0x81c, 0xF9060703,  BBREG_0x81c,
	0xF8080703,  BBREG_0x81c, 0xF70A0703,  BBREG_0x81c, 0xF60C0703,
	BBREG_0x81c, 0xF50E0703,  BBREG_0x81c, 0xF4100703,  BBREG_0x81c,
	0xF3120703,  BBREG_0x81c, 0xF2140703,  BBREG_0x81c, 0xF1160703,
	BBREG_0x81c, 0xF0180703,  BBREG_0x81c, 0xEF1A0703,  BBREG_0x81c,
	0xEE1C0703,  BBREG_0x81c, 0xED1E0703,  BBREG_0x81c, 0xEC200703,
	BBREG_0x81c, 0xEB220703,  BBREG_0x81c, 0xEA240703,  BBREG_0x81c,
	0xE9260703,  BBREG_0x81c, 0xE8280703,  BBREG_0x81c, 0xE72A0703,
	BBREG_0x81c, 0xE62C0703,  BBREG_0x81c, 0xE52E0703,  BBREG_0x81c,
	0xE4300703,  BBREG_0x81c, 0xE3320703,  BBREG_0x81c, 0xE2340703,
	BBREG_0x81c, 0xC6360703,  BBREG_0x81c, 0xC5380703,  BBREG_0x81c,
	0xC43A0703,  BBREG_0x81c, 0xC33C0703,  BBREG_0x81c, 0xA63E0703,
	BBREG_0x81c, 0xA5400703,  BBREG_0x81c, 0xA4420703,  BBREG_0x81c,
	0xA3440703,  BBREG_0x81c, 0xA2460703,  BBREG_0x81c, 0x84480703,
	BBREG_0x81c, 0x834A0703,  BBREG_0x81c, 0x824C0703,  BBREG_0x81c,
	0x814E0703,  BBREG_0x81c, 0x80500703,  BBREG_0x81c, 0x63520703,
	BBREG_0x81c, 0x62540703,  BBREG_0x81c, 0x61560703,  BBREG_0x81c,
	0x60580703,  BBREG_0x81c, 0x235A0703,  BBREG_0x81c, 0x225C0703,
	BBREG_0x81c, 0x215E0703,  BBREG_0x81c, 0x20600703,  BBREG_0x81c,
	0x03620703,  BBREG_0x81c, 0x02640703,  BBREG_0x81c, 0x01660703,
	BBREG_0x81c, 0x00680703,  BBREG_0x81c, 0x006A0703,  BBREG_0x81c,
	0x006C0703,  BBREG_0x81c, 0x006E0703,  BBREG_0x81c, 0x00700703,
	BBREG_0x81c, 0x00720703,  BBREG_0x81c, 0x00740703,  BBREG_0x81c,
	0x00760703,  BBREG_0x81c, 0x00780703,  BBREG_0x81c, 0x007A0703,
	BBREG_0x81c, 0x007C0703,  BBREG_0x81c, 0x007E0703,  BBREG_0x81c,
	0x007E0703,  0xB0000000,  0x00000000,  0x80000000,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0xc50, 0x00000022,  BBREG_0xc50,
	0x00000020,  BBREG_0xe50, 0x00000022,  BBREG_0xe50, 0x00000020,
	0x9000000d,  0x00000000,  0x40000000,  0x00000000,  BBREG_0xc50,
	0x00000022,  BBREG_0xc50, 0x00000020,  BBREG_0xe50, 0x00000022,
	BBREG_0xe50, 0x00000020,  0x9000000e,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0xc50, 0x00000022,  BBREG_0xc50, 0x00000020,
	BBREG_0xe50, 0x00000022,  BBREG_0xe50, 0x00000020,  0xA0000000,
	0x00000000,  BBREG_0xc50, 0x00000022,  BBREG_0xc50, 0x00000020,
	BBREG_0xe50, 0x00000022,  BBREG_0xe50, 0x00000020,  0xB0000000,
	0x00000000,

};

void odm_read_and_config_mp_8822b_agc_tab(struct PHY_DM_STRUCT *p_dm_odm)
{
	u32 i = 0;
	u8 c_cond;
	boolean is_matched = true, is_skipped = false;
	u32 array_len = sizeof(array_mp_8822b_agc_tab) / sizeof(u32);
	u32 *array = array_mp_8822b_agc_tab;

	u32 v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> odm_read_and_config_mp_8822b_agc_tab\n"));

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 &
		    (BIT(31) | BIT(30))) { /*positive & negative condition*/
			if (v1 & BIT(31)) { /* positive condition*/
				c_cond = (u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) { /*end*/
					is_matched = true;
					is_skipped = false;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT,
						     ODM_DBG_LOUD, ("ENDIF\n"));
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT,
						     ODM_DBG_LOUD, ("ELSE\n"));
				} else { /*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT,
						     ODM_DBG_LOUD,
						     ("IF or ELSE IF\n"));
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (is_skipped == false) {
					if (check_positive(p_dm_odm, pre_v1,
							   pre_v2, v1, v2)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else
					is_matched = false;
			}
		} else {
			if (is_matched)
				odm_config_bb_agc_8822b(p_dm_odm, v1, MASKDWORD,
							v2);
		}
		i = i + 2;
	}
}

u32 odm_get_version_mp_8822b_agc_tab(void) { return 100; }

/******************************************************************************
*                           phy_reg.TXT
******************************************************************************/

u32 array_mp_8822b_phy_reg[] = {
	BBREG_0x800, 0x9020D010,  BBREG_0x804, 0x800181A0,  BBREG_0x808,
	0x0E028233,  BBREG_0x80c, 0x10000013,  BBREG_0x810, 0x22101243,
	BBREG_0x814, 0x020C3D11,  BBREG_0x818, 0x84A10385,  BBREG_0x81c,
	0x1E1E081F,  BBREG_0x820, 0x0001AAAA,  BBREG_0x824, 0x00030FE0,
	BBREG_0x828, 0x0000CCCC,  BBREG_0x82c, 0x75CB7010,  BBREG_0x830,
	0x79A0EAAA,  BBREG_0x834, 0x072E6986,  BBREG_0x838, 0x87766441,
	BBREG_0x83c, 0x9194B2B7,  BBREG_0x840, 0x171750E0,  BBREG_0x844,
	0x4D3D7CDB,  BBREG_0x848, 0x4AD0408B,  BBREG_0x84c, 0x6AFBF7A5,
	BBREG_0x850, 0x28A74706,  BBREG_0x854, 0x0001520C,  BBREG_0x858,
	0x4060C000,  BBREG_0x85c, 0x74010160,  BBREG_0x860, 0x68A7C321,
	BBREG_0x864, 0x79F27432,  BBREG_0x868, 0x8CA7A314,  BBREG_0x86c,
	0x778C2878,  BBREG_0x870, 0x77777777,  BBREG_0x874, 0x27612C2E,
	BBREG_0x878, 0xC0003152,  BBREG_0x87c, 0x5C8FC000,  BBREG_0x880,
	0x00000000,  BBREG_0x884, 0x00000000,  BBREG_0x888, 0x00000000,
	BBREG_0x88c, 0x00000000,  BBREG_0x890, 0x00000000,  BBREG_0x894,
	0x00000000,  BBREG_0x898, 0x00000000,  BBREG_0x89c, 0x00000000,
	BBREG_0x8a0, 0x00000013,  BBREG_0x8a4, 0x7F7F7F7F,  BBREG_0x8a8,
	0x2202033E,  BBREG_0x8ac, 0xF00F000A,  BBREG_0x8b0, 0x00000600,
	BBREG_0x8b4, 0x000FC080,  BBREG_0x8b8, 0xEC0057F7,  BBREG_0x8bc,
	0xACB520A3,  BBREG_0x8c0, 0xFFE04020,  BBREG_0x8c4, 0x47C00000,
	BBREG_0x8c8, 0x000251A5,  BBREG_0x8cc, 0x08108492,  BBREG_0x8d0,
	0x0000B800,  BBREG_0x8d4, 0x860308A0,  BBREG_0x8d8, 0x29095612,
	BBREG_0x8dc, 0x00000000,  BBREG_0x8e0, 0x32D16777,  BBREG_0x8e4,
	0x4C098935,  BBREG_0x8e8, 0xFFFFC42C,  BBREG_0x8ec, 0x99999999,
	BBREG_0x8f0, 0x00009999,  BBREG_0x8f4, 0x00D80FA1,  BBREG_0x8f8,
	0x40000080,  BBREG_0x8fc, 0x00000130,  BBREG_0x900, 0x00800000,
	BBREG_0x904, 0x00000000,  BBREG_0x908, 0x00000000,  BBREG_0x90c,
	0xD3000000,  BBREG_0x910, 0x0000FC00,  BBREG_0x914, 0xC6380000,
	BBREG_0x918, 0x1C1028C0,  BBREG_0x91c, 0x64B11A1C,  BBREG_0x920,
	0xE0767233,  BBREG_0x924, 0x855A2500,  BBREG_0x928, 0x4AB0E4E4,
	BBREG_0x92c, 0xFFFEB200,  BBREG_0x930, 0xFFFFFFFE,  BBREG_0x934,
	0x001FFFFF,  BBREG_0x938, 0x00008480,  BBREG_0x93c, 0xE41C0642,
	BBREG_0x940, 0x0E470430,  BBREG_0x944, 0x00000000,  BBREG_0x948,
	0xAC000000,  BBREG_0x94c, 0x10000083,  BBREG_0x950, 0x32010080,
	BBREG_0x954, 0x84510080,  BBREG_0x958, 0x00000001,  BBREG_0x95c,
	0x04248000,  BBREG_0x960, 0x00000000,  BBREG_0x964, 0x00000000,
	BBREG_0x968, 0x00000000,  BBREG_0x96c, 0x00000000,  BBREG_0x970,
	0x00001FFF,  BBREG_0x974, 0x44000FFF,  BBREG_0x978, 0x00000000,
	BBREG_0x97c, 0x00000000,  BBREG_0x980, 0x00000000,  BBREG_0x984,
	0x00000000,  BBREG_0x988, 0x00000000,  BBREG_0x98c, 0x43440000,
	BBREG_0x990, 0x27100000,  BBREG_0x994, 0xFFFF0100,  BBREG_0x998,
	0xFFFFFF5C,  BBREG_0x99c, 0xFFFFFFFF,  BBREG_0x9a0, 0x000000FF,
	BBREG_0x9a4, 0x80000088,  BBREG_0x9a8, 0x0C2F0000,  BBREG_0x9ac,
	0x01560000,  BBREG_0x9b0, 0x70000000,  BBREG_0x9b4, 0x00000000,
	BBREG_0x9b8, 0x00000000,  BBREG_0x9bc, 0x00000000,  BBREG_0x9c0,
	0x00000000,  BBREG_0x9c4, 0x00000000,  BBREG_0x9c8, 0x00000000,
	BBREG_0x9cc, 0x00000000,  BBREG_0x9d0, 0x00000000,  BBREG_0x9d4,
	0x00000000,  BBREG_0x9d8, 0x00000000,  BBREG_0x9dc, 0x00000000,
	BBREG_0x9e0, 0x00000000,  BBREG_0x9e4, 0x02000402,  BBREG_0x9e8,
	0x000022D4,  BBREG_0x9ec, 0x00000000,  BBREG_0x9f0, 0x00010080,
	BBREG_0x9f4, 0x00000000,  BBREG_0x9f8, 0x00000000,  BBREG_0x9fc,
	0xEFFFF7F7,  BBREG_0xa00, 0x00D047C8,  BBREG_0xa04, 0x81FF800C,
	BBREG_0xa08, 0x8C838300,  BBREG_0xa0c, 0x2E20100F,  BBREG_0xa10,
	0x9500BB78,  BBREG_0xa14, 0x1114D028,  BBREG_0xa18, 0x00881117,
	BBREG_0xa1c, 0x89140F00,  BBREG_0xa20, 0x84880000,  BBREG_0xa24,
	0x384F6577,  BBREG_0xa28, 0x00001525,  BBREG_0xa2c, 0x00920000,
	BBREG_0xa70, 0x101FFF00,  BBREG_0xa74, 0x00000148,  BBREG_0xa78,
	0x00000900,  BBREG_0xa7c, 0x225B0606,  BBREG_0xa80, 0x218675B2,
	BBREG_0xa84, 0x80208C00,  BBREG_0xa88, 0x040C0000,  BBREG_0xa8c,
	0x12345678,  BBREG_0xa90, 0xABCDEF00,  BBREG_0xa94, 0x001B1B89,
	BBREG_0xa98, 0x030A0000,  BBREG_0xa9c, 0x00060000,  BBREG_0xaa0,
	0x00000000,  BBREG_0xaa4, 0x0004000F,  BBREG_0xaa8, 0x00000200,
	BBREG_0xb00, 0xE1000440,  BBREG_0xb04, 0x00800000,  BBREG_0xb08,
	0xFF02030B,  BBREG_0xb0c, 0x01EAA406,  BBREG_0xb10, 0x00030690,
	BBREG_0xb14, 0x006000FA,  BBREG_0xb18, 0x00000002,  BBREG_0xb1c,
	0x00000002,  BBREG_0xb20, 0x4B00001F,  BBREG_0xb24, 0x4E8E3E40,
	BBREG_0xb28, 0x03020100,  BBREG_0xb2c, 0x07060504,  BBREG_0xb30,
	0x0B0A0908,  BBREG_0xb34, 0x0F0E0D0C,  BBREG_0xb38, 0x13121110,
	BBREG_0xb3c, 0x0000003A,  BBREG_0xb40, 0x00000000,  BBREG_0xb44,
	0x80000000,  BBREG_0xb48, 0x3F0000FA,  BBREG_0xb4c, 0x88C80020,
	BBREG_0xb50, 0x00000000,  BBREG_0xb54, 0x00004241,  BBREG_0xb58,
	0xE0008208,  BBREG_0xb5c, 0x41EFFFF9,  BBREG_0xb60, 0x00000000,
	BBREG_0xb64, 0x00200063,  BBREG_0xb68, 0x0000003A,  BBREG_0xb6c,
	0x00000102,  BBREG_0xb70, 0x4E6D1870,  BBREG_0xb74, 0x03020100,
	BBREG_0xb78, 0x07060504,  BBREG_0xb7c, 0x0B0A0908,  BBREG_0xb80,
	0x0F0E0D0C,  BBREG_0xb84, 0x13121110,  BBREG_0xb88, 0x00000000,
	BBREG_0xb8c, 0x00000000,  BBREG_0xc00, 0x00000007,  BBREG_0xc04,
	0x00000020,  BBREG_0xc08, 0x60403231,  BBREG_0xc0c, 0x00012345,
	BBREG_0xc10, 0x00000100,  BBREG_0xc14, 0x01000000,  BBREG_0xc18,
	0x00000000,  BBREG_0xc1c, 0x40040053,  BBREG_0xc20, 0x40020103,
	BBREG_0xc24, 0x00000000,  BBREG_0xc28, 0x00000000,  BBREG_0xc2c,
	0x00000000,  BBREG_0xc30, 0x00000000,  BBREG_0xc34, 0x00000000,
	BBREG_0xc38, 0x00000000,  BBREG_0xc3c, 0x00000000,  BBREG_0xc40,
	0x00000000,  BBREG_0xc44, 0x00000000,  BBREG_0xc48, 0x00000000,
	BBREG_0xc4c, 0x00000000,  BBREG_0xc50, 0x00000020,  BBREG_0xc54,
	0x00000000,  BBREG_0xc58, 0xD8020402,  BBREG_0xc5c, 0xDE000120,
	BBREG_0xc68, 0x5979993F,  BBREG_0xc6c, 0x0000122A,  BBREG_0xc70,
	0x99795979,  BBREG_0xc74, 0x99795979,  BBREG_0xc78, 0x99799979,
	BBREG_0xc7c, 0x99791979,  BBREG_0xc80, 0x19791979,  BBREG_0xc84,
	0x19791979,  BBREG_0xc88, 0x00000000,  BBREG_0xc8c, 0x07000000,
	BBREG_0xc94, 0x01000100,  BBREG_0xc98, 0x201C8000,  BBREG_0xc9c,
	0x00000000,  BBREG_0xca0, 0x0000A555,  BBREG_0xca4, 0x08040201,
	BBREG_0xca8, 0x80402010,  BBREG_0xcac, 0x00000000,  BBREG_0xcb0,
	0x77777777,  BBREG_0xcb4, 0x00007777,  BBREG_0xcb8, 0x00000000,
	BBREG_0xcbc, 0x00000000,  BBREG_0xcc0, 0x00000000,  BBREG_0xcc4,
	0x00000000,  BBREG_0xcc8, 0x00000000,  BBREG_0xccc, 0x00000000,
	BBREG_0xcd0, 0x00000000,  BBREG_0xcd4, 0x00000000,  BBREG_0xcd8,
	0x00000000,  BBREG_0xcdc, 0x00000000,  BBREG_0xce0, 0x00000000,
	BBREG_0xce4, 0x00000000,  BBREG_0xce8, 0x00000000,  BBREG_0xcec,
	0x00000000,  BBREG_0xe00, 0x00000007,  BBREG_0xe04, 0x00000020,
	BBREG_0xe08, 0x60403231,  BBREG_0xe0c, 0x00012345,  BBREG_0xe10,
	0x00000100,  BBREG_0xe14, 0x01000000,  BBREG_0xe18, 0x00000000,
	BBREG_0xe1c, 0x40040053,  BBREG_0xe20, 0x40020103,  BBREG_0xe24,
	0x00000000,  BBREG_0xe28, 0x00000000,  BBREG_0xe2c, 0x00000000,
	BBREG_0xe30, 0x00000000,  BBREG_0xe34, 0x00000000,  BBREG_0xe38,
	0x00000000,  BBREG_0xe3c, 0x00000000,  BBREG_0xe40, 0x00000000,
	BBREG_0xe44, 0x00000000,  BBREG_0xe48, 0x00000000,  BBREG_0xe4c,
	0x00000000,  BBREG_0xe50, 0x00000020,  BBREG_0xe54, 0x00000000,
	BBREG_0xe58, 0xD8020402,  BBREG_0xe5c, 0xDE000120,  BBREG_0xe68,
	0x5979993F,  BBREG_0xe6c, 0x0000122A,  BBREG_0xe70, 0x99795979,
	BBREG_0xe74, 0x99795979,  BBREG_0xe78, 0x99799979,  BBREG_0xe7c,
	0x99791979,  BBREG_0xe80, 0x19791979,  BBREG_0xe84, 0x19791979,
	BBREG_0xe88, 0x00000000,  BBREG_0xe8c, 0x07000000,  BBREG_0xe94,
	0x01000100,  BBREG_0xe98, 0x201C8000,  BBREG_0xe9c, 0x00000000,
	BBREG_0xea0, 0x0000A555,  BBREG_0xea4, 0x08040201,  BBREG_0xea8,
	0x80402010,  BBREG_0xeac, 0x00000000,  BBREG_0xeb0, 0x77777777,
	BBREG_0xeb4, 0x00007777,  BBREG_0xeb8, 0x00000000,  BBREG_0xebc,
	0x00000000,  BBREG_0xec0, 0x00000000,  BBREG_0xec4, 0x00000000,
	BBREG_0xec8, 0x00000000,  BBREG_0xecc, 0x00000000,  BBREG_0xed0,
	0x00000000,  BBREG_0xed4, 0x00000000,  BBREG_0xed8, 0x00000000,
	BBREG_0xedc, 0x00000000,  BBREG_0xee0, 0x00000000,  BBREG_0xee4,
	0x00000000,  BBREG_0xee8, 0x00000000,  BBREG_0xeec, 0x00000000,
	0x1900,      0x00000000,  0x1904,      0x00238000,  0x1908,
	0x00000000,  0x190C,      0x00000000,  0x1910,      0x00000000,
	0x1914,      0x00000000,  0x1918,      0x00000000,  0x191C,
	0x00000000,  0x1920,      0x00000000,  0x1924,      0x00000000,
	0x1928,      0x00000000,  0x192C,      0x00000000,  0x1930,
	0x00000000,  0x1934,      0x00000000,  0x1938,      0x00000000,
	0x193C,      0x00000000,  0x1940,      0x00000000,  0x1944,
	0x00000000,  0x1948,      0x00000000,  0x194C,      0x00000000,
	0x1950,      0x00000000,  0x1954,      0x00000000,  0x1958,
	0x00000000,  0x195C,      0x00000000,  0x1960,      0x00000000,
	0x1964,      0x00000000,  0x1968,      0x00000000,  0x196C,
	0x00000000,  0x1970,      0x00000000,  0x1974,      0x00000000,
	0x1978,      0x00000000,  0x197C,      0x00000000,  0x1980,
	0x00000000,  0x1984,      0x03000000,  0x1988,      0x21401E88,
	0x198C,      0x00004000,  0x1990,      0x00000000,  0x1994,
	0x00000000,  0x1998,      0x00000053,  0x199C,      0x00000000,
	0x19A0,      0x00000000,  0x19A4,      0x00000000,  0x19A8,
	0x00000000,  0x19AC,      0x0E47E47F,  0x19B0,      0x00000000,
	0x19B4,      0x0E47E47F,  0x19B8,      0x00000000,  0x19BC,
	0x00000000,  0x19C0,      0x00000000,  0x19C4,      0x00000000,
	0x19C8,      0x00000000,  0x19CC,      0x00000000,  0x19D0,
	0x00000000,  0x19D4,      0xAAAAAAAA,  0x19D8,      0x00000AAA,
	0x19DC,      0x133E0F37,  0x19E0,      0x00000000,  0x19E4,
	0x00000000,  0x19E8,      0x00000000,  0x19EC,      0x00000000,
	0x19F0,      0x00000000,  0x19F4,      0x00000000,  0x19F8,
	0x01A00000,  0x19FC,      0x00000000,  0x1C00,      0x00000100,
	0x1C04,      0x01000000,  0x1C08,      0x00000100,  0x1C0C,
	0x01000000,  0x1C10,      0x00000100,  0x1C14,      0x01000000,
	0x1C18,      0x00000100,  0x1C1C,      0x01000000,  0x1C20,
	0x00000100,  0x1C24,      0x01000000,  0x1C28,      0x00000100,
	0x1C2C,      0x01000000,  0x1C30,      0x00000100,  0x1C34,
	0x01000000,  0x1C38,      0x00000000,  0x1C3C,      0x00000000,
	0x1C40,      0x000C0100,  0x1C44,      0x000000F3,  0x1C48,
	0x1A8249A8,  0x1C4C,      0x1461C826,  0x1C50,      0x0001469E,
	0x1C54,      0x58D158D1,  0x1C58,      0x04490088,  0x1C5C,
	0x04004400,  0x1C60,      0x00000000,  0x1C64,      0x04004400,
	0x1C68,      0x00000100,  0x1C6C,      0x01000000,  0x1C70,
	0x00000100,  0x1C74,      0x01000000,  0x1C78,      0x00000000,
	0x1C7C,      0x00000010,  0x1C80,      0x5FFF5FFF,  0x1C84,
	0x5FFF5FFF,  0x1C88,      0x5FFF5FFF,  0x1C8C,      0x5FFF5FFF,
	0x1C90,      0x5FFF5FFF,  0x1C94,      0x5FFF5FFF,  0x1C98,
	0x5FFF5FFF,  0x1C9C,      0x5FFF5FFF,  0x1CA0,      0x00000100,
	0x1CA4,      0x01000000,  0x1CA8,      0x00000100,  0x1CAC,
	0x5FFF5FFF,  0x1CB0,      0x00000100,  0x1CB4,      0x01000000,
	0x1CB8,      0x00000000,  0x1CBC,      0x00000000,  0x1CC0,
	0x00000100,  0x1CC4,      0x01000000,  0x1CC8,      0x00000100,
	0x1CCC,      0x01000000,  0x1CD0,      0x00000100,  0x1CD4,
	0x01000000,  0x1CD8,      0x00000100,  0x1CDC,      0x01000000,
	0x1CE0,      0x00000100,  0x1CE4,      0x01000000,  0x1CE8,
	0x00000100,  0x1CEC,      0x01000000,  0x1CF0,      0x00000100,
	0x1CF4,      0x01000000,  0x1CF8,      0x00000000,  0x1CFC,
	0x00000000,  BBREG_0xc60, 0x70038040,  BBREG_0xc60, 0x70038040,
	BBREG_0xc60, 0x70146040,  BBREG_0xc60, 0x70246040,  BBREG_0xc60,
	0x70346040,  BBREG_0xc60, 0x70446040,  BBREG_0xc60, 0x70532040,
	BBREG_0xc60, 0x70646040,  BBREG_0xc60, 0x70738040,  BBREG_0xc60,
	0x70838040,  BBREG_0xc60, 0x70938040,  BBREG_0xc60, 0x70A38040,
	BBREG_0xc60, 0x70B36040,  BBREG_0xc60, 0x70C06040,  BBREG_0xc60,
	0x70D06040,  BBREG_0xc60, 0x70E76040,  BBREG_0xc60, 0x70F06040,
	BBREG_0xe60, 0x70038040,  BBREG_0xe60, 0x70038040,  BBREG_0xe60,
	0x70146040,  BBREG_0xe60, 0x70246040,  BBREG_0xe60, 0x70346040,
	BBREG_0xe60, 0x70446040,  BBREG_0xe60, 0x70532040,  BBREG_0xe60,
	0x70646040,  BBREG_0xe60, 0x70738040,  BBREG_0xe60, 0x70838040,
	BBREG_0xe60, 0x70938040,  BBREG_0xe60, 0x70A38040,  BBREG_0xe60,
	0x70B36040,  BBREG_0xe60, 0x70C06040,  BBREG_0xe60, 0x70D06040,
	BBREG_0xe60, 0x70E76040,  BBREG_0xe60, 0x70F06040,  BBREG_0xc64,
	0x00800000,  BBREG_0xc64, 0x08800001,  BBREG_0xc64, 0x00800002,
	BBREG_0xc64, 0x00800003,  BBREG_0xc64, 0x00800004,  BBREG_0xc64,
	0x00800005,  BBREG_0xc64, 0x00800006,  BBREG_0xc64, 0x08800007,
	BBREG_0xc64, 0x00004000,  BBREG_0xe64, 0x00800000,  BBREG_0xe64,
	0x08800001,  BBREG_0xe64, 0x00800002,  BBREG_0xe64, 0x00800003,
	BBREG_0xe64, 0x00800004,  BBREG_0xe64, 0x00800005,  BBREG_0xe64,
	0x00800006,  BBREG_0xe64, 0x08800007,  BBREG_0xe64, 0x00004000,
	0x1B00,      0xF8000008,  0x1B00,      0xF80A7008,  0x1B00,
	0xF8015008,  0x1B00,      0xF8000008,  0x1B04,      0xE24629D2,
	0x1B08,      0x00000080,  0x1B0C,      0x00000000,  0x1B10,
	0x00011C00,  0x1B14,      0x00000000,  0x1B18,      0x00292903,
	0x1B1C,      0xA2193C32,  0x1B20,      0x01840008,  0x1B24,
	0x01860008,  0x1B28,      0x80060300,  0x1B2C,      0x00000003,
	0x1B30,      0x20000000,  0x1B34,      0x00000800,  0x1B3C,
	0x20000000,  0x1BC0,      0x01000000,  0x1BCC,      0x00000000,
	0x1B00,      0xF800000A,  0x1B1C,      0xA2193C32,  0x1B20,
	0x01840008,  0x1B24,      0x01860008,  0x1B28,      0x80060300,
	0x1B2C,      0x00000003,  0x1B30,      0x20000000,  0x1B34,
	0x00000800,  0x1B3C,      0x20000000,  0x1BC0,      0x01000000,
	0x1BCC,      0x00000000,  0x1B00,      0xF8000000,  0x1B80,
	0x00000007,  0x1B80,      0x090A0005,  0x1B80,      0x090A0007,
	0x1B80,      0x0FFE0015,  0x1B80,      0x0FFE0017,  0x1B80,
	0x00220025,  0x1B80,      0x00220027,  0x1B80,      0x00040035,
	0x1B80,      0x00040037,  0x1B80,      0x05C00045,  0x1B80,
	0x05C00047,  0x1B80,      0x00070055,  0x1B80,      0x00070057,
	0x1B80,      0x64000065,  0x1B80,      0x64000067,  0x1B80,
	0x00020075,  0x1B80,      0x00020077,  0x1B80,      0x00080085,
	0x1B80,      0x00080087,  0x1B80,      0x80000095,  0x1B80,
	0x80000097,  0x1B80,      0x090800A5,  0x1B80,      0x090800A7,
	0x1B80,      0x0F0200B5,  0x1B80,      0x0F0200B7,  0x1B80,
	0x002200C5,  0x1B80,      0x002200C7,  0x1B80,      0x000400D5,
	0x1B80,      0x000400D7,  0x1B80,      0x05C000E5,  0x1B80,
	0x05C000E7,  0x1B80,      0x000700F5,  0x1B80,      0x000700F7,
	0x1B80,      0x64020105,  0x1B80,      0x64020107,  0x1B80,
	0x00020115,  0x1B80,      0x00020117,  0x1B80,      0x00040125,
	0x1B80,      0x00040127,  0x1B80,      0x4A000135,  0x1B80,
	0x4A000137,  0x1B80,      0x4B040145,  0x1B80,      0x4B040147,
	0x1B80,      0x85030155,  0x1B80,      0x85030157,  0x1B80,
	0x40090165,  0x1B80,      0x40090167,  0x1B80,      0xE0280175,
	0x1B80,      0xE0280177,  0x1B80,      0x4B050185,  0x1B80,
	0x4B050187,  0x1B80,      0x86030195,  0x1B80,      0x86030197,
	0x1B80,      0x400B01A5,  0x1B80,      0x400B01A7,  0x1B80,
	0xE02801B5,  0x1B80,      0xE02801B7,  0x1B80,      0x4B0001C5,
	0x1B80,      0x4B0001C7,  0x1B80,      0x000701D5,  0x1B80,
	0x000701D7,  0x1B80,      0x4C0001E5,  0x1B80,      0x4C0001E7,
	0x1B80,      0x000401F5,  0x1B80,      0x000401F7,  0x1B80,
	0x4D040205,  0x1B80,      0x4D040207,  0x1B80,      0x2EF00215,
	0x1B80,      0x2EF00217,  0x1B80,      0x00000225,  0x1B80,
	0x00000227,  0x1B80,      0x20810235,  0x1B80,      0x20810237,
	0x1B80,      0x23450245,  0x1B80,      0x23450247,  0x1B80,
	0x4D000255,  0x1B80,      0x4D000257,  0x1B80,      0x00040265,
	0x1B80,      0x00040267,  0x1B80,      0x30000275,  0x1B80,
	0x30000277,  0x1B80,      0xE1D80285,  0x1B80,      0xE1D80287,
	0x1B80,      0xF0110295,  0x1B80,      0xF0110297,  0x1B80,
	0xF11102A5,  0x1B80,      0xF11102A7,  0x1B80,      0xF21102B5,
	0x1B80,      0xF21102B7,  0x1B80,      0xF31102C5,  0x1B80,
	0xF31102C7,  0x1B80,      0xF41102D5,  0x1B80,      0xF41102D7,
	0x1B80,      0xF51102E5,  0x1B80,      0xF51102E7,  0x1B80,
	0xF61102F5,  0x1B80,      0xF61102F7,  0x1B80,      0xF7110305,
	0x1B80,      0xF7110307,  0x1B80,      0xF8110315,  0x1B80,
	0xF8110317,  0x1B80,      0xF9110325,  0x1B80,      0xF9110327,
	0x1B80,      0xFA110335,  0x1B80,      0xFA110337,  0x1B80,
	0xFB110345,  0x1B80,      0xFB110347,  0x1B80,      0xFC110355,
	0x1B80,      0xFC110357,  0x1B80,      0xFD110365,  0x1B80,
	0xFD110367,  0x1B80,      0xFE110375,  0x1B80,      0xFE110377,
	0x1B80,      0xFF110385,  0x1B80,      0xFF110387,  0x1B80,
	0x00010395,  0x1B80,      0x00010397,  0x1B80,      0x305103A5,
	0x1B80,      0x305103A7,  0x1B80,      0x306903B5,  0x1B80,
	0x306903B7,  0x1B80,      0x30B403C5,  0x1B80,      0x30B403C7,
	0x1B80,      0x30B703D5,  0x1B80,      0x30B703D7,  0x1B80,
	0x306B03E5,  0x1B80,      0x306B03E7,  0x1B80,      0x307603F5,
	0x1B80,      0x307603F7,  0x1B80,      0x30810405,  0x1B80,
	0x30810407,  0x1B80,      0x30C10415,  0x1B80,      0x30C10417,
	0x1B80,      0x30BB0425,  0x1B80,      0x30BB0427,  0x1B80,
	0x30CF0435,  0x1B80,      0x30CF0437,  0x1B80,      0x30DA0445,
	0x1B80,      0x30DA0447,  0x1B80,      0x30E50455,  0x1B80,
	0x30E50457,  0x1B80,      0x304A0465,  0x1B80,      0x304A0467,
	0x1B80,      0x31140475,  0x1B80,      0x31140477,  0x1B80,
	0x31250485,  0x1B80,      0x31250487,  0x1B80,      0x313A0495,
	0x1B80,      0x313A0497,  0x1B80,      0x4D0404A5,  0x1B80,
	0x4D0404A7,  0x1B80,      0x2EF004B5,  0x1B80,      0x2EF004B7,
	0x1B80,      0x000004C5,  0x1B80,      0x000004C7,  0x1B80,
	0x208104D5,  0x1B80,      0x208104D7,  0x1B80,      0xA3B504E5,
	0x1B80,      0xA3B504E7,  0x1B80,      0x4D0004F5,  0x1B80,
	0x4D0004F7,  0x1B80,      0x30000505,  0x1B80,      0x30000507,
	0x1B80,      0xE1650515,  0x1B80,      0xE1650517,  0x1B80,
	0x4D040525,  0x1B80,      0x4D040527,  0x1B80,      0x20800535,
	0x1B80,      0x20800537,  0x1B80,      0x00000545,  0x1B80,
	0x00000547,  0x1B80,      0x4D000555,  0x1B80,      0x4D000557,
	0x1B80,      0x55070565,  0x1B80,      0x55070567,  0x1B80,
	0xE15D0575,  0x1B80,      0xE15D0577,  0x1B80,      0xE15D0585,
	0x1B80,      0xE15D0587,  0x1B80,      0x4D040595,  0x1B80,
	0x4D040597,  0x1B80,      0x208805A5,  0x1B80,      0x208805A7,
	0x1B80,      0x020005B5,  0x1B80,      0x020005B7,  0x1B80,
	0x4D0005C5,  0x1B80,      0x4D0005C7,  0x1B80,      0x550F05D5,
	0x1B80,      0x550F05D7,  0x1B80,      0xE15D05E5,  0x1B80,
	0xE15D05E7,  0x1B80,      0x4F0205F5,  0x1B80,      0x4F0205F7,
	0x1B80,      0x4E000605,  0x1B80,      0x4E000607,  0x1B80,
	0x53020615,  0x1B80,      0x53020617,  0x1B80,      0x52010625,
	0x1B80,      0x52010627,  0x1B80,      0xE1610635,  0x1B80,
	0xE1610637,  0x1B80,      0x4D080645,  0x1B80,      0x4D080647,
	0x1B80,      0x57100655,  0x1B80,      0x57100657,  0x1B80,
	0x57000665,  0x1B80,      0x57000667,  0x1B80,      0x4D000675,
	0x1B80,      0x4D000677,  0x1B80,      0x00010685,  0x1B80,
	0x00010687,  0x1B80,      0xE1650695,  0x1B80,      0xE1650697,
	0x1B80,      0x000106A5,  0x1B80,      0x000106A7,  0x1B80,
	0x308B06B5,  0x1B80,      0x308B06B7,  0x1B80,      0x002306C5,
	0x1B80,      0x002306C7,  0x1B80,      0xE1CB06D5,  0x1B80,
	0xE1CB06D7,  0x1B80,      0x000206E5,  0x1B80,      0x000206E7,
	0x1B80,      0x54E906F5,  0x1B80,      0x54E906F7,  0x1B80,
	0x0BA60705,  0x1B80,      0x0BA60707,  0x1B80,      0x00230715,
	0x1B80,      0x00230717,  0x1B80,      0xE1CB0725,  0x1B80,
	0xE1CB0727,  0x1B80,      0x00020735,  0x1B80,      0x00020737,
	0x1B80,      0x4D300745,  0x1B80,      0x4D300747,  0x1B80,
	0x30A40755,  0x1B80,      0x30A40757,  0x1B80,      0x30870765,
	0x1B80,      0x30870767,  0x1B80,      0x00220775,  0x1B80,
	0x00220777,  0x1B80,      0xE1CB0785,  0x1B80,      0xE1CB0787,
	0x1B80,      0x00020795,  0x1B80,      0x00020797,  0x1B80,
	0x54E807A5,  0x1B80,      0x54E807A7,  0x1B80,      0x0BA607B5,
	0x1B80,      0x0BA607B7,  0x1B80,      0x002207C5,  0x1B80,
	0x002207C7,  0x1B80,      0xE1CB07D5,  0x1B80,      0xE1CB07D7,
	0x1B80,      0x000207E5,  0x1B80,      0x000207E7,  0x1B80,
	0x4D3007F5,  0x1B80,      0x4D3007F7,  0x1B80,      0x30A40805,
	0x1B80,      0x30A40807,  0x1B80,      0x63F10815,  0x1B80,
	0x63F10817,  0x1B80,      0xE1650825,  0x1B80,      0xE1650827,
	0x1B80,      0xE1CB0835,  0x1B80,      0xE1CB0837,  0x1B80,
	0x63F40845,  0x1B80,      0x63F40847,  0x1B80,      0xE1650855,
	0x1B80,      0xE1650857,  0x1B80,      0xE1CB0865,  0x1B80,
	0xE1CB0867,  0x1B80,      0x0BA80875,  0x1B80,      0x0BA80877,
	0x1B80,      0x63F80885,  0x1B80,      0x63F80887,  0x1B80,
	0xE1650895,  0x1B80,      0xE1650897,  0x1B80,      0xE1CB08A5,
	0x1B80,      0xE1CB08A7,  0x1B80,      0x0BA908B5,  0x1B80,
	0x0BA908B7,  0x1B80,      0x63FC08C5,  0x1B80,      0x63FC08C7,
	0x1B80,      0xE16508D5,  0x1B80,      0xE16508D7,  0x1B80,
	0xE1CB08E5,  0x1B80,      0xE1CB08E7,  0x1B80,      0x63FF08F5,
	0x1B80,      0x63FF08F7,  0x1B80,      0xE1650905,  0x1B80,
	0xE1650907,  0x1B80,      0xE1CB0915,  0x1B80,      0xE1CB0917,
	0x1B80,      0x63000925,  0x1B80,      0x63000927,  0x1B80,
	0xE1650935,  0x1B80,      0xE1650937,  0x1B80,      0xE1CB0945,
	0x1B80,      0xE1CB0947,  0x1B80,      0x63030955,  0x1B80,
	0x63030957,  0x1B80,      0xE1650965,  0x1B80,      0xE1650967,
	0x1B80,      0xE1CB0975,  0x1B80,      0xE1CB0977,  0x1B80,
	0xF4D40985,  0x1B80,      0xF4D40987,  0x1B80,      0x63070995,
	0x1B80,      0x63070997,  0x1B80,      0xE16509A5,  0x1B80,
	0xE16509A7,  0x1B80,      0xE1CB09B5,  0x1B80,      0xE1CB09B7,
	0x1B80,      0xF5DB09C5,  0x1B80,      0xF5DB09C7,  0x1B80,
	0x630B09D5,  0x1B80,      0x630B09D7,  0x1B80,      0xE16509E5,
	0x1B80,      0xE16509E7,  0x1B80,      0xE1CB09F5,  0x1B80,
	0xE1CB09F7,  0x1B80,      0x630E0A05,  0x1B80,      0x630E0A07,
	0x1B80,      0xE1650A15,  0x1B80,      0xE1650A17,  0x1B80,
	0xE1CB0A25,  0x1B80,      0xE1CB0A27,  0x1B80,      0x4D300A35,
	0x1B80,      0x4D300A37,  0x1B80,      0x55010A45,  0x1B80,
	0x55010A47,  0x1B80,      0x57040A55,  0x1B80,      0x57040A57,
	0x1B80,      0x57000A65,  0x1B80,      0x57000A67,  0x1B80,
	0x96000A75,  0x1B80,      0x96000A77,  0x1B80,      0x57080A85,
	0x1B80,      0x57080A87,  0x1B80,      0x57000A95,  0x1B80,
	0x57000A97,  0x1B80,      0x95000AA5,  0x1B80,      0x95000AA7,
	0x1B80,      0x4D000AB5,  0x1B80,      0x4D000AB7,  0x1B80,
	0x6C070AC5,  0x1B80,      0x6C070AC7,  0x1B80,      0x7B200AD5,
	0x1B80,      0x7B200AD7,  0x1B80,      0x7A000AE5,  0x1B80,
	0x7A000AE7,  0x1B80,      0x79000AF5,  0x1B80,      0x79000AF7,
	0x1B80,      0x7F200B05,  0x1B80,      0x7F200B07,  0x1B80,
	0x7E000B15,  0x1B80,      0x7E000B17,  0x1B80,      0x7D000B25,
	0x1B80,      0x7D000B27,  0x1B80,      0x00010B35,  0x1B80,
	0x00010B37,  0x1B80,      0x62850B45,  0x1B80,      0x62850B47,
	0x1B80,      0xE1650B55,  0x1B80,      0xE1650B57,  0x1B80,
	0x00010B65,  0x1B80,      0x00010B67,  0x1B80,      0x5C320B75,
	0x1B80,      0x5C320B77,  0x1B80,      0xE1C70B85,  0x1B80,
	0xE1C70B87,  0x1B80,      0xE1930B95,  0x1B80,      0xE1930B97,
	0x1B80,      0x00010BA5,  0x1B80,      0x00010BA7,  0x1B80,
	0x5C320BB5,  0x1B80,      0x5C320BB7,  0x1B80,      0x63F40BC5,
	0x1B80,      0x63F40BC7,  0x1B80,      0x62850BD5,  0x1B80,
	0x62850BD7,  0x1B80,      0x0BB00BE5,  0x1B80,      0x0BB00BE7,
	0x1B80,      0xE1650BF5,  0x1B80,      0xE1650BF7,  0x1B80,
	0xE1CB0C05,  0x1B80,      0xE1CB0C07,  0x1B80,      0x5C320C15,
	0x1B80,      0x5C320C17,  0x1B80,      0x63FC0C25,  0x1B80,
	0x63FC0C27,  0x1B80,      0x62850C35,  0x1B80,      0x62850C37,
	0x1B80,      0x0BB10C45,  0x1B80,      0x0BB10C47,  0x1B80,
	0xE1650C55,  0x1B80,      0xE1650C57,  0x1B80,      0xE1CB0C65,
	0x1B80,      0xE1CB0C67,  0x1B80,      0x63030C75,  0x1B80,
	0x63030C77,  0x1B80,      0xE1650C85,  0x1B80,      0xE1650C87,
	0x1B80,      0xE1CB0C95,  0x1B80,      0xE1CB0C97,  0x1B80,
	0xF7040CA5,  0x1B80,      0xF7040CA7,  0x1B80,      0x630B0CB5,
	0x1B80,      0x630B0CB7,  0x1B80,      0xE1650CC5,  0x1B80,
	0xE1650CC7,  0x1B80,      0xE1CB0CD5,  0x1B80,      0xE1CB0CD7,
	0x1B80,      0x00010CE5,  0x1B80,      0x00010CE7,  0x1B80,
	0x30F30CF5,  0x1B80,      0x30F30CF7,  0x1B80,      0x00230D05,
	0x1B80,      0x00230D07,  0x1B80,      0xE1D00D15,  0x1B80,
	0xE1D00D17,  0x1B80,      0x00020D25,  0x1B80,      0x00020D27,
	0x1B80,      0x54E90D35,  0x1B80,      0x54E90D37,  0x1B80,
	0x0BA60D45,  0x1B80,      0x0BA60D47,  0x1B80,      0x00230D55,
	0x1B80,      0x00230D57,  0x1B80,      0xE1D00D65,  0x1B80,
	0xE1D00D67,  0x1B80,      0x00020D75,  0x1B80,      0x00020D77,
	0x1B80,      0x4D100D85,  0x1B80,      0x4D100D87,  0x1B80,
	0x30A40D95,  0x1B80,      0x30A40D97,  0x1B80,      0x30ED0DA5,
	0x1B80,      0x30ED0DA7,  0x1B80,      0x00220DB5,  0x1B80,
	0x00220DB7,  0x1B80,      0xE1D00DC5,  0x1B80,      0xE1D00DC7,
	0x1B80,      0x00020DD5,  0x1B80,      0x00020DD7,  0x1B80,
	0x54E80DE5,  0x1B80,      0x54E80DE7,  0x1B80,      0x0BA60DF5,
	0x1B80,      0x0BA60DF7,  0x1B80,      0x00220E05,  0x1B80,
	0x00220E07,  0x1B80,      0xE1D00E15,  0x1B80,      0xE1D00E17,
	0x1B80,      0x00020E25,  0x1B80,      0x00020E27,  0x1B80,
	0x4D100E35,  0x1B80,      0x4D100E37,  0x1B80,      0x30A40E45,
	0x1B80,      0x30A40E47,  0x1B80,      0x5C320E55,  0x1B80,
	0x5C320E57,  0x1B80,      0x54F00E65,  0x1B80,      0x54F00E67,
	0x1B80,      0x67F10E75,  0x1B80,      0x67F10E77,  0x1B80,
	0xE1930E85,  0x1B80,      0xE1930E87,  0x1B80,      0xE1D00E95,
	0x1B80,      0xE1D00E97,  0x1B80,      0x67F40EA5,  0x1B80,
	0x67F40EA7,  0x1B80,      0xE1930EB5,  0x1B80,      0xE1930EB7,
	0x1B80,      0xE1D00EC5,  0x1B80,      0xE1D00EC7,  0x1B80,
	0x5C320ED5,  0x1B80,      0x5C320ED7,  0x1B80,      0x54F10EE5,
	0x1B80,      0x54F10EE7,  0x1B80,      0x0BA80EF5,  0x1B80,
	0x0BA80EF7,  0x1B80,      0x67F80F05,  0x1B80,      0x67F80F07,
	0x1B80,      0xE1930F15,  0x1B80,      0xE1930F17,  0x1B80,
	0xE1D00F25,  0x1B80,      0xE1D00F27,  0x1B80,      0x5C320F35,
	0x1B80,      0x5C320F37,  0x1B80,      0x54F10F45,  0x1B80,
	0x54F10F47,  0x1B80,      0x0BA90F55,  0x1B80,      0x0BA90F57,
	0x1B80,      0x67FC0F65,  0x1B80,      0x67FC0F67,  0x1B80,
	0xE1930F75,  0x1B80,      0xE1930F77,  0x1B80,      0xE1D00F85,
	0x1B80,      0xE1D00F87,  0x1B80,      0x67FF0F95,  0x1B80,
	0x67FF0F97,  0x1B80,      0xE1930FA5,  0x1B80,      0xE1930FA7,
	0x1B80,      0xE1D00FB5,  0x1B80,      0xE1D00FB7,  0x1B80,
	0x5C320FC5,  0x1B80,      0x5C320FC7,  0x1B80,      0x54F20FD5,
	0x1B80,      0x54F20FD7,  0x1B80,      0x67000FE5,  0x1B80,
	0x67000FE7,  0x1B80,      0xE1930FF5,  0x1B80,      0xE1930FF7,
	0x1B80,      0xE1D01005,  0x1B80,      0xE1D01007,  0x1B80,
	0x67031015,  0x1B80,      0x67031017,  0x1B80,      0xE1931025,
	0x1B80,      0xE1931027,  0x1B80,      0xE1D01035,  0x1B80,
	0xE1D01037,  0x1B80,      0xF9CC1045,  0x1B80,      0xF9CC1047,
	0x1B80,      0x67071055,  0x1B80,      0x67071057,  0x1B80,
	0xE1931065,  0x1B80,      0xE1931067,  0x1B80,      0xE1D01075,
	0x1B80,      0xE1D01077,  0x1B80,      0xFAD31085,  0x1B80,
	0xFAD31087,  0x1B80,      0x5C321095,  0x1B80,      0x5C321097,
	0x1B80,      0x54F310A5,  0x1B80,      0x54F310A7,  0x1B80,
	0x670B10B5,  0x1B80,      0x670B10B7,  0x1B80,      0xE19310C5,
	0x1B80,      0xE19310C7,  0x1B80,      0xE1D010D5,  0x1B80,
	0xE1D010D7,  0x1B80,      0x670E10E5,  0x1B80,      0x670E10E7,
	0x1B80,      0xE19310F5,  0x1B80,      0xE19310F7,  0x1B80,
	0xE1D01105,  0x1B80,      0xE1D01107,  0x1B80,      0x4D101115,
	0x1B80,      0x4D101117,  0x1B80,      0x30A41125,  0x1B80,
	0x30A41127,  0x1B80,      0x00011135,  0x1B80,      0x00011137,
	0x1B80,      0x6C001145,  0x1B80,      0x6C001147,  0x1B80,
	0x00061155,  0x1B80,      0x00061157,  0x1B80,      0x53001165,
	0x1B80,      0x53001167,  0x1B80,      0x57F71175,  0x1B80,
	0x57F71177,  0x1B80,      0x58211185,  0x1B80,      0x58211187,
	0x1B80,      0x592E1195,  0x1B80,      0x592E1197,  0x1B80,
	0x5A3811A5,  0x1B80,      0x5A3811A7,  0x1B80,      0x5B4111B5,
	0x1B80,      0x5B4111B7,  0x1B80,      0x000711C5,  0x1B80,
	0x000711C7,  0x1B80,      0x5C0011D5,  0x1B80,      0x5C0011D7,
	0x1B80,      0x4B0011E5,  0x1B80,      0x4B0011E7,  0x1B80,
	0x4E8F11F5,  0x1B80,      0x4E8F11F7,  0x1B80,      0x4F151205,
	0x1B80,      0x4F151207,  0x1B80,      0x00041215,  0x1B80,
	0x00041217,  0x1B80,      0xE1B51225,  0x1B80,      0xE1B51227,
	0x1B80,      0xAB001235,  0x1B80,      0xAB001237,  0x1B80,
	0x00011245,  0x1B80,      0x00011247,  0x1B80,      0x6C001255,
	0x1B80,      0x6C001257,  0x1B80,      0x00061265,  0x1B80,
	0x00061267,  0x1B80,      0x53001275,  0x1B80,      0x53001277,
	0x1B80,      0x57F71285,  0x1B80,      0x57F71287,  0x1B80,
	0x58211295,  0x1B80,      0x58211297,  0x1B80,      0x592E12A5,
	0x1B80,      0x592E12A7,  0x1B80,      0x5A3812B5,  0x1B80,
	0x5A3812B7,  0x1B80,      0x5B4112C5,  0x1B80,      0x5B4112C7,
	0x1B80,      0x000712D5,  0x1B80,      0x000712D7,  0x1B80,
	0x5C0012E5,  0x1B80,      0x5C0012E7,  0x1B80,      0x4B4012F5,
	0x1B80,      0x4B4012F7,  0x1B80,      0x4E971305,  0x1B80,
	0x4E971307,  0x1B80,      0x4F111315,  0x1B80,      0x4F111317,
	0x1B80,      0x00041325,  0x1B80,      0x00041327,  0x1B80,
	0xE1B51335,  0x1B80,      0xE1B51337,  0x1B80,      0xAB001345,
	0x1B80,      0xAB001347,  0x1B80,      0x8B001355,  0x1B80,
	0x8B001357,  0x1B80,      0xAB001365,  0x1B80,      0xAB001367,
	0x1B80,      0x8A191375,  0x1B80,      0x8A191377,  0x1B80,
	0x301D1385,  0x1B80,      0x301D1387,  0x1B80,      0x00011395,
	0x1B80,      0x00011397,  0x1B80,      0x6C0113A5,  0x1B80,
	0x6C0113A7,  0x1B80,      0x000613B5,  0x1B80,      0x000613B7,
	0x1B80,      0x530113C5,  0x1B80,      0x530113C7,  0x1B80,
	0x57F713D5,  0x1B80,      0x57F713D7,  0x1B80,      0x582113E5,
	0x1B80,      0x582113E7,  0x1B80,      0x592E13F5,  0x1B80,
	0x592E13F7,  0x1B80,      0x5A381405,  0x1B80,      0x5A381407,
	0x1B80,      0x5B411415,  0x1B80,      0x5B411417,  0x1B80,
	0x00071425,  0x1B80,      0x00071427,  0x1B80,      0x5C001435,
	0x1B80,      0x5C001437,  0x1B80,      0x4B001445,  0x1B80,
	0x4B001447,  0x1B80,      0x4E871455,  0x1B80,      0x4E871457,
	0x1B80,      0x4F111465,  0x1B80,      0x4F111467,  0x1B80,
	0x00041475,  0x1B80,      0x00041477,  0x1B80,      0xE1B51485,
	0x1B80,      0xE1B51487,  0x1B80,      0xAB001495,  0x1B80,
	0xAB001497,  0x1B80,      0x000614A5,  0x1B80,      0x000614A7,
	0x1B80,      0x577714B5,  0x1B80,      0x577714B7,  0x1B80,
	0x000714C5,  0x1B80,      0x000714C7,  0x1B80,      0x4E8614D5,
	0x1B80,      0x4E8614D7,  0x1B80,      0x000414E5,  0x1B80,
	0x000414E7,  0x1B80,      0x000114F5,  0x1B80,      0x000114F7,
	0x1B80,      0x00011505,  0x1B80,      0x00011507,  0x1B80,
	0x7B241515,  0x1B80,      0x7B241517,  0x1B80,      0x7A401525,
	0x1B80,      0x7A401527,  0x1B80,      0x79001535,  0x1B80,
	0x79001537,  0x1B80,      0x55031545,  0x1B80,      0x55031547,
	0x1B80,      0x315D1555,  0x1B80,      0x315D1557,  0x1B80,
	0x7B1C1565,  0x1B80,      0x7B1C1567,  0x1B80,      0x7A401575,
	0x1B80,      0x7A401577,  0x1B80,      0x550B1585,  0x1B80,
	0x550B1587,  0x1B80,      0x315D1595,  0x1B80,      0x315D1597,
	0x1B80,      0x7B2015A5,  0x1B80,      0x7B2015A7,  0x1B80,
	0x7A0015B5,  0x1B80,      0x7A0015B7,  0x1B80,      0x551315C5,
	0x1B80,      0x551315C7,  0x1B80,      0x740115D5,  0x1B80,
	0x740115D7,  0x1B80,      0x740015E5,  0x1B80,      0x740015E7,
	0x1B80,      0x8E0015F5,  0x1B80,      0x8E0015F7,  0x1B80,
	0x00011605,  0x1B80,      0x00011607,  0x1B80,      0x57021615,
	0x1B80,      0x57021617,  0x1B80,      0x57001625,  0x1B80,
	0x57001627,  0x1B80,      0x97001635,  0x1B80,      0x97001637,
	0x1B80,      0x00011645,  0x1B80,      0x00011647,  0x1B80,
	0x4F781655,  0x1B80,      0x4F781657,  0x1B80,      0x53881665,
	0x1B80,      0x53881667,  0x1B80,      0xE1731675,  0x1B80,
	0xE1731677,  0x1B80,      0x54801685,  0x1B80,      0x54801687,
	0x1B80,      0x54001695,  0x1B80,      0x54001697,  0x1B80,
	0xE17316A5,  0x1B80,      0xE17316A7,  0x1B80,      0x548116B5,
	0x1B80,      0x548116B7,  0x1B80,      0x540016C5,  0x1B80,
	0x540016C7,  0x1B80,      0xE17316D5,  0x1B80,      0xE17316D7,
	0x1B80,      0x548216E5,  0x1B80,      0x548216E7,  0x1B80,
	0x540016F5,  0x1B80,      0x540016F7,  0x1B80,      0xE17E1705,
	0x1B80,      0xE17E1707,  0x1B80,      0xBF1D1715,  0x1B80,
	0xBF1D1717,  0x1B80,      0x301D1725,  0x1B80,      0x301D1727,
	0x1B80,      0xE1511735,  0x1B80,      0xE1511737,  0x1B80,
	0xE1561745,  0x1B80,      0xE1561747,  0x1B80,      0xE15A1755,
	0x1B80,      0xE15A1757,  0x1B80,      0xE1611765,  0x1B80,
	0xE1611767,  0x1B80,      0xE1C71775,  0x1B80,      0xE1C71777,
	0x1B80,      0x55131785,  0x1B80,      0x55131787,  0x1B80,
	0xE15D1795,  0x1B80,      0xE15D1797,  0x1B80,      0x551517A5,
	0x1B80,      0x551517A7,  0x1B80,      0xE16117B5,  0x1B80,
	0xE16117B7,  0x1B80,      0xE1C717C5,  0x1B80,      0xE1C717C7,
	0x1B80,      0x000117D5,  0x1B80,      0x000117D7,  0x1B80,
	0x54BF17E5,  0x1B80,      0x54BF17E7,  0x1B80,      0x54C017F5,
	0x1B80,      0x54C017F7,  0x1B80,      0x54A31805,  0x1B80,
	0x54A31807,  0x1B80,      0x54C11815,  0x1B80,      0x54C11817,
	0x1B80,      0x54A41825,  0x1B80,      0x54A41827,  0x1B80,
	0x4C181835,  0x1B80,      0x4C181837,  0x1B80,      0xBF071845,
	0x1B80,      0xBF071847,  0x1B80,      0x54C21855,  0x1B80,
	0x54C21857,  0x1B80,      0x54A41865,  0x1B80,      0x54A41867,
	0x1B80,      0xBF041875,  0x1B80,      0xBF041877,  0x1B80,
	0x54C11885,  0x1B80,      0x54C11887,  0x1B80,      0x54A31895,
	0x1B80,      0x54A31897,  0x1B80,      0xBF0118A5,  0x1B80,
	0xBF0118A7,  0x1B80,      0xE1D518B5,  0x1B80,      0xE1D518B7,
	0x1B80,      0x54DF18C5,  0x1B80,      0x54DF18C7,  0x1B80,
	0x000118D5,  0x1B80,      0x000118D7,  0x1B80,      0x54BF18E5,
	0x1B80,      0x54BF18E7,  0x1B80,      0x54E518F5,  0x1B80,
	0x54E518F7,  0x1B80,      0x050A1905,  0x1B80,      0x050A1907,
	0x1B80,      0x54DF1915,  0x1B80,      0x54DF1917,  0x1B80,
	0x00011925,  0x1B80,      0x00011927,  0x1B80,      0x7F201935,
	0x1B80,      0x7F201937,  0x1B80,      0x7E001945,  0x1B80,
	0x7E001947,  0x1B80,      0x7D001955,  0x1B80,      0x7D001957,
	0x1B80,      0x55011965,  0x1B80,      0x55011967,  0x1B80,
	0x5C311975,  0x1B80,      0x5C311977,  0x1B80,      0xE15D1985,
	0x1B80,      0xE15D1987,  0x1B80,      0xE1611995,  0x1B80,
	0xE1611997,  0x1B80,      0x548019A5,  0x1B80,      0x548019A7,
	0x1B80,      0x540019B5,  0x1B80,      0x540019B7,  0x1B80,
	0xE15D19C5,  0x1B80,      0xE15D19C7,  0x1B80,      0xE16119D5,
	0x1B80,      0xE16119D7,  0x1B80,      0x548119E5,  0x1B80,
	0x548119E7,  0x1B80,      0x540019F5,  0x1B80,      0x540019F7,
	0x1B80,      0xE15D1A05,  0x1B80,      0xE15D1A07,  0x1B80,
	0xE1611A15,  0x1B80,      0xE1611A17,  0x1B80,      0x54821A25,
	0x1B80,      0x54821A27,  0x1B80,      0x54001A35,  0x1B80,
	0x54001A37,  0x1B80,      0xE17E1A45,  0x1B80,      0xE17E1A47,
	0x1B80,      0xBFE91A55,  0x1B80,      0xBFE91A57,  0x1B80,
	0x301D1A65,  0x1B80,      0x301D1A67,  0x1B80,      0x00231A75,
	0x1B80,      0x00231A77,  0x1B80,      0x7B201A85,  0x1B80,
	0x7B201A87,  0x1B80,      0x7A001A95,  0x1B80,      0x7A001A97,
	0x1B80,      0x79001AA5,  0x1B80,      0x79001AA7,  0x1B80,
	0xE1CB1AB5,  0x1B80,      0xE1CB1AB7,  0x1B80,      0x00021AC5,
	0x1B80,      0x00021AC7,  0x1B80,      0x00011AD5,  0x1B80,
	0x00011AD7,  0x1B80,      0x00221AE5,  0x1B80,      0x00221AE7,
	0x1B80,      0x7B201AF5,  0x1B80,      0x7B201AF7,  0x1B80,
	0x7A001B05,  0x1B80,      0x7A001B07,  0x1B80,      0x79001B15,
	0x1B80,      0x79001B17,  0x1B80,      0xE1CB1B25,  0x1B80,
	0xE1CB1B27,  0x1B80,      0x00021B35,  0x1B80,      0x00021B37,
	0x1B80,      0x00011B45,  0x1B80,      0x00011B47,  0x1B80,
	0x74021B55,  0x1B80,      0x74021B57,  0x1B80,      0x003F1B65,
	0x1B80,      0x003F1B67,  0x1B80,      0x74001B75,  0x1B80,
	0x74001B77,  0x1B80,      0x00021B85,  0x1B80,      0x00021B87,
	0x1B80,      0x00011B95,  0x1B80,      0x00011B97,  0x1B80,
	0x4D041BA5,  0x1B80,      0x4D041BA7,  0x1B80,      0x2EF81BB5,
	0x1B80,      0x2EF81BB7,  0x1B80,      0x00001BC5,  0x1B80,
	0x00001BC7,  0x1B80,      0x23301BD5,  0x1B80,      0x23301BD7,
	0x1B80,      0x00241BE5,  0x1B80,      0x00241BE7,  0x1B80,
	0x23E01BF5,  0x1B80,      0x23E01BF7,  0x1B80,      0x003F1C05,
	0x1B80,      0x003F1C07,  0x1B80,      0x23FC1C15,  0x1B80,
	0x23FC1C17,  0x1B80,      0xBFCE1C25,  0x1B80,      0xBFCE1C27,
	0x1B80,      0x2EF01C35,  0x1B80,      0x2EF01C37,  0x1B80,
	0x00001C45,  0x1B80,      0x00001C47,  0x1B80,      0x4D001C55,
	0x1B80,      0x4D001C57,  0x1B80,      0x00011C65,  0x1B80,
	0x00011C67,  0x1B80,      0x549F1C75,  0x1B80,      0x549F1C77,
	0x1B80,      0x54FF1C85,  0x1B80,      0x54FF1C87,  0x1B80,
	0x54001C95,  0x1B80,      0x54001C97,  0x1B80,      0x00011CA5,
	0x1B80,      0x00011CA7,  0x1B80,      0x5C311CB5,  0x1B80,
	0x5C311CB7,  0x1B80,      0x07141CC5,  0x1B80,      0x07141CC7,
	0x1B80,      0x54001CD5,  0x1B80,      0x54001CD7,  0x1B80,
	0x5C321CE5,  0x1B80,      0x5C321CE7,  0x1B80,      0x00011CF5,
	0x1B80,      0x00011CF7,  0x1B80,      0x5C321D05,  0x1B80,
	0x5C321D07,  0x1B80,      0x07141D15,  0x1B80,      0x07141D17,
	0x1B80,      0x54001D25,  0x1B80,      0x54001D27,  0x1B80,
	0x5C311D35,  0x1B80,      0x5C311D37,  0x1B80,      0x00011D45,
	0x1B80,      0x00011D47,  0x1B80,      0x4C981D55,  0x1B80,
	0x4C981D57,  0x1B80,      0x4C181D65,  0x1B80,      0x4C181D67,
	0x1B80,      0x00011D75,  0x1B80,      0x00011D77,  0x1B80,
	0x5C321D85,  0x1B80,      0x5C321D87,  0x1B80,      0x62841D95,
	0x1B80,      0x62841D97,  0x1B80,      0x66861DA5,  0x1B80,
	0x66861DA7,  0x1B80,      0x6C031DB5,  0x1B80,      0x6C031DB7,
	0x1B80,      0x7B201DC5,  0x1B80,      0x7B201DC7,  0x1B80,
	0x7A001DD5,  0x1B80,      0x7A001DD7,  0x1B80,      0x79001DE5,
	0x1B80,      0x79001DE7,  0x1B80,      0x7F201DF5,  0x1B80,
	0x7F201DF7,  0x1B80,      0x7E001E05,  0x1B80,      0x7E001E07,
	0x1B80,      0x7D001E15,  0x1B80,      0x7D001E17,  0x1B80,
	0x09011E25,  0x1B80,      0x09011E27,  0x1B80,      0x0C011E35,
	0x1B80,      0x0C011E37,  0x1B80,      0x0BA61E45,  0x1B80,
	0x0BA61E47,  0x1B80,      0x00011E55,  0x1B80,      0x00011E57,
	0x1B80,      0x00000006,  0x1B80,      0x00000002,

};

void odm_read_and_config_mp_8822b_phy_reg(struct PHY_DM_STRUCT *p_dm_odm)
{
	u32 i = 0;
	u8 c_cond;
	boolean is_matched = true, is_skipped = false;
	u32 array_len = sizeof(array_mp_8822b_phy_reg) / sizeof(u32);
	u32 *array = array_mp_8822b_phy_reg;

	u32 v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> odm_read_and_config_mp_8822b_phy_reg\n"));

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 &
		    (BIT(31) | BIT(30))) { /*positive & negative condition*/
			if (v1 & BIT(31)) { /* positive condition*/
				c_cond = (u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) { /*end*/
					is_matched = true;
					is_skipped = false;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT,
						     ODM_DBG_LOUD, ("ENDIF\n"));
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT,
						     ODM_DBG_LOUD, ("ELSE\n"));
				} else { /*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT,
						     ODM_DBG_LOUD,
						     ("IF or ELSE IF\n"));
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (is_skipped == false) {
					if (check_positive(p_dm_odm, pre_v1,
							   pre_v2, v1, v2)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else
					is_matched = false;
			}
		} else {
			if (is_matched)
				odm_config_bb_phy_8822b(p_dm_odm, v1, MASKDWORD,
							v2);
		}
		i = i + 2;
	}
}

u32 odm_get_version_mp_8822b_phy_reg(void) { return 100; }

/******************************************************************************
*                           phy_reg_pg.TXT
******************************************************************************/

u32 array_mp_8822b_phy_reg_pg[] = {0, 0, 0, 0x00000c20, 0xffffffff, 0x32343638,
				   0, 0, 0, 0x00000c24, 0xffffffff, 0x36384042,
				   0, 0, 0, 0x00000c28, 0xffffffff, 0x28303234,
				   0, 0, 0, 0x00000c2c, 0xffffffff, 0x34363840,
				   0, 0, 0, 0x00000c30, 0xffffffff, 0x26283032,
				   0, 0, 1, 0x00000c34, 0xffffffff, 0x34363840,
				   0, 0, 1, 0x00000c38, 0xffffffff, 0x26283032,
				   0, 0, 0, 0x00000c3c, 0xffffffff, 0x34363840,
				   0, 0, 0, 0x00000c40, 0xffffffff, 0x26283032,
				   0, 0, 0, 0x00000c44, 0xffffffff, 0x38402224,
				   0, 0, 1, 0x00000c48, 0xffffffff, 0x30323436,
				   0, 0, 1, 0x00000c4c, 0xffffffff, 0x22242628,
				   0, 1, 0, 0x00000e20, 0xffffffff, 0x32343638,
				   0, 1, 0, 0x00000e24, 0xffffffff, 0x36384042,
				   0, 1, 0, 0x00000e28, 0xffffffff, 0x28303234,
				   0, 1, 0, 0x00000e2c, 0xffffffff, 0x34363840,
				   0, 1, 0, 0x00000e30, 0xffffffff, 0x26283032,
				   0, 1, 1, 0x00000e34, 0xffffffff, 0x34363840,
				   0, 1, 1, 0x00000e38, 0xffffffff, 0x26283032,
				   0, 1, 0, 0x00000e3c, 0xffffffff, 0x34363840,
				   0, 1, 0, 0x00000e40, 0xffffffff, 0x26283032,
				   0, 1, 0, 0x00000e44, 0xffffffff, 0x38402224,
				   0, 1, 1, 0x00000e48, 0xffffffff, 0x30323436,
				   0, 1, 1, 0x00000e4c, 0xffffffff, 0x22242628,
				   1, 0, 0, 0x00000c24, 0xffffffff, 0x34363840,
				   1, 0, 0, 0x00000c28, 0xffffffff, 0x26283032,
				   1, 0, 0, 0x00000c2c, 0xffffffff, 0x32343638,
				   1, 0, 0, 0x00000c30, 0xffffffff, 0x24262830,
				   1, 0, 1, 0x00000c34, 0xffffffff, 0x32343638,
				   1, 0, 1, 0x00000c38, 0xffffffff, 0x24262830,
				   1, 0, 0, 0x00000c3c, 0xffffffff, 0x32343638,
				   1, 0, 0, 0x00000c40, 0xffffffff, 0x24262830,
				   1, 0, 0, 0x00000c44, 0xffffffff, 0x36382022,
				   1, 0, 1, 0x00000c48, 0xffffffff, 0x28303234,
				   1, 0, 1, 0x00000c4c, 0xffffffff, 0x20222426,
				   1, 1, 0, 0x00000e24, 0xffffffff, 0x34363840,
				   1, 1, 0, 0x00000e28, 0xffffffff, 0x26283032,
				   1, 1, 0, 0x00000e2c, 0xffffffff, 0x32343638,
				   1, 1, 0, 0x00000e30, 0xffffffff, 0x24262830,
				   1, 1, 1, 0x00000e34, 0xffffffff, 0x32343638,
				   1, 1, 1, 0x00000e38, 0xffffffff, 0x24262830,
				   1, 1, 0, 0x00000e3c, 0xffffffff, 0x32343638,
				   1, 1, 0, 0x00000e40, 0xffffffff, 0x24262830,
				   1, 1, 0, 0x00000e44, 0xffffffff, 0x36382022,
				   1, 1, 1, 0x00000e48, 0xffffffff, 0x28303234,
				   1, 1, 1, 0x00000e4c, 0xffffffff, 0x20222426};

void odm_read_and_config_mp_8822b_phy_reg_pg(struct PHY_DM_STRUCT *p_dm_odm)
{
	u32 i = 0;
	u32 array_len = sizeof(array_mp_8822b_phy_reg_pg) / sizeof(u32);
	u32 *array = array_mp_8822b_phy_reg_pg;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	struct _ADAPTER	*adapter = p_dm_odm->adapter;
	HAL_DATA_TYPE	*p_hal_data = GET_HAL_DATA(adapter);

	PlatformZeroMemory(p_hal_data->BufOfLinesPwrByRate, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	p_hal_data->nLinesReadPwrByRate = array_len/6;
#endif

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> odm_read_and_config_mp_8822b_phy_reg_pg\n"));

	p_dm_odm->phy_reg_pg_version = 1;
	p_dm_odm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32 v1 = array[i];
		u32 v2 = array[i + 1];
		u32 v3 = array[i + 2];
		u32 v4 = array[i + 3];
		u32 v5 = array[i + 4];
		u32 v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8822b(p_dm_odm, v1, v2, v3, v4, v5,
					       v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)p_hal_data->BufOfLinesPwrByRate[i/6], 100, "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		(v1 == 0?"2.4G":"  5G"), (v2 == 0?"A":"B"), (v3 == 0?"1Tx":"2Tx"), v4, v5, v6);
#endif
	}
}

/******************************************************************************
*                           phy_reg_pg_type12.TXT
******************************************************************************/

u32 array_mp_8822b_phy_reg_pg_type12[] = {
	0, 0, 0, 0x00000c20, 0xffffffff, 0x32343638,
	0, 0, 0, 0x00000c24, 0xffffffff, 0x36384042,
	0, 0, 0, 0x00000c28, 0xffffffff, 0x28303234,
	0, 0, 0, 0x00000c2c, 0xffffffff, 0x34363840,
	0, 0, 0, 0x00000c30, 0xffffffff, 0x26283032,
	0, 0, 1, 0x00000c34, 0xffffffff, 0x34363840,
	0, 0, 1, 0x00000c38, 0xffffffff, 0x26283032,
	0, 0, 0, 0x00000c3c, 0xffffffff, 0x34363840,
	0, 0, 0, 0x00000c40, 0xffffffff, 0x26283032,
	0, 0, 0, 0x00000c44, 0xffffffff, 0x38402224,
	0, 0, 1, 0x00000c48, 0xffffffff, 0x30323436,
	0, 0, 1, 0x00000c4c, 0xffffffff, 0x22242628,
	0, 1, 0, 0x00000e20, 0xffffffff, 0x32343638,
	0, 1, 0, 0x00000e24, 0xffffffff, 0x36384042,
	0, 1, 0, 0x00000e28, 0xffffffff, 0x28303234,
	0, 1, 0, 0x00000e2c, 0xffffffff, 0x34363840,
	0, 1, 0, 0x00000e30, 0xffffffff, 0x26283032,
	0, 1, 1, 0x00000e34, 0xffffffff, 0x34363840,
	0, 1, 1, 0x00000e38, 0xffffffff, 0x26283032,
	0, 1, 0, 0x00000e3c, 0xffffffff, 0x34363840,
	0, 1, 0, 0x00000e40, 0xffffffff, 0x26283032,
	0, 1, 0, 0x00000e44, 0xffffffff, 0x38402224,
	0, 1, 1, 0x00000e48, 0xffffffff, 0x30323436,
	0, 1, 1, 0x00000e4c, 0xffffffff, 0x22242628,
	1, 0, 0, 0x00000c24, 0xffffffff, 0x32343638,
	1, 0, 0, 0x00000c28, 0xffffffff, 0x24262830,
	1, 0, 0, 0x00000c2c, 0xffffffff, 0x30323436,
	1, 0, 0, 0x00000c30, 0xffffffff, 0x22242628,
	1, 0, 1, 0x00000c34, 0xffffffff, 0x30323436,
	1, 0, 1, 0x00000c38, 0xffffffff, 0x22242628,
	1, 0, 0, 0x00000c3c, 0xffffffff, 0x30323436,
	1, 0, 0, 0x00000c40, 0xffffffff, 0x22242628,
	1, 0, 0, 0x00000c44, 0xffffffff, 0x34361820,
	1, 0, 1, 0x00000c48, 0xffffffff, 0x26283032,
	1, 0, 1, 0x00000c4c, 0xffffffff, 0x18202224,
	1, 1, 0, 0x00000e24, 0xffffffff, 0x32343638,
	1, 1, 0, 0x00000e28, 0xffffffff, 0x24262830,
	1, 1, 0, 0x00000e2c, 0xffffffff, 0x30323436,
	1, 1, 0, 0x00000e30, 0xffffffff, 0x22242628,
	1, 1, 1, 0x00000e34, 0xffffffff, 0x30323436,
	1, 1, 1, 0x00000e38, 0xffffffff, 0x22242628,
	1, 1, 0, 0x00000e3c, 0xffffffff, 0x30323436,
	1, 1, 0, 0x00000e40, 0xffffffff, 0x22242628,
	1, 1, 0, 0x00000e44, 0xffffffff, 0x34361820,
	1, 1, 1, 0x00000e48, 0xffffffff, 0x26283032,
	1, 1, 1, 0x00000e4c, 0xffffffff, 0x18202224};

void odm_read_and_config_mp_8822b_phy_reg_pg_type12(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	u32 i = 0;
	u32 array_len = sizeof(array_mp_8822b_phy_reg_pg_type12) / sizeof(u32);
	u32 *array = array_mp_8822b_phy_reg_pg_type12;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	struct _ADAPTER	*adapter = p_dm_odm->adapter;
	HAL_DATA_TYPE	*p_hal_data = GET_HAL_DATA(adapter);

	PlatformZeroMemory(p_hal_data->BufOfLinesPwrByRate, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	p_hal_data->nLinesReadPwrByRate = array_len/6;
#endif

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> odm_read_and_config_mp_8822b_phy_reg_pg_type12\n"));

	p_dm_odm->phy_reg_pg_version = 1;
	p_dm_odm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32 v1 = array[i];
		u32 v2 = array[i + 1];
		u32 v3 = array[i + 2];
		u32 v4 = array[i + 3];
		u32 v5 = array[i + 4];
		u32 v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8822b(p_dm_odm, v1, v2, v3, v4, v5,
					       v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)p_hal_data->BufOfLinesPwrByRate[i/6], 100, "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		(v1 == 0?"2.4G":"  5G"), (v2 == 0?"A":"B"), (v3 == 0?"1Tx":"2Tx"), v4, v5, v6);
#endif
	}
}

/******************************************************************************
*                           phy_reg_pg_type15.TXT
******************************************************************************/

u32 array_mp_8822b_phy_reg_pg_type15[] = {
	0, 0, 0, 0x00000c20, 0xffffffff, 0x32343638,
	0, 0, 0, 0x00000c24, 0xffffffff, 0x36384042,
	0, 0, 0, 0x00000c28, 0xffffffff, 0x28303234,
	0, 0, 0, 0x00000c2c, 0xffffffff, 0x34363840,
	0, 0, 0, 0x00000c30, 0xffffffff, 0x26283032,
	0, 0, 1, 0x00000c34, 0xffffffff, 0x34363840,
	0, 0, 1, 0x00000c38, 0xffffffff, 0x26283032,
	0, 0, 0, 0x00000c3c, 0xffffffff, 0x34363840,
	0, 0, 0, 0x00000c40, 0xffffffff, 0x26283032,
	0, 0, 0, 0x00000c44, 0xffffffff, 0x38402224,
	0, 0, 1, 0x00000c48, 0xffffffff, 0x30323436,
	0, 0, 1, 0x00000c4c, 0xffffffff, 0x22242628,
	0, 1, 0, 0x00000e20, 0xffffffff, 0x32343638,
	0, 1, 0, 0x00000e24, 0xffffffff, 0x36384042,
	0, 1, 0, 0x00000e28, 0xffffffff, 0x28303234,
	0, 1, 0, 0x00000e2c, 0xffffffff, 0x34363840,
	0, 1, 0, 0x00000e30, 0xffffffff, 0x26283032,
	0, 1, 1, 0x00000e34, 0xffffffff, 0x34363840,
	0, 1, 1, 0x00000e38, 0xffffffff, 0x26283032,
	0, 1, 0, 0x00000e3c, 0xffffffff, 0x34363840,
	0, 1, 0, 0x00000e40, 0xffffffff, 0x26283032,
	0, 1, 0, 0x00000e44, 0xffffffff, 0x38402224,
	0, 1, 1, 0x00000e48, 0xffffffff, 0x30323436,
	0, 1, 1, 0x00000e4c, 0xffffffff, 0x22242628,
	1, 0, 0, 0x00000c24, 0xffffffff, 0x34363840,
	1, 0, 0, 0x00000c28, 0xffffffff, 0x26283032,
	1, 0, 0, 0x00000c2c, 0xffffffff, 0x32343638,
	1, 0, 0, 0x00000c30, 0xffffffff, 0x24262830,
	1, 0, 1, 0x00000c34, 0xffffffff, 0x32343638,
	1, 0, 1, 0x00000c38, 0xffffffff, 0x24262830,
	1, 0, 0, 0x00000c3c, 0xffffffff, 0x32343638,
	1, 0, 0, 0x00000c40, 0xffffffff, 0x24262830,
	1, 0, 0, 0x00000c44, 0xffffffff, 0x36382022,
	1, 0, 1, 0x00000c48, 0xffffffff, 0x28303234,
	1, 0, 1, 0x00000c4c, 0xffffffff, 0x20222426,
	1, 1, 0, 0x00000e24, 0xffffffff, 0x34363840,
	1, 1, 0, 0x00000e28, 0xffffffff, 0x26283032,
	1, 1, 0, 0x00000e2c, 0xffffffff, 0x32343638,
	1, 1, 0, 0x00000e30, 0xffffffff, 0x24262830,
	1, 1, 1, 0x00000e34, 0xffffffff, 0x32343638,
	1, 1, 1, 0x00000e38, 0xffffffff, 0x24262830,
	1, 1, 0, 0x00000e3c, 0xffffffff, 0x32343638,
	1, 1, 0, 0x00000e40, 0xffffffff, 0x24262830,
	1, 1, 0, 0x00000e44, 0xffffffff, 0x36382022,
	1, 1, 1, 0x00000e48, 0xffffffff, 0x28303234,
	1, 1, 1, 0x00000e4c, 0xffffffff, 0x20222426};

void odm_read_and_config_mp_8822b_phy_reg_pg_type15(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	u32 i = 0;
	u32 array_len = sizeof(array_mp_8822b_phy_reg_pg_type15) / sizeof(u32);
	u32 *array = array_mp_8822b_phy_reg_pg_type15;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	struct _ADAPTER	*adapter = p_dm_odm->adapter;
	HAL_DATA_TYPE	*p_hal_data = GET_HAL_DATA(adapter);

	PlatformZeroMemory(p_hal_data->BufOfLinesPwrByRate, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	p_hal_data->nLinesReadPwrByRate = array_len/6;
#endif

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> odm_read_and_config_mp_8822b_phy_reg_pg_type15\n"));

	p_dm_odm->phy_reg_pg_version = 1;
	p_dm_odm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32 v1 = array[i];
		u32 v2 = array[i + 1];
		u32 v3 = array[i + 2];
		u32 v4 = array[i + 3];
		u32 v5 = array[i + 4];
		u32 v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8822b(p_dm_odm, v1, v2, v3, v4, v5,
					       v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)p_hal_data->BufOfLinesPwrByRate[i/6], 100, "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		(v1 == 0?"2.4G":"  5G"), (v2 == 0?"A":"B"), (v3 == 0?"1Tx":"2Tx"), v4, v5, v6);
#endif
	}
}

/******************************************************************************
*                           phy_reg_pg_type16.TXT
******************************************************************************/

u32 array_mp_8822b_phy_reg_pg_type16[] = {
	0, 0, 0, 0x00000c20, 0xffffffff, 0x32343638,
	0, 0, 0, 0x00000c24, 0xffffffff, 0x36384042,
	0, 0, 0, 0x00000c28, 0xffffffff, 0x28303234,
	0, 0, 0, 0x00000c2c, 0xffffffff, 0x34363840,
	0, 0, 0, 0x00000c30, 0xffffffff, 0x26283032,
	0, 0, 1, 0x00000c34, 0xffffffff, 0x34363840,
	0, 0, 1, 0x00000c38, 0xffffffff, 0x26283032,
	0, 0, 0, 0x00000c3c, 0xffffffff, 0x34363840,
	0, 0, 0, 0x00000c40, 0xffffffff, 0x26283032,
	0, 0, 0, 0x00000c44, 0xffffffff, 0x38402224,
	0, 0, 1, 0x00000c48, 0xffffffff, 0x30323436,
	0, 0, 1, 0x00000c4c, 0xffffffff, 0x22242628,
	0, 1, 0, 0x00000e20, 0xffffffff, 0x32343638,
	0, 1, 0, 0x00000e24, 0xffffffff, 0x36384042,
	0, 1, 0, 0x00000e28, 0xffffffff, 0x28303234,
	0, 1, 0, 0x00000e2c, 0xffffffff, 0x34363840,
	0, 1, 0, 0x00000e30, 0xffffffff, 0x26283032,
	0, 1, 1, 0x00000e34, 0xffffffff, 0x34363840,
	0, 1, 1, 0x00000e38, 0xffffffff, 0x26283032,
	0, 1, 0, 0x00000e3c, 0xffffffff, 0x34363840,
	0, 1, 0, 0x00000e40, 0xffffffff, 0x26283032,
	0, 1, 0, 0x00000e44, 0xffffffff, 0x38402224,
	0, 1, 1, 0x00000e48, 0xffffffff, 0x30323436,
	0, 1, 1, 0x00000e4c, 0xffffffff, 0x22242628,
	1, 0, 0, 0x00000c24, 0xffffffff, 0x34363840,
	1, 0, 0, 0x00000c28, 0xffffffff, 0x26283032,
	1, 0, 0, 0x00000c2c, 0xffffffff, 0x32343638,
	1, 0, 0, 0x00000c30, 0xffffffff, 0x24262830,
	1, 0, 1, 0x00000c34, 0xffffffff, 0x32343638,
	1, 0, 1, 0x00000c38, 0xffffffff, 0x24262830,
	1, 0, 0, 0x00000c3c, 0xffffffff, 0x32343638,
	1, 0, 0, 0x00000c40, 0xffffffff, 0x24262830,
	1, 0, 0, 0x00000c44, 0xffffffff, 0x36382022,
	1, 0, 1, 0x00000c48, 0xffffffff, 0x28303234,
	1, 0, 1, 0x00000c4c, 0xffffffff, 0x20222426,
	1, 1, 0, 0x00000e24, 0xffffffff, 0x34363840,
	1, 1, 0, 0x00000e28, 0xffffffff, 0x26283032,
	1, 1, 0, 0x00000e2c, 0xffffffff, 0x32343638,
	1, 1, 0, 0x00000e30, 0xffffffff, 0x24262830,
	1, 1, 1, 0x00000e34, 0xffffffff, 0x32343638,
	1, 1, 1, 0x00000e38, 0xffffffff, 0x24262830,
	1, 1, 0, 0x00000e3c, 0xffffffff, 0x32343638,
	1, 1, 0, 0x00000e40, 0xffffffff, 0x24262830,
	1, 1, 0, 0x00000e44, 0xffffffff, 0x36382022,
	1, 1, 1, 0x00000e48, 0xffffffff, 0x28303234,
	1, 1, 1, 0x00000e4c, 0xffffffff, 0x20222426};

void odm_read_and_config_mp_8822b_phy_reg_pg_type16(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	u32 i = 0;
	u32 array_len = sizeof(array_mp_8822b_phy_reg_pg_type16) / sizeof(u32);
	u32 *array = array_mp_8822b_phy_reg_pg_type16;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	struct _ADAPTER	*adapter = p_dm_odm->adapter;
	HAL_DATA_TYPE	*p_hal_data = GET_HAL_DATA(adapter);

	PlatformZeroMemory(p_hal_data->BufOfLinesPwrByRate, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	p_hal_data->nLinesReadPwrByRate = array_len/6;
#endif

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> odm_read_and_config_mp_8822b_phy_reg_pg_type16\n"));

	p_dm_odm->phy_reg_pg_version = 1;
	p_dm_odm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32 v1 = array[i];
		u32 v2 = array[i + 1];
		u32 v3 = array[i + 2];
		u32 v4 = array[i + 3];
		u32 v5 = array[i + 4];
		u32 v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8822b(p_dm_odm, v1, v2, v3, v4, v5,
					       v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)p_hal_data->BufOfLinesPwrByRate[i/6], 100, "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		(v1 == 0?"2.4G":"  5G"), (v2 == 0?"A":"B"), (v3 == 0?"1Tx":"2Tx"), v4, v5, v6);
#endif
	}
}

/******************************************************************************
*                           phy_reg_pg_type2.TXT
******************************************************************************/

u32 array_mp_8822b_phy_reg_pg_type2[] = {
	0, 0, 0, 0x00000c20, 0xffffffff, 0x32343638,
	0, 0, 0, 0x00000c24, 0xffffffff, 0x36384042,
	0, 0, 0, 0x00000c28, 0xffffffff, 0x28303234,
	0, 0, 0, 0x00000c2c, 0xffffffff, 0x34363840,
	0, 0, 0, 0x00000c30, 0xffffffff, 0x26283032,
	0, 0, 1, 0x00000c34, 0xffffffff, 0x34363840,
	0, 0, 1, 0x00000c38, 0xffffffff, 0x26283032,
	0, 0, 0, 0x00000c3c, 0xffffffff, 0x34363840,
	0, 0, 0, 0x00000c40, 0xffffffff, 0x26283032,
	0, 0, 0, 0x00000c44, 0xffffffff, 0x38402224,
	0, 0, 1, 0x00000c48, 0xffffffff, 0x30323436,
	0, 0, 1, 0x00000c4c, 0xffffffff, 0x22242628,
	0, 1, 0, 0x00000e20, 0xffffffff, 0x32343638,
	0, 1, 0, 0x00000e24, 0xffffffff, 0x36384042,
	0, 1, 0, 0x00000e28, 0xffffffff, 0x28303234,
	0, 1, 0, 0x00000e2c, 0xffffffff, 0x34363840,
	0, 1, 0, 0x00000e30, 0xffffffff, 0x26283032,
	0, 1, 1, 0x00000e34, 0xffffffff, 0x34363840,
	0, 1, 1, 0x00000e38, 0xffffffff, 0x26283032,
	0, 1, 0, 0x00000e3c, 0xffffffff, 0x34363840,
	0, 1, 0, 0x00000e40, 0xffffffff, 0x26283032,
	0, 1, 0, 0x00000e44, 0xffffffff, 0x38402224,
	0, 1, 1, 0x00000e48, 0xffffffff, 0x30323436,
	0, 1, 1, 0x00000e4c, 0xffffffff, 0x22242628,
	1, 0, 0, 0x00000c24, 0xffffffff, 0x40424446,
	1, 0, 0, 0x00000c28, 0xffffffff, 0x32343638,
	1, 0, 0, 0x00000c2c, 0xffffffff, 0x38404244,
	1, 0, 0, 0x00000c30, 0xffffffff, 0x30323436,
	1, 0, 1, 0x00000c34, 0xffffffff, 0x38404244,
	1, 0, 1, 0x00000c38, 0xffffffff, 0x30323436,
	1, 0, 0, 0x00000c3c, 0xffffffff, 0x38404244,
	1, 0, 0, 0x00000c40, 0xffffffff, 0x30323436,
	1, 0, 0, 0x00000c44, 0xffffffff, 0x42442628,
	1, 0, 1, 0x00000c48, 0xffffffff, 0x34363840,
	1, 0, 1, 0x00000c4c, 0xffffffff, 0x26283032,
	1, 1, 0, 0x00000e24, 0xffffffff, 0x40424446,
	1, 1, 0, 0x00000e28, 0xffffffff, 0x32343638,
	1, 1, 0, 0x00000e2c, 0xffffffff, 0x38404244,
	1, 1, 0, 0x00000e30, 0xffffffff, 0x30323436,
	1, 1, 1, 0x00000e34, 0xffffffff, 0x38404244,
	1, 1, 1, 0x00000e38, 0xffffffff, 0x30323436,
	1, 1, 0, 0x00000e3c, 0xffffffff, 0x38404244,
	1, 1, 0, 0x00000e40, 0xffffffff, 0x30323436,
	1, 1, 0, 0x00000e44, 0xffffffff, 0x42442628,
	1, 1, 1, 0x00000e48, 0xffffffff, 0x34363840,
	1, 1, 1, 0x00000e4c, 0xffffffff, 0x26283032};

void odm_read_and_config_mp_8822b_phy_reg_pg_type2(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	u32 i = 0;
	u32 array_len = sizeof(array_mp_8822b_phy_reg_pg_type2) / sizeof(u32);
	u32 *array = array_mp_8822b_phy_reg_pg_type2;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	struct _ADAPTER	*adapter = p_dm_odm->adapter;
	HAL_DATA_TYPE	*p_hal_data = GET_HAL_DATA(adapter);

	PlatformZeroMemory(p_hal_data->BufOfLinesPwrByRate, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	p_hal_data->nLinesReadPwrByRate = array_len/6;
#endif

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> odm_read_and_config_mp_8822b_phy_reg_pg_type2\n"));

	p_dm_odm->phy_reg_pg_version = 1;
	p_dm_odm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32 v1 = array[i];
		u32 v2 = array[i + 1];
		u32 v3 = array[i + 2];
		u32 v4 = array[i + 3];
		u32 v5 = array[i + 4];
		u32 v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8822b(p_dm_odm, v1, v2, v3, v4, v5,
					       v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)p_hal_data->BufOfLinesPwrByRate[i/6], 100, "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		(v1 == 0?"2.4G":"  5G"), (v2 == 0?"A":"B"), (v3 == 0?"1Tx":"2Tx"), v4, v5, v6);
#endif
	}
}

/******************************************************************************
*                           phy_reg_pg_type3.TXT
******************************************************************************/

u32 array_mp_8822b_phy_reg_pg_type3[] = {
	0, 0, 0, 0x00000c20, 0xffffffff, 0x32343638,
	0, 0, 0, 0x00000c24, 0xffffffff, 0x36384042,
	0, 0, 0, 0x00000c28, 0xffffffff, 0x28303234,
	0, 0, 0, 0x00000c2c, 0xffffffff, 0x34363840,
	0, 0, 0, 0x00000c30, 0xffffffff, 0x26283032,
	0, 0, 1, 0x00000c34, 0xffffffff, 0x34363840,
	0, 0, 1, 0x00000c38, 0xffffffff, 0x26283032,
	0, 0, 0, 0x00000c3c, 0xffffffff, 0x34363840,
	0, 0, 0, 0x00000c40, 0xffffffff, 0x26283032,
	0, 0, 0, 0x00000c44, 0xffffffff, 0x38402224,
	0, 0, 1, 0x00000c48, 0xffffffff, 0x30323436,
	0, 0, 1, 0x00000c4c, 0xffffffff, 0x22242628,
	0, 1, 0, 0x00000e20, 0xffffffff, 0x32343638,
	0, 1, 0, 0x00000e24, 0xffffffff, 0x36384042,
	0, 1, 0, 0x00000e28, 0xffffffff, 0x28303234,
	0, 1, 0, 0x00000e2c, 0xffffffff, 0x34363840,
	0, 1, 0, 0x00000e30, 0xffffffff, 0x26283032,
	0, 1, 1, 0x00000e34, 0xffffffff, 0x34363840,
	0, 1, 1, 0x00000e38, 0xffffffff, 0x26283032,
	0, 1, 0, 0x00000e3c, 0xffffffff, 0x34363840,
	0, 1, 0, 0x00000e40, 0xffffffff, 0x26283032,
	0, 1, 0, 0x00000e44, 0xffffffff, 0x38402224,
	0, 1, 1, 0x00000e48, 0xffffffff, 0x30323436,
	0, 1, 1, 0x00000e4c, 0xffffffff, 0x22242628,
	1, 0, 0, 0x00000c24, 0xffffffff, 0x34363840,
	1, 0, 0, 0x00000c28, 0xffffffff, 0x26283032,
	1, 0, 0, 0x00000c2c, 0xffffffff, 0x32343638,
	1, 0, 0, 0x00000c30, 0xffffffff, 0x24262830,
	1, 0, 1, 0x00000c34, 0xffffffff, 0x32343638,
	1, 0, 1, 0x00000c38, 0xffffffff, 0x24262830,
	1, 0, 0, 0x00000c3c, 0xffffffff, 0x32343638,
	1, 0, 0, 0x00000c40, 0xffffffff, 0x24262830,
	1, 0, 0, 0x00000c44, 0xffffffff, 0x36382022,
	1, 0, 1, 0x00000c48, 0xffffffff, 0x28303234,
	1, 0, 1, 0x00000c4c, 0xffffffff, 0x20222426,
	1, 1, 0, 0x00000e24, 0xffffffff, 0x34363840,
	1, 1, 0, 0x00000e28, 0xffffffff, 0x26283032,
	1, 1, 0, 0x00000e2c, 0xffffffff, 0x32343638,
	1, 1, 0, 0x00000e30, 0xffffffff, 0x24262830,
	1, 1, 1, 0x00000e34, 0xffffffff, 0x32343638,
	1, 1, 1, 0x00000e38, 0xffffffff, 0x24262830,
	1, 1, 0, 0x00000e3c, 0xffffffff, 0x32343638,
	1, 1, 0, 0x00000e40, 0xffffffff, 0x24262830,
	1, 1, 0, 0x00000e44, 0xffffffff, 0x36382022,
	1, 1, 1, 0x00000e48, 0xffffffff, 0x28303234,
	1, 1, 1, 0x00000e4c, 0xffffffff, 0x20222426};

void odm_read_and_config_mp_8822b_phy_reg_pg_type3(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	u32 i = 0;
	u32 array_len = sizeof(array_mp_8822b_phy_reg_pg_type3) / sizeof(u32);
	u32 *array = array_mp_8822b_phy_reg_pg_type3;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	struct _ADAPTER	*adapter = p_dm_odm->adapter;
	HAL_DATA_TYPE	*p_hal_data = GET_HAL_DATA(adapter);

	PlatformZeroMemory(p_hal_data->BufOfLinesPwrByRate, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	p_hal_data->nLinesReadPwrByRate = array_len/6;
#endif

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> odm_read_and_config_mp_8822b_phy_reg_pg_type3\n"));

	p_dm_odm->phy_reg_pg_version = 1;
	p_dm_odm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32 v1 = array[i];
		u32 v2 = array[i + 1];
		u32 v3 = array[i + 2];
		u32 v4 = array[i + 3];
		u32 v5 = array[i + 4];
		u32 v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8822b(p_dm_odm, v1, v2, v3, v4, v5,
					       v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)p_hal_data->BufOfLinesPwrByRate[i/6], 100, "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		(v1 == 0?"2.4G":"  5G"), (v2 == 0?"A":"B"), (v3 == 0?"1Tx":"2Tx"), v4, v5, v6);
#endif
	}
}

/******************************************************************************
*                           phy_reg_pg_type4.TXT
******************************************************************************/

u32 array_mp_8822b_phy_reg_pg_type4[] = {
	0, 0, 0, 0x00000c20, 0xffffffff, 0x38404244,
	0, 0, 0, 0x00000c24, 0xffffffff, 0x42444648,
	0, 0, 0, 0x00000c28, 0xffffffff, 0x34363840,
	0, 0, 0, 0x00000c2c, 0xffffffff, 0x40424446,
	0, 0, 0, 0x00000c30, 0xffffffff, 0x32343638,
	0, 0, 1, 0x00000c34, 0xffffffff, 0x40424446,
	0, 0, 1, 0x00000c38, 0xffffffff, 0x32343638,
	0, 0, 0, 0x00000c3c, 0xffffffff, 0x40424446,
	0, 0, 0, 0x00000c40, 0xffffffff, 0x32343638,
	0, 0, 0, 0x00000c44, 0xffffffff, 0x44462830,
	0, 0, 1, 0x00000c48, 0xffffffff, 0x36384042,
	0, 0, 1, 0x00000c4c, 0xffffffff, 0x28303234,
	0, 1, 0, 0x00000e20, 0xffffffff, 0x38404244,
	0, 1, 0, 0x00000e24, 0xffffffff, 0x42444648,
	0, 1, 0, 0x00000e28, 0xffffffff, 0x34363840,
	0, 1, 0, 0x00000e2c, 0xffffffff, 0x40424446,
	0, 1, 0, 0x00000e30, 0xffffffff, 0x32343638,
	0, 1, 1, 0x00000e34, 0xffffffff, 0x40424446,
	0, 1, 1, 0x00000e38, 0xffffffff, 0x32343638,
	0, 1, 0, 0x00000e3c, 0xffffffff, 0x40424446,
	0, 1, 0, 0x00000e40, 0xffffffff, 0x32343638,
	0, 1, 0, 0x00000e44, 0xffffffff, 0x44462830,
	0, 1, 1, 0x00000e48, 0xffffffff, 0x36384042,
	0, 1, 1, 0x00000e4c, 0xffffffff, 0x28303234,
	1, 0, 0, 0x00000c24, 0xffffffff, 0x40424446,
	1, 0, 0, 0x00000c28, 0xffffffff, 0x32343638,
	1, 0, 0, 0x00000c2c, 0xffffffff, 0x38404244,
	1, 0, 0, 0x00000c30, 0xffffffff, 0x30323436,
	1, 0, 1, 0x00000c34, 0xffffffff, 0x38404244,
	1, 0, 1, 0x00000c38, 0xffffffff, 0x30323436,
	1, 0, 0, 0x00000c3c, 0xffffffff, 0x38404244,
	1, 0, 0, 0x00000c40, 0xffffffff, 0x30323436,
	1, 0, 0, 0x00000c44, 0xffffffff, 0x42442628,
	1, 0, 1, 0x00000c48, 0xffffffff, 0x34363840,
	1, 0, 1, 0x00000c4c, 0xffffffff, 0x26283032,
	1, 1, 0, 0x00000e24, 0xffffffff, 0x40424446,
	1, 1, 0, 0x00000e28, 0xffffffff, 0x32343638,
	1, 1, 0, 0x00000e2c, 0xffffffff, 0x38404244,
	1, 1, 0, 0x00000e30, 0xffffffff, 0x30323436,
	1, 1, 1, 0x00000e34, 0xffffffff, 0x38404244,
	1, 1, 1, 0x00000e38, 0xffffffff, 0x30323436,
	1, 1, 0, 0x00000e3c, 0xffffffff, 0x38404244,
	1, 1, 0, 0x00000e40, 0xffffffff, 0x30323436,
	1, 1, 0, 0x00000e44, 0xffffffff, 0x42442628,
	1, 1, 1, 0x00000e48, 0xffffffff, 0x34363840,
	1, 1, 1, 0x00000e4c, 0xffffffff, 0x26283032};

void odm_read_and_config_mp_8822b_phy_reg_pg_type4(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	u32 i = 0;
	u32 array_len = sizeof(array_mp_8822b_phy_reg_pg_type4) / sizeof(u32);
	u32 *array = array_mp_8822b_phy_reg_pg_type4;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	struct _ADAPTER	*adapter = p_dm_odm->adapter;
	HAL_DATA_TYPE	*p_hal_data = GET_HAL_DATA(adapter);

	PlatformZeroMemory(p_hal_data->BufOfLinesPwrByRate, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	p_hal_data->nLinesReadPwrByRate = array_len/6;
#endif

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> odm_read_and_config_mp_8822b_phy_reg_pg_type4\n"));

	p_dm_odm->phy_reg_pg_version = 1;
	p_dm_odm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32 v1 = array[i];
		u32 v2 = array[i + 1];
		u32 v3 = array[i + 2];
		u32 v4 = array[i + 3];
		u32 v5 = array[i + 4];
		u32 v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8822b(p_dm_odm, v1, v2, v3, v4, v5,
					       v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)p_hal_data->BufOfLinesPwrByRate[i/6], 100, "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		(v1 == 0?"2.4G":"  5G"), (v2 == 0?"A":"B"), (v3 == 0?"1Tx":"2Tx"), v4, v5, v6);
#endif
	}
}

/******************************************************************************
*                           phy_reg_pg_type5.TXT
******************************************************************************/

u32 array_mp_8822b_phy_reg_pg_type5[] = {
	0, 0, 0, 0x00000c20, 0xffffffff, 0x32343638,
	0, 0, 0, 0x00000c24, 0xffffffff, 0x36384042,
	0, 0, 0, 0x00000c28, 0xffffffff, 0x28303234,
	0, 0, 0, 0x00000c2c, 0xffffffff, 0x34363840,
	0, 0, 0, 0x00000c30, 0xffffffff, 0x26283032,
	0, 0, 1, 0x00000c34, 0xffffffff, 0x34363840,
	0, 0, 1, 0x00000c38, 0xffffffff, 0x26283032,
	0, 0, 0, 0x00000c3c, 0xffffffff, 0x34363840,
	0, 0, 0, 0x00000c40, 0xffffffff, 0x26283032,
	0, 0, 0, 0x00000c44, 0xffffffff, 0x38402224,
	0, 0, 1, 0x00000c48, 0xffffffff, 0x30323436,
	0, 0, 1, 0x00000c4c, 0xffffffff, 0x22242628,
	0, 1, 0, 0x00000e20, 0xffffffff, 0x32343638,
	0, 1, 0, 0x00000e24, 0xffffffff, 0x36384042,
	0, 1, 0, 0x00000e28, 0xffffffff, 0x28303234,
	0, 1, 0, 0x00000e2c, 0xffffffff, 0x34363840,
	0, 1, 0, 0x00000e30, 0xffffffff, 0x26283032,
	0, 1, 1, 0x00000e34, 0xffffffff, 0x34363840,
	0, 1, 1, 0x00000e38, 0xffffffff, 0x26283032,
	0, 1, 0, 0x00000e3c, 0xffffffff, 0x34363840,
	0, 1, 0, 0x00000e40, 0xffffffff, 0x26283032,
	0, 1, 0, 0x00000e44, 0xffffffff, 0x38402224,
	0, 1, 1, 0x00000e48, 0xffffffff, 0x30323436,
	0, 1, 1, 0x00000e4c, 0xffffffff, 0x22242628,
	1, 0, 0, 0x00000c24, 0xffffffff, 0x34363840,
	1, 0, 0, 0x00000c28, 0xffffffff, 0x26283032,
	1, 0, 0, 0x00000c2c, 0xffffffff, 0x32343638,
	1, 0, 0, 0x00000c30, 0xffffffff, 0x24262830,
	1, 0, 1, 0x00000c34, 0xffffffff, 0x32343638,
	1, 0, 1, 0x00000c38, 0xffffffff, 0x24262830,
	1, 0, 0, 0x00000c3c, 0xffffffff, 0x32343638,
	1, 0, 0, 0x00000c40, 0xffffffff, 0x24262830,
	1, 0, 0, 0x00000c44, 0xffffffff, 0x36382022,
	1, 0, 1, 0x00000c48, 0xffffffff, 0x28303234,
	1, 0, 1, 0x00000c4c, 0xffffffff, 0x20222426,
	1, 1, 0, 0x00000e24, 0xffffffff, 0x34363840,
	1, 1, 0, 0x00000e28, 0xffffffff, 0x26283032,
	1, 1, 0, 0x00000e2c, 0xffffffff, 0x32343638,
	1, 1, 0, 0x00000e30, 0xffffffff, 0x24262830,
	1, 1, 1, 0x00000e34, 0xffffffff, 0x32343638,
	1, 1, 1, 0x00000e38, 0xffffffff, 0x24262830,
	1, 1, 0, 0x00000e3c, 0xffffffff, 0x32343638,
	1, 1, 0, 0x00000e40, 0xffffffff, 0x24262830,
	1, 1, 0, 0x00000e44, 0xffffffff, 0x36382022,
	1, 1, 1, 0x00000e48, 0xffffffff, 0x28303234,
	1, 1, 1, 0x00000e4c, 0xffffffff, 0x20222426};

void odm_read_and_config_mp_8822b_phy_reg_pg_type5(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	u32 i = 0;
	u32 array_len = sizeof(array_mp_8822b_phy_reg_pg_type5) / sizeof(u32);
	u32 *array = array_mp_8822b_phy_reg_pg_type5;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	struct _ADAPTER	*adapter = p_dm_odm->adapter;
	HAL_DATA_TYPE	*p_hal_data = GET_HAL_DATA(adapter);

	PlatformZeroMemory(p_hal_data->BufOfLinesPwrByRate, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	p_hal_data->nLinesReadPwrByRate = array_len/6;
#endif

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> odm_read_and_config_mp_8822b_phy_reg_pg_type5\n"));

	p_dm_odm->phy_reg_pg_version = 1;
	p_dm_odm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32 v1 = array[i];
		u32 v2 = array[i + 1];
		u32 v3 = array[i + 2];
		u32 v4 = array[i + 3];
		u32 v5 = array[i + 4];
		u32 v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8822b(p_dm_odm, v1, v2, v3, v4, v5,
					       v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)p_hal_data->BufOfLinesPwrByRate[i/6], 100, "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		(v1 == 0?"2.4G":"  5G"), (v2 == 0?"A":"B"), (v3 == 0?"1Tx":"2Tx"), v4, v5, v6);
#endif
	}
}

#endif /* end of HWIMG_SUPPORT*/

