/******************************************************************************
 *
 * Copyright(c) 2007 - 2017  Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/

/*Image2HeaderVersion: R2 1.2.1*/
#include "mp_precomp.h"
#include "../phydm_precomp.h"

#if (RTL8822B_SUPPORT == 1)
static boolean check_positive(struct PHY_DM_STRUCT *p_dm_odm,
			      const u32 condition1, const u32 condition2,
			      const u32 condition3, const u32 condition4)
{
	u32 cond1 = condition1, cond2 = condition2, cond3 = condition3,
	    cond4 = condition4;

	u8 cut_version_for_para = (p_dm_odm->cut_version == ODM_CUT_A) ?
					  15 :
					  p_dm_odm->cut_version;
	u8 pkg_type_for_para =
		(p_dm_odm->package_type == 0) ? 15 : p_dm_odm->package_type;

	u32 driver1 =
		cut_version_for_para << 24 |
		(p_dm_odm->support_interface & 0xF0) << 16 |
		p_dm_odm->support_platform << 16 | pkg_type_for_para << 12 |
		(p_dm_odm->support_interface & 0x0F) << 8 | p_dm_odm->rfe_type;

	u32 driver2 = (p_dm_odm->type_glna & 0xFF) << 0 |
		      (p_dm_odm->type_gpa & 0xFF) << 8 |
		      (p_dm_odm->type_alna & 0xFF) << 16 |
		      (p_dm_odm->type_apa & 0xFF) << 24;

	u32 driver3 = 0;

	u32 driver4 = (p_dm_odm->type_glna & 0xFF00) >> 8 |
		      (p_dm_odm->type_gpa & 0xFF00) |
		      (p_dm_odm->type_alna & 0xFF00) << 8 |
		      (p_dm_odm->type_apa & 0xFF00) << 16;

	ODM_RT_TRACE(
		p_dm_odm, ODM_COMP_INIT, ODM_DBG_TRACE,
		("===> check_positive (cond1, cond2, cond3, cond4) = (0x%X 0x%X 0x%X 0x%X)\n",
		 cond1, cond2, cond3, cond4));
	ODM_RT_TRACE(
		p_dm_odm, ODM_COMP_INIT, ODM_DBG_TRACE,
		("===> check_positive (driver1, driver2, driver3, driver4) = (0x%X 0x%X 0x%X 0x%X)\n",
		 driver1, driver2, driver3, driver4));

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_TRACE,
		     ("	(Platform, Interface) = (0x%X, 0x%X)\n",
		      p_dm_odm->support_platform, p_dm_odm->support_interface));
	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_TRACE,
		     ("	(RFE, Package) = (0x%X, 0x%X)\n",
		      p_dm_odm->rfe_type, p_dm_odm->package_type));

	/*============== value Defined Check ===============*/
	/*cut version [27:24] need to do value check*/

	if (((cond1 & 0x0F000000) != 0) &&
	    ((cond1 & 0x0F000000) != (driver1 & 0x0F000000)))
		return false;

	/*pkg type [15:12] need to do value check*/

	if (((cond1 & 0x0000F000) != 0) &&
	    ((cond1 & 0x0000F000) != (driver1 & 0x0000F000)))
		return false;

	/*=============== Bit Defined Check ================*/
	/* We don't care [31:28] */

	cond1 &= 0x000000FF;
	driver1 &= 0x000000FF;

	if (cond1 == driver1)
		return true;
	else
		return false;
}

/******************************************************************************
*                           radioa.TXT
******************************************************************************/

u32 array_mp_8822b_radioa[] = {
	BBREG_0x000, 0x00030000,  0x83000001,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x001, 0x0004002D,  0x93000002,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x001, 0x00040029,  0x93000003,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x001, 0x00040029,
	0x93000004,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x001,
	0x0004002D,  0x93000005,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x001, 0x00040029,  0x93000006,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x001, 0x0004002D,  0x93000007,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x001, 0x0004002D,  0x93000008,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x001, 0x00040029,
	0x93000009,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x001,
	0x00040029,  0x9300000a,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x001, 0x00040029,  0x9300000b,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x001, 0x00040029,  0x9300000c,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x001, 0x00040029,  0x9300000f,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x001, 0x00040029,
	0x93000010,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x001,
	0x00040029,  0x90000001,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x001, 0x0004002D,  0x90000002,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x001, 0x00040029,  0x90000003,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x001, 0x00040029,  0x90000004,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x001, 0x0004002D,
	0x90000005,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x001,
	0x00040029,  0x90000006,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x001, 0x0004002D,  0x90000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x001, 0x0004002D,  0xA0000000,  0x00000000,
	BBREG_0x001, 0x00040029,  0xB0000000,  0x00000000,  BBREG_0x018,
	0x00010D24,  BBREG_0x0ef, 0x00080000,  BBREG_0x033, 0x00000002,
	BBREG_0x03e, 0x0000003F,  0x8300000c,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03f, 0x000D0F4E,  0xA0000000,  0x00000000,
	BBREG_0x03f, 0x000C0F4E,  0xB0000000,  0x00000000,  BBREG_0x033,
	0x00000001,  BBREG_0x03e, 0x00000034,  BBREG_0x03f, 0x0004080E,
	BBREG_0x0ef, 0x00080000,  BBREG_0x0df, 0x00002449,  BBREG_0x033,
	0x00000024,  BBREG_0x03e, 0x0000003F,  BBREG_0x03f, 0x00060FDE,
	BBREG_0x0ef, 0x00000000,  BBREG_0x0ef, 0x00080000,  BBREG_0x033,
	0x00000025,  BBREG_0x03e, 0x00000037,  BBREG_0x03f, 0x0007EFCE,
	BBREG_0x0ef, 0x00000000,  BBREG_0x0ef, 0x00080000,  BBREG_0x033,
	0x00000026,  BBREG_0x03e, 0x00000037,  BBREG_0x03f, 0x000DEFCE,
	BBREG_0x0ef, 0x00000000,  BBREG_0x07f, 0x00000000,  0x83000000,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x0b0, 0x000FF0F8,
	0x93000001,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x0b0,
	0x000FF0F8,  0x93000002,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x0b0, 0x000FB0F8,  0x93000003,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0b0, 0x000FB0F8,  0x93000004,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x0b0, 0x000FB0F8,  0x93000005,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x0b0, 0x000FB0F8,
	0x93000006,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x0b0,
	0x000FF0F8,  0x93000007,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x0b0, 0x000FF0F8,  0x93000008,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0b0, 0x000FB0F8,  0x93000009,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x0b0, 0x000FF0F8,  0x9300000a,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x0b0, 0x000FF0F8,
	0x9300000b,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x0b0,
	0x000FB0F8,  0x9300000c,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x0b0, 0x000FB0F8,  0x9300000d,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0b0, 0x000FF0F8,  0x9300000e,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x0b0, 0x000FF0F8,  0x9300000f,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x0b0, 0x000FB0F8,
	0x93000010,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x0b0,
	0x000FB0F8,  0x90000001,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x0b0, 0x000FF0F8,  0x90000002,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0b0, 0x000FB0F8,  0x90000003,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x0b0, 0x000FB0F8,  0x90000004,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x0b0, 0x000FB0F8,
	0x90000005,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x0b0,
	0x000FB0F8,  0x90000006,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x0b0, 0x000FF0F8,  0x90000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0b0, 0x000FF0F8,  0xA0000000,  0x00000000,
	BBREG_0x0b0, 0x000FF0F8,  0xB0000000,  0x00000000,  BBREG_0x0b1,
	0x0007DBE4,  BBREG_0x0b2, 0x000225D1,  0x83000001,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x0b3, 0x000FC760,  0x93000002,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x0b3, 0x000FC760,
	0x93000004,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x0b3,
	0x000FC760,  0x93000005,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x0b3, 0x0007C330,  0x93000006,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0b3, 0x000FC760,  0x93000007,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x0b3, 0x000FC760,  0x93000008,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x0b3, 0x000FC760,
	0x9300000b,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x0b3,
	0x000FC760,  0x90000001,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x0b3, 0x000FC760,  0x90000004,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0b3, 0x000FC760,  0x90000006,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x0b3, 0x000FC760,  0x90000007,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x0b3, 0x000FC760,
	0xA0000000,  0x00000000,  BBREG_0x0b3, 0x000FC760,  0xB0000000,
	0x00000000,  BBREG_0x0b4, 0x00099DD0,  BBREG_0x0b5, 0x000400FC,
	BBREG_0x0b6, 0x000187F0,  BBREG_0x0b7, 0x00030018,  BBREG_0x0b8,
	0x00080800,  BBREG_0x0b9, 0x00000000,  BBREG_0x0ba, 0x00008000,
	BBREG_0x0bb, 0x00000000,  BBREG_0x0bc, 0x00040030,  BBREG_0x0bd,
	0x00000000,  BBREG_0x0be, 0x00000000,  BBREG_0x0bf, 0x00000000,
	BBREG_0x0c0, 0x00000000,  BBREG_0x0c1, 0x00000000,  BBREG_0x0c2,
	0x00000000,  BBREG_0x0c3, 0x00000000,  BBREG_0x0c4, 0x00002402,
	BBREG_0x0c5, 0x00000009,  BBREG_0x0c6, 0x00040299,  BBREG_0x0c7,
	0x00055555,  BBREG_0x0c8, 0x0000C16C,  BBREG_0x0c9, 0x0001C146,
	BBREG_0x0ca, 0x00000000,  BBREG_0x0cb, 0x00000000,  BBREG_0x0cc,
	0x00000000,  BBREG_0x0cd, 0x00000000,  BBREG_0x0ce, 0x00090C00,
	BBREG_0x0cf, 0x0006D200,  BBREG_0x0df, 0x00000009,  BBREG_0x018,
	0x00010524,  BBREG_0x089, 0x00000207,  0x83000001,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x08a, 0x000FF186,  0x93000002,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x08a, 0x000FF186,
	0x93000004,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x08a,
	0x000FF186,  0x93000005,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x08a, 0x000FE186,  0x93000006,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x08a, 0x000FE186,  0x93000007,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x08a, 0x000FF186,  0x93000008,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x08a, 0x000FF186,
	0x9300000b,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x08a,
	0x000FF186,  0x90000001,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x08a, 0x000FF186,  0x90000004,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x08a, 0x000FF186,  0x90000006,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x08a, 0x000FE186,  0x90000007,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x08a, 0x000FF186,
	0xA0000000,  0x00000000,  BBREG_0x08a, 0x000FF186,  0xB0000000,
	0x00000000,  BBREG_0x08b, 0x00061E3C,  BBREG_0x08c, 0x000112C7,
	BBREG_0x08d, 0x000F4988,  BBREG_0x08e, 0x00064D40,  BBREG_0x0ef,
	0x00020000,  BBREG_0x033, 0x00000007,  0x83000000,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00004000,  0x93000001,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004040,
	0x93000002,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x00004040,  0x93000004,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00004040,  0x93000005,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00004000,  0x93000006,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00004080,  0x93000007,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004040,
	0x93000008,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x00004000,  0x93000009,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00004040,  0x9300000a,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00004000,  0x9300000b,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00004040,  0x9300000d,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004000,
	0x9300000e,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x00004000,  0x90000001,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00004040,  0x90000002,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00004040,  0x90000004,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00004040,  0x90000006,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004040,
	0x90000007,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x00004040,  0xA0000000,  0x00000000,  BBREG_0x03e, 0x00004000,
	0xB0000000,  0x00000000,  0x83000000,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03f, 0x000C3186,  0x93000001,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03f, 0x000C3186,  0x93000002,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f, 0x000C3186,
	0x93000003,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f,
	0x000C0006,  0x93000004,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03f, 0x000C3186,  0x93000005,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03f, 0x000DFF86,  0x93000006,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03f, 0x000C3186,  0x93000007,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f, 0x000C3186,
	0x93000008,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f,
	0x000C3186,  0x93000009,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03f, 0x000C3186,  0x9300000a,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03f, 0x000C3186,  0x9300000b,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03f, 0x000C3186,  0x9300000c,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f, 0x000C0006,
	0x9300000d,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f,
	0x000C3186,  0x9300000e,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03f, 0x000DFF86,  0x9300000f,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03f, 0x000C0006,  0x93000010,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03f, 0x000C0006,  0x90000001,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f, 0x000C3186,
	0x90000002,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f,
	0x000C3186,  0x90000004,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03f, 0x000C3186,  0x90000006,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03f, 0x000C3186,  0x90000007,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03f, 0x000C3186,  0xA0000000,
	0x00000000,  BBREG_0x03f, 0x000C3186,  0xB0000000,  0x00000000,
	BBREG_0x033, 0x00000006,  0x83000001,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00004080,  0x93000004,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00004080,  0x93000006,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004080,
	0x93000007,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x00004080,  0x9300000b,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00004080,  0x90000006,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00004040,  0x90000007,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00004080,  0xA0000000,
	0x00000000,  BBREG_0x03e, 0x00004080,  0xB0000000,  0x00000000,
	BBREG_0x03f, 0x000C3186,  BBREG_0x033, 0x00000005,  0x83000001,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x000040C8,
	0x93000004,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x000040C8,  0x93000006,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x000040C8,  0x93000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x000040C8,  0x9300000b,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x000040C8,  0x90000006,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004084,
	0x90000007,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x000040C8,  0xA0000000,  0x00000000,  BBREG_0x03e, 0x000040C8,
	0xB0000000,  0x00000000,  BBREG_0x03f, 0x000C3186,  BBREG_0x033,
	0x00000004,  0x83000001,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00004190,  0x93000004,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00004190,  0x93000006,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00004190,  0x93000007,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004190,
	0x9300000b,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x00004190,  0x90000006,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00004108,  0x90000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00004190,  0xA0000000,  0x00000000,
	BBREG_0x03e, 0x00004190,  0xB0000000,  0x00000000,  BBREG_0x03f,
	0x000C3186,  BBREG_0x033, 0x00000003,  0x83000001,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00004998,  0x93000004,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004998,
	0x93000006,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x00004998,  0x93000007,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00004998,  0x9300000b,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00004998,  0x90000006,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x0000490C,  0x90000007,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004998,
	0xA0000000,  0x00000000,  BBREG_0x03e, 0x00004998,  0xB0000000,
	0x00000000,  BBREG_0x03f, 0x000C3186,  BBREG_0x033, 0x00000002,
	0x83000001,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x00005840,  0x93000004,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00005840,  0x93000006,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00005840,  0x93000007,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00005840,  0x9300000b,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00005840,
	0x90000006,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x00005E00,  0x90000007,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00005840,  0xA0000000,  0x00000000,  BBREG_0x03e,
	0x00005840,  0xB0000000,  0x00000000,  BBREG_0x03f, 0x000C3186,
	BBREG_0x033, 0x00000001,  0x83000001,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x000058C2,  0x93000004,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x000058C2,  0x93000006,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x000058C2,
	0x93000007,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x000058C2,  0x9300000b,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x000058C2,  0x90000006,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00005862,  0x90000007,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x000058C2,  0xA0000000,
	0x00000000,  BBREG_0x03e, 0x000058C2,  0xB0000000,  0x00000000,
	BBREG_0x03f, 0x000C3186,  BBREG_0x033, 0x00000000,  0x83000001,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00005930,
	0x93000004,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x00005930,  0x93000006,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00005930,  0x93000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00005930,  0x9300000b,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00005930,  0x90000006,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00005948,
	0x90000007,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x00005930,  0xA0000000,  0x00000000,  BBREG_0x03e, 0x00005930,
	0xB0000000,  0x00000000,  BBREG_0x03f, 0x000C3186,  BBREG_0x033,
	0x0000000F,  0x83000000,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00004000,  0x93000001,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00004040,  0x93000002,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00004040,  0x93000004,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004040,
	0x93000005,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x00004000,  0x93000006,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00004080,  0x93000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00004040,  0x93000008,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00004000,  0x93000009,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004040,
	0x9300000a,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x00004000,  0x9300000b,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00004040,  0x9300000d,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00004000,  0x9300000e,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00004000,  0x90000001,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004040,
	0x90000002,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x00004040,  0x90000004,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00004040,  0x90000006,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00004080,  0x90000007,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00004040,  0xA0000000,
	0x00000000,  BBREG_0x03e, 0x00004000,  0xB0000000,  0x00000000,
	0x83000000,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f,
	0x000C3186,  0x93000001,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03f, 0x000C3186,  0x93000002,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03f, 0x000C3186,  0x93000003,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03f, 0x000C0006,  0x93000004,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f, 0x000C3186,
	0x93000005,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f,
	0x000DFF86,  0x93000006,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03f, 0x000C3186,  0x93000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03f, 0x000C3186,  0x93000008,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03f, 0x000DFF86,  0x93000009,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f, 0x000C3186,
	0x9300000a,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f,
	0x000C3186,  0x9300000b,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03f, 0x000C3186,  0x9300000c,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03f, 0x000C0006,  0x9300000d,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03f, 0x000C3186,  0x9300000e,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f, 0x000C3186,
	0x9300000f,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f,
	0x000C0006,  0x93000010,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03f, 0x000C0006,  0x90000001,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03f, 0x000C3186,  0x90000002,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03f, 0x000C3186,  0x90000004,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f, 0x000C3186,
	0x90000006,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f,
	0x000C3186,  0x90000007,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03f, 0x000C3186,  0xA0000000,  0x00000000,  BBREG_0x03f,
	0x000C3186,  0xB0000000,  0x00000000,  BBREG_0x033, 0x0000000E,
	BBREG_0x03e, 0x00004080,  BBREG_0x03f, 0x000C3186,  BBREG_0x033,
	0x0000000D,  BBREG_0x03e, 0x000040C8,  BBREG_0x03f, 0x000C3186,
	BBREG_0x033, 0x0000000C,  BBREG_0x03e, 0x00004190,  BBREG_0x03f,
	0x000C3186,  BBREG_0x033, 0x0000000B,  BBREG_0x03e, 0x00004998,
	BBREG_0x03f, 0x000C3186,  BBREG_0x033, 0x0000000A,  BBREG_0x03e,
	0x00005840,  BBREG_0x03f, 0x000C3186,  BBREG_0x033, 0x00000009,
	BBREG_0x03e, 0x000058C2,  BBREG_0x03f, 0x000C3186,  BBREG_0x033,
	0x00000008,  BBREG_0x03e, 0x00005930,  BBREG_0x03f, 0x000C3186,
	BBREG_0x033, 0x00000017,  0x83000000,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00004000,  0x93000001,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00004040,  0x93000002,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004040,
	0x93000004,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x00004040,  0x93000005,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00004000,  0x93000006,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00004080,  0x93000007,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00004040,  0x93000008,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004000,
	0x93000009,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x00004040,  0x9300000a,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00004000,  0x9300000b,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00004040,  0x9300000d,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00004000,  0x9300000e,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004000,
	0x90000001,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x00004040,  0x90000002,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00004040,  0x90000004,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00004040,  0x90000006,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00004080,  0x90000007,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004040,
	0xA0000000,  0x00000000,  BBREG_0x03e, 0x00004000,  0xB0000000,
	0x00000000,  0x83000000,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03f, 0x000C3186,  0x93000001,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03f, 0x000C3186,  0x93000002,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03f, 0x000C3186,  0x93000003,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f, 0x000C0006,
	0x93000004,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f,
	0x000C3186,  0x93000005,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03f, 0x000C3186,  0x93000006,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03f, 0x000C3186,  0x93000007,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03f, 0x000C3186,  0x93000008,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f, 0x000C3186,
	0x93000009,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f,
	0x000C3186,  0x9300000a,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03f, 0x000C3186,  0x9300000b,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03f, 0x000C3186,  0x9300000c,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03f, 0x000C0006,  0x9300000d,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f, 0x000DFF86,
	0x9300000e,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f,
	0x000C3186,  0x9300000f,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03f, 0x000C0006,  0x93000010,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03f, 0x000C0006,  0x90000001,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03f, 0x000C3186,  0x90000002,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f, 0x000C3186,
	0x90000004,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f,
	0x000C3186,  0x90000006,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03f, 0x000C3186,  0x90000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03f, 0x000C3186,  0xA0000000,  0x00000000,
	BBREG_0x03f, 0x000C3186,  0xB0000000,  0x00000000,  BBREG_0x033,
	0x00000016,  BBREG_0x03e, 0x00004080,  BBREG_0x03f, 0x000C3186,
	BBREG_0x033, 0x00000015,  BBREG_0x03e, 0x000040C8,  BBREG_0x03f,
	0x000C3186,  BBREG_0x033, 0x00000014,  BBREG_0x03e, 0x00004190,
	BBREG_0x03f, 0x000C3186,  BBREG_0x033, 0x00000013,  BBREG_0x03e,
	0x00004998,  BBREG_0x03f, 0x000C3186,  BBREG_0x033, 0x00000012,
	BBREG_0x03e, 0x00005840,  BBREG_0x03f, 0x000C3186,  BBREG_0x033,
	0x00000011,  BBREG_0x03e, 0x000058C2,  BBREG_0x03f, 0x000C3186,
	BBREG_0x033, 0x00000010,  BBREG_0x03e, 0x00005930,  BBREG_0x03f,
	0x000C3186,  BBREG_0x0ef, 0x00000000,  BBREG_0x0ef, 0x00004000,
	BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x0000000A,  BBREG_0x033,
	0x00000001,  0x83000000,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03f, 0x00000005,  0x93000001,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03f, 0x00000000,  0x93000002,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03f, 0x00000000,  0x93000003,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f, 0x00000000,
	0x93000004,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f,
	0x00000000,  0x93000005,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03f, 0x00000006,  0x93000006,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03f, 0x00000000,  0x93000007,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03f, 0x00000000,  0x93000008,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f, 0x00000005,
	0x93000009,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f,
	0x00000000,  0x9300000a,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03f, 0x00000005,  0x9300000b,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03f, 0x00000000,  0x9300000c,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03f, 0x00000000,  0x9300000d,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f, 0x00000005,
	0x9300000e,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f,
	0x00000005,  0x9300000f,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03f, 0x00000000,  0x93000010,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03f, 0x00000000,  0x90000001,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03f, 0x00000000,  0x90000002,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f, 0x00000000,
	0x90000003,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f,
	0x00000000,  0x90000004,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03f, 0x00000000,  0x90000005,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03f, 0x00000000,  0x90000006,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03f, 0x00000000,  0x90000007,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f, 0x00000000,
	0xA0000000,  0x00000000,  BBREG_0x03f, 0x00000005,  0xB0000000,
	0x00000000,  BBREG_0x033, 0x00000002,  BBREG_0x03f, 0x00000000,
	BBREG_0x0ef, 0x00000000,  BBREG_0x018, 0x00000401,  BBREG_0x084,
	0x00001209,  BBREG_0x086, 0x000001A0,  0x83000001,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x087, 0x00068080,  0x93000004,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x087, 0x00068080,
	0x93000006,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x087,
	0x00068080,  0x93000007,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x087, 0x00068080,  0x9300000b,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x087, 0x00068080,  0x90000001,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x087, 0x00068080,  0x90000004,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x087, 0x00068080,
	0x90000006,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x087,
	0x00068080,  0x90000007,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x087, 0x00068080,  0xA0000000,  0x00000000,  BBREG_0x087,
	0x000E8180,  0xB0000000,  0x00000000,  BBREG_0x088, 0x00070020,
	BBREG_0x0de, 0x00000010,  BBREG_0x0ef, 0x00008000,  BBREG_0x033,
	0x0000000F,  BBREG_0x03f, 0x0000003C,  BBREG_0x033, 0x0000000E,
	BBREG_0x03f, 0x00000038,  BBREG_0x033, 0x0000000D,  BBREG_0x03f,
	0x00000030,  BBREG_0x033, 0x0000000C,  BBREG_0x03f, 0x00000028,
	BBREG_0x033, 0x0000000B,  BBREG_0x03f, 0x00000020,  BBREG_0x033,
	0x0000000A,  BBREG_0x03f, 0x00000018,  BBREG_0x033, 0x00000009,
	BBREG_0x03f, 0x00000010,  BBREG_0x033, 0x00000008,  BBREG_0x03f,
	0x00000008,  BBREG_0x033, 0x00000007,  BBREG_0x03f, 0x0000003C,
	BBREG_0x033, 0x00000006,  BBREG_0x03f, 0x00000038,  BBREG_0x033,
	0x00000005,  BBREG_0x03f, 0x00000030,  BBREG_0x033, 0x00000004,
	BBREG_0x03f, 0x00000028,  BBREG_0x033, 0x00000003,  BBREG_0x03f,
	0x00000020,  BBREG_0x033, 0x00000002,  BBREG_0x03f, 0x00000018,
	BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x00000010,  BBREG_0x033,
	0x00000000,  BBREG_0x03f, 0x00000008,  BBREG_0x0ef, 0x00000000,
	BBREG_0x0b8, 0x00080A00,  BBREG_0x0fe, 0x00000000,  BBREG_0x0b0,
	0x000FF0FA,  BBREG_0x0fe, 0x00000000,  BBREG_0x0fe, 0x00000000,
	BBREG_0x0ca, 0x00080000,  BBREG_0x0fe, 0x00000000,  BBREG_0x0c9,
	0x0001C141,  BBREG_0x0fe, 0x00000000,  BBREG_0x0fe, 0x00000000,
	BBREG_0x0b0, 0x000FF0F8,  BBREG_0x018, 0x00018D24,  BBREG_0xffe,
	0x00000000,  BBREG_0xffe, 0x00000000,  BBREG_0xffe, 0x00000000,
	BBREG_0xffe, 0x00000000,  BBREG_0x018, 0x00010D24,  BBREG_0x01b,
	0x00075A40,  BBREG_0x0ee, 0x00000002,  BBREG_0x033, 0x00000000,
	BBREG_0x03f, 0x00000004,  BBREG_0x033, 0x00000001,  BBREG_0x03f,
	0x00000004,  BBREG_0x033, 0x00000002,  BBREG_0x03f, 0x00000004,
	BBREG_0x033, 0x00000003,  BBREG_0x03f, 0x00000004,  BBREG_0x033,
	0x00000004,  BBREG_0x03f, 0x00000004,  BBREG_0x033, 0x00000005,
	BBREG_0x03f, 0x00000006,  BBREG_0x033, 0x00000006,  BBREG_0x03f,
	0x00000004,  BBREG_0x033, 0x00000007,  BBREG_0x03f, 0x00000000,
	BBREG_0x0ee, 0x00000000,  0x83000000,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x061, 0x0005D3D1,  BBREG_0x062, 0x0000D3A2,
	BBREG_0x063, 0x00000002,  0x93000001,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x061, 0x0005D4A0,  BBREG_0x062, 0x0000D203,
	BBREG_0x063, 0x00000062,  0x93000002,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x061, 0x0005D2A1,  BBREG_0x062, 0x0000D3A2,
	BBREG_0x063, 0x00000062,  0x93000003,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x061, 0x0005D301,  BBREG_0x062, 0x0000D303,
	BBREG_0x063, 0x00000002,  0x93000004,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x061, 0x0005D2A1,  BBREG_0x062, 0x0000D3A2,
	BBREG_0x063, 0x00000062,  0x93000005,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x061, 0x0005D301,  BBREG_0x062, 0x0000D303,
	BBREG_0x063, 0x00000002,  0x93000006,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x061, 0x0005D4A0,  BBREG_0x062, 0x0000D203,
	BBREG_0x063, 0x00000062,  0x93000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x061, 0x0005D4A0,  BBREG_0x062, 0x0000D203,
	BBREG_0x063, 0x00000062,  0x93000008,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x061, 0x0005D301,  BBREG_0x062, 0x0000D303,
	BBREG_0x063, 0x00000002,  0x93000009,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x061, 0x0005D3D1,  BBREG_0x062, 0x0000D3A2,
	BBREG_0x063, 0x00000002,  0x9300000a,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x061, 0x0005D3D1,  BBREG_0x062, 0x0000D3A2,
	BBREG_0x063, 0x00000002,  0x9300000b,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x061, 0x0005D4A0,  BBREG_0x062, 0x0000D203,
	BBREG_0x063, 0x00000062,  0x9300000c,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x061, 0x0005D301,  BBREG_0x062, 0x0000D303,
	BBREG_0x063, 0x00000002,  0x9300000d,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x061, 0x0005D3D1,  BBREG_0x062, 0x0000D3A2,
	BBREG_0x063, 0x00000002,  0x9300000e,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x061, 0x0005D3D1,  BBREG_0x062, 0x0000D3A2,
	BBREG_0x063, 0x00000002,  0x9300000f,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x061, 0x0005D301,  BBREG_0x062, 0x0000D303,
	BBREG_0x063, 0x00000002,  0x93000010,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x061, 0x0005D301,  BBREG_0x062, 0x0000D303,
	BBREG_0x063, 0x00000002,  0x90000001,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x061, 0x0005D4A0,  BBREG_0x062, 0x0000D203,
	BBREG_0x063, 0x00000062,  0x90000002,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x061, 0x0005D2A1,  BBREG_0x062, 0x0000D3A2,
	BBREG_0x063, 0x00000062,  0x90000003,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x061, 0x0005D301,  BBREG_0x062, 0x0000D303,
	BBREG_0x063, 0x00000002,  0x90000004,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x061, 0x0005D2A1,  BBREG_0x062, 0x0000D3A2,
	BBREG_0x063, 0x00000062,  0x90000005,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x061, 0x0005D301,  BBREG_0x062, 0x0000D303,
	BBREG_0x063, 0x00000002,  0x90000006,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x061, 0x0005D4A0,  BBREG_0x062, 0x0000D203,
	BBREG_0x063, 0x00000062,  0x90000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x061, 0x0005D4A0,  BBREG_0x062, 0x0000D203,
	BBREG_0x063, 0x00000062,  0xA0000000,  0x00000000,  BBREG_0x061,
	0x0005D3D0,  BBREG_0x062, 0x0000D303,  BBREG_0x063, 0x00000002,
	0xB0000000,  0x00000000,  0x83000000,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000200,  BBREG_0x030, 0x000003A2,
	BBREG_0x030, 0x000013A2,  BBREG_0x030, 0x000023A2,  BBREG_0x030,
	0x000033A2,  BBREG_0x030, 0x000043A2,  BBREG_0x030, 0x000053A2,
	BBREG_0x030, 0x000063A2,  BBREG_0x030, 0x000073A2,  BBREG_0x030,
	0x000083A3,  BBREG_0x030, 0x000093A3,  BBREG_0x030, 0x0000A3A3,
	BBREG_0x030, 0x0000B3A3,  BBREG_0x0ef, 0x00000000,  0x93000001,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x0ef, 0x00000200,
	BBREG_0x030, 0x000004A3,  BBREG_0x030, 0x000014A3,  BBREG_0x030,
	0x000024A3,  BBREG_0x030, 0x000034A3,  BBREG_0x030, 0x000044A3,
	BBREG_0x030, 0x000054A3,  BBREG_0x030, 0x000064A3,  BBREG_0x030,
	0x000074A3,  BBREG_0x030, 0x000084A3,  BBREG_0x030, 0x000094A3,
	BBREG_0x030, 0x0000A4A3,  BBREG_0x030, 0x0000B4A3,  BBREG_0x0ef,
	0x00000000,  0x93000002,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x0ef, 0x00000200,  BBREG_0x030, 0x000002A6,  BBREG_0x030,
	0x000012A6,  BBREG_0x030, 0x000022A6,  BBREG_0x030, 0x000032A6,
	BBREG_0x030, 0x000042A6,  BBREG_0x030, 0x000052A6,  BBREG_0x030,
	0x000062A6,  BBREG_0x030, 0x000072A6,  BBREG_0x030, 0x000082A6,
	BBREG_0x030, 0x000092A6,  BBREG_0x030, 0x0000A2A6,  BBREG_0x030,
	0x0000B2A6,  BBREG_0x0ef, 0x00000000,  0x93000003,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x0ef, 0x00000200,  BBREG_0x030,
	0x00000303,  BBREG_0x030, 0x00001303,  BBREG_0x030, 0x00002303,
	BBREG_0x030, 0x00003303,  BBREG_0x030, 0x000043A4,  BBREG_0x030,
	0x000053A4,  BBREG_0x030, 0x000063A4,  BBREG_0x030, 0x000073A4,
	BBREG_0x030, 0x00008365,  BBREG_0x030, 0x00009365,  BBREG_0x030,
	0x0000A365,  BBREG_0x030, 0x0000B365,  BBREG_0x0ef, 0x00000000,
	0x93000004,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x0ef,
	0x00000200,  BBREG_0x030, 0x000002A6,  BBREG_0x030, 0x000012A6,
	BBREG_0x030, 0x000022A6,  BBREG_0x030, 0x000032A6,  BBREG_0x030,
	0x000042A6,  BBREG_0x030, 0x000052A6,  BBREG_0x030, 0x000062A6,
	BBREG_0x030, 0x000072A6,  BBREG_0x030, 0x000082A6,  BBREG_0x030,
	0x000092A6,  BBREG_0x030, 0x0000A2A6,  BBREG_0x030, 0x0000B2A6,
	BBREG_0x0ef, 0x00000000,  0x93000005,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000200,  BBREG_0x030, 0x000003A3,
	BBREG_0x030, 0x000013A3,  BBREG_0x030, 0x000023A3,  BBREG_0x030,
	0x000033A3,  BBREG_0x030, 0x00004355,  BBREG_0x030, 0x00005355,
	BBREG_0x030, 0x00006355,  BBREG_0x030, 0x00007355,  BBREG_0x030,
	0x00008315,  BBREG_0x030, 0x00009315,  BBREG_0x030, 0x0000A315,
	BBREG_0x030, 0x0000B315,  BBREG_0x0ef, 0x00000000,  0x93000006,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x0ef, 0x00000200,
	BBREG_0x030, 0x000004A3,  BBREG_0x030, 0x000014A3,  BBREG_0x030,
	0x000024A3,  BBREG_0x030, 0x000034A3,  BBREG_0x030, 0x000044A3,
	BBREG_0x030, 0x000054A3,  BBREG_0x030, 0x000064A3,  BBREG_0x030,
	0x000074A3,  BBREG_0x030, 0x000084A3,  BBREG_0x030, 0x000094A3,
	BBREG_0x030, 0x0000A4A3,  BBREG_0x030, 0x0000B4A3,  BBREG_0x0ef,
	0x00000000,  0x93000007,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x0ef, 0x00000200,  BBREG_0x030, 0x000004A3,  BBREG_0x030,
	0x000014A3,  BBREG_0x030, 0x000024A3,  BBREG_0x030, 0x000034A3,
	BBREG_0x030, 0x000044A3,  BBREG_0x030, 0x000054A3,  BBREG_0x030,
	0x000064A3,  BBREG_0x030, 0x000074A3,  BBREG_0x030, 0x000084A3,
	BBREG_0x030, 0x000094A3,  BBREG_0x030, 0x0000A4A3,  BBREG_0x030,
	0x0000B4A3,  BBREG_0x0ef, 0x00000000,  0x93000008,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x0ef, 0x00000200,  BBREG_0x030,
	0x00000384,  BBREG_0x030, 0x00001384,  BBREG_0x030, 0x00002384,
	BBREG_0x030, 0x00003384,  BBREG_0x030, 0x00004425,  BBREG_0x030,
	0x00005425,  BBREG_0x030, 0x00006425,  BBREG_0x030, 0x00007425,
	BBREG_0x030, 0x000084A6,  BBREG_0x030, 0x000094A6,  BBREG_0x030,
	0x0000A4A6,  BBREG_0x030, 0x0000B4A6,  BBREG_0x0ef, 0x00000000,
	0x93000009,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x0ef,
	0x00000200,  BBREG_0x030, 0x00000463,  BBREG_0x030, 0x00001463,
	BBREG_0x030, 0x00002463,  BBREG_0x030, 0x00003463,  BBREG_0x030,
	0x00004545,  BBREG_0x030, 0x00005545,  BBREG_0x030, 0x00006545,
	BBREG_0x030, 0x00007545,  BBREG_0x030, 0x00008565,  BBREG_0x030,
	0x00009565,  BBREG_0x030, 0x0000A565,  BBREG_0x030, 0x0000B565,
	BBREG_0x0ef, 0x00000000,  0x9300000a,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000200,  BBREG_0x030, 0x000003A2,
	BBREG_0x030, 0x000013A2,  BBREG_0x030, 0x000023A2,  BBREG_0x030,
	0x000033A2,  BBREG_0x030, 0x000043A2,  BBREG_0x030, 0x000053A2,
	BBREG_0x030, 0x000063A2,  BBREG_0x030, 0x000073A2,  BBREG_0x030,
	0x000083A3,  BBREG_0x030, 0x000093A3,  BBREG_0x030, 0x0000A3A3,
	BBREG_0x030, 0x0000B3A3,  BBREG_0x0ef, 0x00000000,  0x9300000b,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x0ef, 0x00000200,
	BBREG_0x030, 0x000004A3,  BBREG_0x030, 0x000014A3,  BBREG_0x030,
	0x000024A3,  BBREG_0x030, 0x000034A3,  BBREG_0x030, 0x000044A3,
	BBREG_0x030, 0x000054A3,  BBREG_0x030, 0x000064A3,  BBREG_0x030,
	0x000074A3,  BBREG_0x030, 0x000084A3,  BBREG_0x030, 0x000094A3,
	BBREG_0x030, 0x0000A4A3,  BBREG_0x030, 0x0000B4A3,  BBREG_0x0ef,
	0x00000000,  0x9300000c,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x0ef, 0x00000200,  BBREG_0x030, 0x00000443,  BBREG_0x030,
	0x00001443,  BBREG_0x030, 0x00002443,  BBREG_0x030, 0x00003443,
	BBREG_0x030, 0x000043A4,  BBREG_0x030, 0x000053A4,  BBREG_0x030,
	0x000063A4,  BBREG_0x030, 0x000073A4,  BBREG_0x030, 0x00008365,
	BBREG_0x030, 0x00009365,  BBREG_0x030, 0x0000A365,  BBREG_0x030,
	0x0000B365,  BBREG_0x0ef, 0x00000000,  0x9300000d,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x0ef, 0x00000200,  BBREG_0x030,
	0x00000443,  BBREG_0x030, 0x00001443,  BBREG_0x030, 0x00002443,
	BBREG_0x030, 0x00003443,  BBREG_0x030, 0x00004483,  BBREG_0x030,
	0x00005483,  BBREG_0x030, 0x00006483,  BBREG_0x030, 0x00007483,
	BBREG_0x030, 0x000084A4,  BBREG_0x030, 0x000094A4,  BBREG_0x030,
	0x0000A4A4,  BBREG_0x030, 0x0000B4A4,  BBREG_0x0ef, 0x00000000,
	0x9300000e,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x0ef,
	0x00000200,  BBREG_0x030, 0x00000361,  BBREG_0x030, 0x00001361,
	BBREG_0x030, 0x00002361,  BBREG_0x030, 0x00003361,  BBREG_0x030,
	0x00004443,  BBREG_0x030, 0x00005443,  BBREG_0x030, 0x00006443,
	BBREG_0x030, 0x00007443,  BBREG_0x030, 0x00008424,  BBREG_0x030,
	0x00009424,  BBREG_0x030, 0x0000A424,  BBREG_0x030, 0x0000B424,
	BBREG_0x0ef, 0x00000000,  0x9300000f,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000200,  BBREG_0x030, 0x00000334,
	BBREG_0x030, 0x00001334,  BBREG_0x030, 0x00002334,  BBREG_0x030,
	0x00003334,  BBREG_0x030, 0x000043A4,  BBREG_0x030, 0x000053A4,
	BBREG_0x030, 0x000063A4,  BBREG_0x030, 0x000073A4,  BBREG_0x030,
	0x00008365,  BBREG_0x030, 0x00009365,  BBREG_0x030, 0x0000A365,
	BBREG_0x030, 0x0000B365,  BBREG_0x0ef, 0x00000000,  0x93000010,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x0ef, 0x00000200,
	BBREG_0x030, 0x00000403,  BBREG_0x030, 0x00001403,  BBREG_0x030,
	0x00002403,  BBREG_0x030, 0x00003403,  BBREG_0x030, 0x000044A2,
	BBREG_0x030, 0x000054A2,  BBREG_0x030, 0x000064A2,  BBREG_0x030,
	0x000074A2,  BBREG_0x030, 0x000083A3,  BBREG_0x030, 0x000093A3,
	BBREG_0x030, 0x0000A3A3,  BBREG_0x030, 0x0000B3A3,  BBREG_0x0ef,
	0x00000000,  0x90000001,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x0ef, 0x00000200,  BBREG_0x030, 0x000004A0,  BBREG_0x030,
	0x000014A0,  BBREG_0x030, 0x000024A0,  BBREG_0x030, 0x000034A0,
	BBREG_0x030, 0x000044A0,  BBREG_0x030, 0x000054A0,  BBREG_0x030,
	0x000064A0,  BBREG_0x030, 0x000074A0,  BBREG_0x030, 0x000084A0,
	BBREG_0x030, 0x000094A0,  BBREG_0x030, 0x0000A4A0,  BBREG_0x030,
	0x0000B4A0,  BBREG_0x0ef, 0x00000000,  0x90000002,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x0ef, 0x00000200,  BBREG_0x030,
	0x000002A1,  BBREG_0x030, 0x000012A1,  BBREG_0x030, 0x000022A1,
	BBREG_0x030, 0x000032A1,  BBREG_0x030, 0x000042A1,  BBREG_0x030,
	0x000052A1,  BBREG_0x030, 0x000062A1,  BBREG_0x030, 0x000072A1,
	BBREG_0x030, 0x000082A1,  BBREG_0x030, 0x000092A1,  BBREG_0x030,
	0x0000A2A1,  BBREG_0x030, 0x0000B2A1,  BBREG_0x0ef, 0x00000000,
	0x90000003,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x0ef,
	0x00000200,  BBREG_0x030, 0x000003A0,  BBREG_0x030, 0x000013A0,
	BBREG_0x030, 0x000023A0,  BBREG_0x030, 0x000033A0,  BBREG_0x030,
	0x000043A1,  BBREG_0x030, 0x000053A1,  BBREG_0x030, 0x000063A1,
	BBREG_0x030, 0x000073A1,  BBREG_0x030, 0x000083A2,  BBREG_0x030,
	0x000093A2,  BBREG_0x030, 0x0000A3A2,  BBREG_0x030, 0x0000B3A2,
	BBREG_0x0ef, 0x00000000,  0x90000004,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000200,  BBREG_0x030, 0x000002A1,
	BBREG_0x030, 0x000012A1,  BBREG_0x030, 0x000022A1,  BBREG_0x030,
	0x000032A1,  BBREG_0x030, 0x000042A1,  BBREG_0x030, 0x000052A1,
	BBREG_0x030, 0x000062A1,  BBREG_0x030, 0x000072A1,  BBREG_0x030,
	0x000082A1,  BBREG_0x030, 0x000092A1,  BBREG_0x030, 0x0000A2A1,
	BBREG_0x030, 0x0000B2A1,  BBREG_0x0ef, 0x00000000,  0x90000005,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x0ef, 0x00000200,
	BBREG_0x030, 0x000003A0,  BBREG_0x030, 0x000013A0,  BBREG_0x030,
	0x000023A0,  BBREG_0x030, 0x000033A0,  BBREG_0x030, 0x00004430,
	BBREG_0x030, 0x00005430,  BBREG_0x030, 0x00006430,  BBREG_0x030,
	0x00007430,  BBREG_0x030, 0x00008372,  BBREG_0x030, 0x00009372,
	BBREG_0x030, 0x0000A372,  BBREG_0x030, 0x0000B372,  BBREG_0x0ef,
	0x00000000,  0x90000006,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x0ef, 0x00000200,  BBREG_0x030, 0x000004A0,  BBREG_0x030,
	0x000014A0,  BBREG_0x030, 0x000024A0,  BBREG_0x030, 0x000034A0,
	BBREG_0x030, 0x000044A0,  BBREG_0x030, 0x000054A0,  BBREG_0x030,
	0x000064A0,  BBREG_0x030, 0x000074A0,  BBREG_0x030, 0x000084A0,
	BBREG_0x030, 0x000094A0,  BBREG_0x030, 0x0000A4A0,  BBREG_0x030,
	0x0000B4A0,  BBREG_0x0ef, 0x00000000,  0x90000007,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x0ef, 0x00000200,  BBREG_0x030,
	0x000004A0,  BBREG_0x030, 0x000014A0,  BBREG_0x030, 0x000024A0,
	BBREG_0x030, 0x000034A0,  BBREG_0x030, 0x000044A0,  BBREG_0x030,
	0x000054A0,  BBREG_0x030, 0x000064A0,  BBREG_0x030, 0x000074A0,
	BBREG_0x030, 0x000084A0,  BBREG_0x030, 0x000094A0,  BBREG_0x030,
	0x0000A4A0,  BBREG_0x030, 0x0000B4A0,  BBREG_0x0ef, 0x00000000,
	0xA0000000,  0x00000000,  BBREG_0x0ef, 0x00000200,  BBREG_0x030,
	0x000003D0,  BBREG_0x030, 0x000013D0,  BBREG_0x030, 0x000023D0,
	BBREG_0x030, 0x000033D0,  BBREG_0x030, 0x000043D0,  BBREG_0x030,
	0x000053D0,  BBREG_0x030, 0x000063D0,  BBREG_0x030, 0x000073D0,
	BBREG_0x030, 0x000083D0,  BBREG_0x030, 0x000093D0,  BBREG_0x030,
	0x0000A3D0,  BBREG_0x030, 0x0000B3D0,  BBREG_0x0ef, 0x00000000,
	0xB0000000,  0x00000000,  0x83000000,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000080,  BBREG_0x030, 0x000003A2,
	BBREG_0x030, 0x000013A2,  BBREG_0x030, 0x000023A2,  BBREG_0x030,
	0x000033A2,  BBREG_0x030, 0x000043A2,  BBREG_0x030, 0x000053A2,
	BBREG_0x030, 0x000063A2,  BBREG_0x030, 0x000073A2,  BBREG_0x030,
	0x000083A2,  BBREG_0x030, 0x000093A2,  BBREG_0x030, 0x0000A3A2,
	BBREG_0x030, 0x0000B3A2,  0x93000001,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000080,  BBREG_0x030, 0x00000203,
	BBREG_0x030, 0x00001203,  BBREG_0x030, 0x00002203,  BBREG_0x030,
	0x00003203,  BBREG_0x030, 0x00004203,  BBREG_0x030, 0x00005203,
	BBREG_0x030, 0x00006203,  BBREG_0x030, 0x00007203,  BBREG_0x030,
	0x00008203,  BBREG_0x030, 0x00009203,  BBREG_0x030, 0x0000A203,
	BBREG_0x030, 0x0000B203,  0x93000002,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000080,  BBREG_0x030, 0x000003A2,
	BBREG_0x030, 0x000013A2,  BBREG_0x030, 0x000023A2,  BBREG_0x030,
	0x000033A2,  BBREG_0x030, 0x000043A2,  BBREG_0x030, 0x000053A2,
	BBREG_0x030, 0x000063A2,  BBREG_0x030, 0x000073A2,  BBREG_0x030,
	0x000083A2,  BBREG_0x030, 0x000093A2,  BBREG_0x030, 0x0000A3A2,
	BBREG_0x030, 0x0000B3A2,  0x93000003,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000080,  BBREG_0x030, 0x000003A2,
	BBREG_0x030, 0x000013A2,  BBREG_0x030, 0x000023A2,  BBREG_0x030,
	0x000033A2,  BBREG_0x030, 0x000043A2,  BBREG_0x030, 0x000053A2,
	BBREG_0x030, 0x000063A2,  BBREG_0x030, 0x000073A2,  BBREG_0x030,
	0x000083A2,  BBREG_0x030, 0x000093A2,  BBREG_0x030, 0x0000A3A2,
	BBREG_0x030, 0x0000B3A2,  0x93000004,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000080,  BBREG_0x030, 0x000003A2,
	BBREG_0x030, 0x000013A2,  BBREG_0x030, 0x000023A2,  BBREG_0x030,
	0x000033A2,  BBREG_0x030, 0x000043A2,  BBREG_0x030, 0x000053A2,
	BBREG_0x030, 0x000063A2,  BBREG_0x030, 0x000073A2,  BBREG_0x030,
	0x000083A2,  BBREG_0x030, 0x000093A2,  BBREG_0x030, 0x0000A3A2,
	BBREG_0x030, 0x0000B3A2,  0x93000005,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000080,  BBREG_0x030, 0x000003A2,
	BBREG_0x030, 0x000013A2,  BBREG_0x030, 0x000023A2,  BBREG_0x030,
	0x000033A2,  BBREG_0x030, 0x000043A2,  BBREG_0x030, 0x000053A2,
	BBREG_0x030, 0x000063A2,  BBREG_0x030, 0x000073A2,  BBREG_0x030,
	0x000083A2,  BBREG_0x030, 0x000093A2,  BBREG_0x030, 0x0000A3A2,
	BBREG_0x030, 0x0000B3A2,  0x93000006,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000080,  BBREG_0x030, 0x00000203,
	BBREG_0x030, 0x00001203,  BBREG_0x030, 0x00002203,  BBREG_0x030,
	0x00003203,  BBREG_0x030, 0x00004203,  BBREG_0x030, 0x00005203,
	BBREG_0x030, 0x00006203,  BBREG_0x030, 0x00007203,  BBREG_0x030,
	0x00008203,  BBREG_0x030, 0x00009203,  BBREG_0x030, 0x0000A203,
	BBREG_0x030, 0x0000B203,  0x93000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000080,  BBREG_0x030, 0x00000203,
	BBREG_0x030, 0x00001203,  BBREG_0x030, 0x00002203,  BBREG_0x030,
	0x00003203,  BBREG_0x030, 0x00004203,  BBREG_0x030, 0x00005203,
	BBREG_0x030, 0x00006203,  BBREG_0x030, 0x00007203,  BBREG_0x030,
	0x00008203,  BBREG_0x030, 0x00009203,  BBREG_0x030, 0x0000A203,
	BBREG_0x030, 0x0000B203,  0x93000008,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000080,  BBREG_0x030, 0x000003A3,
	BBREG_0x030, 0x000013A3,  BBREG_0x030, 0x000023A3,  BBREG_0x030,
	0x000033A3,  BBREG_0x030, 0x000043A3,  BBREG_0x030, 0x000053A3,
	BBREG_0x030, 0x000063A3,  BBREG_0x030, 0x000073A3,  BBREG_0x030,
	0x000083A3,  BBREG_0x030, 0x000093A3,  BBREG_0x030, 0x0000A3A3,
	BBREG_0x030, 0x0000B3A3,  0x93000009,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000080,  BBREG_0x030, 0x000003A2,
	BBREG_0x030, 0x000013A2,  BBREG_0x030, 0x000023A2,  BBREG_0x030,
	0x000033A2,  BBREG_0x030, 0x000043A2,  BBREG_0x030, 0x000053A2,
	BBREG_0x030, 0x000063A2,  BBREG_0x030, 0x000073A2,  BBREG_0x030,
	0x000083A2,  BBREG_0x030, 0x000093A2,  BBREG_0x030, 0x0000A3A2,
	BBREG_0x030, 0x0000B3A2,  0x9300000a,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000080,  BBREG_0x030, 0x000003A2,
	BBREG_0x030, 0x000013A2,  BBREG_0x030, 0x000023A2,  BBREG_0x030,
	0x000033A2,  BBREG_0x030, 0x000043A2,  BBREG_0x030, 0x000053A2,
	BBREG_0x030, 0x000063A2,  BBREG_0x030, 0x000073A2,  BBREG_0x030,
	0x000083A2,  BBREG_0x030, 0x000093A2,  BBREG_0x030, 0x0000A3A2,
	BBREG_0x030, 0x0000B3A2,  0x9300000b,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000080,  BBREG_0x030, 0x00000203,
	BBREG_0x030, 0x00001203,  BBREG_0x030, 0x00002203,  BBREG_0x030,
	0x00003203,  BBREG_0x030, 0x00004203,  BBREG_0x030, 0x00005203,
	BBREG_0x030, 0x00006203,  BBREG_0x030, 0x00007203,  BBREG_0x030,
	0x00008203,  BBREG_0x030, 0x00009203,  BBREG_0x030, 0x0000A203,
	BBREG_0x030, 0x0000B203,  0x9300000c,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000080,  BBREG_0x030, 0x000003A2,
	BBREG_0x030, 0x000013A2,  BBREG_0x030, 0x000023A2,  BBREG_0x030,
	0x000033A2,  BBREG_0x030, 0x000043A2,  BBREG_0x030, 0x000053A2,
	BBREG_0x030, 0x000063A2,  BBREG_0x030, 0x000073A2,  BBREG_0x030,
	0x000083A2,  BBREG_0x030, 0x000093A2,  BBREG_0x030, 0x0000A3A2,
	BBREG_0x030, 0x0000B3A2,  0x9300000d,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000080,  BBREG_0x030, 0x000003A2,
	BBREG_0x030, 0x000013A2,  BBREG_0x030, 0x000023A2,  BBREG_0x030,
	0x000033A2,  BBREG_0x030, 0x000043A2,  BBREG_0x030, 0x000053A2,
	BBREG_0x030, 0x000063A2,  BBREG_0x030, 0x000073A2,  BBREG_0x030,
	0x000083A2,  BBREG_0x030, 0x000093A2,  BBREG_0x030, 0x0000A3A2,
	BBREG_0x030, 0x0000B3A2,  0x9300000e,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000080,  BBREG_0x030, 0x000003A2,
	BBREG_0x030, 0x000013A2,  BBREG_0x030, 0x000023A2,  BBREG_0x030,
	0x000033A2,  BBREG_0x030, 0x000043A2,  BBREG_0x030, 0x000053A2,
	BBREG_0x030, 0x000063A2,  BBREG_0x030, 0x000073A2,  BBREG_0x030,
	0x000083A2,  BBREG_0x030, 0x000093A2,  BBREG_0x030, 0x0000A3A2,
	BBREG_0x030, 0x0000B3A2,  0x9300000f,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000080,  BBREG_0x030, 0x000003A2,
	BBREG_0x030, 0x000013A2,  BBREG_0x030, 0x000023A2,  BBREG_0x030,
	0x000033A2,  BBREG_0x030, 0x000043A2,  BBREG_0x030, 0x000053A2,
	BBREG_0x030, 0x000063A2,  BBREG_0x030, 0x000073A2,  BBREG_0x030,
	0x000083A2,  BBREG_0x030, 0x000093A2,  BBREG_0x030, 0x0000A3A2,
	BBREG_0x030, 0x0000B3A2,  0x93000010,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000080,  BBREG_0x030, 0x000003A2,
	BBREG_0x030, 0x000013A2,  BBREG_0x030, 0x000023A2,  BBREG_0x030,
	0x000033A2,  BBREG_0x030, 0x000043A2,  BBREG_0x030, 0x000053A2,
	BBREG_0x030, 0x000063A2,  BBREG_0x030, 0x000073A2,  BBREG_0x030,
	0x000083A2,  BBREG_0x030, 0x000093A2,  BBREG_0x030, 0x0000A3A2,
	BBREG_0x030, 0x0000B3A2,  0x90000001,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000080,  BBREG_0x030, 0x00000203,
	BBREG_0x030, 0x00001203,  BBREG_0x030, 0x00002203,  BBREG_0x030,
	0x00003203,  BBREG_0x030, 0x00004203,  BBREG_0x030, 0x00005203,
	BBREG_0x030, 0x00006203,  BBREG_0x030, 0x00007203,  BBREG_0x030,
	0x00008203,  BBREG_0x030, 0x00009203,  BBREG_0x030, 0x0000A203,
	BBREG_0x030, 0x0000B203,  0x90000002,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000080,  BBREG_0x030, 0x000003A2,
	BBREG_0x030, 0x000013A2,  BBREG_0x030, 0x000023A2,  BBREG_0x030,
	0x000033A2,  BBREG_0x030, 0x000043A2,  BBREG_0x030, 0x000053A2,
	BBREG_0x030, 0x000063A2,  BBREG_0x030, 0x000073A2,  BBREG_0x030,
	0x000083A2,  BBREG_0x030, 0x000093A2,  BBREG_0x030, 0x0000A3A2,
	BBREG_0x030, 0x0000B3A2,  0x90000003,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000080,  BBREG_0x030, 0x000003A2,
	BBREG_0x030, 0x000013A2,  BBREG_0x030, 0x000023A2,  BBREG_0x030,
	0x000033A2,  BBREG_0x030, 0x000043A2,  BBREG_0x030, 0x000053A2,
	BBREG_0x030, 0x000063A2,  BBREG_0x030, 0x000073A2,  BBREG_0x030,
	0x000083A2,  BBREG_0x030, 0x000093A2,  BBREG_0x030, 0x0000A3A2,
	BBREG_0x030, 0x0000B3A2,  0x90000004,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000080,  BBREG_0x030, 0x000003A2,
	BBREG_0x030, 0x000013A2,  BBREG_0x030, 0x000023A2,  BBREG_0x030,
	0x000033A2,  BBREG_0x030, 0x000043A2,  BBREG_0x030, 0x000053A2,
	BBREG_0x030, 0x000063A2,  BBREG_0x030, 0x000073A2,  BBREG_0x030,
	0x000083A2,  BBREG_0x030, 0x000093A2,  BBREG_0x030, 0x0000A3A2,
	BBREG_0x030, 0x0000B3A2,  0x90000005,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000080,  BBREG_0x030, 0x000003A2,
	BBREG_0x030, 0x000013A2,  BBREG_0x030, 0x000023A2,  BBREG_0x030,
	0x000033A2,  BBREG_0x030, 0x000043A2,  BBREG_0x030, 0x000053A2,
	BBREG_0x030, 0x000063A2,  BBREG_0x030, 0x000073A2,  BBREG_0x030,
	0x000083A2,  BBREG_0x030, 0x000093A2,  BBREG_0x030, 0x0000A3A2,
	BBREG_0x030, 0x0000B3A2,  0x90000006,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000080,  BBREG_0x030, 0x00000203,
	BBREG_0x030, 0x00001203,  BBREG_0x030, 0x00002203,  BBREG_0x030,
	0x00003203,  BBREG_0x030, 0x00004203,  BBREG_0x030, 0x00005203,
	BBREG_0x030, 0x00006203,  BBREG_0x030, 0x00007203,  BBREG_0x030,
	0x00008203,  BBREG_0x030, 0x00009203,  BBREG_0x030, 0x0000A203,
	BBREG_0x030, 0x0000B203,  0x90000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000080,  BBREG_0x030, 0x00000203,
	BBREG_0x030, 0x00001203,  BBREG_0x030, 0x00002203,  BBREG_0x030,
	0x00003203,  BBREG_0x030, 0x00004203,  BBREG_0x030, 0x00005203,
	BBREG_0x030, 0x00006203,  BBREG_0x030, 0x00007203,  BBREG_0x030,
	0x00008203,  BBREG_0x030, 0x00009203,  BBREG_0x030, 0x0000A203,
	BBREG_0x030, 0x0000B203,  0xA0000000,  0x00000000,  BBREG_0x0ef,
	0x00000080,  BBREG_0x030, 0x000003A2,  BBREG_0x030, 0x000013A2,
	BBREG_0x030, 0x000023A2,  BBREG_0x030, 0x000033A2,  BBREG_0x030,
	0x000043A2,  BBREG_0x030, 0x000053A2,  BBREG_0x030, 0x000063A2,
	BBREG_0x030, 0x000073A2,  BBREG_0x030, 0x000083A2,  BBREG_0x030,
	0x000093A2,  BBREG_0x030, 0x0000A3A2,  BBREG_0x030, 0x0000B3A2,
	0xB0000000,  0x00000000,  BBREG_0x0ef, 0x00000000,  0x83000000,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x0ef, 0x00000040,
	BBREG_0x030, 0x00000764,  BBREG_0x030, 0x00001632,  BBREG_0x030,
	0x00002421,  BBREG_0x030, 0x00004000,  BBREG_0x030, 0x00005000,
	BBREG_0x030, 0x00006000,  0x93000001,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000040,  BBREG_0x030, 0x00000645,
	BBREG_0x030, 0x00001333,  BBREG_0x030, 0x00002011,  BBREG_0x030,
	0x00004000,  BBREG_0x030, 0x00005000,  BBREG_0x030, 0x00006000,
	0x93000002,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x0ef,
	0x00000040,  BBREG_0x030, 0x00000645,  BBREG_0x030, 0x00001333,
	BBREG_0x030, 0x00002011,  BBREG_0x030, 0x00004777,  BBREG_0x030,
	0x00005777,  BBREG_0x030, 0x00006777,  0x93000003,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x0ef, 0x00000040,  BBREG_0x030,
	0x00000777,  BBREG_0x030, 0x00001442,  BBREG_0x030, 0x00002222,
	BBREG_0x030, 0x00004777,  BBREG_0x030, 0x00005777,  BBREG_0x030,
	0x00006777,  0x93000004,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x0ef, 0x00000040,  BBREG_0x030, 0x00000645,  BBREG_0x030,
	0x00001333,  BBREG_0x030, 0x00002011,  BBREG_0x030, 0x00004777,
	BBREG_0x030, 0x00005777,  BBREG_0x030, 0x00006777,  0x93000005,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x0ef, 0x00000040,
	BBREG_0x030, 0x00000776,  BBREG_0x030, 0x00001455,  BBREG_0x030,
	0x00002335,  BBREG_0x030, 0x00004777,  BBREG_0x030, 0x00005777,
	BBREG_0x030, 0x00006777,  0x93000006,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000040,  BBREG_0x030, 0x00000645,
	BBREG_0x030, 0x00001333,  BBREG_0x030, 0x00002011,  BBREG_0x030,
	0x00004000,  BBREG_0x030, 0x00005000,  BBREG_0x030, 0x00006000,
	0x93000007,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x0ef,
	0x00000040,  BBREG_0x030, 0x00000645,  BBREG_0x030, 0x00001333,
	BBREG_0x030, 0x00002011,  BBREG_0x030, 0x00004000,  BBREG_0x030,
	0x00005000,  BBREG_0x030, 0x00006000,  0x93000008,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x0ef, 0x00000040,  BBREG_0x030,
	0x00000660,  BBREG_0x030, 0x00001443,  BBREG_0x030, 0x00002221,
	BBREG_0x030, 0x00004777,  BBREG_0x030, 0x00005777,  BBREG_0x030,
	0x00006777,  0x93000009,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x0ef, 0x00000040,  BBREG_0x030, 0x00000764,  BBREG_0x030,
	0x00001632,  BBREG_0x030, 0x00002421,  BBREG_0x030, 0x00004000,
	BBREG_0x030, 0x00005000,  BBREG_0x030, 0x00006000,  0x9300000a,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x0ef, 0x00000040,
	BBREG_0x030, 0x00000764,  BBREG_0x030, 0x00001632,  BBREG_0x030,
	0x00002421,  BBREG_0x030, 0x00004000,  BBREG_0x030, 0x00005000,
	BBREG_0x030, 0x00006000,  0x9300000b,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000040,  BBREG_0x030, 0x00000645,
	BBREG_0x030, 0x00001333,  BBREG_0x030, 0x00002011,  BBREG_0x030,
	0x00004000,  BBREG_0x030, 0x00005000,  BBREG_0x030, 0x00006000,
	0x9300000c,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x0ef,
	0x00000040,  BBREG_0x030, 0x00000767,  BBREG_0x030, 0x00001442,
	BBREG_0x030, 0x00002222,  BBREG_0x030, 0x00004777,  BBREG_0x030,
	0x00005777,  BBREG_0x030, 0x00006777,  0x9300000d,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x0ef, 0x00000040,  BBREG_0x030,
	0x00000765,  BBREG_0x030, 0x00001632,  BBREG_0x030, 0x00002451,
	BBREG_0x030, 0x00004000,  BBREG_0x030, 0x00005000,  BBREG_0x030,
	0x00006000,  0x9300000e,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x0ef, 0x00000040,  BBREG_0x030, 0x00000764,  BBREG_0x030,
	0x00001632,  BBREG_0x030, 0x00002421,  BBREG_0x030, 0x00004000,
	BBREG_0x030, 0x00005000,  BBREG_0x030, 0x00006000,  0x9300000f,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x0ef, 0x00000040,
	BBREG_0x030, 0x00000777,  BBREG_0x030, 0x00001454,  BBREG_0x030,
	0x00002224,  BBREG_0x030, 0x00004777,  BBREG_0x030, 0x00005777,
	BBREG_0x030, 0x00006777,  0x93000010,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000040,  BBREG_0x030, 0x00000777,
	BBREG_0x030, 0x00001442,  BBREG_0x030, 0x00002222,  BBREG_0x030,
	0x00004777,  BBREG_0x030, 0x00005777,  BBREG_0x030, 0x00006777,
	0x90000001,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x0ef,
	0x00000040,  BBREG_0x030, 0x00000645,  BBREG_0x030, 0x00001333,
	BBREG_0x030, 0x00002011,  BBREG_0x030, 0x00004000,  BBREG_0x030,
	0x00005000,  BBREG_0x030, 0x00006000,  0x90000002,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x0ef, 0x00000040,  BBREG_0x030,
	0x00000645,  BBREG_0x030, 0x00001333,  BBREG_0x030, 0x00002011,
	BBREG_0x030, 0x00004000,  BBREG_0x030, 0x00005000,  BBREG_0x030,
	0x00006000,  0x90000003,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x0ef, 0x00000040,  BBREG_0x030, 0x00000775,  BBREG_0x030,
	0x00001422,  BBREG_0x030, 0x00002210,  BBREG_0x030, 0x00004000,
	BBREG_0x030, 0x00005000,  BBREG_0x030, 0x00006000,  0x90000004,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x0ef, 0x00000040,
	BBREG_0x030, 0x00000645,  BBREG_0x030, 0x00001333,  BBREG_0x030,
	0x00002011,  BBREG_0x030, 0x00004000,  BBREG_0x030, 0x00005000,
	BBREG_0x030, 0x00006000,  0x90000005,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000040,  BBREG_0x030, 0x00000775,
	BBREG_0x030, 0x00001343,  BBREG_0x030, 0x00002210,  BBREG_0x030,
	0x00004000,  BBREG_0x030, 0x00005000,  BBREG_0x030, 0x00006000,
	0x90000006,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x0ef,
	0x00000040,  BBREG_0x030, 0x00000645,  BBREG_0x030, 0x00001333,
	BBREG_0x030, 0x00002011,  BBREG_0x030, 0x00004000,  BBREG_0x030,
	0x00005000,  BBREG_0x030, 0x00006000,  0x90000007,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x0ef, 0x00000040,  BBREG_0x030,
	0x00000645,  BBREG_0x030, 0x00001333,  BBREG_0x030, 0x00002011,
	BBREG_0x030, 0x00004000,  BBREG_0x030, 0x00005000,  BBREG_0x030,
	0x00006000,  0xA0000000,  0x00000000,  BBREG_0x0ef, 0x00000040,
	BBREG_0x030, 0x00000764,  BBREG_0x030, 0x00001632,  BBREG_0x030,
	0x00002421,  BBREG_0x030, 0x00004000,  BBREG_0x030, 0x00005000,
	BBREG_0x030, 0x00006000,  0xB0000000,  0x00000000,  BBREG_0x0ef,
	0x00000000,  BBREG_0x0ef, 0x00000800,  0x83000000,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x00000020,  BBREG_0x03f,
	0x00000C09,  BBREG_0x033, 0x00000021,  BBREG_0x03f, 0x00000C0C,
	BBREG_0x033, 0x00000022,  BBREG_0x03f, 0x00000C0F,  BBREG_0x033,
	0x00000023,  BBREG_0x03f, 0x00000C2C,  BBREG_0x033, 0x00000024,
	BBREG_0x03f, 0x00000C2F,  BBREG_0x033, 0x00000025,  BBREG_0x03f,
	0x00000C8A,  BBREG_0x033, 0x00000026,  BBREG_0x03f, 0x00000C8D,
	BBREG_0x033, 0x00000027,  BBREG_0x03f, 0x00000C90,  BBREG_0x033,
	0x00000028,  BBREG_0x03f, 0x00000CD0,  BBREG_0x033, 0x00000029,
	BBREG_0x03f, 0x00000CF2,  BBREG_0x033, 0x0000002A,  BBREG_0x03f,
	0x00000CF5,  0x93000001,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000020,  BBREG_0x03f, 0x00000007,  BBREG_0x033,
	0x00000021,  BBREG_0x03f, 0x0000000A,  BBREG_0x033, 0x00000022,
	BBREG_0x03f, 0x0000000D,  BBREG_0x033, 0x00000023,  BBREG_0x03f,
	0x0000002A,  BBREG_0x033, 0x00000024,  BBREG_0x03f, 0x0000002D,
	BBREG_0x033, 0x00000025,  BBREG_0x03f, 0x00000030,  BBREG_0x033,
	0x00000026,  BBREG_0x03f, 0x0000006D,  BBREG_0x033, 0x00000027,
	BBREG_0x03f, 0x00000070,  BBREG_0x033, 0x00000028,  BBREG_0x03f,
	0x000000ED,  BBREG_0x033, 0x00000029,  BBREG_0x03f, 0x000000F0,
	BBREG_0x033, 0x0000002A,  BBREG_0x03f, 0x000000F3,  0x93000002,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x00000020,
	BBREG_0x03f, 0x00000005,  BBREG_0x033, 0x00000021,  BBREG_0x03f,
	0x00000008,  BBREG_0x033, 0x00000022,  BBREG_0x03f, 0x0000000B,
	BBREG_0x033, 0x00000023,  BBREG_0x03f, 0x0000000E,  BBREG_0x033,
	0x00000024,  BBREG_0x03f, 0x0000002B,  BBREG_0x033, 0x00000025,
	BBREG_0x03f, 0x00000068,  BBREG_0x033, 0x00000026,  BBREG_0x03f,
	0x0000006B,  BBREG_0x033, 0x00000027,  BBREG_0x03f, 0x0000006E,
	BBREG_0x033, 0x00000028,  BBREG_0x03f, 0x00000071,  BBREG_0x033,
	0x00000029,  BBREG_0x03f, 0x00000074,  BBREG_0x033, 0x0000002A,
	BBREG_0x03f, 0x00000077,  0x93000003,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000020,  BBREG_0x03f, 0x00000429,
	BBREG_0x033, 0x00000021,  BBREG_0x03f, 0x00000828,  BBREG_0x033,
	0x00000022,  BBREG_0x03f, 0x00000847,  BBREG_0x033, 0x00000023,
	BBREG_0x03f, 0x0000084A,  BBREG_0x033, 0x00000024,  BBREG_0x03f,
	0x00000C4B,  BBREG_0x033, 0x00000025,  BBREG_0x03f, 0x00000C8A,
	BBREG_0x033, 0x00000026,  BBREG_0x03f, 0x00000CEA,  BBREG_0x033,
	0x00000027,  BBREG_0x03f, 0x00000CED,  BBREG_0x033, 0x00000028,
	BBREG_0x03f, 0x00000CF0,  BBREG_0x033, 0x00000029,  BBREG_0x03f,
	0x00000CF3,  BBREG_0x033, 0x0000002A,  BBREG_0x03f, 0x00000CF6,
	0x93000004,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x033,
	0x00000020,  BBREG_0x03f, 0x00000005,  BBREG_0x033, 0x00000021,
	BBREG_0x03f, 0x00000008,  BBREG_0x033, 0x00000022,  BBREG_0x03f,
	0x0000000B,  BBREG_0x033, 0x00000023,  BBREG_0x03f, 0x0000000E,
	BBREG_0x033, 0x00000024,  BBREG_0x03f, 0x0000002B,  BBREG_0x033,
	0x00000025,  BBREG_0x03f, 0x00000068,  BBREG_0x033, 0x00000026,
	BBREG_0x03f, 0x0000006B,  BBREG_0x033, 0x00000027,  BBREG_0x03f,
	0x0000006E,  BBREG_0x033, 0x00000028,  BBREG_0x03f, 0x00000071,
	BBREG_0x033, 0x00000029,  BBREG_0x03f, 0x00000074,  BBREG_0x033,
	0x0000002A,  BBREG_0x03f, 0x00000077,  0x93000005,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x00000020,  BBREG_0x03f,
	0x0000042B,  BBREG_0x033, 0x00000021,  BBREG_0x03f, 0x0000082A,
	BBREG_0x033, 0x00000022,  BBREG_0x03f, 0x00000849,  BBREG_0x033,
	0x00000023,  BBREG_0x03f, 0x0000084C,  BBREG_0x033, 0x00000024,
	BBREG_0x03f, 0x00000C4C,  BBREG_0x033, 0x00000025,  BBREG_0x03f,
	0x00000C6C,  BBREG_0x033, 0x00000026,  BBREG_0x03f, 0x00000CAC,
	BBREG_0x033, 0x00000027,  BBREG_0x03f, 0x00000CED,  BBREG_0x033,
	0x00000028,  BBREG_0x03f, 0x00000CF0,  BBREG_0x033, 0x00000029,
	BBREG_0x03f, 0x00000CF3,  BBREG_0x033, 0x0000002A,  BBREG_0x03f,
	0x00000CF6,  0x93000006,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000020,  BBREG_0x03f, 0x00000007,  BBREG_0x033,
	0x00000021,  BBREG_0x03f, 0x0000000A,  BBREG_0x033, 0x00000022,
	BBREG_0x03f, 0x0000000D,  BBREG_0x033, 0x00000023,  BBREG_0x03f,
	0x0000002A,  BBREG_0x033, 0x00000024,  BBREG_0x03f, 0x0000002D,
	BBREG_0x033, 0x00000025,  BBREG_0x03f, 0x00000030,  BBREG_0x033,
	0x00000026,  BBREG_0x03f, 0x0000006D,  BBREG_0x033, 0x00000027,
	BBREG_0x03f, 0x00000070,  BBREG_0x033, 0x00000028,  BBREG_0x03f,
	0x000000ED,  BBREG_0x033, 0x00000029,  BBREG_0x03f, 0x000000F0,
	BBREG_0x033, 0x0000002A,  BBREG_0x03f, 0x000000F3,  0x93000007,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x00000020,
	BBREG_0x03f, 0x00000007,  BBREG_0x033, 0x00000021,  BBREG_0x03f,
	0x0000000A,  BBREG_0x033, 0x00000022,  BBREG_0x03f, 0x0000000D,
	BBREG_0x033, 0x00000023,  BBREG_0x03f, 0x0000002A,  BBREG_0x033,
	0x00000024,  BBREG_0x03f, 0x0000002D,  BBREG_0x033, 0x00000025,
	BBREG_0x03f, 0x00000030,  BBREG_0x033, 0x00000026,  BBREG_0x03f,
	0x0000006D,  BBREG_0x033, 0x00000027,  BBREG_0x03f, 0x00000070,
	BBREG_0x033, 0x00000028,  BBREG_0x03f, 0x000000ED,  BBREG_0x033,
	0x00000029,  BBREG_0x03f, 0x000000F0,  BBREG_0x033, 0x0000002A,
	BBREG_0x03f, 0x000000F3,  0x93000008,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000020,  BBREG_0x03f, 0x00000C0C,
	BBREG_0x033, 0x00000021,  BBREG_0x03f, 0x00000C29,  BBREG_0x033,
	0x00000022,  BBREG_0x03f, 0x00000C2C,  BBREG_0x033, 0x00000023,
	BBREG_0x03f, 0x00000C69,  BBREG_0x033, 0x00000024,  BBREG_0x03f,
	0x00000CA8,  BBREG_0x033, 0x00000025,  BBREG_0x03f, 0x00000CE8,
	BBREG_0x033, 0x00000026,  BBREG_0x03f, 0x00000CEB,  BBREG_0x033,
	0x00000027,  BBREG_0x03f, 0x00000CEE,  BBREG_0x033, 0x00000028,
	BBREG_0x03f, 0x00000CF1,  BBREG_0x033, 0x00000029,  BBREG_0x03f,
	0x00000CF4,  BBREG_0x033, 0x0000002A,  BBREG_0x03f, 0x00000CF7,
	0x93000009,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x033,
	0x00000020,  BBREG_0x03f, 0x00000C09,  BBREG_0x033, 0x00000021,
	BBREG_0x03f, 0x00000C0C,  BBREG_0x033, 0x00000022,  BBREG_0x03f,
	0x00000C0F,  BBREG_0x033, 0x00000023,  BBREG_0x03f, 0x00000C2C,
	BBREG_0x033, 0x00000024,  BBREG_0x03f, 0x00000C2F,  BBREG_0x033,
	0x00000025,  BBREG_0x03f, 0x00000C8A,  BBREG_0x033, 0x00000026,
	BBREG_0x03f, 0x00000C8D,  BBREG_0x033, 0x00000027,  BBREG_0x03f,
	0x00000C90,  BBREG_0x033, 0x00000028,  BBREG_0x03f, 0x00000CD0,
	BBREG_0x033, 0x00000029,  BBREG_0x03f, 0x00000CF2,  BBREG_0x033,
	0x0000002A,  BBREG_0x03f, 0x00000CF5,  0x9300000a,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x00000020,  BBREG_0x03f,
	0x00000C09,  BBREG_0x033, 0x00000021,  BBREG_0x03f, 0x00000C0C,
	BBREG_0x033, 0x00000022,  BBREG_0x03f, 0x00000C0F,  BBREG_0x033,
	0x00000023,  BBREG_0x03f, 0x00000C2C,  BBREG_0x033, 0x00000024,
	BBREG_0x03f, 0x00000C2F,  BBREG_0x033, 0x00000025,  BBREG_0x03f,
	0x00000C8A,  BBREG_0x033, 0x00000026,  BBREG_0x03f, 0x00000C8D,
	BBREG_0x033, 0x00000027,  BBREG_0x03f, 0x00000C90,  BBREG_0x033,
	0x00000028,  BBREG_0x03f, 0x00000CD0,  BBREG_0x033, 0x00000029,
	BBREG_0x03f, 0x00000CF2,  BBREG_0x033, 0x0000002A,  BBREG_0x03f,
	0x00000CF5,  0x9300000b,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000020,  BBREG_0x03f, 0x00000007,  BBREG_0x033,
	0x00000021,  BBREG_0x03f, 0x0000000A,  BBREG_0x033, 0x00000022,
	BBREG_0x03f, 0x0000000D,  BBREG_0x033, 0x00000023,  BBREG_0x03f,
	0x0000002A,  BBREG_0x033, 0x00000024,  BBREG_0x03f, 0x0000002D,
	BBREG_0x033, 0x00000025,  BBREG_0x03f, 0x00000030,  BBREG_0x033,
	0x00000026,  BBREG_0x03f, 0x0000006D,  BBREG_0x033, 0x00000027,
	BBREG_0x03f, 0x00000070,  BBREG_0x033, 0x00000028,  BBREG_0x03f,
	0x000000ED,  BBREG_0x033, 0x00000029,  BBREG_0x03f, 0x000000F0,
	BBREG_0x033, 0x0000002A,  BBREG_0x03f, 0x000000F3,  0x9300000c,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x00000020,
	BBREG_0x03f, 0x00000429,  BBREG_0x033, 0x00000021,  BBREG_0x03f,
	0x00000828,  BBREG_0x033, 0x00000022,  BBREG_0x03f, 0x00000847,
	BBREG_0x033, 0x00000023,  BBREG_0x03f, 0x0000084A,  BBREG_0x033,
	0x00000024,  BBREG_0x03f, 0x00000C4B,  BBREG_0x033, 0x00000025,
	BBREG_0x03f, 0x00000CE5,  BBREG_0x033, 0x00000026,  BBREG_0x03f,
	0x00000CE8,  BBREG_0x033, 0x00000027,  BBREG_0x03f, 0x00000CEB,
	BBREG_0x033, 0x00000028,  BBREG_0x03f, 0x00000CEE,  BBREG_0x033,
	0x00000029,  BBREG_0x03f, 0x00000CF1,  BBREG_0x033, 0x0000002A,
	BBREG_0x03f, 0x00000CF4,  0x9300000d,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000020,  BBREG_0x03f, 0x00000C0B,
	BBREG_0x033, 0x00000021,  BBREG_0x03f, 0x00000C0E,  BBREG_0x033,
	0x00000022,  BBREG_0x03f, 0x00000C2B,  BBREG_0x033, 0x00000023,
	BBREG_0x03f, 0x00000C2E,  BBREG_0x033, 0x00000024,  BBREG_0x03f,
	0x00000C89,  BBREG_0x033, 0x00000025,  BBREG_0x03f, 0x00000CE8,
	BBREG_0x033, 0x00000026,  BBREG_0x03f, 0x00000CEB,  BBREG_0x033,
	0x00000027,  BBREG_0x03f, 0x00000CEE,  BBREG_0x033, 0x00000028,
	BBREG_0x03f, 0x00000CF1,  BBREG_0x033, 0x00000029,  BBREG_0x03f,
	0x00000CF4,  BBREG_0x033, 0x0000002A,  BBREG_0x03f, 0x00000CF7,
	0x9300000e,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x033,
	0x00000020,  BBREG_0x03f, 0x00000C09,  BBREG_0x033, 0x00000021,
	BBREG_0x03f, 0x00000C0C,  BBREG_0x033, 0x00000022,  BBREG_0x03f,
	0x00000C0F,  BBREG_0x033, 0x00000023,  BBREG_0x03f, 0x00000C2C,
	BBREG_0x033, 0x00000024,  BBREG_0x03f, 0x00000C2F,  BBREG_0x033,
	0x00000025,  BBREG_0x03f, 0x00000C8A,  BBREG_0x033, 0x00000026,
	BBREG_0x03f, 0x00000C8D,  BBREG_0x033, 0x00000027,  BBREG_0x03f,
	0x00000C90,  BBREG_0x033, 0x00000028,  BBREG_0x03f, 0x00000CD0,
	BBREG_0x033, 0x00000029,  BBREG_0x03f, 0x00000CF2,  BBREG_0x033,
	0x0000002A,  BBREG_0x03f, 0x00000CF5,  0x9300000f,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x00000020,  BBREG_0x03f,
	0x00000429,  BBREG_0x033, 0x00000021,  BBREG_0x03f, 0x00000828,
	BBREG_0x033, 0x00000022,  BBREG_0x03f, 0x00000847,  BBREG_0x033,
	0x00000023,  BBREG_0x03f, 0x0000084A,  BBREG_0x033, 0x00000024,
	BBREG_0x03f, 0x0000086A,  BBREG_0x033, 0x00000025,  BBREG_0x03f,
	0x0000086D,  BBREG_0x033, 0x00000026,  BBREG_0x03f, 0x00000870,
	BBREG_0x033, 0x00000027,  BBREG_0x03f, 0x00000891,  BBREG_0x033,
	0x00000028,  BBREG_0x03f, 0x00000894,  BBREG_0x033, 0x00000029,
	BBREG_0x03f, 0x000008B5,  BBREG_0x033, 0x0000002A,  BBREG_0x03f,
	0x000008F5,  0x93000010,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000020,  BBREG_0x03f, 0x00000429,  BBREG_0x033,
	0x00000021,  BBREG_0x03f, 0x00000828,  BBREG_0x033, 0x00000022,
	BBREG_0x03f, 0x00000847,  BBREG_0x033, 0x00000023,  BBREG_0x03f,
	0x0000084A,  BBREG_0x033, 0x00000024,  BBREG_0x03f, 0x00000C4B,
	BBREG_0x033, 0x00000025,  BBREG_0x03f, 0x00000C8A,  BBREG_0x033,
	0x00000026,  BBREG_0x03f, 0x00000CEA,  BBREG_0x033, 0x00000027,
	BBREG_0x03f, 0x00000CED,  BBREG_0x033, 0x00000028,  BBREG_0x03f,
	0x00000CF0,  BBREG_0x033, 0x00000029,  BBREG_0x03f, 0x00000CF3,
	BBREG_0x033, 0x0000002A,  BBREG_0x03f, 0x00000CF6,  0x90000001,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x00000020,
	BBREG_0x03f, 0x00000007,  BBREG_0x033, 0x00000021,  BBREG_0x03f,
	0x0000000A,  BBREG_0x033, 0x00000022,  BBREG_0x03f, 0x0000000D,
	BBREG_0x033, 0x00000023,  BBREG_0x03f, 0x0000002A,  BBREG_0x033,
	0x00000024,  BBREG_0x03f, 0x0000002D,  BBREG_0x033, 0x00000025,
	BBREG_0x03f, 0x00000030,  BBREG_0x033, 0x00000026,  BBREG_0x03f,
	0x0000006D,  BBREG_0x033, 0x00000027,  BBREG_0x03f, 0x00000070,
	BBREG_0x033, 0x00000028,  BBREG_0x03f, 0x000000ED,  BBREG_0x033,
	0x00000029,  BBREG_0x03f, 0x000000F0,  BBREG_0x033, 0x0000002A,
	BBREG_0x03f, 0x000000F3,  0x90000002,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000020,  BBREG_0x03f, 0x00000005,
	BBREG_0x033, 0x00000021,  BBREG_0x03f, 0x00000008,  BBREG_0x033,
	0x00000022,  BBREG_0x03f, 0x0000000B,  BBREG_0x033, 0x00000023,
	BBREG_0x03f, 0x0000000E,  BBREG_0x033, 0x00000024,  BBREG_0x03f,
	0x0000002B,  BBREG_0x033, 0x00000025,  BBREG_0x03f, 0x00000068,
	BBREG_0x033, 0x00000026,  BBREG_0x03f, 0x0000006B,  BBREG_0x033,
	0x00000027,  BBREG_0x03f, 0x0000006E,  BBREG_0x033, 0x00000028,
	BBREG_0x03f, 0x00000071,  BBREG_0x033, 0x00000029,  BBREG_0x03f,
	0x00000074,  BBREG_0x033, 0x0000002A,  BBREG_0x03f, 0x00000077,
	0x90000003,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x033,
	0x00000020,  BBREG_0x03f, 0x0000042B,  BBREG_0x033, 0x00000021,
	BBREG_0x03f, 0x0000082A,  BBREG_0x033, 0x00000022,  BBREG_0x03f,
	0x00000849,  BBREG_0x033, 0x00000023,  BBREG_0x03f, 0x0000084C,
	BBREG_0x033, 0x00000024,  BBREG_0x03f, 0x00000C4C,  BBREG_0x033,
	0x00000025,  BBREG_0x03f, 0x00000C8A,  BBREG_0x033, 0x00000026,
	BBREG_0x03f, 0x00000C8D,  BBREG_0x033, 0x00000027,  BBREG_0x03f,
	0x00000CEB,  BBREG_0x033, 0x00000028,  BBREG_0x03f, 0x00000CEE,
	BBREG_0x033, 0x00000029,  BBREG_0x03f, 0x00000CF1,  BBREG_0x033,
	0x0000002A,  BBREG_0x03f, 0x00000CF4,  0x90000004,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x00000020,  BBREG_0x03f,
	0x00000005,  BBREG_0x033, 0x00000021,  BBREG_0x03f, 0x00000008,
	BBREG_0x033, 0x00000022,  BBREG_0x03f, 0x0000000B,  BBREG_0x033,
	0x00000023,  BBREG_0x03f, 0x0000000E,  BBREG_0x033, 0x00000024,
	BBREG_0x03f, 0x0000002B,  BBREG_0x033, 0x00000025,  BBREG_0x03f,
	0x00000068,  BBREG_0x033, 0x00000026,  BBREG_0x03f, 0x0000006B,
	BBREG_0x033, 0x00000027,  BBREG_0x03f, 0x0000006E,  BBREG_0x033,
	0x00000028,  BBREG_0x03f, 0x00000071,  BBREG_0x033, 0x00000029,
	BBREG_0x03f, 0x00000074,  BBREG_0x033, 0x0000002A,  BBREG_0x03f,
	0x00000077,  0x90000005,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000020,  BBREG_0x03f, 0x0000042B,  BBREG_0x033,
	0x00000021,  BBREG_0x03f, 0x0000082A,  BBREG_0x033, 0x00000022,
	BBREG_0x03f, 0x00000849,  BBREG_0x033, 0x00000023,  BBREG_0x03f,
	0x0000084C,  BBREG_0x033, 0x00000024,  BBREG_0x03f, 0x00000C4C,
	BBREG_0x033, 0x00000025,  BBREG_0x03f, 0x00000C8A,  BBREG_0x033,
	0x00000026,  BBREG_0x03f, 0x00000C8D,  BBREG_0x033, 0x00000027,
	BBREG_0x03f, 0x00000CEB,  BBREG_0x033, 0x00000028,  BBREG_0x03f,
	0x00000CEE,  BBREG_0x033, 0x00000029,  BBREG_0x03f, 0x00000CF1,
	BBREG_0x033, 0x0000002A,  BBREG_0x03f, 0x00000CF4,  0x90000006,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x00000020,
	BBREG_0x03f, 0x00000007,  BBREG_0x033, 0x00000021,  BBREG_0x03f,
	0x0000000A,  BBREG_0x033, 0x00000022,  BBREG_0x03f, 0x0000000D,
	BBREG_0x033, 0x00000023,  BBREG_0x03f, 0x0000002A,  BBREG_0x033,
	0x00000024,  BBREG_0x03f, 0x0000002D,  BBREG_0x033, 0x00000025,
	BBREG_0x03f, 0x00000030,  BBREG_0x033, 0x00000026,  BBREG_0x03f,
	0x0000006D,  BBREG_0x033, 0x00000027,  BBREG_0x03f, 0x00000070,
	BBREG_0x033, 0x00000028,  BBREG_0x03f, 0x000000ED,  BBREG_0x033,
	0x00000029,  BBREG_0x03f, 0x000000F0,  BBREG_0x033, 0x0000002A,
	BBREG_0x03f, 0x000000F3,  0x90000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000020,  BBREG_0x03f, 0x00000007,
	BBREG_0x033, 0x00000021,  BBREG_0x03f, 0x0000000A,  BBREG_0x033,
	0x00000022,  BBREG_0x03f, 0x0000000D,  BBREG_0x033, 0x00000023,
	BBREG_0x03f, 0x0000002A,  BBREG_0x033, 0x00000024,  BBREG_0x03f,
	0x0000002D,  BBREG_0x033, 0x00000025,  BBREG_0x03f, 0x00000030,
	BBREG_0x033, 0x00000026,  BBREG_0x03f, 0x0000006D,  BBREG_0x033,
	0x00000027,  BBREG_0x03f, 0x00000070,  BBREG_0x033, 0x00000028,
	BBREG_0x03f, 0x000000ED,  BBREG_0x033, 0x00000029,  BBREG_0x03f,
	0x000000F0,  BBREG_0x033, 0x0000002A,  BBREG_0x03f, 0x000000F3,
	0xA0000000,  0x00000000,  BBREG_0x033, 0x00000020,  BBREG_0x03f,
	0x00000C09,  BBREG_0x033, 0x00000021,  BBREG_0x03f, 0x00000C0C,
	BBREG_0x033, 0x00000022,  BBREG_0x03f, 0x00000C0F,  BBREG_0x033,
	0x00000023,  BBREG_0x03f, 0x00000C2C,  BBREG_0x033, 0x00000024,
	BBREG_0x03f, 0x00000C2F,  BBREG_0x033, 0x00000025,  BBREG_0x03f,
	0x00000C8A,  BBREG_0x033, 0x00000026,  BBREG_0x03f, 0x00000C8D,
	BBREG_0x033, 0x00000027,  BBREG_0x03f, 0x00000C90,  BBREG_0x033,
	0x00000028,  BBREG_0x03f, 0x00000CD0,  BBREG_0x033, 0x00000029,
	BBREG_0x03f, 0x00000CF2,  BBREG_0x033, 0x0000002A,  BBREG_0x03f,
	0x00000CF5,  0xB0000000,  0x00000000,  0x83000000,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x00000060,  BBREG_0x03f,
	0x00000C0A,  BBREG_0x033, 0x00000061,  BBREG_0x03f, 0x00000C0D,
	BBREG_0x033, 0x00000062,  BBREG_0x03f, 0x00000C2A,  BBREG_0x033,
	0x00000063,  BBREG_0x03f, 0x00000C2D,  BBREG_0x033, 0x00000064,
	BBREG_0x03f, 0x00000C6A,  BBREG_0x033, 0x00000065,  BBREG_0x03f,
	0x00000CAA,  BBREG_0x033, 0x00000066,  BBREG_0x03f, 0x00000CAD,
	BBREG_0x033, 0x00000067,  BBREG_0x03f, 0x00000CB0,  BBREG_0x033,
	0x00000068,  BBREG_0x03f, 0x00000CF1,  BBREG_0x033, 0x00000069,
	BBREG_0x03f, 0x00000CF4,  BBREG_0x033, 0x0000006A,  BBREG_0x03f,
	0x00000CF7,  0x93000001,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000060,  BBREG_0x03f, 0x00000007,  BBREG_0x033,
	0x00000061,  BBREG_0x03f, 0x0000000A,  BBREG_0x033, 0x00000062,
	BBREG_0x03f, 0x0000000D,  BBREG_0x033, 0x00000063,  BBREG_0x03f,
	0x0000002A,  BBREG_0x033, 0x00000064,  BBREG_0x03f, 0x0000002D,
	BBREG_0x033, 0x00000065,  BBREG_0x03f, 0x00000030,  BBREG_0x033,
	0x00000066,  BBREG_0x03f, 0x0000006D,  BBREG_0x033, 0x00000067,
	BBREG_0x03f, 0x00000070,  BBREG_0x033, 0x00000068,  BBREG_0x03f,
	0x000000ED,  BBREG_0x033, 0x00000069,  BBREG_0x03f, 0x000000F0,
	BBREG_0x033, 0x0000006A,  BBREG_0x03f, 0x000000F3,  0x93000002,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x00000060,
	BBREG_0x03f, 0x00000005,  BBREG_0x033, 0x00000061,  BBREG_0x03f,
	0x00000008,  BBREG_0x033, 0x00000062,  BBREG_0x03f, 0x0000000B,
	BBREG_0x033, 0x00000063,  BBREG_0x03f, 0x0000000E,  BBREG_0x033,
	0x00000064,  BBREG_0x03f, 0x0000002B,  BBREG_0x033, 0x00000065,
	BBREG_0x03f, 0x00000068,  BBREG_0x033, 0x00000066,  BBREG_0x03f,
	0x0000006B,  BBREG_0x033, 0x00000067,  BBREG_0x03f, 0x0000006E,
	BBREG_0x033, 0x00000068,  BBREG_0x03f, 0x00000071,  BBREG_0x033,
	0x00000069,  BBREG_0x03f, 0x00000074,  BBREG_0x033, 0x0000006A,
	BBREG_0x03f, 0x00000077,  0x93000003,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000060,  BBREG_0x03f, 0x00000429,
	BBREG_0x033, 0x00000061,  BBREG_0x03f, 0x00000828,  BBREG_0x033,
	0x00000062,  BBREG_0x03f, 0x00000847,  BBREG_0x033, 0x00000063,
	BBREG_0x03f, 0x0000084A,  BBREG_0x033, 0x00000064,  BBREG_0x03f,
	0x00000C4B,  BBREG_0x033, 0x00000065,  BBREG_0x03f, 0x00000C8A,
	BBREG_0x033, 0x00000066,  BBREG_0x03f, 0x00000CEA,  BBREG_0x033,
	0x00000067,  BBREG_0x03f, 0x00000CED,  BBREG_0x033, 0x00000068,
	BBREG_0x03f, 0x00000CF0,  BBREG_0x033, 0x00000069,  BBREG_0x03f,
	0x00000CF3,  BBREG_0x033, 0x0000006A,  BBREG_0x03f, 0x00000CF6,
	0x93000004,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x033,
	0x00000060,  BBREG_0x03f, 0x00000005,  BBREG_0x033, 0x00000061,
	BBREG_0x03f, 0x00000008,  BBREG_0x033, 0x00000062,  BBREG_0x03f,
	0x0000000B,  BBREG_0x033, 0x00000063,  BBREG_0x03f, 0x0000000E,
	BBREG_0x033, 0x00000064,  BBREG_0x03f, 0x0000002B,  BBREG_0x033,
	0x00000065,  BBREG_0x03f, 0x00000068,  BBREG_0x033, 0x00000066,
	BBREG_0x03f, 0x0000006B,  BBREG_0x033, 0x00000067,  BBREG_0x03f,
	0x0000006E,  BBREG_0x033, 0x00000068,  BBREG_0x03f, 0x00000071,
	BBREG_0x033, 0x00000069,  BBREG_0x03f, 0x00000074,  BBREG_0x033,
	0x0000006A,  BBREG_0x03f, 0x00000077,  0x93000005,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x00000060,  BBREG_0x03f,
	0x0000042A,  BBREG_0x033, 0x00000061,  BBREG_0x03f, 0x00000829,
	BBREG_0x033, 0x00000062,  BBREG_0x03f, 0x00000848,  BBREG_0x033,
	0x00000063,  BBREG_0x03f, 0x0000084B,  BBREG_0x033, 0x00000064,
	BBREG_0x03f, 0x00000C4B,  BBREG_0x033, 0x00000065,  BBREG_0x03f,
	0x00000C6C,  BBREG_0x033, 0x00000066,  BBREG_0x03f, 0x00000CAC,
	BBREG_0x033, 0x00000067,  BBREG_0x03f, 0x00000CED,  BBREG_0x033,
	0x00000068,  BBREG_0x03f, 0x00000CF0,  BBREG_0x033, 0x00000069,
	BBREG_0x03f, 0x00000CF3,  BBREG_0x033, 0x0000006A,  BBREG_0x03f,
	0x00000CF6,  0x93000006,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000060,  BBREG_0x03f, 0x00000007,  BBREG_0x033,
	0x00000061,  BBREG_0x03f, 0x0000000A,  BBREG_0x033, 0x00000062,
	BBREG_0x03f, 0x0000000D,  BBREG_0x033, 0x00000063,  BBREG_0x03f,
	0x0000002A,  BBREG_0x033, 0x00000064,  BBREG_0x03f, 0x0000002D,
	BBREG_0x033, 0x00000065,  BBREG_0x03f, 0x00000030,  BBREG_0x033,
	0x00000066,  BBREG_0x03f, 0x0000006D,  BBREG_0x033, 0x00000067,
	BBREG_0x03f, 0x00000070,  BBREG_0x033, 0x00000068,  BBREG_0x03f,
	0x000000ED,  BBREG_0x033, 0x00000069,  BBREG_0x03f, 0x000000F0,
	BBREG_0x033, 0x0000006A,  BBREG_0x03f, 0x000000F3,  0x93000007,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x00000060,
	BBREG_0x03f, 0x00000007,  BBREG_0x033, 0x00000061,  BBREG_0x03f,
	0x0000000A,  BBREG_0x033, 0x00000062,  BBREG_0x03f, 0x0000000D,
	BBREG_0x033, 0x00000063,  BBREG_0x03f, 0x0000002A,  BBREG_0x033,
	0x00000064,  BBREG_0x03f, 0x0000002D,  BBREG_0x033, 0x00000065,
	BBREG_0x03f, 0x00000030,  BBREG_0x033, 0x00000066,  BBREG_0x03f,
	0x0000006D,  BBREG_0x033, 0x00000067,  BBREG_0x03f, 0x00000070,
	BBREG_0x033, 0x00000068,  BBREG_0x03f, 0x000000ED,  BBREG_0x033,
	0x00000069,  BBREG_0x03f, 0x000000F0,  BBREG_0x033, 0x0000006A,
	BBREG_0x03f, 0x000000F3,  0x93000008,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000060,  BBREG_0x03f, 0x0000080B,
	BBREG_0x033, 0x00000061,  BBREG_0x03f, 0x0000080E,  BBREG_0x033,
	0x00000062,  BBREG_0x03f, 0x00000848,  BBREG_0x033, 0x00000063,
	BBREG_0x03f, 0x00000869,  BBREG_0x033, 0x00000064,  BBREG_0x03f,
	0x000008A9,  BBREG_0x033, 0x00000065,  BBREG_0x03f, 0x00000CE8,
	BBREG_0x033, 0x00000066,  BBREG_0x03f, 0x00000CEB,  BBREG_0x033,
	0x00000067,  BBREG_0x03f, 0x00000CEE,  BBREG_0x033, 0x00000068,
	BBREG_0x03f, 0x00000CF1,  BBREG_0x033, 0x00000069,  BBREG_0x03f,
	0x00000CF4,  BBREG_0x033, 0x0000006A,  BBREG_0x03f, 0x00000CF7,
	0x93000009,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x033,
	0x00000060,  BBREG_0x03f, 0x00000C0A,  BBREG_0x033, 0x00000061,
	BBREG_0x03f, 0x00000C0D,  BBREG_0x033, 0x00000062,  BBREG_0x03f,
	0x00000C2A,  BBREG_0x033, 0x00000063,  BBREG_0x03f, 0x00000C2D,
	BBREG_0x033, 0x00000064,  BBREG_0x03f, 0x00000C6A,  BBREG_0x033,
	0x00000065,  BBREG_0x03f, 0x00000CAA,  BBREG_0x033, 0x00000066,
	BBREG_0x03f, 0x00000CAD,  BBREG_0x033, 0x00000067,  BBREG_0x03f,
	0x00000CB0,  BBREG_0x033, 0x00000068,  BBREG_0x03f, 0x00000CF1,
	BBREG_0x033, 0x00000069,  BBREG_0x03f, 0x00000CF4,  BBREG_0x033,
	0x0000006A,  BBREG_0x03f, 0x00000CF7,  0x9300000a,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x00000060,  BBREG_0x03f,
	0x00000C0A,  BBREG_0x033, 0x00000061,  BBREG_0x03f, 0x00000C0D,
	BBREG_0x033, 0x00000062,  BBREG_0x03f, 0x00000C2A,  BBREG_0x033,
	0x00000063,  BBREG_0x03f, 0x00000C2D,  BBREG_0x033, 0x00000064,
	BBREG_0x03f, 0x00000C6A,  BBREG_0x033, 0x00000065,  BBREG_0x03f,
	0x00000CAA,  BBREG_0x033, 0x00000066,  BBREG_0x03f, 0x00000CAD,
	BBREG_0x033, 0x00000067,  BBREG_0x03f, 0x00000CB0,  BBREG_0x033,
	0x00000068,  BBREG_0x03f, 0x00000CF1,  BBREG_0x033, 0x00000069,
	BBREG_0x03f, 0x00000CF4,  BBREG_0x033, 0x0000006A,  BBREG_0x03f,
	0x00000CF7,  0x9300000b,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000060,  BBREG_0x03f, 0x00000005,  BBREG_0x033,
	0x00000061,  BBREG_0x03f, 0x00000008,  BBREG_0x033, 0x00000062,
	BBREG_0x03f, 0x0000000B,  BBREG_0x033, 0x00000063,  BBREG_0x03f,
	0x0000000E,  BBREG_0x033, 0x00000064,  BBREG_0x03f, 0x0000002B,
	BBREG_0x033, 0x00000065,  BBREG_0x03f, 0x00000068,  BBREG_0x033,
	0x00000066,  BBREG_0x03f, 0x0000006B,  BBREG_0x033, 0x00000067,
	BBREG_0x03f, 0x0000006E,  BBREG_0x033, 0x00000068,  BBREG_0x03f,
	0x00000071,  BBREG_0x033, 0x00000069,  BBREG_0x03f, 0x00000074,
	BBREG_0x033, 0x0000006A,  BBREG_0x03f, 0x00000077,  0x9300000c,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x00000060,
	BBREG_0x03f, 0x00000429,  BBREG_0x033, 0x00000061,  BBREG_0x03f,
	0x00000828,  BBREG_0x033, 0x00000062,  BBREG_0x03f, 0x00000847,
	BBREG_0x033, 0x00000063,  BBREG_0x03f, 0x0000084A,  BBREG_0x033,
	0x00000064,  BBREG_0x03f, 0x00000C4B,  BBREG_0x033, 0x00000065,
	BBREG_0x03f, 0x00000CE5,  BBREG_0x033, 0x00000066,  BBREG_0x03f,
	0x00000CE8,  BBREG_0x033, 0x00000067,  BBREG_0x03f, 0x00000CEB,
	BBREG_0x033, 0x00000068,  BBREG_0x03f, 0x00000CEE,  BBREG_0x033,
	0x00000069,  BBREG_0x03f, 0x00000CF1,  BBREG_0x033, 0x0000006A,
	BBREG_0x03f, 0x00000CF4,  0x9300000d,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000060,  BBREG_0x03f, 0x00000C0A,
	BBREG_0x033, 0x00000061,  BBREG_0x03f, 0x00000C0D,  BBREG_0x033,
	0x00000062,  BBREG_0x03f, 0x00000C10,  BBREG_0x033, 0x00000063,
	BBREG_0x03f, 0x00000C4A,  BBREG_0x033, 0x00000064,  BBREG_0x03f,
	0x00000C4D,  BBREG_0x033, 0x00000065,  BBREG_0x03f, 0x00000CC9,
	BBREG_0x033, 0x00000066,  BBREG_0x03f, 0x00000CEB,  BBREG_0x033,
	0x00000067,  BBREG_0x03f, 0x00000CEE,  BBREG_0x033, 0x00000068,
	BBREG_0x03f, 0x00000CF1,  BBREG_0x033, 0x00000069,  BBREG_0x03f,
	0x00000CF4,  BBREG_0x033, 0x0000006A,  BBREG_0x03f, 0x00000CF7,
	0x9300000e,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x033,
	0x00000060,  BBREG_0x03f, 0x00000C0A,  BBREG_0x033, 0x00000061,
	BBREG_0x03f, 0x00000C0D,  BBREG_0x033, 0x00000062,  BBREG_0x03f,
	0x00000C2A,  BBREG_0x033, 0x00000063,  BBREG_0x03f, 0x00000C2D,
	BBREG_0x033, 0x00000064,  BBREG_0x03f, 0x00000C6A,  BBREG_0x033,
	0x00000065,  BBREG_0x03f, 0x00000CAA,  BBREG_0x033, 0x00000066,
	BBREG_0x03f, 0x00000CAD,  BBREG_0x033, 0x00000067,  BBREG_0x03f,
	0x00000CB0,  BBREG_0x033, 0x00000068,  BBREG_0x03f, 0x00000CF1,
	BBREG_0x033, 0x00000069,  BBREG_0x03f, 0x00000CF4,  BBREG_0x033,
	0x0000006A,  BBREG_0x03f, 0x00000CF7,  0x9300000f,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x00000060,  BBREG_0x03f,
	0x00000429,  BBREG_0x033, 0x00000061,  BBREG_0x03f, 0x00000828,
	BBREG_0x033, 0x00000062,  BBREG_0x03f, 0x00000847,  BBREG_0x033,
	0x00000063,  BBREG_0x03f, 0x0000084A,  BBREG_0x033, 0x00000064,
	BBREG_0x03f, 0x0000086A,  BBREG_0x033, 0x00000065,  BBREG_0x03f,
	0x0000086D,  BBREG_0x033, 0x00000066,  BBREG_0x03f, 0x00000870,
	BBREG_0x033, 0x00000067,  BBREG_0x03f, 0x00000891,  BBREG_0x033,
	0x00000068,  BBREG_0x03f, 0x00000894,  BBREG_0x033, 0x00000069,
	BBREG_0x03f, 0x000008B5,  BBREG_0x033, 0x0000006A,  BBREG_0x03f,
	0x000008F5,  0x93000010,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000060,  BBREG_0x03f, 0x00000429,  BBREG_0x033,
	0x00000061,  BBREG_0x03f, 0x00000828,  BBREG_0x033, 0x00000062,
	BBREG_0x03f, 0x00000847,  BBREG_0x033, 0x00000063,  BBREG_0x03f,
	0x0000084A,  BBREG_0x033, 0x00000064,  BBREG_0x03f, 0x00000C4B,
	BBREG_0x033, 0x00000065,  BBREG_0x03f, 0x00000C8A,  BBREG_0x033,
	0x00000066,  BBREG_0x03f, 0x00000CEA,  BBREG_0x033, 0x00000067,
	BBREG_0x03f, 0x00000CED,  BBREG_0x033, 0x00000068,  BBREG_0x03f,
	0x00000CF0,  BBREG_0x033, 0x00000069,  BBREG_0x03f, 0x00000CF3,
	BBREG_0x033, 0x0000006A,  BBREG_0x03f, 0x00000CF6,  0x90000001,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x00000060,
	BBREG_0x03f, 0x00000007,  BBREG_0x033, 0x00000061,  BBREG_0x03f,
	0x0000000A,  BBREG_0x033, 0x00000062,  BBREG_0x03f, 0x0000000D,
	BBREG_0x033, 0x00000063,  BBREG_0x03f, 0x0000002A,  BBREG_0x033,
	0x00000064,  BBREG_0x03f, 0x0000002D,  BBREG_0x033, 0x00000065,
	BBREG_0x03f, 0x00000030,  BBREG_0x033, 0x00000066,  BBREG_0x03f,
	0x0000006D,  BBREG_0x033, 0x00000067,  BBREG_0x03f, 0x00000070,
	BBREG_0x033, 0x00000068,  BBREG_0x03f, 0x000000ED,  BBREG_0x033,
	0x00000069,  BBREG_0x03f, 0x000000F0,  BBREG_0x033, 0x0000006A,
	BBREG_0x03f, 0x000000F3,  0x90000002,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000060,  BBREG_0x03f, 0x00000005,
	BBREG_0x033, 0x00000061,  BBREG_0x03f, 0x00000008,  BBREG_0x033,
	0x00000062,  BBREG_0x03f, 0x0000000B,  BBREG_0x033, 0x00000063,
	BBREG_0x03f, 0x0000000E,  BBREG_0x033, 0x00000064,  BBREG_0x03f,
	0x0000002B,  BBREG_0x033, 0x00000065,  BBREG_0x03f, 0x00000068,
	BBREG_0x033, 0x00000066,  BBREG_0x03f, 0x0000006B,  BBREG_0x033,
	0x00000067,  BBREG_0x03f, 0x0000006E,  BBREG_0x033, 0x00000068,
	BBREG_0x03f, 0x00000071,  BBREG_0x033, 0x00000069,  BBREG_0x03f,
	0x00000074,  BBREG_0x033, 0x0000006A,  BBREG_0x03f, 0x00000077,
	0x90000003,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x033,
	0x00000060,  BBREG_0x03f, 0x0000042C,  BBREG_0x033, 0x00000061,
	BBREG_0x03f, 0x0000082B,  BBREG_0x033, 0x00000062,  BBREG_0x03f,
	0x0000084A,  BBREG_0x033, 0x00000063,  BBREG_0x03f, 0x0000084D,
	BBREG_0x033, 0x00000064,  BBREG_0x03f, 0x00000C4D,  BBREG_0x033,
	0x00000065,  BBREG_0x03f, 0x00000C8B,  BBREG_0x033, 0x00000066,
	BBREG_0x03f, 0x00000C8E,  BBREG_0x033, 0x00000067,  BBREG_0x03f,
	0x00000CEC,  BBREG_0x033, 0x00000068,  BBREG_0x03f, 0x00000CEF,
	BBREG_0x033, 0x00000069,  BBREG_0x03f, 0x00000CF2,  BBREG_0x033,
	0x0000006A,  BBREG_0x03f, 0x00000CF5,  0x90000004,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x00000060,  BBREG_0x03f,
	0x00000005,  BBREG_0x033, 0x00000061,  BBREG_0x03f, 0x00000008,
	BBREG_0x033, 0x00000062,  BBREG_0x03f, 0x0000000B,  BBREG_0x033,
	0x00000063,  BBREG_0x03f, 0x0000000E,  BBREG_0x033, 0x00000064,
	BBREG_0x03f, 0x0000002B,  BBREG_0x033, 0x00000065,  BBREG_0x03f,
	0x00000068,  BBREG_0x033, 0x00000066,  BBREG_0x03f, 0x0000006B,
	BBREG_0x033, 0x00000067,  BBREG_0x03f, 0x0000006E,  BBREG_0x033,
	0x00000068,  BBREG_0x03f, 0x00000071,  BBREG_0x033, 0x00000069,
	BBREG_0x03f, 0x00000074,  BBREG_0x033, 0x0000006A,  BBREG_0x03f,
	0x00000077,  0x90000005,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000060,  BBREG_0x03f, 0x0000042C,  BBREG_0x033,
	0x00000061,  BBREG_0x03f, 0x0000082B,  BBREG_0x033, 0x00000062,
	BBREG_0x03f, 0x0000084A,  BBREG_0x033, 0x00000063,  BBREG_0x03f,
	0x0000084D,  BBREG_0x033, 0x00000064,  BBREG_0x03f, 0x00000C4D,
	BBREG_0x033, 0x00000065,  BBREG_0x03f, 0x00000C8B,  BBREG_0x033,
	0x00000066,  BBREG_0x03f, 0x00000C8E,  BBREG_0x033, 0x00000067,
	BBREG_0x03f, 0x00000CEC,  BBREG_0x033, 0x00000068,  BBREG_0x03f,
	0x00000CEF,  BBREG_0x033, 0x00000069,  BBREG_0x03f, 0x00000CF2,
	BBREG_0x033, 0x0000006A,  BBREG_0x03f, 0x00000CF5,  0x90000006,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x00000060,
	BBREG_0x03f, 0x00000007,  BBREG_0x033, 0x00000061,  BBREG_0x03f,
	0x0000000A,  BBREG_0x033, 0x00000062,  BBREG_0x03f, 0x0000000D,
	BBREG_0x033, 0x00000063,  BBREG_0x03f, 0x0000002A,  BBREG_0x033,
	0x00000064,  BBREG_0x03f, 0x0000002D,  BBREG_0x033, 0x00000065,
	BBREG_0x03f, 0x00000030,  BBREG_0x033, 0x00000066,  BBREG_0x03f,
	0x0000006D,  BBREG_0x033, 0x00000067,  BBREG_0x03f, 0x00000070,
	BBREG_0x033, 0x00000068,  BBREG_0x03f, 0x000000ED,  BBREG_0x033,
	0x00000069,  BBREG_0x03f, 0x000000F0,  BBREG_0x033, 0x0000006A,
	BBREG_0x03f, 0x000000F3,  0x90000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000060,  BBREG_0x03f, 0x00000007,
	BBREG_0x033, 0x00000061,  BBREG_0x03f, 0x0000000A,  BBREG_0x033,
	0x00000062,  BBREG_0x03f, 0x0000000D,  BBREG_0x033, 0x00000063,
	BBREG_0x03f, 0x0000002A,  BBREG_0x033, 0x00000064,  BBREG_0x03f,
	0x0000002D,  BBREG_0x033, 0x00000065,  BBREG_0x03f, 0x00000030,
	BBREG_0x033, 0x00000066,  BBREG_0x03f, 0x0000006D,  BBREG_0x033,
	0x00000067,  BBREG_0x03f, 0x00000070,  BBREG_0x033, 0x00000068,
	BBREG_0x03f, 0x000000ED,  BBREG_0x033, 0x00000069,  BBREG_0x03f,
	0x000000F0,  BBREG_0x033, 0x0000006A,  BBREG_0x03f, 0x000000F3,
	0xA0000000,  0x00000000,  BBREG_0x033, 0x00000060,  BBREG_0x03f,
	0x00000C0A,  BBREG_0x033, 0x00000061,  BBREG_0x03f, 0x00000C0D,
	BBREG_0x033, 0x00000062,  BBREG_0x03f, 0x00000C2A,  BBREG_0x033,
	0x00000063,  BBREG_0x03f, 0x00000C2D,  BBREG_0x033, 0x00000064,
	BBREG_0x03f, 0x00000C6A,  BBREG_0x033, 0x00000065,  BBREG_0x03f,
	0x00000CAA,  BBREG_0x033, 0x00000066,  BBREG_0x03f, 0x00000CAD,
	BBREG_0x033, 0x00000067,  BBREG_0x03f, 0x00000CB0,  BBREG_0x033,
	0x00000068,  BBREG_0x03f, 0x00000CF1,  BBREG_0x033, 0x00000069,
	BBREG_0x03f, 0x00000CF4,  BBREG_0x033, 0x0000006A,  BBREG_0x03f,
	0x00000CF7,  0xB0000000,  0x00000000,  0x83000000,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x000000A0,  BBREG_0x03f,
	0x00000C09,  BBREG_0x033, 0x000000A1,  BBREG_0x03f, 0x00000C0C,
	BBREG_0x033, 0x000000A2,  BBREG_0x03f, 0x00000C0F,  BBREG_0x033,
	0x000000A3,  BBREG_0x03f, 0x00000C2C,  BBREG_0x033, 0x000000A4,
	BBREG_0x03f, 0x00000C2F,  BBREG_0x033, 0x000000A5,  BBREG_0x03f,
	0x00000C8A,  BBREG_0x033, 0x000000A6,  BBREG_0x03f, 0x00000C8D,
	BBREG_0x033, 0x000000A7,  BBREG_0x03f, 0x00000C90,  BBREG_0x033,
	0x000000A8,  BBREG_0x03f, 0x00000CEF,  BBREG_0x033, 0x000000A9,
	BBREG_0x03f, 0x00000CF2,  BBREG_0x033, 0x000000AA,  BBREG_0x03f,
	0x00000CF5,  0x93000001,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x000000A0,  BBREG_0x03f, 0x00000007,  BBREG_0x033,
	0x000000A1,  BBREG_0x03f, 0x0000000A,  BBREG_0x033, 0x000000A2,
	BBREG_0x03f, 0x0000000D,  BBREG_0x033, 0x000000A3,  BBREG_0x03f,
	0x0000002A,  BBREG_0x033, 0x000000A4,  BBREG_0x03f, 0x0000002D,
	BBREG_0x033, 0x000000A5,  BBREG_0x03f, 0x00000030,  BBREG_0x033,
	0x000000A6,  BBREG_0x03f, 0x0000006D,  BBREG_0x033, 0x000000A7,
	BBREG_0x03f, 0x00000070,  BBREG_0x033, 0x000000A8,  BBREG_0x03f,
	0x000000ED,  BBREG_0x033, 0x000000A9,  BBREG_0x03f, 0x000000F0,
	BBREG_0x033, 0x000000AA,  BBREG_0x03f, 0x000000F3,  0x93000002,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x000000A0,
	BBREG_0x03f, 0x00000005,  BBREG_0x033, 0x000000A1,  BBREG_0x03f,
	0x00000008,  BBREG_0x033, 0x000000A2,  BBREG_0x03f, 0x0000000B,
	BBREG_0x033, 0x000000A3,  BBREG_0x03f, 0x0000000E,  BBREG_0x033,
	0x000000A4,  BBREG_0x03f, 0x00000047,  BBREG_0x033, 0x000000A5,
	BBREG_0x03f, 0x0000004A,  BBREG_0x033, 0x000000A6,  BBREG_0x03f,
	0x0000004D,  BBREG_0x033, 0x000000A7,  BBREG_0x03f, 0x00000050,
	BBREG_0x033, 0x000000A8,  BBREG_0x03f, 0x00000053,  BBREG_0x033,
	0x000000A9,  BBREG_0x03f, 0x00000056,  BBREG_0x033, 0x000000AA,
	BBREG_0x03f, 0x00000094,  0x93000003,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x000000A0,  BBREG_0x03f, 0x00000429,
	BBREG_0x033, 0x000000A1,  BBREG_0x03f, 0x00000828,  BBREG_0x033,
	0x000000A2,  BBREG_0x03f, 0x00000847,  BBREG_0x033, 0x000000A3,
	BBREG_0x03f, 0x0000084A,  BBREG_0x033, 0x000000A4,  BBREG_0x03f,
	0x00000C4B,  BBREG_0x033, 0x000000A5,  BBREG_0x03f, 0x00000C8A,
	BBREG_0x033, 0x000000A6,  BBREG_0x03f, 0x00000CEA,  BBREG_0x033,
	0x000000A7,  BBREG_0x03f, 0x00000CED,  BBREG_0x033, 0x000000A8,
	BBREG_0x03f, 0x00000CF0,  BBREG_0x033, 0x000000A9,  BBREG_0x03f,
	0x00000CF3,  BBREG_0x033, 0x000000AA,  BBREG_0x03f, 0x00000CF6,
	0x93000004,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x033,
	0x000000A0,  BBREG_0x03f, 0x00000005,  BBREG_0x033, 0x000000A1,
	BBREG_0x03f, 0x00000008,  BBREG_0x033, 0x000000A2,  BBREG_0x03f,
	0x0000000B,  BBREG_0x033, 0x000000A3,  BBREG_0x03f, 0x0000000E,
	BBREG_0x033, 0x000000A4,  BBREG_0x03f, 0x00000047,  BBREG_0x033,
	0x000000A5,  BBREG_0x03f, 0x0000004A,  BBREG_0x033, 0x000000A6,
	BBREG_0x03f, 0x0000004D,  BBREG_0x033, 0x000000A7,  BBREG_0x03f,
	0x00000050,  BBREG_0x033, 0x000000A8,  BBREG_0x03f, 0x00000053,
	BBREG_0x033, 0x000000A9,  BBREG_0x03f, 0x00000056,  BBREG_0x033,
	0x000000AA,  BBREG_0x03f, 0x00000094,  0x93000005,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x000000A0,  BBREG_0x03f,
	0x00000429,  BBREG_0x033, 0x000000A1,  BBREG_0x03f, 0x00000828,
	BBREG_0x033, 0x000000A2,  BBREG_0x03f, 0x00000847,  BBREG_0x033,
	0x000000A3,  BBREG_0x03f, 0x0000084A,  BBREG_0x033, 0x000000A4,
	BBREG_0x03f, 0x00000C4B,  BBREG_0x033, 0x000000A5,  BBREG_0x03f,
	0x00000C6C,  BBREG_0x033, 0x000000A6,  BBREG_0x03f, 0x00000CAC,
	BBREG_0x033, 0x000000A7,  BBREG_0x03f, 0x00000CED,  BBREG_0x033,
	0x000000A8,  BBREG_0x03f, 0x00000CF0,  BBREG_0x033, 0x000000A9,
	BBREG_0x03f, 0x00000CF3,  BBREG_0x033, 0x000000AA,  BBREG_0x03f,
	0x00000CF6,  0x93000006,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x000000A0,  BBREG_0x03f, 0x00000007,  BBREG_0x033,
	0x000000A1,  BBREG_0x03f, 0x0000000A,  BBREG_0x033, 0x000000A2,
	BBREG_0x03f, 0x0000000D,  BBREG_0x033, 0x000000A3,  BBREG_0x03f,
	0x0000002A,  BBREG_0x033, 0x000000A4,  BBREG_0x03f, 0x0000002D,
	BBREG_0x033, 0x000000A5,  BBREG_0x03f, 0x00000030,  BBREG_0x033,
	0x000000A6,  BBREG_0x03f, 0x0000006D,  BBREG_0x033, 0x000000A7,
	BBREG_0x03f, 0x00000070,  BBREG_0x033, 0x000000A8,  BBREG_0x03f,
	0x000000ED,  BBREG_0x033, 0x000000A9,  BBREG_0x03f, 0x000000F0,
	BBREG_0x033, 0x000000AA,  BBREG_0x03f, 0x000000F3,  0x93000007,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x000000A0,
	BBREG_0x03f, 0x00000007,  BBREG_0x033, 0x000000A1,  BBREG_0x03f,
	0x0000000A,  BBREG_0x033, 0x000000A2,  BBREG_0x03f, 0x0000000D,
	BBREG_0x033, 0x000000A3,  BBREG_0x03f, 0x0000002A,  BBREG_0x033,
	0x000000A4,  BBREG_0x03f, 0x0000002D,  BBREG_0x033, 0x000000A5,
	BBREG_0x03f, 0x00000030,  BBREG_0x033, 0x000000A6,  BBREG_0x03f,
	0x0000006D,  BBREG_0x033, 0x000000A7,  BBREG_0x03f, 0x00000070,
	BBREG_0x033, 0x000000A8,  BBREG_0x03f, 0x000000ED,  BBREG_0x033,
	0x000000A9,  BBREG_0x03f, 0x000000F0,  BBREG_0x033, 0x000000AA,
	BBREG_0x03f, 0x000000F3,  0x93000008,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x000000A0,  BBREG_0x03f, 0x00000C0A,
	BBREG_0x033, 0x000000A1,  BBREG_0x03f, 0x00000C0D,  BBREG_0x033,
	0x000000A2,  BBREG_0x03f, 0x00000C2A,  BBREG_0x033, 0x000000A3,
	BBREG_0x03f, 0x00000C2D,  BBREG_0x033, 0x000000A4,  BBREG_0x03f,
	0x00000C6A,  BBREG_0x033, 0x000000A5,  BBREG_0x03f, 0x00000CE8,
	BBREG_0x033, 0x000000A6,  BBREG_0x03f, 0x00000CEB,  BBREG_0x033,
	0x000000A7,  BBREG_0x03f, 0x00000CEE,  BBREG_0x033, 0x000000A8,
	BBREG_0x03f, 0x00000CF1,  BBREG_0x033, 0x000000A9,  BBREG_0x03f,
	0x00000CF4,  BBREG_0x033, 0x000000AA,  BBREG_0x03f, 0x00000CF7,
	0x93000009,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x033,
	0x000000A0,  BBREG_0x03f, 0x00000C09,  BBREG_0x033, 0x000000A1,
	BBREG_0x03f, 0x00000C0C,  BBREG_0x033, 0x000000A2,  BBREG_0x03f,
	0x00000C0F,  BBREG_0x033, 0x000000A3,  BBREG_0x03f, 0x00000C2C,
	BBREG_0x033, 0x000000A4,  BBREG_0x03f, 0x00000C2F,  BBREG_0x033,
	0x000000A5,  BBREG_0x03f, 0x00000C8A,  BBREG_0x033, 0x000000A6,
	BBREG_0x03f, 0x00000C8D,  BBREG_0x033, 0x000000A7,  BBREG_0x03f,
	0x00000C90,  BBREG_0x033, 0x000000A8,  BBREG_0x03f, 0x00000CEF,
	BBREG_0x033, 0x000000A9,  BBREG_0x03f, 0x00000CF2,  BBREG_0x033,
	0x000000AA,  BBREG_0x03f, 0x00000CF5,  0x9300000a,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x000000A0,  BBREG_0x03f,
	0x00000C09,  BBREG_0x033, 0x000000A1,  BBREG_0x03f, 0x00000C0C,
	BBREG_0x033, 0x000000A2,  BBREG_0x03f, 0x00000C0F,  BBREG_0x033,
	0x000000A3,  BBREG_0x03f, 0x00000C2C,  BBREG_0x033, 0x000000A4,
	BBREG_0x03f, 0x00000C2F,  BBREG_0x033, 0x000000A5,  BBREG_0x03f,
	0x00000C8A,  BBREG_0x033, 0x000000A6,  BBREG_0x03f, 0x00000C8D,
	BBREG_0x033, 0x000000A7,  BBREG_0x03f, 0x00000C90,  BBREG_0x033,
	0x000000A8,  BBREG_0x03f, 0x00000CEF,  BBREG_0x033, 0x000000A9,
	BBREG_0x03f, 0x00000CF2,  BBREG_0x033, 0x000000AA,  BBREG_0x03f,
	0x00000CF5,  0x9300000b,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x000000A0,  BBREG_0x03f, 0x00000007,  BBREG_0x033,
	0x000000A1,  BBREG_0x03f, 0x0000000A,  BBREG_0x033, 0x000000A2,
	BBREG_0x03f, 0x0000000D,  BBREG_0x033, 0x000000A3,  BBREG_0x03f,
	0x0000002A,  BBREG_0x033, 0x000000A4,  BBREG_0x03f, 0x0000002D,
	BBREG_0x033, 0x000000A5,  BBREG_0x03f, 0x00000030,  BBREG_0x033,
	0x000000A6,  BBREG_0x03f, 0x0000006D,  BBREG_0x033, 0x000000A7,
	BBREG_0x03f, 0x00000070,  BBREG_0x033, 0x000000A8,  BBREG_0x03f,
	0x000000ED,  BBREG_0x033, 0x000000A9,  BBREG_0x03f, 0x000000F0,
	BBREG_0x033, 0x000000AA,  BBREG_0x03f, 0x000000F3,  0x9300000c,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x000000A0,
	BBREG_0x03f, 0x00000429,  BBREG_0x033, 0x000000A1,  BBREG_0x03f,
	0x00000828,  BBREG_0x033, 0x000000A2,  BBREG_0x03f, 0x00000847,
	BBREG_0x033, 0x000000A3,  BBREG_0x03f, 0x0000084A,  BBREG_0x033,
	0x000000A4,  BBREG_0x03f, 0x00000C4B,  BBREG_0x033, 0x000000A5,
	BBREG_0x03f, 0x00000CE5,  BBREG_0x033, 0x000000A6,  BBREG_0x03f,
	0x00000CE8,  BBREG_0x033, 0x000000A7,  BBREG_0x03f, 0x00000CEB,
	BBREG_0x033, 0x000000A8,  BBREG_0x03f, 0x00000CEE,  BBREG_0x033,
	0x000000A9,  BBREG_0x03f, 0x00000CF1,  BBREG_0x033, 0x000000AA,
	BBREG_0x03f, 0x00000CF4,  0x9300000d,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x000000A0,  BBREG_0x03f, 0x00000824,
	BBREG_0x033, 0x000000A1,  BBREG_0x03f, 0x00000827,  BBREG_0x033,
	0x000000A2,  BBREG_0x03f, 0x0000082A,  BBREG_0x033, 0x000000A3,
	BBREG_0x03f, 0x0000082D,  BBREG_0x033, 0x000000A4,  BBREG_0x03f,
	0x00000C68,  BBREG_0x033, 0x000000A5,  BBREG_0x03f, 0x00000C6B,
	BBREG_0x033, 0x000000A6,  BBREG_0x03f, 0x00000CCA,  BBREG_0x033,
	0x000000A7,  BBREG_0x03f, 0x00000CCD,  BBREG_0x033, 0x000000A8,
	BBREG_0x03f, 0x00000CEF,  BBREG_0x033, 0x000000A9,  BBREG_0x03f,
	0x00000CF2,  BBREG_0x033, 0x000000AA,  BBREG_0x03f, 0x00000CF5,
	0x9300000e,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x033,
	0x000000A0,  BBREG_0x03f, 0x00000C08,  BBREG_0x033, 0x000000A1,
	BBREG_0x03f, 0x00000C0B,  BBREG_0x033, 0x000000A2,  BBREG_0x03f,
	0x00000C0E,  BBREG_0x033, 0x000000A3,  BBREG_0x03f, 0x00000C2B,
	BBREG_0x033, 0x000000A4,  BBREG_0x03f, 0x00000C2E,  BBREG_0x033,
	0x000000A5,  BBREG_0x03f, 0x00000C31,  BBREG_0x033, 0x000000A6,
	BBREG_0x03f, 0x00000CCA,  BBREG_0x033, 0x000000A7,  BBREG_0x03f,
	0x00000CCD,  BBREG_0x033, 0x000000A8,  BBREG_0x03f, 0x00000CEF,
	BBREG_0x033, 0x000000A9,  BBREG_0x03f, 0x00000CF2,  BBREG_0x033,
	0x000000AA,  BBREG_0x03f, 0x00000CF5,  0x9300000f,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x000000A0,  BBREG_0x03f,
	0x00000429,  BBREG_0x033, 0x000000A1,  BBREG_0x03f, 0x00000828,
	BBREG_0x033, 0x000000A2,  BBREG_0x03f, 0x00000847,  BBREG_0x033,
	0x000000A3,  BBREG_0x03f, 0x0000084A,  BBREG_0x033, 0x000000A4,
	BBREG_0x03f, 0x0000086A,  BBREG_0x033, 0x000000A5,  BBREG_0x03f,
	0x0000086D,  BBREG_0x033, 0x000000A6,  BBREG_0x03f, 0x00000870,
	BBREG_0x033, 0x000000A7,  BBREG_0x03f, 0x00000891,  BBREG_0x033,
	0x000000A8,  BBREG_0x03f, 0x00000894,  BBREG_0x033, 0x000000A9,
	BBREG_0x03f, 0x000008B5,  BBREG_0x033, 0x000000AA,  BBREG_0x03f,
	0x000008F5,  0x93000010,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x000000A0,  BBREG_0x03f, 0x00000429,  BBREG_0x033,
	0x000000A1,  BBREG_0x03f, 0x00000828,  BBREG_0x033, 0x000000A2,
	BBREG_0x03f, 0x00000847,  BBREG_0x033, 0x000000A3,  BBREG_0x03f,
	0x0000084A,  BBREG_0x033, 0x000000A4,  BBREG_0x03f, 0x00000C4B,
	BBREG_0x033, 0x000000A5,  BBREG_0x03f, 0x00000C8A,  BBREG_0x033,
	0x000000A6,  BBREG_0x03f, 0x00000CEA,  BBREG_0x033, 0x000000A7,
	BBREG_0x03f, 0x00000CED,  BBREG_0x033, 0x000000A8,  BBREG_0x03f,
	0x00000CF0,  BBREG_0x033, 0x000000A9,  BBREG_0x03f, 0x00000CF3,
	BBREG_0x033, 0x000000AA,  BBREG_0x03f, 0x00000CF6,  0x90000001,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x000000A0,
	BBREG_0x03f, 0x00000007,  BBREG_0x033, 0x000000A1,  BBREG_0x03f,
	0x0000000A,  BBREG_0x033, 0x000000A2,  BBREG_0x03f, 0x0000000D,
	BBREG_0x033, 0x000000A3,  BBREG_0x03f, 0x0000002A,  BBREG_0x033,
	0x000000A4,  BBREG_0x03f, 0x0000002D,  BBREG_0x033, 0x000000A5,
	BBREG_0x03f, 0x00000030,  BBREG_0x033, 0x000000A6,  BBREG_0x03f,
	0x0000006D,  BBREG_0x033, 0x000000A7,  BBREG_0x03f, 0x00000070,
	BBREG_0x033, 0x000000A8,  BBREG_0x03f, 0x000000ED,  BBREG_0x033,
	0x000000A9,  BBREG_0x03f, 0x000000F0,  BBREG_0x033, 0x000000AA,
	BBREG_0x03f, 0x000000F3,  0x90000002,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x000000A0,  BBREG_0x03f, 0x00000005,
	BBREG_0x033, 0x000000A1,  BBREG_0x03f, 0x00000008,  BBREG_0x033,
	0x000000A2,  BBREG_0x03f, 0x0000000B,  BBREG_0x033, 0x000000A3,
	BBREG_0x03f, 0x0000000E,  BBREG_0x033, 0x000000A4,  BBREG_0x03f,
	0x00000047,  BBREG_0x033, 0x000000A5,  BBREG_0x03f, 0x0000004A,
	BBREG_0x033, 0x000000A6,  BBREG_0x03f, 0x0000004D,  BBREG_0x033,
	0x000000A7,  BBREG_0x03f, 0x00000050,  BBREG_0x033, 0x000000A8,
	BBREG_0x03f, 0x00000053,  BBREG_0x033, 0x000000A9,  BBREG_0x03f,
	0x00000056,  BBREG_0x033, 0x000000AA,  BBREG_0x03f, 0x00000094,
	0x90000003,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x033,
	0x000000A0,  BBREG_0x03f, 0x0000042A,  BBREG_0x033, 0x000000A1,
	BBREG_0x03f, 0x00000829,  BBREG_0x033, 0x000000A2,  BBREG_0x03f,
	0x00000848,  BBREG_0x033, 0x000000A3,  BBREG_0x03f, 0x0000084B,
	BBREG_0x033, 0x000000A4,  BBREG_0x03f, 0x00000C4C,  BBREG_0x033,
	0x000000A5,  BBREG_0x03f, 0x00000C8A,  BBREG_0x033, 0x000000A6,
	BBREG_0x03f, 0x00000C8D,  BBREG_0x033, 0x000000A7,  BBREG_0x03f,
	0x00000CEB,  BBREG_0x033, 0x000000A8,  BBREG_0x03f, 0x00000CEE,
	BBREG_0x033, 0x000000A9,  BBREG_0x03f, 0x00000CF1,  BBREG_0x033,
	0x000000AA,  BBREG_0x03f, 0x00000CF4,  0x90000004,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x000000A0,  BBREG_0x03f,
	0x00000005,  BBREG_0x033, 0x000000A1,  BBREG_0x03f, 0x00000008,
	BBREG_0x033, 0x000000A2,  BBREG_0x03f, 0x0000000B,  BBREG_0x033,
	0x000000A3,  BBREG_0x03f, 0x0000000E,  BBREG_0x033, 0x000000A4,
	BBREG_0x03f, 0x00000047,  BBREG_0x033, 0x000000A5,  BBREG_0x03f,
	0x0000004A,  BBREG_0x033, 0x000000A6,  BBREG_0x03f, 0x0000004D,
	BBREG_0x033, 0x000000A7,  BBREG_0x03f, 0x00000050,  BBREG_0x033,
	0x000000A8,  BBREG_0x03f, 0x00000053,  BBREG_0x033, 0x000000A9,
	BBREG_0x03f, 0x00000056,  BBREG_0x033, 0x000000AA,  BBREG_0x03f,
	0x00000094,  0x90000005,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x000000A0,  BBREG_0x03f, 0x0000042A,  BBREG_0x033,
	0x000000A1,  BBREG_0x03f, 0x00000829,  BBREG_0x033, 0x000000A2,
	BBREG_0x03f, 0x00000848,  BBREG_0x033, 0x000000A3,  BBREG_0x03f,
	0x0000084B,  BBREG_0x033, 0x000000A4,  BBREG_0x03f, 0x00000C4C,
	BBREG_0x033, 0x000000A5,  BBREG_0x03f, 0x00000C8A,  BBREG_0x033,
	0x000000A6,  BBREG_0x03f, 0x00000C8D,  BBREG_0x033, 0x000000A7,
	BBREG_0x03f, 0x00000CEB,  BBREG_0x033, 0x000000A8,  BBREG_0x03f,
	0x00000CEE,  BBREG_0x033, 0x000000A9,  BBREG_0x03f, 0x00000CF1,
	BBREG_0x033, 0x000000AA,  BBREG_0x03f, 0x00000CF4,  0x90000006,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x000000A0,
	BBREG_0x03f, 0x00000007,  BBREG_0x033, 0x000000A1,  BBREG_0x03f,
	0x0000000A,  BBREG_0x033, 0x000000A2,  BBREG_0x03f, 0x0000000D,
	BBREG_0x033, 0x000000A3,  BBREG_0x03f, 0x0000002A,  BBREG_0x033,
	0x000000A4,  BBREG_0x03f, 0x0000002D,  BBREG_0x033, 0x000000A5,
	BBREG_0x03f, 0x00000030,  BBREG_0x033, 0x000000A6,  BBREG_0x03f,
	0x0000006D,  BBREG_0x033, 0x000000A7,  BBREG_0x03f, 0x00000070,
	BBREG_0x033, 0x000000A8,  BBREG_0x03f, 0x000000ED,  BBREG_0x033,
	0x000000A9,  BBREG_0x03f, 0x000000F0,  BBREG_0x033, 0x000000AA,
	BBREG_0x03f, 0x000000F3,  0x90000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x000000A0,  BBREG_0x03f, 0x00000007,
	BBREG_0x033, 0x000000A1,  BBREG_0x03f, 0x0000000A,  BBREG_0x033,
	0x000000A2,  BBREG_0x03f, 0x0000000D,  BBREG_0x033, 0x000000A3,
	BBREG_0x03f, 0x0000002A,  BBREG_0x033, 0x000000A4,  BBREG_0x03f,
	0x0000002D,  BBREG_0x033, 0x000000A5,  BBREG_0x03f, 0x00000030,
	BBREG_0x033, 0x000000A6,  BBREG_0x03f, 0x0000006D,  BBREG_0x033,
	0x000000A7,  BBREG_0x03f, 0x00000070,  BBREG_0x033, 0x000000A8,
	BBREG_0x03f, 0x000000ED,  BBREG_0x033, 0x000000A9,  BBREG_0x03f,
	0x000000F0,  BBREG_0x033, 0x000000AA,  BBREG_0x03f, 0x000000F3,
	0xA0000000,  0x00000000,  BBREG_0x033, 0x000000A0,  BBREG_0x03f,
	0x00000C09,  BBREG_0x033, 0x000000A1,  BBREG_0x03f, 0x00000C0C,
	BBREG_0x033, 0x000000A2,  BBREG_0x03f, 0x00000C0F,  BBREG_0x033,
	0x000000A3,  BBREG_0x03f, 0x00000C2C,  BBREG_0x033, 0x000000A4,
	BBREG_0x03f, 0x00000C2F,  BBREG_0x033, 0x000000A5,  BBREG_0x03f,
	0x00000C8A,  BBREG_0x033, 0x000000A6,  BBREG_0x03f, 0x00000C8D,
	BBREG_0x033, 0x000000A7,  BBREG_0x03f, 0x00000C90,  BBREG_0x033,
	0x000000A8,  BBREG_0x03f, 0x00000CEF,  BBREG_0x033, 0x000000A9,
	BBREG_0x03f, 0x00000CF2,  BBREG_0x033, 0x000000AA,  BBREG_0x03f,
	0x00000CF5,  0xB0000000,  0x00000000,  BBREG_0x0ef, 0x00000000,
	BBREG_0x0ef, 0x00000400,  0x83000001,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x0000047C,
	BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x0000047C,  BBREG_0x033,
	0x00000002,  BBREG_0x03f, 0x0000047C,  BBREG_0x033, 0x00000003,
	BBREG_0x03f, 0x0000047C,  0x93000004,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x0000047C,
	BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x0000047C,  BBREG_0x033,
	0x00000002,  BBREG_0x03f, 0x0000047C,  BBREG_0x033, 0x00000003,
	BBREG_0x03f, 0x0000047C,  0x93000006,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x0000047C,
	BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x0000047C,  BBREG_0x033,
	0x00000002,  BBREG_0x03f, 0x0000047C,  BBREG_0x033, 0x00000003,
	BBREG_0x03f, 0x0000047C,  0x93000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x0000047C,
	BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x0000047C,  BBREG_0x033,
	0x00000002,  BBREG_0x03f, 0x0000047C,  BBREG_0x033, 0x00000003,
	BBREG_0x03f, 0x0000047C,  0x9300000b,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x0000047C,
	BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x0000047C,  BBREG_0x033,
	0x00000002,  BBREG_0x03f, 0x0000047C,  BBREG_0x033, 0x00000003,
	BBREG_0x03f, 0x0000047C,  0x9300000c,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x000008BB,
	BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x000008BB,  BBREG_0x033,
	0x00000002,  BBREG_0x03f, 0x000008BB,  BBREG_0x033, 0x00000003,
	BBREG_0x03f, 0x000008BB,  0x90000001,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x0000047C,
	BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x0000047C,  BBREG_0x033,
	0x00000002,  BBREG_0x03f, 0x0000047C,  BBREG_0x033, 0x00000003,
	BBREG_0x03f, 0x0000047C,  0x90000004,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x0000047C,
	BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x0000047C,  BBREG_0x033,
	0x00000002,  BBREG_0x03f, 0x0000047C,  BBREG_0x033, 0x00000003,
	BBREG_0x03f, 0x0000047C,  0x90000006,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x0000047C,
	BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x0000047C,  BBREG_0x033,
	0x00000002,  BBREG_0x03f, 0x0000047C,  BBREG_0x033, 0x00000003,
	BBREG_0x03f, 0x0000047C,  0x90000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x0000047C,
	BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x0000047C,  BBREG_0x033,
	0x00000002,  BBREG_0x03f, 0x0000047C,  BBREG_0x033, 0x00000003,
	BBREG_0x03f, 0x0000047C,  0xA0000000,  0x00000000,  BBREG_0x033,
	0x00000000,  BBREG_0x03f, 0x000004BB,  BBREG_0x033, 0x00000001,
	BBREG_0x03f, 0x000004BB,  BBREG_0x033, 0x00000002,  BBREG_0x03f,
	0x000004BB,  BBREG_0x033, 0x00000003,  BBREG_0x03f, 0x000004BB,
	0xB0000000,  0x00000000,  BBREG_0x0ef, 0x00000000,  BBREG_0x0ef,
	0x00000100,  0x83000001,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00001726,  BBREG_0x033,
	0x00000001,  BBREG_0x03f, 0x00001726,  BBREG_0x033, 0x00000002,
	BBREG_0x03f, 0x00001726,  BBREG_0x033, 0x00000003,  BBREG_0x03f,
	0x00001726,  0x93000004,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00001726,  BBREG_0x033,
	0x00000001,  BBREG_0x03f, 0x00001726,  BBREG_0x033, 0x00000002,
	BBREG_0x03f, 0x00001726,  BBREG_0x033, 0x00000003,  BBREG_0x03f,
	0x00001726,  0x93000006,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00001726,  BBREG_0x033,
	0x00000001,  BBREG_0x03f, 0x00001726,  BBREG_0x033, 0x00000002,
	BBREG_0x03f, 0x00001726,  BBREG_0x033, 0x00000003,  BBREG_0x03f,
	0x00001726,  0x93000007,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00001726,  BBREG_0x033,
	0x00000001,  BBREG_0x03f, 0x00001726,  BBREG_0x033, 0x00000002,
	BBREG_0x03f, 0x00001726,  BBREG_0x033, 0x00000003,  BBREG_0x03f,
	0x00001726,  0x9300000b,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00001726,  BBREG_0x033,
	0x00000001,  BBREG_0x03f, 0x00001726,  BBREG_0x033, 0x00000002,
	BBREG_0x03f, 0x00001726,  BBREG_0x033, 0x00000003,  BBREG_0x03f,
	0x00001726,  0x90000001,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00001726,  BBREG_0x033,
	0x00000001,  BBREG_0x03f, 0x00001726,  BBREG_0x033, 0x00000002,
	BBREG_0x03f, 0x00001726,  BBREG_0x033, 0x00000003,  BBREG_0x03f,
	0x00001726,  0x90000004,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00001726,  BBREG_0x033,
	0x00000001,  BBREG_0x03f, 0x00001726,  BBREG_0x033, 0x00000002,
	BBREG_0x03f, 0x00001726,  BBREG_0x033, 0x00000003,  BBREG_0x03f,
	0x00001726,  0x90000006,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00001726,  BBREG_0x033,
	0x00000001,  BBREG_0x03f, 0x00001726,  BBREG_0x033, 0x00000002,
	BBREG_0x03f, 0x00001726,  BBREG_0x033, 0x00000003,  BBREG_0x03f,
	0x00001726,  0x90000007,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00001726,  BBREG_0x033,
	0x00000001,  BBREG_0x03f, 0x00001726,  BBREG_0x033, 0x00000002,
	BBREG_0x03f, 0x00001726,  BBREG_0x033, 0x00000003,  BBREG_0x03f,
	0x00001726,  0xA0000000,  0x00000000,  BBREG_0x033, 0x00000000,
	BBREG_0x03f, 0x00000F34,  BBREG_0x033, 0x00000001,  BBREG_0x03f,
	0x00000F34,  BBREG_0x033, 0x00000002,  BBREG_0x03f, 0x00000F34,
	BBREG_0x033, 0x00000003,  BBREG_0x03f, 0x00000F34,  0xB0000000,
	0x00000000,  BBREG_0x0ef, 0x00000000,  0x83000001,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x081, 0x0000F400,  BBREG_0x087,
	0x00016040,  BBREG_0x051, 0x00000808,  BBREG_0x052, 0x00098002,
	BBREG_0x053, 0x0000FA47,  BBREG_0x054, 0x00058032,  BBREG_0x056,
	0x00051000,  BBREG_0x057, 0x0000CE0A,  BBREG_0x058, 0x00082030,
	0x93000004,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x081,
	0x0000F400,  BBREG_0x087, 0x00016040,  BBREG_0x051, 0x00000808,
	BBREG_0x052, 0x00098002,  BBREG_0x053, 0x0000FA47,  BBREG_0x054,
	0x00058032,  BBREG_0x056, 0x00051000,  BBREG_0x057, 0x0000CE0A,
	BBREG_0x058, 0x00082030,  0x93000006,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x081, 0x0000F400,  BBREG_0x087, 0x00016040,
	BBREG_0x051, 0x00000808,  BBREG_0x052, 0x00098002,  BBREG_0x053,
	0x0000FA47,  BBREG_0x054, 0x00058032,  BBREG_0x056, 0x00051000,
	BBREG_0x057, 0x0000CE0A,  BBREG_0x058, 0x00082030,  0x93000007,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x081, 0x0000F400,
	BBREG_0x087, 0x00016040,  BBREG_0x051, 0x00000808,  BBREG_0x052,
	0x00098002,  BBREG_0x053, 0x0000FA47,  BBREG_0x054, 0x00058032,
	BBREG_0x056, 0x00051000,  BBREG_0x057, 0x0000CE0A,  BBREG_0x058,
	0x00082030,  0x9300000b,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x081, 0x0000F400,  BBREG_0x087, 0x00016040,  BBREG_0x051,
	0x00000808,  BBREG_0x052, 0x00098002,  BBREG_0x053, 0x0000FA47,
	BBREG_0x054, 0x00058032,  BBREG_0x056, 0x00051000,  BBREG_0x057,
	0x0000CE0A,  BBREG_0x058, 0x00082030,  0x90000001,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x081, 0x0000F400,  BBREG_0x087,
	0x00016040,  BBREG_0x051, 0x00000808,  BBREG_0x052, 0x00098002,
	BBREG_0x053, 0x0000FA47,  BBREG_0x054, 0x00058032,  BBREG_0x056,
	0x00051000,  BBREG_0x057, 0x0000CE0A,  BBREG_0x058, 0x00082030,
	0x90000004,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x081,
	0x0000F400,  BBREG_0x087, 0x00016040,  BBREG_0x051, 0x00000808,
	BBREG_0x052, 0x00098002,  BBREG_0x053, 0x0000FA47,  BBREG_0x054,
	0x00058032,  BBREG_0x056, 0x00051000,  BBREG_0x057, 0x0000CE0A,
	BBREG_0x058, 0x00082030,  0x90000006,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x081, 0x0000F400,  BBREG_0x087, 0x00016040,
	BBREG_0x051, 0x00000808,  BBREG_0x052, 0x00098002,  BBREG_0x053,
	0x0000FA47,  BBREG_0x054, 0x00058032,  BBREG_0x056, 0x00051000,
	BBREG_0x057, 0x0000CE0A,  BBREG_0x058, 0x00082030,  0x90000007,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x081, 0x0000F400,
	BBREG_0x087, 0x00016040,  BBREG_0x051, 0x00000808,  BBREG_0x052,
	0x00098002,  BBREG_0x053, 0x0000FA47,  BBREG_0x054, 0x00058032,
	BBREG_0x056, 0x00051000,  BBREG_0x057, 0x0000CE0A,  BBREG_0x058,
	0x00082030,  0xA0000000,  0x00000000,  BBREG_0x081, 0x0000F000,
	BBREG_0x087, 0x00016040,  BBREG_0x051, 0x00000C00,  BBREG_0x052,
	0x0007C241,  BBREG_0x053, 0x0001C069,  BBREG_0x054, 0x00078032,
	BBREG_0x057, 0x0000CE0A,  BBREG_0x058, 0x00058750,  0xB0000000,
	0x00000000,  BBREG_0x0ef, 0x00000800,  0x83000001,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f,
	0x00000003,  BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x00000006,
	BBREG_0x033, 0x00000002,  BBREG_0x03f, 0x00000009,  BBREG_0x033,
	0x00000003,  BBREG_0x03f, 0x00000026,  BBREG_0x033, 0x00000004,
	BBREG_0x03f, 0x00000029,  BBREG_0x033, 0x00000005,  BBREG_0x03f,
	0x0000002C,  BBREG_0x033, 0x00000006,  BBREG_0x03f, 0x0000002F,
	BBREG_0x033, 0x00000007,  BBREG_0x03f, 0x00000033,  BBREG_0x033,
	0x00000008,  BBREG_0x03f, 0x00000036,  BBREG_0x033, 0x00000009,
	BBREG_0x03f, 0x00000039,  BBREG_0x033, 0x0000000A,  BBREG_0x03f,
	0x0000003C,  0x93000004,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00000002,  BBREG_0x033,
	0x00000001,  BBREG_0x03f, 0x00000005,  BBREG_0x033, 0x00000002,
	BBREG_0x03f, 0x00000008,  BBREG_0x033, 0x00000003,  BBREG_0x03f,
	0x0000000B,  BBREG_0x033, 0x00000004,  BBREG_0x03f, 0x0000000E,
	BBREG_0x033, 0x00000005,  BBREG_0x03f, 0x0000002B,  BBREG_0x033,
	0x00000006,  BBREG_0x03f, 0x0000002E,  BBREG_0x033, 0x00000007,
	BBREG_0x03f, 0x00000031,  BBREG_0x033, 0x00000008,  BBREG_0x03f,
	0x0000006E,  BBREG_0x033, 0x00000009,  BBREG_0x03f, 0x00000071,
	BBREG_0x033, 0x0000000A,  BBREG_0x03f, 0x00000074,  0x93000006,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x00000000,
	BBREG_0x03f, 0x00000003,  BBREG_0x033, 0x00000001,  BBREG_0x03f,
	0x00000006,  BBREG_0x033, 0x00000002,  BBREG_0x03f, 0x00000009,
	BBREG_0x033, 0x00000003,  BBREG_0x03f, 0x00000026,  BBREG_0x033,
	0x00000004,  BBREG_0x03f, 0x00000029,  BBREG_0x033, 0x00000005,
	BBREG_0x03f, 0x0000002C,  BBREG_0x033, 0x00000006,  BBREG_0x03f,
	0x0000002F,  BBREG_0x033, 0x00000007,  BBREG_0x03f, 0x00000033,
	BBREG_0x033, 0x00000008,  BBREG_0x03f, 0x00000036,  BBREG_0x033,
	0x00000009,  BBREG_0x03f, 0x00000039,  BBREG_0x033, 0x0000000A,
	BBREG_0x03f, 0x0000003C,  0x93000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00000003,
	BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x00000006,  BBREG_0x033,
	0x00000002,  BBREG_0x03f, 0x00000009,  BBREG_0x033, 0x00000003,
	BBREG_0x03f, 0x00000026,  BBREG_0x033, 0x00000004,  BBREG_0x03f,
	0x00000029,  BBREG_0x033, 0x00000005,  BBREG_0x03f, 0x0000002C,
	BBREG_0x033, 0x00000006,  BBREG_0x03f, 0x0000002F,  BBREG_0x033,
	0x00000007,  BBREG_0x03f, 0x00000033,  BBREG_0x033, 0x00000008,
	BBREG_0x03f, 0x00000036,  BBREG_0x033, 0x00000009,  BBREG_0x03f,
	0x00000039,  BBREG_0x033, 0x0000000A,  BBREG_0x03f, 0x0000003C,
	0x9300000b,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x033,
	0x00000000,  BBREG_0x03f, 0x00000003,  BBREG_0x033, 0x00000001,
	BBREG_0x03f, 0x00000006,  BBREG_0x033, 0x00000002,  BBREG_0x03f,
	0x00000009,  BBREG_0x033, 0x00000003,  BBREG_0x03f, 0x00000026,
	BBREG_0x033, 0x00000004,  BBREG_0x03f, 0x00000029,  BBREG_0x033,
	0x00000005,  BBREG_0x03f, 0x0000002C,  BBREG_0x033, 0x00000006,
	BBREG_0x03f, 0x0000002F,  BBREG_0x033, 0x00000007,  BBREG_0x03f,
	0x00000033,  BBREG_0x033, 0x00000008,  BBREG_0x03f, 0x00000036,
	BBREG_0x033, 0x00000009,  BBREG_0x03f, 0x00000039,  BBREG_0x033,
	0x0000000A,  BBREG_0x03f, 0x0000003C,  0x90000001,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f,
	0x00000003,  BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x00000006,
	BBREG_0x033, 0x00000002,  BBREG_0x03f, 0x00000009,  BBREG_0x033,
	0x00000003,  BBREG_0x03f, 0x00000026,  BBREG_0x033, 0x00000004,
	BBREG_0x03f, 0x00000029,  BBREG_0x033, 0x00000005,  BBREG_0x03f,
	0x0000002C,  BBREG_0x033, 0x00000006,  BBREG_0x03f, 0x0000002F,
	BBREG_0x033, 0x00000007,  BBREG_0x03f, 0x00000033,  BBREG_0x033,
	0x00000008,  BBREG_0x03f, 0x00000036,  BBREG_0x033, 0x00000009,
	BBREG_0x03f, 0x00000039,  BBREG_0x033, 0x0000000A,  BBREG_0x03f,
	0x0000003C,  0x90000004,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00000003,  BBREG_0x033,
	0x00000001,  BBREG_0x03f, 0x00000006,  BBREG_0x033, 0x00000002,
	BBREG_0x03f, 0x00000009,  BBREG_0x033, 0x00000003,  BBREG_0x03f,
	0x00000026,  BBREG_0x033, 0x00000004,  BBREG_0x03f, 0x00000029,
	BBREG_0x033, 0x00000005,  BBREG_0x03f, 0x0000002C,  BBREG_0x033,
	0x00000006,  BBREG_0x03f, 0x0000002F,  BBREG_0x033, 0x00000007,
	BBREG_0x03f, 0x00000033,  BBREG_0x033, 0x00000008,  BBREG_0x03f,
	0x00000036,  BBREG_0x033, 0x00000009,  BBREG_0x03f, 0x00000039,
	BBREG_0x033, 0x0000000A,  BBREG_0x03f, 0x0000003C,  0x90000006,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x00000000,
	BBREG_0x03f, 0x00000003,  BBREG_0x033, 0x00000001,  BBREG_0x03f,
	0x00000006,  BBREG_0x033, 0x00000002,  BBREG_0x03f, 0x00000009,
	BBREG_0x033, 0x00000003,  BBREG_0x03f, 0x00000026,  BBREG_0x033,
	0x00000004,  BBREG_0x03f, 0x00000029,  BBREG_0x033, 0x00000005,
	BBREG_0x03f, 0x0000002C,  BBREG_0x033, 0x00000006,  BBREG_0x03f,
	0x0000002F,  BBREG_0x033, 0x00000007,  BBREG_0x03f, 0x00000033,
	BBREG_0x033, 0x00000008,  BBREG_0x03f, 0x00000036,  BBREG_0x033,
	0x00000009,  BBREG_0x03f, 0x00000039,  BBREG_0x033, 0x0000000A,
	BBREG_0x03f, 0x0000003C,  0x90000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00000003,
	BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x00000006,  BBREG_0x033,
	0x00000002,  BBREG_0x03f, 0x00000009,  BBREG_0x033, 0x00000003,
	BBREG_0x03f, 0x00000026,  BBREG_0x033, 0x00000004,  BBREG_0x03f,
	0x00000029,  BBREG_0x033, 0x00000005,  BBREG_0x03f, 0x0000002C,
	BBREG_0x033, 0x00000006,  BBREG_0x03f, 0x0000002F,  BBREG_0x033,
	0x00000007,  BBREG_0x03f, 0x00000033,  BBREG_0x033, 0x00000008,
	BBREG_0x03f, 0x00000036,  BBREG_0x033, 0x00000009,  BBREG_0x03f,
	0x00000039,  BBREG_0x033, 0x0000000A,  BBREG_0x03f, 0x0000003C,
	0xA0000000,  0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f,
	0x0005142C,  BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x0005144B,
	BBREG_0x033, 0x00000002,  BBREG_0x03f, 0x0005144E,  BBREG_0x033,
	0x00000003,  BBREG_0x03f, 0x00051C69,  BBREG_0x033, 0x00000004,
	BBREG_0x03f, 0x00051C6C,  BBREG_0x033, 0x00000005,  BBREG_0x03f,
	0x00051C6F,  BBREG_0x033, 0x00000006,  BBREG_0x03f, 0x00051CEB,
	BBREG_0x033, 0x00000007,  BBREG_0x03f, 0x00051CEE,  BBREG_0x033,
	0x00000008,  BBREG_0x03f, 0x00051CF1,  BBREG_0x033, 0x00000009,
	BBREG_0x03f, 0x00051CF4,  BBREG_0x033, 0x0000000A,  BBREG_0x03f,
	0x00051CF7,  0xB0000000,  0x00000000,  BBREG_0x0ef, 0x00000000,
	BBREG_0x0ef, 0x00000010,  BBREG_0x033, 0x00000000,  BBREG_0x008,
	0x0009C060,  BBREG_0x033, 0x00000001,  BBREG_0x008, 0x0009C060,
	BBREG_0x0ef, 0x00000000,  BBREG_0x033, 0x000000A2,  BBREG_0x0ef,
	0x00080000,  BBREG_0x03e, 0x0000593F,  0x8300000c,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03f, 0x000D0F4F,  0xA0000000,
	0x00000000,  BBREG_0x03f, 0x000C0F4F,  0xB0000000,  0x00000000,
	BBREG_0x0ef, 0x00000000,  BBREG_0x033, 0x000000A3,  BBREG_0x0ef,
	0x00080000,  BBREG_0x03e, 0x00005934,  BBREG_0x03f, 0x0005AFCF,
	BBREG_0x0ef, 0x00000000,  0x83000002,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ce, 0x00094400,  0x93000003,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x0ce, 0x00094400,  0x93000004,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x0ce, 0x00094400,
	0x93000005,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x0ce,
	0x00094400,  0x93000010,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x0ce, 0x00094400,  0xA0000000,  0x00000000,  BBREG_0x0ce,
	0x00094C00,  0xB0000000,  0x00000000,  0x83000002,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x0cf, 0x00072F00,  0x93000003,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x0cf, 0x00072F00,
	0x93000004,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x0cf,
	0x00072F00,  0x93000005,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x0cf, 0x00072F00,  0x9300000c,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0cf, 0x00064700,  0x93000010,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x0cf, 0x00072F00,  0xA0000000,
	0x00000000,  BBREG_0x0cf, 0x00064700,  0xB0000000,  0x00000000,
	0x83000002,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x0ef,
	0x00000004,  BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00000056,
	BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x000000D6,  BBREG_0x0ef,
	0x00000000,  0x93000003,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x0ef, 0x00000004,  BBREG_0x033, 0x00000000,  BBREG_0x03f,
	0x00000056,  BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x000000D6,
	BBREG_0x0ef, 0x00000000,  0x93000004,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x0ef, 0x00000004,  BBREG_0x033, 0x00000000,
	BBREG_0x03f, 0x00000056,  BBREG_0x033, 0x00000001,  BBREG_0x03f,
	0x000000D6,  BBREG_0x0ef, 0x00000000,  0x93000005,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x0ef, 0x00000004,  BBREG_0x033,
	0x00000000,  BBREG_0x03f, 0x00000056,  BBREG_0x033, 0x00000001,
	BBREG_0x03f, 0x000000D6,  BBREG_0x0ef, 0x00000000,  0x9300000c,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x0ef, 0x00000004,
	BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00000096,  BBREG_0x033,
	0x00000001,  BBREG_0x03f, 0x000000D6,  BBREG_0x0ef, 0x00000000,
	0x93000010,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x0ef,
	0x00000004,  BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00000056,
	BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x00000056,  BBREG_0x0ef,
	0x00000000,  0xA0000000,  0x00000000,  BBREG_0x0ef, 0x00000000,
	BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00000096,  BBREG_0x033,
	0x00000001,  BBREG_0x03f, 0x000000D6,  BBREG_0x0ef, 0x00000000,
	0xB0000000,  0x00000000,  BBREG_0x0b0, 0x000FF0FC,  BBREG_0x0c4,
	0x00081402,  BBREG_0x0cc, 0x00082000,

};

void odm_read_and_config_mp_8822b_radioa(struct PHY_DM_STRUCT *p_dm_odm)
{
	u32 i = 0;
	u8 c_cond;
	boolean is_matched = true, is_skipped = false;
	u32 array_len = sizeof(array_mp_8822b_radioa) / sizeof(u32);
	u32 *array = array_mp_8822b_radioa;

	u32 v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> odm_read_and_config_mp_8822b_radioa\n"));

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 &
		    (BIT(31) | BIT(30))) { /*positive & negative condition*/
			if (v1 & BIT(31)) { /* positive condition*/
				c_cond = (u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) { /*end*/
					is_matched = true;
					is_skipped = false;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT,
						     ODM_DBG_LOUD, ("ENDIF\n"));
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT,
						     ODM_DBG_LOUD, ("ELSE\n"));
				} else { /*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT,
						     ODM_DBG_LOUD,
						     ("IF or ELSE IF\n"));
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (is_skipped == false) {
					if (check_positive(p_dm_odm, pre_v1,
							   pre_v2, v1, v2)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else
					is_matched = false;
			}
		} else {
			if (is_matched)
				odm_config_rf_radio_a_8822b(p_dm_odm, v1, v2);
		}
		i = i + 2;
	}
}

u32 odm_get_version_mp_8822b_radioa(void) { return 100; }

/******************************************************************************
*                           radiob.TXT
******************************************************************************/

u32 array_mp_8822b_radiob[] = {
	BBREG_0x000, 0x00030000,  0x83000001,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x001, 0x0004002D,  0x93000002,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x001, 0x00040029,  0x93000003,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x001, 0x00040029,
	0x93000004,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x001,
	0x0004002D,  0x93000005,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x001, 0x00040029,  0x93000006,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x001, 0x0004002D,  0x93000007,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x001, 0x0004002D,  0x93000008,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x001, 0x00040029,
	0x93000009,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x001,
	0x00040029,  0x9300000a,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x001, 0x00040029,  0x9300000b,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x001, 0x0004002D,  0x9300000c,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x001, 0x00040029,  0x9300000f,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x001, 0x00040029,
	0x93000010,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x001,
	0x00040029,  0x90000001,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x001, 0x0004002D,  0x90000002,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x001, 0x00040029,  0x90000003,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x001, 0x00040029,  0x90000004,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x001, 0x0004002D,
	0x90000005,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x001,
	0x00040029,  0x90000006,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x001, 0x0004002D,  0x90000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x001, 0x0004002D,  0xA0000000,  0x00000000,
	BBREG_0x001, 0x00040029,  0xB0000000,  0x00000000,  BBREG_0x018,
	0x00010D24,  BBREG_0x0ef, 0x00080000,  BBREG_0x033, 0x00000002,
	BBREG_0x03e, 0x0000003F,  0x8300000c,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03f, 0x000D0F4E,  0xA0000000,  0x00000000,
	BBREG_0x03f, 0x000C0F4E,  0xB0000000,  0x00000000,  BBREG_0x033,
	0x00000001,  BBREG_0x03e, 0x00000034,  BBREG_0x03f, 0x0004080E,
	BBREG_0x0ef, 0x00080000,  BBREG_0x0df, 0x00002449,  BBREG_0x033,
	0x00000024,  BBREG_0x03e, 0x0000003F,  BBREG_0x03f, 0x00060FDE,
	BBREG_0x0ef, 0x00000000,  BBREG_0x0ef, 0x00080000,  BBREG_0x033,
	0x00000025,  BBREG_0x03e, 0x00000037,  BBREG_0x03f, 0x0007EFCE,
	BBREG_0x0ef, 0x00000000,  BBREG_0x0ef, 0x00080000,  BBREG_0x033,
	0x00000026,  BBREG_0x03e, 0x00000037,  BBREG_0x03f, 0x000DEFCE,
	BBREG_0x0ef, 0x00000000,  BBREG_0x0df, 0x00000009,  BBREG_0x018,
	0x00010524,  BBREG_0x089, 0x00000207,  0x83000001,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x08a, 0x000FF186,  0x93000004,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x08a, 0x000FF186,
	0x93000006,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x08a,
	0x000FE186,  0x93000007,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x08a, 0x000FF186,  0x9300000b,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x08a, 0x000FF186,  0x90000006,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x08a, 0x000FE186,  0x90000007,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x08a, 0x000FF186,
	0xA0000000,  0x00000000,  BBREG_0x08a, 0x000FF186,  0xB0000000,
	0x00000000,  BBREG_0x08b, 0x00061E3C,  BBREG_0x08c, 0x000112C7,
	BBREG_0x08d, 0x000F4988,  BBREG_0x08e, 0x00064D40,  BBREG_0x0ef,
	0x00020000,  BBREG_0x033, 0x00000007,  0x83000000,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00004000,  BBREG_0x03f,
	0x000C3186,  0x93000001,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00004040,  BBREG_0x03f, 0x000C3186,  0x93000002,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004040,
	BBREG_0x03f, 0x000C3186,  0x93000003,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00004000,  BBREG_0x03f, 0x000C0006,
	0x93000004,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x00004040,  BBREG_0x03f, 0x000C3186,  0x93000005,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00004000,  BBREG_0x03f,
	0x000C0006,  0x93000006,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00004080,  BBREG_0x03f, 0x000C3186,  0x93000007,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004040,
	BBREG_0x03f, 0x000C3186,  0x93000008,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00004000,  BBREG_0x03f, 0x000C0006,
	0x93000009,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x00004040,  BBREG_0x03f, 0x000C3186,  0x9300000a,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00004000,  BBREG_0x03f,
	0x000C3186,  0x9300000b,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00004040,  BBREG_0x03f, 0x000C3186,  0x9300000c,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004000,
	BBREG_0x03f, 0x000C0006,  0x9300000d,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00004000,  BBREG_0x03f, 0x000C3186,
	0x9300000e,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x00004000,  BBREG_0x03f, 0x000C3186,  0x9300000f,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00004000,  BBREG_0x03f,
	0x000C0006,  0x93000010,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00004000,  BBREG_0x03f, 0x000C0006,  0x90000001,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004040,
	BBREG_0x03f, 0x000C3186,  0x90000002,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00004040,  BBREG_0x03f, 0x000C3186,
	0x90000004,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x00004040,  BBREG_0x03f, 0x000C3186,  0x90000006,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00004080,  BBREG_0x03f,
	0x000C3186,  0x90000007,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00004040,  BBREG_0x03f, 0x000C3186,  0xA0000000,
	0x00000000,  BBREG_0x03e, 0x00004000,  BBREG_0x03f, 0x000C3186,
	0xB0000000,  0x00000000,  BBREG_0x033, 0x00000006,  BBREG_0x03e,
	0x00004080,  BBREG_0x03f, 0x000C3186,  BBREG_0x033, 0x00000005,
	BBREG_0x03e, 0x000040C8,  BBREG_0x03f, 0x000C3186,  BBREG_0x033,
	0x00000004,  BBREG_0x03e, 0x00004190,  BBREG_0x03f, 0x000C3186,
	BBREG_0x033, 0x00000003,  BBREG_0x03e, 0x00004998,  BBREG_0x03f,
	0x000C3186,  BBREG_0x033, 0x00000002,  BBREG_0x03e, 0x00005840,
	BBREG_0x03f, 0x000C3186,  BBREG_0x033, 0x00000001,  BBREG_0x03e,
	0x000058C2,  BBREG_0x03f, 0x000C3186,  BBREG_0x033, 0x00000000,
	BBREG_0x03e, 0x00005930,  BBREG_0x03f, 0x000C3186,  BBREG_0x033,
	0x0000000F,  0x83000000,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00004000,  BBREG_0x03f, 0x000C3186,  0x93000001,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004040,
	BBREG_0x03f, 0x000C3186,  0x93000002,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00004040,  BBREG_0x03f, 0x000C3186,
	0x93000003,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x00004000,  BBREG_0x03f, 0x000C0006,  0x93000004,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00004040,  BBREG_0x03f,
	0x000C3186,  0x93000005,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00004000,  BBREG_0x03f, 0x000C3186,  0x93000006,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004080,
	BBREG_0x03f, 0x000C3186,  0x93000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00004040,  BBREG_0x03f, 0x000C3186,
	0x93000008,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x00004000,  BBREG_0x03f, 0x000C0006,  0x93000009,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00004040,  BBREG_0x03f,
	0x000C3186,  0x9300000a,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00004000,  BBREG_0x03f, 0x000C3186,  0x9300000b,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004040,
	BBREG_0x03f, 0x000C3186,  0x9300000c,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00004000,  BBREG_0x03f, 0x000C0006,
	0x9300000d,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x00004000,  BBREG_0x03f, 0x000C3186,  0x9300000e,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00004000,  BBREG_0x03f,
	0x000C3186,  0x9300000f,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00004000,  BBREG_0x03f, 0x000C0006,  0x93000010,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004000,
	BBREG_0x03f, 0x000C0006,  0x90000001,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00004040,  BBREG_0x03f, 0x000C3186,
	0x90000002,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x00004040,  BBREG_0x03f, 0x000C3186,  0x90000004,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00004040,  BBREG_0x03f,
	0x000C3186,  0x90000006,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00004080,  BBREG_0x03f, 0x000C3186,  0x90000007,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004040,
	BBREG_0x03f, 0x000C3186,  0xA0000000,  0x00000000,  BBREG_0x03e,
	0x00004000,  BBREG_0x03f, 0x000C3186,  0xB0000000,  0x00000000,
	BBREG_0x033, 0x0000000E,  BBREG_0x03e, 0x00004080,  BBREG_0x03f,
	0x000C3186,  BBREG_0x033, 0x0000000D,  0x8300000f,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x000040D0,  0xA0000000,
	0x00000000,  BBREG_0x03e, 0x000040C8,  0xB0000000,  0x00000000,
	BBREG_0x03f, 0x000C3186,  BBREG_0x033, 0x0000000C,  BBREG_0x03e,
	0x00004190,  BBREG_0x03f, 0x000C3186,  BBREG_0x033, 0x0000000B,
	BBREG_0x03e, 0x00004998,  BBREG_0x03f, 0x000C3186,  BBREG_0x033,
	0x0000000A,  BBREG_0x03e, 0x00005840,  BBREG_0x03f, 0x000C3186,
	BBREG_0x033, 0x00000009,  BBREG_0x03e, 0x000058C2,  BBREG_0x03f,
	0x000C3186,  BBREG_0x033, 0x00000008,  BBREG_0x03e, 0x00005930,
	BBREG_0x03f, 0x000C3186,  BBREG_0x033, 0x00000017,  0x83000000,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004000,
	BBREG_0x03f, 0x000C3186,  0x93000001,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00004040,  BBREG_0x03f, 0x000C3186,
	0x93000002,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x00004040,  BBREG_0x03f, 0x000C3186,  0x93000003,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00004000,  BBREG_0x03f,
	0x000C0006,  0x93000004,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00004040,  BBREG_0x03f, 0x000C3186,  0x93000005,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004000,
	BBREG_0x03f, 0x000DFF86,  0x93000006,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00004080,  BBREG_0x03f, 0x000C3186,
	0x93000007,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x00004040,  BBREG_0x03f, 0x000C3186,  0x93000008,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00004000,  BBREG_0x03f,
	0x000C3186,  0x93000009,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00004040,  BBREG_0x03f, 0x000C3186,  0x9300000a,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004000,
	BBREG_0x03f, 0x000C3186,  0x9300000b,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00004040,  BBREG_0x03f, 0x000C3186,
	0x9300000c,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x00004000,  BBREG_0x03f, 0x000C0006,  0x9300000d,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00004000,  BBREG_0x03f,
	0x000DFF86,  0x9300000e,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00004000,  BBREG_0x03f, 0x000C3186,  0x9300000f,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004000,
	BBREG_0x03f, 0x000C0006,  0x93000010,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00004000,  BBREG_0x03f, 0x000C0006,
	0x90000001,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e,
	0x00004040,  BBREG_0x03f, 0x000C3186,  0x90000002,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03e, 0x00004040,  BBREG_0x03f,
	0x000C3186,  0x90000004,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x00004040,  BBREG_0x03f, 0x000C3186,  0x90000006,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03e, 0x00004080,
	BBREG_0x03f, 0x000C3186,  0x90000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03e, 0x00004040,  BBREG_0x03f, 0x000C3186,
	0xA0000000,  0x00000000,  BBREG_0x03e, 0x00004000,  BBREG_0x03f,
	0x000C3186,  0xB0000000,  0x00000000,  BBREG_0x033, 0x00000016,
	BBREG_0x03e, 0x00004080,  BBREG_0x03f, 0x000C3186,  BBREG_0x033,
	0x00000015,  0x8300000f,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03e, 0x000040D0,  0xA0000000,  0x00000000,  BBREG_0x03e,
	0x000040C8,  0xB0000000,  0x00000000,  BBREG_0x03f, 0x000C3186,
	BBREG_0x033, 0x00000014,  BBREG_0x03e, 0x00004190,  BBREG_0x03f,
	0x000C3186,  BBREG_0x033, 0x00000013,  BBREG_0x03e, 0x00004998,
	BBREG_0x03f, 0x000C3186,  BBREG_0x033, 0x00000012,  BBREG_0x03e,
	0x00005840,  BBREG_0x03f, 0x000C3186,  BBREG_0x033, 0x00000011,
	BBREG_0x03e, 0x000058C2,  BBREG_0x03f, 0x000C3186,  BBREG_0x033,
	0x00000010,  BBREG_0x03e, 0x00005930,  BBREG_0x03f, 0x000C3186,
	BBREG_0x0ef, 0x00000000,  BBREG_0x0ef, 0x00004000,  BBREG_0x033,
	0x00000000,  BBREG_0x03f, 0x0000000A,  BBREG_0x033, 0x00000001,
	0x83000000,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f,
	0x00000005,  0x93000001,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03f, 0x00000000,  0x93000002,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03f, 0x00000000,  0x93000003,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03f, 0x00000000,  0x93000004,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f, 0x00000000,
	0x93000005,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f,
	0x00000000,  0x93000006,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03f, 0x00000000,  0x93000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03f, 0x00000000,  0x93000008,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03f, 0x00000002,  0x93000009,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f, 0x00000000,
	0x9300000a,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f,
	0x00000005,  0x9300000b,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03f, 0x00000000,  0x9300000c,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03f, 0x00000000,  0x9300000d,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03f, 0x00000005,  0x9300000e,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f, 0x00000005,
	0x9300000f,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f,
	0x00000000,  0x93000010,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03f, 0x00000000,  0x90000001,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03f, 0x00000000,  0x90000002,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03f, 0x00000000,  0x90000003,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f, 0x00000000,
	0x90000004,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f,
	0x00000000,  0x90000005,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x03f, 0x00000000,  0x90000006,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x03f, 0x00000000,  0x90000007,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x03f, 0x00000000,  0xA0000000,
	0x00000000,  BBREG_0x03f, 0x00000005,  0xB0000000,  0x00000000,
	BBREG_0x033, 0x00000002,  BBREG_0x03f, 0x00000000,  BBREG_0x0ef,
	0x00000000,  BBREG_0x018, 0x00000401,  BBREG_0x084, 0x00001209,
	BBREG_0x086, 0x000001A0,  0x83000001,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x087, 0x00068080,  0x93000004,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x087, 0x00068080,  0x93000006,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x087, 0x00068080,
	0x93000007,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x087,
	0x00068080,  0x9300000b,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x087, 0x00068080,  0x90000001,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x087, 0x00068080,  0x90000004,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x087, 0x00068080,  0x90000006,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x087, 0x00068080,
	0x90000007,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x087,
	0x00068080,  0xA0000000,  0x00000000,  BBREG_0x087, 0x000E8180,
	0xB0000000,  0x00000000,  BBREG_0x088, 0x00070020,  BBREG_0x0de,
	0x00000010,  BBREG_0x0ef, 0x00008000,  BBREG_0x033, 0x0000000F,
	BBREG_0x03f, 0x0000003C,  BBREG_0x033, 0x0000000E,  BBREG_0x03f,
	0x00000038,  BBREG_0x033, 0x0000000D,  BBREG_0x03f, 0x00000030,
	BBREG_0x033, 0x0000000C,  BBREG_0x03f, 0x00000028,  BBREG_0x033,
	0x0000000B,  BBREG_0x03f, 0x00000020,  BBREG_0x033, 0x0000000A,
	BBREG_0x03f, 0x00000018,  BBREG_0x033, 0x00000009,  BBREG_0x03f,
	0x00000010,  BBREG_0x033, 0x00000008,  BBREG_0x03f, 0x00000008,
	BBREG_0x033, 0x00000007,  BBREG_0x03f, 0x0000003C,  BBREG_0x033,
	0x00000006,  BBREG_0x03f, 0x00000038,  BBREG_0x033, 0x00000005,
	BBREG_0x03f, 0x00000030,  BBREG_0x033, 0x00000004,  BBREG_0x03f,
	0x00000028,  BBREG_0x033, 0x00000003,  BBREG_0x03f, 0x00000020,
	BBREG_0x033, 0x00000002,  BBREG_0x03f, 0x00000018,  BBREG_0x033,
	0x00000001,  BBREG_0x03f, 0x00000010,  BBREG_0x033, 0x00000000,
	BBREG_0x03f, 0x00000008,  BBREG_0x0ef, 0x00000000,  BBREG_0x018,
	0x00018D24,  BBREG_0xffe, 0x00000000,  BBREG_0xffe, 0x00000000,
	BBREG_0xffe, 0x00000000,  BBREG_0xffe, 0x00000000,  BBREG_0x018,
	0x00010D24,  BBREG_0x01b, 0x00075A40,  BBREG_0x0ee, 0x00000002,
	BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00000004,  BBREG_0x033,
	0x00000001,  BBREG_0x03f, 0x00000004,  BBREG_0x033, 0x00000002,
	BBREG_0x03f, 0x00000004,  BBREG_0x033, 0x00000003,  BBREG_0x03f,
	0x00000004,  BBREG_0x033, 0x00000004,  BBREG_0x03f, 0x00000004,
	BBREG_0x033, 0x00000005,  BBREG_0x03f, 0x00000006,  BBREG_0x033,
	0x00000006,  BBREG_0x03f, 0x00000004,  BBREG_0x033, 0x00000007,
	BBREG_0x03f, 0x00000000,  BBREG_0x0ee, 0x00000000,  0x83000000,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x061, 0x0005D3D1,
	BBREG_0x062, 0x0000D3A2,  BBREG_0x063, 0x00000002,  0x93000001,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x061, 0x0005D4A0,
	BBREG_0x062, 0x0000D203,  BBREG_0x063, 0x00000062,  0x93000002,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x061, 0x0005D2A1,
	BBREG_0x062, 0x0000D3A2,  BBREG_0x063, 0x00000062,  0x93000003,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x061, 0x0005D2A1,
	BBREG_0x062, 0x0000D3A2,  BBREG_0x063, 0x00000002,  0x93000004,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x061, 0x0005D2A1,
	BBREG_0x062, 0x0000D3A2,  BBREG_0x063, 0x00000062,  0x93000005,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x061, 0x0005D2A1,
	BBREG_0x062, 0x0000D3A2,  BBREG_0x063, 0x00000002,  0x93000006,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x061, 0x0005D4A0,
	BBREG_0x062, 0x0000D203,  BBREG_0x063, 0x00000062,  0x93000007,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x061, 0x0005D4A0,
	BBREG_0x062, 0x0000D203,  BBREG_0x063, 0x00000062,  0x93000008,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x061, 0x0005D2A1,
	BBREG_0x062, 0x0000D3A2,  BBREG_0x063, 0x00000002,  0x93000009,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x061, 0x0005D3D1,
	BBREG_0x062, 0x0000D3A2,  BBREG_0x063, 0x00000002,  0x9300000a,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x061, 0x0005D3D1,
	BBREG_0x062, 0x0000D3A2,  BBREG_0x063, 0x00000002,  0x9300000b,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x061, 0x0005D4A0,
	BBREG_0x062, 0x0000D203,  BBREG_0x063, 0x00000062,  0x9300000c,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x061, 0x0005D2A1,
	BBREG_0x062, 0x0000D3A2,  BBREG_0x063, 0x00000002,  0x9300000d,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x061, 0x0005D3D1,
	BBREG_0x062, 0x0000D3A2,  BBREG_0x063, 0x00000002,  0x9300000e,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x061, 0x0005D3D1,
	BBREG_0x062, 0x0000D3A2,  BBREG_0x063, 0x00000002,  0x9300000f,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x061, 0x0005D2A1,
	BBREG_0x062, 0x0000D3A2,  BBREG_0x063, 0x00000002,  0x93000010,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x061, 0x0005D2A1,
	BBREG_0x062, 0x0000D3A2,  BBREG_0x063, 0x00000002,  0x90000001,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x061, 0x0005D4A0,
	BBREG_0x062, 0x0000D203,  BBREG_0x063, 0x00000062,  0x90000002,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x061, 0x0005D2A1,
	BBREG_0x062, 0x0000D3A2,  BBREG_0x063, 0x00000062,  0x90000003,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x061, 0x0005D2A1,
	BBREG_0x062, 0x0000D3A2,  BBREG_0x063, 0x00000002,  0x90000004,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x061, 0x0005D2A1,
	BBREG_0x062, 0x0000D3A2,  BBREG_0x063, 0x00000062,  0x90000005,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x061, 0x0005D2A1,
	BBREG_0x062, 0x0000D3A2,  BBREG_0x063, 0x00000002,  0x90000006,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x061, 0x0005D4A0,
	BBREG_0x062, 0x0000D203,  BBREG_0x063, 0x00000062,  0x90000007,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x061, 0x0005D4A0,
	BBREG_0x062, 0x0000D203,  BBREG_0x063, 0x00000062,  0xA0000000,
	0x00000000,  BBREG_0x061, 0x0005D3D0,  BBREG_0x062, 0x0000D303,
	BBREG_0x063, 0x00000002,  0xB0000000,  0x00000000,  BBREG_0x0ef,
	0x00000200,  0x83000000,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x030, 0x000003A2,  BBREG_0x030, 0x000013A2,  BBREG_0x030,
	0x000023A2,  BBREG_0x030, 0x000033A2,  BBREG_0x030, 0x000043A3,
	BBREG_0x030, 0x000053A3,  BBREG_0x030, 0x000063A3,  BBREG_0x030,
	0x000073A3,  BBREG_0x030, 0x000083A3,  BBREG_0x030, 0x000093A3,
	BBREG_0x030, 0x0000A3A3,  BBREG_0x030, 0x0000B3A3,  0x93000001,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x030, 0x000004A3,
	BBREG_0x030, 0x000014A3,  BBREG_0x030, 0x000024A3,  BBREG_0x030,
	0x000034A3,  BBREG_0x030, 0x000044A3,  BBREG_0x030, 0x000054A3,
	BBREG_0x030, 0x000064A3,  BBREG_0x030, 0x000074A3,  BBREG_0x030,
	0x000084A3,  BBREG_0x030, 0x000094A3,  BBREG_0x030, 0x0000A4A3,
	BBREG_0x030, 0x0000B4A3,  0x93000002,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x030, 0x000002A6,  BBREG_0x030, 0x000012A6,
	BBREG_0x030, 0x000022A6,  BBREG_0x030, 0x000032A6,  BBREG_0x030,
	0x000042A6,  BBREG_0x030, 0x000052A6,  BBREG_0x030, 0x000062A6,
	BBREG_0x030, 0x000072A6,  BBREG_0x030, 0x000082A6,  BBREG_0x030,
	0x000092A6,  BBREG_0x030, 0x0000A2A6,  BBREG_0x030, 0x0000B2A6,
	0x93000003,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x030,
	0x00000303,  BBREG_0x030, 0x00001303,  BBREG_0x030, 0x00002303,
	BBREG_0x030, 0x00003303,  BBREG_0x030, 0x000043A4,  BBREG_0x030,
	0x000053A4,  BBREG_0x030, 0x000063A4,  BBREG_0x030, 0x000073A4,
	BBREG_0x030, 0x00008365,  BBREG_0x030, 0x00009365,  BBREG_0x030,
	0x0000A365,  BBREG_0x030, 0x0000B365,  0x93000004,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x030, 0x000002A6,  BBREG_0x030,
	0x000012A6,  BBREG_0x030, 0x000022A6,  BBREG_0x030, 0x000032A6,
	BBREG_0x030, 0x000042A6,  BBREG_0x030, 0x000052A6,  BBREG_0x030,
	0x000062A6,  BBREG_0x030, 0x000072A6,  BBREG_0x030, 0x000082A6,
	BBREG_0x030, 0x000092A6,  BBREG_0x030, 0x0000A2A6,  BBREG_0x030,
	0x0000B2A6,  0x93000005,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x030, 0x000004A4,  BBREG_0x030, 0x000014A4,  BBREG_0x030,
	0x000024A4,  BBREG_0x030, 0x000034A4,  BBREG_0x030, 0x000043A4,
	BBREG_0x030, 0x000053A4,  BBREG_0x030, 0x000063A4,  BBREG_0x030,
	0x000073A4,  BBREG_0x030, 0x000083A5,  BBREG_0x030, 0x000093A5,
	BBREG_0x030, 0x0000A3A5,  BBREG_0x030, 0x0000B3A5,  0x93000006,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x030, 0x000004A3,
	BBREG_0x030, 0x000014A3,  BBREG_0x030, 0x000024A3,  BBREG_0x030,
	0x000034A3,  BBREG_0x030, 0x000044A3,  BBREG_0x030, 0x000054A3,
	BBREG_0x030, 0x000064A3,  BBREG_0x030, 0x000074A3,  BBREG_0x030,
	0x000084A3,  BBREG_0x030, 0x000094A3,  BBREG_0x030, 0x0000A4A3,
	BBREG_0x030, 0x0000B4A3,  0x93000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x030, 0x000004A3,  BBREG_0x030, 0x000014A3,
	BBREG_0x030, 0x000024A3,  BBREG_0x030, 0x000034A3,  BBREG_0x030,
	0x000044A3,  BBREG_0x030, 0x000054A3,  BBREG_0x030, 0x000064A3,
	BBREG_0x030, 0x000074A3,  BBREG_0x030, 0x000084A3,  BBREG_0x030,
	0x000094A3,  BBREG_0x030, 0x0000A4A3,  BBREG_0x030, 0x0000B4A3,
	0x93000008,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x030,
	0x000002F4,  BBREG_0x030, 0x000012F4,  BBREG_0x030, 0x000022F4,
	BBREG_0x030, 0x000032F4,  BBREG_0x030, 0x00004365,  BBREG_0x030,
	0x00005365,  BBREG_0x030, 0x00006365,  BBREG_0x030, 0x00007365,
	BBREG_0x030, 0x000082A4,  BBREG_0x030, 0x000092A4,  BBREG_0x030,
	0x0000A2A4,  BBREG_0x030, 0x0000B2A4,  0x93000009,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x030, 0x00000382,  BBREG_0x030,
	0x00001382,  BBREG_0x030, 0x00002382,  BBREG_0x030, 0x00003382,
	BBREG_0x030, 0x00004445,  BBREG_0x030, 0x00005445,  BBREG_0x030,
	0x00006445,  BBREG_0x030, 0x00007445,  BBREG_0x030, 0x00008425,
	BBREG_0x030, 0x00009425,  BBREG_0x030, 0x0000A425,  BBREG_0x030,
	0x0000B425,  0x9300000a,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x030, 0x000003A2,  BBREG_0x030, 0x000013A2,  BBREG_0x030,
	0x000023A2,  BBREG_0x030, 0x000033A2,  BBREG_0x030, 0x000043A3,
	BBREG_0x030, 0x000053A3,  BBREG_0x030, 0x000063A3,  BBREG_0x030,
	0x000073A3,  BBREG_0x030, 0x000083A3,  BBREG_0x030, 0x000093A3,
	BBREG_0x030, 0x0000A3A3,  BBREG_0x030, 0x0000B3A3,  0x9300000b,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x030, 0x000004A3,
	BBREG_0x030, 0x000014A3,  BBREG_0x030, 0x000024A3,  BBREG_0x030,
	0x000034A3,  BBREG_0x030, 0x000044A3,  BBREG_0x030, 0x000054A3,
	BBREG_0x030, 0x000064A3,  BBREG_0x030, 0x000074A3,  BBREG_0x030,
	0x000084A3,  BBREG_0x030, 0x000094A3,  BBREG_0x030, 0x0000A4A3,
	BBREG_0x030, 0x0000B4A3,  0x9300000c,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x030, 0x00000443,  BBREG_0x030, 0x00001443,
	BBREG_0x030, 0x00002443,  BBREG_0x030, 0x00003443,  BBREG_0x030,
	0x000043A4,  BBREG_0x030, 0x000053A4,  BBREG_0x030, 0x000063A4,
	BBREG_0x030, 0x000073A4,  BBREG_0x030, 0x00008365,  BBREG_0x030,
	0x00009365,  BBREG_0x030, 0x0000A365,  BBREG_0x030, 0x0000B365,
	0x9300000d,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x030,
	0x00000343,  BBREG_0x030, 0x00001343,  BBREG_0x030, 0x00002343,
	BBREG_0x030, 0x00003343,  BBREG_0x030, 0x00004483,  BBREG_0x030,
	0x00005483,  BBREG_0x030, 0x00006483,  BBREG_0x030, 0x00007483,
	BBREG_0x030, 0x000083A4,  BBREG_0x030, 0x000093A4,  BBREG_0x030,
	0x0000A3A4,  BBREG_0x030, 0x0000B3A4,  0x9300000e,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x030, 0x000003A2,  BBREG_0x030,
	0x000013A2,  BBREG_0x030, 0x000023A2,  BBREG_0x030, 0x000033A2,
	BBREG_0x030, 0x00004423,  BBREG_0x030, 0x00005423,  BBREG_0x030,
	0x00006423,  BBREG_0x030, 0x00007423,  BBREG_0x030, 0x00008324,
	BBREG_0x030, 0x00009324,  BBREG_0x030, 0x0000A324,  BBREG_0x030,
	0x0000B324,  0x9300000f,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x030, 0x00000303,  BBREG_0x030, 0x00001303,  BBREG_0x030,
	0x00002303,  BBREG_0x030, 0x00003303,  BBREG_0x030, 0x000043A4,
	BBREG_0x030, 0x000053A4,  BBREG_0x030, 0x000063A4,  BBREG_0x030,
	0x000073A4,  BBREG_0x030, 0x00008365,  BBREG_0x030, 0x00009365,
	BBREG_0x030, 0x0000A365,  BBREG_0x030, 0x0000B365,  0x93000010,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x030, 0x00000403,
	BBREG_0x030, 0x00001403,  BBREG_0x030, 0x00002403,  BBREG_0x030,
	0x00003403,  BBREG_0x030, 0x000043A4,  BBREG_0x030, 0x000053A4,
	BBREG_0x030, 0x000063A4,  BBREG_0x030, 0x000073A4,  BBREG_0x030,
	0x000083A3,  BBREG_0x030, 0x000093A3,  BBREG_0x030, 0x0000A3A3,
	BBREG_0x030, 0x0000B3A3,  0x90000001,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x030, 0x000004A0,  BBREG_0x030, 0x000014A0,
	BBREG_0x030, 0x000024A0,  BBREG_0x030, 0x000034A0,  BBREG_0x030,
	0x000044A0,  BBREG_0x030, 0x000054A0,  BBREG_0x030, 0x000064A0,
	BBREG_0x030, 0x000074A0,  BBREG_0x030, 0x000084A0,  BBREG_0x030,
	0x000094A0,  BBREG_0x030, 0x0000A4A0,  BBREG_0x030, 0x0000B4A0,
	0x90000002,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x030,
	0x000002A1,  BBREG_0x030, 0x000012A1,  BBREG_0x030, 0x000022A1,
	BBREG_0x030, 0x000032A1,  BBREG_0x030, 0x000042A1,  BBREG_0x030,
	0x000052A1,  BBREG_0x030, 0x000062A1,  BBREG_0x030, 0x000072A1,
	BBREG_0x030, 0x000082A1,  BBREG_0x030, 0x000092A1,  BBREG_0x030,
	0x0000A2A1,  BBREG_0x030, 0x0000B2A1,  0x90000003,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x030, 0x000004A0,  BBREG_0x030,
	0x000014A0,  BBREG_0x030, 0x000024A0,  BBREG_0x030, 0x000034A0,
	BBREG_0x030, 0x000043A1,  BBREG_0x030, 0x000053A1,  BBREG_0x030,
	0x000063A1,  BBREG_0x030, 0x000073A1,  BBREG_0x030, 0x000083A2,
	BBREG_0x030, 0x000093A2,  BBREG_0x030, 0x0000A3A2,  BBREG_0x030,
	0x0000B3A2,  0x90000004,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x030, 0x000002A1,  BBREG_0x030, 0x000012A1,  BBREG_0x030,
	0x000022A1,  BBREG_0x030, 0x000032A1,  BBREG_0x030, 0x000042A1,
	BBREG_0x030, 0x000052A1,  BBREG_0x030, 0x000062A1,  BBREG_0x030,
	0x000072A1,  BBREG_0x030, 0x000082A1,  BBREG_0x030, 0x000092A1,
	BBREG_0x030, 0x0000A2A1,  BBREG_0x030, 0x0000B2A1,  0x90000005,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x030, 0x000004A1,
	BBREG_0x030, 0x000014A1,  BBREG_0x030, 0x000024A1,  BBREG_0x030,
	0x000034A1,  BBREG_0x030, 0x000043A1,  BBREG_0x030, 0x000053A1,
	BBREG_0x030, 0x000063A1,  BBREG_0x030, 0x000073A1,  BBREG_0x030,
	0x000083A1,  BBREG_0x030, 0x000093A1,  BBREG_0x030, 0x0000A3A1,
	BBREG_0x030, 0x0000B3A1,  0x90000006,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x030, 0x000004A0,  BBREG_0x030, 0x000014A0,
	BBREG_0x030, 0x000024A0,  BBREG_0x030, 0x000034A0,  BBREG_0x030,
	0x000044A0,  BBREG_0x030, 0x000054A0,  BBREG_0x030, 0x000064A0,
	BBREG_0x030, 0x000074A0,  BBREG_0x030, 0x000084A0,  BBREG_0x030,
	0x000094A0,  BBREG_0x030, 0x0000A4A0,  BBREG_0x030, 0x0000B4A0,
	0x90000007,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x030,
	0x000004A0,  BBREG_0x030, 0x000014A0,  BBREG_0x030, 0x000024A0,
	BBREG_0x030, 0x000034A0,  BBREG_0x030, 0x000044A0,  BBREG_0x030,
	0x000054A0,  BBREG_0x030, 0x000064A0,  BBREG_0x030, 0x000074A0,
	BBREG_0x030, 0x000084A0,  BBREG_0x030, 0x000094A0,  BBREG_0x030,
	0x0000A4A0,  BBREG_0x030, 0x0000B4A0,  0xA0000000,  0x00000000,
	BBREG_0x030, 0x000002D0,  BBREG_0x030, 0x000012D0,  BBREG_0x030,
	0x000022D0,  BBREG_0x030, 0x000032D0,  BBREG_0x030, 0x000042D0,
	BBREG_0x030, 0x000052D0,  BBREG_0x030, 0x000062D0,  BBREG_0x030,
	0x000072D0,  BBREG_0x030, 0x000082D0,  BBREG_0x030, 0x000092D0,
	BBREG_0x030, 0x0000A2D0,  BBREG_0x030, 0x0000B2D0,  0xB0000000,
	0x00000000,  BBREG_0x0ef, 0x00000000,  BBREG_0x0ef, 0x00000080,
	0x83000000,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x030,
	0x000003A2,  BBREG_0x030, 0x000013A2,  BBREG_0x030, 0x000023A2,
	BBREG_0x030, 0x000033A2,  BBREG_0x030, 0x000043A2,  BBREG_0x030,
	0x000053A2,  BBREG_0x030, 0x000063A2,  BBREG_0x030, 0x000073A2,
	BBREG_0x030, 0x000083A2,  BBREG_0x030, 0x000093A2,  BBREG_0x030,
	0x0000A3A2,  BBREG_0x030, 0x0000B3A2,  0x93000001,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x030, 0x00000203,  BBREG_0x030,
	0x00001203,  BBREG_0x030, 0x00002203,  BBREG_0x030, 0x00003203,
	BBREG_0x030, 0x00004203,  BBREG_0x030, 0x00005203,  BBREG_0x030,
	0x00006203,  BBREG_0x030, 0x00007203,  BBREG_0x030, 0x00008203,
	BBREG_0x030, 0x00009203,  BBREG_0x030, 0x0000A203,  BBREG_0x030,
	0x0000B203,  0x93000002,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x030, 0x000003A2,  BBREG_0x030, 0x000013A2,  BBREG_0x030,
	0x000023A2,  BBREG_0x030, 0x000033A2,  BBREG_0x030, 0x000043A2,
	BBREG_0x030, 0x000053A2,  BBREG_0x030, 0x000063A2,  BBREG_0x030,
	0x000073A2,  BBREG_0x030, 0x000083A2,  BBREG_0x030, 0x000093A2,
	BBREG_0x030, 0x0000A3A2,  BBREG_0x030, 0x0000B3A2,  0x93000003,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x030, 0x000003A2,
	BBREG_0x030, 0x000013A2,  BBREG_0x030, 0x000023A2,  BBREG_0x030,
	0x000033A2,  BBREG_0x030, 0x000043A2,  BBREG_0x030, 0x000053A2,
	BBREG_0x030, 0x000063A2,  BBREG_0x030, 0x000073A2,  BBREG_0x030,
	0x000083A2,  BBREG_0x030, 0x000093A2,  BBREG_0x030, 0x0000A3A2,
	BBREG_0x030, 0x0000B3A2,  0x93000004,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x030, 0x000003A2,  BBREG_0x030, 0x000013A2,
	BBREG_0x030, 0x000023A2,  BBREG_0x030, 0x000033A2,  BBREG_0x030,
	0x000043A2,  BBREG_0x030, 0x000053A2,  BBREG_0x030, 0x000063A2,
	BBREG_0x030, 0x000073A2,  BBREG_0x030, 0x000083A2,  BBREG_0x030,
	0x000093A2,  BBREG_0x030, 0x0000A3A2,  BBREG_0x030, 0x0000B3A2,
	0x93000005,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x030,
	0x000003A2,  BBREG_0x030, 0x000013A2,  BBREG_0x030, 0x000023A2,
	BBREG_0x030, 0x000033A2,  BBREG_0x030, 0x000043A2,  BBREG_0x030,
	0x000053A2,  BBREG_0x030, 0x000063A2,  BBREG_0x030, 0x000073A2,
	BBREG_0x030, 0x000083A2,  BBREG_0x030, 0x000093A2,  BBREG_0x030,
	0x0000A3A2,  BBREG_0x030, 0x0000B3A2,  0x93000006,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x030, 0x00000203,  BBREG_0x030,
	0x00001203,  BBREG_0x030, 0x00002203,  BBREG_0x030, 0x00003203,
	BBREG_0x030, 0x00004203,  BBREG_0x030, 0x00005203,  BBREG_0x030,
	0x00006203,  BBREG_0x030, 0x00007203,  BBREG_0x030, 0x00008203,
	BBREG_0x030, 0x00009203,  BBREG_0x030, 0x0000A203,  BBREG_0x030,
	0x0000B203,  0x93000007,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x030, 0x00000203,  BBREG_0x030, 0x00001203,  BBREG_0x030,
	0x00002203,  BBREG_0x030, 0x00003203,  BBREG_0x030, 0x00004203,
	BBREG_0x030, 0x00005203,  BBREG_0x030, 0x00006203,  BBREG_0x030,
	0x00007203,  BBREG_0x030, 0x00008203,  BBREG_0x030, 0x00009203,
	BBREG_0x030, 0x0000A203,  BBREG_0x030, 0x0000B203,  0x93000008,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x030, 0x000003A3,
	BBREG_0x030, 0x000013A3,  BBREG_0x030, 0x000023A3,  BBREG_0x030,
	0x000033A3,  BBREG_0x030, 0x000043A4,  BBREG_0x030, 0x000053A4,
	BBREG_0x030, 0x000063A4,  BBREG_0x030, 0x000073A4,  BBREG_0x030,
	0x000083A3,  BBREG_0x030, 0x000093A3,  BBREG_0x030, 0x0000A3A3,
	BBREG_0x030, 0x0000B3A3,  0x93000009,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x030, 0x000003A2,  BBREG_0x030, 0x000013A2,
	BBREG_0x030, 0x000023A2,  BBREG_0x030, 0x000033A2,  BBREG_0x030,
	0x000043A2,  BBREG_0x030, 0x000053A2,  BBREG_0x030, 0x000063A2,
	BBREG_0x030, 0x000073A2,  BBREG_0x030, 0x000083A2,  BBREG_0x030,
	0x000093A2,  BBREG_0x030, 0x0000A3A2,  BBREG_0x030, 0x0000B3A2,
	0x9300000a,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x030,
	0x000003A2,  BBREG_0x030, 0x000013A2,  BBREG_0x030, 0x000023A2,
	BBREG_0x030, 0x000033A2,  BBREG_0x030, 0x000043A2,  BBREG_0x030,
	0x000053A2,  BBREG_0x030, 0x000063A2,  BBREG_0x030, 0x000073A2,
	BBREG_0x030, 0x000083A2,  BBREG_0x030, 0x000093A2,  BBREG_0x030,
	0x0000A3A2,  BBREG_0x030, 0x0000B3A2,  0x9300000b,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x030, 0x00000203,  BBREG_0x030,
	0x00001203,  BBREG_0x030, 0x00002203,  BBREG_0x030, 0x00003203,
	BBREG_0x030, 0x00004203,  BBREG_0x030, 0x00005203,  BBREG_0x030,
	0x00006203,  BBREG_0x030, 0x00007203,  BBREG_0x030, 0x00008203,
	BBREG_0x030, 0x00009203,  BBREG_0x030, 0x0000A203,  BBREG_0x030,
	0x0000B203,  0x9300000c,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x030, 0x000003A2,  BBREG_0x030, 0x000013A2,  BBREG_0x030,
	0x000023A2,  BBREG_0x030, 0x000033A2,  BBREG_0x030, 0x000043A2,
	BBREG_0x030, 0x000053A2,  BBREG_0x030, 0x000063A2,  BBREG_0x030,
	0x000073A2,  BBREG_0x030, 0x000083A2,  BBREG_0x030, 0x000093A2,
	BBREG_0x030, 0x0000A3A2,  BBREG_0x030, 0x0000B3A2,  0x9300000d,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x030, 0x000003A2,
	BBREG_0x030, 0x000013A2,  BBREG_0x030, 0x000023A2,  BBREG_0x030,
	0x000033A2,  BBREG_0x030, 0x000043A2,  BBREG_0x030, 0x000053A2,
	BBREG_0x030, 0x000063A2,  BBREG_0x030, 0x000073A2,  BBREG_0x030,
	0x000083A2,  BBREG_0x030, 0x000093A2,  BBREG_0x030, 0x0000A3A2,
	BBREG_0x030, 0x0000B3A2,  0x9300000e,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x030, 0x000003A2,  BBREG_0x030, 0x000013A2,
	BBREG_0x030, 0x000023A2,  BBREG_0x030, 0x000033A2,  BBREG_0x030,
	0x000043A2,  BBREG_0x030, 0x000053A2,  BBREG_0x030, 0x000063A2,
	BBREG_0x030, 0x000073A2,  BBREG_0x030, 0x000083A2,  BBREG_0x030,
	0x000093A2,  BBREG_0x030, 0x0000A3A2,  BBREG_0x030, 0x0000B3A2,
	0x9300000f,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x030,
	0x000003A2,  BBREG_0x030, 0x000013A2,  BBREG_0x030, 0x000023A2,
	BBREG_0x030, 0x000033A2,  BBREG_0x030, 0x000043A2,  BBREG_0x030,
	0x000053A2,  BBREG_0x030, 0x000063A2,  BBREG_0x030, 0x000073A2,
	BBREG_0x030, 0x000083A2,  BBREG_0x030, 0x000093A2,  BBREG_0x030,
	0x0000A3A2,  BBREG_0x030, 0x0000B3A2,  0x93000010,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x030, 0x000003A2,  BBREG_0x030,
	0x000013A2,  BBREG_0x030, 0x000023A2,  BBREG_0x030, 0x000033A2,
	BBREG_0x030, 0x000043A2,  BBREG_0x030, 0x000053A2,  BBREG_0x030,
	0x000063A2,  BBREG_0x030, 0x000073A2,  BBREG_0x030, 0x000083A2,
	BBREG_0x030, 0x000093A2,  BBREG_0x030, 0x0000A3A2,  BBREG_0x030,
	0x0000B3A2,  0x90000001,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x030, 0x00000203,  BBREG_0x030, 0x00001203,  BBREG_0x030,
	0x00002203,  BBREG_0x030, 0x00003203,  BBREG_0x030, 0x00004203,
	BBREG_0x030, 0x00005203,  BBREG_0x030, 0x00006203,  BBREG_0x030,
	0x00007203,  BBREG_0x030, 0x00008203,  BBREG_0x030, 0x00009203,
	BBREG_0x030, 0x0000A203,  BBREG_0x030, 0x0000B203,  0x90000002,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x030, 0x000003A2,
	BBREG_0x030, 0x000013A2,  BBREG_0x030, 0x000023A2,  BBREG_0x030,
	0x000033A2,  BBREG_0x030, 0x000043A2,  BBREG_0x030, 0x000053A2,
	BBREG_0x030, 0x000063A2,  BBREG_0x030, 0x000073A2,  BBREG_0x030,
	0x000083A2,  BBREG_0x030, 0x000093A2,  BBREG_0x030, 0x0000A3A2,
	BBREG_0x030, 0x0000B3A2,  0x90000003,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x030, 0x000003A2,  BBREG_0x030, 0x000013A2,
	BBREG_0x030, 0x000023A2,  BBREG_0x030, 0x000033A2,  BBREG_0x030,
	0x000043A2,  BBREG_0x030, 0x000053A2,  BBREG_0x030, 0x000063A2,
	BBREG_0x030, 0x000073A2,  BBREG_0x030, 0x000083A2,  BBREG_0x030,
	0x000093A2,  BBREG_0x030, 0x0000A3A2,  BBREG_0x030, 0x0000B3A2,
	0x90000004,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x030,
	0x000003A2,  BBREG_0x030, 0x000013A2,  BBREG_0x030, 0x000023A2,
	BBREG_0x030, 0x000033A2,  BBREG_0x030, 0x000043A2,  BBREG_0x030,
	0x000053A2,  BBREG_0x030, 0x000063A2,  BBREG_0x030, 0x000073A2,
	BBREG_0x030, 0x000083A2,  BBREG_0x030, 0x000093A2,  BBREG_0x030,
	0x0000A3A2,  BBREG_0x030, 0x0000B3A2,  0x90000005,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x030, 0x000003A2,  BBREG_0x030,
	0x000013A2,  BBREG_0x030, 0x000023A2,  BBREG_0x030, 0x000033A2,
	BBREG_0x030, 0x000043A2,  BBREG_0x030, 0x000053A2,  BBREG_0x030,
	0x000063A2,  BBREG_0x030, 0x000073A2,  BBREG_0x030, 0x000083A2,
	BBREG_0x030, 0x000093A2,  BBREG_0x030, 0x0000A3A2,  BBREG_0x030,
	0x0000B3A2,  0x90000006,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x030, 0x00000203,  BBREG_0x030, 0x00001203,  BBREG_0x030,
	0x00002203,  BBREG_0x030, 0x00003203,  BBREG_0x030, 0x00004203,
	BBREG_0x030, 0x00005203,  BBREG_0x030, 0x00006203,  BBREG_0x030,
	0x00007203,  BBREG_0x030, 0x00008203,  BBREG_0x030, 0x00009203,
	BBREG_0x030, 0x0000A203,  BBREG_0x030, 0x0000B203,  0x90000007,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x030, 0x00000203,
	BBREG_0x030, 0x00001203,  BBREG_0x030, 0x00002203,  BBREG_0x030,
	0x00003203,  BBREG_0x030, 0x00004203,  BBREG_0x030, 0x00005203,
	BBREG_0x030, 0x00006203,  BBREG_0x030, 0x00007203,  BBREG_0x030,
	0x00008203,  BBREG_0x030, 0x00009203,  BBREG_0x030, 0x0000A203,
	BBREG_0x030, 0x0000B203,  0xA0000000,  0x00000000,  BBREG_0x030,
	0x000003A2,  BBREG_0x030, 0x000013A2,  BBREG_0x030, 0x000023A2,
	BBREG_0x030, 0x000033A2,  BBREG_0x030, 0x000043A2,  BBREG_0x030,
	0x000053A2,  BBREG_0x030, 0x000063A2,  BBREG_0x030, 0x000073A2,
	BBREG_0x030, 0x000083A2,  BBREG_0x030, 0x000093A2,  BBREG_0x030,
	0x0000A3A2,  BBREG_0x030, 0x0000B3A2,  0xB0000000,  0x00000000,
	BBREG_0x0ef, 0x00000000,  BBREG_0x0ef, 0x00000040,  0x83000000,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x030, 0x00000764,
	BBREG_0x030, 0x00001632,  BBREG_0x030, 0x00002421,  BBREG_0x030,
	0x00004000,  BBREG_0x030, 0x00005000,  BBREG_0x030, 0x00006000,
	0x93000001,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x030,
	0x00000645,  BBREG_0x030, 0x00001333,  BBREG_0x030, 0x00002011,
	BBREG_0x030, 0x00004000,  BBREG_0x030, 0x00005000,  BBREG_0x030,
	0x00006000,  0x93000002,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x030, 0x00000645,  BBREG_0x030, 0x00001333,  BBREG_0x030,
	0x00002011,  BBREG_0x030, 0x00004777,  BBREG_0x030, 0x00005777,
	BBREG_0x030, 0x00006777,  0x93000003,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x030, 0x00000777,  BBREG_0x030, 0x00001442,
	BBREG_0x030, 0x00002222,  BBREG_0x030, 0x00004777,  BBREG_0x030,
	0x00005777,  BBREG_0x030, 0x00006777,  0x93000004,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x030, 0x00000645,  BBREG_0x030,
	0x00001333,  BBREG_0x030, 0x00002011,  BBREG_0x030, 0x00004777,
	BBREG_0x030, 0x00005777,  BBREG_0x030, 0x00006777,  0x93000005,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x030, 0x00000764,
	BBREG_0x030, 0x00001452,  BBREG_0x030, 0x00002220,  BBREG_0x030,
	0x00004777,  BBREG_0x030, 0x00005777,  BBREG_0x030, 0x00006777,
	0x93000006,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x030,
	0x00000645,  BBREG_0x030, 0x00001333,  BBREG_0x030, 0x00002011,
	BBREG_0x030, 0x00004000,  BBREG_0x030, 0x00005000,  BBREG_0x030,
	0x00006000,  0x93000007,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x030, 0x00000645,  BBREG_0x030, 0x00001333,  BBREG_0x030,
	0x00002011,  BBREG_0x030, 0x00004000,  BBREG_0x030, 0x00005000,
	BBREG_0x030, 0x00006000,  0x93000008,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x030, 0x00000660,  BBREG_0x030, 0x00001341,
	BBREG_0x030, 0x00002220,  BBREG_0x030, 0x00004777,  BBREG_0x030,
	0x00005777,  BBREG_0x030, 0x00006777,  0x93000009,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x030, 0x00000764,  BBREG_0x030,
	0x00001632,  BBREG_0x030, 0x00002421,  BBREG_0x030, 0x00004000,
	BBREG_0x030, 0x00005000,  BBREG_0x030, 0x00006000,  0x9300000a,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x030, 0x00000764,
	BBREG_0x030, 0x00001632,  BBREG_0x030, 0x00002421,  BBREG_0x030,
	0x00004000,  BBREG_0x030, 0x00005000,  BBREG_0x030, 0x00006000,
	0x9300000b,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x030,
	0x00000645,  BBREG_0x030, 0x00001333,  BBREG_0x030, 0x00002011,
	BBREG_0x030, 0x00004000,  BBREG_0x030, 0x00005000,  BBREG_0x030,
	0x00006000,  0x9300000c,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x030, 0x00000767,  BBREG_0x030, 0x00001442,  BBREG_0x030,
	0x00002222,  BBREG_0x030, 0x00004777,  BBREG_0x030, 0x00005777,
	BBREG_0x030, 0x00006777,  0x9300000d,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x030, 0x00000765,  BBREG_0x030, 0x00001632,
	BBREG_0x030, 0x00002451,  BBREG_0x030, 0x00004000,  BBREG_0x030,
	0x00005000,  BBREG_0x030, 0x00006000,  0x9300000e,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x030, 0x00000764,  BBREG_0x030,
	0x00001632,  BBREG_0x030, 0x00002421,  BBREG_0x030, 0x00004000,
	BBREG_0x030, 0x00005000,  BBREG_0x030, 0x00006000,  0x9300000f,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x030, 0x00000777,
	BBREG_0x030, 0x00001442,  BBREG_0x030, 0x00002222,  BBREG_0x030,
	0x00004777,  BBREG_0x030, 0x00005777,  BBREG_0x030, 0x00006777,
	0x93000010,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x030,
	0x00000776,  BBREG_0x030, 0x00001442,  BBREG_0x030, 0x00002222,
	BBREG_0x030, 0x00004777,  BBREG_0x030, 0x00005777,  BBREG_0x030,
	0x00006777,  0x90000001,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x030, 0x00000645,  BBREG_0x030, 0x00001333,  BBREG_0x030,
	0x00002011,  BBREG_0x030, 0x00004000,  BBREG_0x030, 0x00005000,
	BBREG_0x030, 0x00006000,  0x90000002,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x030, 0x00000645,  BBREG_0x030, 0x00001333,
	BBREG_0x030, 0x00002011,  BBREG_0x030, 0x00004000,  BBREG_0x030,
	0x00005000,  BBREG_0x030, 0x00006000,  0x90000003,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x030, 0x00000775,  BBREG_0x030,
	0x00001422,  BBREG_0x030, 0x00002210,  BBREG_0x030, 0x00004000,
	BBREG_0x030, 0x00005000,  BBREG_0x030, 0x00006000,  0x90000004,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x030, 0x00000645,
	BBREG_0x030, 0x00001333,  BBREG_0x030, 0x00002011,  BBREG_0x030,
	0x00004000,  BBREG_0x030, 0x00005000,  BBREG_0x030, 0x00006000,
	0x90000005,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x030,
	0x00000775,  BBREG_0x030, 0x00001222,  BBREG_0x030, 0x00002210,
	BBREG_0x030, 0x00004000,  BBREG_0x030, 0x00005000,  BBREG_0x030,
	0x00006000,  0x90000006,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x030, 0x00000645,  BBREG_0x030, 0x00001333,  BBREG_0x030,
	0x00002011,  BBREG_0x030, 0x00004000,  BBREG_0x030, 0x00005000,
	BBREG_0x030, 0x00006000,  0x90000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x030, 0x00000645,  BBREG_0x030, 0x00001333,
	BBREG_0x030, 0x00002011,  BBREG_0x030, 0x00004000,  BBREG_0x030,
	0x00005000,  BBREG_0x030, 0x00006000,  0xA0000000,  0x00000000,
	BBREG_0x030, 0x00000764,  BBREG_0x030, 0x00001632,  BBREG_0x030,
	0x00002421,  BBREG_0x030, 0x00004000,  BBREG_0x030, 0x00005000,
	BBREG_0x030, 0x00006000,  0xB0000000,  0x00000000,  BBREG_0x0ef,
	0x00000000,  BBREG_0x0ef, 0x00000800,  0x83000000,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x00000020,  BBREG_0x03f,
	0x00000C09,  BBREG_0x033, 0x00000021,  BBREG_0x03f, 0x00000C0C,
	BBREG_0x033, 0x00000022,  BBREG_0x03f, 0x00000C0F,  BBREG_0x033,
	0x00000023,  BBREG_0x03f, 0x00000C2C,  BBREG_0x033, 0x00000024,
	BBREG_0x03f, 0x00000C2F,  BBREG_0x033, 0x00000025,  BBREG_0x03f,
	0x00000C8A,  BBREG_0x033, 0x00000026,  BBREG_0x03f, 0x00000C8D,
	BBREG_0x033, 0x00000027,  BBREG_0x03f, 0x00000C90,  BBREG_0x033,
	0x00000028,  BBREG_0x03f, 0x00000CD0,  BBREG_0x033, 0x00000029,
	BBREG_0x03f, 0x00000CF2,  BBREG_0x033, 0x0000002A,  BBREG_0x03f,
	0x00000CF5,  0x93000001,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000020,  BBREG_0x03f, 0x00000007,  BBREG_0x033,
	0x00000021,  BBREG_0x03f, 0x0000000A,  BBREG_0x033, 0x00000022,
	BBREG_0x03f, 0x0000000D,  BBREG_0x033, 0x00000023,  BBREG_0x03f,
	0x0000002A,  BBREG_0x033, 0x00000024,  BBREG_0x03f, 0x0000002D,
	BBREG_0x033, 0x00000025,  BBREG_0x03f, 0x00000030,  BBREG_0x033,
	0x00000026,  BBREG_0x03f, 0x0000006D,  BBREG_0x033, 0x00000027,
	BBREG_0x03f, 0x00000070,  BBREG_0x033, 0x00000028,  BBREG_0x03f,
	0x000000ED,  BBREG_0x033, 0x00000029,  BBREG_0x03f, 0x000000F0,
	BBREG_0x033, 0x0000002A,  BBREG_0x03f, 0x000000F3,  0x93000002,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x00000020,
	BBREG_0x03f, 0x00000005,  BBREG_0x033, 0x00000021,  BBREG_0x03f,
	0x00000008,  BBREG_0x033, 0x00000022,  BBREG_0x03f, 0x0000000B,
	BBREG_0x033, 0x00000023,  BBREG_0x03f, 0x0000000E,  BBREG_0x033,
	0x00000024,  BBREG_0x03f, 0x0000002B,  BBREG_0x033, 0x00000025,
	BBREG_0x03f, 0x00000068,  BBREG_0x033, 0x00000026,  BBREG_0x03f,
	0x0000006B,  BBREG_0x033, 0x00000027,  BBREG_0x03f, 0x0000006E,
	BBREG_0x033, 0x00000028,  BBREG_0x03f, 0x00000071,  BBREG_0x033,
	0x00000029,  BBREG_0x03f, 0x00000074,  BBREG_0x033, 0x0000002A,
	BBREG_0x03f, 0x00000077,  0x93000003,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000020,  BBREG_0x03f, 0x00000429,
	BBREG_0x033, 0x00000021,  BBREG_0x03f, 0x00000828,  BBREG_0x033,
	0x00000022,  BBREG_0x03f, 0x00000847,  BBREG_0x033, 0x00000023,
	BBREG_0x03f, 0x0000084A,  BBREG_0x033, 0x00000024,  BBREG_0x03f,
	0x00000C4B,  BBREG_0x033, 0x00000025,  BBREG_0x03f, 0x00000C8A,
	BBREG_0x033, 0x00000026,  BBREG_0x03f, 0x00000CEA,  BBREG_0x033,
	0x00000027,  BBREG_0x03f, 0x00000CED,  BBREG_0x033, 0x00000028,
	BBREG_0x03f, 0x00000CF0,  BBREG_0x033, 0x00000029,  BBREG_0x03f,
	0x00000CF3,  BBREG_0x033, 0x0000002A,  BBREG_0x03f, 0x00000CF6,
	0x93000004,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x033,
	0x00000020,  BBREG_0x03f, 0x00000005,  BBREG_0x033, 0x00000021,
	BBREG_0x03f, 0x00000008,  BBREG_0x033, 0x00000022,  BBREG_0x03f,
	0x0000000B,  BBREG_0x033, 0x00000023,  BBREG_0x03f, 0x0000000E,
	BBREG_0x033, 0x00000024,  BBREG_0x03f, 0x0000002B,  BBREG_0x033,
	0x00000025,  BBREG_0x03f, 0x00000068,  BBREG_0x033, 0x00000026,
	BBREG_0x03f, 0x0000006B,  BBREG_0x033, 0x00000027,  BBREG_0x03f,
	0x0000006E,  BBREG_0x033, 0x00000028,  BBREG_0x03f, 0x00000071,
	BBREG_0x033, 0x00000029,  BBREG_0x03f, 0x00000074,  BBREG_0x033,
	0x0000002A,  BBREG_0x03f, 0x00000077,  0x93000005,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x00000020,  BBREG_0x03f,
	0x0000042C,  BBREG_0x033, 0x00000021,  BBREG_0x03f, 0x0000082B,
	BBREG_0x033, 0x00000022,  BBREG_0x03f, 0x0000084A,  BBREG_0x033,
	0x00000023,  BBREG_0x03f, 0x0000084D,  BBREG_0x033, 0x00000024,
	BBREG_0x03f, 0x00000C4E,  BBREG_0x033, 0x00000025,  BBREG_0x03f,
	0x00000C6E,  BBREG_0x033, 0x00000026,  BBREG_0x03f, 0x00000CAD,
	BBREG_0x033, 0x00000027,  BBREG_0x03f, 0x00000CED,  BBREG_0x033,
	0x00000028,  BBREG_0x03f, 0x00000CF0,  BBREG_0x033, 0x00000029,
	BBREG_0x03f, 0x00000CF3,  BBREG_0x033, 0x0000002A,  BBREG_0x03f,
	0x00000CF6,  0x93000006,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000020,  BBREG_0x03f, 0x00000007,  BBREG_0x033,
	0x00000021,  BBREG_0x03f, 0x0000000A,  BBREG_0x033, 0x00000022,
	BBREG_0x03f, 0x0000000D,  BBREG_0x033, 0x00000023,  BBREG_0x03f,
	0x0000002A,  BBREG_0x033, 0x00000024,  BBREG_0x03f, 0x0000002D,
	BBREG_0x033, 0x00000025,  BBREG_0x03f, 0x00000030,  BBREG_0x033,
	0x00000026,  BBREG_0x03f, 0x0000006D,  BBREG_0x033, 0x00000027,
	BBREG_0x03f, 0x00000070,  BBREG_0x033, 0x00000028,  BBREG_0x03f,
	0x000000ED,  BBREG_0x033, 0x00000029,  BBREG_0x03f, 0x000000F0,
	BBREG_0x033, 0x0000002A,  BBREG_0x03f, 0x000000F3,  0x93000007,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x00000020,
	BBREG_0x03f, 0x00000007,  BBREG_0x033, 0x00000021,  BBREG_0x03f,
	0x0000000A,  BBREG_0x033, 0x00000022,  BBREG_0x03f, 0x0000000D,
	BBREG_0x033, 0x00000023,  BBREG_0x03f, 0x0000002A,  BBREG_0x033,
	0x00000024,  BBREG_0x03f, 0x0000002D,  BBREG_0x033, 0x00000025,
	BBREG_0x03f, 0x00000030,  BBREG_0x033, 0x00000026,  BBREG_0x03f,
	0x0000006D,  BBREG_0x033, 0x00000027,  BBREG_0x03f, 0x00000070,
	BBREG_0x033, 0x00000028,  BBREG_0x03f, 0x000000ED,  BBREG_0x033,
	0x00000029,  BBREG_0x03f, 0x000000F0,  BBREG_0x033, 0x0000002A,
	BBREG_0x03f, 0x000000F3,  0x93000008,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000020,  BBREG_0x03f, 0x00000828,
	BBREG_0x033, 0x00000021,  BBREG_0x03f, 0x0000082B,  BBREG_0x033,
	0x00000022,  BBREG_0x03f, 0x00000868,  BBREG_0x033, 0x00000023,
	BBREG_0x03f, 0x00000889,  BBREG_0x033, 0x00000024,  BBREG_0x03f,
	0x000008AA,  BBREG_0x033, 0x00000025,  BBREG_0x03f, 0x00000CE8,
	BBREG_0x033, 0x00000026,  BBREG_0x03f, 0x00000CEB,  BBREG_0x033,
	0x00000027,  BBREG_0x03f, 0x00000CEE,  BBREG_0x033, 0x00000028,
	BBREG_0x03f, 0x00000CF1,  BBREG_0x033, 0x00000029,  BBREG_0x03f,
	0x00000CF4,  BBREG_0x033, 0x0000002A,  BBREG_0x03f, 0x00000CF7,
	0x93000009,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x033,
	0x00000020,  BBREG_0x03f, 0x00000C09,  BBREG_0x033, 0x00000021,
	BBREG_0x03f, 0x00000C0C,  BBREG_0x033, 0x00000022,  BBREG_0x03f,
	0x00000C0F,  BBREG_0x033, 0x00000023,  BBREG_0x03f, 0x00000C2C,
	BBREG_0x033, 0x00000024,  BBREG_0x03f, 0x00000C2F,  BBREG_0x033,
	0x00000025,  BBREG_0x03f, 0x00000C8A,  BBREG_0x033, 0x00000026,
	BBREG_0x03f, 0x00000C8D,  BBREG_0x033, 0x00000027,  BBREG_0x03f,
	0x00000C90,  BBREG_0x033, 0x00000028,  BBREG_0x03f, 0x00000CD0,
	BBREG_0x033, 0x00000029,  BBREG_0x03f, 0x00000CF2,  BBREG_0x033,
	0x0000002A,  BBREG_0x03f, 0x00000CF5,  0x9300000a,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x00000020,  BBREG_0x03f,
	0x00000C09,  BBREG_0x033, 0x00000021,  BBREG_0x03f, 0x00000C0C,
	BBREG_0x033, 0x00000022,  BBREG_0x03f, 0x00000C0F,  BBREG_0x033,
	0x00000023,  BBREG_0x03f, 0x00000C2C,  BBREG_0x033, 0x00000024,
	BBREG_0x03f, 0x00000C2F,  BBREG_0x033, 0x00000025,  BBREG_0x03f,
	0x00000C8A,  BBREG_0x033, 0x00000026,  BBREG_0x03f, 0x00000C8D,
	BBREG_0x033, 0x00000027,  BBREG_0x03f, 0x00000C90,  BBREG_0x033,
	0x00000028,  BBREG_0x03f, 0x00000CD0,  BBREG_0x033, 0x00000029,
	BBREG_0x03f, 0x00000CF2,  BBREG_0x033, 0x0000002A,  BBREG_0x03f,
	0x00000CF5,  0x9300000b,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000020,  BBREG_0x03f, 0x00000007,  BBREG_0x033,
	0x00000021,  BBREG_0x03f, 0x0000000A,  BBREG_0x033, 0x00000022,
	BBREG_0x03f, 0x0000000D,  BBREG_0x033, 0x00000023,  BBREG_0x03f,
	0x0000002A,  BBREG_0x033, 0x00000024,  BBREG_0x03f, 0x0000002D,
	BBREG_0x033, 0x00000025,  BBREG_0x03f, 0x00000030,  BBREG_0x033,
	0x00000026,  BBREG_0x03f, 0x0000006D,  BBREG_0x033, 0x00000027,
	BBREG_0x03f, 0x00000070,  BBREG_0x033, 0x00000028,  BBREG_0x03f,
	0x000000ED,  BBREG_0x033, 0x00000029,  BBREG_0x03f, 0x000000F0,
	BBREG_0x033, 0x0000002A,  BBREG_0x03f, 0x000000F3,  0x9300000c,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x00000020,
	BBREG_0x03f, 0x00000429,  BBREG_0x033, 0x00000021,  BBREG_0x03f,
	0x00000828,  BBREG_0x033, 0x00000022,  BBREG_0x03f, 0x00000847,
	BBREG_0x033, 0x00000023,  BBREG_0x03f, 0x0000084A,  BBREG_0x033,
	0x00000024,  BBREG_0x03f, 0x00000C4B,  BBREG_0x033, 0x00000025,
	BBREG_0x03f, 0x00000CE5,  BBREG_0x033, 0x00000026,  BBREG_0x03f,
	0x00000CE8,  BBREG_0x033, 0x00000027,  BBREG_0x03f, 0x00000CEB,
	BBREG_0x033, 0x00000028,  BBREG_0x03f, 0x00000CEE,  BBREG_0x033,
	0x00000029,  BBREG_0x03f, 0x00000CF1,  BBREG_0x033, 0x0000002A,
	BBREG_0x03f, 0x00000CF4,  0x9300000d,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000020,  BBREG_0x03f, 0x00000C25,
	BBREG_0x033, 0x00000021,  BBREG_0x03f, 0x00000C28,  BBREG_0x033,
	0x00000022,  BBREG_0x03f, 0x00000C2B,  BBREG_0x033, 0x00000023,
	BBREG_0x03f, 0x00000C68,  BBREG_0x033, 0x00000024,  BBREG_0x03f,
	0x00000C6B,  BBREG_0x033, 0x00000025,  BBREG_0x03f, 0x00000C6E,
	BBREG_0x033, 0x00000026,  BBREG_0x03f, 0x00000CEB,  BBREG_0x033,
	0x00000027,  BBREG_0x03f, 0x00000CEE,  BBREG_0x033, 0x00000028,
	BBREG_0x03f, 0x00000CF1,  BBREG_0x033, 0x00000029,  BBREG_0x03f,
	0x00000CF4,  BBREG_0x033, 0x0000002A,  BBREG_0x03f, 0x00000CF7,
	0x9300000e,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x033,
	0x00000020,  BBREG_0x03f, 0x00000C09,  BBREG_0x033, 0x00000021,
	BBREG_0x03f, 0x00000C0C,  BBREG_0x033, 0x00000022,  BBREG_0x03f,
	0x00000C0F,  BBREG_0x033, 0x00000023,  BBREG_0x03f, 0x00000C2C,
	BBREG_0x033, 0x00000024,  BBREG_0x03f, 0x00000C2F,  BBREG_0x033,
	0x00000025,  BBREG_0x03f, 0x00000C8A,  BBREG_0x033, 0x00000026,
	BBREG_0x03f, 0x00000C8D,  BBREG_0x033, 0x00000027,  BBREG_0x03f,
	0x00000C90,  BBREG_0x033, 0x00000028,  BBREG_0x03f, 0x00000CD0,
	BBREG_0x033, 0x00000029,  BBREG_0x03f, 0x00000CF2,  BBREG_0x033,
	0x0000002A,  BBREG_0x03f, 0x00000CF5,  0x9300000f,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x00000020,  BBREG_0x03f,
	0x00000429,  BBREG_0x033, 0x00000021,  BBREG_0x03f, 0x00000828,
	BBREG_0x033, 0x00000022,  BBREG_0x03f, 0x00000847,  BBREG_0x033,
	0x00000023,  BBREG_0x03f, 0x0000084A,  BBREG_0x033, 0x00000024,
	BBREG_0x03f, 0x00000C4B,  BBREG_0x033, 0x00000025,  BBREG_0x03f,
	0x00000C8A,  BBREG_0x033, 0x00000026,  BBREG_0x03f, 0x00000CEA,
	BBREG_0x033, 0x00000027,  BBREG_0x03f, 0x00000CED,  BBREG_0x033,
	0x00000028,  BBREG_0x03f, 0x00000CF0,  BBREG_0x033, 0x00000029,
	BBREG_0x03f, 0x00000CF3,  BBREG_0x033, 0x0000002A,  BBREG_0x03f,
	0x00000CF6,  0x93000010,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000020,  BBREG_0x03f, 0x00000429,  BBREG_0x033,
	0x00000021,  BBREG_0x03f, 0x00000828,  BBREG_0x033, 0x00000022,
	BBREG_0x03f, 0x00000847,  BBREG_0x033, 0x00000023,  BBREG_0x03f,
	0x0000084A,  BBREG_0x033, 0x00000024,  BBREG_0x03f, 0x00000C4B,
	BBREG_0x033, 0x00000025,  BBREG_0x03f, 0x00000C8A,  BBREG_0x033,
	0x00000026,  BBREG_0x03f, 0x00000CEA,  BBREG_0x033, 0x00000027,
	BBREG_0x03f, 0x00000CED,  BBREG_0x033, 0x00000028,  BBREG_0x03f,
	0x00000CF0,  BBREG_0x033, 0x00000029,  BBREG_0x03f, 0x00000CF3,
	BBREG_0x033, 0x0000002A,  BBREG_0x03f, 0x00000CF6,  0x90000001,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x00000020,
	BBREG_0x03f, 0x00000007,  BBREG_0x033, 0x00000021,  BBREG_0x03f,
	0x0000000A,  BBREG_0x033, 0x00000022,  BBREG_0x03f, 0x0000000D,
	BBREG_0x033, 0x00000023,  BBREG_0x03f, 0x0000002A,  BBREG_0x033,
	0x00000024,  BBREG_0x03f, 0x0000002D,  BBREG_0x033, 0x00000025,
	BBREG_0x03f, 0x00000030,  BBREG_0x033, 0x00000026,  BBREG_0x03f,
	0x0000006D,  BBREG_0x033, 0x00000027,  BBREG_0x03f, 0x00000070,
	BBREG_0x033, 0x00000028,  BBREG_0x03f, 0x000000ED,  BBREG_0x033,
	0x00000029,  BBREG_0x03f, 0x000000F0,  BBREG_0x033, 0x0000002A,
	BBREG_0x03f, 0x000000F3,  0x90000002,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000020,  BBREG_0x03f, 0x00000005,
	BBREG_0x033, 0x00000021,  BBREG_0x03f, 0x00000008,  BBREG_0x033,
	0x00000022,  BBREG_0x03f, 0x0000000B,  BBREG_0x033, 0x00000023,
	BBREG_0x03f, 0x0000000E,  BBREG_0x033, 0x00000024,  BBREG_0x03f,
	0x0000002B,  BBREG_0x033, 0x00000025,  BBREG_0x03f, 0x00000068,
	BBREG_0x033, 0x00000026,  BBREG_0x03f, 0x0000006B,  BBREG_0x033,
	0x00000027,  BBREG_0x03f, 0x0000006E,  BBREG_0x033, 0x00000028,
	BBREG_0x03f, 0x00000071,  BBREG_0x033, 0x00000029,  BBREG_0x03f,
	0x00000074,  BBREG_0x033, 0x0000002A,  BBREG_0x03f, 0x00000077,
	0x90000003,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x033,
	0x00000020,  BBREG_0x03f, 0x0000042B,  BBREG_0x033, 0x00000021,
	BBREG_0x03f, 0x0000082A,  BBREG_0x033, 0x00000022,  BBREG_0x03f,
	0x00000849,  BBREG_0x033, 0x00000023,  BBREG_0x03f, 0x0000084C,
	BBREG_0x033, 0x00000024,  BBREG_0x03f, 0x00000C4C,  BBREG_0x033,
	0x00000025,  BBREG_0x03f, 0x00000C8A,  BBREG_0x033, 0x00000026,
	BBREG_0x03f, 0x00000C8D,  BBREG_0x033, 0x00000027,  BBREG_0x03f,
	0x00000CEB,  BBREG_0x033, 0x00000028,  BBREG_0x03f, 0x00000CEE,
	BBREG_0x033, 0x00000029,  BBREG_0x03f, 0x00000CF1,  BBREG_0x033,
	0x0000002A,  BBREG_0x03f, 0x00000CF4,  0x90000004,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x00000020,  BBREG_0x03f,
	0x00000005,  BBREG_0x033, 0x00000021,  BBREG_0x03f, 0x00000008,
	BBREG_0x033, 0x00000022,  BBREG_0x03f, 0x0000000B,  BBREG_0x033,
	0x00000023,  BBREG_0x03f, 0x0000000E,  BBREG_0x033, 0x00000024,
	BBREG_0x03f, 0x0000002B,  BBREG_0x033, 0x00000025,  BBREG_0x03f,
	0x00000068,  BBREG_0x033, 0x00000026,  BBREG_0x03f, 0x0000006B,
	BBREG_0x033, 0x00000027,  BBREG_0x03f, 0x0000006E,  BBREG_0x033,
	0x00000028,  BBREG_0x03f, 0x00000071,  BBREG_0x033, 0x00000029,
	BBREG_0x03f, 0x00000074,  BBREG_0x033, 0x0000002A,  BBREG_0x03f,
	0x00000077,  0x90000005,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000020,  BBREG_0x03f, 0x0000042B,  BBREG_0x033,
	0x00000021,  BBREG_0x03f, 0x0000082A,  BBREG_0x033, 0x00000022,
	BBREG_0x03f, 0x00000849,  BBREG_0x033, 0x00000023,  BBREG_0x03f,
	0x0000084C,  BBREG_0x033, 0x00000024,  BBREG_0x03f, 0x00000C4C,
	BBREG_0x033, 0x00000025,  BBREG_0x03f, 0x00000C8A,  BBREG_0x033,
	0x00000026,  BBREG_0x03f, 0x00000C8D,  BBREG_0x033, 0x00000027,
	BBREG_0x03f, 0x00000CEB,  BBREG_0x033, 0x00000028,  BBREG_0x03f,
	0x00000CEE,  BBREG_0x033, 0x00000029,  BBREG_0x03f, 0x00000CF1,
	BBREG_0x033, 0x0000002A,  BBREG_0x03f, 0x00000CF4,  0x90000006,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x00000020,
	BBREG_0x03f, 0x00000007,  BBREG_0x033, 0x00000021,  BBREG_0x03f,
	0x0000000A,  BBREG_0x033, 0x00000022,  BBREG_0x03f, 0x0000000D,
	BBREG_0x033, 0x00000023,  BBREG_0x03f, 0x0000002A,  BBREG_0x033,
	0x00000024,  BBREG_0x03f, 0x0000002D,  BBREG_0x033, 0x00000025,
	BBREG_0x03f, 0x00000030,  BBREG_0x033, 0x00000026,  BBREG_0x03f,
	0x0000006D,  BBREG_0x033, 0x00000027,  BBREG_0x03f, 0x00000070,
	BBREG_0x033, 0x00000028,  BBREG_0x03f, 0x000000ED,  BBREG_0x033,
	0x00000029,  BBREG_0x03f, 0x000000F0,  BBREG_0x033, 0x0000002A,
	BBREG_0x03f, 0x000000F3,  0x90000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000020,  BBREG_0x03f, 0x00000007,
	BBREG_0x033, 0x00000021,  BBREG_0x03f, 0x0000000A,  BBREG_0x033,
	0x00000022,  BBREG_0x03f, 0x0000000D,  BBREG_0x033, 0x00000023,
	BBREG_0x03f, 0x0000002A,  BBREG_0x033, 0x00000024,  BBREG_0x03f,
	0x0000002D,  BBREG_0x033, 0x00000025,  BBREG_0x03f, 0x00000030,
	BBREG_0x033, 0x00000026,  BBREG_0x03f, 0x0000006D,  BBREG_0x033,
	0x00000027,  BBREG_0x03f, 0x00000070,  BBREG_0x033, 0x00000028,
	BBREG_0x03f, 0x000000ED,  BBREG_0x033, 0x00000029,  BBREG_0x03f,
	0x000000F0,  BBREG_0x033, 0x0000002A,  BBREG_0x03f, 0x000000F3,
	0xA0000000,  0x00000000,  BBREG_0x033, 0x00000020,  BBREG_0x03f,
	0x00000C09,  BBREG_0x033, 0x00000021,  BBREG_0x03f, 0x00000C0C,
	BBREG_0x033, 0x00000022,  BBREG_0x03f, 0x00000C0F,  BBREG_0x033,
	0x00000023,  BBREG_0x03f, 0x00000C2C,  BBREG_0x033, 0x00000024,
	BBREG_0x03f, 0x00000C2F,  BBREG_0x033, 0x00000025,  BBREG_0x03f,
	0x00000C8A,  BBREG_0x033, 0x00000026,  BBREG_0x03f, 0x00000C8D,
	BBREG_0x033, 0x00000027,  BBREG_0x03f, 0x00000C90,  BBREG_0x033,
	0x00000028,  BBREG_0x03f, 0x00000CD0,  BBREG_0x033, 0x00000029,
	BBREG_0x03f, 0x00000CF2,  BBREG_0x033, 0x0000002A,  BBREG_0x03f,
	0x00000CF5,  0xB0000000,  0x00000000,  0x83000000,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x00000060,  BBREG_0x03f,
	0x00000C0A,  BBREG_0x033, 0x00000061,  BBREG_0x03f, 0x00000C0D,
	BBREG_0x033, 0x00000062,  BBREG_0x03f, 0x00000C2A,  BBREG_0x033,
	0x00000063,  BBREG_0x03f, 0x00000C2D,  BBREG_0x033, 0x00000064,
	BBREG_0x03f, 0x00000C6A,  BBREG_0x033, 0x00000065,  BBREG_0x03f,
	0x00000CAA,  BBREG_0x033, 0x00000066,  BBREG_0x03f, 0x00000CAD,
	BBREG_0x033, 0x00000067,  BBREG_0x03f, 0x00000CB0,  BBREG_0x033,
	0x00000068,  BBREG_0x03f, 0x00000CF1,  BBREG_0x033, 0x00000069,
	BBREG_0x03f, 0x00000CF4,  BBREG_0x033, 0x0000006A,  BBREG_0x03f,
	0x00000CF7,  0x93000001,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000060,  BBREG_0x03f, 0x00000007,  BBREG_0x033,
	0x00000061,  BBREG_0x03f, 0x0000000A,  BBREG_0x033, 0x00000062,
	BBREG_0x03f, 0x0000000D,  BBREG_0x033, 0x00000063,  BBREG_0x03f,
	0x0000002A,  BBREG_0x033, 0x00000064,  BBREG_0x03f, 0x0000002D,
	BBREG_0x033, 0x00000065,  BBREG_0x03f, 0x00000030,  BBREG_0x033,
	0x00000066,  BBREG_0x03f, 0x0000006D,  BBREG_0x033, 0x00000067,
	BBREG_0x03f, 0x00000070,  BBREG_0x033, 0x00000068,  BBREG_0x03f,
	0x000000ED,  BBREG_0x033, 0x00000069,  BBREG_0x03f, 0x000000F0,
	BBREG_0x033, 0x0000006A,  BBREG_0x03f, 0x000000F3,  0x93000002,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x00000060,
	BBREG_0x03f, 0x00000005,  BBREG_0x033, 0x00000061,  BBREG_0x03f,
	0x00000008,  BBREG_0x033, 0x00000062,  BBREG_0x03f, 0x0000000B,
	BBREG_0x033, 0x00000063,  BBREG_0x03f, 0x0000000E,  BBREG_0x033,
	0x00000064,  BBREG_0x03f, 0x0000002B,  BBREG_0x033, 0x00000065,
	BBREG_0x03f, 0x00000068,  BBREG_0x033, 0x00000066,  BBREG_0x03f,
	0x0000006B,  BBREG_0x033, 0x00000067,  BBREG_0x03f, 0x0000006E,
	BBREG_0x033, 0x00000068,  BBREG_0x03f, 0x00000071,  BBREG_0x033,
	0x00000069,  BBREG_0x03f, 0x00000074,  BBREG_0x033, 0x0000006A,
	BBREG_0x03f, 0x00000077,  0x93000003,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000060,  BBREG_0x03f, 0x00000429,
	BBREG_0x033, 0x00000061,  BBREG_0x03f, 0x00000828,  BBREG_0x033,
	0x00000062,  BBREG_0x03f, 0x00000847,  BBREG_0x033, 0x00000063,
	BBREG_0x03f, 0x0000084A,  BBREG_0x033, 0x00000064,  BBREG_0x03f,
	0x00000C4B,  BBREG_0x033, 0x00000065,  BBREG_0x03f, 0x00000C8A,
	BBREG_0x033, 0x00000066,  BBREG_0x03f, 0x00000CEA,  BBREG_0x033,
	0x00000067,  BBREG_0x03f, 0x00000CED,  BBREG_0x033, 0x00000068,
	BBREG_0x03f, 0x00000CF0,  BBREG_0x033, 0x00000069,  BBREG_0x03f,
	0x00000CF3,  BBREG_0x033, 0x0000006A,  BBREG_0x03f, 0x00000CF6,
	0x93000004,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x033,
	0x00000060,  BBREG_0x03f, 0x00000005,  BBREG_0x033, 0x00000061,
	BBREG_0x03f, 0x00000008,  BBREG_0x033, 0x00000062,  BBREG_0x03f,
	0x0000000B,  BBREG_0x033, 0x00000063,  BBREG_0x03f, 0x0000000E,
	BBREG_0x033, 0x00000064,  BBREG_0x03f, 0x0000002B,  BBREG_0x033,
	0x00000065,  BBREG_0x03f, 0x00000068,  BBREG_0x033, 0x00000066,
	BBREG_0x03f, 0x0000006B,  BBREG_0x033, 0x00000067,  BBREG_0x03f,
	0x0000006E,  BBREG_0x033, 0x00000068,  BBREG_0x03f, 0x00000071,
	BBREG_0x033, 0x00000069,  BBREG_0x03f, 0x00000074,  BBREG_0x033,
	0x0000006A,  BBREG_0x03f, 0x00000077,  0x93000005,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x00000060,  BBREG_0x03f,
	0x0000042A,  BBREG_0x033, 0x00000061,  BBREG_0x03f, 0x00000829,
	BBREG_0x033, 0x00000062,  BBREG_0x03f, 0x00000848,  BBREG_0x033,
	0x00000063,  BBREG_0x03f, 0x0000084B,  BBREG_0x033, 0x00000064,
	BBREG_0x03f, 0x00000C4B,  BBREG_0x033, 0x00000065,  BBREG_0x03f,
	0x00000C6C,  BBREG_0x033, 0x00000066,  BBREG_0x03f, 0x00000CAC,
	BBREG_0x033, 0x00000067,  BBREG_0x03f, 0x00000CED,  BBREG_0x033,
	0x00000068,  BBREG_0x03f, 0x00000CF0,  BBREG_0x033, 0x00000069,
	BBREG_0x03f, 0x00000CF3,  BBREG_0x033, 0x0000006A,  BBREG_0x03f,
	0x00000CF6,  0x93000006,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000060,  BBREG_0x03f, 0x00000007,  BBREG_0x033,
	0x00000061,  BBREG_0x03f, 0x0000000A,  BBREG_0x033, 0x00000062,
	BBREG_0x03f, 0x0000000D,  BBREG_0x033, 0x00000063,  BBREG_0x03f,
	0x0000002A,  BBREG_0x033, 0x00000064,  BBREG_0x03f, 0x0000002D,
	BBREG_0x033, 0x00000065,  BBREG_0x03f, 0x00000030,  BBREG_0x033,
	0x00000066,  BBREG_0x03f, 0x0000006D,  BBREG_0x033, 0x00000067,
	BBREG_0x03f, 0x00000070,  BBREG_0x033, 0x00000068,  BBREG_0x03f,
	0x000000ED,  BBREG_0x033, 0x00000069,  BBREG_0x03f, 0x000000F0,
	BBREG_0x033, 0x0000006A,  BBREG_0x03f, 0x000000F3,  0x93000007,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x00000060,
	BBREG_0x03f, 0x00000007,  BBREG_0x033, 0x00000061,  BBREG_0x03f,
	0x0000000A,  BBREG_0x033, 0x00000062,  BBREG_0x03f, 0x0000000D,
	BBREG_0x033, 0x00000063,  BBREG_0x03f, 0x0000002A,  BBREG_0x033,
	0x00000064,  BBREG_0x03f, 0x0000002D,  BBREG_0x033, 0x00000065,
	BBREG_0x03f, 0x00000030,  BBREG_0x033, 0x00000066,  BBREG_0x03f,
	0x0000006D,  BBREG_0x033, 0x00000067,  BBREG_0x03f, 0x00000070,
	BBREG_0x033, 0x00000068,  BBREG_0x03f, 0x000000ED,  BBREG_0x033,
	0x00000069,  BBREG_0x03f, 0x000000F0,  BBREG_0x033, 0x0000006A,
	BBREG_0x03f, 0x000000F3,  0x93000008,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000060,  BBREG_0x03f, 0x00000842,
	BBREG_0x033, 0x00000061,  BBREG_0x03f, 0x00000845,  BBREG_0x033,
	0x00000062,  BBREG_0x03f, 0x00000866,  BBREG_0x033, 0x00000063,
	BBREG_0x03f, 0x000008A6,  BBREG_0x033, 0x00000064,  BBREG_0x03f,
	0x000008C8,  BBREG_0x033, 0x00000065,  BBREG_0x03f, 0x00000CE8,
	BBREG_0x033, 0x00000066,  BBREG_0x03f, 0x00000CEB,  BBREG_0x033,
	0x00000067,  BBREG_0x03f, 0x00000CEE,  BBREG_0x033, 0x00000068,
	BBREG_0x03f, 0x00000CF1,  BBREG_0x033, 0x00000069,  BBREG_0x03f,
	0x00000CF4,  BBREG_0x033, 0x0000006A,  BBREG_0x03f, 0x00000CF7,
	0x93000009,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x033,
	0x00000060,  BBREG_0x03f, 0x00000C0A,  BBREG_0x033, 0x00000061,
	BBREG_0x03f, 0x00000C0D,  BBREG_0x033, 0x00000062,  BBREG_0x03f,
	0x00000C2A,  BBREG_0x033, 0x00000063,  BBREG_0x03f, 0x00000C2D,
	BBREG_0x033, 0x00000064,  BBREG_0x03f, 0x00000C6A,  BBREG_0x033,
	0x00000065,  BBREG_0x03f, 0x00000CAA,  BBREG_0x033, 0x00000066,
	BBREG_0x03f, 0x00000CAD,  BBREG_0x033, 0x00000067,  BBREG_0x03f,
	0x00000CB0,  BBREG_0x033, 0x00000068,  BBREG_0x03f, 0x00000CF1,
	BBREG_0x033, 0x00000069,  BBREG_0x03f, 0x00000CF4,  BBREG_0x033,
	0x0000006A,  BBREG_0x03f, 0x00000CF7,  0x9300000a,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x00000060,  BBREG_0x03f,
	0x00000C0A,  BBREG_0x033, 0x00000061,  BBREG_0x03f, 0x00000C0D,
	BBREG_0x033, 0x00000062,  BBREG_0x03f, 0x00000C2A,  BBREG_0x033,
	0x00000063,  BBREG_0x03f, 0x00000C2D,  BBREG_0x033, 0x00000064,
	BBREG_0x03f, 0x00000C6A,  BBREG_0x033, 0x00000065,  BBREG_0x03f,
	0x00000CAA,  BBREG_0x033, 0x00000066,  BBREG_0x03f, 0x00000CAD,
	BBREG_0x033, 0x00000067,  BBREG_0x03f, 0x00000CB0,  BBREG_0x033,
	0x00000068,  BBREG_0x03f, 0x00000CF1,  BBREG_0x033, 0x00000069,
	BBREG_0x03f, 0x00000CF4,  BBREG_0x033, 0x0000006A,  BBREG_0x03f,
	0x00000CF7,  0x9300000b,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000060,  BBREG_0x03f, 0x00000005,  BBREG_0x033,
	0x00000061,  BBREG_0x03f, 0x00000008,  BBREG_0x033, 0x00000062,
	BBREG_0x03f, 0x0000000B,  BBREG_0x033, 0x00000063,  BBREG_0x03f,
	0x0000000E,  BBREG_0x033, 0x00000064,  BBREG_0x03f, 0x0000002B,
	BBREG_0x033, 0x00000065,  BBREG_0x03f, 0x00000068,  BBREG_0x033,
	0x00000066,  BBREG_0x03f, 0x0000006B,  BBREG_0x033, 0x00000067,
	BBREG_0x03f, 0x0000006E,  BBREG_0x033, 0x00000068,  BBREG_0x03f,
	0x00000071,  BBREG_0x033, 0x00000069,  BBREG_0x03f, 0x00000074,
	BBREG_0x033, 0x0000006A,  BBREG_0x03f, 0x00000077,  0x9300000c,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x00000060,
	BBREG_0x03f, 0x00000429,  BBREG_0x033, 0x00000061,  BBREG_0x03f,
	0x00000828,  BBREG_0x033, 0x00000062,  BBREG_0x03f, 0x00000847,
	BBREG_0x033, 0x00000063,  BBREG_0x03f, 0x0000084A,  BBREG_0x033,
	0x00000064,  BBREG_0x03f, 0x00000C4B,  BBREG_0x033, 0x00000065,
	BBREG_0x03f, 0x00000CE5,  BBREG_0x033, 0x00000066,  BBREG_0x03f,
	0x00000CE8,  BBREG_0x033, 0x00000067,  BBREG_0x03f, 0x00000CEB,
	BBREG_0x033, 0x00000068,  BBREG_0x03f, 0x00000CEE,  BBREG_0x033,
	0x00000069,  BBREG_0x03f, 0x00000CF1,  BBREG_0x033, 0x0000006A,
	BBREG_0x03f, 0x00000CF4,  0x9300000d,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000060,  BBREG_0x03f, 0x00000C0A,
	BBREG_0x033, 0x00000061,  BBREG_0x03f, 0x00000C0D,  BBREG_0x033,
	0x00000062,  BBREG_0x03f, 0x00000C10,  BBREG_0x033, 0x00000063,
	BBREG_0x03f, 0x00000C4A,  BBREG_0x033, 0x00000064,  BBREG_0x03f,
	0x00000C4D,  BBREG_0x033, 0x00000065,  BBREG_0x03f, 0x00000CC9,
	BBREG_0x033, 0x00000066,  BBREG_0x03f, 0x00000CEB,  BBREG_0x033,
	0x00000067,  BBREG_0x03f, 0x00000CEE,  BBREG_0x033, 0x00000068,
	BBREG_0x03f, 0x00000CF1,  BBREG_0x033, 0x00000069,  BBREG_0x03f,
	0x00000CF4,  BBREG_0x033, 0x0000006A,  BBREG_0x03f, 0x00000CF7,
	0x9300000e,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x033,
	0x00000060,  BBREG_0x03f, 0x00000C0A,  BBREG_0x033, 0x00000061,
	BBREG_0x03f, 0x00000C0D,  BBREG_0x033, 0x00000062,  BBREG_0x03f,
	0x00000C2A,  BBREG_0x033, 0x00000063,  BBREG_0x03f, 0x00000C2D,
	BBREG_0x033, 0x00000064,  BBREG_0x03f, 0x00000C6A,  BBREG_0x033,
	0x00000065,  BBREG_0x03f, 0x00000CAA,  BBREG_0x033, 0x00000066,
	BBREG_0x03f, 0x00000CAD,  BBREG_0x033, 0x00000067,  BBREG_0x03f,
	0x00000CB0,  BBREG_0x033, 0x00000068,  BBREG_0x03f, 0x00000CF1,
	BBREG_0x033, 0x00000069,  BBREG_0x03f, 0x00000CF4,  BBREG_0x033,
	0x0000006A,  BBREG_0x03f, 0x00000CF7,  0x9300000f,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x00000060,  BBREG_0x03f,
	0x00000429,  BBREG_0x033, 0x00000061,  BBREG_0x03f, 0x00000828,
	BBREG_0x033, 0x00000062,  BBREG_0x03f, 0x00000847,  BBREG_0x033,
	0x00000063,  BBREG_0x03f, 0x0000084A,  BBREG_0x033, 0x00000064,
	BBREG_0x03f, 0x00000C4B,  BBREG_0x033, 0x00000065,  BBREG_0x03f,
	0x00000C8A,  BBREG_0x033, 0x00000066,  BBREG_0x03f, 0x00000CEA,
	BBREG_0x033, 0x00000067,  BBREG_0x03f, 0x00000CED,  BBREG_0x033,
	0x00000068,  BBREG_0x03f, 0x00000CF0,  BBREG_0x033, 0x00000069,
	BBREG_0x03f, 0x00000CF3,  BBREG_0x033, 0x0000006A,  BBREG_0x03f,
	0x00000CF6,  0x93000010,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000060,  BBREG_0x03f, 0x00000429,  BBREG_0x033,
	0x00000061,  BBREG_0x03f, 0x00000828,  BBREG_0x033, 0x00000062,
	BBREG_0x03f, 0x00000847,  BBREG_0x033, 0x00000063,  BBREG_0x03f,
	0x0000084A,  BBREG_0x033, 0x00000064,  BBREG_0x03f, 0x00000C4B,
	BBREG_0x033, 0x00000065,  BBREG_0x03f, 0x00000C8A,  BBREG_0x033,
	0x00000066,  BBREG_0x03f, 0x00000CEA,  BBREG_0x033, 0x00000067,
	BBREG_0x03f, 0x00000CED,  BBREG_0x033, 0x00000068,  BBREG_0x03f,
	0x00000CF0,  BBREG_0x033, 0x00000069,  BBREG_0x03f, 0x00000CF3,
	BBREG_0x033, 0x0000006A,  BBREG_0x03f, 0x00000CF6,  0x90000001,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x00000060,
	BBREG_0x03f, 0x00000007,  BBREG_0x033, 0x00000061,  BBREG_0x03f,
	0x0000000A,  BBREG_0x033, 0x00000062,  BBREG_0x03f, 0x0000000D,
	BBREG_0x033, 0x00000063,  BBREG_0x03f, 0x0000002A,  BBREG_0x033,
	0x00000064,  BBREG_0x03f, 0x0000002D,  BBREG_0x033, 0x00000065,
	BBREG_0x03f, 0x00000030,  BBREG_0x033, 0x00000066,  BBREG_0x03f,
	0x0000006D,  BBREG_0x033, 0x00000067,  BBREG_0x03f, 0x00000070,
	BBREG_0x033, 0x00000068,  BBREG_0x03f, 0x000000ED,  BBREG_0x033,
	0x00000069,  BBREG_0x03f, 0x000000F0,  BBREG_0x033, 0x0000006A,
	BBREG_0x03f, 0x000000F3,  0x90000002,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000060,  BBREG_0x03f, 0x00000005,
	BBREG_0x033, 0x00000061,  BBREG_0x03f, 0x00000008,  BBREG_0x033,
	0x00000062,  BBREG_0x03f, 0x0000000B,  BBREG_0x033, 0x00000063,
	BBREG_0x03f, 0x0000000E,  BBREG_0x033, 0x00000064,  BBREG_0x03f,
	0x0000002B,  BBREG_0x033, 0x00000065,  BBREG_0x03f, 0x00000068,
	BBREG_0x033, 0x00000066,  BBREG_0x03f, 0x0000006B,  BBREG_0x033,
	0x00000067,  BBREG_0x03f, 0x0000006E,  BBREG_0x033, 0x00000068,
	BBREG_0x03f, 0x00000071,  BBREG_0x033, 0x00000069,  BBREG_0x03f,
	0x00000074,  BBREG_0x033, 0x0000006A,  BBREG_0x03f, 0x00000077,
	0x90000003,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x033,
	0x00000060,  BBREG_0x03f, 0x0000042C,  BBREG_0x033, 0x00000061,
	BBREG_0x03f, 0x0000082B,  BBREG_0x033, 0x00000062,  BBREG_0x03f,
	0x0000084A,  BBREG_0x033, 0x00000063,  BBREG_0x03f, 0x0000084D,
	BBREG_0x033, 0x00000064,  BBREG_0x03f, 0x00000C4E,  BBREG_0x033,
	0x00000065,  BBREG_0x03f, 0x00000C8C,  BBREG_0x033, 0x00000066,
	BBREG_0x03f, 0x00000C8F,  BBREG_0x033, 0x00000067,  BBREG_0x03f,
	0x00000CEC,  BBREG_0x033, 0x00000068,  BBREG_0x03f, 0x00000CEF,
	BBREG_0x033, 0x00000069,  BBREG_0x03f, 0x00000CF2,  BBREG_0x033,
	0x0000006A,  BBREG_0x03f, 0x00000CF5,  0x90000004,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x00000060,  BBREG_0x03f,
	0x00000005,  BBREG_0x033, 0x00000061,  BBREG_0x03f, 0x00000008,
	BBREG_0x033, 0x00000062,  BBREG_0x03f, 0x0000000B,  BBREG_0x033,
	0x00000063,  BBREG_0x03f, 0x0000000E,  BBREG_0x033, 0x00000064,
	BBREG_0x03f, 0x0000002B,  BBREG_0x033, 0x00000065,  BBREG_0x03f,
	0x00000068,  BBREG_0x033, 0x00000066,  BBREG_0x03f, 0x0000006B,
	BBREG_0x033, 0x00000067,  BBREG_0x03f, 0x0000006E,  BBREG_0x033,
	0x00000068,  BBREG_0x03f, 0x00000071,  BBREG_0x033, 0x00000069,
	BBREG_0x03f, 0x00000074,  BBREG_0x033, 0x0000006A,  BBREG_0x03f,
	0x00000077,  0x90000005,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000060,  BBREG_0x03f, 0x0000042C,  BBREG_0x033,
	0x00000061,  BBREG_0x03f, 0x0000082B,  BBREG_0x033, 0x00000062,
	BBREG_0x03f, 0x0000084A,  BBREG_0x033, 0x00000063,  BBREG_0x03f,
	0x0000084D,  BBREG_0x033, 0x00000064,  BBREG_0x03f, 0x00000C4E,
	BBREG_0x033, 0x00000065,  BBREG_0x03f, 0x00000C8C,  BBREG_0x033,
	0x00000066,  BBREG_0x03f, 0x00000C8F,  BBREG_0x033, 0x00000067,
	BBREG_0x03f, 0x00000CEC,  BBREG_0x033, 0x00000068,  BBREG_0x03f,
	0x00000CEF,  BBREG_0x033, 0x00000069,  BBREG_0x03f, 0x00000CF2,
	BBREG_0x033, 0x0000006A,  BBREG_0x03f, 0x00000CF5,  0x90000006,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x00000060,
	BBREG_0x03f, 0x00000007,  BBREG_0x033, 0x00000061,  BBREG_0x03f,
	0x0000000A,  BBREG_0x033, 0x00000062,  BBREG_0x03f, 0x0000000D,
	BBREG_0x033, 0x00000063,  BBREG_0x03f, 0x0000002A,  BBREG_0x033,
	0x00000064,  BBREG_0x03f, 0x0000002D,  BBREG_0x033, 0x00000065,
	BBREG_0x03f, 0x00000030,  BBREG_0x033, 0x00000066,  BBREG_0x03f,
	0x0000006D,  BBREG_0x033, 0x00000067,  BBREG_0x03f, 0x00000070,
	BBREG_0x033, 0x00000068,  BBREG_0x03f, 0x000000ED,  BBREG_0x033,
	0x00000069,  BBREG_0x03f, 0x000000F0,  BBREG_0x033, 0x0000006A,
	BBREG_0x03f, 0x000000F3,  0x90000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000060,  BBREG_0x03f, 0x00000007,
	BBREG_0x033, 0x00000061,  BBREG_0x03f, 0x0000000A,  BBREG_0x033,
	0x00000062,  BBREG_0x03f, 0x0000000D,  BBREG_0x033, 0x00000063,
	BBREG_0x03f, 0x0000002A,  BBREG_0x033, 0x00000064,  BBREG_0x03f,
	0x0000002D,  BBREG_0x033, 0x00000065,  BBREG_0x03f, 0x00000030,
	BBREG_0x033, 0x00000066,  BBREG_0x03f, 0x0000006D,  BBREG_0x033,
	0x00000067,  BBREG_0x03f, 0x00000070,  BBREG_0x033, 0x00000068,
	BBREG_0x03f, 0x000000ED,  BBREG_0x033, 0x00000069,  BBREG_0x03f,
	0x000000F0,  BBREG_0x033, 0x0000006A,  BBREG_0x03f, 0x000000F3,
	0xA0000000,  0x00000000,  BBREG_0x033, 0x00000060,  BBREG_0x03f,
	0x00000C0A,  BBREG_0x033, 0x00000061,  BBREG_0x03f, 0x00000C0D,
	BBREG_0x033, 0x00000062,  BBREG_0x03f, 0x00000C2A,  BBREG_0x033,
	0x00000063,  BBREG_0x03f, 0x00000C2D,  BBREG_0x033, 0x00000064,
	BBREG_0x03f, 0x00000C6A,  BBREG_0x033, 0x00000065,  BBREG_0x03f,
	0x00000CAA,  BBREG_0x033, 0x00000066,  BBREG_0x03f, 0x00000CAD,
	BBREG_0x033, 0x00000067,  BBREG_0x03f, 0x00000CB0,  BBREG_0x033,
	0x00000068,  BBREG_0x03f, 0x00000CF1,  BBREG_0x033, 0x00000069,
	BBREG_0x03f, 0x00000CF4,  BBREG_0x033, 0x0000006A,  BBREG_0x03f,
	0x00000CF7,  0xB0000000,  0x00000000,  0x83000000,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x000000A0,  BBREG_0x03f,
	0x00000C09,  BBREG_0x033, 0x000000A1,  BBREG_0x03f, 0x00000C0C,
	BBREG_0x033, 0x000000A2,  BBREG_0x03f, 0x00000C0F,  BBREG_0x033,
	0x000000A3,  BBREG_0x03f, 0x00000C2C,  BBREG_0x033, 0x000000A4,
	BBREG_0x03f, 0x00000C2F,  BBREG_0x033, 0x000000A5,  BBREG_0x03f,
	0x00000C8A,  BBREG_0x033, 0x000000A6,  BBREG_0x03f, 0x00000C8D,
	BBREG_0x033, 0x000000A7,  BBREG_0x03f, 0x00000C90,  BBREG_0x033,
	0x000000A8,  BBREG_0x03f, 0x00000CEF,  BBREG_0x033, 0x000000A9,
	BBREG_0x03f, 0x00000CF2,  BBREG_0x033, 0x000000AA,  BBREG_0x03f,
	0x00000CF5,  0x93000001,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x000000A0,  BBREG_0x03f, 0x00000007,  BBREG_0x033,
	0x000000A1,  BBREG_0x03f, 0x0000000A,  BBREG_0x033, 0x000000A2,
	BBREG_0x03f, 0x0000000D,  BBREG_0x033, 0x000000A3,  BBREG_0x03f,
	0x0000002A,  BBREG_0x033, 0x000000A4,  BBREG_0x03f, 0x0000002D,
	BBREG_0x033, 0x000000A5,  BBREG_0x03f, 0x00000030,  BBREG_0x033,
	0x000000A6,  BBREG_0x03f, 0x0000006D,  BBREG_0x033, 0x000000A7,
	BBREG_0x03f, 0x00000070,  BBREG_0x033, 0x000000A8,  BBREG_0x03f,
	0x000000ED,  BBREG_0x033, 0x000000A9,  BBREG_0x03f, 0x000000F0,
	BBREG_0x033, 0x000000AA,  BBREG_0x03f, 0x000000F3,  0x93000002,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x000000A0,
	BBREG_0x03f, 0x00000005,  BBREG_0x033, 0x000000A1,  BBREG_0x03f,
	0x00000008,  BBREG_0x033, 0x000000A2,  BBREG_0x03f, 0x0000000B,
	BBREG_0x033, 0x000000A3,  BBREG_0x03f, 0x0000000E,  BBREG_0x033,
	0x000000A4,  BBREG_0x03f, 0x00000047,  BBREG_0x033, 0x000000A5,
	BBREG_0x03f, 0x0000004A,  BBREG_0x033, 0x000000A6,  BBREG_0x03f,
	0x0000004D,  BBREG_0x033, 0x000000A7,  BBREG_0x03f, 0x00000050,
	BBREG_0x033, 0x000000A8,  BBREG_0x03f, 0x00000053,  BBREG_0x033,
	0x000000A9,  BBREG_0x03f, 0x00000056,  BBREG_0x033, 0x000000AA,
	BBREG_0x03f, 0x00000094,  0x93000003,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x000000A0,  BBREG_0x03f, 0x00000429,
	BBREG_0x033, 0x000000A1,  BBREG_0x03f, 0x00000828,  BBREG_0x033,
	0x000000A2,  BBREG_0x03f, 0x00000847,  BBREG_0x033, 0x000000A3,
	BBREG_0x03f, 0x0000084A,  BBREG_0x033, 0x000000A4,  BBREG_0x03f,
	0x00000C4B,  BBREG_0x033, 0x000000A5,  BBREG_0x03f, 0x00000C8A,
	BBREG_0x033, 0x000000A6,  BBREG_0x03f, 0x00000CEA,  BBREG_0x033,
	0x000000A7,  BBREG_0x03f, 0x00000CED,  BBREG_0x033, 0x000000A8,
	BBREG_0x03f, 0x00000CF0,  BBREG_0x033, 0x000000A9,  BBREG_0x03f,
	0x00000CF3,  BBREG_0x033, 0x000000AA,  BBREG_0x03f, 0x00000CF6,
	0x93000004,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x033,
	0x000000A0,  BBREG_0x03f, 0x00000005,  BBREG_0x033, 0x000000A1,
	BBREG_0x03f, 0x00000008,  BBREG_0x033, 0x000000A2,  BBREG_0x03f,
	0x0000000B,  BBREG_0x033, 0x000000A3,  BBREG_0x03f, 0x0000000E,
	BBREG_0x033, 0x000000A4,  BBREG_0x03f, 0x00000047,  BBREG_0x033,
	0x000000A5,  BBREG_0x03f, 0x0000004A,  BBREG_0x033, 0x000000A6,
	BBREG_0x03f, 0x0000004D,  BBREG_0x033, 0x000000A7,  BBREG_0x03f,
	0x00000050,  BBREG_0x033, 0x000000A8,  BBREG_0x03f, 0x00000053,
	BBREG_0x033, 0x000000A9,  BBREG_0x03f, 0x00000056,  BBREG_0x033,
	0x000000AA,  BBREG_0x03f, 0x00000094,  0x93000005,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x000000A0,  BBREG_0x03f,
	0x0000042A,  BBREG_0x033, 0x000000A1,  BBREG_0x03f, 0x00000829,
	BBREG_0x033, 0x000000A2,  BBREG_0x03f, 0x00000848,  BBREG_0x033,
	0x000000A3,  BBREG_0x03f, 0x0000084B,  BBREG_0x033, 0x000000A4,
	BBREG_0x03f, 0x00000C4C,  BBREG_0x033, 0x000000A5,  BBREG_0x03f,
	0x00000C6C,  BBREG_0x033, 0x000000A6,  BBREG_0x03f, 0x00000CAC,
	BBREG_0x033, 0x000000A7,  BBREG_0x03f, 0x00000CED,  BBREG_0x033,
	0x000000A8,  BBREG_0x03f, 0x00000CF0,  BBREG_0x033, 0x000000A9,
	BBREG_0x03f, 0x00000CF3,  BBREG_0x033, 0x000000AA,  BBREG_0x03f,
	0x00000CF6,  0x93000006,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x000000A0,  BBREG_0x03f, 0x00000007,  BBREG_0x033,
	0x000000A1,  BBREG_0x03f, 0x0000000A,  BBREG_0x033, 0x000000A2,
	BBREG_0x03f, 0x0000000D,  BBREG_0x033, 0x000000A3,  BBREG_0x03f,
	0x0000002A,  BBREG_0x033, 0x000000A4,  BBREG_0x03f, 0x0000002D,
	BBREG_0x033, 0x000000A5,  BBREG_0x03f, 0x00000030,  BBREG_0x033,
	0x000000A6,  BBREG_0x03f, 0x0000006D,  BBREG_0x033, 0x000000A7,
	BBREG_0x03f, 0x00000070,  BBREG_0x033, 0x000000A8,  BBREG_0x03f,
	0x000000ED,  BBREG_0x033, 0x000000A9,  BBREG_0x03f, 0x000000F0,
	BBREG_0x033, 0x000000AA,  BBREG_0x03f, 0x000000F3,  0x93000007,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x000000A0,
	BBREG_0x03f, 0x00000007,  BBREG_0x033, 0x000000A1,  BBREG_0x03f,
	0x0000000A,  BBREG_0x033, 0x000000A2,  BBREG_0x03f, 0x0000000D,
	BBREG_0x033, 0x000000A3,  BBREG_0x03f, 0x0000002A,  BBREG_0x033,
	0x000000A4,  BBREG_0x03f, 0x0000002D,  BBREG_0x033, 0x000000A5,
	BBREG_0x03f, 0x00000030,  BBREG_0x033, 0x000000A6,  BBREG_0x03f,
	0x0000006D,  BBREG_0x033, 0x000000A7,  BBREG_0x03f, 0x00000070,
	BBREG_0x033, 0x000000A8,  BBREG_0x03f, 0x000000ED,  BBREG_0x033,
	0x000000A9,  BBREG_0x03f, 0x000000F0,  BBREG_0x033, 0x000000AA,
	BBREG_0x03f, 0x000000F3,  0x93000008,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x000000A0,  BBREG_0x03f, 0x00000826,
	BBREG_0x033, 0x000000A1,  BBREG_0x03f, 0x00000829,  BBREG_0x033,
	0x000000A2,  BBREG_0x03f, 0x0000082C,  BBREG_0x033, 0x000000A3,
	BBREG_0x03f, 0x0000082F,  BBREG_0x033, 0x000000A4,  BBREG_0x03f,
	0x0000086C,  BBREG_0x033, 0x000000A5,  BBREG_0x03f, 0x00000CE8,
	BBREG_0x033, 0x000000A6,  BBREG_0x03f, 0x00000CEB,  BBREG_0x033,
	0x000000A7,  BBREG_0x03f, 0x00000CEE,  BBREG_0x033, 0x000000A8,
	BBREG_0x03f, 0x00000CF1,  BBREG_0x033, 0x000000A9,  BBREG_0x03f,
	0x00000CF4,  BBREG_0x033, 0x000000AA,  BBREG_0x03f, 0x00000CF7,
	0x93000009,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x033,
	0x000000A0,  BBREG_0x03f, 0x00000C09,  BBREG_0x033, 0x000000A1,
	BBREG_0x03f, 0x00000C0C,  BBREG_0x033, 0x000000A2,  BBREG_0x03f,
	0x00000C0F,  BBREG_0x033, 0x000000A3,  BBREG_0x03f, 0x00000C2C,
	BBREG_0x033, 0x000000A4,  BBREG_0x03f, 0x00000C2F,  BBREG_0x033,
	0x000000A5,  BBREG_0x03f, 0x00000C8A,  BBREG_0x033, 0x000000A6,
	BBREG_0x03f, 0x00000C8D,  BBREG_0x033, 0x000000A7,  BBREG_0x03f,
	0x00000C90,  BBREG_0x033, 0x000000A8,  BBREG_0x03f, 0x00000CEF,
	BBREG_0x033, 0x000000A9,  BBREG_0x03f, 0x00000CF2,  BBREG_0x033,
	0x000000AA,  BBREG_0x03f, 0x00000CF5,  0x9300000a,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x000000A0,  BBREG_0x03f,
	0x00000C09,  BBREG_0x033, 0x000000A1,  BBREG_0x03f, 0x00000C0C,
	BBREG_0x033, 0x000000A2,  BBREG_0x03f, 0x00000C0F,  BBREG_0x033,
	0x000000A3,  BBREG_0x03f, 0x00000C2C,  BBREG_0x033, 0x000000A4,
	BBREG_0x03f, 0x00000C2F,  BBREG_0x033, 0x000000A5,  BBREG_0x03f,
	0x00000C8A,  BBREG_0x033, 0x000000A6,  BBREG_0x03f, 0x00000C8D,
	BBREG_0x033, 0x000000A7,  BBREG_0x03f, 0x00000C90,  BBREG_0x033,
	0x000000A8,  BBREG_0x03f, 0x00000CEF,  BBREG_0x033, 0x000000A9,
	BBREG_0x03f, 0x00000CF2,  BBREG_0x033, 0x000000AA,  BBREG_0x03f,
	0x00000CF5,  0x9300000b,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x000000A0,  BBREG_0x03f, 0x00000007,  BBREG_0x033,
	0x000000A1,  BBREG_0x03f, 0x0000000A,  BBREG_0x033, 0x000000A2,
	BBREG_0x03f, 0x0000000D,  BBREG_0x033, 0x000000A3,  BBREG_0x03f,
	0x0000002A,  BBREG_0x033, 0x000000A4,  BBREG_0x03f, 0x0000002D,
	BBREG_0x033, 0x000000A5,  BBREG_0x03f, 0x00000030,  BBREG_0x033,
	0x000000A6,  BBREG_0x03f, 0x0000006D,  BBREG_0x033, 0x000000A7,
	BBREG_0x03f, 0x00000070,  BBREG_0x033, 0x000000A8,  BBREG_0x03f,
	0x000000ED,  BBREG_0x033, 0x000000A9,  BBREG_0x03f, 0x000000F0,
	BBREG_0x033, 0x000000AA,  BBREG_0x03f, 0x000000F3,  0x9300000c,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x000000A0,
	BBREG_0x03f, 0x00000429,  BBREG_0x033, 0x000000A1,  BBREG_0x03f,
	0x00000828,  BBREG_0x033, 0x000000A2,  BBREG_0x03f, 0x00000847,
	BBREG_0x033, 0x000000A3,  BBREG_0x03f, 0x0000084A,  BBREG_0x033,
	0x000000A4,  BBREG_0x03f, 0x00000C4B,  BBREG_0x033, 0x000000A5,
	BBREG_0x03f, 0x00000CE5,  BBREG_0x033, 0x000000A6,  BBREG_0x03f,
	0x00000CE8,  BBREG_0x033, 0x000000A7,  BBREG_0x03f, 0x00000CEB,
	BBREG_0x033, 0x000000A8,  BBREG_0x03f, 0x00000CEE,  BBREG_0x033,
	0x000000A9,  BBREG_0x03f, 0x00000CF1,  BBREG_0x033, 0x000000AA,
	BBREG_0x03f, 0x00000CF4,  0x9300000d,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x000000A0,  BBREG_0x03f, 0x0000080A,
	BBREG_0x033, 0x000000A1,  BBREG_0x03f, 0x0000080D,  BBREG_0x033,
	0x000000A2,  BBREG_0x03f, 0x00000810,  BBREG_0x033, 0x000000A3,
	BBREG_0x03f, 0x00000868,  BBREG_0x033, 0x000000A4,  BBREG_0x03f,
	0x00000C68,  BBREG_0x033, 0x000000A5,  BBREG_0x03f, 0x00000C6B,
	BBREG_0x033, 0x000000A6,  BBREG_0x03f, 0x00000CAB,  BBREG_0x033,
	0x000000A7,  BBREG_0x03f, 0x00000CAE,  BBREG_0x033, 0x000000A8,
	BBREG_0x03f, 0x00000CEF,  BBREG_0x033, 0x000000A9,  BBREG_0x03f,
	0x00000CF2,  BBREG_0x033, 0x000000AA,  BBREG_0x03f, 0x00000CF5,
	0x9300000e,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x033,
	0x000000A0,  BBREG_0x03f, 0x00000C08,  BBREG_0x033, 0x000000A1,
	BBREG_0x03f, 0x00000C0B,  BBREG_0x033, 0x000000A2,  BBREG_0x03f,
	0x00000C0E,  BBREG_0x033, 0x000000A3,  BBREG_0x03f, 0x00000C2B,
	BBREG_0x033, 0x000000A4,  BBREG_0x03f, 0x00000C2E,  BBREG_0x033,
	0x000000A5,  BBREG_0x03f, 0x00000C31,  BBREG_0x033, 0x000000A6,
	BBREG_0x03f, 0x00000CAB,  BBREG_0x033, 0x000000A7,  BBREG_0x03f,
	0x00000CAE,  BBREG_0x033, 0x000000A8,  BBREG_0x03f, 0x00000CEF,
	BBREG_0x033, 0x000000A9,  BBREG_0x03f, 0x00000CF2,  BBREG_0x033,
	0x000000AA,  BBREG_0x03f, 0x00000CF5,  0x9300000f,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x000000A0,  BBREG_0x03f,
	0x00000429,  BBREG_0x033, 0x000000A1,  BBREG_0x03f, 0x00000828,
	BBREG_0x033, 0x000000A2,  BBREG_0x03f, 0x00000847,  BBREG_0x033,
	0x000000A3,  BBREG_0x03f, 0x0000084A,  BBREG_0x033, 0x000000A4,
	BBREG_0x03f, 0x00000C4B,  BBREG_0x033, 0x000000A5,  BBREG_0x03f,
	0x00000C8A,  BBREG_0x033, 0x000000A6,  BBREG_0x03f, 0x00000CEA,
	BBREG_0x033, 0x000000A7,  BBREG_0x03f, 0x00000CED,  BBREG_0x033,
	0x000000A8,  BBREG_0x03f, 0x00000CF0,  BBREG_0x033, 0x000000A9,
	BBREG_0x03f, 0x00000CF3,  BBREG_0x033, 0x000000AA,  BBREG_0x03f,
	0x00000CF6,  0x93000010,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x000000A0,  BBREG_0x03f, 0x00000429,  BBREG_0x033,
	0x000000A1,  BBREG_0x03f, 0x00000828,  BBREG_0x033, 0x000000A2,
	BBREG_0x03f, 0x00000847,  BBREG_0x033, 0x000000A3,  BBREG_0x03f,
	0x0000084A,  BBREG_0x033, 0x000000A4,  BBREG_0x03f, 0x00000C4B,
	BBREG_0x033, 0x000000A5,  BBREG_0x03f, 0x00000C8A,  BBREG_0x033,
	0x000000A6,  BBREG_0x03f, 0x00000CEA,  BBREG_0x033, 0x000000A7,
	BBREG_0x03f, 0x00000CED,  BBREG_0x033, 0x000000A8,  BBREG_0x03f,
	0x00000CF0,  BBREG_0x033, 0x000000A9,  BBREG_0x03f, 0x00000CF3,
	BBREG_0x033, 0x000000AA,  BBREG_0x03f, 0x00000CF6,  0x90000001,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x000000A0,
	BBREG_0x03f, 0x00000007,  BBREG_0x033, 0x000000A1,  BBREG_0x03f,
	0x0000000A,  BBREG_0x033, 0x000000A2,  BBREG_0x03f, 0x0000000D,
	BBREG_0x033, 0x000000A3,  BBREG_0x03f, 0x0000002A,  BBREG_0x033,
	0x000000A4,  BBREG_0x03f, 0x0000002D,  BBREG_0x033, 0x000000A5,
	BBREG_0x03f, 0x00000030,  BBREG_0x033, 0x000000A6,  BBREG_0x03f,
	0x0000006D,  BBREG_0x033, 0x000000A7,  BBREG_0x03f, 0x00000070,
	BBREG_0x033, 0x000000A8,  BBREG_0x03f, 0x000000ED,  BBREG_0x033,
	0x000000A9,  BBREG_0x03f, 0x000000F0,  BBREG_0x033, 0x000000AA,
	BBREG_0x03f, 0x000000F3,  0x90000002,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x000000A0,  BBREG_0x03f, 0x00000005,
	BBREG_0x033, 0x000000A1,  BBREG_0x03f, 0x00000008,  BBREG_0x033,
	0x000000A2,  BBREG_0x03f, 0x0000000B,  BBREG_0x033, 0x000000A3,
	BBREG_0x03f, 0x0000000E,  BBREG_0x033, 0x000000A4,  BBREG_0x03f,
	0x00000047,  BBREG_0x033, 0x000000A5,  BBREG_0x03f, 0x0000004A,
	BBREG_0x033, 0x000000A6,  BBREG_0x03f, 0x0000004D,  BBREG_0x033,
	0x000000A7,  BBREG_0x03f, 0x00000050,  BBREG_0x033, 0x000000A8,
	BBREG_0x03f, 0x00000053,  BBREG_0x033, 0x000000A9,  BBREG_0x03f,
	0x00000056,  BBREG_0x033, 0x000000AA,  BBREG_0x03f, 0x00000094,
	0x90000003,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x033,
	0x000000A0,  BBREG_0x03f, 0x0000042A,  BBREG_0x033, 0x000000A1,
	BBREG_0x03f, 0x00000829,  BBREG_0x033, 0x000000A2,  BBREG_0x03f,
	0x00000848,  BBREG_0x033, 0x000000A3,  BBREG_0x03f, 0x0000084B,
	BBREG_0x033, 0x000000A4,  BBREG_0x03f, 0x00000C4C,  BBREG_0x033,
	0x000000A5,  BBREG_0x03f, 0x00000C8A,  BBREG_0x033, 0x000000A6,
	BBREG_0x03f, 0x00000C8D,  BBREG_0x033, 0x000000A7,  BBREG_0x03f,
	0x00000CEC,  BBREG_0x033, 0x000000A8,  BBREG_0x03f, 0x00000CEF,
	BBREG_0x033, 0x000000A9,  BBREG_0x03f, 0x00000CF2,  BBREG_0x033,
	0x000000AA,  BBREG_0x03f, 0x00000CF5,  0x90000004,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x000000A0,  BBREG_0x03f,
	0x00000005,  BBREG_0x033, 0x000000A1,  BBREG_0x03f, 0x00000008,
	BBREG_0x033, 0x000000A2,  BBREG_0x03f, 0x0000000B,  BBREG_0x033,
	0x000000A3,  BBREG_0x03f, 0x0000000E,  BBREG_0x033, 0x000000A4,
	BBREG_0x03f, 0x00000047,  BBREG_0x033, 0x000000A5,  BBREG_0x03f,
	0x0000004A,  BBREG_0x033, 0x000000A6,  BBREG_0x03f, 0x0000004D,
	BBREG_0x033, 0x000000A7,  BBREG_0x03f, 0x00000050,  BBREG_0x033,
	0x000000A8,  BBREG_0x03f, 0x00000053,  BBREG_0x033, 0x000000A9,
	BBREG_0x03f, 0x00000056,  BBREG_0x033, 0x000000AA,  BBREG_0x03f,
	0x00000094,  0x90000005,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x000000A0,  BBREG_0x03f, 0x0000042A,  BBREG_0x033,
	0x000000A1,  BBREG_0x03f, 0x00000829,  BBREG_0x033, 0x000000A2,
	BBREG_0x03f, 0x00000848,  BBREG_0x033, 0x000000A3,  BBREG_0x03f,
	0x0000084B,  BBREG_0x033, 0x000000A4,  BBREG_0x03f, 0x00000C4C,
	BBREG_0x033, 0x000000A5,  BBREG_0x03f, 0x00000C8A,  BBREG_0x033,
	0x000000A6,  BBREG_0x03f, 0x00000C8D,  BBREG_0x033, 0x000000A7,
	BBREG_0x03f, 0x00000CEC,  BBREG_0x033, 0x000000A8,  BBREG_0x03f,
	0x00000CEF,  BBREG_0x033, 0x000000A9,  BBREG_0x03f, 0x00000CF2,
	BBREG_0x033, 0x000000AA,  BBREG_0x03f, 0x00000CF5,  0x90000006,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x000000A0,
	BBREG_0x03f, 0x00000007,  BBREG_0x033, 0x000000A1,  BBREG_0x03f,
	0x0000000A,  BBREG_0x033, 0x000000A2,  BBREG_0x03f, 0x0000000D,
	BBREG_0x033, 0x000000A3,  BBREG_0x03f, 0x0000002A,  BBREG_0x033,
	0x000000A4,  BBREG_0x03f, 0x0000002D,  BBREG_0x033, 0x000000A5,
	BBREG_0x03f, 0x00000030,  BBREG_0x033, 0x000000A6,  BBREG_0x03f,
	0x0000006D,  BBREG_0x033, 0x000000A7,  BBREG_0x03f, 0x00000070,
	BBREG_0x033, 0x000000A8,  BBREG_0x03f, 0x000000ED,  BBREG_0x033,
	0x000000A9,  BBREG_0x03f, 0x000000F0,  BBREG_0x033, 0x000000AA,
	BBREG_0x03f, 0x000000F3,  0x90000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x000000A0,  BBREG_0x03f, 0x00000007,
	BBREG_0x033, 0x000000A1,  BBREG_0x03f, 0x0000000A,  BBREG_0x033,
	0x000000A2,  BBREG_0x03f, 0x0000000D,  BBREG_0x033, 0x000000A3,
	BBREG_0x03f, 0x0000002A,  BBREG_0x033, 0x000000A4,  BBREG_0x03f,
	0x0000002D,  BBREG_0x033, 0x000000A5,  BBREG_0x03f, 0x00000030,
	BBREG_0x033, 0x000000A6,  BBREG_0x03f, 0x0000006D,  BBREG_0x033,
	0x000000A7,  BBREG_0x03f, 0x00000070,  BBREG_0x033, 0x000000A8,
	BBREG_0x03f, 0x000000ED,  BBREG_0x033, 0x000000A9,  BBREG_0x03f,
	0x000000F0,  BBREG_0x033, 0x000000AA,  BBREG_0x03f, 0x000000F3,
	0xA0000000,  0x00000000,  BBREG_0x033, 0x000000A0,  BBREG_0x03f,
	0x00000C09,  BBREG_0x033, 0x000000A1,  BBREG_0x03f, 0x00000C0C,
	BBREG_0x033, 0x000000A2,  BBREG_0x03f, 0x00000C0F,  BBREG_0x033,
	0x000000A3,  BBREG_0x03f, 0x00000C2C,  BBREG_0x033, 0x000000A4,
	BBREG_0x03f, 0x00000C2F,  BBREG_0x033, 0x000000A5,  BBREG_0x03f,
	0x00000C8A,  BBREG_0x033, 0x000000A6,  BBREG_0x03f, 0x00000C8D,
	BBREG_0x033, 0x000000A7,  BBREG_0x03f, 0x00000C90,  BBREG_0x033,
	0x000000A8,  BBREG_0x03f, 0x00000CEF,  BBREG_0x033, 0x000000A9,
	BBREG_0x03f, 0x00000CF2,  BBREG_0x033, 0x000000AA,  BBREG_0x03f,
	0x00000CF5,  0xB0000000,  0x00000000,  BBREG_0x0ef, 0x00000000,
	BBREG_0x0ef, 0x00000400,  0x83000001,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x0000265A,
	BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x0000265A,  BBREG_0x033,
	0x00000002,  BBREG_0x03f, 0x0000265A,  BBREG_0x033, 0x00000003,
	BBREG_0x03f, 0x0000265A,  0x93000004,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x0000265A,
	BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x0000265A,  BBREG_0x033,
	0x00000002,  BBREG_0x03f, 0x0000265A,  BBREG_0x033, 0x00000003,
	BBREG_0x03f, 0x0000265A,  0x93000006,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x0000265A,
	BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x0000265A,  BBREG_0x033,
	0x00000002,  BBREG_0x03f, 0x0000265A,  BBREG_0x033, 0x00000003,
	BBREG_0x03f, 0x0000265A,  0x93000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x0000265A,
	BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x0000265A,  BBREG_0x033,
	0x00000002,  BBREG_0x03f, 0x0000265A,  BBREG_0x033, 0x00000003,
	BBREG_0x03f, 0x0000265A,  0x9300000b,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x0000265A,
	BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x0000265A,  BBREG_0x033,
	0x00000002,  BBREG_0x03f, 0x0000265A,  BBREG_0x033, 0x00000003,
	BBREG_0x03f, 0x0000265A,  0x9300000f,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x000004FB,
	BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x000004FB,  BBREG_0x033,
	0x00000002,  BBREG_0x03f, 0x000004FB,  BBREG_0x033, 0x00000003,
	BBREG_0x03f, 0x000004FB,  0x90000001,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x0000265A,
	BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x0000265A,  BBREG_0x033,
	0x00000002,  BBREG_0x03f, 0x0000265A,  BBREG_0x033, 0x00000003,
	BBREG_0x03f, 0x0000265A,  0x90000004,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x0000265A,
	BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x0000265A,  BBREG_0x033,
	0x00000002,  BBREG_0x03f, 0x0000265A,  BBREG_0x033, 0x00000003,
	BBREG_0x03f, 0x0000265A,  0x90000006,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x0000265A,
	BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x0000265A,  BBREG_0x033,
	0x00000002,  BBREG_0x03f, 0x0000265A,  BBREG_0x033, 0x00000003,
	BBREG_0x03f, 0x0000265A,  0x90000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x0000265A,
	BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x0000265A,  BBREG_0x033,
	0x00000002,  BBREG_0x03f, 0x0000265A,  BBREG_0x033, 0x00000003,
	BBREG_0x03f, 0x0000265A,  0xA0000000,  0x00000000,  BBREG_0x033,
	0x00000000,  BBREG_0x03f, 0x000004BB,  BBREG_0x033, 0x00000001,
	BBREG_0x03f, 0x000004BB,  BBREG_0x033, 0x00000002,  BBREG_0x03f,
	0x000004BB,  BBREG_0x033, 0x00000003,  BBREG_0x03f, 0x000004BB,
	0xB0000000,  0x00000000,  BBREG_0x0ef, 0x00000000,  BBREG_0x0ef,
	0x00000100,  0x83000001,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00000745,  BBREG_0x033,
	0x00000001,  BBREG_0x03f, 0x00000745,  BBREG_0x033, 0x00000002,
	BBREG_0x03f, 0x00000745,  BBREG_0x033, 0x00000003,  BBREG_0x03f,
	0x00000745,  0x93000004,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00000745,  BBREG_0x033,
	0x00000001,  BBREG_0x03f, 0x00000745,  BBREG_0x033, 0x00000002,
	BBREG_0x03f, 0x00000745,  BBREG_0x033, 0x00000003,  BBREG_0x03f,
	0x00000745,  0x93000006,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00000745,  BBREG_0x033,
	0x00000001,  BBREG_0x03f, 0x00000745,  BBREG_0x033, 0x00000002,
	BBREG_0x03f, 0x00000745,  BBREG_0x033, 0x00000003,  BBREG_0x03f,
	0x00000745,  0x93000007,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00000745,  BBREG_0x033,
	0x00000001,  BBREG_0x03f, 0x00000745,  BBREG_0x033, 0x00000002,
	BBREG_0x03f, 0x00000745,  BBREG_0x033, 0x00000003,  BBREG_0x03f,
	0x00000745,  0x9300000b,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00000745,  BBREG_0x033,
	0x00000001,  BBREG_0x03f, 0x00000745,  BBREG_0x033, 0x00000002,
	BBREG_0x03f, 0x00000745,  BBREG_0x033, 0x00000003,  BBREG_0x03f,
	0x00000745,  0x90000001,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00000745,  BBREG_0x033,
	0x00000001,  BBREG_0x03f, 0x00000745,  BBREG_0x033, 0x00000002,
	BBREG_0x03f, 0x00000745,  BBREG_0x033, 0x00000003,  BBREG_0x03f,
	0x00000745,  0x90000004,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00000745,  BBREG_0x033,
	0x00000001,  BBREG_0x03f, 0x00000745,  BBREG_0x033, 0x00000002,
	BBREG_0x03f, 0x00000745,  BBREG_0x033, 0x00000003,  BBREG_0x03f,
	0x00000745,  0x90000006,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00000745,  BBREG_0x033,
	0x00000001,  BBREG_0x03f, 0x00000745,  BBREG_0x033, 0x00000002,
	BBREG_0x03f, 0x00000745,  BBREG_0x033, 0x00000003,  BBREG_0x03f,
	0x00000745,  0x90000007,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00000745,  BBREG_0x033,
	0x00000001,  BBREG_0x03f, 0x00000745,  BBREG_0x033, 0x00000002,
	BBREG_0x03f, 0x00000745,  BBREG_0x033, 0x00000003,  BBREG_0x03f,
	0x00000745,  0xA0000000,  0x00000000,  BBREG_0x033, 0x00000000,
	BBREG_0x03f, 0x00000F34,  BBREG_0x033, 0x00000001,  BBREG_0x03f,
	0x00000F34,  BBREG_0x033, 0x00000002,  BBREG_0x03f, 0x00000F34,
	BBREG_0x033, 0x00000003,  BBREG_0x03f, 0x00000F34,  0xB0000000,
	0x00000000,  BBREG_0x0ef, 0x00000000,  0x83000001,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x081, 0x0000F400,  BBREG_0x087,
	0x00016040,  BBREG_0x051, 0x00000808,  BBREG_0x052, 0x00098002,
	BBREG_0x053, 0x0000FA47,  BBREG_0x054, 0x00058032,  BBREG_0x056,
	0x00051000,  BBREG_0x057, 0x0000CE0A,  BBREG_0x058, 0x00082030,
	0x93000004,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x081,
	0x0000F400,  BBREG_0x087, 0x00016040,  BBREG_0x051, 0x00000808,
	BBREG_0x052, 0x00098002,  BBREG_0x053, 0x0000FA47,  BBREG_0x054,
	0x00058032,  BBREG_0x056, 0x00051000,  BBREG_0x057, 0x0000CE0A,
	BBREG_0x058, 0x00082030,  0x93000006,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x081, 0x0000F400,  BBREG_0x087, 0x00016040,
	BBREG_0x051, 0x00000808,  BBREG_0x052, 0x00098002,  BBREG_0x053,
	0x0000FA47,  BBREG_0x054, 0x00058032,  BBREG_0x056, 0x00051000,
	BBREG_0x057, 0x0000CE0A,  BBREG_0x058, 0x00082030,  0x93000007,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x081, 0x0000F400,
	BBREG_0x087, 0x00016040,  BBREG_0x051, 0x00000808,  BBREG_0x052,
	0x00098002,  BBREG_0x053, 0x0000FA47,  BBREG_0x054, 0x00058032,
	BBREG_0x056, 0x00051000,  BBREG_0x057, 0x0000CE0A,  BBREG_0x058,
	0x00082030,  0x9300000b,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x081, 0x0000F400,  BBREG_0x087, 0x00016040,  BBREG_0x051,
	0x00000808,  BBREG_0x052, 0x00098002,  BBREG_0x053, 0x0000FA47,
	BBREG_0x054, 0x00058032,  BBREG_0x056, 0x00051000,  BBREG_0x057,
	0x0000CE0A,  BBREG_0x058, 0x00082030,  0x90000001,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x081, 0x0000F400,  BBREG_0x087,
	0x00016040,  BBREG_0x051, 0x00000808,  BBREG_0x052, 0x00098002,
	BBREG_0x053, 0x0000FA47,  BBREG_0x054, 0x00058032,  BBREG_0x056,
	0x00051000,  BBREG_0x057, 0x0000CE0A,  BBREG_0x058, 0x00082030,
	0x90000004,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x081,
	0x0000F400,  BBREG_0x087, 0x00016040,  BBREG_0x051, 0x00000808,
	BBREG_0x052, 0x00098002,  BBREG_0x053, 0x0000FA47,  BBREG_0x054,
	0x00058032,  BBREG_0x056, 0x00051000,  BBREG_0x057, 0x0000CE0A,
	BBREG_0x058, 0x00082030,  0x90000006,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x081, 0x0000F400,  BBREG_0x087, 0x00016040,
	BBREG_0x051, 0x00000808,  BBREG_0x052, 0x00098002,  BBREG_0x053,
	0x0000FA47,  BBREG_0x054, 0x00058032,  BBREG_0x056, 0x00051000,
	BBREG_0x057, 0x0000CE0A,  BBREG_0x058, 0x00082030,  0x90000007,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x081, 0x0000F400,
	BBREG_0x087, 0x00016040,  BBREG_0x051, 0x00000808,  BBREG_0x052,
	0x00098002,  BBREG_0x053, 0x0000FA47,  BBREG_0x054, 0x00058032,
	BBREG_0x056, 0x00051000,  BBREG_0x057, 0x0000CE0A,  BBREG_0x058,
	0x00082030,  0xA0000000,  0x00000000,  BBREG_0x081, 0x0000F000,
	BBREG_0x087, 0x00016040,  BBREG_0x051, 0x00000C00,  BBREG_0x052,
	0x0007C241,  BBREG_0x053, 0x0001C069,  BBREG_0x054, 0x00078032,
	BBREG_0x057, 0x0000CE0A,  BBREG_0x058, 0x00058750,  0xB0000000,
	0x00000000,  BBREG_0x0ef, 0x00000800,  0x83000001,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f,
	0x00000003,  BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x00000006,
	BBREG_0x033, 0x00000002,  BBREG_0x03f, 0x00000009,  BBREG_0x033,
	0x00000003,  BBREG_0x03f, 0x00000026,  BBREG_0x033, 0x00000004,
	BBREG_0x03f, 0x00000029,  BBREG_0x033, 0x00000005,  BBREG_0x03f,
	0x0000002C,  BBREG_0x033, 0x00000006,  BBREG_0x03f, 0x0000002F,
	BBREG_0x033, 0x00000007,  BBREG_0x03f, 0x00000033,  BBREG_0x033,
	0x00000008,  BBREG_0x03f, 0x00000036,  BBREG_0x033, 0x00000009,
	BBREG_0x03f, 0x00000039,  BBREG_0x033, 0x0000000A,  BBREG_0x03f,
	0x0000003C,  0x93000004,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00000002,  BBREG_0x033,
	0x00000001,  BBREG_0x03f, 0x00000005,  BBREG_0x033, 0x00000002,
	BBREG_0x03f, 0x00000008,  BBREG_0x033, 0x00000003,  BBREG_0x03f,
	0x0000000B,  BBREG_0x033, 0x00000004,  BBREG_0x03f, 0x0000000E,
	BBREG_0x033, 0x00000005,  BBREG_0x03f, 0x0000002B,  BBREG_0x033,
	0x00000006,  BBREG_0x03f, 0x0000002E,  BBREG_0x033, 0x00000007,
	BBREG_0x03f, 0x00000031,  BBREG_0x033, 0x00000008,  BBREG_0x03f,
	0x0000006E,  BBREG_0x033, 0x00000009,  BBREG_0x03f, 0x00000071,
	BBREG_0x033, 0x0000000A,  BBREG_0x03f, 0x00000074,  0x93000006,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x00000000,
	BBREG_0x03f, 0x00000003,  BBREG_0x033, 0x00000001,  BBREG_0x03f,
	0x00000006,  BBREG_0x033, 0x00000002,  BBREG_0x03f, 0x00000009,
	BBREG_0x033, 0x00000003,  BBREG_0x03f, 0x00000026,  BBREG_0x033,
	0x00000004,  BBREG_0x03f, 0x00000029,  BBREG_0x033, 0x00000005,
	BBREG_0x03f, 0x0000002C,  BBREG_0x033, 0x00000006,  BBREG_0x03f,
	0x0000002F,  BBREG_0x033, 0x00000007,  BBREG_0x03f, 0x00000033,
	BBREG_0x033, 0x00000008,  BBREG_0x03f, 0x00000036,  BBREG_0x033,
	0x00000009,  BBREG_0x03f, 0x00000039,  BBREG_0x033, 0x0000000A,
	BBREG_0x03f, 0x0000003C,  0x93000007,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00000003,
	BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x00000006,  BBREG_0x033,
	0x00000002,  BBREG_0x03f, 0x00000009,  BBREG_0x033, 0x00000003,
	BBREG_0x03f, 0x00000026,  BBREG_0x033, 0x00000004,  BBREG_0x03f,
	0x00000029,  BBREG_0x033, 0x00000005,  BBREG_0x03f, 0x0000002C,
	BBREG_0x033, 0x00000006,  BBREG_0x03f, 0x0000002F,  BBREG_0x033,
	0x00000007,  BBREG_0x03f, 0x00000033,  BBREG_0x033, 0x00000008,
	BBREG_0x03f, 0x00000036,  BBREG_0x033, 0x00000009,  BBREG_0x03f,
	0x00000039,  BBREG_0x033, 0x0000000A,  BBREG_0x03f, 0x0000003C,
	0x9300000b,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x033,
	0x00000000,  BBREG_0x03f, 0x00000003,  BBREG_0x033, 0x00000001,
	BBREG_0x03f, 0x00000006,  BBREG_0x033, 0x00000002,  BBREG_0x03f,
	0x00000009,  BBREG_0x033, 0x00000003,  BBREG_0x03f, 0x00000026,
	BBREG_0x033, 0x00000004,  BBREG_0x03f, 0x00000029,  BBREG_0x033,
	0x00000005,  BBREG_0x03f, 0x0000002C,  BBREG_0x033, 0x00000006,
	BBREG_0x03f, 0x0000002F,  BBREG_0x033, 0x00000007,  BBREG_0x03f,
	0x00000033,  BBREG_0x033, 0x00000008,  BBREG_0x03f, 0x00000036,
	BBREG_0x033, 0x00000009,  BBREG_0x03f, 0x00000039,  BBREG_0x033,
	0x0000000A,  BBREG_0x03f, 0x0000003C,  0x9300000c,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f,
	0x0005142C,  BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x0005142F,
	BBREG_0x033, 0x00000002,  BBREG_0x03f, 0x00051432,  BBREG_0x033,
	0x00000003,  BBREG_0x03f, 0x00051CA5,  BBREG_0x033, 0x00000004,
	BBREG_0x03f, 0x00051CA8,  BBREG_0x033, 0x00000005,  BBREG_0x03f,
	0x00051CAB,  BBREG_0x033, 0x00000006,  BBREG_0x03f, 0x00051CEB,
	BBREG_0x033, 0x00000007,  BBREG_0x03f, 0x00051CEE,  BBREG_0x033,
	0x00000008,  BBREG_0x03f, 0x00051CF1,  BBREG_0x033, 0x00000009,
	BBREG_0x03f, 0x00051CF4,  BBREG_0x033, 0x0000000A,  BBREG_0x03f,
	0x00051CF7,  0x9300000f,  0x00000000,  0x40000000,  0x00000000,
	BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x0005142C,  BBREG_0x033,
	0x00000001,  BBREG_0x03f, 0x0005144B,  BBREG_0x033, 0x00000002,
	BBREG_0x03f, 0x00051868,  BBREG_0x033, 0x00000003,  BBREG_0x03f,
	0x0005186B,  BBREG_0x033, 0x00000004,  BBREG_0x03f, 0x0005186E,
	BBREG_0x033, 0x00000005,  BBREG_0x03f, 0x00051871,  BBREG_0x033,
	0x00000006,  BBREG_0x03f, 0x00051874,  BBREG_0x033, 0x00000007,
	BBREG_0x03f, 0x00051895,  BBREG_0x033, 0x00000008,  BBREG_0x03f,
	0x000518B6,  BBREG_0x033, 0x00000009,  BBREG_0x03f, 0x000518F6,
	BBREG_0x033, 0x0000000A,  BBREG_0x03f, 0x00051CF7,  0x90000001,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x033, 0x00000000,
	BBREG_0x03f, 0x00000003,  BBREG_0x033, 0x00000001,  BBREG_0x03f,
	0x00000006,  BBREG_0x033, 0x00000002,  BBREG_0x03f, 0x00000009,
	BBREG_0x033, 0x00000003,  BBREG_0x03f, 0x00000026,  BBREG_0x033,
	0x00000004,  BBREG_0x03f, 0x00000029,  BBREG_0x033, 0x00000005,
	BBREG_0x03f, 0x0000002C,  BBREG_0x033, 0x00000006,  BBREG_0x03f,
	0x0000002F,  BBREG_0x033, 0x00000007,  BBREG_0x03f, 0x00000033,
	BBREG_0x033, 0x00000008,  BBREG_0x03f, 0x00000036,  BBREG_0x033,
	0x00000009,  BBREG_0x03f, 0x00000039,  BBREG_0x033, 0x0000000A,
	BBREG_0x03f, 0x0000003C,  0x90000004,  0x00000000,  0x40000000,
	0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f, 0x00000003,
	BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x00000006,  BBREG_0x033,
	0x00000002,  BBREG_0x03f, 0x00000009,  BBREG_0x033, 0x00000003,
	BBREG_0x03f, 0x00000026,  BBREG_0x033, 0x00000004,  BBREG_0x03f,
	0x00000029,  BBREG_0x033, 0x00000005,  BBREG_0x03f, 0x0000002C,
	BBREG_0x033, 0x00000006,  BBREG_0x03f, 0x0000002F,  BBREG_0x033,
	0x00000007,  BBREG_0x03f, 0x00000033,  BBREG_0x033, 0x00000008,
	BBREG_0x03f, 0x00000036,  BBREG_0x033, 0x00000009,  BBREG_0x03f,
	0x00000039,  BBREG_0x033, 0x0000000A,  BBREG_0x03f, 0x0000003C,
	0x90000006,  0x00000000,  0x40000000,  0x00000000,  BBREG_0x033,
	0x00000000,  BBREG_0x03f, 0x00000003,  BBREG_0x033, 0x00000001,
	BBREG_0x03f, 0x00000006,  BBREG_0x033, 0x00000002,  BBREG_0x03f,
	0x00000009,  BBREG_0x033, 0x00000003,  BBREG_0x03f, 0x00000026,
	BBREG_0x033, 0x00000004,  BBREG_0x03f, 0x00000029,  BBREG_0x033,
	0x00000005,  BBREG_0x03f, 0x0000002C,  BBREG_0x033, 0x00000006,
	BBREG_0x03f, 0x0000002F,  BBREG_0x033, 0x00000007,  BBREG_0x03f,
	0x00000033,  BBREG_0x033, 0x00000008,  BBREG_0x03f, 0x00000036,
	BBREG_0x033, 0x00000009,  BBREG_0x03f, 0x00000039,  BBREG_0x033,
	0x0000000A,  BBREG_0x03f, 0x0000003C,  0x90000007,  0x00000000,
	0x40000000,  0x00000000,  BBREG_0x033, 0x00000000,  BBREG_0x03f,
	0x00000003,  BBREG_0x033, 0x00000001,  BBREG_0x03f, 0x00000006,
	BBREG_0x033, 0x00000002,  BBREG_0x03f, 0x00000009,  BBREG_0x033,
	0x00000003,  BBREG_0x03f, 0x00000026,  BBREG_0x033, 0x00000004,
	BBREG_0x03f, 0x00000029,  BBREG_0x033, 0x00000005,  BBREG_0x03f,
	0x0000002C,  BBREG_0x033, 0x00000006,  BBREG_0x03f, 0x0000002F,
	BBREG_0x033, 0x00000007,  BBREG_0x03f, 0x00000033,  BBREG_0x033,
	0x00000008,  BBREG_0x03f, 0x00000036,  BBREG_0x033, 0x00000009,
	BBREG_0x03f, 0x00000039,  BBREG_0x033, 0x0000000A,  BBREG_0x03f,
	0x0000003C,  0xA0000000,  0x00000000,  BBREG_0x033, 0x00000000,
	BBREG_0x03f, 0x0005142C,  BBREG_0x033, 0x00000001,  BBREG_0x03f,
	0x0005142F,  BBREG_0x033, 0x00000002,  BBREG_0x03f, 0x00051432,
	BBREG_0x033, 0x00000003,  BBREG_0x03f, 0x00051C87,  BBREG_0x033,
	0x00000004,  BBREG_0x03f, 0x00051C8A,  BBREG_0x033, 0x00000005,
	BBREG_0x03f, 0x00051C8D,  BBREG_0x033, 0x00000006,  BBREG_0x03f,
	0x00051CEB,  BBREG_0x033, 0x00000007,  BBREG_0x03f, 0x00051CEE,
	BBREG_0x033, 0x00000008,  BBREG_0x03f, 0x00051CF1,  BBREG_0x033,
	0x00000009,  BBREG_0x03f, 0x00051CF4,  BBREG_0x033, 0x0000000A,
	BBREG_0x03f, 0x00051CF7,  0xB0000000,  0x00000000,  0x8300000c,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x0ef, 0x00000000,
	0xA0000000,  0x00000000,  BBREG_0x0ef, 0x00000000,  0xB0000000,
	0x00000000,  BBREG_0x0ef, 0x00000010,  BBREG_0x033, 0x00000000,
	BBREG_0x008, 0x0009C060,  BBREG_0x033, 0x00000001,  BBREG_0x008,
	0x0009C060,  BBREG_0x0ef, 0x00000000,  BBREG_0x033, 0x000000A2,
	BBREG_0x0ef, 0x00080000,  BBREG_0x03e, 0x0000593F,  0x8300000c,
	0x00000000,  0x40000000,  0x00000000,  BBREG_0x03f, 0x000D0F4F,
	0xA0000000,  0x00000000,  BBREG_0x03f, 0x000C0F4F,  0xB0000000,
	0x00000000,  BBREG_0x0ef, 0x00000000,  BBREG_0x033, 0x000000A3,
	BBREG_0x0ef, 0x00080000,  BBREG_0x03e, 0x00005934,  BBREG_0x03f,
	0x0005AFCF,  BBREG_0x0ef, 0x00000000,

};

void odm_read_and_config_mp_8822b_radiob(struct PHY_DM_STRUCT *p_dm_odm)
{
	u32 i = 0;
	u8 c_cond;
	boolean is_matched = true, is_skipped = false;
	u32 array_len = sizeof(array_mp_8822b_radiob) / sizeof(u32);
	u32 *array = array_mp_8822b_radiob;

	u32 v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> odm_read_and_config_mp_8822b_radiob\n"));

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 &
		    (BIT(31) | BIT(30))) { /*positive & negative condition*/
			if (v1 & BIT(31)) { /* positive condition*/
				c_cond = (u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) { /*end*/
					is_matched = true;
					is_skipped = false;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT,
						     ODM_DBG_LOUD, ("ENDIF\n"));
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT,
						     ODM_DBG_LOUD, ("ELSE\n"));
				} else { /*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT,
						     ODM_DBG_LOUD,
						     ("IF or ELSE IF\n"));
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (is_skipped == false) {
					if (check_positive(p_dm_odm, pre_v1,
							   pre_v2, v1, v2)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else
					is_matched = false;
			}
		} else {
			if (is_matched)
				odm_config_rf_radio_b_8822b(p_dm_odm, v1, v2);
		}
		i = i + 2;
	}
}

u32 odm_get_version_mp_8822b_radiob(void) { return 100; }

/******************************************************************************
*                           txpowertrack.TXT
******************************************************************************/

u8 g_delta_swing_table_idx_mp_5gb_n_txpowertrack_8822b[][DELTA_SWINGIDX_SIZE] =
	{
		{0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  9,  10, 10,
		 11, 11, 12, 12, 12, 13, 13, 14, 14, 14, 15, 15, 15, 15, 15},
		{0, 1,  1,  2,  2,  3,  3,  4,  5,  5,  6,  7,  7,  8,  8,
		 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
		{0, 1,  2,  2,  3,  3,  4,  4,  5,  6,  6,  7,  7,  8,  9,
		 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
};
u8 g_delta_swing_table_idx_mp_5gb_p_txpowertrack_8822b[][DELTA_SWINGIDX_SIZE] =
	{
		{0,  1,  2,  2,  3,  4,  5,  6,  7,  8,  8,  9,  10, 11, 11,
		 12, 13, 14, 15, 15, 16, 17, 18, 18, 19, 19, 19, 19, 19, 19},
		{0,  1,  2,  2,  3,  4,  5,  6,  6,  7,  8,  8,  9,  9,  10,
		 11, 12, 12, 13, 14, 15, 16, 17, 17, 18, 18, 18, 18, 18, 18},
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  6,  7,  8,  8,  9,  10,
		 10, 11, 12, 13, 14, 15, 15, 16, 16, 17, 17, 17, 17, 17, 17},
};
u8 g_delta_swing_table_idx_mp_5ga_n_txpowertrack_8822b[][DELTA_SWINGIDX_SIZE] =
	{
		{0,  1,  2,  2,  3,  3,  4,  5,  6,  7,  8,  8,  9,  9,  10,
		 11, 11, 12, 12, 12, 13, 13, 14, 14, 14, 15, 15, 15, 15, 15},
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  6,  7,  7,  8,  8,  9,
		 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
		{0, 1,  2,  2,  3,  4,  4,  5,  6,  6,  7,  7,  8,  8,  9,
		 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
};
u8 g_delta_swing_table_idx_mp_5ga_p_txpowertrack_8822b[][DELTA_SWINGIDX_SIZE] =
	{
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  7,  8,  9,  9,  10, 11,
		 12, 13, 14, 14, 15, 16, 17, 18, 19, 19, 20, 20, 20, 20, 20},
		{0,  1,  2,  2,  3,  4,  4,  5,  6,  6,  7,  7,  8,  9,  9,
		 10, 11, 11, 12, 13, 14, 15, 16, 16, 17, 17, 18, 18, 18, 18},
		{0,  1,  2,  3,  3,  4,  5,  5,  6,  6,  7,  8,  8,  9,  10,
		 11, 12, 12, 13, 14, 15, 15, 16, 17, 17, 18, 18, 18, 18, 18},
};
u8 g_delta_swing_table_idx_mp_2gb_n_txpowertrack_8822b[] = {
	0,  1,  2,  3,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2gb_p_txpowertrack_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  7,  8,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2ga_n_txpowertrack_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2ga_p_txpowertrack_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17};
u8 g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_8822b[] = {
	0,  1,  2,  3,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};

void odm_read_and_config_mp_8822b_txpowertrack(struct PHY_DM_STRUCT *p_dm_odm)
{
	struct odm_rf_calibration_structure *p_rf_calibrate_info =
		&p_dm_odm->rf_calibrate_info;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> ODM_ReadAndConfig_MP_mp_8822b\n"));

	odm_move_memory(p_dm_odm,
			p_rf_calibrate_info->delta_swing_table_idx_2ga_p,
			g_delta_swing_table_idx_mp_2ga_p_txpowertrack_8822b,
			DELTA_SWINGIDX_SIZE);
	odm_move_memory(p_dm_odm,
			p_rf_calibrate_info->delta_swing_table_idx_2ga_n,
			g_delta_swing_table_idx_mp_2ga_n_txpowertrack_8822b,
			DELTA_SWINGIDX_SIZE);
	odm_move_memory(p_dm_odm,
			p_rf_calibrate_info->delta_swing_table_idx_2gb_p,
			g_delta_swing_table_idx_mp_2gb_p_txpowertrack_8822b,
			DELTA_SWINGIDX_SIZE);
	odm_move_memory(p_dm_odm,
			p_rf_calibrate_info->delta_swing_table_idx_2gb_n,
			g_delta_swing_table_idx_mp_2gb_n_txpowertrack_8822b,
			DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_p,
		g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_n,
		g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_p,
		g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_n,
		g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(p_dm_odm,
			p_rf_calibrate_info->delta_swing_table_idx_5ga_p,
			g_delta_swing_table_idx_mp_5ga_p_txpowertrack_8822b,
			DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(p_dm_odm,
			p_rf_calibrate_info->delta_swing_table_idx_5ga_n,
			g_delta_swing_table_idx_mp_5ga_n_txpowertrack_8822b,
			DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(p_dm_odm,
			p_rf_calibrate_info->delta_swing_table_idx_5gb_p,
			g_delta_swing_table_idx_mp_5gb_p_txpowertrack_8822b,
			DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(p_dm_odm,
			p_rf_calibrate_info->delta_swing_table_idx_5gb_n,
			g_delta_swing_table_idx_mp_5gb_n_txpowertrack_8822b,
			DELTA_SWINGIDX_SIZE * 3);
}

/******************************************************************************
*                           txpowertrack_type0.TXT
******************************************************************************/

u8 g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type0_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  7,  7,  8,  8,
		 9, 9, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 15, 15},
};
u8 g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type0_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 10, 10, 11, 12, 13, 14, 14, 15, 15, 15, 16, 16},
};
u8 g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type0_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 13, 14, 14},
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
};
u8 g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type0_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 12, 13, 13, 14, 14, 15, 15, 15},
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
};
u8 g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type0_8822b[] = {
	0,  1,  2,  3,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type0_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  7,  8,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type0_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type0_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type0_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17};
u8 g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type0_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type0_8822b[] = {
	0,  1,  2,  3,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type0_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};

void odm_read_and_config_mp_8822b_txpowertrack_type0(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	struct odm_rf_calibration_structure *p_rf_calibrate_info =
		&p_dm_odm->rf_calibrate_info;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> ODM_ReadAndConfig_MP_mp_8822b\n"));

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_p,
		g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type0_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_n,
		g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type0_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_p,
		g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type0_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_n,
		g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type0_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_p,
		g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type0_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_n,
		g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type0_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_p,
		g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type0_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_n,
		g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type0_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_p,
		g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type0_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_n,
		g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type0_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_p,
		g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type0_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_n,
		g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type0_8822b,
		DELTA_SWINGIDX_SIZE * 3);
}

/******************************************************************************
*                           txpowertrack_type1.TXT
******************************************************************************/

u8 g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type1_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  9,  10, 10,
		 11, 11, 12, 12, 12, 13, 13, 14, 14, 14, 15, 15, 15, 15, 15},
		{0, 1,  1,  2,  2,  3,  3,  4,  5,  5,  6,  7,  7,  8,  8,
		 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
		{0, 1,  2,  2,  3,  3,  4,  4,  5,  6,  6,  7,  7,  8,  9,
		 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
};
u8 g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type1_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0,  1,  2,  2,  3,  4,  5,  6,  7,  8,  8,  9,  10, 11, 11,
		 12, 13, 14, 15, 15, 16, 17, 18, 18, 19, 19, 19, 19, 19, 19},
		{0,  1,  2,  2,  3,  4,  5,  6,  6,  7,  8,  8,  9,  9,  10,
		 11, 12, 12, 13, 14, 15, 16, 17, 17, 18, 18, 18, 18, 18, 18},
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  6,  7,  8,  8,  9,  10,
		 10, 11, 12, 13, 14, 15, 15, 16, 16, 17, 17, 17, 17, 17, 17},
};
u8 g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type1_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0,  1,  2,  2,  3,  3,  4,  5,  6,  7,  8,  8,  9,  9,  10,
		 11, 11, 12, 12, 12, 13, 13, 14, 14, 14, 15, 15, 15, 15, 15},
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  6,  7,  7,  8,  8,  9,
		 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
		{0, 1,  2,  2,  3,  4,  4,  5,  6,  6,  7,  7,  8,  8,  9,
		 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
};
u8 g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type1_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  7,  8,  9,  9,  10, 11,
		 12, 13, 14, 14, 15, 16, 17, 18, 19, 19, 20, 20, 20, 20, 20},
		{0,  1,  2,  2,  3,  4,  4,  5,  6,  6,  7,  7,  8,  9,  9,
		 10, 11, 11, 12, 13, 14, 15, 16, 16, 17, 17, 18, 18, 18, 18},
		{0,  1,  2,  3,  3,  4,  5,  5,  6,  6,  7,  8,  8,  9,  10,
		 11, 12, 12, 13, 14, 15, 15, 16, 17, 17, 18, 18, 18, 18, 18},
};
u8 g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type1_8822b[] = {
	0,  1,  2,  3,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type1_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  7,  8,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type1_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type1_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type1_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17};
u8 g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type1_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type1_8822b[] = {
	0,  1,  2,  3,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type1_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};

void odm_read_and_config_mp_8822b_txpowertrack_type1(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	struct odm_rf_calibration_structure *p_rf_calibrate_info =
		&p_dm_odm->rf_calibrate_info;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> ODM_ReadAndConfig_MP_mp_8822b\n"));

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_p,
		g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type1_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_n,
		g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type1_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_p,
		g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type1_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_n,
		g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type1_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_p,
		g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type1_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_n,
		g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type1_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_p,
		g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type1_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_n,
		g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type1_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_p,
		g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type1_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_n,
		g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type1_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_p,
		g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type1_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_n,
		g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type1_8822b,
		DELTA_SWINGIDX_SIZE * 3);
}

/******************************************************************************
*                           txpowertrack_type10.TXT
******************************************************************************/

u8 g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type10_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  7,  7,  8,  8,
		 9, 9, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 15, 15},
};
u8 g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type10_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 10, 10, 11, 12, 13, 14, 14, 15, 15, 15, 16, 16},
};
u8 g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type10_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 13, 14, 14},
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
};
u8 g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type10_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 12, 13, 13, 14, 14, 15, 15, 15},
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
};
u8 g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type10_8822b[] = {
	0,  1,  2,  3,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type10_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  7,  8,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type10_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type10_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type10_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17};
u8 g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type10_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type10_8822b[] = {
	0,  1,  2,  3,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type10_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};

void odm_read_and_config_mp_8822b_txpowertrack_type10(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	struct odm_rf_calibration_structure *p_rf_calibrate_info =
		&p_dm_odm->rf_calibrate_info;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> ODM_ReadAndConfig_MP_mp_8822b\n"));

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_p,
		g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type10_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_n,
		g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type10_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_p,
		g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type10_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_n,
		g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type10_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_p,
		g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type10_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_n,
		g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type10_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_p,
		g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type10_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_n,
		g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type10_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_p,
		g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type10_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_n,
		g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type10_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_p,
		g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type10_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_n,
		g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type10_8822b,
		DELTA_SWINGIDX_SIZE * 3);
}

/******************************************************************************
*                           txpowertrack_type11.TXT
******************************************************************************/

u8 g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type11_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  7,  7,  8,  8,
		 9, 9, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 15, 15},
};
u8 g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type11_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 10, 10, 11, 12, 13, 14, 14, 15, 15, 15, 16, 16},
};
u8 g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type11_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 13, 14, 14},
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
};
u8 g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type11_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 12, 13, 13, 14, 14, 15, 15, 15},
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
};
u8 g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type11_8822b[] = {
	0,  1,  2,  3,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type11_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  7,  8,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type11_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type11_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type11_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17};
u8 g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type11_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type11_8822b[] = {
	0,  1,  2,  3,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type11_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};

void odm_read_and_config_mp_8822b_txpowertrack_type11(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	struct odm_rf_calibration_structure *p_rf_calibrate_info =
		&p_dm_odm->rf_calibrate_info;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> ODM_ReadAndConfig_MP_mp_8822b\n"));

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_p,
		g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type11_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_n,
		g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type11_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_p,
		g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type11_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_n,
		g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type11_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_p,
		g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type11_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_n,
		g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type11_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_p,
		g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type11_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_n,
		g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type11_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_p,
		g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type11_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_n,
		g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type11_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_p,
		g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type11_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_n,
		g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type11_8822b,
		DELTA_SWINGIDX_SIZE * 3);
}

/******************************************************************************
*                           txpowertrack_type12.TXT
******************************************************************************/

u8 g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type12_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};
u8 g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type12_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};
u8 g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type12_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};
u8 g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type12_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};
u8 g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type12_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4,  4,  5,  5,  5,  6,
	6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u8 g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type12_8822b[] = {
	0, 0, 1, 1, 2, 2, 3,  3,  4,  4,  5,  5,  6,  6,  6,
	7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13};
u8 g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type12_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4,  4,  5,  5,  5,  6,
	6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u8 g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type12_8822b[] = {
	0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
	8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15};
u8 g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type12_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4,  4,  5,  5,  5,  6,
	6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u8 g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type12_8822b[] = {
	0, 0, 1, 1, 2, 2, 3,  3,  4,  4,  5,  5,  6,  6,  6,
	7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13};
u8 g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type12_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4,  4,  5,  5,  5,  6,
	6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u8 g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type12_8822b[] = {
	0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
	8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15};

void odm_read_and_config_mp_8822b_txpowertrack_type12(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	struct odm_rf_calibration_structure *p_rf_calibrate_info =
		&p_dm_odm->rf_calibrate_info;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> ODM_ReadAndConfig_MP_mp_8822b\n"));

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_p,
		g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type12_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_n,
		g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type12_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_p,
		g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type12_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_n,
		g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type12_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_p,
		g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type12_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_n,
		g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type12_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_p,
		g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type12_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_n,
		g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type12_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_p,
		g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type12_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_n,
		g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type12_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_p,
		g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type12_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_n,
		g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type12_8822b,
		DELTA_SWINGIDX_SIZE * 3);
}

/******************************************************************************
*                           txpowertrack_type13.TXT
******************************************************************************/

u8 g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type13_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  7,  7,  8,  8,
		 9, 9, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 15, 15},
};
u8 g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type13_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 10, 10, 11, 12, 13, 14, 14, 15, 15, 15, 16, 16},
};
u8 g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type13_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 13, 14, 14},
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
};
u8 g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type13_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 12, 13, 13, 14, 14, 15, 15, 15},
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
};
u8 g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type13_8822b[] = {
	0,  1,  2,  3,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type13_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  7,  8,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type13_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type13_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type13_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17};
u8 g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type13_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type13_8822b[] = {
	0,  1,  2,  3,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type13_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};

void odm_read_and_config_mp_8822b_txpowertrack_type13(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	struct odm_rf_calibration_structure *p_rf_calibrate_info =
		&p_dm_odm->rf_calibrate_info;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> ODM_ReadAndConfig_MP_mp_8822b\n"));

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_p,
		g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type13_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_n,
		g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type13_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_p,
		g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type13_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_n,
		g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type13_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_p,
		g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type13_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_n,
		g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type13_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_p,
		g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type13_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_n,
		g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type13_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_p,
		g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type13_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_n,
		g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type13_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_p,
		g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type13_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_n,
		g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type13_8822b,
		DELTA_SWINGIDX_SIZE * 3);
}

/******************************************************************************
*                           txpowertrack_type14.TXT
******************************************************************************/

u8 g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type14_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  7,  7,  8,  8,
		 9, 9, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 15, 15},
};
u8 g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type14_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 10, 10, 11, 12, 13, 14, 14, 15, 15, 15, 16, 16},
};
u8 g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type14_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 13, 14, 14},
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
};
u8 g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type14_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 12, 13, 13, 14, 14, 15, 15, 15},
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
};
u8 g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type14_8822b[] = {
	0,  1,  2,  3,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type14_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  7,  8,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type14_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type14_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type14_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17};
u8 g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type14_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type14_8822b[] = {
	0,  1,  2,  3,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type14_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};

void odm_read_and_config_mp_8822b_txpowertrack_type14(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	struct odm_rf_calibration_structure *p_rf_calibrate_info =
		&p_dm_odm->rf_calibrate_info;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> ODM_ReadAndConfig_MP_mp_8822b\n"));

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_p,
		g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type14_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_n,
		g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type14_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_p,
		g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type14_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_n,
		g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type14_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_p,
		g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type14_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_n,
		g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type14_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_p,
		g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type14_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_n,
		g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type14_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_p,
		g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type14_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_n,
		g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type14_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_p,
		g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type14_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_n,
		g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type14_8822b,
		DELTA_SWINGIDX_SIZE * 3);
}

/******************************************************************************
*                           txpowertrack_type15.TXT
******************************************************************************/

u8 g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type15_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};
u8 g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type15_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};
u8 g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type15_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};
u8 g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type15_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};
u8 g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type15_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4,  4,  5,  5,  5,  6,
	6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u8 g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type15_8822b[] = {
	0, 0, 1, 1, 2, 2, 3,  3,  4,  4,  5,  5,  6,  6,  6,
	7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13};
u8 g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type15_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4,  4,  5,  5,  5,  6,
	6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u8 g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type15_8822b[] = {
	0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
	8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15};
u8 g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type15_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4,  4,  5,  5,  5,  6,
	6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u8 g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type15_8822b[] = {
	0, 0, 1, 1, 2, 2, 3,  3,  4,  4,  5,  5,  6,  6,  6,
	7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13};
u8 g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type15_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4,  4,  5,  5,  5,  6,
	6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u8 g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type15_8822b[] = {
	0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
	8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15};

void odm_read_and_config_mp_8822b_txpowertrack_type15(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	struct odm_rf_calibration_structure *p_rf_calibrate_info =
		&p_dm_odm->rf_calibrate_info;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> ODM_ReadAndConfig_MP_mp_8822b\n"));

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_p,
		g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type15_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_n,
		g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type15_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_p,
		g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type15_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_n,
		g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type15_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_p,
		g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type15_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_n,
		g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type15_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_p,
		g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type15_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_n,
		g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type15_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_p,
		g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type15_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_n,
		g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type15_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_p,
		g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type15_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_n,
		g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type15_8822b,
		DELTA_SWINGIDX_SIZE * 3);
}

/******************************************************************************
*                           txpowertrack_type16.TXT
******************************************************************************/

u8 g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type16_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};
u8 g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type16_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};
u8 g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type16_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};
u8 g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type16_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};
u8 g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type16_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4,  4,  5,  5,  5,  6,
	6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u8 g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type16_8822b[] = {
	0, 0, 1, 1, 2, 2, 3,  3,  4,  4,  5,  5,  6,  6,  6,
	7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13};
u8 g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type16_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4,  4,  5,  5,  5,  6,
	6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u8 g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type16_8822b[] = {
	0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
	8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15};
u8 g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type16_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4,  4,  5,  5,  5,  6,
	6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u8 g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type16_8822b[] = {
	0, 0, 1, 1, 2, 2, 3,  3,  4,  4,  5,  5,  6,  6,  6,
	7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13};
u8 g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type16_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4,  4,  5,  5,  5,  6,
	6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u8 g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type16_8822b[] = {
	0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
	8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15};

void odm_read_and_config_mp_8822b_txpowertrack_type16(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	struct odm_rf_calibration_structure *p_rf_calibrate_info =
		&p_dm_odm->rf_calibrate_info;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> ODM_ReadAndConfig_MP_mp_8822b\n"));

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_p,
		g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type16_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_n,
		g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type16_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_p,
		g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type16_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_n,
		g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type16_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_p,
		g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type16_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_n,
		g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type16_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_p,
		g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type16_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_n,
		g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type16_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_p,
		g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type16_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_n,
		g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type16_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_p,
		g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type16_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_n,
		g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type16_8822b,
		DELTA_SWINGIDX_SIZE * 3);
}

/******************************************************************************
*                           txpowertrack_type2.TXT
******************************************************************************/

u8 g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type2_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  7,  8,  8,  9,  10, 11,
		 11, 12, 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  7,  8,  8,  9,  10, 11,
		 11, 12, 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  7,  8,  8,  9,  10, 11,
		 11, 12, 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
};
u8 g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type2_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  7,  8,  9,  9,  10, 11,
		 12, 13, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  7,  8,  9,  9,  10, 11,
		 12, 13, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  7,  8,  9,  9,  10, 11,
		 12, 13, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
};
u8 g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type2_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  7,  8,  8,  9,  10, 11,
		 11, 12, 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  7,  8,  8,  9,  10, 11,
		 11, 12, 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  7,  8,  8,  9,  10, 11,
		 11, 12, 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
};
u8 g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type2_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  7,  8,  9,  9,  10, 11,
		 12, 13, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  7,  8,  9,  9,  10, 11,
		 12, 13, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  7,  8,  9,  9,  10, 11,
		 12, 13, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
};
u8 g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type2_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4,  4,  5,  5,  5,  6,
	6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u8 g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type2_8822b[] = {
	0, 0, 1, 1, 2, 2, 3,  3,  4,  4,  5,  5,  6,  6,  6,
	7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13};
u8 g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type2_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4,  4,  5,  5,  5,  6,
	6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u8 g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type2_8822b[] = {
	0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
	8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15};
u8 g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type2_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4,  4,  5,  5,  5,  6,
	6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u8 g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type2_8822b[] = {
	0, 0, 1, 1, 2, 2, 3,  3,  4,  4,  5,  5,  6,  6,  6,
	7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13};
u8 g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type2_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4,  4,  5,  5,  5,  6,
	6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u8 g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type2_8822b[] = {
	0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
	8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15};

void odm_read_and_config_mp_8822b_txpowertrack_type2(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	struct odm_rf_calibration_structure *p_rf_calibrate_info =
		&p_dm_odm->rf_calibrate_info;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> ODM_ReadAndConfig_MP_mp_8822b\n"));

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_p,
		g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type2_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_n,
		g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type2_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_p,
		g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type2_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_n,
		g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type2_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_p,
		g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type2_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_n,
		g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type2_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_p,
		g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type2_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_n,
		g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type2_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_p,
		g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type2_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_n,
		g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type2_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_p,
		g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type2_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_n,
		g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type2_8822b,
		DELTA_SWINGIDX_SIZE * 3);
}

/******************************************************************************
*                           txpowertrack_type3_type5.TXT
******************************************************************************/

u8 g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type3_type5_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};
u8 g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type3_type5_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};
u8 g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type3_type5_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};
u8 g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type3_type5_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};
u8 g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type3_type5_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4,  4,  5,  5,  5,  6,
	6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u8 g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type3_type5_8822b[] = {
	0, 0, 1, 1, 2, 2, 3,  3,  4,  4,  5,  5,  6,  6,  6,
	7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13};
u8 g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type3_type5_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4,  4,  5,  5,  5,  6,
	6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u8 g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type3_type5_8822b[] = {
	0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
	8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15};
u8 g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type3_type5_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4,  4,  5,  5,  5,  6,
	6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u8 g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type3_type5_8822b[] = {
	0, 0, 1, 1, 2, 2, 3,  3,  4,  4,  5,  5,  6,  6,  6,
	7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13};
u8 g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type3_type5_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4,  4,  5,  5,  5,  6,
	6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u8 g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type3_type5_8822b[] = {
	0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
	8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15};

void odm_read_and_config_mp_8822b_txpowertrack_type3_type5(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	struct odm_rf_calibration_structure *p_rf_calibrate_info =
		&p_dm_odm->rf_calibrate_info;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> ODM_ReadAndConfig_MP_mp_8822b\n"));

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_p,
		g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type3_type5_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_n,
		g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type3_type5_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_p,
		g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type3_type5_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_n,
		g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type3_type5_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_p,
		g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type3_type5_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_n,
		g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type3_type5_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_p,
		g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type3_type5_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_n,
		g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type3_type5_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_p,
		g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type3_type5_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_n,
		g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type3_type5_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_p,
		g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type3_type5_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_n,
		g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type3_type5_8822b,
		DELTA_SWINGIDX_SIZE * 3);
}

/******************************************************************************
*                           txpowertrack_type4.TXT
******************************************************************************/

u8 g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type4_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  7,  8,  8,  9,  10, 11,
		 11, 12, 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  7,  8,  8,  9,  10, 11,
		 11, 12, 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  7,  8,  8,  9,  10, 11,
		 11, 12, 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
};
u8 g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type4_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  7,  8,  9,  9,  10, 11,
		 12, 13, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  7,  8,  9,  9,  10, 11,
		 12, 13, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  7,  8,  9,  9,  10, 11,
		 12, 13, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
};
u8 g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type4_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  7,  8,  8,  9,  10, 11,
		 11, 12, 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  7,  8,  8,  9,  10, 11,
		 11, 12, 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  7,  8,  8,  9,  10, 11,
		 11, 12, 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
};
u8 g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type4_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  7,  8,  9,  9,  10, 11,
		 12, 13, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  7,  8,  9,  9,  10, 11,
		 12, 13, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  7,  8,  9,  9,  10, 11,
		 12, 13, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
};
u8 g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type4_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4,  4,  5,  5,  5,  6,
	6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u8 g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type4_8822b[] = {
	0, 0, 1, 1, 2, 2, 3,  3,  4,  4,  5,  5,  6,  6,  6,
	7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13};
u8 g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type4_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4,  4,  5,  5,  5,  6,
	6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u8 g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type4_8822b[] = {
	0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
	8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15};
u8 g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type4_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4,  4,  5,  5,  5,  6,
	6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u8 g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type4_8822b[] = {
	0, 0, 1, 1, 2, 2, 3,  3,  4,  4,  5,  5,  6,  6,  6,
	7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13};
u8 g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type4_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4,  4,  5,  5,  5,  6,
	6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u8 g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type4_8822b[] = {
	0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
	8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15};

void odm_read_and_config_mp_8822b_txpowertrack_type4(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	struct odm_rf_calibration_structure *p_rf_calibrate_info =
		&p_dm_odm->rf_calibrate_info;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> ODM_ReadAndConfig_MP_mp_8822b\n"));

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_p,
		g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type4_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_n,
		g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type4_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_p,
		g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type4_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_n,
		g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type4_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_p,
		g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type4_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_n,
		g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type4_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_p,
		g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type4_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_n,
		g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type4_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_p,
		g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type4_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_n,
		g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type4_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_p,
		g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type4_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_n,
		g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type4_8822b,
		DELTA_SWINGIDX_SIZE * 3);
}

/******************************************************************************
*                           txpowertrack_type6.TXT
******************************************************************************/

u8 g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type6_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  9,  10, 10,
		 11, 11, 12, 12, 12, 13, 13, 14, 14, 14, 15, 15, 15, 15, 15},
		{0,  1,  2,  3,  4,  5,  5,  6,  7,  7,  8,  9,  9,  10, 10,
		 11, 12, 12, 13, 14, 14, 15, 15, 16, 16, 16, 16, 16, 16, 16},
		{0,  1,  2,  3,  4,  4,  5,  5,  6,  7,  8,  9,  10, 11, 12,
		 12, 13, 13, 14, 15, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17},
};
u8 g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type6_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0,  1,  2,  2,  3,  4,  5,  6,  7,  8,  8,  9,  10, 11, 11,
		 12, 13, 14, 15, 15, 16, 17, 18, 18, 19, 19, 19, 19, 19, 19},
		{0,  1,  2,  2,  3,  4,  5,  6,  7,  8,  9,  9,  11, 11, 12,
		 13, 14, 15, 16, 17, 18, 19, 20, 20, 21, 21, 21, 21, 21, 21},
		{0,  1,  2,  3,  4,  5,  6,  6,  7,  7,  8,  9,  10, 11, 12,
		 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 20, 20, 21, 21, 21},
};
u8 g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type6_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0,  1,  2,  2,  3,  3,  4,  5,  6,  7,  8,  9,  10, 10, 11,
		 12, 12, 13, 14, 14, 15, 15, 16, 16, 16, 17, 17, 17, 17, 17},
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  6,  7,  8,  9,  9,  10,
		 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 15, 15, 15, 15, 15},
		{0,  1,  2,  2,  3,  4,  4,  5,  6,  6,  7,  8,  9,  9,  10,
		 11, 12, 12, 13, 14, 14, 15, 15, 16, 16, 16, 16, 16, 16, 16},
};
u8 g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type6_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0,  1,  2,  2,  3,  4,  5,  6,  7,  8,  9,  10, 10, 11, 12,
		 13, 14, 15, 15, 16, 17, 18, 19, 20, 20, 21, 21, 21, 21, 21},
		{0,  1,  2,  2,  3,  4,  4,  5,  7,  7,  8,  9,  10, 11, 11,
		 12, 13, 13, 14, 15, 16, 17, 18, 18, 19, 19, 20, 20, 21, 21},
		{0,  1,  2,  3,  3,  4,  5,  5,  6,  7,  8,  9,  10, 11, 12,
		 13, 14, 14, 15, 16, 17, 17, 18, 19, 19, 20, 20, 20, 20, 20},
};
u8 g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type6_8822b[] = {
	0,  1,  2,  3,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type6_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  7,  8,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type6_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type6_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type6_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17};
u8 g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type6_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type6_8822b[] = {
	0,  1,  2,  3,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type6_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};

void odm_read_and_config_mp_8822b_txpowertrack_type6(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	struct odm_rf_calibration_structure *p_rf_calibrate_info =
		&p_dm_odm->rf_calibrate_info;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> ODM_ReadAndConfig_MP_mp_8822b\n"));

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_p,
		g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type6_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_n,
		g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type6_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_p,
		g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type6_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_n,
		g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type6_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_p,
		g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type6_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_n,
		g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type6_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_p,
		g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type6_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_n,
		g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type6_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_p,
		g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type6_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_n,
		g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type6_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_p,
		g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type6_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_n,
		g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type6_8822b,
		DELTA_SWINGIDX_SIZE * 3);
}

/******************************************************************************
*                           txpowertrack_type7.TXT
******************************************************************************/

u8 g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type7_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  9,  10, 10,
		 11, 11, 12, 12, 12, 13, 13, 14, 14, 14, 15, 15, 15, 15, 15},
		{0,  1,  2,  3,  4,  5,  5,  6,  7,  7,  8,  9,  9,  10, 10,
		 11, 12, 12, 13, 14, 14, 15, 15, 16, 16, 16, 16, 16, 16, 16},
		{0,  1,  2,  3,  4,  4,  5,  5,  6,  7,  8,  9,  10, 11, 12,
		 12, 13, 13, 14, 15, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17},
};
u8 g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type7_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0,  1,  2,  2,  3,  4,  5,  6,  7,  8,  8,  9,  10, 11, 11,
		 12, 13, 14, 15, 15, 16, 17, 18, 18, 19, 19, 19, 19, 19, 19},
		{0,  1,  2,  2,  3,  4,  5,  6,  7,  8,  9,  9,  11, 11, 12,
		 13, 14, 15, 16, 17, 18, 19, 20, 20, 21, 21, 21, 21, 21, 21},
		{0,  1,  2,  3,  4,  5,  6,  6,  7,  7,  8,  9,  10, 11, 12,
		 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 20, 20, 21, 21, 21},
};
u8 g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type7_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0,  1,  2,  2,  3,  3,  4,  5,  6,  7,  8,  9,  10, 10, 11,
		 12, 12, 13, 14, 14, 15, 15, 16, 16, 16, 17, 17, 17, 17, 17},
		{0,  1,  2,  2,  3,  4,  5,  5,  6,  6,  7,  8,  9,  9,  10,
		 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 15, 15, 15, 15, 15},
		{0,  1,  2,  2,  3,  4,  4,  5,  6,  6,  7,  8,  9,  9,  10,
		 11, 12, 12, 13, 14, 14, 15, 15, 16, 16, 16, 16, 16, 16, 16},
};
u8 g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type7_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0,  1,  2,  2,  3,  4,  5,  6,  7,  8,  9,  10, 10, 11, 12,
		 13, 14, 15, 15, 16, 17, 18, 19, 20, 20, 21, 21, 21, 21, 21},
		{0,  1,  2,  2,  3,  4,  4,  5,  7,  7,  8,  9,  10, 11, 11,
		 12, 13, 13, 14, 15, 16, 17, 18, 18, 19, 19, 20, 20, 21, 21},
		{0,  1,  2,  3,  3,  4,  5,  5,  6,  7,  8,  9,  10, 11, 12,
		 13, 14, 14, 15, 16, 17, 17, 18, 19, 19, 20, 20, 20, 20, 20},
};
u8 g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type7_8822b[] = {
	0,  1,  2,  3,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type7_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  7,  8,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type7_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type7_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type7_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17};
u8 g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type7_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type7_8822b[] = {
	0,  1,  2,  3,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type7_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};

void odm_read_and_config_mp_8822b_txpowertrack_type7(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	struct odm_rf_calibration_structure *p_rf_calibrate_info =
		&p_dm_odm->rf_calibrate_info;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> ODM_ReadAndConfig_MP_mp_8822b\n"));

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_p,
		g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type7_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_n,
		g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type7_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_p,
		g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type7_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_n,
		g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type7_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_p,
		g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type7_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_n,
		g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type7_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_p,
		g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type7_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_n,
		g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type7_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_p,
		g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type7_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_n,
		g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type7_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_p,
		g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type7_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_n,
		g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type7_8822b,
		DELTA_SWINGIDX_SIZE * 3);
}

/******************************************************************************
*                           txpowertrack_type8.TXT
******************************************************************************/

u8 g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type8_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};
u8 g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type8_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};
u8 g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type8_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};
u8 g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type8_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  6,  7,  7,  8,
		 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};
u8 g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type8_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4,  4,  5,  5,  5,  6,
	6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u8 g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type8_8822b[] = {
	0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
	8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15};
u8 g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type8_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4,  4,  5,  5,  5,  6,
	6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u8 g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type8_8822b[] = {
	0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
	8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15};
u8 g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type8_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4,  4,  5,  5,  5,  6,
	6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u8 g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type8_8822b[] = {
	0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
	8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15};
u8 g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type8_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4,  4,  5,  5,  5,  6,
	6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u8 g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type8_8822b[] = {
	0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  7,  7,  8,
	8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15};

void odm_read_and_config_mp_8822b_txpowertrack_type8(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	struct odm_rf_calibration_structure *p_rf_calibrate_info =
		&p_dm_odm->rf_calibrate_info;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> ODM_ReadAndConfig_MP_mp_8822b\n"));

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_p,
		g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type8_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_n,
		g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type8_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_p,
		g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type8_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_n,
		g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type8_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_p,
		g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type8_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_n,
		g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type8_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_p,
		g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type8_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_n,
		g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type8_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_p,
		g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type8_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_n,
		g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type8_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_p,
		g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type8_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_n,
		g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type8_8822b,
		DELTA_SWINGIDX_SIZE * 3);
}

/******************************************************************************
*                           txpowertrack_type9.TXT
******************************************************************************/

u8 g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type9_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  8,
		 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
		{0, 1, 1,  2,  2,  3,  3,  4,  5,  5,  6,  7,  7,  8,  8,
		 9, 9, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 15, 15},
};
u8 g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type9_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 10, 10, 11, 12, 13, 14, 14, 15, 15, 15, 16, 16},
};
u8 g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type9_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 13, 14, 14},
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
};
u8 g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type9_8822b
	[][DELTA_SWINGIDX_SIZE] = {
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 12, 13, 13, 14, 14, 15, 15, 15},
		{0, 1, 1, 2, 2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 8, 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
		{0, 1, 1, 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
		 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
};
u8 g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type9_8822b[] = {
	0,  1,  2,  3,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type9_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  7,  8,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type9_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type9_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type9_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17};
u8 g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type9_8822b[] = {
	0,  1,  1,  2,  3,  4,  4,  5,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u8 g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type9_8822b[] = {
	0,  1,  2,  3,  3,  4,  4,  5,  6,  7,  8,  9,  10, 11, 12,
	13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u8 g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type9_8822b[] = {
	0,  1,  2,  3,  3,  4,  5,  6,  6,  7,  8,  9,  9,  10, 11,
	12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};

void odm_read_and_config_mp_8822b_txpowertrack_type9(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	struct odm_rf_calibration_structure *p_rf_calibrate_info =
		&p_dm_odm->rf_calibrate_info;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> ODM_ReadAndConfig_MP_mp_8822b\n"));

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_p,
		g_delta_swing_table_idx_mp_2ga_p_txpowertrack_type9_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_n,
		g_delta_swing_table_idx_mp_2ga_n_txpowertrack_type9_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_p,
		g_delta_swing_table_idx_mp_2gb_p_txpowertrack_type9_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_n,
		g_delta_swing_table_idx_mp_2gb_n_txpowertrack_type9_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_p,
		g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_type9_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_n,
		g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_type9_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_p,
		g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_type9_8822b,
		DELTA_SWINGIDX_SIZE);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_n,
		g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_type9_8822b,
		DELTA_SWINGIDX_SIZE);

	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_p,
		g_delta_swing_table_idx_mp_5ga_p_txpowertrack_type9_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_n,
		g_delta_swing_table_idx_mp_5ga_n_txpowertrack_type9_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_p,
		g_delta_swing_table_idx_mp_5gb_p_txpowertrack_type9_8822b,
		DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(
		p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_n,
		g_delta_swing_table_idx_mp_5gb_n_txpowertrack_type9_8822b,
		DELTA_SWINGIDX_SIZE * 3);
}

/******************************************************************************
*                           txpwr_lmt.TXT
******************************************************************************/

const char *array_mp_8822b_txpwr_lmt[] = {
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "01",   "32",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "01",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "01",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "02",
	"32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "02",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "02",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "03",   "32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"03",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "03",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "04",   "32",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "04",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "04",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "05",
	"32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "05",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "05",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "06",   "32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"06",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "06",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "07",   "32",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "07",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "07",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "08",
	"32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "08",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "08",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "09",   "32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"09",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "09",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "10",   "32",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "10",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "10",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "11",
	"32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "11",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "11",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "12",   "26",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"12",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "12",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "13",   "20",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "13",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "13",   "28",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "14",
	"63",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "14",   "63",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "14",   "32",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "01",   "26",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"01",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "01",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "02",   "30",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "02",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "02",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "03",
	"32",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "03",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "03",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "04",   "34",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"04",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "04",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "05",   "34",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "05",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "05",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "06",
	"34",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "06",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "06",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "07",   "34",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"07",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "07",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "08",   "34",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "08",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "08",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "09",
	"32",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "09",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "09",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "10",   "30",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"10",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "10",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "11",   "28",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "11",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "11",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "12",
	"22",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "12",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "12",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "13",   "14",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"13",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "13",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "14",   "63",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "14",   "63",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "14",   "63",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "01",
	"26",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "01",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "01",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "02",   "30",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"02",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "02",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "03",   "32",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "03",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "03",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "04",
	"34",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "04",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "04",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "05",   "34",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"05",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "05",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "06",   "34",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "06",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "06",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "07",
	"34",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "07",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "07",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "08",   "34",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"08",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "08",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "09",   "32",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "09",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "09",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "10",
	"30",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "10",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "10",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "11",   "26",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"11",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "11",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "12",   "20",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "12",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "12",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "13",
	"14",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "13",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "13",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "14",   "63",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"14",   "63",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "14",   "63",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "01",   "26",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "01",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "01",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "02",
	"28",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "02",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "02",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "03",   "30",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"03",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "03",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "04",   "30",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "04",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "04",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "05",
	"32",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "05",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "05",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "06",   "32",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"06",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "06",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "07",   "32",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "07",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "07",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "08",
	"30",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "08",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "08",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "09",   "30",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"09",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "09",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "10",   "28",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "10",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "10",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "11",
	"26",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "11",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "11",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "12",   "20",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"12",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "12",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "13",   "14",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "13",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "13",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "14",
	"63",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "14",   "63",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "14",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "01",   "63",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"01",   "63",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "01",   "63",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "02",   "63",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "02",   "63",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "02",   "63",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "03",
	"26",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "03",   "30",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "03",   "34",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "04",   "26",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"04",   "30",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "04",   "34",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "05",   "30",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "05",   "30",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "05",   "34",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "06",
	"32",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "06",   "30",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "06",   "34",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "07",   "30",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"07",   "30",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "07",   "34",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "08",   "26",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "08",   "30",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "08",   "34",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "09",
	"26",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "09",   "30",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "09",   "34",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "10",   "20",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"10",   "30",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "10",   "34",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "11",   "14",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "11",   "30",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "11",   "34",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "12",
	"63",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "12",   "63",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "12",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "13",   "63",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"13",   "63",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "13",   "63",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "14",   "63",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "14",   "63",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "14",   "63",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "01",
	"63",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "01",   "63",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "01",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "02",   "63",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"02",   "63",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "02",   "63",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "03",   "24",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "03",   "18",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "03",   "30",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "04",
	"24",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "04",   "18",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "04",   "30",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "05",   "26",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"05",   "18",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "05",   "30",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "06",   "28",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "06",   "18",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "06",   "30",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "07",
	"26",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "07",   "18",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "07",   "30",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "08",   "26",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"08",   "18",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "08",   "30",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "09",   "26",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "09",   "18",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "09",   "30",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "10",
	"20",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "10",   "18",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "10",   "30",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "11",   "14",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"11",   "18",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "11",   "30",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "12",   "63",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "12",   "63",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "12",   "63",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "13",
	"63",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "13",   "63",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "13",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "14",   "63",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"14",   "63",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "14",   "63",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "36",   "30",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "36",   "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "36",   "30",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "40",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "40",   "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "40",   "30",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "44",   "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"44",   "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "44",   "30",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "48",   "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "48",   "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "48",   "30",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "52",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "52",   "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "52",   "28",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "56",   "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"56",   "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "56",   "28",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "60",   "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "60",   "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "60",   "28",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "64",
	"28",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "64",   "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "64",   "28",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "100",  "26",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"100",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "100",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "104",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "104",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "104",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "108",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "108",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "108",  "32",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "112",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"112",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "112",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "116",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "116",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "116",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "120",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "120",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "120",  "32",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "124",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"124",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "124",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "128",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "128",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "128",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "132",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "132",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "132",  "32",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "136",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"136",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "136",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "140",  "28",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "140",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "140",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "144",
	"28",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "144",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "144",  "63",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "149",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"149",  "63",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "149",  "63",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "153",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "153",  "63",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "153",  "63",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "157",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "157",  "63",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "157",  "63",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "161",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"161",  "63",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "161",  "63",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "165",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "165",  "63",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "165",  "63",   "FCC",  "5G",   "20M",  "HT",   "1T",   "36",
	"30",   "ETSI", "5G",   "20M",  "HT",   "1T",   "36",   "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "36",   "28",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "40",   "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"40",   "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "40",   "28",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "44",   "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "44",   "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "44",   "28",   "FCC",  "5G",   "20M",  "HT",   "1T",   "48",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "48",   "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "48",   "28",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "52",   "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"52",   "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "52",   "28",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "56",   "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "56",   "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "56",   "28",   "FCC",  "5G",   "20M",  "HT",   "1T",   "60",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "60",   "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "60",   "28",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "64",   "28",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"64",   "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "64",   "28",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "100",  "26",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "100",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "100",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "104",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "104",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "104",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "108",  "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"108",  "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "108",  "32",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "112",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "112",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "112",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "116",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "116",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "116",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "120",  "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"120",  "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "120",  "32",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "124",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "124",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "124",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "128",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "128",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "128",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "132",  "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"132",  "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "132",  "32",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "136",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "136",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "136",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "140",
	"26",   "ETSI", "5G",   "20M",  "HT",   "1T",   "140",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "140",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "144",  "26",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"144",  "63",   "MKK",  "5G",   "20M",  "HT",   "1T",   "144",  "63",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "149",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "149",  "63",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "149",  "63",   "FCC",  "5G",   "20M",  "HT",   "1T",   "153",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "153",  "63",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "153",  "63",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "157",  "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"157",  "63",   "MKK",  "5G",   "20M",  "HT",   "1T",   "157",  "63",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "161",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "161",  "63",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "161",  "63",   "FCC",  "5G",   "20M",  "HT",   "1T",   "165",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "165",  "63",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "165",  "63",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "36",   "28",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"36",   "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "36",   "22",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "40",   "30",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "40",   "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "40",   "22",   "FCC",  "5G",   "20M",  "HT",   "2T",   "44",
	"30",   "ETSI", "5G",   "20M",  "HT",   "2T",   "44",   "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "44",   "22",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "48",   "30",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"48",   "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "48",   "22",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "52",   "30",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "52",   "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "52",   "22",   "FCC",  "5G",   "20M",  "HT",   "2T",   "56",
	"30",   "ETSI", "5G",   "20M",  "HT",   "2T",   "56",   "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "56",   "22",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "60",   "30",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"60",   "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "60",   "22",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "64",   "28",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "64",   "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "64",   "22",   "FCC",  "5G",   "20M",  "HT",   "2T",   "100",
	"26",   "ETSI", "5G",   "20M",  "HT",   "2T",   "100",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "100",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "104",  "30",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"104",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "104",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "108",  "32",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "108",  "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "108",  "30",   "FCC",  "5G",   "20M",  "HT",   "2T",   "112",
	"32",   "ETSI", "5G",   "20M",  "HT",   "2T",   "112",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "112",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "116",  "32",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"116",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "116",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "120",  "32",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "120",  "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "120",  "30",   "FCC",  "5G",   "20M",  "HT",   "2T",   "124",
	"32",   "ETSI", "5G",   "20M",  "HT",   "2T",   "124",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "124",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "128",  "32",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"128",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "128",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "132",  "32",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "132",  "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "132",  "30",   "FCC",  "5G",   "20M",  "HT",   "2T",   "136",
	"30",   "ETSI", "5G",   "20M",  "HT",   "2T",   "136",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "136",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "140",  "26",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"140",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "140",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "144",  "26",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "144",  "63",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "144",  "63",   "FCC",  "5G",   "20M",  "HT",   "2T",   "149",
	"32",   "ETSI", "5G",   "20M",  "HT",   "2T",   "149",  "63",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "149",  "63",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "153",  "32",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"153",  "63",   "MKK",  "5G",   "20M",  "HT",   "2T",   "153",  "63",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "157",  "32",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "157",  "63",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "157",  "63",   "FCC",  "5G",   "20M",  "HT",   "2T",   "161",
	"32",   "ETSI", "5G",   "20M",  "HT",   "2T",   "161",  "63",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "161",  "63",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "165",  "32",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"165",  "63",   "MKK",  "5G",   "20M",  "HT",   "2T",   "165",  "63",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "38",   "22",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "38",   "30",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "38",   "30",   "FCC",  "5G",   "40M",  "HT",   "1T",   "46",
	"30",   "ETSI", "5G",   "40M",  "HT",   "1T",   "46",   "30",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "46",   "30",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "54",   "30",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"54",   "30",   "MKK",  "5G",   "40M",  "HT",   "1T",   "54",   "30",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "62",   "24",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "62",   "30",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "62",   "30",   "FCC",  "5G",   "40M",  "HT",   "1T",   "102",
	"24",   "ETSI", "5G",   "40M",  "HT",   "1T",   "102",  "30",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "102",  "30",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "110",  "30",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"110",  "30",   "MKK",  "5G",   "40M",  "HT",   "1T",   "110",  "30",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "118",  "30",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "118",  "30",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "118",  "30",   "FCC",  "5G",   "40M",  "HT",   "1T",   "126",
	"30",   "ETSI", "5G",   "40M",  "HT",   "1T",   "126",  "30",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "126",  "30",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "134",  "30",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"134",  "30",   "MKK",  "5G",   "40M",  "HT",   "1T",   "134",  "30",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "142",  "30",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "142",  "63",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "142",  "63",   "FCC",  "5G",   "40M",  "HT",   "1T",   "151",
	"30",   "ETSI", "5G",   "40M",  "HT",   "1T",   "151",  "63",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "151",  "63",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "159",  "30",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"159",  "63",   "MKK",  "5G",   "40M",  "HT",   "1T",   "159",  "63",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "38",   "20",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "38",   "20",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "38",   "22",   "FCC",  "5G",   "40M",  "HT",   "2T",   "46",
	"30",   "ETSI", "5G",   "40M",  "HT",   "2T",   "46",   "20",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "46",   "22",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "54",   "30",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"54",   "20",   "MKK",  "5G",   "40M",  "HT",   "2T",   "54",   "22",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "62",   "22",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "62",   "20",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "62",   "22",   "FCC",  "5G",   "40M",  "HT",   "2T",   "102",
	"22",   "ETSI", "5G",   "40M",  "HT",   "2T",   "102",  "20",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "102",  "30",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "110",  "30",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"110",  "20",   "MKK",  "5G",   "40M",  "HT",   "2T",   "110",  "30",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "118",  "30",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "118",  "20",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "118",  "30",   "FCC",  "5G",   "40M",  "HT",   "2T",   "126",
	"30",   "ETSI", "5G",   "40M",  "HT",   "2T",   "126",  "20",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "126",  "30",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "134",  "30",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"134",  "20",   "MKK",  "5G",   "40M",  "HT",   "2T",   "134",  "30",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "142",  "30",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "142",  "63",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "142",  "63",   "FCC",  "5G",   "40M",  "HT",   "2T",   "151",
	"30",   "ETSI", "5G",   "40M",  "HT",   "2T",   "151",  "63",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "151",  "63",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "159",  "30",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"159",  "63",   "MKK",  "5G",   "40M",  "HT",   "2T",   "159",  "63",
	"FCC",  "5G",   "80M",  "VHT",  "1T",   "42",   "20",   "ETSI", "5G",
	"80M",  "VHT",  "1T",   "42",   "30",   "MKK",  "5G",   "80M",  "VHT",
	"1T",   "42",   "28",   "FCC",  "5G",   "80M",  "VHT",  "1T",   "58",
	"20",   "ETSI", "5G",   "80M",  "VHT",  "1T",   "58",   "30",   "MKK",
	"5G",   "80M",  "VHT",  "1T",   "58",   "28",   "FCC",  "5G",   "80M",
	"VHT",  "1T",   "106",  "20",   "ETSI", "5G",   "80M",  "VHT",  "1T",
	"106",  "30",   "MKK",  "5G",   "80M",  "VHT",  "1T",   "106",  "30",
	"FCC",  "5G",   "80M",  "VHT",  "1T",   "122",  "30",   "ETSI", "5G",
	"80M",  "VHT",  "1T",   "122",  "30",   "MKK",  "5G",   "80M",  "VHT",
	"1T",   "122",  "30",   "FCC",  "5G",   "80M",  "VHT",  "1T",   "138",
	"30",   "ETSI", "5G",   "80M",  "VHT",  "1T",   "138",  "63",   "MKK",
	"5G",   "80M",  "VHT",  "1T",   "138",  "63",   "FCC",  "5G",   "80M",
	"VHT",  "1T",   "155",  "30",   "ETSI", "5G",   "80M",  "VHT",  "1T",
	"155",  "63",   "MKK",  "5G",   "80M",  "VHT",  "1T",   "155",  "63",
	"FCC",  "5G",   "80M",  "VHT",  "2T",   "42",   "18",   "ETSI", "5G",
	"80M",  "VHT",  "2T",   "42",   "20",   "MKK",  "5G",   "80M",  "VHT",
	"2T",   "42",   "22",   "FCC",  "5G",   "80M",  "VHT",  "2T",   "58",
	"18",   "ETSI", "5G",   "80M",  "VHT",  "2T",   "58",   "20",   "MKK",
	"5G",   "80M",  "VHT",  "2T",   "58",   "22",   "FCC",  "5G",   "80M",
	"VHT",  "2T",   "106",  "20",   "ETSI", "5G",   "80M",  "VHT",  "2T",
	"106",  "20",   "MKK",  "5G",   "80M",  "VHT",  "2T",   "106",  "30",
	"FCC",  "5G",   "80M",  "VHT",  "2T",   "122",  "30",   "ETSI", "5G",
	"80M",  "VHT",  "2T",   "122",  "20",   "MKK",  "5G",   "80M",  "VHT",
	"2T",   "122",  "30",   "FCC",  "5G",   "80M",  "VHT",  "2T",   "138",
	"30",   "ETSI", "5G",   "80M",  "VHT",  "2T",   "138",  "63",   "MKK",
	"5G",   "80M",  "VHT",  "2T",   "138",  "63",   "FCC",  "5G",   "80M",
	"VHT",  "2T",   "155",  "30",   "ETSI", "5G",   "80M",  "VHT",  "2T",
	"155",  "63",   "MKK",  "5G",   "80M",  "VHT",  "2T",   "155",  "63"};

void odm_read_and_config_mp_8822b_txpwr_lmt(struct PHY_DM_STRUCT *p_dm_odm)
{
	u32 i = 0;
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
	u32	array_len = sizeof(array_mp_8822b_txpwr_lmt)/sizeof(u8);
	u8	*array = (u8 *)array_mp_8822b_txpwr_lmt;
#else
	u32 array_len = sizeof(array_mp_8822b_txpwr_lmt) / sizeof(u8 *);
	u8 **array = (u8 **)array_mp_8822b_txpwr_lmt;
#endif

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	struct _ADAPTER	*adapter = p_dm_odm->adapter;
	HAL_DATA_TYPE	*p_hal_data = GET_HAL_DATA(adapter);

	PlatformZeroMemory(p_hal_data->BufOfLinesPwrLmt, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	p_hal_data->nLinesReadPwrLmt = array_len/7;
#endif

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> odm_read_and_config_mp_8822b_txpwr_lmt\n"));

	for (i = 0; i < array_len; i += 7) {
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
		u8	regulation = array[i];
		u8	band = array[i+1];
		u8	bandwidth = array[i+2];
		u8	rate = array[i+3];
		u8	rf_path = array[i+4];
		u8	chnl = array[i+5];
		u8	val = array[i+6];
#else
		u8 *regulation = array[i];
		u8 *band = array[i + 1];
		u8 *bandwidth = array[i + 2];
		u8 *rate = array[i + 3];
		u8 *rf_path = array[i + 4];
		u8 *chnl = array[i + 5];
		u8 *val = array[i + 6];
#endif

		odm_config_bb_txpwr_lmt_8822b(p_dm_odm, regulation, band,
					      bandwidth, rate, rf_path, chnl,
					      val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)p_hal_data->BufOfLinesPwrLmt[i/7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
		regulation, band, bandwidth, rate, rf_path, chnl, val);
#endif
	}
}

/******************************************************************************
*                           txpwr_lmt_type12.TXT
******************************************************************************/

const char *array_mp_8822b_txpwr_lmt_type12[] = {
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "01",   "32",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "01",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "01",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "02",
	"32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "02",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "02",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "03",   "32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"03",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "03",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "04",   "32",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "04",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "04",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "05",
	"32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "05",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "05",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "06",   "32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"06",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "06",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "07",   "32",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "07",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "07",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "08",
	"32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "08",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "08",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "09",   "32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"09",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "09",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "10",   "32",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "10",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "10",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "11",
	"32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "11",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "11",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "12",   "26",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"12",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "12",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "13",   "20",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "13",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "13",   "28",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "14",
	"63",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "14",   "63",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "14",   "32",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "01",   "26",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"01",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "01",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "02",   "30",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "02",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "02",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "03",
	"32",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "03",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "03",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "04",   "34",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"04",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "04",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "05",   "34",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "05",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "05",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "06",
	"34",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "06",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "06",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "07",   "34",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"07",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "07",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "08",   "34",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "08",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "08",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "09",
	"32",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "09",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "09",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "10",   "30",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"10",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "10",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "11",   "28",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "11",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "11",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "12",
	"22",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "12",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "12",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "13",   "14",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"13",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "13",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "14",   "63",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "14",   "63",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "14",   "63",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "01",
	"26",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "01",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "01",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "02",   "30",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"02",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "02",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "03",   "32",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "03",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "03",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "04",
	"34",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "04",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "04",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "05",   "34",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"05",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "05",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "06",   "34",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "06",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "06",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "07",
	"34",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "07",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "07",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "08",   "34",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"08",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "08",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "09",   "32",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "09",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "09",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "10",
	"30",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "10",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "10",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "11",   "26",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"11",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "11",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "12",   "20",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "12",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "12",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "13",
	"14",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "13",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "13",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "14",   "63",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"14",   "63",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "14",   "63",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "01",   "26",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "01",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "01",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "02",
	"28",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "02",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "02",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "03",   "30",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"03",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "03",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "04",   "30",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "04",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "04",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "05",
	"32",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "05",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "05",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "06",   "32",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"06",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "06",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "07",   "32",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "07",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "07",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "08",
	"30",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "08",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "08",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "09",   "30",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"09",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "09",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "10",   "28",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "10",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "10",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "11",
	"26",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "11",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "11",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "12",   "20",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"12",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "12",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "13",   "14",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "13",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "13",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "14",
	"63",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "14",   "63",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "14",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "01",   "63",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"01",   "63",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "01",   "63",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "02",   "63",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "02",   "63",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "02",   "63",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "03",
	"26",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "03",   "30",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "03",   "34",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "04",   "26",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"04",   "30",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "04",   "34",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "05",   "30",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "05",   "30",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "05",   "34",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "06",
	"32",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "06",   "30",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "06",   "34",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "07",   "30",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"07",   "30",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "07",   "34",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "08",   "26",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "08",   "30",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "08",   "34",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "09",
	"26",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "09",   "30",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "09",   "34",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "10",   "20",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"10",   "30",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "10",   "34",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "11",   "14",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "11",   "30",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "11",   "34",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "12",
	"63",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "12",   "63",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "12",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "13",   "63",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"13",   "63",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "13",   "63",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "14",   "63",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "14",   "63",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "14",   "63",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "01",
	"63",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "01",   "63",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "01",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "02",   "63",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"02",   "63",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "02",   "63",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "03",   "24",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "03",   "18",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "03",   "30",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "04",
	"24",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "04",   "18",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "04",   "30",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "05",   "26",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"05",   "18",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "05",   "30",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "06",   "28",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "06",   "18",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "06",   "30",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "07",
	"26",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "07",   "18",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "07",   "30",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "08",   "26",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"08",   "18",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "08",   "30",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "09",   "26",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "09",   "18",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "09",   "30",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "10",
	"20",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "10",   "18",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "10",   "30",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "11",   "14",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"11",   "18",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "11",   "30",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "12",   "63",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "12",   "63",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "12",   "63",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "13",
	"63",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "13",   "63",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "13",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "14",   "63",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"14",   "63",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "14",   "63",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "36",   "30",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "36",   "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "36",   "30",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "40",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "40",   "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "40",   "30",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "44",   "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"44",   "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "44",   "30",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "48",   "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "48",   "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "48",   "30",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "52",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "52",   "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "52",   "28",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "56",   "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"56",   "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "56",   "28",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "60",   "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "60",   "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "60",   "28",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "64",
	"28",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "64",   "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "64",   "28",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "100",  "26",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"100",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "100",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "104",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "104",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "104",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "108",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "108",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "108",  "32",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "112",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"112",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "112",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "116",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "116",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "116",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "120",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "120",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "120",  "32",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "124",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"124",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "124",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "128",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "128",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "128",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "132",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "132",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "132",  "32",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "136",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"136",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "136",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "140",  "28",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "140",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "140",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "144",
	"28",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "144",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "144",  "63",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "149",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"149",  "63",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "149",  "63",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "153",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "153",  "63",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "153",  "63",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "157",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "157",  "63",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "157",  "63",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "161",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"161",  "63",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "161",  "63",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "165",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "165",  "63",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "165",  "63",   "FCC",  "5G",   "20M",  "HT",   "1T",   "36",
	"30",   "ETSI", "5G",   "20M",  "HT",   "1T",   "36",   "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "36",   "28",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "40",   "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"40",   "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "40",   "28",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "44",   "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "44",   "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "44",   "28",   "FCC",  "5G",   "20M",  "HT",   "1T",   "48",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "48",   "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "48",   "28",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "52",   "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"52",   "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "52",   "28",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "56",   "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "56",   "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "56",   "28",   "FCC",  "5G",   "20M",  "HT",   "1T",   "60",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "60",   "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "60",   "28",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "64",   "28",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"64",   "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "64",   "28",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "100",  "26",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "100",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "100",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "104",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "104",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "104",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "108",  "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"108",  "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "108",  "32",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "112",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "112",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "112",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "116",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "116",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "116",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "120",  "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"120",  "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "120",  "32",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "124",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "124",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "124",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "128",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "128",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "128",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "132",  "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"132",  "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "132",  "32",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "136",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "136",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "136",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "140",
	"26",   "ETSI", "5G",   "20M",  "HT",   "1T",   "140",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "140",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "144",  "26",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"144",  "63",   "MKK",  "5G",   "20M",  "HT",   "1T",   "144",  "63",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "149",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "149",  "63",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "149",  "63",   "FCC",  "5G",   "20M",  "HT",   "1T",   "153",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "153",  "63",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "153",  "63",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "157",  "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"157",  "63",   "MKK",  "5G",   "20M",  "HT",   "1T",   "157",  "63",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "161",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "161",  "63",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "161",  "63",   "FCC",  "5G",   "20M",  "HT",   "1T",   "165",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "165",  "63",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "165",  "63",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "36",   "28",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"36",   "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "36",   "22",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "40",   "30",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "40",   "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "40",   "22",   "FCC",  "5G",   "20M",  "HT",   "2T",   "44",
	"30",   "ETSI", "5G",   "20M",  "HT",   "2T",   "44",   "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "44",   "22",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "48",   "30",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"48",   "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "48",   "22",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "52",   "30",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "52",   "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "52",   "22",   "FCC",  "5G",   "20M",  "HT",   "2T",   "56",
	"30",   "ETSI", "5G",   "20M",  "HT",   "2T",   "56",   "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "56",   "22",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "60",   "30",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"60",   "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "60",   "22",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "64",   "28",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "64",   "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "64",   "22",   "FCC",  "5G",   "20M",  "HT",   "2T",   "100",
	"26",   "ETSI", "5G",   "20M",  "HT",   "2T",   "100",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "100",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "104",  "30",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"104",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "104",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "108",  "32",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "108",  "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "108",  "30",   "FCC",  "5G",   "20M",  "HT",   "2T",   "112",
	"32",   "ETSI", "5G",   "20M",  "HT",   "2T",   "112",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "112",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "116",  "32",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"116",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "116",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "120",  "32",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "120",  "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "120",  "30",   "FCC",  "5G",   "20M",  "HT",   "2T",   "124",
	"32",   "ETSI", "5G",   "20M",  "HT",   "2T",   "124",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "124",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "128",  "32",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"128",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "128",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "132",  "32",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "132",  "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "132",  "30",   "FCC",  "5G",   "20M",  "HT",   "2T",   "136",
	"30",   "ETSI", "5G",   "20M",  "HT",   "2T",   "136",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "136",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "140",  "26",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"140",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "140",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "144",  "26",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "144",  "63",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "144",  "63",   "FCC",  "5G",   "20M",  "HT",   "2T",   "149",
	"32",   "ETSI", "5G",   "20M",  "HT",   "2T",   "149",  "63",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "149",  "63",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "153",  "32",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"153",  "63",   "MKK",  "5G",   "20M",  "HT",   "2T",   "153",  "63",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "157",  "32",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "157",  "63",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "157",  "63",   "FCC",  "5G",   "20M",  "HT",   "2T",   "161",
	"32",   "ETSI", "5G",   "20M",  "HT",   "2T",   "161",  "63",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "161",  "63",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "165",  "32",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"165",  "63",   "MKK",  "5G",   "20M",  "HT",   "2T",   "165",  "63",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "38",   "22",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "38",   "30",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "38",   "30",   "FCC",  "5G",   "40M",  "HT",   "1T",   "46",
	"30",   "ETSI", "5G",   "40M",  "HT",   "1T",   "46",   "30",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "46",   "30",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "54",   "30",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"54",   "30",   "MKK",  "5G",   "40M",  "HT",   "1T",   "54",   "30",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "62",   "24",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "62",   "30",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "62",   "30",   "FCC",  "5G",   "40M",  "HT",   "1T",   "102",
	"24",   "ETSI", "5G",   "40M",  "HT",   "1T",   "102",  "30",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "102",  "30",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "110",  "30",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"110",  "30",   "MKK",  "5G",   "40M",  "HT",   "1T",   "110",  "30",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "118",  "30",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "118",  "30",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "118",  "30",   "FCC",  "5G",   "40M",  "HT",   "1T",   "126",
	"30",   "ETSI", "5G",   "40M",  "HT",   "1T",   "126",  "30",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "126",  "30",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "134",  "30",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"134",  "30",   "MKK",  "5G",   "40M",  "HT",   "1T",   "134",  "30",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "142",  "30",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "142",  "63",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "142",  "63",   "FCC",  "5G",   "40M",  "HT",   "1T",   "151",
	"30",   "ETSI", "5G",   "40M",  "HT",   "1T",   "151",  "63",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "151",  "63",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "159",  "30",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"159",  "63",   "MKK",  "5G",   "40M",  "HT",   "1T",   "159",  "63",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "38",   "20",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "38",   "20",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "38",   "22",   "FCC",  "5G",   "40M",  "HT",   "2T",   "46",
	"30",   "ETSI", "5G",   "40M",  "HT",   "2T",   "46",   "20",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "46",   "22",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "54",   "30",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"54",   "20",   "MKK",  "5G",   "40M",  "HT",   "2T",   "54",   "22",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "62",   "22",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "62",   "20",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "62",   "22",   "FCC",  "5G",   "40M",  "HT",   "2T",   "102",
	"22",   "ETSI", "5G",   "40M",  "HT",   "2T",   "102",  "20",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "102",  "30",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "110",  "30",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"110",  "20",   "MKK",  "5G",   "40M",  "HT",   "2T",   "110",  "30",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "118",  "30",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "118",  "20",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "118",  "30",   "FCC",  "5G",   "40M",  "HT",   "2T",   "126",
	"30",   "ETSI", "5G",   "40M",  "HT",   "2T",   "126",  "20",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "126",  "30",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "134",  "30",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"134",  "20",   "MKK",  "5G",   "40M",  "HT",   "2T",   "134",  "30",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "142",  "30",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "142",  "63",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "142",  "63",   "FCC",  "5G",   "40M",  "HT",   "2T",   "151",
	"30",   "ETSI", "5G",   "40M",  "HT",   "2T",   "151",  "63",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "151",  "63",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "159",  "30",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"159",  "63",   "MKK",  "5G",   "40M",  "HT",   "2T",   "159",  "63",
	"FCC",  "5G",   "80M",  "VHT",  "1T",   "42",   "20",   "ETSI", "5G",
	"80M",  "VHT",  "1T",   "42",   "30",   "MKK",  "5G",   "80M",  "VHT",
	"1T",   "42",   "28",   "FCC",  "5G",   "80M",  "VHT",  "1T",   "58",
	"20",   "ETSI", "5G",   "80M",  "VHT",  "1T",   "58",   "30",   "MKK",
	"5G",   "80M",  "VHT",  "1T",   "58",   "28",   "FCC",  "5G",   "80M",
	"VHT",  "1T",   "106",  "20",   "ETSI", "5G",   "80M",  "VHT",  "1T",
	"106",  "30",   "MKK",  "5G",   "80M",  "VHT",  "1T",   "106",  "30",
	"FCC",  "5G",   "80M",  "VHT",  "1T",   "122",  "30",   "ETSI", "5G",
	"80M",  "VHT",  "1T",   "122",  "30",   "MKK",  "5G",   "80M",  "VHT",
	"1T",   "122",  "30",   "FCC",  "5G",   "80M",  "VHT",  "1T",   "138",
	"30",   "ETSI", "5G",   "80M",  "VHT",  "1T",   "138",  "63",   "MKK",
	"5G",   "80M",  "VHT",  "1T",   "138",  "63",   "FCC",  "5G",   "80M",
	"VHT",  "1T",   "155",  "30",   "ETSI", "5G",   "80M",  "VHT",  "1T",
	"155",  "63",   "MKK",  "5G",   "80M",  "VHT",  "1T",   "155",  "63",
	"FCC",  "5G",   "80M",  "VHT",  "2T",   "42",   "18",   "ETSI", "5G",
	"80M",  "VHT",  "2T",   "42",   "20",   "MKK",  "5G",   "80M",  "VHT",
	"2T",   "42",   "22",   "FCC",  "5G",   "80M",  "VHT",  "2T",   "58",
	"18",   "ETSI", "5G",   "80M",  "VHT",  "2T",   "58",   "20",   "MKK",
	"5G",   "80M",  "VHT",  "2T",   "58",   "22",   "FCC",  "5G",   "80M",
	"VHT",  "2T",   "106",  "20",   "ETSI", "5G",   "80M",  "VHT",  "2T",
	"106",  "20",   "MKK",  "5G",   "80M",  "VHT",  "2T",   "106",  "30",
	"FCC",  "5G",   "80M",  "VHT",  "2T",   "122",  "30",   "ETSI", "5G",
	"80M",  "VHT",  "2T",   "122",  "20",   "MKK",  "5G",   "80M",  "VHT",
	"2T",   "122",  "30",   "FCC",  "5G",   "80M",  "VHT",  "2T",   "138",
	"30",   "ETSI", "5G",   "80M",  "VHT",  "2T",   "138",  "63",   "MKK",
	"5G",   "80M",  "VHT",  "2T",   "138",  "63",   "FCC",  "5G",   "80M",
	"VHT",  "2T",   "155",  "30",   "ETSI", "5G",   "80M",  "VHT",  "2T",
	"155",  "63",   "MKK",  "5G",   "80M",  "VHT",  "2T",   "155",  "63"};

void odm_read_and_config_mp_8822b_txpwr_lmt_type12(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	u32 i = 0;
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
	u32	array_len = sizeof(array_mp_8822b_txpwr_lmt_type12)/sizeof(u8);
	u8	*array = (u8 *)array_mp_8822b_txpwr_lmt_type12;
#else
	u32 array_len = sizeof(array_mp_8822b_txpwr_lmt_type12) / sizeof(u8 *);
	u8 **array = (u8 **)array_mp_8822b_txpwr_lmt_type12;
#endif

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	struct _ADAPTER	*adapter = p_dm_odm->adapter;
	HAL_DATA_TYPE	*p_hal_data = GET_HAL_DATA(adapter);

	PlatformZeroMemory(p_hal_data->BufOfLinesPwrLmt, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	p_hal_data->nLinesReadPwrLmt = array_len/7;
#endif

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> odm_read_and_config_mp_8822b_txpwr_lmt_type12\n"));

	for (i = 0; i < array_len; i += 7) {
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
		u8	regulation = array[i];
		u8	band = array[i+1];
		u8	bandwidth = array[i+2];
		u8	rate = array[i+3];
		u8	rf_path = array[i+4];
		u8	chnl = array[i+5];
		u8	val = array[i+6];
#else
		u8 *regulation = array[i];
		u8 *band = array[i + 1];
		u8 *bandwidth = array[i + 2];
		u8 *rate = array[i + 3];
		u8 *rf_path = array[i + 4];
		u8 *chnl = array[i + 5];
		u8 *val = array[i + 6];
#endif

		odm_config_bb_txpwr_lmt_8822b(p_dm_odm, regulation, band,
					      bandwidth, rate, rf_path, chnl,
					      val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)p_hal_data->BufOfLinesPwrLmt[i/7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
		regulation, band, bandwidth, rate, rf_path, chnl, val);
#endif
	}
}

/******************************************************************************
*                           txpwr_lmt_type15.TXT
******************************************************************************/

const char *array_mp_8822b_txpwr_lmt_type15[] = {
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "01",   "32",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "01",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "01",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "02",
	"32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "02",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "02",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "03",   "32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"03",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "03",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "04",   "32",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "04",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "04",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "05",
	"32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "05",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "05",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "06",   "32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"06",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "06",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "07",   "32",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "07",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "07",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "08",
	"32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "08",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "08",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "09",   "32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"09",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "09",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "10",   "32",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "10",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "10",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "11",
	"32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "11",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "11",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "12",   "26",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"12",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "12",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "13",   "20",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "13",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "13",   "28",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "14",
	"63",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "14",   "63",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "14",   "32",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "01",   "26",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"01",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "01",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "02",   "30",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "02",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "02",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "03",
	"32",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "03",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "03",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "04",   "34",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"04",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "04",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "05",   "34",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "05",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "05",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "06",
	"34",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "06",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "06",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "07",   "34",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"07",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "07",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "08",   "34",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "08",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "08",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "09",
	"32",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "09",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "09",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "10",   "30",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"10",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "10",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "11",   "28",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "11",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "11",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "12",
	"22",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "12",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "12",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "13",   "14",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"13",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "13",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "14",   "63",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "14",   "63",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "14",   "63",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "01",
	"26",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "01",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "01",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "02",   "30",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"02",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "02",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "03",   "32",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "03",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "03",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "04",
	"34",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "04",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "04",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "05",   "34",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"05",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "05",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "06",   "34",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "06",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "06",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "07",
	"34",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "07",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "07",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "08",   "34",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"08",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "08",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "09",   "32",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "09",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "09",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "10",
	"30",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "10",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "10",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "11",   "26",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"11",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "11",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "12",   "20",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "12",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "12",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "13",
	"14",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "13",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "13",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "14",   "63",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"14",   "63",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "14",   "63",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "01",   "26",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "01",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "01",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "02",
	"28",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "02",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "02",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "03",   "30",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"03",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "03",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "04",   "30",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "04",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "04",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "05",
	"32",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "05",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "05",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "06",   "32",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"06",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "06",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "07",   "32",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "07",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "07",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "08",
	"30",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "08",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "08",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "09",   "30",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"09",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "09",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "10",   "28",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "10",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "10",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "11",
	"26",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "11",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "11",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "12",   "20",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"12",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "12",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "13",   "14",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "13",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "13",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "14",
	"63",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "14",   "63",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "14",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "01",   "63",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"01",   "63",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "01",   "63",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "02",   "63",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "02",   "63",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "02",   "63",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "03",
	"26",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "03",   "30",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "03",   "34",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "04",   "26",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"04",   "30",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "04",   "34",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "05",   "30",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "05",   "30",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "05",   "34",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "06",
	"32",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "06",   "30",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "06",   "34",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "07",   "30",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"07",   "30",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "07",   "34",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "08",   "26",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "08",   "30",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "08",   "34",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "09",
	"26",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "09",   "30",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "09",   "34",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "10",   "20",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"10",   "30",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "10",   "34",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "11",   "14",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "11",   "30",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "11",   "34",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "12",
	"63",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "12",   "63",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "12",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "13",   "63",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"13",   "63",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "13",   "63",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "14",   "63",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "14",   "63",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "14",   "63",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "01",
	"63",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "01",   "63",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "01",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "02",   "63",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"02",   "63",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "02",   "63",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "03",   "24",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "03",   "18",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "03",   "30",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "04",
	"24",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "04",   "18",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "04",   "30",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "05",   "26",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"05",   "18",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "05",   "30",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "06",   "28",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "06",   "18",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "06",   "30",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "07",
	"26",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "07",   "18",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "07",   "30",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "08",   "26",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"08",   "18",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "08",   "30",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "09",   "26",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "09",   "18",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "09",   "30",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "10",
	"20",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "10",   "18",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "10",   "30",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "11",   "14",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"11",   "18",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "11",   "30",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "12",   "63",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "12",   "63",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "12",   "63",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "13",
	"63",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "13",   "63",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "13",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "14",   "63",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"14",   "63",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "14",   "63",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "36",   "30",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "36",   "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "36",   "30",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "40",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "40",   "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "40",   "30",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "44",   "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"44",   "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "44",   "30",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "48",   "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "48",   "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "48",   "30",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "52",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "52",   "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "52",   "28",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "56",   "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"56",   "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "56",   "28",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "60",   "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "60",   "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "60",   "28",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "64",
	"28",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "64",   "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "64",   "28",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "100",  "26",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"100",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "100",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "104",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "104",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "104",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "108",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "108",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "108",  "32",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "112",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"112",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "112",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "116",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "116",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "116",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "120",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "120",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "120",  "32",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "124",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"124",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "124",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "128",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "128",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "128",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "132",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "132",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "132",  "32",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "136",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"136",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "136",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "140",  "28",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "140",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "140",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "144",
	"28",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "144",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "144",  "63",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "149",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"149",  "63",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "149",  "63",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "153",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "153",  "63",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "153",  "63",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "157",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "157",  "63",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "157",  "63",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "161",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"161",  "63",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "161",  "63",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "165",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "165",  "63",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "165",  "63",   "FCC",  "5G",   "20M",  "HT",   "1T",   "36",
	"30",   "ETSI", "5G",   "20M",  "HT",   "1T",   "36",   "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "36",   "28",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "40",   "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"40",   "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "40",   "28",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "44",   "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "44",   "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "44",   "28",   "FCC",  "5G",   "20M",  "HT",   "1T",   "48",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "48",   "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "48",   "28",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "52",   "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"52",   "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "52",   "28",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "56",   "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "56",   "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "56",   "28",   "FCC",  "5G",   "20M",  "HT",   "1T",   "60",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "60",   "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "60",   "28",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "64",   "28",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"64",   "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "64",   "28",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "100",  "26",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "100",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "100",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "104",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "104",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "104",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "108",  "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"108",  "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "108",  "32",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "112",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "112",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "112",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "116",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "116",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "116",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "120",  "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"120",  "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "120",  "32",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "124",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "124",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "124",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "128",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "128",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "128",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "132",  "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"132",  "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "132",  "32",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "136",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "136",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "136",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "140",
	"26",   "ETSI", "5G",   "20M",  "HT",   "1T",   "140",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "140",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "144",  "26",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"144",  "63",   "MKK",  "5G",   "20M",  "HT",   "1T",   "144",  "63",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "149",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "149",  "63",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "149",  "63",   "FCC",  "5G",   "20M",  "HT",   "1T",   "153",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "153",  "63",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "153",  "63",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "157",  "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"157",  "63",   "MKK",  "5G",   "20M",  "HT",   "1T",   "157",  "63",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "161",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "161",  "63",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "161",  "63",   "FCC",  "5G",   "20M",  "HT",   "1T",   "165",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "165",  "63",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "165",  "63",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "36",   "28",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"36",   "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "36",   "22",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "40",   "30",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "40",   "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "40",   "22",   "FCC",  "5G",   "20M",  "HT",   "2T",   "44",
	"30",   "ETSI", "5G",   "20M",  "HT",   "2T",   "44",   "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "44",   "22",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "48",   "30",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"48",   "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "48",   "22",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "52",   "30",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "52",   "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "52",   "22",   "FCC",  "5G",   "20M",  "HT",   "2T",   "56",
	"30",   "ETSI", "5G",   "20M",  "HT",   "2T",   "56",   "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "56",   "22",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "60",   "30",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"60",   "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "60",   "22",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "64",   "28",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "64",   "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "64",   "22",   "FCC",  "5G",   "20M",  "HT",   "2T",   "100",
	"26",   "ETSI", "5G",   "20M",  "HT",   "2T",   "100",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "100",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "104",  "30",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"104",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "104",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "108",  "32",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "108",  "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "108",  "30",   "FCC",  "5G",   "20M",  "HT",   "2T",   "112",
	"32",   "ETSI", "5G",   "20M",  "HT",   "2T",   "112",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "112",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "116",  "32",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"116",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "116",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "120",  "32",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "120",  "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "120",  "30",   "FCC",  "5G",   "20M",  "HT",   "2T",   "124",
	"32",   "ETSI", "5G",   "20M",  "HT",   "2T",   "124",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "124",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "128",  "32",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"128",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "128",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "132",  "32",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "132",  "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "132",  "30",   "FCC",  "5G",   "20M",  "HT",   "2T",   "136",
	"30",   "ETSI", "5G",   "20M",  "HT",   "2T",   "136",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "136",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "140",  "26",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"140",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "140",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "144",  "26",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "144",  "63",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "144",  "63",   "FCC",  "5G",   "20M",  "HT",   "2T",   "149",
	"32",   "ETSI", "5G",   "20M",  "HT",   "2T",   "149",  "63",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "149",  "63",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "153",  "32",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"153",  "63",   "MKK",  "5G",   "20M",  "HT",   "2T",   "153",  "63",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "157",  "32",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "157",  "63",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "157",  "63",   "FCC",  "5G",   "20M",  "HT",   "2T",   "161",
	"32",   "ETSI", "5G",   "20M",  "HT",   "2T",   "161",  "63",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "161",  "63",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "165",  "32",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"165",  "63",   "MKK",  "5G",   "20M",  "HT",   "2T",   "165",  "63",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "38",   "22",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "38",   "30",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "38",   "30",   "FCC",  "5G",   "40M",  "HT",   "1T",   "46",
	"30",   "ETSI", "5G",   "40M",  "HT",   "1T",   "46",   "30",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "46",   "30",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "54",   "30",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"54",   "30",   "MKK",  "5G",   "40M",  "HT",   "1T",   "54",   "30",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "62",   "24",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "62",   "30",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "62",   "30",   "FCC",  "5G",   "40M",  "HT",   "1T",   "102",
	"24",   "ETSI", "5G",   "40M",  "HT",   "1T",   "102",  "30",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "102",  "30",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "110",  "30",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"110",  "30",   "MKK",  "5G",   "40M",  "HT",   "1T",   "110",  "30",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "118",  "30",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "118",  "30",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "118",  "30",   "FCC",  "5G",   "40M",  "HT",   "1T",   "126",
	"30",   "ETSI", "5G",   "40M",  "HT",   "1T",   "126",  "30",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "126",  "30",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "134",  "30",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"134",  "30",   "MKK",  "5G",   "40M",  "HT",   "1T",   "134",  "30",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "142",  "30",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "142",  "63",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "142",  "63",   "FCC",  "5G",   "40M",  "HT",   "1T",   "151",
	"30",   "ETSI", "5G",   "40M",  "HT",   "1T",   "151",  "63",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "151",  "63",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "159",  "30",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"159",  "63",   "MKK",  "5G",   "40M",  "HT",   "1T",   "159",  "63",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "38",   "20",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "38",   "20",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "38",   "22",   "FCC",  "5G",   "40M",  "HT",   "2T",   "46",
	"30",   "ETSI", "5G",   "40M",  "HT",   "2T",   "46",   "20",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "46",   "22",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "54",   "30",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"54",   "20",   "MKK",  "5G",   "40M",  "HT",   "2T",   "54",   "22",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "62",   "22",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "62",   "20",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "62",   "22",   "FCC",  "5G",   "40M",  "HT",   "2T",   "102",
	"22",   "ETSI", "5G",   "40M",  "HT",   "2T",   "102",  "20",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "102",  "30",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "110",  "30",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"110",  "20",   "MKK",  "5G",   "40M",  "HT",   "2T",   "110",  "30",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "118",  "30",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "118",  "20",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "118",  "30",   "FCC",  "5G",   "40M",  "HT",   "2T",   "126",
	"30",   "ETSI", "5G",   "40M",  "HT",   "2T",   "126",  "20",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "126",  "30",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "134",  "30",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"134",  "20",   "MKK",  "5G",   "40M",  "HT",   "2T",   "134",  "30",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "142",  "30",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "142",  "63",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "142",  "63",   "FCC",  "5G",   "40M",  "HT",   "2T",   "151",
	"30",   "ETSI", "5G",   "40M",  "HT",   "2T",   "151",  "63",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "151",  "63",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "159",  "30",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"159",  "63",   "MKK",  "5G",   "40M",  "HT",   "2T",   "159",  "63",
	"FCC",  "5G",   "80M",  "VHT",  "1T",   "42",   "20",   "ETSI", "5G",
	"80M",  "VHT",  "1T",   "42",   "30",   "MKK",  "5G",   "80M",  "VHT",
	"1T",   "42",   "28",   "FCC",  "5G",   "80M",  "VHT",  "1T",   "58",
	"20",   "ETSI", "5G",   "80M",  "VHT",  "1T",   "58",   "30",   "MKK",
	"5G",   "80M",  "VHT",  "1T",   "58",   "28",   "FCC",  "5G",   "80M",
	"VHT",  "1T",   "106",  "20",   "ETSI", "5G",   "80M",  "VHT",  "1T",
	"106",  "30",   "MKK",  "5G",   "80M",  "VHT",  "1T",   "106",  "30",
	"FCC",  "5G",   "80M",  "VHT",  "1T",   "122",  "30",   "ETSI", "5G",
	"80M",  "VHT",  "1T",   "122",  "30",   "MKK",  "5G",   "80M",  "VHT",
	"1T",   "122",  "30",   "FCC",  "5G",   "80M",  "VHT",  "1T",   "138",
	"30",   "ETSI", "5G",   "80M",  "VHT",  "1T",   "138",  "63",   "MKK",
	"5G",   "80M",  "VHT",  "1T",   "138",  "63",   "FCC",  "5G",   "80M",
	"VHT",  "1T",   "155",  "30",   "ETSI", "5G",   "80M",  "VHT",  "1T",
	"155",  "63",   "MKK",  "5G",   "80M",  "VHT",  "1T",   "155",  "63",
	"FCC",  "5G",   "80M",  "VHT",  "2T",   "42",   "18",   "ETSI", "5G",
	"80M",  "VHT",  "2T",   "42",   "20",   "MKK",  "5G",   "80M",  "VHT",
	"2T",   "42",   "22",   "FCC",  "5G",   "80M",  "VHT",  "2T",   "58",
	"18",   "ETSI", "5G",   "80M",  "VHT",  "2T",   "58",   "20",   "MKK",
	"5G",   "80M",  "VHT",  "2T",   "58",   "22",   "FCC",  "5G",   "80M",
	"VHT",  "2T",   "106",  "20",   "ETSI", "5G",   "80M",  "VHT",  "2T",
	"106",  "20",   "MKK",  "5G",   "80M",  "VHT",  "2T",   "106",  "30",
	"FCC",  "5G",   "80M",  "VHT",  "2T",   "122",  "30",   "ETSI", "5G",
	"80M",  "VHT",  "2T",   "122",  "20",   "MKK",  "5G",   "80M",  "VHT",
	"2T",   "122",  "30",   "FCC",  "5G",   "80M",  "VHT",  "2T",   "138",
	"30",   "ETSI", "5G",   "80M",  "VHT",  "2T",   "138",  "63",   "MKK",
	"5G",   "80M",  "VHT",  "2T",   "138",  "63",   "FCC",  "5G",   "80M",
	"VHT",  "2T",   "155",  "30",   "ETSI", "5G",   "80M",  "VHT",  "2T",
	"155",  "63",   "MKK",  "5G",   "80M",  "VHT",  "2T",   "155",  "63"};

void odm_read_and_config_mp_8822b_txpwr_lmt_type15(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	u32 i = 0;
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
	u32	array_len = sizeof(array_mp_8822b_txpwr_lmt_type15)/sizeof(u8);
	u8	*array = (u8 *)array_mp_8822b_txpwr_lmt_type15;
#else
	u32 array_len = sizeof(array_mp_8822b_txpwr_lmt_type15) / sizeof(u8 *);
	u8 **array = (u8 **)array_mp_8822b_txpwr_lmt_type15;
#endif

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	struct _ADAPTER	*adapter = p_dm_odm->adapter;
	HAL_DATA_TYPE	*p_hal_data = GET_HAL_DATA(adapter);

	PlatformZeroMemory(p_hal_data->BufOfLinesPwrLmt, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	p_hal_data->nLinesReadPwrLmt = array_len/7;
#endif

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> odm_read_and_config_mp_8822b_txpwr_lmt_type15\n"));

	for (i = 0; i < array_len; i += 7) {
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
		u8	regulation = array[i];
		u8	band = array[i+1];
		u8	bandwidth = array[i+2];
		u8	rate = array[i+3];
		u8	rf_path = array[i+4];
		u8	chnl = array[i+5];
		u8	val = array[i+6];
#else
		u8 *regulation = array[i];
		u8 *band = array[i + 1];
		u8 *bandwidth = array[i + 2];
		u8 *rate = array[i + 3];
		u8 *rf_path = array[i + 4];
		u8 *chnl = array[i + 5];
		u8 *val = array[i + 6];
#endif

		odm_config_bb_txpwr_lmt_8822b(p_dm_odm, regulation, band,
					      bandwidth, rate, rf_path, chnl,
					      val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)p_hal_data->BufOfLinesPwrLmt[i/7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
		regulation, band, bandwidth, rate, rf_path, chnl, val);
#endif
	}
}

/******************************************************************************
*                           txpwr_lmt_type16.TXT
******************************************************************************/

const char *array_mp_8822b_txpwr_lmt_type16[] = {
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "01",   "32",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "01",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "01",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "02",
	"32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "02",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "02",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "03",   "32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"03",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "03",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "04",   "32",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "04",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "04",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "05",
	"32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "05",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "05",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "06",   "32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"06",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "06",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "07",   "32",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "07",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "07",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "08",
	"32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "08",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "08",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "09",   "32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"09",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "09",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "10",   "32",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "10",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "10",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "11",
	"32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "11",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "11",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "12",   "26",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"12",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "12",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "13",   "20",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "13",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "13",   "28",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "14",
	"63",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "14",   "63",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "14",   "32",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "01",   "26",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"01",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "01",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "02",   "30",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "02",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "02",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "03",
	"32",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "03",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "03",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "04",   "34",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"04",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "04",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "05",   "34",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "05",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "05",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "06",
	"34",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "06",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "06",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "07",   "34",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"07",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "07",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "08",   "34",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "08",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "08",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "09",
	"32",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "09",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "09",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "10",   "30",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"10",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "10",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "11",   "28",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "11",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "11",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "12",
	"22",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "12",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "12",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "13",   "14",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"13",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "13",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "14",   "63",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "14",   "63",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "14",   "63",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "01",
	"26",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "01",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "01",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "02",   "30",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"02",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "02",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "03",   "32",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "03",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "03",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "04",
	"34",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "04",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "04",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "05",   "34",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"05",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "05",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "06",   "34",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "06",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "06",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "07",
	"34",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "07",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "07",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "08",   "34",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"08",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "08",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "09",   "32",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "09",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "09",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "10",
	"30",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "10",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "10",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "11",   "26",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"11",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "11",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "12",   "20",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "12",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "12",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "13",
	"14",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "13",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "13",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "14",   "63",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"14",   "63",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "14",   "63",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "01",   "26",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "01",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "01",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "02",
	"28",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "02",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "02",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "03",   "30",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"03",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "03",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "04",   "30",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "04",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "04",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "05",
	"32",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "05",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "05",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "06",   "32",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"06",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "06",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "07",   "32",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "07",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "07",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "08",
	"30",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "08",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "08",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "09",   "30",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"09",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "09",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "10",   "28",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "10",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "10",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "11",
	"26",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "11",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "11",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "12",   "20",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"12",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "12",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "13",   "14",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "13",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "13",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "14",
	"63",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "14",   "63",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "14",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "01",   "63",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"01",   "63",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "01",   "63",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "02",   "63",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "02",   "63",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "02",   "63",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "03",
	"26",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "03",   "30",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "03",   "34",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "04",   "26",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"04",   "30",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "04",   "34",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "05",   "30",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "05",   "30",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "05",   "34",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "06",
	"32",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "06",   "30",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "06",   "34",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "07",   "30",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"07",   "30",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "07",   "34",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "08",   "26",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "08",   "30",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "08",   "34",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "09",
	"26",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "09",   "30",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "09",   "34",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "10",   "20",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"10",   "30",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "10",   "34",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "11",   "14",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "11",   "30",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "11",   "34",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "12",
	"63",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "12",   "63",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "12",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "13",   "63",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"13",   "63",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "13",   "63",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "14",   "63",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "14",   "63",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "14",   "63",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "01",
	"63",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "01",   "63",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "01",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "02",   "63",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"02",   "63",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "02",   "63",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "03",   "24",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "03",   "18",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "03",   "30",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "04",
	"24",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "04",   "18",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "04",   "30",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "05",   "26",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"05",   "18",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "05",   "30",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "06",   "28",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "06",   "18",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "06",   "30",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "07",
	"26",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "07",   "18",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "07",   "30",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "08",   "26",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"08",   "18",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "08",   "30",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "09",   "26",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "09",   "18",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "09",   "30",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "10",
	"20",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "10",   "18",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "10",   "30",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "11",   "14",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"11",   "18",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "11",   "30",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "12",   "63",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "12",   "63",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "12",   "63",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "13",
	"63",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "13",   "63",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "13",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "14",   "63",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"14",   "63",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "14",   "63",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "36",   "30",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "36",   "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "36",   "30",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "40",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "40",   "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "40",   "30",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "44",   "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"44",   "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "44",   "30",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "48",   "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "48",   "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "48",   "30",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "52",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "52",   "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "52",   "28",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "56",   "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"56",   "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "56",   "28",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "60",   "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "60",   "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "60",   "28",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "64",
	"28",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "64",   "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "64",   "28",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "100",  "26",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"100",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "100",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "104",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "104",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "104",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "108",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "108",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "108",  "32",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "112",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"112",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "112",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "116",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "116",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "116",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "120",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "120",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "120",  "32",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "124",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"124",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "124",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "128",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "128",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "128",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "132",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "132",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "132",  "32",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "136",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"136",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "136",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "140",  "28",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "140",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "140",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "144",
	"28",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "144",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "144",  "63",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "149",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"149",  "63",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "149",  "63",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "153",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "153",  "63",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "153",  "63",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "157",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "157",  "63",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "157",  "63",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "161",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"161",  "63",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "161",  "63",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "165",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "165",  "63",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "165",  "63",   "FCC",  "5G",   "20M",  "HT",   "1T",   "36",
	"30",   "ETSI", "5G",   "20M",  "HT",   "1T",   "36",   "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "36",   "28",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "40",   "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"40",   "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "40",   "28",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "44",   "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "44",   "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "44",   "28",   "FCC",  "5G",   "20M",  "HT",   "1T",   "48",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "48",   "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "48",   "28",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "52",   "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"52",   "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "52",   "28",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "56",   "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "56",   "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "56",   "28",   "FCC",  "5G",   "20M",  "HT",   "1T",   "60",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "60",   "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "60",   "28",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "64",   "28",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"64",   "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "64",   "28",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "100",  "26",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "100",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "100",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "104",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "104",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "104",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "108",  "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"108",  "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "108",  "32",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "112",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "112",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "112",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "116",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "116",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "116",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "120",  "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"120",  "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "120",  "32",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "124",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "124",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "124",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "128",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "128",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "128",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "132",  "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"132",  "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "132",  "32",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "136",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "136",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "136",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "140",
	"26",   "ETSI", "5G",   "20M",  "HT",   "1T",   "140",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "140",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "144",  "26",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"144",  "63",   "MKK",  "5G",   "20M",  "HT",   "1T",   "144",  "63",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "149",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "149",  "63",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "149",  "63",   "FCC",  "5G",   "20M",  "HT",   "1T",   "153",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "153",  "63",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "153",  "63",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "157",  "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"157",  "63",   "MKK",  "5G",   "20M",  "HT",   "1T",   "157",  "63",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "161",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "161",  "63",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "161",  "63",   "FCC",  "5G",   "20M",  "HT",   "1T",   "165",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "165",  "63",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "165",  "63",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "36",   "28",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"36",   "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "36",   "22",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "40",   "30",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "40",   "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "40",   "22",   "FCC",  "5G",   "20M",  "HT",   "2T",   "44",
	"30",   "ETSI", "5G",   "20M",  "HT",   "2T",   "44",   "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "44",   "22",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "48",   "30",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"48",   "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "48",   "22",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "52",   "30",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "52",   "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "52",   "22",   "FCC",  "5G",   "20M",  "HT",   "2T",   "56",
	"30",   "ETSI", "5G",   "20M",  "HT",   "2T",   "56",   "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "56",   "22",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "60",   "30",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"60",   "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "60",   "22",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "64",   "28",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "64",   "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "64",   "22",   "FCC",  "5G",   "20M",  "HT",   "2T",   "100",
	"26",   "ETSI", "5G",   "20M",  "HT",   "2T",   "100",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "100",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "104",  "30",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"104",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "104",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "108",  "32",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "108",  "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "108",  "30",   "FCC",  "5G",   "20M",  "HT",   "2T",   "112",
	"32",   "ETSI", "5G",   "20M",  "HT",   "2T",   "112",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "112",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "116",  "32",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"116",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "116",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "120",  "32",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "120",  "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "120",  "30",   "FCC",  "5G",   "20M",  "HT",   "2T",   "124",
	"32",   "ETSI", "5G",   "20M",  "HT",   "2T",   "124",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "124",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "128",  "32",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"128",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "128",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "132",  "32",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "132",  "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "132",  "30",   "FCC",  "5G",   "20M",  "HT",   "2T",   "136",
	"30",   "ETSI", "5G",   "20M",  "HT",   "2T",   "136",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "136",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "140",  "26",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"140",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "140",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "144",  "26",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "144",  "63",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "144",  "63",   "FCC",  "5G",   "20M",  "HT",   "2T",   "149",
	"32",   "ETSI", "5G",   "20M",  "HT",   "2T",   "149",  "63",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "149",  "63",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "153",  "32",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"153",  "63",   "MKK",  "5G",   "20M",  "HT",   "2T",   "153",  "63",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "157",  "32",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "157",  "63",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "157",  "63",   "FCC",  "5G",   "20M",  "HT",   "2T",   "161",
	"32",   "ETSI", "5G",   "20M",  "HT",   "2T",   "161",  "63",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "161",  "63",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "165",  "32",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"165",  "63",   "MKK",  "5G",   "20M",  "HT",   "2T",   "165",  "63",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "38",   "22",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "38",   "30",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "38",   "30",   "FCC",  "5G",   "40M",  "HT",   "1T",   "46",
	"30",   "ETSI", "5G",   "40M",  "HT",   "1T",   "46",   "30",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "46",   "30",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "54",   "30",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"54",   "30",   "MKK",  "5G",   "40M",  "HT",   "1T",   "54",   "30",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "62",   "24",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "62",   "30",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "62",   "30",   "FCC",  "5G",   "40M",  "HT",   "1T",   "102",
	"24",   "ETSI", "5G",   "40M",  "HT",   "1T",   "102",  "30",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "102",  "30",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "110",  "30",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"110",  "30",   "MKK",  "5G",   "40M",  "HT",   "1T",   "110",  "30",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "118",  "30",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "118",  "30",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "118",  "30",   "FCC",  "5G",   "40M",  "HT",   "1T",   "126",
	"30",   "ETSI", "5G",   "40M",  "HT",   "1T",   "126",  "30",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "126",  "30",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "134",  "30",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"134",  "30",   "MKK",  "5G",   "40M",  "HT",   "1T",   "134",  "30",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "142",  "30",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "142",  "63",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "142",  "63",   "FCC",  "5G",   "40M",  "HT",   "1T",   "151",
	"30",   "ETSI", "5G",   "40M",  "HT",   "1T",   "151",  "63",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "151",  "63",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "159",  "30",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"159",  "63",   "MKK",  "5G",   "40M",  "HT",   "1T",   "159",  "63",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "38",   "20",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "38",   "20",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "38",   "22",   "FCC",  "5G",   "40M",  "HT",   "2T",   "46",
	"30",   "ETSI", "5G",   "40M",  "HT",   "2T",   "46",   "20",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "46",   "22",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "54",   "30",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"54",   "20",   "MKK",  "5G",   "40M",  "HT",   "2T",   "54",   "22",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "62",   "22",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "62",   "20",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "62",   "22",   "FCC",  "5G",   "40M",  "HT",   "2T",   "102",
	"22",   "ETSI", "5G",   "40M",  "HT",   "2T",   "102",  "20",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "102",  "30",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "110",  "30",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"110",  "20",   "MKK",  "5G",   "40M",  "HT",   "2T",   "110",  "30",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "118",  "30",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "118",  "20",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "118",  "30",   "FCC",  "5G",   "40M",  "HT",   "2T",   "126",
	"30",   "ETSI", "5G",   "40M",  "HT",   "2T",   "126",  "20",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "126",  "30",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "134",  "30",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"134",  "20",   "MKK",  "5G",   "40M",  "HT",   "2T",   "134",  "30",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "142",  "30",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "142",  "63",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "142",  "63",   "FCC",  "5G",   "40M",  "HT",   "2T",   "151",
	"30",   "ETSI", "5G",   "40M",  "HT",   "2T",   "151",  "63",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "151",  "63",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "159",  "30",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"159",  "63",   "MKK",  "5G",   "40M",  "HT",   "2T",   "159",  "63",
	"FCC",  "5G",   "80M",  "VHT",  "1T",   "42",   "20",   "ETSI", "5G",
	"80M",  "VHT",  "1T",   "42",   "30",   "MKK",  "5G",   "80M",  "VHT",
	"1T",   "42",   "28",   "FCC",  "5G",   "80M",  "VHT",  "1T",   "58",
	"20",   "ETSI", "5G",   "80M",  "VHT",  "1T",   "58",   "30",   "MKK",
	"5G",   "80M",  "VHT",  "1T",   "58",   "28",   "FCC",  "5G",   "80M",
	"VHT",  "1T",   "106",  "20",   "ETSI", "5G",   "80M",  "VHT",  "1T",
	"106",  "30",   "MKK",  "5G",   "80M",  "VHT",  "1T",   "106",  "30",
	"FCC",  "5G",   "80M",  "VHT",  "1T",   "122",  "30",   "ETSI", "5G",
	"80M",  "VHT",  "1T",   "122",  "30",   "MKK",  "5G",   "80M",  "VHT",
	"1T",   "122",  "30",   "FCC",  "5G",   "80M",  "VHT",  "1T",   "138",
	"30",   "ETSI", "5G",   "80M",  "VHT",  "1T",   "138",  "63",   "MKK",
	"5G",   "80M",  "VHT",  "1T",   "138",  "63",   "FCC",  "5G",   "80M",
	"VHT",  "1T",   "155",  "30",   "ETSI", "5G",   "80M",  "VHT",  "1T",
	"155",  "63",   "MKK",  "5G",   "80M",  "VHT",  "1T",   "155",  "63",
	"FCC",  "5G",   "80M",  "VHT",  "2T",   "42",   "18",   "ETSI", "5G",
	"80M",  "VHT",  "2T",   "42",   "20",   "MKK",  "5G",   "80M",  "VHT",
	"2T",   "42",   "22",   "FCC",  "5G",   "80M",  "VHT",  "2T",   "58",
	"18",   "ETSI", "5G",   "80M",  "VHT",  "2T",   "58",   "20",   "MKK",
	"5G",   "80M",  "VHT",  "2T",   "58",   "22",   "FCC",  "5G",   "80M",
	"VHT",  "2T",   "106",  "20",   "ETSI", "5G",   "80M",  "VHT",  "2T",
	"106",  "20",   "MKK",  "5G",   "80M",  "VHT",  "2T",   "106",  "30",
	"FCC",  "5G",   "80M",  "VHT",  "2T",   "122",  "30",   "ETSI", "5G",
	"80M",  "VHT",  "2T",   "122",  "20",   "MKK",  "5G",   "80M",  "VHT",
	"2T",   "122",  "30",   "FCC",  "5G",   "80M",  "VHT",  "2T",   "138",
	"30",   "ETSI", "5G",   "80M",  "VHT",  "2T",   "138",  "63",   "MKK",
	"5G",   "80M",  "VHT",  "2T",   "138",  "63",   "FCC",  "5G",   "80M",
	"VHT",  "2T",   "155",  "30",   "ETSI", "5G",   "80M",  "VHT",  "2T",
	"155",  "63",   "MKK",  "5G",   "80M",  "VHT",  "2T",   "155",  "63"};

void odm_read_and_config_mp_8822b_txpwr_lmt_type16(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	u32 i = 0;
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
	u32	array_len = sizeof(array_mp_8822b_txpwr_lmt_type16)/sizeof(u8);
	u8	*array = (u8 *)array_mp_8822b_txpwr_lmt_type16;
#else
	u32 array_len = sizeof(array_mp_8822b_txpwr_lmt_type16) / sizeof(u8 *);
	u8 **array = (u8 **)array_mp_8822b_txpwr_lmt_type16;
#endif

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	struct _ADAPTER	*adapter = p_dm_odm->adapter;
	HAL_DATA_TYPE	*p_hal_data = GET_HAL_DATA(adapter);

	PlatformZeroMemory(p_hal_data->BufOfLinesPwrLmt, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	p_hal_data->nLinesReadPwrLmt = array_len/7;
#endif

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> odm_read_and_config_mp_8822b_txpwr_lmt_type16\n"));

	for (i = 0; i < array_len; i += 7) {
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
		u8	regulation = array[i];
		u8	band = array[i+1];
		u8	bandwidth = array[i+2];
		u8	rate = array[i+3];
		u8	rf_path = array[i+4];
		u8	chnl = array[i+5];
		u8	val = array[i+6];
#else
		u8 *regulation = array[i];
		u8 *band = array[i + 1];
		u8 *bandwidth = array[i + 2];
		u8 *rate = array[i + 3];
		u8 *rf_path = array[i + 4];
		u8 *chnl = array[i + 5];
		u8 *val = array[i + 6];
#endif

		odm_config_bb_txpwr_lmt_8822b(p_dm_odm, regulation, band,
					      bandwidth, rate, rf_path, chnl,
					      val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)p_hal_data->BufOfLinesPwrLmt[i/7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
		regulation, band, bandwidth, rate, rf_path, chnl, val);
#endif
	}
}

/******************************************************************************
*                           txpwr_lmt_type2.TXT
******************************************************************************/

const char *array_mp_8822b_txpwr_lmt_type2[] = {
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "01",   "32",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "01",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "01",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "02",
	"32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "02",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "02",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "03",   "32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"03",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "03",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "04",   "32",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "04",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "04",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "05",
	"32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "05",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "05",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "06",   "32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"06",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "06",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "07",   "32",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "07",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "07",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "08",
	"32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "08",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "08",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "09",   "32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"09",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "09",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "10",   "32",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "10",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "10",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "11",
	"32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "11",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "11",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "12",   "26",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"12",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "12",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "13",   "20",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "13",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "13",   "28",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "14",
	"63",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "14",   "63",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "14",   "32",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "01",   "26",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"01",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "01",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "02",   "30",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "02",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "02",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "03",
	"32",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "03",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "03",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "04",   "34",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"04",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "04",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "05",   "34",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "05",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "05",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "06",
	"34",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "06",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "06",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "07",   "34",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"07",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "07",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "08",   "34",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "08",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "08",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "09",
	"32",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "09",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "09",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "10",   "30",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"10",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "10",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "11",   "28",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "11",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "11",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "12",
	"22",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "12",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "12",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "13",   "14",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"13",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "13",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "14",   "63",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "14",   "63",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "14",   "63",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "01",
	"26",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "01",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "01",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "02",   "30",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"02",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "02",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "03",   "32",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "03",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "03",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "04",
	"34",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "04",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "04",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "05",   "34",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"05",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "05",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "06",   "34",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "06",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "06",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "07",
	"34",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "07",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "07",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "08",   "34",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"08",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "08",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "09",   "32",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "09",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "09",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "10",
	"30",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "10",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "10",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "11",   "26",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"11",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "11",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "12",   "20",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "12",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "12",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "13",
	"14",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "13",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "13",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "14",   "63",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"14",   "63",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "14",   "63",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "01",   "26",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "01",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "01",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "02",
	"28",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "02",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "02",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "03",   "30",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"03",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "03",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "04",   "30",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "04",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "04",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "05",
	"32",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "05",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "05",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "06",   "32",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"06",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "06",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "07",   "32",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "07",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "07",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "08",
	"30",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "08",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "08",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "09",   "30",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"09",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "09",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "10",   "28",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "10",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "10",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "11",
	"26",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "11",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "11",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "12",   "20",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"12",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "12",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "13",   "14",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "13",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "13",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "14",
	"63",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "14",   "63",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "14",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "01",   "63",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"01",   "63",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "01",   "63",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "02",   "63",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "02",   "63",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "02",   "63",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "03",
	"26",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "03",   "30",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "03",   "34",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "04",   "26",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"04",   "30",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "04",   "34",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "05",   "30",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "05",   "30",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "05",   "34",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "06",
	"32",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "06",   "30",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "06",   "34",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "07",   "30",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"07",   "30",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "07",   "34",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "08",   "26",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "08",   "30",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "08",   "34",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "09",
	"26",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "09",   "30",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "09",   "34",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "10",   "20",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"10",   "30",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "10",   "34",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "11",   "14",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "11",   "30",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "11",   "34",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "12",
	"63",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "12",   "63",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "12",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "13",   "63",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"13",   "63",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "13",   "63",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "14",   "63",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "14",   "63",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "14",   "63",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "01",
	"63",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "01",   "63",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "01",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "02",   "63",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"02",   "63",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "02",   "63",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "03",   "24",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "03",   "18",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "03",   "30",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "04",
	"24",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "04",   "18",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "04",   "30",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "05",   "26",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"05",   "18",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "05",   "30",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "06",   "28",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "06",   "18",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "06",   "30",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "07",
	"26",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "07",   "18",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "07",   "30",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "08",   "26",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"08",   "18",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "08",   "30",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "09",   "26",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "09",   "18",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "09",   "30",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "10",
	"20",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "10",   "18",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "10",   "30",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "11",   "14",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"11",   "18",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "11",   "30",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "12",   "63",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "12",   "63",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "12",   "63",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "13",
	"63",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "13",   "63",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "13",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "14",   "63",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"14",   "63",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "14",   "63",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "36",   "36",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "36",   "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "36",   "30",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "40",
	"38",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "40",   "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "40",   "30",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "44",   "38",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"44",   "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "44",   "30",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "48",   "38",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "48",   "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "48",   "30",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "52",
	"38",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "52",   "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "52",   "28",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "56",   "38",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"56",   "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "56",   "28",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "60",   "38",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "60",   "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "60",   "28",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "64",
	"34",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "64",   "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "64",   "28",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "100",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"100",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "100",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "104",  "38",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "104",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "104",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "108",
	"38",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "108",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "108",  "32",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "112",  "38",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"112",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "112",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "116",  "38",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "116",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "116",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "120",
	"38",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "120",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "120",  "32",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "124",  "38",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"124",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "124",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "128",  "38",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "128",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "128",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "132",
	"38",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "132",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "132",  "32",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "136",  "38",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"136",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "136",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "140",  "34",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "140",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "140",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "144",
	"34",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "144",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "144",  "63",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "149",  "38",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"149",  "63",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "149",  "63",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "153",  "38",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "153",  "63",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "153",  "63",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "157",
	"38",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "157",  "63",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "157",  "63",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "161",  "38",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"161",  "63",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "161",  "63",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "165",  "38",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "165",  "63",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "165",  "63",   "FCC",  "5G",   "20M",  "HT",   "1T",   "36",
	"36",   "ETSI", "5G",   "20M",  "HT",   "1T",   "36",   "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "36",   "28",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "40",   "38",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"40",   "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "40",   "28",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "44",   "38",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "44",   "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "44",   "28",   "FCC",  "5G",   "20M",  "HT",   "1T",   "48",
	"38",   "ETSI", "5G",   "20M",  "HT",   "1T",   "48",   "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "48",   "28",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "52",   "38",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"52",   "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "52",   "28",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "56",   "38",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "56",   "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "56",   "28",   "FCC",  "5G",   "20M",  "HT",   "1T",   "60",
	"38",   "ETSI", "5G",   "20M",  "HT",   "1T",   "60",   "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "60",   "28",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "64",   "34",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"64",   "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "64",   "28",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "100",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "100",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "100",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "104",
	"38",   "ETSI", "5G",   "20M",  "HT",   "1T",   "104",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "104",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "108",  "38",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"108",  "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "108",  "32",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "112",  "38",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "112",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "112",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "116",
	"38",   "ETSI", "5G",   "20M",  "HT",   "1T",   "116",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "116",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "120",  "38",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"120",  "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "120",  "32",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "124",  "38",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "124",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "124",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "128",
	"38",   "ETSI", "5G",   "20M",  "HT",   "1T",   "128",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "128",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "132",  "38",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"132",  "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "132",  "32",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "136",  "38",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "136",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "136",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "140",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "140",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "140",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "144",  "26",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"144",  "63",   "MKK",  "5G",   "20M",  "HT",   "1T",   "144",  "63",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "149",  "38",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "149",  "63",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "149",  "63",   "FCC",  "5G",   "20M",  "HT",   "1T",   "153",
	"38",   "ETSI", "5G",   "20M",  "HT",   "1T",   "153",  "63",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "153",  "63",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "157",  "38",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"157",  "63",   "MKK",  "5G",   "20M",  "HT",   "1T",   "157",  "63",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "161",  "38",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "161",  "63",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "161",  "63",   "FCC",  "5G",   "20M",  "HT",   "1T",   "165",
	"38",   "ETSI", "5G",   "20M",  "HT",   "1T",   "165",  "63",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "165",  "63",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "36",   "34",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"36",   "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "36",   "22",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "40",   "36",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "40",   "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "40",   "22",   "FCC",  "5G",   "20M",  "HT",   "2T",   "44",
	"36",   "ETSI", "5G",   "20M",  "HT",   "2T",   "44",   "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "44",   "22",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "48",   "36",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"48",   "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "48",   "22",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "52",   "36",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "52",   "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "52",   "22",   "FCC",  "5G",   "20M",  "HT",   "2T",   "56",
	"36",   "ETSI", "5G",   "20M",  "HT",   "2T",   "56",   "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "56",   "22",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "60",   "36",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"60",   "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "60",   "22",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "64",   "34",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "64",   "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "64",   "22",   "FCC",  "5G",   "20M",  "HT",   "2T",   "100",
	"32",   "ETSI", "5G",   "20M",  "HT",   "2T",   "100",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "100",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "104",  "36",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"104",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "104",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "108",  "38",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "108",  "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "108",  "30",   "FCC",  "5G",   "20M",  "HT",   "2T",   "112",
	"38",   "ETSI", "5G",   "20M",  "HT",   "2T",   "112",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "112",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "116",  "38",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"116",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "116",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "120",  "38",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "120",  "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "120",  "30",   "FCC",  "5G",   "20M",  "HT",   "2T",   "124",
	"38",   "ETSI", "5G",   "20M",  "HT",   "2T",   "124",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "124",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "128",  "38",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"128",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "128",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "132",  "38",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "132",  "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "132",  "30",   "FCC",  "5G",   "20M",  "HT",   "2T",   "136",
	"36",   "ETSI", "5G",   "20M",  "HT",   "2T",   "136",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "136",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "140",  "32",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"140",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "140",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "144",  "26",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "144",  "63",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "144",  "63",   "FCC",  "5G",   "20M",  "HT",   "2T",   "149",
	"38",   "ETSI", "5G",   "20M",  "HT",   "2T",   "149",  "63",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "149",  "63",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "153",  "38",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"153",  "63",   "MKK",  "5G",   "20M",  "HT",   "2T",   "153",  "63",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "157",  "38",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "157",  "63",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "157",  "63",   "FCC",  "5G",   "20M",  "HT",   "2T",   "161",
	"38",   "ETSI", "5G",   "20M",  "HT",   "2T",   "161",  "63",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "161",  "63",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "165",  "38",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"165",  "63",   "MKK",  "5G",   "20M",  "HT",   "2T",   "165",  "63",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "38",   "28",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "38",   "30",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "38",   "30",   "FCC",  "5G",   "40M",  "HT",   "1T",   "46",
	"36",   "ETSI", "5G",   "40M",  "HT",   "1T",   "46",   "30",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "46",   "30",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "54",   "36",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"54",   "30",   "MKK",  "5G",   "40M",  "HT",   "1T",   "54",   "30",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "62",   "30",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "62",   "30",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "62",   "30",   "FCC",  "5G",   "40M",  "HT",   "1T",   "102",
	"30",   "ETSI", "5G",   "40M",  "HT",   "1T",   "102",  "30",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "102",  "30",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "110",  "36",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"110",  "30",   "MKK",  "5G",   "40M",  "HT",   "1T",   "110",  "30",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "118",  "36",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "118",  "30",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "118",  "30",   "FCC",  "5G",   "40M",  "HT",   "1T",   "126",
	"36",   "ETSI", "5G",   "40M",  "HT",   "1T",   "126",  "30",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "126",  "30",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "134",  "36",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"134",  "30",   "MKK",  "5G",   "40M",  "HT",   "1T",   "134",  "30",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "142",  "30",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "142",  "63",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "142",  "63",   "FCC",  "5G",   "40M",  "HT",   "1T",   "151",
	"36",   "ETSI", "5G",   "40M",  "HT",   "1T",   "151",  "63",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "151",  "63",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "159",  "36",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"159",  "63",   "MKK",  "5G",   "40M",  "HT",   "1T",   "159",  "63",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "38",   "26",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "38",   "20",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "38",   "22",   "FCC",  "5G",   "40M",  "HT",   "2T",   "46",
	"36",   "ETSI", "5G",   "40M",  "HT",   "2T",   "46",   "20",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "46",   "22",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "54",   "36",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"54",   "20",   "MKK",  "5G",   "40M",  "HT",   "2T",   "54",   "22",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "62",   "28",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "62",   "20",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "62",   "22",   "FCC",  "5G",   "40M",  "HT",   "2T",   "102",
	"28",   "ETSI", "5G",   "40M",  "HT",   "2T",   "102",  "20",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "102",  "30",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "110",  "36",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"110",  "20",   "MKK",  "5G",   "40M",  "HT",   "2T",   "110",  "30",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "118",  "36",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "118",  "20",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "118",  "30",   "FCC",  "5G",   "40M",  "HT",   "2T",   "126",
	"36",   "ETSI", "5G",   "40M",  "HT",   "2T",   "126",  "20",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "126",  "30",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "134",  "36",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"134",  "20",   "MKK",  "5G",   "40M",  "HT",   "2T",   "134",  "30",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "142",  "30",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "142",  "63",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "142",  "63",   "FCC",  "5G",   "40M",  "HT",   "2T",   "151",
	"36",   "ETSI", "5G",   "40M",  "HT",   "2T",   "151",  "63",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "151",  "63",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "159",  "36",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"159",  "63",   "MKK",  "5G",   "40M",  "HT",   "2T",   "159",  "63",
	"FCC",  "5G",   "80M",  "VHT",  "1T",   "42",   "26",   "ETSI", "5G",
	"80M",  "VHT",  "1T",   "42",   "30",   "MKK",  "5G",   "80M",  "VHT",
	"1T",   "42",   "28",   "FCC",  "5G",   "80M",  "VHT",  "1T",   "58",
	"26",   "ETSI", "5G",   "80M",  "VHT",  "1T",   "58",   "30",   "MKK",
	"5G",   "80M",  "VHT",  "1T",   "58",   "28",   "FCC",  "5G",   "80M",
	"VHT",  "1T",   "106",  "26",   "ETSI", "5G",   "80M",  "VHT",  "1T",
	"106",  "30",   "MKK",  "5G",   "80M",  "VHT",  "1T",   "106",  "30",
	"FCC",  "5G",   "80M",  "VHT",  "1T",   "122",  "36",   "ETSI", "5G",
	"80M",  "VHT",  "1T",   "122",  "30",   "MKK",  "5G",   "80M",  "VHT",
	"1T",   "122",  "30",   "FCC",  "5G",   "80M",  "VHT",  "1T",   "138",
	"36",   "ETSI", "5G",   "80M",  "VHT",  "1T",   "138",  "63",   "MKK",
	"5G",   "80M",  "VHT",  "1T",   "138",  "63",   "FCC",  "5G",   "80M",
	"VHT",  "1T",   "155",  "36",   "ETSI", "5G",   "80M",  "VHT",  "1T",
	"155",  "63",   "MKK",  "5G",   "80M",  "VHT",  "1T",   "155",  "63",
	"FCC",  "5G",   "80M",  "VHT",  "2T",   "42",   "24",   "ETSI", "5G",
	"80M",  "VHT",  "2T",   "42",   "20",   "MKK",  "5G",   "80M",  "VHT",
	"2T",   "42",   "22",   "FCC",  "5G",   "80M",  "VHT",  "2T",   "58",
	"24",   "ETSI", "5G",   "80M",  "VHT",  "2T",   "58",   "20",   "MKK",
	"5G",   "80M",  "VHT",  "2T",   "58",   "22",   "FCC",  "5G",   "80M",
	"VHT",  "2T",   "106",  "26",   "ETSI", "5G",   "80M",  "VHT",  "2T",
	"106",  "20",   "MKK",  "5G",   "80M",  "VHT",  "2T",   "106",  "30",
	"FCC",  "5G",   "80M",  "VHT",  "2T",   "122",  "36",   "ETSI", "5G",
	"80M",  "VHT",  "2T",   "122",  "20",   "MKK",  "5G",   "80M",  "VHT",
	"2T",   "122",  "30",   "FCC",  "5G",   "80M",  "VHT",  "2T",   "138",
	"36",   "ETSI", "5G",   "80M",  "VHT",  "2T",   "138",  "63",   "MKK",
	"5G",   "80M",  "VHT",  "2T",   "138",  "63",   "FCC",  "5G",   "80M",
	"VHT",  "2T",   "155",  "36",   "ETSI", "5G",   "80M",  "VHT",  "2T",
	"155",  "63",   "MKK",  "5G",   "80M",  "VHT",  "2T",   "155",  "63"};

void odm_read_and_config_mp_8822b_txpwr_lmt_type2(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	u32 i = 0;
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
	u32	array_len = sizeof(array_mp_8822b_txpwr_lmt_type2)/sizeof(u8);
	u8	*array = (u8 *)array_mp_8822b_txpwr_lmt_type2;
#else
	u32 array_len = sizeof(array_mp_8822b_txpwr_lmt_type2) / sizeof(u8 *);
	u8 **array = (u8 **)array_mp_8822b_txpwr_lmt_type2;
#endif

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	struct _ADAPTER	*adapter = p_dm_odm->adapter;
	HAL_DATA_TYPE	*p_hal_data = GET_HAL_DATA(adapter);

	PlatformZeroMemory(p_hal_data->BufOfLinesPwrLmt, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	p_hal_data->nLinesReadPwrLmt = array_len/7;
#endif

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> odm_read_and_config_mp_8822b_txpwr_lmt_type2\n"));

	for (i = 0; i < array_len; i += 7) {
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
		u8	regulation = array[i];
		u8	band = array[i+1];
		u8	bandwidth = array[i+2];
		u8	rate = array[i+3];
		u8	rf_path = array[i+4];
		u8	chnl = array[i+5];
		u8	val = array[i+6];
#else
		u8 *regulation = array[i];
		u8 *band = array[i + 1];
		u8 *bandwidth = array[i + 2];
		u8 *rate = array[i + 3];
		u8 *rf_path = array[i + 4];
		u8 *chnl = array[i + 5];
		u8 *val = array[i + 6];
#endif

		odm_config_bb_txpwr_lmt_8822b(p_dm_odm, regulation, band,
					      bandwidth, rate, rf_path, chnl,
					      val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)p_hal_data->BufOfLinesPwrLmt[i/7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
		regulation, band, bandwidth, rate, rf_path, chnl, val);
#endif
	}
}

/******************************************************************************
*                           txpwr_lmt_type3.TXT
******************************************************************************/

const char *array_mp_8822b_txpwr_lmt_type3[] = {
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "01",   "32",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "01",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "01",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "02",
	"32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "02",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "02",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "03",   "32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"03",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "03",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "04",   "32",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "04",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "04",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "05",
	"32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "05",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "05",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "06",   "32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"06",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "06",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "07",   "32",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "07",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "07",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "08",
	"32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "08",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "08",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "09",   "32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"09",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "09",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "10",   "32",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "10",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "10",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "11",
	"32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "11",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "11",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "12",   "26",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"12",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "12",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "13",   "20",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "13",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "13",   "28",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "14",
	"63",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "14",   "63",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "14",   "32",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "01",   "26",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"01",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "01",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "02",   "30",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "02",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "02",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "03",
	"32",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "03",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "03",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "04",   "34",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"04",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "04",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "05",   "34",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "05",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "05",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "06",
	"34",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "06",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "06",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "07",   "34",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"07",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "07",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "08",   "34",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "08",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "08",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "09",
	"32",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "09",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "09",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "10",   "30",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"10",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "10",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "11",   "28",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "11",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "11",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "12",
	"22",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "12",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "12",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "13",   "14",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"13",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "13",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "14",   "63",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "14",   "63",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "14",   "63",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "01",
	"26",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "01",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "01",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "02",   "30",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"02",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "02",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "03",   "32",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "03",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "03",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "04",
	"34",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "04",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "04",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "05",   "34",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"05",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "05",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "06",   "34",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "06",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "06",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "07",
	"34",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "07",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "07",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "08",   "34",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"08",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "08",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "09",   "32",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "09",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "09",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "10",
	"30",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "10",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "10",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "11",   "26",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"11",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "11",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "12",   "20",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "12",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "12",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "13",
	"14",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "13",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "13",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "14",   "63",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"14",   "63",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "14",   "63",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "01",   "26",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "01",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "01",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "02",
	"28",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "02",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "02",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "03",   "30",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"03",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "03",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "04",   "30",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "04",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "04",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "05",
	"32",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "05",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "05",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "06",   "32",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"06",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "06",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "07",   "32",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "07",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "07",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "08",
	"30",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "08",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "08",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "09",   "30",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"09",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "09",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "10",   "28",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "10",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "10",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "11",
	"26",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "11",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "11",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "12",   "20",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"12",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "12",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "13",   "14",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "13",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "13",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "14",
	"63",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "14",   "63",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "14",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "01",   "63",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"01",   "63",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "01",   "63",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "02",   "63",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "02",   "63",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "02",   "63",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "03",
	"26",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "03",   "30",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "03",   "34",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "04",   "26",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"04",   "30",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "04",   "34",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "05",   "30",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "05",   "30",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "05",   "34",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "06",
	"32",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "06",   "30",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "06",   "34",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "07",   "30",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"07",   "30",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "07",   "34",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "08",   "26",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "08",   "30",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "08",   "34",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "09",
	"26",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "09",   "30",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "09",   "34",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "10",   "20",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"10",   "30",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "10",   "34",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "11",   "14",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "11",   "30",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "11",   "34",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "12",
	"63",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "12",   "63",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "12",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "13",   "63",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"13",   "63",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "13",   "63",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "14",   "63",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "14",   "63",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "14",   "63",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "01",
	"63",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "01",   "63",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "01",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "02",   "63",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"02",   "63",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "02",   "63",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "03",   "24",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "03",   "18",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "03",   "30",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "04",
	"24",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "04",   "18",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "04",   "30",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "05",   "26",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"05",   "18",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "05",   "30",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "06",   "28",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "06",   "18",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "06",   "30",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "07",
	"26",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "07",   "18",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "07",   "30",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "08",   "26",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"08",   "18",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "08",   "30",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "09",   "26",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "09",   "18",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "09",   "30",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "10",
	"20",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "10",   "18",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "10",   "30",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "11",   "14",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"11",   "18",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "11",   "30",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "12",   "63",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "12",   "63",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "12",   "63",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "13",
	"63",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "13",   "63",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "13",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "14",   "63",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"14",   "63",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "14",   "63",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "36",   "30",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "36",   "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "36",   "30",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "40",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "40",   "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "40",   "30",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "44",   "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"44",   "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "44",   "30",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "48",   "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "48",   "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "48",   "30",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "52",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "52",   "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "52",   "28",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "56",   "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"56",   "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "56",   "28",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "60",   "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "60",   "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "60",   "28",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "64",
	"28",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "64",   "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "64",   "28",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "100",  "26",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"100",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "100",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "104",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "104",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "104",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "108",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "108",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "108",  "32",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "112",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"112",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "112",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "116",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "116",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "116",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "120",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "120",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "120",  "32",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "124",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"124",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "124",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "128",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "128",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "128",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "132",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "132",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "132",  "32",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "136",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"136",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "136",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "140",  "28",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "140",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "140",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "144",
	"28",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "144",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "144",  "63",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "149",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"149",  "63",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "149",  "63",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "153",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "153",  "63",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "153",  "63",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "157",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "157",  "63",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "157",  "63",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "161",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"161",  "63",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "161",  "63",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "165",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "165",  "63",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "165",  "63",   "FCC",  "5G",   "20M",  "HT",   "1T",   "36",
	"30",   "ETSI", "5G",   "20M",  "HT",   "1T",   "36",   "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "36",   "28",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "40",   "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"40",   "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "40",   "28",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "44",   "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "44",   "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "44",   "28",   "FCC",  "5G",   "20M",  "HT",   "1T",   "48",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "48",   "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "48",   "28",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "52",   "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"52",   "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "52",   "28",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "56",   "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "56",   "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "56",   "28",   "FCC",  "5G",   "20M",  "HT",   "1T",   "60",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "60",   "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "60",   "28",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "64",   "28",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"64",   "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "64",   "28",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "100",  "26",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "100",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "100",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "104",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "104",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "104",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "108",  "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"108",  "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "108",  "32",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "112",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "112",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "112",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "116",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "116",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "116",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "120",  "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"120",  "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "120",  "32",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "124",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "124",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "124",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "128",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "128",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "128",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "132",  "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"132",  "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "132",  "32",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "136",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "136",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "136",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "140",
	"26",   "ETSI", "5G",   "20M",  "HT",   "1T",   "140",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "140",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "144",  "26",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"144",  "63",   "MKK",  "5G",   "20M",  "HT",   "1T",   "144",  "63",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "149",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "149",  "63",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "149",  "63",   "FCC",  "5G",   "20M",  "HT",   "1T",   "153",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "153",  "63",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "153",  "63",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "157",  "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"157",  "63",   "MKK",  "5G",   "20M",  "HT",   "1T",   "157",  "63",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "161",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "161",  "63",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "161",  "63",   "FCC",  "5G",   "20M",  "HT",   "1T",   "165",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "165",  "63",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "165",  "63",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "36",   "28",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"36",   "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "36",   "22",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "40",   "30",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "40",   "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "40",   "22",   "FCC",  "5G",   "20M",  "HT",   "2T",   "44",
	"30",   "ETSI", "5G",   "20M",  "HT",   "2T",   "44",   "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "44",   "22",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "48",   "30",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"48",   "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "48",   "22",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "52",   "30",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "52",   "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "52",   "22",   "FCC",  "5G",   "20M",  "HT",   "2T",   "56",
	"30",   "ETSI", "5G",   "20M",  "HT",   "2T",   "56",   "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "56",   "22",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "60",   "30",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"60",   "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "60",   "22",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "64",   "28",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "64",   "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "64",   "22",   "FCC",  "5G",   "20M",  "HT",   "2T",   "100",
	"26",   "ETSI", "5G",   "20M",  "HT",   "2T",   "100",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "100",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "104",  "30",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"104",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "104",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "108",  "32",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "108",  "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "108",  "30",   "FCC",  "5G",   "20M",  "HT",   "2T",   "112",
	"32",   "ETSI", "5G",   "20M",  "HT",   "2T",   "112",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "112",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "116",  "32",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"116",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "116",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "120",  "32",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "120",  "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "120",  "30",   "FCC",  "5G",   "20M",  "HT",   "2T",   "124",
	"32",   "ETSI", "5G",   "20M",  "HT",   "2T",   "124",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "124",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "128",  "32",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"128",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "128",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "132",  "32",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "132",  "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "132",  "30",   "FCC",  "5G",   "20M",  "HT",   "2T",   "136",
	"30",   "ETSI", "5G",   "20M",  "HT",   "2T",   "136",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "136",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "140",  "26",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"140",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "140",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "144",  "26",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "144",  "63",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "144",  "63",   "FCC",  "5G",   "20M",  "HT",   "2T",   "149",
	"32",   "ETSI", "5G",   "20M",  "HT",   "2T",   "149",  "63",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "149",  "63",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "153",  "32",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"153",  "63",   "MKK",  "5G",   "20M",  "HT",   "2T",   "153",  "63",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "157",  "32",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "157",  "63",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "157",  "63",   "FCC",  "5G",   "20M",  "HT",   "2T",   "161",
	"32",   "ETSI", "5G",   "20M",  "HT",   "2T",   "161",  "63",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "161",  "63",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "165",  "32",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"165",  "63",   "MKK",  "5G",   "20M",  "HT",   "2T",   "165",  "63",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "38",   "22",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "38",   "30",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "38",   "30",   "FCC",  "5G",   "40M",  "HT",   "1T",   "46",
	"30",   "ETSI", "5G",   "40M",  "HT",   "1T",   "46",   "30",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "46",   "30",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "54",   "30",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"54",   "30",   "MKK",  "5G",   "40M",  "HT",   "1T",   "54",   "30",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "62",   "24",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "62",   "30",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "62",   "30",   "FCC",  "5G",   "40M",  "HT",   "1T",   "102",
	"24",   "ETSI", "5G",   "40M",  "HT",   "1T",   "102",  "30",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "102",  "30",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "110",  "30",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"110",  "30",   "MKK",  "5G",   "40M",  "HT",   "1T",   "110",  "30",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "118",  "30",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "118",  "30",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "118",  "30",   "FCC",  "5G",   "40M",  "HT",   "1T",   "126",
	"30",   "ETSI", "5G",   "40M",  "HT",   "1T",   "126",  "30",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "126",  "30",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "134",  "30",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"134",  "30",   "MKK",  "5G",   "40M",  "HT",   "1T",   "134",  "30",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "142",  "30",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "142",  "63",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "142",  "63",   "FCC",  "5G",   "40M",  "HT",   "1T",   "151",
	"30",   "ETSI", "5G",   "40M",  "HT",   "1T",   "151",  "63",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "151",  "63",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "159",  "30",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"159",  "63",   "MKK",  "5G",   "40M",  "HT",   "1T",   "159",  "63",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "38",   "20",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "38",   "20",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "38",   "22",   "FCC",  "5G",   "40M",  "HT",   "2T",   "46",
	"30",   "ETSI", "5G",   "40M",  "HT",   "2T",   "46",   "20",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "46",   "22",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "54",   "30",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"54",   "20",   "MKK",  "5G",   "40M",  "HT",   "2T",   "54",   "22",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "62",   "22",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "62",   "20",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "62",   "22",   "FCC",  "5G",   "40M",  "HT",   "2T",   "102",
	"22",   "ETSI", "5G",   "40M",  "HT",   "2T",   "102",  "20",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "102",  "30",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "110",  "30",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"110",  "20",   "MKK",  "5G",   "40M",  "HT",   "2T",   "110",  "30",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "118",  "30",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "118",  "20",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "118",  "30",   "FCC",  "5G",   "40M",  "HT",   "2T",   "126",
	"30",   "ETSI", "5G",   "40M",  "HT",   "2T",   "126",  "20",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "126",  "30",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "134",  "30",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"134",  "20",   "MKK",  "5G",   "40M",  "HT",   "2T",   "134",  "30",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "142",  "30",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "142",  "63",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "142",  "63",   "FCC",  "5G",   "40M",  "HT",   "2T",   "151",
	"30",   "ETSI", "5G",   "40M",  "HT",   "2T",   "151",  "63",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "151",  "63",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "159",  "30",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"159",  "63",   "MKK",  "5G",   "40M",  "HT",   "2T",   "159",  "63",
	"FCC",  "5G",   "80M",  "VHT",  "1T",   "42",   "20",   "ETSI", "5G",
	"80M",  "VHT",  "1T",   "42",   "30",   "MKK",  "5G",   "80M",  "VHT",
	"1T",   "42",   "28",   "FCC",  "5G",   "80M",  "VHT",  "1T",   "58",
	"20",   "ETSI", "5G",   "80M",  "VHT",  "1T",   "58",   "30",   "MKK",
	"5G",   "80M",  "VHT",  "1T",   "58",   "28",   "FCC",  "5G",   "80M",
	"VHT",  "1T",   "106",  "20",   "ETSI", "5G",   "80M",  "VHT",  "1T",
	"106",  "30",   "MKK",  "5G",   "80M",  "VHT",  "1T",   "106",  "30",
	"FCC",  "5G",   "80M",  "VHT",  "1T",   "122",  "30",   "ETSI", "5G",
	"80M",  "VHT",  "1T",   "122",  "30",   "MKK",  "5G",   "80M",  "VHT",
	"1T",   "122",  "30",   "FCC",  "5G",   "80M",  "VHT",  "1T",   "138",
	"30",   "ETSI", "5G",   "80M",  "VHT",  "1T",   "138",  "63",   "MKK",
	"5G",   "80M",  "VHT",  "1T",   "138",  "63",   "FCC",  "5G",   "80M",
	"VHT",  "1T",   "155",  "30",   "ETSI", "5G",   "80M",  "VHT",  "1T",
	"155",  "63",   "MKK",  "5G",   "80M",  "VHT",  "1T",   "155",  "63",
	"FCC",  "5G",   "80M",  "VHT",  "2T",   "42",   "18",   "ETSI", "5G",
	"80M",  "VHT",  "2T",   "42",   "20",   "MKK",  "5G",   "80M",  "VHT",
	"2T",   "42",   "22",   "FCC",  "5G",   "80M",  "VHT",  "2T",   "58",
	"18",   "ETSI", "5G",   "80M",  "VHT",  "2T",   "58",   "20",   "MKK",
	"5G",   "80M",  "VHT",  "2T",   "58",   "22",   "FCC",  "5G",   "80M",
	"VHT",  "2T",   "106",  "20",   "ETSI", "5G",   "80M",  "VHT",  "2T",
	"106",  "20",   "MKK",  "5G",   "80M",  "VHT",  "2T",   "106",  "30",
	"FCC",  "5G",   "80M",  "VHT",  "2T",   "122",  "30",   "ETSI", "5G",
	"80M",  "VHT",  "2T",   "122",  "20",   "MKK",  "5G",   "80M",  "VHT",
	"2T",   "122",  "30",   "FCC",  "5G",   "80M",  "VHT",  "2T",   "138",
	"30",   "ETSI", "5G",   "80M",  "VHT",  "2T",   "138",  "63",   "MKK",
	"5G",   "80M",  "VHT",  "2T",   "138",  "63",   "FCC",  "5G",   "80M",
	"VHT",  "2T",   "155",  "30",   "ETSI", "5G",   "80M",  "VHT",  "2T",
	"155",  "63",   "MKK",  "5G",   "80M",  "VHT",  "2T",   "155",  "63"};

void odm_read_and_config_mp_8822b_txpwr_lmt_type3(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	u32 i = 0;
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
	u32	array_len = sizeof(array_mp_8822b_txpwr_lmt_type3)/sizeof(u8);
	u8	*array = (u8 *)array_mp_8822b_txpwr_lmt_type3;
#else
	u32 array_len = sizeof(array_mp_8822b_txpwr_lmt_type3) / sizeof(u8 *);
	u8 **array = (u8 **)array_mp_8822b_txpwr_lmt_type3;
#endif

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	struct _ADAPTER	*adapter = p_dm_odm->adapter;
	HAL_DATA_TYPE	*p_hal_data = GET_HAL_DATA(adapter);

	PlatformZeroMemory(p_hal_data->BufOfLinesPwrLmt, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	p_hal_data->nLinesReadPwrLmt = array_len/7;
#endif

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> odm_read_and_config_mp_8822b_txpwr_lmt_type3\n"));

	for (i = 0; i < array_len; i += 7) {
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
		u8	regulation = array[i];
		u8	band = array[i+1];
		u8	bandwidth = array[i+2];
		u8	rate = array[i+3];
		u8	rf_path = array[i+4];
		u8	chnl = array[i+5];
		u8	val = array[i+6];
#else
		u8 *regulation = array[i];
		u8 *band = array[i + 1];
		u8 *bandwidth = array[i + 2];
		u8 *rate = array[i + 3];
		u8 *rf_path = array[i + 4];
		u8 *chnl = array[i + 5];
		u8 *val = array[i + 6];
#endif

		odm_config_bb_txpwr_lmt_8822b(p_dm_odm, regulation, band,
					      bandwidth, rate, rf_path, chnl,
					      val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)p_hal_data->BufOfLinesPwrLmt[i/7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
		regulation, band, bandwidth, rate, rf_path, chnl, val);
#endif
	}
}

/******************************************************************************
*                           txpwr_lmt_type4.TXT
******************************************************************************/

const char *array_mp_8822b_txpwr_lmt_type4[] = {
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "01",   "38",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "01",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "01",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "02",
	"38",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "02",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "02",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "03",   "38",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"03",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "03",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "04",   "38",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "04",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "04",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "05",
	"38",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "05",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "05",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "06",   "38",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"06",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "06",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "07",   "38",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "07",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "07",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "08",
	"38",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "08",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "08",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "09",   "38",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"09",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "09",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "10",   "38",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "10",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "10",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "11",
	"38",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "11",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "11",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "12",   "32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"12",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "12",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "13",   "26",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "13",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "13",   "28",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "14",
	"63",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "14",   "63",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "14",   "32",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "01",   "32",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"01",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "01",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "02",   "36",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "02",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "02",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "03",
	"38",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "03",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "03",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "04",   "40",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"04",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "04",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "05",   "40",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "05",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "05",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "06",
	"40",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "06",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "06",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "07",   "40",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"07",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "07",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "08",   "40",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "08",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "08",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "09",
	"38",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "09",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "09",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "10",   "36",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"10",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "10",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "11",   "34",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "11",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "11",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "12",
	"28",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "12",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "12",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "13",   "20",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"13",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "13",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "14",   "63",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "14",   "63",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "14",   "63",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "01",
	"32",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "01",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "01",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "02",   "36",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"02",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "02",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "03",   "38",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "03",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "03",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "04",
	"40",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "04",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "04",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "05",   "40",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"05",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "05",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "06",   "40",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "06",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "06",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "07",
	"40",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "07",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "07",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "08",   "40",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"08",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "08",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "09",   "38",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "09",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "09",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "10",
	"36",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "10",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "10",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "11",   "32",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"11",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "11",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "12",   "26",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "12",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "12",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "13",
	"20",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "13",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "13",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "14",   "63",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"14",   "63",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "14",   "63",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "01",   "32",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "01",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "01",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "02",
	"34",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "02",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "02",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "03",   "36",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"03",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "03",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "04",   "36",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "04",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "04",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "05",
	"38",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "05",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "05",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "06",   "38",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"06",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "06",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "07",   "38",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "07",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "07",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "08",
	"36",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "08",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "08",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "09",   "36",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"09",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "09",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "10",   "34",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "10",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "10",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "11",
	"32",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "11",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "11",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "12",   "26",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"12",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "12",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "13",   "20",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "13",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "13",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "14",
	"63",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "14",   "63",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "14",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "01",   "63",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"01",   "63",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "01",   "63",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "02",   "63",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "02",   "63",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "02",   "63",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "03",
	"30",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "03",   "30",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "03",   "34",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "04",   "32",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"04",   "30",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "04",   "34",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "05",   "36",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "05",   "30",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "05",   "34",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "06",
	"38",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "06",   "30",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "06",   "34",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "07",   "36",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"07",   "30",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "07",   "34",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "08",   "32",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "08",   "30",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "08",   "34",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "09",
	"32",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "09",   "30",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "09",   "34",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "10",   "26",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"10",   "30",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "10",   "34",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "11",   "20",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "11",   "30",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "11",   "34",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "12",
	"63",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "12",   "63",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "12",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "13",   "63",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"13",   "63",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "13",   "63",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "14",   "63",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "14",   "63",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "14",   "63",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "01",
	"63",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "01",   "63",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "01",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "02",   "63",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"02",   "63",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "02",   "63",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "03",   "30",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "03",   "18",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "03",   "30",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "04",
	"30",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "04",   "18",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "04",   "30",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "05",   "32",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"05",   "18",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "05",   "30",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "06",   "34",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "06",   "18",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "06",   "30",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "07",
	"32",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "07",   "18",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "07",   "30",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "08",   "32",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"08",   "18",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "08",   "30",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "09",   "32",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "09",   "18",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "09",   "30",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "10",
	"26",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "10",   "18",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "10",   "30",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "11",   "20",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"11",   "18",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "11",   "30",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "12",   "63",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "12",   "63",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "12",   "63",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "13",
	"63",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "13",   "63",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "13",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "14",   "63",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"14",   "63",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "14",   "63",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "36",   "36",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "36",   "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "36",   "30",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "40",
	"38",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "40",   "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "40",   "30",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "44",   "38",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"44",   "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "44",   "30",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "48",   "38",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "48",   "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "48",   "30",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "52",
	"38",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "52",   "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "52",   "28",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "56",   "38",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"56",   "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "56",   "28",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "60",   "38",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "60",   "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "60",   "28",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "64",
	"34",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "64",   "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "64",   "28",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "100",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"100",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "100",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "104",  "38",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "104",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "104",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "108",
	"38",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "108",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "108",  "32",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "112",  "38",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"112",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "112",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "116",  "38",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "116",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "116",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "120",
	"38",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "120",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "120",  "32",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "124",  "38",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"124",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "124",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "128",  "38",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "128",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "128",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "132",
	"38",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "132",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "132",  "32",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "136",  "38",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"136",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "136",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "140",  "34",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "140",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "140",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "144",
	"34",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "144",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "144",  "63",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "149",  "38",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"149",  "63",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "149",  "63",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "153",  "38",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "153",  "63",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "153",  "63",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "157",
	"38",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "157",  "63",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "157",  "63",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "161",  "38",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"161",  "63",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "161",  "63",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "165",  "38",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "165",  "63",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "165",  "63",   "FCC",  "5G",   "20M",  "HT",   "1T",   "36",
	"36",   "ETSI", "5G",   "20M",  "HT",   "1T",   "36",   "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "36",   "28",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "40",   "38",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"40",   "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "40",   "28",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "44",   "38",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "44",   "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "44",   "28",   "FCC",  "5G",   "20M",  "HT",   "1T",   "48",
	"38",   "ETSI", "5G",   "20M",  "HT",   "1T",   "48",   "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "48",   "28",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "52",   "38",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"52",   "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "52",   "28",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "56",   "38",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "56",   "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "56",   "28",   "FCC",  "5G",   "20M",  "HT",   "1T",   "60",
	"38",   "ETSI", "5G",   "20M",  "HT",   "1T",   "60",   "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "60",   "28",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "64",   "34",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"64",   "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "64",   "28",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "100",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "100",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "100",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "104",
	"38",   "ETSI", "5G",   "20M",  "HT",   "1T",   "104",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "104",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "108",  "38",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"108",  "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "108",  "32",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "112",  "38",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "112",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "112",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "116",
	"38",   "ETSI", "5G",   "20M",  "HT",   "1T",   "116",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "116",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "120",  "38",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"120",  "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "120",  "32",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "124",  "38",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "124",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "124",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "128",
	"38",   "ETSI", "5G",   "20M",  "HT",   "1T",   "128",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "128",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "132",  "38",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"132",  "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "132",  "32",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "136",  "38",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "136",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "136",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "140",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "140",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "140",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "144",  "26",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"144",  "63",   "MKK",  "5G",   "20M",  "HT",   "1T",   "144",  "63",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "149",  "38",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "149",  "63",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "149",  "63",   "FCC",  "5G",   "20M",  "HT",   "1T",   "153",
	"38",   "ETSI", "5G",   "20M",  "HT",   "1T",   "153",  "63",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "153",  "63",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "157",  "38",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"157",  "63",   "MKK",  "5G",   "20M",  "HT",   "1T",   "157",  "63",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "161",  "38",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "161",  "63",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "161",  "63",   "FCC",  "5G",   "20M",  "HT",   "1T",   "165",
	"38",   "ETSI", "5G",   "20M",  "HT",   "1T",   "165",  "63",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "165",  "63",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "36",   "34",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"36",   "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "36",   "22",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "40",   "36",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "40",   "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "40",   "22",   "FCC",  "5G",   "20M",  "HT",   "2T",   "44",
	"36",   "ETSI", "5G",   "20M",  "HT",   "2T",   "44",   "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "44",   "22",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "48",   "36",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"48",   "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "48",   "22",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "52",   "36",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "52",   "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "52",   "22",   "FCC",  "5G",   "20M",  "HT",   "2T",   "56",
	"36",   "ETSI", "5G",   "20M",  "HT",   "2T",   "56",   "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "56",   "22",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "60",   "36",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"60",   "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "60",   "22",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "64",   "34",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "64",   "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "64",   "22",   "FCC",  "5G",   "20M",  "HT",   "2T",   "100",
	"32",   "ETSI", "5G",   "20M",  "HT",   "2T",   "100",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "100",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "104",  "36",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"104",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "104",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "108",  "38",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "108",  "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "108",  "30",   "FCC",  "5G",   "20M",  "HT",   "2T",   "112",
	"38",   "ETSI", "5G",   "20M",  "HT",   "2T",   "112",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "112",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "116",  "38",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"116",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "116",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "120",  "38",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "120",  "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "120",  "30",   "FCC",  "5G",   "20M",  "HT",   "2T",   "124",
	"38",   "ETSI", "5G",   "20M",  "HT",   "2T",   "124",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "124",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "128",  "38",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"128",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "128",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "132",  "38",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "132",  "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "132",  "30",   "FCC",  "5G",   "20M",  "HT",   "2T",   "136",
	"36",   "ETSI", "5G",   "20M",  "HT",   "2T",   "136",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "136",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "140",  "32",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"140",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "140",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "144",  "26",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "144",  "63",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "144",  "63",   "FCC",  "5G",   "20M",  "HT",   "2T",   "149",
	"38",   "ETSI", "5G",   "20M",  "HT",   "2T",   "149",  "63",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "149",  "63",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "153",  "38",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"153",  "63",   "MKK",  "5G",   "20M",  "HT",   "2T",   "153",  "63",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "157",  "38",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "157",  "63",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "157",  "63",   "FCC",  "5G",   "20M",  "HT",   "2T",   "161",
	"38",   "ETSI", "5G",   "20M",  "HT",   "2T",   "161",  "63",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "161",  "63",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "165",  "38",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"165",  "63",   "MKK",  "5G",   "20M",  "HT",   "2T",   "165",  "63",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "38",   "28",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "38",   "30",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "38",   "30",   "FCC",  "5G",   "40M",  "HT",   "1T",   "46",
	"36",   "ETSI", "5G",   "40M",  "HT",   "1T",   "46",   "30",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "46",   "30",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "54",   "36",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"54",   "30",   "MKK",  "5G",   "40M",  "HT",   "1T",   "54",   "30",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "62",   "30",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "62",   "30",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "62",   "30",   "FCC",  "5G",   "40M",  "HT",   "1T",   "102",
	"30",   "ETSI", "5G",   "40M",  "HT",   "1T",   "102",  "30",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "102",  "30",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "110",  "36",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"110",  "30",   "MKK",  "5G",   "40M",  "HT",   "1T",   "110",  "30",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "118",  "36",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "118",  "30",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "118",  "30",   "FCC",  "5G",   "40M",  "HT",   "1T",   "126",
	"36",   "ETSI", "5G",   "40M",  "HT",   "1T",   "126",  "30",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "126",  "30",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "134",  "36",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"134",  "30",   "MKK",  "5G",   "40M",  "HT",   "1T",   "134",  "30",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "142",  "30",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "142",  "63",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "142",  "63",   "FCC",  "5G",   "40M",  "HT",   "1T",   "151",
	"36",   "ETSI", "5G",   "40M",  "HT",   "1T",   "151",  "63",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "151",  "63",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "159",  "36",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"159",  "63",   "MKK",  "5G",   "40M",  "HT",   "1T",   "159",  "63",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "38",   "26",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "38",   "20",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "38",   "22",   "FCC",  "5G",   "40M",  "HT",   "2T",   "46",
	"36",   "ETSI", "5G",   "40M",  "HT",   "2T",   "46",   "20",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "46",   "22",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "54",   "36",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"54",   "20",   "MKK",  "5G",   "40M",  "HT",   "2T",   "54",   "22",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "62",   "28",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "62",   "20",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "62",   "22",   "FCC",  "5G",   "40M",  "HT",   "2T",   "102",
	"28",   "ETSI", "5G",   "40M",  "HT",   "2T",   "102",  "20",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "102",  "30",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "110",  "36",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"110",  "20",   "MKK",  "5G",   "40M",  "HT",   "2T",   "110",  "30",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "118",  "36",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "118",  "20",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "118",  "30",   "FCC",  "5G",   "40M",  "HT",   "2T",   "126",
	"36",   "ETSI", "5G",   "40M",  "HT",   "2T",   "126",  "20",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "126",  "30",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "134",  "36",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"134",  "20",   "MKK",  "5G",   "40M",  "HT",   "2T",   "134",  "30",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "142",  "30",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "142",  "63",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "142",  "63",   "FCC",  "5G",   "40M",  "HT",   "2T",   "151",
	"36",   "ETSI", "5G",   "40M",  "HT",   "2T",   "151",  "63",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "151",  "63",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "159",  "36",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"159",  "63",   "MKK",  "5G",   "40M",  "HT",   "2T",   "159",  "63",
	"FCC",  "5G",   "80M",  "VHT",  "1T",   "42",   "26",   "ETSI", "5G",
	"80M",  "VHT",  "1T",   "42",   "30",   "MKK",  "5G",   "80M",  "VHT",
	"1T",   "42",   "28",   "FCC",  "5G",   "80M",  "VHT",  "1T",   "58",
	"26",   "ETSI", "5G",   "80M",  "VHT",  "1T",   "58",   "30",   "MKK",
	"5G",   "80M",  "VHT",  "1T",   "58",   "28",   "FCC",  "5G",   "80M",
	"VHT",  "1T",   "106",  "26",   "ETSI", "5G",   "80M",  "VHT",  "1T",
	"106",  "30",   "MKK",  "5G",   "80M",  "VHT",  "1T",   "106",  "30",
	"FCC",  "5G",   "80M",  "VHT",  "1T",   "122",  "36",   "ETSI", "5G",
	"80M",  "VHT",  "1T",   "122",  "30",   "MKK",  "5G",   "80M",  "VHT",
	"1T",   "122",  "30",   "FCC",  "5G",   "80M",  "VHT",  "1T",   "138",
	"36",   "ETSI", "5G",   "80M",  "VHT",  "1T",   "138",  "63",   "MKK",
	"5G",   "80M",  "VHT",  "1T",   "138",  "63",   "FCC",  "5G",   "80M",
	"VHT",  "1T",   "155",  "36",   "ETSI", "5G",   "80M",  "VHT",  "1T",
	"155",  "63",   "MKK",  "5G",   "80M",  "VHT",  "1T",   "155",  "63",
	"FCC",  "5G",   "80M",  "VHT",  "2T",   "42",   "24",   "ETSI", "5G",
	"80M",  "VHT",  "2T",   "42",   "20",   "MKK",  "5G",   "80M",  "VHT",
	"2T",   "42",   "22",   "FCC",  "5G",   "80M",  "VHT",  "2T",   "58",
	"24",   "ETSI", "5G",   "80M",  "VHT",  "2T",   "58",   "20",   "MKK",
	"5G",   "80M",  "VHT",  "2T",   "58",   "22",   "FCC",  "5G",   "80M",
	"VHT",  "2T",   "106",  "26",   "ETSI", "5G",   "80M",  "VHT",  "2T",
	"106",  "20",   "MKK",  "5G",   "80M",  "VHT",  "2T",   "106",  "30",
	"FCC",  "5G",   "80M",  "VHT",  "2T",   "122",  "36",   "ETSI", "5G",
	"80M",  "VHT",  "2T",   "122",  "20",   "MKK",  "5G",   "80M",  "VHT",
	"2T",   "122",  "30",   "FCC",  "5G",   "80M",  "VHT",  "2T",   "138",
	"36",   "ETSI", "5G",   "80M",  "VHT",  "2T",   "138",  "63",   "MKK",
	"5G",   "80M",  "VHT",  "2T",   "138",  "63",   "FCC",  "5G",   "80M",
	"VHT",  "2T",   "155",  "36",   "ETSI", "5G",   "80M",  "VHT",  "2T",
	"155",  "63",   "MKK",  "5G",   "80M",  "VHT",  "2T",   "155",  "63"};

void odm_read_and_config_mp_8822b_txpwr_lmt_type4(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	u32 i = 0;
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
	u32	array_len = sizeof(array_mp_8822b_txpwr_lmt_type4)/sizeof(u8);
	u8	*array = (u8 *)array_mp_8822b_txpwr_lmt_type4;
#else
	u32 array_len = sizeof(array_mp_8822b_txpwr_lmt_type4) / sizeof(u8 *);
	u8 **array = (u8 **)array_mp_8822b_txpwr_lmt_type4;
#endif

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	struct _ADAPTER	*adapter = p_dm_odm->adapter;
	HAL_DATA_TYPE	*p_hal_data = GET_HAL_DATA(adapter);

	PlatformZeroMemory(p_hal_data->BufOfLinesPwrLmt, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	p_hal_data->nLinesReadPwrLmt = array_len/7;
#endif

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> odm_read_and_config_mp_8822b_txpwr_lmt_type4\n"));

	for (i = 0; i < array_len; i += 7) {
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
		u8	regulation = array[i];
		u8	band = array[i+1];
		u8	bandwidth = array[i+2];
		u8	rate = array[i+3];
		u8	rf_path = array[i+4];
		u8	chnl = array[i+5];
		u8	val = array[i+6];
#else
		u8 *regulation = array[i];
		u8 *band = array[i + 1];
		u8 *bandwidth = array[i + 2];
		u8 *rate = array[i + 3];
		u8 *rf_path = array[i + 4];
		u8 *chnl = array[i + 5];
		u8 *val = array[i + 6];
#endif

		odm_config_bb_txpwr_lmt_8822b(p_dm_odm, regulation, band,
					      bandwidth, rate, rf_path, chnl,
					      val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)p_hal_data->BufOfLinesPwrLmt[i/7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
		regulation, band, bandwidth, rate, rf_path, chnl, val);
#endif
	}
}

/******************************************************************************
*                           txpwr_lmt_type5.TXT
******************************************************************************/

const char *array_mp_8822b_txpwr_lmt_type5[] = {
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "01",   "32",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "01",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "01",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "02",
	"32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "02",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "02",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "03",   "32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"03",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "03",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "04",   "32",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "04",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "04",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "05",
	"32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "05",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "05",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "06",   "32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"06",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "06",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "07",   "32",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "07",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "07",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "08",
	"32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "08",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "08",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "09",   "32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"09",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "09",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "10",   "32",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "10",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "10",   "30",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "11",
	"32",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "11",   "28",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "11",   "30",   "FCC",  "2.4G", "20M",
	"CCK",  "1T",   "12",   "26",   "ETSI", "2.4G", "20M",  "CCK",  "1T",
	"12",   "28",   "MKK",  "2.4G", "20M",  "CCK",  "1T",   "12",   "30",
	"FCC",  "2.4G", "20M",  "CCK",  "1T",   "13",   "20",   "ETSI", "2.4G",
	"20M",  "CCK",  "1T",   "13",   "28",   "MKK",  "2.4G", "20M",  "CCK",
	"1T",   "13",   "28",   "FCC",  "2.4G", "20M",  "CCK",  "1T",   "14",
	"63",   "ETSI", "2.4G", "20M",  "CCK",  "1T",   "14",   "63",   "MKK",
	"2.4G", "20M",  "CCK",  "1T",   "14",   "32",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "01",   "26",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"01",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "01",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "02",   "30",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "02",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "02",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "03",
	"32",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "03",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "03",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "04",   "34",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"04",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "04",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "05",   "34",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "05",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "05",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "06",
	"34",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "06",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "06",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "07",   "34",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"07",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "07",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "08",   "34",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "08",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "08",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "09",
	"32",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "09",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "09",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "10",   "30",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"10",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "10",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "11",   "28",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "11",   "30",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "11",   "34",   "FCC",  "2.4G", "20M",  "OFDM", "1T",   "12",
	"22",   "ETSI", "2.4G", "20M",  "OFDM", "1T",   "12",   "30",   "MKK",
	"2.4G", "20M",  "OFDM", "1T",   "12",   "34",   "FCC",  "2.4G", "20M",
	"OFDM", "1T",   "13",   "14",   "ETSI", "2.4G", "20M",  "OFDM", "1T",
	"13",   "30",   "MKK",  "2.4G", "20M",  "OFDM", "1T",   "13",   "34",
	"FCC",  "2.4G", "20M",  "OFDM", "1T",   "14",   "63",   "ETSI", "2.4G",
	"20M",  "OFDM", "1T",   "14",   "63",   "MKK",  "2.4G", "20M",  "OFDM",
	"1T",   "14",   "63",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "01",
	"26",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "01",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "01",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "02",   "30",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"02",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "02",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "03",   "32",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "03",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "03",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "04",
	"34",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "04",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "04",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "05",   "34",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"05",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "05",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "06",   "34",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "06",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "06",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "07",
	"34",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "07",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "07",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "08",   "34",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"08",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "08",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "09",   "32",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "09",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "09",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "10",
	"30",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "10",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "10",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "11",   "26",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"11",   "30",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "11",   "34",
	"FCC",  "2.4G", "20M",  "HT",   "1T",   "12",   "20",   "ETSI", "2.4G",
	"20M",  "HT",   "1T",   "12",   "30",   "MKK",  "2.4G", "20M",  "HT",
	"1T",   "12",   "34",   "FCC",  "2.4G", "20M",  "HT",   "1T",   "13",
	"14",   "ETSI", "2.4G", "20M",  "HT",   "1T",   "13",   "30",   "MKK",
	"2.4G", "20M",  "HT",   "1T",   "13",   "34",   "FCC",  "2.4G", "20M",
	"HT",   "1T",   "14",   "63",   "ETSI", "2.4G", "20M",  "HT",   "1T",
	"14",   "63",   "MKK",  "2.4G", "20M",  "HT",   "1T",   "14",   "63",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "01",   "26",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "01",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "01",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "02",
	"28",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "02",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "02",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "03",   "30",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"03",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "03",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "04",   "30",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "04",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "04",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "05",
	"32",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "05",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "05",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "06",   "32",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"06",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "06",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "07",   "32",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "07",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "07",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "08",
	"30",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "08",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "08",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "09",   "30",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"09",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "09",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "10",   "28",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "10",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "10",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "11",
	"26",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "11",   "18",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "11",   "30",   "FCC",  "2.4G", "20M",
	"HT",   "2T",   "12",   "20",   "ETSI", "2.4G", "20M",  "HT",   "2T",
	"12",   "18",   "MKK",  "2.4G", "20M",  "HT",   "2T",   "12",   "30",
	"FCC",  "2.4G", "20M",  "HT",   "2T",   "13",   "14",   "ETSI", "2.4G",
	"20M",  "HT",   "2T",   "13",   "18",   "MKK",  "2.4G", "20M",  "HT",
	"2T",   "13",   "30",   "FCC",  "2.4G", "20M",  "HT",   "2T",   "14",
	"63",   "ETSI", "2.4G", "20M",  "HT",   "2T",   "14",   "63",   "MKK",
	"2.4G", "20M",  "HT",   "2T",   "14",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "01",   "63",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"01",   "63",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "01",   "63",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "02",   "63",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "02",   "63",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "02",   "63",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "03",
	"26",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "03",   "30",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "03",   "34",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "04",   "26",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"04",   "30",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "04",   "34",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "05",   "30",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "05",   "30",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "05",   "34",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "06",
	"32",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "06",   "30",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "06",   "34",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "07",   "30",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"07",   "30",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "07",   "34",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "08",   "26",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "08",   "30",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "08",   "34",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "09",
	"26",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "09",   "30",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "09",   "34",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "10",   "20",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"10",   "30",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "10",   "34",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "11",   "14",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "11",   "30",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "11",   "34",   "FCC",  "2.4G", "40M",  "HT",   "1T",   "12",
	"63",   "ETSI", "2.4G", "40M",  "HT",   "1T",   "12",   "63",   "MKK",
	"2.4G", "40M",  "HT",   "1T",   "12",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "1T",   "13",   "63",   "ETSI", "2.4G", "40M",  "HT",   "1T",
	"13",   "63",   "MKK",  "2.4G", "40M",  "HT",   "1T",   "13",   "63",
	"FCC",  "2.4G", "40M",  "HT",   "1T",   "14",   "63",   "ETSI", "2.4G",
	"40M",  "HT",   "1T",   "14",   "63",   "MKK",  "2.4G", "40M",  "HT",
	"1T",   "14",   "63",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "01",
	"63",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "01",   "63",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "01",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "02",   "63",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"02",   "63",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "02",   "63",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "03",   "24",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "03",   "18",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "03",   "30",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "04",
	"24",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "04",   "18",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "04",   "30",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "05",   "26",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"05",   "18",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "05",   "30",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "06",   "28",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "06",   "18",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "06",   "30",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "07",
	"26",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "07",   "18",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "07",   "30",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "08",   "26",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"08",   "18",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "08",   "30",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "09",   "26",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "09",   "18",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "09",   "30",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "10",
	"20",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "10",   "18",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "10",   "30",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "11",   "14",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"11",   "18",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "11",   "30",
	"FCC",  "2.4G", "40M",  "HT",   "2T",   "12",   "63",   "ETSI", "2.4G",
	"40M",  "HT",   "2T",   "12",   "63",   "MKK",  "2.4G", "40M",  "HT",
	"2T",   "12",   "63",   "FCC",  "2.4G", "40M",  "HT",   "2T",   "13",
	"63",   "ETSI", "2.4G", "40M",  "HT",   "2T",   "13",   "63",   "MKK",
	"2.4G", "40M",  "HT",   "2T",   "13",   "63",   "FCC",  "2.4G", "40M",
	"HT",   "2T",   "14",   "63",   "ETSI", "2.4G", "40M",  "HT",   "2T",
	"14",   "63",   "MKK",  "2.4G", "40M",  "HT",   "2T",   "14",   "63",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "36",   "30",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "36",   "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "36",   "30",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "40",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "40",   "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "40",   "30",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "44",   "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"44",   "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "44",   "30",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "48",   "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "48",   "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "48",   "30",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "52",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "52",   "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "52",   "28",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "56",   "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"56",   "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "56",   "28",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "60",   "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "60",   "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "60",   "28",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "64",
	"28",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "64",   "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "64",   "28",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "100",  "26",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"100",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "100",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "104",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "104",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "104",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "108",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "108",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "108",  "32",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "112",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"112",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "112",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "116",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "116",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "116",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "120",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "120",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "120",  "32",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "124",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"124",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "124",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "128",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "128",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "128",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "132",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "132",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "132",  "32",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "136",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"136",  "32",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "136",  "32",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "140",  "28",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "140",  "32",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "140",  "32",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "144",
	"28",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "144",  "32",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "144",  "63",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "149",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"149",  "63",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "149",  "63",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "153",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "153",  "63",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "153",  "63",   "FCC",  "5G",   "20M",  "OFDM", "1T",   "157",
	"32",   "ETSI", "5G",   "20M",  "OFDM", "1T",   "157",  "63",   "MKK",
	"5G",   "20M",  "OFDM", "1T",   "157",  "63",   "FCC",  "5G",   "20M",
	"OFDM", "1T",   "161",  "32",   "ETSI", "5G",   "20M",  "OFDM", "1T",
	"161",  "63",   "MKK",  "5G",   "20M",  "OFDM", "1T",   "161",  "63",
	"FCC",  "5G",   "20M",  "OFDM", "1T",   "165",  "32",   "ETSI", "5G",
	"20M",  "OFDM", "1T",   "165",  "63",   "MKK",  "5G",   "20M",  "OFDM",
	"1T",   "165",  "63",   "FCC",  "5G",   "20M",  "HT",   "1T",   "36",
	"30",   "ETSI", "5G",   "20M",  "HT",   "1T",   "36",   "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "36",   "28",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "40",   "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"40",   "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "40",   "28",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "44",   "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "44",   "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "44",   "28",   "FCC",  "5G",   "20M",  "HT",   "1T",   "48",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "48",   "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "48",   "28",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "52",   "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"52",   "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "52",   "28",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "56",   "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "56",   "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "56",   "28",   "FCC",  "5G",   "20M",  "HT",   "1T",   "60",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "60",   "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "60",   "28",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "64",   "28",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"64",   "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "64",   "28",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "100",  "26",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "100",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "100",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "104",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "104",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "104",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "108",  "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"108",  "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "108",  "32",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "112",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "112",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "112",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "116",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "116",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "116",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "120",  "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"120",  "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "120",  "32",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "124",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "124",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "124",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "128",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "128",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "128",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "132",  "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"132",  "32",   "MKK",  "5G",   "20M",  "HT",   "1T",   "132",  "32",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "136",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "136",  "32",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "136",  "32",   "FCC",  "5G",   "20M",  "HT",   "1T",   "140",
	"26",   "ETSI", "5G",   "20M",  "HT",   "1T",   "140",  "32",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "140",  "32",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "144",  "26",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"144",  "63",   "MKK",  "5G",   "20M",  "HT",   "1T",   "144",  "63",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "149",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "149",  "63",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "149",  "63",   "FCC",  "5G",   "20M",  "HT",   "1T",   "153",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "153",  "63",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "153",  "63",   "FCC",  "5G",   "20M",
	"HT",   "1T",   "157",  "32",   "ETSI", "5G",   "20M",  "HT",   "1T",
	"157",  "63",   "MKK",  "5G",   "20M",  "HT",   "1T",   "157",  "63",
	"FCC",  "5G",   "20M",  "HT",   "1T",   "161",  "32",   "ETSI", "5G",
	"20M",  "HT",   "1T",   "161",  "63",   "MKK",  "5G",   "20M",  "HT",
	"1T",   "161",  "63",   "FCC",  "5G",   "20M",  "HT",   "1T",   "165",
	"32",   "ETSI", "5G",   "20M",  "HT",   "1T",   "165",  "63",   "MKK",
	"5G",   "20M",  "HT",   "1T",   "165",  "63",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "36",   "28",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"36",   "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "36",   "22",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "40",   "30",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "40",   "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "40",   "22",   "FCC",  "5G",   "20M",  "HT",   "2T",   "44",
	"30",   "ETSI", "5G",   "20M",  "HT",   "2T",   "44",   "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "44",   "22",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "48",   "30",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"48",   "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "48",   "22",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "52",   "30",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "52",   "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "52",   "22",   "FCC",  "5G",   "20M",  "HT",   "2T",   "56",
	"30",   "ETSI", "5G",   "20M",  "HT",   "2T",   "56",   "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "56",   "22",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "60",   "30",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"60",   "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "60",   "22",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "64",   "28",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "64",   "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "64",   "22",   "FCC",  "5G",   "20M",  "HT",   "2T",   "100",
	"26",   "ETSI", "5G",   "20M",  "HT",   "2T",   "100",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "100",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "104",  "30",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"104",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "104",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "108",  "32",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "108",  "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "108",  "30",   "FCC",  "5G",   "20M",  "HT",   "2T",   "112",
	"32",   "ETSI", "5G",   "20M",  "HT",   "2T",   "112",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "112",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "116",  "32",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"116",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "116",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "120",  "32",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "120",  "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "120",  "30",   "FCC",  "5G",   "20M",  "HT",   "2T",   "124",
	"32",   "ETSI", "5G",   "20M",  "HT",   "2T",   "124",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "124",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "128",  "32",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"128",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "128",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "132",  "32",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "132",  "20",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "132",  "30",   "FCC",  "5G",   "20M",  "HT",   "2T",   "136",
	"30",   "ETSI", "5G",   "20M",  "HT",   "2T",   "136",  "20",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "136",  "30",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "140",  "26",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"140",  "20",   "MKK",  "5G",   "20M",  "HT",   "2T",   "140",  "30",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "144",  "26",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "144",  "63",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "144",  "63",   "FCC",  "5G",   "20M",  "HT",   "2T",   "149",
	"32",   "ETSI", "5G",   "20M",  "HT",   "2T",   "149",  "63",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "149",  "63",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "153",  "32",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"153",  "63",   "MKK",  "5G",   "20M",  "HT",   "2T",   "153",  "63",
	"FCC",  "5G",   "20M",  "HT",   "2T",   "157",  "32",   "ETSI", "5G",
	"20M",  "HT",   "2T",   "157",  "63",   "MKK",  "5G",   "20M",  "HT",
	"2T",   "157",  "63",   "FCC",  "5G",   "20M",  "HT",   "2T",   "161",
	"32",   "ETSI", "5G",   "20M",  "HT",   "2T",   "161",  "63",   "MKK",
	"5G",   "20M",  "HT",   "2T",   "161",  "63",   "FCC",  "5G",   "20M",
	"HT",   "2T",   "165",  "32",   "ETSI", "5G",   "20M",  "HT",   "2T",
	"165",  "63",   "MKK",  "5G",   "20M",  "HT",   "2T",   "165",  "63",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "38",   "22",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "38",   "30",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "38",   "30",   "FCC",  "5G",   "40M",  "HT",   "1T",   "46",
	"30",   "ETSI", "5G",   "40M",  "HT",   "1T",   "46",   "30",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "46",   "30",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "54",   "30",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"54",   "30",   "MKK",  "5G",   "40M",  "HT",   "1T",   "54",   "30",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "62",   "24",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "62",   "30",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "62",   "30",   "FCC",  "5G",   "40M",  "HT",   "1T",   "102",
	"24",   "ETSI", "5G",   "40M",  "HT",   "1T",   "102",  "30",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "102",  "30",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "110",  "30",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"110",  "30",   "MKK",  "5G",   "40M",  "HT",   "1T",   "110",  "30",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "118",  "30",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "118",  "30",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "118",  "30",   "FCC",  "5G",   "40M",  "HT",   "1T",   "126",
	"30",   "ETSI", "5G",   "40M",  "HT",   "1T",   "126",  "30",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "126",  "30",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "134",  "30",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"134",  "30",   "MKK",  "5G",   "40M",  "HT",   "1T",   "134",  "30",
	"FCC",  "5G",   "40M",  "HT",   "1T",   "142",  "30",   "ETSI", "5G",
	"40M",  "HT",   "1T",   "142",  "63",   "MKK",  "5G",   "40M",  "HT",
	"1T",   "142",  "63",   "FCC",  "5G",   "40M",  "HT",   "1T",   "151",
	"30",   "ETSI", "5G",   "40M",  "HT",   "1T",   "151",  "63",   "MKK",
	"5G",   "40M",  "HT",   "1T",   "151",  "63",   "FCC",  "5G",   "40M",
	"HT",   "1T",   "159",  "30",   "ETSI", "5G",   "40M",  "HT",   "1T",
	"159",  "63",   "MKK",  "5G",   "40M",  "HT",   "1T",   "159",  "63",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "38",   "20",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "38",   "20",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "38",   "22",   "FCC",  "5G",   "40M",  "HT",   "2T",   "46",
	"30",   "ETSI", "5G",   "40M",  "HT",   "2T",   "46",   "20",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "46",   "22",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "54",   "30",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"54",   "20",   "MKK",  "5G",   "40M",  "HT",   "2T",   "54",   "22",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "62",   "22",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "62",   "20",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "62",   "22",   "FCC",  "5G",   "40M",  "HT",   "2T",   "102",
	"22",   "ETSI", "5G",   "40M",  "HT",   "2T",   "102",  "20",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "102",  "30",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "110",  "30",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"110",  "20",   "MKK",  "5G",   "40M",  "HT",   "2T",   "110",  "30",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "118",  "30",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "118",  "20",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "118",  "30",   "FCC",  "5G",   "40M",  "HT",   "2T",   "126",
	"30",   "ETSI", "5G",   "40M",  "HT",   "2T",   "126",  "20",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "126",  "30",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "134",  "30",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"134",  "20",   "MKK",  "5G",   "40M",  "HT",   "2T",   "134",  "30",
	"FCC",  "5G",   "40M",  "HT",   "2T",   "142",  "30",   "ETSI", "5G",
	"40M",  "HT",   "2T",   "142",  "63",   "MKK",  "5G",   "40M",  "HT",
	"2T",   "142",  "63",   "FCC",  "5G",   "40M",  "HT",   "2T",   "151",
	"30",   "ETSI", "5G",   "40M",  "HT",   "2T",   "151",  "63",   "MKK",
	"5G",   "40M",  "HT",   "2T",   "151",  "63",   "FCC",  "5G",   "40M",
	"HT",   "2T",   "159",  "30",   "ETSI", "5G",   "40M",  "HT",   "2T",
	"159",  "63",   "MKK",  "5G",   "40M",  "HT",   "2T",   "159",  "63",
	"FCC",  "5G",   "80M",  "VHT",  "1T",   "42",   "20",   "ETSI", "5G",
	"80M",  "VHT",  "1T",   "42",   "30",   "MKK",  "5G",   "80M",  "VHT",
	"1T",   "42",   "28",   "FCC",  "5G",   "80M",  "VHT",  "1T",   "58",
	"20",   "ETSI", "5G",   "80M",  "VHT",  "1T",   "58",   "30",   "MKK",
	"5G",   "80M",  "VHT",  "1T",   "58",   "28",   "FCC",  "5G",   "80M",
	"VHT",  "1T",   "106",  "20",   "ETSI", "5G",   "80M",  "VHT",  "1T",
	"106",  "30",   "MKK",  "5G",   "80M",  "VHT",  "1T",   "106",  "30",
	"FCC",  "5G",   "80M",  "VHT",  "1T",   "122",  "30",   "ETSI", "5G",
	"80M",  "VHT",  "1T",   "122",  "30",   "MKK",  "5G",   "80M",  "VHT",
	"1T",   "122",  "30",   "FCC",  "5G",   "80M",  "VHT",  "1T",   "138",
	"30",   "ETSI", "5G",   "80M",  "VHT",  "1T",   "138",  "63",   "MKK",
	"5G",   "80M",  "VHT",  "1T",   "138",  "63",   "FCC",  "5G",   "80M",
	"VHT",  "1T",   "155",  "30",   "ETSI", "5G",   "80M",  "VHT",  "1T",
	"155",  "63",   "MKK",  "5G",   "80M",  "VHT",  "1T",   "155",  "63",
	"FCC",  "5G",   "80M",  "VHT",  "2T",   "42",   "18",   "ETSI", "5G",
	"80M",  "VHT",  "2T",   "42",   "20",   "MKK",  "5G",   "80M",  "VHT",
	"2T",   "42",   "22",   "FCC",  "5G",   "80M",  "VHT",  "2T",   "58",
	"18",   "ETSI", "5G",   "80M",  "VHT",  "2T",   "58",   "20",   "MKK",
	"5G",   "80M",  "VHT",  "2T",   "58",   "22",   "FCC",  "5G",   "80M",
	"VHT",  "2T",   "106",  "20",   "ETSI", "5G",   "80M",  "VHT",  "2T",
	"106",  "20",   "MKK",  "5G",   "80M",  "VHT",  "2T",   "106",  "30",
	"FCC",  "5G",   "80M",  "VHT",  "2T",   "122",  "30",   "ETSI", "5G",
	"80M",  "VHT",  "2T",   "122",  "20",   "MKK",  "5G",   "80M",  "VHT",
	"2T",   "122",  "30",   "FCC",  "5G",   "80M",  "VHT",  "2T",   "138",
	"30",   "ETSI", "5G",   "80M",  "VHT",  "2T",   "138",  "63",   "MKK",
	"5G",   "80M",  "VHT",  "2T",   "138",  "63",   "FCC",  "5G",   "80M",
	"VHT",  "2T",   "155",  "30",   "ETSI", "5G",   "80M",  "VHT",  "2T",
	"155",  "63",   "MKK",  "5G",   "80M",  "VHT",  "2T",   "155",  "63"};

void odm_read_and_config_mp_8822b_txpwr_lmt_type5(
	struct PHY_DM_STRUCT *p_dm_odm)
{
	u32 i = 0;
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
	u32	array_len = sizeof(array_mp_8822b_txpwr_lmt_type5)/sizeof(u8);
	u8	*array = (u8 *)array_mp_8822b_txpwr_lmt_type5;
#else
	u32 array_len = sizeof(array_mp_8822b_txpwr_lmt_type5) / sizeof(u8 *);
	u8 **array = (u8 **)array_mp_8822b_txpwr_lmt_type5;
#endif

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	struct _ADAPTER	*adapter = p_dm_odm->adapter;
	HAL_DATA_TYPE	*p_hal_data = GET_HAL_DATA(adapter);

	PlatformZeroMemory(p_hal_data->BufOfLinesPwrLmt, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	p_hal_data->nLinesReadPwrLmt = array_len/7;
#endif

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD,
		     ("===> odm_read_and_config_mp_8822b_txpwr_lmt_type5\n"));

	for (i = 0; i < array_len; i += 7) {
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
		u8	regulation = array[i];
		u8	band = array[i+1];
		u8	bandwidth = array[i+2];
		u8	rate = array[i+3];
		u8	rf_path = array[i+4];
		u8	chnl = array[i+5];
		u8	val = array[i+6];
#else
		u8 *regulation = array[i];
		u8 *band = array[i + 1];
		u8 *bandwidth = array[i + 2];
		u8 *rate = array[i + 3];
		u8 *rf_path = array[i + 4];
		u8 *chnl = array[i + 5];
		u8 *val = array[i + 6];
#endif

		odm_config_bb_txpwr_lmt_8822b(p_dm_odm, regulation, band,
					      bandwidth, rate, rf_path, chnl,
					      val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)p_hal_data->BufOfLinesPwrLmt[i/7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
		regulation, band, bandwidth, rate, rf_path, chnl, val);
#endif
	}
}

#endif /* end of HWIMG_SUPPORT*/

