#include "stm32f10x.h"

GPIO_InitTypeDef GPIO_InitStructure;


void RCC_Configuration(void);
void GPIO_Configuration(void);

void Delay(__IO uint32_t nCount);

int main(void)
{
  RCC_Configuration();   
  
  GPIO_Configuration();

  while (1)
  {
    if (!GPIO_ReadInputDataBit(GPIOE, GPIO_Pin_5))
    {
      GPIO_SetBits(GPIOC, GPIO_Pin_6);
    }
    else
    {
      GPIO_ResetBits(GPIOC, GPIO_Pin_6);
    }

    if (!GPIO_ReadInputDataBit(GPIOE, GPIO_Pin_4))
    {
      GPIO_SetBits(GPIOC, GPIO_Pin_7);
    }
    else
    {
      GPIO_ResetBits(GPIOC, GPIO_Pin_7);
    }

    if (!GPIO_ReadInputDataBit(GPIOE, GPIO_Pin_3))
    {
      GPIO_SetBits(GPIOD, GPIO_Pin_13);
    }
    else
    {
      GPIO_ResetBits(GPIOD, GPIO_Pin_13);
    }

    if (!GPIO_ReadInputDataBit(GPIOE, GPIO_Pin_2))
    {
      GPIO_SetBits(GPIOD, GPIO_Pin_6);
    }
    else
    {
      GPIO_ResetBits(GPIOD, GPIO_Pin_6);
    }
  }
}

void RCC_Configuration(void)
{
  SystemInit();
	
	RCC_APB2PeriphClockCmd( RCC_APB2Periph_USART1 |RCC_APB2Periph_GPIOA | RCC_APB2Periph_GPIOB |
                         RCC_APB2Periph_GPIOC | RCC_APB2Periph_GPIOD |
                         RCC_APB2Periph_GPIOE, ENABLE);
}

void GPIO_Configuration()
{
  //Кнопки
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_2 | GPIO_Pin_3 | GPIO_Pin_4 | GPIO_Pin_5;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPU; //вход с подтяжкой к питанию
  GPIO_Init(GPIOE, &GPIO_InitStructure);
 
  //светодиоды D1 и D2
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_6 | GPIO_Pin_7;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_Init(GPIOC, &GPIO_InitStructure);
 
  //светодиоды D3 и D4
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_6 | GPIO_Pin_13;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_Init(GPIOD, &GPIO_InitStructure);
}

void Delay(__IO uint32_t nCount)
{
  for(; nCount != 0; nCount--);
}
